/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.cli.tasks;

import java.io.File;
import java.io.PrintStream;
import org.hl7.fhir.utilities.TimeTracker;
import org.hl7.fhir.validation.cli.model.CliContext;
import org.hl7.fhir.validation.cli.tasks.StandaloneTask;
import org.hl7.fhir.validation.cli.utils.Params;
import org.hl7.fhir.validation.special.R4R5MapTester;

public class SpecialTask
extends StandaloneTask {
    @Override
    public String getName() {
        return "special";
    }

    @Override
    public String getDisplayName() {
        return "Special";
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    public boolean shouldExecuteTask(CliContext cliContext, String[] args) {
        return Params.hasParam(args, "-special");
    }

    @Override
    public void printHelp(PrintStream out) {
    }

    @Override
    public void executeTask(CliContext cliContext, String[] args, TimeTracker tt, TimeTracker.Session tts) throws Exception {
        String specialMode = Params.getParam(args, "-special");
        if ("r4r5tests".equals(specialMode)) {
            String target = Params.getParam(args, "-target");
            String source = Params.getParam(args, "-source");
            String filter = Params.getParam(args, "-filter");
            if (new File(target).exists()) {
                new R4R5MapTester().testMaps(target, source, filter);
            }
        } else {
            System.out.println("Unknown SpecialMode " + specialMode);
        }
    }
}

