/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation;

import java.io.File;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.terminologies.JurisdictionUtilities;
import org.hl7.fhir.utilities.TimeTracker;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.validation.Scanner;
import org.hl7.fhir.validation.ValidationEngine;
import org.hl7.fhir.validation.cli.model.CliContext;
import org.hl7.fhir.validation.cli.services.ComparisonService;
import org.hl7.fhir.validation.cli.services.ValidationService;
import org.hl7.fhir.validation.cli.utils.Display;
import org.hl7.fhir.validation.cli.utils.EngineMode;
import org.hl7.fhir.validation.cli.utils.Params;
import org.hl7.fhir.validation.testexecutor.TestExecutor;
import org.hl7.fhir.validation.testexecutor.TestExecutorParams;

public class ValidatorCli {
    public static final String HTTP_PROXY_HOST = "http.proxyHost";
    public static final String HTTP_PROXY_PORT = "http.proxyPort";
    public static final String HTTP_PROXY_USER = "http.proxyUser";
    public static final String HTTP_PROXY_PASS = "http.proxyPassword";
    public static final String JAVA_DISABLED_TUNNELING_SCHEMES = "jdk.http.auth.tunneling.disabledSchemes";
    public static final String JAVA_DISABLED_PROXY_SCHEMES = "jdk.http.auth.proxying.disabledSchemes";
    public static final String JAVA_USE_SYSTEM_PROXIES = "java.net.useSystemProxies";
    private static ValidationService validationService = new ValidationService();

    public static void main(String[] args) throws Exception {
        String[] p;
        TimeTracker tt = new TimeTracker();
        TimeTracker.Session tts = tt.start("Loading");
        args = ValidatorCli.preProcessArgs(args);
        Display.displayVersion();
        Display.displaySystemInfo();
        if (Params.hasParam(args, "-proxy")) {
            assert (Params.getParam(args, "-proxy") != null) : "PROXY arg passed in was NULL";
            p = Params.getParam(args, "-proxy").split(":");
            System.setProperty(HTTP_PROXY_HOST, p[0]);
            System.setProperty(HTTP_PROXY_PORT, p[1]);
        }
        if (Params.hasParam(args, "-auth")) {
            assert (Params.getParam(args, "-proxy") != null) : "Cannot set PROXY_AUTH without setting PROXY...";
            assert (Params.getParam(args, "-auth") != null) : "PROXY_AUTH arg passed in was NULL...";
            p = Params.getParam(args, "-auth").split(":");
            final String authUser = p[0];
            final String authPass = p[1];
            Authenticator.setDefault(new Authenticator(){

                @Override
                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(authUser, authPass.toCharArray());
                }
            });
            System.setProperty(HTTP_PROXY_USER, authUser);
            System.setProperty(HTTP_PROXY_PASS, authPass);
            System.setProperty(JAVA_USE_SYSTEM_PROXIES, "true");
            System.setProperty(JAVA_DISABLED_TUNNELING_SCHEMES, "");
            System.setProperty(JAVA_DISABLED_PROXY_SCHEMES, "");
        }
        CliContext cliContext = Params.loadCliContext(args);
        if (ValidatorCli.shouldDisplayHelpToUser(args)) {
            Display.displayHelpDetails();
        } else if (Params.hasParam(args, "-compare")) {
            if (ValidatorCli.destinationDirectoryValid(Params.getParam(args, "-dest"))) {
                ValidatorCli.doLeftRightComparison(args, cliContext, tt);
            }
        } else if (Params.hasParam(args, "-tests")) {
            ValidatorCli.parseTestParamsAndExecute(args);
        } else {
            Display.printCliArgumentsAndInfo(args);
            ValidatorCli.doValidation(tt, tts, cliContext);
        }
    }

    protected static void parseTestParamsAndExecute(String[] args) {
        String testModuleParam = Params.getParam(args, "-test-modules");
        String testClassnameFilter = Params.getParam(args, "-test-classname-filter");
        String testCasesDirectory = Params.getParam(args, "-tests");
        String txCacheDirectory = Params.getParam(args, "-txCache");
        assert (TestExecutorParams.isValidModuleParam(testModuleParam)) : "Invalid test module param: " + testModuleParam;
        String[] moduleNamesArg = TestExecutorParams.parseModuleParam(testModuleParam);
        assert (TestExecutorParams.isValidClassnameFilterParam(testClassnameFilter)) : "Invalid regex for test classname filter: " + testClassnameFilter;
        new TestExecutor(moduleNamesArg).executeTests(testClassnameFilter, txCacheDirectory, testCasesDirectory);
        System.exit(0);
    }

    private static String[] preProcessArgs(String[] args) {
        ArrayList<String> res = new ArrayList<String>();
        for (String a : args) {
            if (a.equals("-ips")) {
                res.add("-version");
                res.add("4.0");
                res.add("-ig");
                res.add("hl7.fhir.uv.ips#current");
                res.add("-profile");
                res.add("http://hl7.org/fhir/uv/ips/StructureDefinition/Bundle-uv-ips");
                continue;
            }
            if (a.startsWith("-ips$")) {
                res.add("-version");
                res.add("4.0");
                res.add("-ig");
                res.add("hl7.fhir.uv.ips#current$" + a.substring(5));
                res.add("-profile");
                res.add("http://hl7.org/fhir/uv/ips/StructureDefinition/Bundle-uv-ips");
                continue;
            }
            res.add(a);
        }
        String[] r = new String[res.size()];
        for (int i = 0; i < res.size(); ++i) {
            r[i] = (String)res.get(i);
        }
        return r;
    }

    private static boolean destinationDirectoryValid(String dest) {
        if (dest == null) {
            System.out.println("no -dest parameter provided");
            return false;
        }
        if (!new File(dest).isDirectory()) {
            System.out.println("Specified destination (-dest parameter) is not valid: \"" + dest + "\")");
            return false;
        }
        System.out.println("Valid destination directory provided: \"" + dest + "\")");
        return true;
    }

    private static boolean shouldDisplayHelpToUser(String[] args) {
        return args.length == 0 || Params.hasParam(args, "help") || Params.hasParam(args, "?") || Params.hasParam(args, "-?") || Params.hasParam(args, "/?");
    }

    private static void doLeftRightComparison(String[] args, CliContext cliContext, TimeTracker tt) throws Exception {
        Display.printCliArgumentsAndInfo(args);
        if (cliContext.getSv() == null) {
            cliContext.setSv(validationService.determineVersion(cliContext));
        }
        String v = VersionUtilities.getCurrentVersion((String)cliContext.getSv());
        String definitions = VersionUtilities.packageForVersion((String)v) + "#" + v;
        ValidationEngine validator = validationService.initializeValidator(cliContext, definitions, tt);
        validator.loadPackage("hl7.fhir.pubpack", null);
        ComparisonService.doLeftRightComparison(args, Params.getParam(args, "-dest"), validator);
    }

    private static void doValidation(TimeTracker tt, TimeTracker.Session tts, CliContext cliContext) throws Exception {
        if (cliContext.getSv() == null) {
            cliContext.setSv(validationService.determineVersion(cliContext));
        }
        System.out.println("  Jurisdiction: " + JurisdictionUtilities.displayJurisdiction((String)cliContext.getJurisdiction()));
        System.out.println("Loading");
        String definitions = "dev".equals(cliContext.getSv()) ? "hl7.fhir.r5.core#current" : VersionUtilities.packageForVersion((String)cliContext.getSv()) + "#" + VersionUtilities.getCurrentVersion((String)cliContext.getSv());
        ValidationEngine validator = validationService.initializeValidator(cliContext, definitions, tt);
        tts.end();
        switch (cliContext.getMode()) {
            case TRANSFORM: {
                validationService.transform(cliContext, validator);
                break;
            }
            case COMPILE: {
                validationService.compile(cliContext, validator);
                break;
            }
            case NARRATIVE: {
                validationService.generateNarrative(cliContext, validator);
                break;
            }
            case SNAPSHOT: {
                validationService.generateSnapshot(cliContext, validator);
                break;
            }
            case SPREADSHEET: {
                validationService.generateSpreadsheet(cliContext, validator);
                break;
            }
            case CONVERT: {
                validationService.convertSources(cliContext, validator);
                break;
            }
            case FHIRPATH: {
                validationService.evaluateFhirpath(cliContext, validator);
                break;
            }
            case VERSION: {
                validationService.transformVersion(cliContext, validator);
                break;
            }
            default: {
                for (String s : cliContext.getProfiles()) {
                    if (validator.getContext().hasResource(StructureDefinition.class, s) || validator.getContext().hasResource(ImplementationGuide.class, s)) continue;
                    System.out.println("  Fetch Profile from " + s);
                    validator.loadProfile(cliContext.getLocations().getOrDefault(s, s));
                }
                System.out.println("Validating");
                if (cliContext.getMode() == EngineMode.SCAN) {
                    Scanner validationScanner = new Scanner(validator.getContext(), validator.getValidator(null), validator.getIgLoader(), validator.getFhirPathEngine());
                    validationScanner.validateScan(cliContext.getOutput(), cliContext.getSources());
                    break;
                }
                validationService.validateSources(cliContext, validator);
            }
        }
        System.out.println("Done. " + tt.report() + ". Max Memory = " + Utilities.describeSize((long)Runtime.getRuntime().maxMemory()));
    }
}

