/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.type;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.ValueSetExpander;
import org.hl7.fhir.r5.utils.XVerExtensionManager;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;
import org.hl7.fhir.validation.BaseValidator;
import org.hl7.fhir.validation.TimeTracker;
import org.hl7.fhir.validation.instance.InstanceValidator;
import org.hl7.fhir.validation.instance.utils.NodeStack;

public class ValueSetValidator
extends BaseValidator {
    private InstanceValidator parent;

    public ValueSetValidator(IWorkerContext context, TimeTracker timeTracker, InstanceValidator parent, XVerExtensionManager xverManager, Coding jurisdiction) {
        super(context, xverManager);
        this.source = ValidationMessage.Source.InstanceValidator;
        this.timeTracker = timeTracker;
        this.parent = parent;
        this.jurisdiction = jurisdiction;
    }

    public void validateValueSet(List<ValidationMessage> errors, Element vs, NodeStack stack) {
        if (!VersionUtilities.isR2Ver((String)this.context.getVersion())) {
            List composes = vs.getChildrenByName("compose");
            int cc = 0;
            for (Element compose : composes) {
                this.validateValueSetCompose(errors, compose, stack.push(compose, cc, null, null), vs.getNamedChildValue("url"), "retired".equals(vs.getNamedChildValue("url")));
                ++cc;
            }
        }
        this.checkShareableValueSet(errors, vs, stack);
    }

    private void checkShareableValueSet(List<ValidationMessage> errors, Element vs, NodeStack stack) {
        if (this.parent.isForPublication()) {
            if (this.isHL7(vs)) {
                this.rule(errors, ValidationMessage.IssueType.REQUIRED, vs.line(), vs.col(), stack.getLiteralPath(), vs.hasChild("url"), "VALUESET_SHAREABLE_MISSING_HL7", "url");
                this.rule(errors, ValidationMessage.IssueType.REQUIRED, vs.line(), vs.col(), stack.getLiteralPath(), vs.hasChild("version"), "VALUESET_SHAREABLE_MISSING_HL7", "version");
                this.rule(errors, ValidationMessage.IssueType.REQUIRED, vs.line(), vs.col(), stack.getLiteralPath(), vs.hasChild("title"), "VALUESET_SHAREABLE_MISSING_HL7", "title");
                this.warning(errors, ValidationMessage.IssueType.REQUIRED, vs.line(), vs.col(), stack.getLiteralPath(), vs.hasChild("name"), "VALUESET_SHAREABLE_EXTRA_MISSING_HL7", "name");
                this.rule(errors, ValidationMessage.IssueType.REQUIRED, vs.line(), vs.col(), stack.getLiteralPath(), vs.hasChild("status"), "VALUESET_SHAREABLE_MISSING_HL7", "status");
                this.rule(errors, ValidationMessage.IssueType.REQUIRED, vs.line(), vs.col(), stack.getLiteralPath(), vs.hasChild("experimental"), "VALUESET_SHAREABLE_MISSING_HL7", "experimental");
                this.rule(errors, ValidationMessage.IssueType.REQUIRED, vs.line(), vs.col(), stack.getLiteralPath(), vs.hasChild("description"), "VALUESET_SHAREABLE_MISSING_HL7", "description");
            } else {
                this.warning(errors, ValidationMessage.IssueType.REQUIRED, vs.line(), vs.col(), stack.getLiteralPath(), vs.hasChild("url"), "VALUESET_SHAREABLE_MISSING", "url");
                this.warning(errors, ValidationMessage.IssueType.REQUIRED, vs.line(), vs.col(), stack.getLiteralPath(), vs.hasChild("version"), "VALUESET_SHAREABLE_MISSING", "version");
                this.warning(errors, ValidationMessage.IssueType.REQUIRED, vs.line(), vs.col(), stack.getLiteralPath(), vs.hasChild("title"), "VALUESET_SHAREABLE_MISSING", "title");
                this.warning(errors, ValidationMessage.IssueType.REQUIRED, vs.line(), vs.col(), stack.getLiteralPath(), vs.hasChild("name"), "VALUESET_SHAREABLE_EXTRA_MISSING", "name");
                this.warning(errors, ValidationMessage.IssueType.REQUIRED, vs.line(), vs.col(), stack.getLiteralPath(), vs.hasChild("status"), "VALUESET_SHAREABLE_MISSING", "status");
                this.warning(errors, ValidationMessage.IssueType.REQUIRED, vs.line(), vs.col(), stack.getLiteralPath(), vs.hasChild("experimental"), "VALUESET_SHAREABLE_MISSING", "experimental");
                this.warning(errors, ValidationMessage.IssueType.REQUIRED, vs.line(), vs.col(), stack.getLiteralPath(), vs.hasChild("description"), "VALUESET_SHAREABLE_MISSING", "description");
            }
        }
    }

    private void validateValueSetCompose(List<ValidationMessage> errors, Element compose, NodeStack stack, String vsid, boolean retired) {
        List includes = compose.getChildrenByName("include");
        int ci = 0;
        for (Element include : includes) {
            this.validateValueSetInclude(errors, include, stack.push(include, ci, null, null), vsid, retired);
            ++ci;
        }
        List excludes = compose.getChildrenByName("exclude");
        int ce = 0;
        for (Element exclude : excludes) {
            this.validateValueSetInclude(errors, exclude, stack.push(exclude, ce, null, null), vsid, retired);
            ++ce;
        }
    }

    private void validateValueSetInclude(List<ValidationMessage> errors, Element include, NodeStack stack, String vsid, boolean retired) {
        String system = include.getChildValue("system");
        String version = include.getChildValue("version");
        List valuesets = include.getChildrenByName("valueSet");
        int i = 0;
        for (Element ve : valuesets) {
            String v = ve.getValue();
            ValueSet vs = (ValueSet)this.context.fetchResource(ValueSet.class, v);
            if (vs == null) {
                NodeStack ns = stack.push(ve, i, ve.getProperty().getDefinition(), ve.getProperty().getDefinition());
                Resource rs = this.context.fetchResource(Resource.class, v);
                if (rs != null) {
                    this.warning(errors, ValidationMessage.IssueType.BUSINESSRULE, ns.getLiteralPath(), false, "VALUESET_REFERENCE_INVALID_TYPE", v, rs.fhirType());
                } else {
                    this.warning(errors, ValidationMessage.IssueType.BUSINESSRULE, ns.getLiteralPath(), false, "VALUESET_REFERENCE_UNKNOWN", v);
                }
            }
            ++i;
        }
        if (valuesets.size() > 1) {
            this.warning(errors, ValidationMessage.IssueType.INFORMATIONAL, stack.getLiteralPath(), false, "VALUESET_IMPORT_UNION_INTERSECTION", new Object[0]);
        }
        List concepts = include.getChildrenByName("concept");
        List filters = include.getChildrenByName("filter");
        if (!Utilities.noString((String)system)) {
            boolean systemOk = true;
            int cc = 0;
            ArrayList<VSCodingValidationRequest> batch = new ArrayList<VSCodingValidationRequest>();
            boolean first = true;
            for (Element concept : concepts) {
                if (first) {
                    systemOk = this.validateValueSetIncludeConcept(errors, concept, stack.push(concept, cc, null, null), system, version);
                    first = false;
                } else if (systemOk) {
                    batch.add(this.prepareValidateValueSetIncludeConcept(errors, concept, stack.push(concept, cc, null, null), system, version));
                }
                ++cc;
            }
            if (this.parent.isValidateValueSetCodesOnTxServer() && batch.size() > 0) {
                long t = System.currentTimeMillis();
                if (this.parent.isDebug()) {
                    System.out.println("  : Validate " + batch.size() + " codes from " + system + " for " + vsid);
                }
                this.context.validateCodeBatch(ValidationOptions.defaults(), batch, null);
                if (this.parent.isDebug()) {
                    System.out.println("  :   .. " + (System.currentTimeMillis() - t) + "ms");
                }
                for (VSCodingValidationRequest cv : batch) {
                    if (version == null) {
                        this.warningOrHint(errors, ValidationMessage.IssueType.BUSINESSRULE, cv.getStack().getLiteralPath(), cv.getResult().isOk(), !retired, "VALUESET_INCLUDE_INVALID_CONCEPT_CODE", system, cv.getCoding().getCode());
                        continue;
                    }
                    this.warningOrHint(errors, ValidationMessage.IssueType.BUSINESSRULE, cv.getStack().getLiteralPath(), cv.getResult().isOk(), !retired, "VALUESET_INCLUDE_INVALID_CONCEPT_CODE_VER", system, version, cv.getCoding().getCode());
                }
            }
            int cf = 0;
            for (Element filter : filters) {
                if (systemOk && !this.validateValueSetIncludeFilter(errors, include, stack.push(filter, cf, null, null), system, version)) {
                    systemOk = false;
                }
                ++cf;
            }
            this.warning(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), systemOk, version == null ? "VALUESET_UNC_SYSTEM_WARNING" : "VALUESET_UNC_SYSTEM_WARNING_VER", new Object[0]);
        } else {
            this.warning(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), filters.size() == 0 && concepts.size() == 0, "VALUESET_NO_SYSTEM_WARNING", new Object[0]);
        }
    }

    private boolean validateValueSetIncludeConcept(List<ValidationMessage> errors, Element concept, NodeStack stack, String system, String version) {
        String code = concept.getChildValue("code");
        if (version == null) {
            IWorkerContext.ValidationResult vv = this.context.validateCode(ValidationOptions.defaults(), new Coding(system, code, null), null);
            if (vv.getErrorClass() == ValueSetExpander.TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED) {
                return false;
            }
            boolean ok = vv.isOk();
            this.warning(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), ok, "VALUESET_INCLUDE_INVALID_CONCEPT_CODE", system, code);
        } else {
            IWorkerContext.ValidationResult vv = this.context.validateCode(ValidationOptions.defaults(), new Coding(system, code, null).setVersion(version), null);
            if (vv.getErrorClass() == ValueSetExpander.TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED) {
                return false;
            }
            boolean ok = vv.isOk();
            this.warning(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), ok, "VALUESET_INCLUDE_INVALID_CONCEPT_CODE_VER", system, version, code);
        }
        return true;
    }

    private VSCodingValidationRequest prepareValidateValueSetIncludeConcept(List<ValidationMessage> errors, Element concept, NodeStack stack, String system, String version) {
        String code = concept.getChildValue("code");
        Coding c = new Coding(system, code, null);
        if (version != null) {
            c.setVersion(version);
        }
        return new VSCodingValidationRequest(stack, c);
    }

    private boolean validateValueSetIncludeFilter(List<ValidationMessage> errors, Element include, NodeStack push, String system, String version) {
        return true;
    }

    public class VSCodingValidationRequest
    extends IWorkerContext.CodingValidationRequest {
        private NodeStack stack;

        public VSCodingValidationRequest(NodeStack stack, Coding code) {
            super(code);
            this.stack = stack;
        }

        public NodeStack getStack() {
            return this.stack;
        }
    }
}

