/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.type;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_10_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_14_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_30_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.conformance.ProfileUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.ExpressionNode;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.utils.FHIRPathEngine;
import org.hl7.fhir.r5.utils.XVerExtensionManager;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;
import org.hl7.fhir.validation.BaseValidator;
import org.hl7.fhir.validation.TimeTracker;
import org.hl7.fhir.validation.instance.utils.NodeStack;

public class StructureDefinitionValidator
extends BaseValidator {
    private FHIRPathEngine fpe;
    private boolean wantCheckSnapshotUnchanged;

    public StructureDefinitionValidator(IWorkerContext context, TimeTracker timeTracker, FHIRPathEngine fpe, boolean wantCheckSnapshotUnchanged, XVerExtensionManager xverManager, Coding jurisdiction) {
        super(context, xverManager);
        this.source = ValidationMessage.Source.InstanceValidator;
        this.fpe = fpe;
        this.timeTracker = timeTracker;
        this.wantCheckSnapshotUnchanged = wantCheckSnapshotUnchanged;
        this.jurisdiction = jurisdiction;
    }

    public void validateStructureDefinition(List<ValidationMessage> errors, Element src, NodeStack stack) {
        StructureDefinition sd = null;
        try {
            sd = this.loadAsSD(src);
            List snapshot = sd.getSnapshot().getElement();
            sd.setSnapshot(null);
            StructureDefinition base = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition());
            if (this.warning(errors, ValidationMessage.IssueType.NOTFOUND, stack.getLiteralPath(), base != null, "Unable_to_find_base__for_", sd.getBaseDefinition(), "StructureDefinition, so can't check the differential")) {
                if (this.rule(errors, ValidationMessage.IssueType.NOTFOUND, stack.getLiteralPath(), sd.hasDerivation(), "SD_MUST_HAVE_DERIVATION", sd.getUrl()) && sd.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT) {
                    ArrayList msgs = new ArrayList();
                    ProfileUtilities pu = new ProfileUtilities(this.context, msgs, null);
                    pu.setXver(this.xverManager);
                    pu.generateSnapshot(base, sd, sd.getUrl(), "http://hl7.org/fhir/R4/", sd.getName());
                    if (msgs.size() > 0) {
                        for (ValidationMessage msg : msgs) {
                            String loc = msg.getLocation();
                            if (loc.contains("#")) {
                                msg.setLocation(stack.getLiteralPath() + ".differential.element.where(path = '" + loc.substring(loc.indexOf("#") + 1) + "')");
                            } else {
                                msg.setLocation(stack.getLiteralPath());
                            }
                            errors.add(msg);
                        }
                    }
                    if (!snapshot.isEmpty() && this.wantCheckSnapshotUnchanged) {
                        int was = snapshot.size();
                        int is = sd.getSnapshot().getElement().size();
                        this.rule(errors, ValidationMessage.IssueType.NOTFOUND, stack.getLiteralPath(), was == is, "SNAPSHOT_EXISTING_PROBLEM", was, is);
                    }
                }
                if ("constraint".equals(src.getChildValue("derivation"))) {
                    this.rule(errors, ValidationMessage.IssueType.NOTFOUND, stack.getLiteralPath(), base.getKindElement().primitiveValue().equals(src.getChildValue("kind")), "SD_DERIVATION_KIND_MISMATCH", base.getKindElement().primitiveValue(), src.getChildValue("kind"));
                }
            }
        }
        catch (IOException | FHIRException e) {
            this.rule(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), false, "ERROR_GENERATING_SNAPSHOT", e.getMessage());
        }
        List differentials = src.getChildrenByName("differential");
        List snapshots = src.getChildrenByName("snapshot");
        for (Element differential : differentials) {
            this.validateElementList(errors, differential, stack.push(differential, -1, null, null), false, snapshots.size() > 0, sd);
        }
        for (Element snapshot : snapshots) {
            this.validateElementList(errors, snapshot, stack.push(snapshot, -1, null, null), true, true, sd);
        }
    }

    private void validateElementList(List<ValidationMessage> errors, Element elementList, NodeStack stack, boolean snapshot, boolean hasSnapshot, StructureDefinition sd) {
        List elements = elementList.getChildrenByName("element");
        int cc = 0;
        for (Element element : elements) {
            this.validateElementDefinition(errors, element, stack.push(element, cc, null, null), snapshot, hasSnapshot, sd);
            ++cc;
        }
    }

    private void validateElementDefinition(List<ValidationMessage> errors, Element element, NodeStack stack, boolean snapshot, boolean hasSnapshot, StructureDefinition sd) {
        boolean typeMustSupport = false;
        List types = element.getChildrenByName("type");
        HashSet<String> typeCodes = new HashSet<String>();
        HashSet<String> characteristics = new HashSet<String>();
        for (Element type : types) {
            if (this.hasMustSupportExtension(type)) {
                typeMustSupport = true;
            }
            String tc = type.getChildValue("code");
            if (type.hasExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type")) {
                tc = type.getExtensionValue("http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type").primitiveValue();
            }
            if (Utilities.noString((String)tc) && type.hasChild("code") && type.getNamedChild("code").hasExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-json-type")) {
                tc = "*";
            }
            typeCodes.add(tc);
            HashSet<String> tcharacteristics = new HashSet<String>();
            this.addCharacteristics(tcharacteristics, tc);
            characteristics.addAll(tcharacteristics);
            if (type.hasChildren("targetProfile")) {
                this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), tcharacteristics.contains("has-target"), "SD_ILLEGAL_CHARACTERISTICS", "targetProfile");
            }
            if (!snapshot && sd == null) continue;
            this.validateElementType(errors, type, stack.push(type, -1, null, null), sd, element.getChildValue("path"));
        }
        if (typeMustSupport) {
            if (snapshot) {
                this.rule(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), "true".equals(element.getChildValue("mustSupport")), "SD_NESTED_MUST_SUPPORT_SNAPSHOT", element.getNamedChildValue("path"));
            } else {
                this.hint(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), hasSnapshot || "true".equals(element.getChildValue("mustSupport")), "SD_NESTED_MUST_SUPPORT_DIFF", element.getNamedChildValue("path"));
            }
        }
        if (element.hasChild("binding")) {
            if (!typeCodes.isEmpty()) {
                this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), characteristics.contains("can-bind"), "SD_ILLEGAL_CHARACTERISTICS", "Binding");
            }
            Element binding = element.getNamedChild("binding");
            this.validateBinding(errors, binding, stack.push(binding, -1, null, null), typeCodes, snapshot, element.getNamedChildValue("path"));
        }
        if (!typeCodes.isEmpty()) {
            if (element.hasChild("maxLength")) {
                this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), characteristics.contains("has-length"), "SD_ILLEGAL_CHARACTERISTICS", "MaxLength");
            }
            if (element.hasExtension("http://hl7.org/fhir/StructureDefinition/minLength")) {
                this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), characteristics.contains("has-length"), "SD_ILLEGAL_CHARACTERISTICS", "MinLength Extension");
            }
            if (element.hasChild("minValue")) {
                this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), characteristics.contains("has-range"), "SD_ILLEGAL_CHARACTERISTICS", "MinValue");
            }
            if (element.hasChild("maxValue")) {
                this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), characteristics.contains("has-range"), "SD_ILLEGAL_CHARACTERISTICS", "MaxValue");
            }
            if (element.hasExtension("http://hl7.org/fhir/StructureDefinition/maxDecimalPlaces")) {
                this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), characteristics.contains("is-continuous"), "SD_ILLEGAL_CHARACTERISTICS", "Max Decimal Places Extension");
            }
            if (element.hasExtension("http://hl7.org/fhir/StructureDefinition/maxSize")) {
                this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), characteristics.contains("has-size"), "SD_ILLEGAL_CHARACTERISTICS", "Max Size");
            }
        }
        if (snapshot && element.getIdBase() != null && element.getIdBase().contains(".") && this.rule(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), !typeCodes.isEmpty() || element.hasChild("contentReference"), "SD_NO_TYPES_OR_CONTENTREF", element.getIdBase())) {
            boolean repeating = !Utilities.existsInList((String)element.getChildValue("max"), (String[])new String[]{"0", "1"});
            Element v = element.getNamedChild("defaultValue");
            if (v != null) {
                this.rule(errors, ValidationMessage.IssueType.EXCEPTION, stack.push(v, -1, null, null).getLiteralPath(), typeCodes.contains(v.fhirType()), "SD_VALUE_TYPE_IILEGAL", element.getIdBase(), "defaultValue", v.fhirType(), typeCodes);
            }
            if ((v = element.getNamedChild("fixed")) != null) {
                this.rule(errors, ValidationMessage.IssueType.EXCEPTION, stack.push(v, -1, null, null).getLiteralPath(), typeCodes.contains(v.fhirType()), "SD_VALUE_TYPE_IILEGAL", element.getIdBase(), "fixed", v.fhirType(), typeCodes);
                this.hint(errors, ValidationMessage.IssueType.EXCEPTION, stack.push(v, -1, null, null).getLiteralPath(), !repeating, "SD_VALUE_TYPE_REPEAT_HINT", element.getIdBase(), "fixed");
                if (this.isPrimitiveType(v.fhirType())) {
                    this.warning(errors, ValidationMessage.IssueType.EXCEPTION, stack.push(v, -1, null, null).getLiteralPath(), !repeating, "SD_VALUE_TYPE_REPEAT_WARNING_DOTNET", element.getIdBase(), "fixed");
                } else {
                    this.warning(errors, ValidationMessage.IssueType.EXCEPTION, stack.push(v, -1, null, null).getLiteralPath(), false, "SD_VALUE_COMPLEX_FIXED", v.fhirType());
                }
            }
            if ((v = element.getNamedChild("pattern")) != null) {
                this.rule(errors, ValidationMessage.IssueType.EXCEPTION, stack.push(v, -1, null, null).getLiteralPath(), typeCodes.contains(v.fhirType()), "SD_VALUE_TYPE_IILEGAL", element.getIdBase(), "pattern", v.fhirType(), typeCodes);
                this.hint(errors, ValidationMessage.IssueType.EXCEPTION, stack.push(v, -1, null, null).getLiteralPath(), !repeating, "SD_VALUE_TYPE_REPEAT_HINT", element.getIdBase(), "pattern");
                if (this.isPrimitiveType(v.fhirType())) {
                    this.warning(errors, ValidationMessage.IssueType.EXCEPTION, stack.push(v, -1, null, null).getLiteralPath(), !repeating, "SD_VALUE_TYPE_REPEAT_WARNING_DOTNET", element.getIdBase(), "pattern");
                }
            }
        }
    }

    private boolean addCharacteristics(Set<String> set, String tc) {
        switch (tc) {
            case "boolean": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "integer": {
                return this.addCharacteristicsForType(set, "has-range", "has-length");
            }
            case "integer64": {
                return this.addCharacteristicsForType(set, "has-range", "has-length");
            }
            case "decimal": {
                return this.addCharacteristicsForType(set, "has-range", "is-continuous", "has-length");
            }
            case "base64Binary": {
                return this.addCharacteristicsForType(set, "has-size");
            }
            case "instant": {
                return this.addCharacteristicsForType(set, "has-range", "is-continuous", "has-length");
            }
            case "string": {
                return this.addCharacteristicsForType(set, "has-length", "do-translations");
            }
            case "uri": {
                return this.addCharacteristicsForType(set, "has-length", "can-bind");
            }
            case "date": {
                return this.addCharacteristicsForType(set, "has-range", "has-length");
            }
            case "dateTime": {
                return this.addCharacteristicsForType(set, "has-range", "is-continuous", "has-length");
            }
            case "time": {
                return this.addCharacteristicsForType(set, "has-range", "is-continuous", "has-length");
            }
            case "canonical": {
                return this.addCharacteristicsForType(set, "has-target", "has-length");
            }
            case "code": {
                return this.addCharacteristicsForType(set, "has-length", "can-bind");
            }
            case "id": {
                return this.addCharacteristicsForType(set, "has-length");
            }
            case "markdown": {
                return this.addCharacteristicsForType(set, "do-translations");
            }
            case "oid": {
                return this.addCharacteristicsForType(set, "has-length", "can-bind");
            }
            case "positiveInt": {
                return this.addCharacteristicsForType(set, "has-range", "has-length");
            }
            case "unsignedInt": {
                return this.addCharacteristicsForType(set, "has-range", "has-length");
            }
            case "url": {
                return this.addCharacteristicsForType(set, "has-length", "can-bind");
            }
            case "uuid": {
                return this.addCharacteristicsForType(set, "has-length", "can-bind");
            }
            case "Address": {
                return this.addCharacteristicsForType(set, "do-translations");
            }
            case "Age": {
                return this.addCharacteristicsForType(set, "has-range", "is-continuous");
            }
            case "Annotation": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Attachment": {
                return this.addCharacteristicsForType(set, "has-size", "do-translations");
            }
            case "CodeableConcept": {
                return this.addCharacteristicsForType(set, "can-bind", "do-translations");
            }
            case "CodeableReference": {
                return this.addCharacteristicsForType(set, "has-target", "can-bind", "do-translations");
            }
            case "Coding": {
                return this.addCharacteristicsForType(set, "can-bind", "do-translations");
            }
            case "ContactPoint": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Count": {
                return this.addCharacteristicsForType(set, "has-range");
            }
            case "Distance": {
                return this.addCharacteristicsForType(set, "has-range", "is-continuous");
            }
            case "Duration": {
                return this.addCharacteristicsForType(set, "has-range", "is-continuous");
            }
            case "HumanName": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Identifier": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Money": {
                return this.addCharacteristicsForType(set, "has-range", "is-continuous");
            }
            case "Period": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Quantity": {
                return this.addCharacteristicsForType(set, "has-range", "is-continuous", "can-bind", "has-units");
            }
            case "Range": {
                return this.addCharacteristicsForType(set, "has-units");
            }
            case "Ratio": {
                return this.addCharacteristicsForType(set, "has-units");
            }
            case "RatioRange": {
                return this.addCharacteristicsForType(set, "has-units");
            }
            case "Reference": {
                return this.addCharacteristicsForType(set, "has-target");
            }
            case "SampledData": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Signature": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Timing": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "ContactDetail": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Contributor": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "DataRequirement": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Expression": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "ParameterDefinition": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "RelatedArtifact": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "TriggerDefinition": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "UsageContext": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Dosage": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Meta": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Resource": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Extension": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Narrative": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Element": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "BackboneElement": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
        }
        throw new Error("Unhandled data type in addCharacterstics: " + tc);
    }

    private boolean addCharacteristicsForType(Set<String> set, String ... cl) {
        for (String c : cl) {
            set.add(c);
        }
        return true;
    }

    private boolean isPrimitiveType(String fhirType) {
        StructureDefinition sd = this.context.fetchTypeDefinition(fhirType);
        return sd != null && sd.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE;
    }

    private String boundType(Set<String> typeCodes) {
        for (String tc : typeCodes) {
            if (!Utilities.existsInList((String)tc, (String[])new String[]{"code", "Coding", "CodeableConcept", "Quantity", "CodeableReference"})) continue;
            return tc;
        }
        return null;
    }

    private String bindableType(Set<String> typeCodes) {
        String ret = this.boundType(typeCodes);
        if (ret != null) {
            return ret;
        }
        for (String tc : typeCodes) {
            if (Utilities.existsInList((String)tc, (String[])new String[]{"string", "uri", "CodeableConcept", "Quantity", "CodeableReference"})) {
                return tc;
            }
            StructureDefinition sd = this.context.fetchTypeDefinition(tc);
            if (sd == null || !sd.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-binding-method")) continue;
            return tc;
        }
        return null;
    }

    private void validateBinding(List<ValidationMessage> errors, Element binding, NodeStack stack, Set<String> typeCodes, boolean snapshot, String path) {
        this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), !snapshot || this.bindableType(typeCodes) != null, "SD_ED_BIND_NO_BINDABLE", path, typeCodes.toString());
        if (!snapshot) {
            Set<String> bindables = this.getListofBindableTypes(typeCodes);
            this.hint(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), bindables.size() <= 1, "SD_ED_BIND_MULTIPLE_TYPES", path, typeCodes.toString());
        }
        if (binding.hasChild("valueSet")) {
            Element valueSet = binding.getNamedChild("valueSet");
            String ref = valueSet.hasPrimitiveValue() ? valueSet.primitiveValue() : valueSet.getNamedChildValue("reference");
            if (this.warning(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), !snapshot || ref != null, "SD_ED_SHOULD_BIND_WITH_VS", path)) {
                Resource vs = this.context.fetchResource(Resource.class, ref);
                if (this.warning(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), vs != null || this.serverSupportsValueSet(ref), "SD_ED_BIND_UNKNOWN_VS", path, ref) && vs != null) {
                    this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), vs instanceof ValueSet, "SD_ED_BIND_NOT_VS", path, ref, vs.fhirType());
                }
            }
        }
    }

    private Set<String> getListofBindableTypes(Set<String> types) {
        HashSet<String> res = new HashSet<String>();
        for (String s : types) {
            if (!Utilities.existsInList((String)s, (String[])new String[]{"code", "string", "url", "uri", "Coding", "CodeableConcept", "Quantity", "CodeableReference"})) continue;
            res.add(s);
        }
        return res;
    }

    private boolean serverSupportsValueSet(String ref) {
        IWorkerContext.ValidationResult vr = this.context.validateCode(new ValidationOptions().checkValueSetOnly().setVsAsUrl().noClient(), new Coding("http://loinc.org", "5792-7", null), new ValueSet().setUrl(ref));
        return vr.getErrorClass() == null;
    }

    private void validateElementType(List<ValidationMessage> errors, Element type, NodeStack stack, StructureDefinition sd, String path) {
        block6: {
            String code = type.getNamedChildValue("code");
            if (code == null && path != null) {
                code = this.getTypeCodeFromSD(sd, path);
            }
            if (code == null) break block6;
            List profiles = type.getChildrenByName("profile");
            if (VersionUtilities.isR2Ver((String)this.context.getVersion()) || VersionUtilities.isR2BVer((String)this.context.getVersion())) {
                for (Element profile : profiles) {
                    this.validateProfileTypeOrTarget(errors, profile, code, stack.push(profile, -1, null, null), path);
                }
            } else {
                for (Element profile : profiles) {
                    this.validateTypeProfile(errors, profile, code, stack.push(profile, -1, null, null), path);
                }
                profiles = type.getChildrenByName("targetProfile");
                for (Element profile : profiles) {
                    this.validateTargetProfile(errors, profile, code, stack.push(profile, -1, null, null), path);
                }
            }
        }
    }

    private void validateProfileTypeOrTarget(List<ValidationMessage> errors, Element profile, String code, NodeStack stack, String path) {
        String p = profile.primitiveValue();
        StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, p);
        if (code.equals("Reference")) {
            if (this.warning(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), sd != null, "SD_ED_TYPE_PROFILE_UNKNOWN", p)) {
                StructureDefinition t = this.determineBaseType(sd);
                if (t == null) {
                    this.rule(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), false, "SD_ED_TYPE_PROFILE_NOTYPE", p);
                } else {
                    this.rule(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), sd.getKind() == StructureDefinition.StructureDefinitionKind.RESOURCE, "SD_ED_TYPE_PROFILE_WRONG", p, t, code, path);
                }
            }
        } else {
            if (sd == null) {
                sd = this.getXverExt(errors, stack.getLiteralPath(), profile, p);
            }
            if (this.warning(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), sd != null, "SD_ED_TYPE_PROFILE_UNKNOWN", p)) {
                StructureDefinition t = this.determineBaseType(sd);
                if (t == null) {
                    this.rule(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), false, "SD_ED_TYPE_PROFILE_NOTYPE", p);
                } else {
                    this.rule(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), this.isInstanceOf(t, code), "SD_ED_TYPE_PROFILE_WRONG", p, t, code, path);
                    if (t.getType().equals("Extension")) {
                        boolean isModifierDefinition = this.checkIsModifierExtension(sd);
                        boolean isModifierContext = path.endsWith(".modifierExtension");
                        if (isModifierDefinition) {
                            this.rule(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), isModifierContext, "SD_ED_TYPE_PROFILE_NOT_MODIFIER", p, t, code, path);
                        } else {
                            this.rule(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), !isModifierContext, "SD_ED_TYPE_PROFILE_IS_MODIFIER", p, t, code, path);
                        }
                    }
                }
            }
        }
    }

    private String getTypeCodeFromSD(StructureDefinition sd, String path) {
        ElementDefinition ed = null;
        for (ElementDefinition t : sd.getSnapshot().getElement()) {
            if (!t.hasPath() || !t.getPath().equals(path)) continue;
            if (ed == null) {
                ed = t;
                continue;
            }
            return null;
        }
        return ed != null && ed.getType().size() == 1 ? ed.getTypeFirstRep().getCode() : null;
    }

    private void validateTypeProfile(List<ValidationMessage> errors, Element profile, String code, NodeStack stack, String path) {
        String p = profile.primitiveValue();
        StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, p);
        if (sd == null) {
            sd = this.getXverExt(errors, stack.getLiteralPath(), profile, p);
        }
        if (this.warning(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), sd != null, "SD_ED_TYPE_PROFILE_UNKNOWN", p)) {
            StructureDefinition t = this.determineBaseType(sd);
            if (t == null) {
                this.rule(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), false, "SD_ED_TYPE_PROFILE_NOTYPE", p);
            } else if (!this.isInstanceOf(t, code)) {
                this.rule(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), false, "SD_ED_TYPE_PROFILE_WRONG", p, t, code, path);
            } else if (t.getType().equals("Extension")) {
                boolean isModifierDefinition = this.checkIsModifierExtension(sd);
                boolean isModifierContext = path.endsWith(".modifierExtension");
                if (isModifierDefinition) {
                    this.rule(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), isModifierContext, "SD_ED_TYPE_PROFILE_NOT_MODIFIER", p, t, code, path);
                } else {
                    this.rule(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), !isModifierContext, "SD_ED_TYPE_PROFILE_IS_MODIFIER", p, t, code, path);
                }
            }
        }
    }

    private boolean checkIsModifierExtension(StructureDefinition t) {
        return t.getSnapshot().getElementFirstRep().getIsModifier();
    }

    private void validateTargetProfile(List<ValidationMessage> errors, Element profile, String code, NodeStack stack, String path) {
        String p = profile.primitiveValue();
        StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, p);
        if (code.equals("Reference") || code.equals("CodeableReference")) {
            if (this.warning(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), sd != null, "SD_ED_TYPE_PROFILE_UNKNOWN", p)) {
                StructureDefinition t = this.determineBaseType(sd);
                if (t == null) {
                    this.rule(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), false, "SD_ED_TYPE_PROFILE_NOTYPE", p);
                } else {
                    this.rule(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), sd.getKind() == StructureDefinition.StructureDefinitionKind.RESOURCE, "SD_ED_TYPE_PROFILE_WRONG_TARGET", p, t, code, path, "Resource");
                }
            }
        } else if (code.equals("canonical")) {
            if (this.warning(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), sd != null, "SD_ED_TYPE_PROFILE_UNKNOWN", p)) {
                StructureDefinition t = this.determineBaseType(sd);
                if (t == null) {
                    this.rule(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), false, "SD_ED_TYPE_PROFILE_NOTYPE", p);
                } else if (!VersionUtilities.isR5Ver((String)this.context.getVersion())) {
                    this.rule(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), VersionUtilities.getCanonicalResourceNames((String)this.context.getVersion()).contains(t.getType()) || "Resource".equals(t.getType()), "SD_ED_TYPE_PROFILE_WRONG_TARGET", p, t, code, path, "Canonical Resource");
                } else {
                    this.rule(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), VersionUtilities.getCanonicalResourceNames((String)this.context.getVersion()).contains(t.getType()), "SD_ED_TYPE_PROFILE_WRONG_TARGET", p, t, code, path, "Canonical Resource");
                }
            }
        } else {
            this.rule(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), false, "SD_ED_TYPE_NO_TARGET_PROFILE", code);
        }
    }

    private boolean isInstanceOf(StructureDefinition sd, String code) {
        while (sd != null) {
            if (sd.getType().equals(code)) {
                return true;
            }
            if (sd.getUrl().equals(code)) {
                return true;
            }
            StructureDefinition structureDefinition = sd = sd.hasBaseDefinition() ? (StructureDefinition)this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition()) : null;
            if (VersionUtilities.isR2Ver((String)this.context.getVersion()) || VersionUtilities.isR2BVer((String)this.context.getVersion()) || sd == null || sd.getAbstract() || sd.getKind() == StructureDefinition.StructureDefinitionKind.LOGICAL) continue;
            sd = null;
        }
        return false;
    }

    private StructureDefinition determineBaseType(StructureDefinition sd) {
        while (sd != null && sd.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT) {
            sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition());
        }
        return sd;
    }

    private boolean hasMustSupportExtension(Element type) {
        if ("true".equals(this.getExtensionValue(type, "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support"))) {
            return true;
        }
        List profiles = type.getChildrenByName("profile");
        for (Element profile : profiles) {
            if (!"true".equals(this.getExtensionValue(profile, "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support"))) continue;
            return true;
        }
        profiles = type.getChildrenByName("targetProfile");
        for (Element profile : profiles) {
            if (!"true".equals(this.getExtensionValue(profile, "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support"))) continue;
            return true;
        }
        return false;
    }

    private String getExtensionValue(Element element, String url) {
        List extensions = element.getChildrenByName("extension");
        for (Element extension : extensions) {
            if (!url.equals(extension.getNamedChildValue("url"))) continue;
            return extension.getNamedChildValue("value");
        }
        return null;
    }

    private StructureDefinition loadAsSD(Element src) throws FHIRException, IOException {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        Manager.compose((IWorkerContext)this.context, (Element)src, (OutputStream)bs, (Manager.FhirFormat)Manager.FhirFormat.JSON, (IParser.OutputStyle)IParser.OutputStyle.NORMAL, null);
        if (VersionUtilities.isR2Ver((String)this.context.getVersion())) {
            org.hl7.fhir.dstu2.model.Resource r2 = new org.hl7.fhir.dstu2.formats.JsonParser().parse(bs.toByteArray());
            return (StructureDefinition)VersionConvertorFactory_10_50.convertResource((org.hl7.fhir.dstu2.model.Resource)r2);
        }
        if (VersionUtilities.isR2BVer((String)this.context.getVersion())) {
            org.hl7.fhir.dstu2016may.model.Resource r2b = new org.hl7.fhir.dstu2016may.formats.JsonParser().parse(bs.toByteArray());
            return (StructureDefinition)VersionConvertorFactory_14_50.convertResource((org.hl7.fhir.dstu2016may.model.Resource)r2b);
        }
        if (VersionUtilities.isR3Ver((String)this.context.getVersion())) {
            org.hl7.fhir.dstu3.model.Resource r3 = new org.hl7.fhir.dstu3.formats.JsonParser().parse(bs.toByteArray());
            return (StructureDefinition)VersionConvertorFactory_30_50.convertResource((org.hl7.fhir.dstu3.model.Resource)r3);
        }
        if (VersionUtilities.isR4Ver((String)this.context.getVersion())) {
            org.hl7.fhir.r4.model.Resource r4 = new org.hl7.fhir.r4.formats.JsonParser().parse(bs.toByteArray());
            return (StructureDefinition)VersionConvertorFactory_40_50.convertResource((org.hl7.fhir.r4.model.Resource)r4);
        }
        return (StructureDefinition)new JsonParser().parse(bs.toByteArray());
    }

    public class FhirPathSorter
    implements Comparator<ExpressionNode> {
        @Override
        public int compare(ExpressionNode arg0, ExpressionNode arg1) {
            return arg0.toString().compareTo(arg1.toString());
        }
    }
}

