/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ExpressionNode;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.utils.FHIRPathEngine;
import org.hl7.fhir.r5.utils.XVerExtensionManager;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.validation.BaseValidator;
import org.hl7.fhir.validation.TimeTracker;
import org.hl7.fhir.validation.instance.utils.NodeStack;

public class SearchParameterValidator
extends BaseValidator {
    private FHIRPathEngine fpe;

    public SearchParameterValidator(IWorkerContext context, TimeTracker timeTracker, FHIRPathEngine fpe, XVerExtensionManager xverManager, Coding jurisdiction) {
        super(context, xverManager);
        this.source = ValidationMessage.Source.InstanceValidator;
        this.fpe = fpe;
        this.timeTracker = timeTracker;
        this.jurisdiction = jurisdiction;
    }

    public void validateSearchParameter(List<ValidationMessage> errors, Element cs, NodeStack stack) {
        String url = cs.getNamedChildValue("url");
        String master = cs.getNamedChildValue("derivedFrom");
        if (!Utilities.noString((String)master)) {
            SearchParameter sp = (SearchParameter)this.context.fetchResource(SearchParameter.class, master);
            if (this.warning(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), sp != null, "SEARCHPARAMETER_NOTFOUND", master)) {
                List bl = cs.getChildren("base");
                for (Object b : bl) {
                    this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), sp.hasBase(b.primitiveValue()) || sp.hasBase("Resource"), "SEARCHPARAMETER_BASE_WRONG", master, b.primitiveValue());
                }
                this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), !cs.hasChild("type") || sp.getType().toCode().equals(cs.getNamedChildValue("type")), "SEARCHPARAMETER_TYPE_WRONG", master, sp.getType().toCode(), cs.getNamedChildValue("type"));
                if (sp.hasExpression() && cs.hasChild("expression") && !sp.getExpression().equals(cs.getNamedChildValue("expression"))) {
                    ArrayList<String> bases = new ArrayList<String>();
                    for (Element b : cs.getChildren("base")) {
                        bases.add(b.primitiveValue());
                    }
                    String expThis = this.canonicalise(cs.getNamedChildValue("expression"), bases);
                    String expOther = this.canonicalise(sp.getExpression(), bases);
                    this.warning(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), expThis.equals(expOther), "SEARCHPARAMETER_EXP_WRONG", master, sp.getExpression(), cs.getNamedChildValue("expression"));
                }
            }
        }
    }

    private String canonicalise(String path, List<String> bases) {
        ExpressionNode exp = this.fpe.parse(path);
        ArrayList<ExpressionNode> pass = new ArrayList<ExpressionNode>();
        while (exp != null) {
            String name;
            if (exp.getKind() != ExpressionNode.Kind.Name && (exp.getKind() != ExpressionNode.Kind.Group || exp.getGroup().getKind() != ExpressionNode.Kind.Name)) {
                return path;
            }
            if (exp.getOperation() != null && exp.getOperation() != ExpressionNode.Operation.Union) {
                return path;
            }
            ExpressionNode nexp = exp.getOpNext();
            exp.setOperation(null);
            exp.setOpNext(null);
            String string = name = exp.getKind() == ExpressionNode.Kind.Name ? exp.getName() : exp.getGroup().getName();
            if (this.context.getResourceNames().contains(name)) {
                if (bases.contains(name)) {
                    pass.add(exp);
                }
            } else {
                pass.add(exp);
            }
            exp = nexp;
        }
        Collections.sort(pass, new FhirPathSorter());
        for (int i = 0; i < pass.size() - 1; ++i) {
            ((ExpressionNode)pass.get(i)).setOperation(ExpressionNode.Operation.Union);
            ((ExpressionNode)pass.get(i)).setOpNext((ExpressionNode)pass.get(i + 1));
        }
        return ((ExpressionNode)pass.get(0)).toString();
    }

    public class FhirPathSorter
    implements Comparator<ExpressionNode> {
        @Override
        public int compare(ExpressionNode arg0, ExpressionNode arg1) {
            return arg0.toString().compareTo(arg1.toString());
        }
    }
}

