/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.cli.utils;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.hl7.fhir.utilities.npm.FilesystemPackageCacheManager;
import org.hl7.fhir.validation.cli.utils.VersionUtil;

public class Display {
    static final String CURLY_START = "\\{\\{";
    static final String CURLY_END = "\\}\\}";
    static final String[][] PLACEHOLDERS = new String[][]{{Display.getMoustacheString("XML_AND_JSON_FHIR_VERSIONS"), "1.0, 1.4, 3.0, 4.0,5.0"}, {Display.getMoustacheString("TURTLE_FHIR_VERSIONS"), "3.0, 4.0, 5.0"}, {Display.getMoustacheString("FHIR_MAJOR_VERSIONS"), "1.0|1.4|3.0|4.6"}, {Display.getMoustacheString("FHIR_MINOR_VERSIONS"), "1.0.2|1.4.0|3.0.2|4.0.1|4.6.0"}, {Display.getMoustacheString("FHIR_CURRENT_VERSION"), "4.6"}};

    private static String toMB(long maxMemory) {
        return Long.toString(maxMemory / 0x100000L);
    }

    public static void printCliArgumentsAndInfo(String[] args) throws IOException {
        System.out.println("  Paths:  Current = " + System.getProperty("user.dir") + ", Package Cache = " + new FilesystemPackageCacheManager(true, 3).getFolder());
        System.out.print("  Params:");
        for (String s : args) {
            System.out.print(s.contains(" ") ? " \"" + s + "\"" : " " + s);
        }
        System.out.println();
    }

    static final String getMoustacheString(String string) {
        return CURLY_START + string + CURLY_END;
    }

    static final String replacePlaceholders(String input, String[][] placeholders) {
        String output = input;
        for (String[] placeholder : placeholders) {
            output = output.replaceAll(placeholder[0], placeholder[1]);
        }
        return output;
    }

    public static void displayHelpDetails() {
        ClassLoader classLoader = Display.class.getClassLoader();
        InputStream help = classLoader.getResourceAsStream("help.txt");
        try {
            String data = IOUtils.toString((InputStream)help, (String)"UTF-8");
            System.out.println(Display.replacePlaceholders(data, PLACEHOLDERS));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void displaySystemInfo() {
        System.out.println("  Java:   " + System.getProperty("java.version") + " from " + System.getProperty("java.home") + " on " + System.getProperty("os.arch") + " (" + System.getProperty("sun.arch.data.model") + "bit). " + Display.toMB(Runtime.getRuntime().maxMemory()) + "MB available");
    }

    public static void displayVersion() {
        System.out.println("FHIR Validation tool " + VersionUtil.getVersionString());
    }
}

