/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.cli.utils;

import java.io.InputStream;
import java.time.Duration;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.utilities.Utilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionUtil {
    private static final Logger ourLog = LoggerFactory.getLogger(ca.uhn.fhir.util.VersionUtil.class);
    private static String ourVersion;
    private static String ourBuildNumber;
    private static String ourBuildTime;

    public static String getBuildNumber() {
        return ourBuildNumber;
    }

    public static String getBuildTime() {
        return ourBuildTime;
    }

    public static String getVersion() {
        return ourVersion;
    }

    private static void initialize() {
        try (InputStream is = ca.uhn.fhir.util.VersionUtil.class.getResourceAsStream("/fhir-build.properties");){
            Properties p = new Properties();
            if (is != null) {
                p.load(is);
            }
            ourVersion = p.getProperty("orgfhir.version");
            ourVersion = (String)StringUtils.defaultIfBlank((CharSequence)ourVersion, (CharSequence)"(unknown)");
            ourBuildNumber = p.getProperty("orgfhir.buildnumber");
            ourBuildTime = p.getProperty("orgfhir.timestamp");
        }
        catch (Exception e) {
            ourLog.warn("Unable to determine version information", (Throwable)e);
        }
    }

    public static String getVersionString() {
        return "Version " + VersionUtil.getVersion() + " (Git# " + StringUtils.left((String)VersionUtil.getBuildNumber(), (int)12) + "). Built " + VersionUtil.getBuildTime() + " (" + VersionUtil.getDurationSinceBuild() + ")";
    }

    private static String getDurationSinceBuild() {
        try {
            InstantType dt = new InstantType(ourBuildTime);
            return Utilities.describeDuration((Duration)Duration.ofMillis(new Date().getTime() - ((Date)dt.getValue()).getTime())) + " old";
        }
        catch (Exception e) {
            return "??";
        }
    }

    static {
        VersionUtil.initialize();
    }
}

