/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation;

import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.context.SimpleWorkerContext;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.elementmodel.SHCParser;
import org.hl7.fhir.r5.utils.structuremap.StructureMapUtilities;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.json.JsonTrackingParser;
import org.hl7.fhir.validation.ValidatorUtils;

public class ResourceChecker {
    public static Manager.FhirFormat checkIsResource(SimpleWorkerContext context, boolean debug, byte[] cnt, String filename, boolean guessFromExtension) {
        System.out.println("   ..Detect format for " + filename);
        if (guessFromExtension) {
            String ext = Utilities.getFileExtension((String)filename);
            if (Utilities.existsInList((String)ext, (String[])new String[]{"xml"})) {
                return Manager.FhirFormat.XML;
            }
            if (Utilities.existsInList((String)ext, (String[])new String[]{"ttl"})) {
                return Manager.FhirFormat.TURTLE;
            }
            if (Utilities.existsInList((String)ext, (String[])new String[]{"map"})) {
                return Manager.FhirFormat.TEXT;
            }
            if (Utilities.existsInList((String)ext, (String[])new String[]{"jwt", "jws"})) {
                return Manager.FhirFormat.SHC;
            }
            if (Utilities.existsInList((String)ext, (String[])new String[]{"json"})) {
                try {
                    JsonObject json = JsonTrackingParser.parseJson((byte[])cnt);
                    if (json.has("verifiableCredential")) {
                        return Manager.FhirFormat.SHC;
                    }
                }
                catch (Exception json) {
                    // empty catch block
                }
                return Manager.FhirFormat.JSON;
            }
            if (Utilities.existsInList((String)ext, (String[])new String[]{"txt"})) {
                try {
                    String src = TextFile.bytesToString((byte[])cnt);
                    if (src.startsWith("shc:/")) {
                        return Manager.FhirFormat.SHC;
                    }
                }
                catch (Exception src) {
                    // empty catch block
                }
                return Manager.FhirFormat.TEXT;
            }
        }
        try {
            Manager.parse((IWorkerContext)context, (InputStream)new ByteArrayInputStream(cnt), (Manager.FhirFormat)Manager.FhirFormat.JSON);
            return Manager.FhirFormat.JSON;
        }
        catch (Exception e) {
            if (debug) {
                System.out.println("Not JSON: " + e.getMessage());
            }
            try {
                ValidatorUtils.parseXml(cnt);
                return Manager.FhirFormat.XML;
            }
            catch (Exception e2) {
                if (debug) {
                    System.out.println("Not XML: " + e2.getMessage());
                }
                try {
                    Manager.parse((IWorkerContext)context, (InputStream)new ByteArrayInputStream(cnt), (Manager.FhirFormat)Manager.FhirFormat.TURTLE);
                    return Manager.FhirFormat.TURTLE;
                }
                catch (Exception e3) {
                    if (debug) {
                        System.out.println("Not Turtle: " + e3.getMessage());
                    }
                    try {
                        String s = new String(cnt, StandardCharsets.UTF_8);
                        if (s.startsWith("shc:/")) {
                            s = SHCParser.decodeQRCode((String)s);
                        }
                        SHCParser.JWT jwt = new SHCParser((IWorkerContext)context).decodeJWT(s);
                        return Manager.FhirFormat.SHC;
                    }
                    catch (Exception e4) {
                        if (debug) {
                            System.out.println("Not a smart health card: " + e4.getMessage());
                        }
                        try {
                            new StructureMapUtilities((IWorkerContext)context, null, null).parse(TextFile.bytesToString((byte[])cnt), null);
                            return Manager.FhirFormat.TEXT;
                        }
                        catch (Exception e5) {
                            if (debug) {
                                System.out.println("Not Text: " + e5.getMessage());
                            }
                            if (debug) {
                                System.out.println("     .. not a resource: " + filename);
                            }
                            return null;
                        }
                    }
                }
            }
        }
    }
}

