/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.type;

import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.utils.XVerExtensionManager;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;
import org.hl7.fhir.validation.BaseValidator;
import org.hl7.fhir.validation.TimeTracker;
import org.hl7.fhir.validation.instance.utils.NodeStack;

public class CodeSystemValidator
extends BaseValidator {
    public CodeSystemValidator(IWorkerContext context, TimeTracker timeTracker, XVerExtensionManager xverManager) {
        super(context, xverManager);
        this.source = ValidationMessage.Source.InstanceValidator;
        this.timeTracker = timeTracker;
    }

    public void validateCodeSystem(List<ValidationMessage> errors, Element cs, NodeStack stack, ValidationOptions options) {
        String supp;
        String url = cs.getNamedChildValue("url");
        String content = cs.getNamedChildValue("content");
        String vsu = cs.getNamedChildValue("valueSet");
        if (!Utilities.noString((String)vsu)) {
            ValueSet vs;
            this.hint(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), "complete".equals(content), "CODESYSTEM_CS_NO_VS_NOTCOMPLETE", new Object[0]);
            try {
                vs = (ValueSet)this.context.fetchResourceWithException(ValueSet.class, vsu);
            }
            catch (FHIRException e) {
                vs = null;
            }
            if (vs != null && this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), vs.hasCompose(), "CodeSystem_CS_VS_Invalid", url, vsu) && this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), vs.getCompose().getInclude().size() == 1, "CodeSystem_CS_VS_Invalid", url, vsu) && this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), ((ValueSet.ConceptSetComponent)vs.getCompose().getInclude().get(0)).getSystem().equals(url), "CodeSystem_CS_VS_WrongSystem", url, vsu, ((ValueSet.ConceptSetComponent)vs.getCompose().getInclude().get(0)).getSystem())) {
                this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), !((ValueSet.ConceptSetComponent)vs.getCompose().getInclude().get(0)).hasValueSet() && !((ValueSet.ConceptSetComponent)vs.getCompose().getInclude().get(0)).hasConcept() && !((ValueSet.ConceptSetComponent)vs.getCompose().getInclude().get(0)).hasFilter(), "CodeSystem_CS_VS_IncludeDetails", url, vsu);
                if (vs.hasExpansion()) {
                    int count = this.countConcepts(cs);
                    this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), vs.getExpansion().getContains().size() == count, "CODESYSTEM_CS_VS_EXP_MISMATCH", url, vsu, count, vs.getExpansion().getContains().size());
                }
            }
        }
        if ((supp = cs.getNamedChildValue("supplements")) != null) {
            if (this.context.supportsSystem(supp)) {
                List concepts = cs.getChildrenByName("concept");
                int ce = 0;
                for (Element concept : concepts) {
                    this.validateSupplementConcept(errors, concept, stack.push(concept, ce, null, null), supp, options);
                    ++ce;
                }
            } else if (cs.hasChildren("concept")) {
                this.warning(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), false, "CODESYSTEM_CS_SUPP_CANT_CHECK", supp);
            }
        }
    }

    private void validateSupplementConcept(List<ValidationMessage> errors, Element concept, NodeStack stack, String supp, ValidationOptions options) {
        String code = concept.getChildValue("code");
        if (!Utilities.noString((String)code)) {
            IWorkerContext.ValidationResult res = this.context.validateCode(options, this.systemFromCanonical(supp), this.versionFromCanonical(supp), code, null);
            this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), res.isOk(), "CODESYSTEM_CS_SUPP_INVALID_CODE", supp, code);
        }
    }

    private int countConcepts(Element cs) {
        List concepts = cs.getChildrenByName("concept");
        int res = concepts.size();
        for (Element concept : concepts) {
            res += this.countConcepts(concept);
        }
        return res;
    }
}

