/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation;

import java.util.List;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class ValidationRecord {
    private String location;
    private List<ValidationMessage> messages;
    int err = 0;
    int warn = 0;
    int info = 0;

    public ValidationRecord(String location, List<ValidationMessage> messages) {
        this.location = location;
        this.messages = messages;
        for (ValidationMessage vm : messages) {
            if (vm.getLevel().equals((Object)ValidationMessage.IssueSeverity.FATAL) || vm.getLevel().equals((Object)ValidationMessage.IssueSeverity.ERROR)) {
                ++this.err;
                continue;
            }
            if (vm.getLevel().equals((Object)ValidationMessage.IssueSeverity.WARNING)) {
                ++this.warn;
                continue;
            }
            if (vm.isSignpost()) continue;
            ++this.info;
        }
    }

    public String getLocation() {
        return this.location;
    }

    public List<ValidationMessage> getMessages() {
        return this.messages;
    }

    public int getErr() {
        return this.err;
    }

    public int getWarn() {
        return this.warn;
    }

    public int getInfo() {
        return this.info;
    }
}

