/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.cli.services;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.validation.ValidationEngine;
import org.hl7.fhir.validation.cli.utils.Params;

public class ComparisonService {
    public static void doLeftRightComparison(String[] args, String dest, ValidationEngine validator) throws IOException, FHIRException, EOperationOutcome {
        String left = Params.getParam(args, "-left");
        String right = Params.getParam(args, "-right");
        Resource resLeft = validator.getContext().fetchResource(Resource.class, left);
        Resource resRight = validator.getContext().fetchResource(Resource.class, right);
        if (resLeft == null) {
            System.out.println("Unable to locate left resource " + left);
        }
        if (resRight == null) {
            System.out.println("Unable to locate right resource " + right);
        }
        if (resLeft != null && resRight != null) {
            if (resLeft instanceof StructureDefinition && resRight instanceof StructureDefinition) {
                ComparisonService.compareStructureDefinitions(dest, validator, left, right, (StructureDefinition)resLeft, (StructureDefinition)resRight);
            } else if (resLeft instanceof CapabilityStatement && resRight instanceof CapabilityStatement) {
                ComparisonService.compareCapabilityStatements(args, dest, validator, left, right, (CanonicalResource)resLeft, (CanonicalResource)resRight);
            } else {
                System.out.println("Unable to compare left resource " + left + " (" + resLeft.fhirType() + ") with right resource " + right + " (" + resRight.fhirType() + ")");
            }
        }
    }

    public static void compareCapabilityStatements(String[] args, String dest, ValidationEngine validator, String left, String right, CanonicalResource resLeft, CanonicalResource resRight) throws IOException {
        String nameLeft = ComparisonService.chooseName(args, "leftName", resLeft);
        String nameRight = ComparisonService.chooseName(args, "rightName", resRight);
        System.out.println("Comparing CapabilityStatements " + left + " to " + right);
        String destHtml = Utilities.path((String[])new String[]{dest, "public/index.html"});
        File htmlFile = new File(destHtml);
        Desktop.getDesktop().browse(htmlFile.toURI());
        System.out.println("Done");
    }

    public static void compareStructureDefinitions(String dest, ValidationEngine validator, String left, String right, StructureDefinition resLeft, StructureDefinition resRight) throws IOException, FHIRException, EOperationOutcome {
    }

    private static String chooseName(String[] args, String name, CanonicalResource mr) {
        String s = Params.getParam(args, "-" + name);
        if (Utilities.noString((String)s)) {
            s = mr.present();
        }
        return s;
    }
}

