/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.cli.services;

import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.map.PassiveExpiringMap;
import org.hl7.fhir.validation.ValidationEngine;

public class SessionCache {
    protected static final long TIME_TO_LIVE = 60L;
    protected static final TimeUnit TIME_UNIT = TimeUnit.MINUTES;
    private final PassiveExpiringMap<String, ValidationEngine> cachedSessions;

    public SessionCache() {
        this.cachedSessions = new PassiveExpiringMap(60L, TIME_UNIT);
    }

    public SessionCache(long sessionLength, TimeUnit sessionLengthUnit) {
        this.cachedSessions = new PassiveExpiringMap(sessionLength, sessionLengthUnit);
    }

    public String cacheSession(ValidationEngine validationEngine) {
        String generatedId = this.generateID();
        this.cachedSessions.put((Object)generatedId, (Object)validationEngine);
        return generatedId;
    }

    public String cacheSession(String sessionId, ValidationEngine validationEngine) {
        if (sessionId == null) {
            sessionId = this.cacheSession(validationEngine);
        } else {
            this.cachedSessions.put((Object)sessionId, (Object)validationEngine);
        }
        return sessionId;
    }

    public boolean sessionExists(String sessionId) {
        return this.cachedSessions.containsKey((Object)sessionId);
    }

    public ValidationEngine fetchSessionValidatorEngine(String sessionId) {
        return (ValidationEngine)this.cachedSessions.get((Object)sessionId);
    }

    public Set<String> getSessionIds() {
        return this.cachedSessions.keySet();
    }

    private String generateID() {
        return UUID.randomUUID().toString();
    }
}

