/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.PathEngineException;
import org.hl7.fhir.exceptions.TerminologyServiceException;
import org.hl7.fhir.r5.conformance.ProfileUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.JsonParser;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.elementmodel.ObjectConverter;
import org.hl7.fhir.r5.elementmodel.ParserBase;
import org.hl7.fhir.r5.elementmodel.XmlParser;
import org.hl7.fhir.r5.formats.FormatUtilities;
import org.hl7.fhir.r5.model.Address;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Base64BinaryType;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.ExpressionNode;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.HumanName;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.OidType;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Ratio;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.SampledData;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.TimeType;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.TypeDetails;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UuidType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.ValueSetExpander;
import org.hl7.fhir.r5.utils.FHIRLexer;
import org.hl7.fhir.r5.utils.FHIRPathEngine;
import org.hl7.fhir.r5.utils.IResourceValidator;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.r5.utils.XVerExtensionManager;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.validation.BaseValidator;
import org.hl7.fhir.validation.cli.utils.QuestionnaireMode;
import org.hl7.fhir.validation.instance.EnableWhenEvaluator;
import org.hl7.fhir.validation.instance.SpecialExtensions;
import org.hl7.fhir.validation.instance.type.BundleValidator;
import org.hl7.fhir.validation.instance.type.CodeSystemValidator;
import org.hl7.fhir.validation.instance.type.MeasureValidator;
import org.hl7.fhir.validation.instance.type.QuestionnaireValidator;
import org.hl7.fhir.validation.instance.type.SearchParameterValidator;
import org.hl7.fhir.validation.instance.type.StructureDefinitionValidator;
import org.hl7.fhir.validation.instance.type.ValueSetValidator;
import org.hl7.fhir.validation.instance.utils.ChildIterator;
import org.hl7.fhir.validation.instance.utils.ElementInfo;
import org.hl7.fhir.validation.instance.utils.IndexedElement;
import org.hl7.fhir.validation.instance.utils.NodeStack;
import org.hl7.fhir.validation.instance.utils.ResolvedReference;
import org.hl7.fhir.validation.instance.utils.ResourceValidationTracker;
import org.hl7.fhir.validation.instance.utils.ValidatorHostContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InstanceValidator
extends BaseValidator
implements IResourceValidator {
    private static final String EXECUTED_CONSTRAINT_LIST = "validator.executed.invariant.list";
    private static final String EXECUTION_ID = "validator.execution.id";
    private static final String HTML_FRAGMENT_REGEX = "[a-zA-Z]\\w*(((\\s+)(\\S)*)*)";
    private FHIRPathEngine fpe;
    private IResourceValidator.CheckDisplayOption checkDisplay;
    private boolean anyExtensionsAllowed;
    private boolean errorForUnknownProfiles;
    private boolean noInvariantChecks;
    private boolean noTerminologyChecks;
    private boolean hintAboutNonMustSupport;
    private boolean showMessagesFromReferences;
    private IResourceValidator.BestPracticeWarningLevel bpWarnings;
    private String validationLanguage;
    private boolean baseOnly;
    private boolean noCheckAggregation;
    private boolean wantCheckSnapshotUnchanged;
    private List<ImplementationGuide> igs = new ArrayList<ImplementationGuide>();
    private List<String> extensionDomains = new ArrayList<String>();
    private IResourceValidator.IdStatus resourceIdRule;
    private boolean allowXsiLocation;
    private boolean suppressLoincSnomedMessages;
    private boolean noBindingMsgSuppressed;
    private boolean debug;
    private Map<String, org.hl7.fhir.r5.elementmodel.Element> fetchCache = new HashMap<String, org.hl7.fhir.r5.elementmodel.Element>();
    private HashMap<org.hl7.fhir.r5.elementmodel.Element, ResourceValidationTracker> resourceTracker = new HashMap();
    private IResourceValidator.IValidatorResourceFetcher fetcher;
    long time = 0L;
    private FHIRPathEngine.IEvaluationContext externalHostServices;
    private boolean noExtensibleWarnings;
    private String serverBase;
    private EnableWhenEvaluator myEnableWhenEvaluator = new EnableWhenEvaluator();
    private String executionId;
    private IResourceValidator.IValidationProfileUsageTracker tracker;
    private ValidatorHostServices validatorServices;
    private boolean assumeValidRestReferences;
    private boolean allowExamples;
    private boolean securityChecks;
    private ProfileUtilities profileUtilities;
    private boolean crumbTrails;
    private List<IResourceValidator.BundleValidationRule> bundleValidationRules = new ArrayList<IResourceValidator.BundleValidationRule>();
    private boolean validateValueSetCodesOnTxServer = true;
    private QuestionnaireMode questionnaireMode;

    public FHIRPathEngine getFHIRPathEngine() {
        return this.fpe;
    }

    public InstanceValidator(IWorkerContext theContext, FHIRPathEngine.IEvaluationContext hostServices, XVerExtensionManager xverManager) {
        super(theContext, xverManager);
        this.externalHostServices = hostServices;
        this.profileUtilities = new ProfileUtilities(theContext, null, null);
        this.fpe = new FHIRPathEngine(this.context);
        this.validatorServices = new ValidatorHostServices();
        this.fpe.setHostServices((FHIRPathEngine.IEvaluationContext)this.validatorServices);
        if (theContext.getVersion().startsWith("3.0") || theContext.getVersion().startsWith("1.0")) {
            this.fpe.setLegacyMode(true);
        }
        this.source = ValidationMessage.Source.InstanceValidator;
    }

    public boolean isNoExtensibleWarnings() {
        return this.noExtensibleWarnings;
    }

    public IResourceValidator setNoExtensibleWarnings(boolean noExtensibleWarnings) {
        this.noExtensibleWarnings = noExtensibleWarnings;
        return this;
    }

    public boolean isShowMessagesFromReferences() {
        return this.showMessagesFromReferences;
    }

    public void setShowMessagesFromReferences(boolean showMessagesFromReferences) {
        this.showMessagesFromReferences = showMessagesFromReferences;
    }

    public boolean isNoInvariantChecks() {
        return this.noInvariantChecks;
    }

    public IResourceValidator setNoInvariantChecks(boolean value) {
        this.noInvariantChecks = value;
        return this;
    }

    public IResourceValidator.IValidatorResourceFetcher getFetcher() {
        return this.fetcher;
    }

    public IResourceValidator setFetcher(IResourceValidator.IValidatorResourceFetcher value) {
        this.fetcher = value;
        return this;
    }

    public IResourceValidator.IValidationProfileUsageTracker getTracker() {
        return this.tracker;
    }

    public IResourceValidator setTracker(IResourceValidator.IValidationProfileUsageTracker value) {
        this.tracker = value;
        return this;
    }

    public boolean isHintAboutNonMustSupport() {
        return this.hintAboutNonMustSupport;
    }

    public void setHintAboutNonMustSupport(boolean hintAboutNonMustSupport) {
        this.hintAboutNonMustSupport = hintAboutNonMustSupport;
    }

    public boolean isAssumeValidRestReferences() {
        return this.assumeValidRestReferences;
    }

    public void setAssumeValidRestReferences(boolean value) {
        this.assumeValidRestReferences = value;
    }

    public boolean isAllowExamples() {
        return this.allowExamples;
    }

    public void setAllowExamples(boolean value) {
        this.allowExamples = value;
    }

    public boolean isCrumbTrails() {
        return this.crumbTrails;
    }

    public void setCrumbTrails(boolean crumbTrails) {
        this.crumbTrails = crumbTrails;
    }

    private boolean allowUnknownExtension(String url) {
        if (this.allowExamples && (url.contains("example.org") || url.contains("acme.com")) || url.contains("nema.org") || url.startsWith("http://hl7.org/fhir/tools/StructureDefinition/") || url.equals("http://hl7.org/fhir/StructureDefinition/structuredefinition-expression")) {
            return true;
        }
        for (String s : this.extensionDomains) {
            if (!url.startsWith(s)) continue;
            return true;
        }
        return this.anyExtensionsAllowed;
    }

    private boolean isKnownExtension(String url) {
        if (this.allowExamples && (url.contains("example.org") || url.contains("acme.com")) || url.contains("nema.org") || url.startsWith("http://hl7.org/fhir/tools/StructureDefinition/") || url.equals("http://hl7.org/fhir/StructureDefinition/structuredefinition-expression")) {
            return true;
        }
        for (String s : this.extensionDomains) {
            if (!url.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    private void bpCheck(List<ValidationMessage> errors, ValidationMessage.IssueType invalid, int line, int col, String literalPath, boolean test, String message, Object ... theMessageArguments) {
        if (this.bpWarnings != null) {
            switch (this.bpWarnings) {
                case Error: {
                    this.rule(errors, invalid, line, col, literalPath, test, message, theMessageArguments);
                    break;
                }
                case Warning: {
                    this.warning(errors, invalid, line, col, literalPath, test, message, theMessageArguments);
                    break;
                }
                case Hint: {
                    this.hint(errors, invalid, line, col, literalPath, test, message, theMessageArguments);
                    break;
                }
            }
        }
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, InputStream stream, Manager.FhirFormat format) throws FHIRException {
        return this.validate(appContext, errors, stream, format, new ArrayList<StructureDefinition>());
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, InputStream stream, Manager.FhirFormat format, String profile) throws FHIRException {
        ArrayList<StructureDefinition> profiles = new ArrayList<StructureDefinition>();
        if (profile != null) {
            profiles.add(this.getSpecifiedProfile(profile));
        }
        return this.validate(appContext, errors, stream, format, profiles);
    }

    private StructureDefinition getSpecifiedProfile(String profile) {
        StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, profile);
        if (sd == null) {
            throw new FHIRException(this.context.formatMessage("Unable_to_locate_the_profile__in_order_to_validate_against_it", new Object[]{profile}));
        }
        return sd;
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, InputStream stream, Manager.FhirFormat format, List<StructureDefinition> profiles) throws FHIRException {
        org.hl7.fhir.r5.elementmodel.Element e;
        ParserBase parser = Manager.makeParser((IWorkerContext)this.context, (Manager.FhirFormat)format);
        if (parser instanceof XmlParser) {
            ((XmlParser)parser).setAllowXsiLocation(this.allowXsiLocation);
        }
        parser.setupValidation(ParserBase.ValidationPolicy.EVERYTHING, errors);
        long t = System.nanoTime();
        try {
            e = parser.parse(stream);
        }
        catch (IOException e1) {
            throw new FHIRException((Throwable)e1);
        }
        this.timeTracker.load(t);
        if (e != null) {
            this.validate(appContext, errors, e, profiles);
        }
        return e;
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, Resource resource) throws FHIRException {
        return this.validate(appContext, errors, resource, new ArrayList<StructureDefinition>());
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, Resource resource, String profile) throws FHIRException {
        ArrayList<StructureDefinition> profiles = new ArrayList<StructureDefinition>();
        if (profile != null) {
            profiles.add(this.getSpecifiedProfile(profile));
        }
        return this.validate(appContext, errors, resource, profiles);
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, Resource resource, List<StructureDefinition> profiles) throws FHIRException {
        org.hl7.fhir.r5.elementmodel.Element e;
        long t = System.nanoTime();
        try {
            e = new ObjectConverter(this.context).convert(resource);
        }
        catch (IOException e1) {
            throw new FHIRException((Throwable)e1);
        }
        this.timeTracker.load(t);
        this.validate(appContext, errors, e, profiles);
        return e;
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, Element element) throws FHIRException {
        return this.validate(appContext, errors, element, new ArrayList<StructureDefinition>());
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, Element element, String profile) throws FHIRException {
        ArrayList<StructureDefinition> profiles = new ArrayList<StructureDefinition>();
        if (profile != null) {
            profiles.add(this.getSpecifiedProfile(profile));
        }
        return this.validate(appContext, errors, element, profiles);
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, Element element, List<StructureDefinition> profiles) throws FHIRException {
        org.hl7.fhir.r5.elementmodel.Element e;
        XmlParser parser = new XmlParser(this.context);
        parser.setupValidation(ParserBase.ValidationPolicy.EVERYTHING, errors);
        long t = System.nanoTime();
        try {
            e = parser.parse(element);
        }
        catch (IOException e1) {
            throw new FHIRException((Throwable)e1);
        }
        this.timeTracker.load(t);
        if (e != null) {
            this.validate(appContext, errors, e, profiles);
        }
        return e;
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, Document document) throws FHIRException {
        return this.validate(appContext, errors, document, new ArrayList<StructureDefinition>());
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, Document document, String profile) throws FHIRException {
        ArrayList<StructureDefinition> profiles = new ArrayList<StructureDefinition>();
        if (profile != null) {
            profiles.add(this.getSpecifiedProfile(profile));
        }
        return this.validate(appContext, errors, document, profiles);
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, Document document, List<StructureDefinition> profiles) throws FHIRException {
        org.hl7.fhir.r5.elementmodel.Element e;
        XmlParser parser = new XmlParser(this.context);
        parser.setupValidation(ParserBase.ValidationPolicy.EVERYTHING, errors);
        long t = System.nanoTime();
        try {
            e = parser.parse(document);
        }
        catch (IOException e1) {
            throw new FHIRException((Throwable)e1);
        }
        this.timeTracker.load(t);
        if (e != null) {
            this.validate(appContext, errors, e, profiles);
        }
        return e;
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, JsonObject object) throws FHIRException {
        return this.validate(appContext, errors, object, new ArrayList<StructureDefinition>());
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, JsonObject object, String profile) throws FHIRException {
        ArrayList<StructureDefinition> profiles = new ArrayList<StructureDefinition>();
        if (profile != null) {
            profiles.add(this.getSpecifiedProfile(profile));
        }
        return this.validate(appContext, errors, object, profiles);
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, JsonObject object, List<StructureDefinition> profiles) throws FHIRException {
        JsonParser parser = new JsonParser(this.context, new ProfileUtilities(this.context, null, null, this.fpe));
        parser.setupValidation(ParserBase.ValidationPolicy.EVERYTHING, errors);
        long t = System.nanoTime();
        org.hl7.fhir.r5.elementmodel.Element e = parser.parse(object);
        this.timeTracker.load(t);
        if (e != null) {
            this.validate(appContext, errors, e, profiles);
        }
        return e;
    }

    public void validate(Object appContext, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element) throws FHIRException {
        this.validate(appContext, errors, element, new ArrayList<StructureDefinition>());
    }

    public void validate(Object appContext, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, String profile) throws FHIRException {
        ArrayList<StructureDefinition> profiles = new ArrayList<StructureDefinition>();
        if (profile != null) {
            profiles.add(this.getSpecifiedProfile(profile));
        }
        this.validate(appContext, errors, element, profiles);
    }

    public void validate(Object appContext, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, List<StructureDefinition> profiles) throws FHIRException {
        this.fetchCache.clear();
        this.fetchCache.put(element.fhirType() + "/" + element.getIdBase(), element);
        this.resourceTracker.clear();
        this.trackedMessages.clear();
        this.messagesToRemove.clear();
        this.executionId = UUID.randomUUID().toString();
        this.baseOnly = profiles.isEmpty();
        InstanceValidator.setParents(element);
        long t = System.nanoTime();
        if (profiles == null || profiles.isEmpty()) {
            this.validateResource(new ValidatorHostContext(appContext, element), errors, element, element, null, this.resourceIdRule, new NodeStack(this.context, element, this.validationLanguage).resetIds());
        } else {
            for (StructureDefinition defn : profiles) {
                this.validateResource(new ValidatorHostContext(appContext, element), errors, element, element, defn, this.resourceIdRule, new NodeStack(this.context, element, this.validationLanguage).resetIds());
            }
        }
        if (this.hintAboutNonMustSupport) {
            this.checkElementUsage(errors, element, new NodeStack(this.context, element, this.validationLanguage));
        }
        errors.removeAll(this.messagesToRemove);
        this.timeTracker.overall(t);
    }

    private void checkElementUsage(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack) {
        String elementUsage = element.getUserString("elementSupported");
        this.hint(errors, ValidationMessage.IssueType.INFORMATIONAL, element.line(), element.col(), stack.getLiteralPath(), elementUsage == null || elementUsage.equals("Y"), "MustSupport_VAL_MustSupport", element.getName(), element.getProperty().getStructure().getUrl());
        if (element.hasChildren()) {
            String prevName = "";
            int elementCount = 0;
            for (org.hl7.fhir.r5.elementmodel.Element ce : element.getChildren()) {
                if (ce.getName().equals(prevName)) {
                    ++elementCount;
                } else {
                    elementCount = 1;
                    prevName = ce.getName();
                }
                this.checkElementUsage(errors, ce, stack.push(ce, elementCount, null, null));
            }
        }
    }

    private boolean check(String v1, String v2) {
        return v1 == null ? Utilities.noString((String)v1) : v1.equals(v2);
    }

    private void checkAddress(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, Address fixed, String fixedSource, boolean pattern) {
        this.checkFixedValue(errors, path + ".use", focus.getNamedChild("use"), (org.hl7.fhir.r5.model.Element)fixed.getUseElement(), fixedSource, "use", focus, pattern);
        this.checkFixedValue(errors, path + ".text", focus.getNamedChild("text"), (org.hl7.fhir.r5.model.Element)fixed.getTextElement(), fixedSource, "text", focus, pattern);
        this.checkFixedValue(errors, path + ".city", focus.getNamedChild("city"), (org.hl7.fhir.r5.model.Element)fixed.getCityElement(), fixedSource, "city", focus, pattern);
        this.checkFixedValue(errors, path + ".state", focus.getNamedChild("state"), (org.hl7.fhir.r5.model.Element)fixed.getStateElement(), fixedSource, "state", focus, pattern);
        this.checkFixedValue(errors, path + ".country", focus.getNamedChild("country"), (org.hl7.fhir.r5.model.Element)fixed.getCountryElement(), fixedSource, "country", focus, pattern);
        this.checkFixedValue(errors, path + ".zip", focus.getNamedChild("zip"), (org.hl7.fhir.r5.model.Element)fixed.getPostalCodeElement(), fixedSource, "postalCode", focus, pattern);
        ArrayList lines = new ArrayList();
        focus.getNamedChildren("line", lines);
        if (this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, lines.size() == fixed.getLine().size(), "Fixed_Type_Checks_DT_Address_Line", Integer.toString(fixed.getLine().size()), Integer.toString(lines.size()))) {
            for (int i = 0; i < lines.size(); ++i) {
                this.checkFixedValue(errors, path + ".coding", (org.hl7.fhir.r5.elementmodel.Element)lines.get(i), (org.hl7.fhir.r5.model.Element)fixed.getLine().get(i), fixedSource, "coding", focus, pattern);
            }
        }
    }

    private void checkAttachment(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, Attachment fixed, String fixedSource, boolean pattern) {
        this.checkFixedValue(errors, path + ".contentType", focus.getNamedChild("contentType"), (org.hl7.fhir.r5.model.Element)fixed.getContentTypeElement(), fixedSource, "contentType", focus, pattern);
        this.checkFixedValue(errors, path + ".language", focus.getNamedChild("language"), (org.hl7.fhir.r5.model.Element)fixed.getLanguageElement(), fixedSource, "language", focus, pattern);
        this.checkFixedValue(errors, path + ".data", focus.getNamedChild("data"), (org.hl7.fhir.r5.model.Element)fixed.getDataElement(), fixedSource, "data", focus, pattern);
        this.checkFixedValue(errors, path + ".url", focus.getNamedChild("url"), (org.hl7.fhir.r5.model.Element)fixed.getUrlElement(), fixedSource, "url", focus, pattern);
        this.checkFixedValue(errors, path + ".size", focus.getNamedChild("size"), (org.hl7.fhir.r5.model.Element)fixed.getSizeElement(), fixedSource, "size", focus, pattern);
        this.checkFixedValue(errors, path + ".hash", focus.getNamedChild("hash"), (org.hl7.fhir.r5.model.Element)fixed.getHashElement(), fixedSource, "hash", focus, pattern);
        this.checkFixedValue(errors, path + ".title", focus.getNamedChild("title"), (org.hl7.fhir.r5.model.Element)fixed.getTitleElement(), fixedSource, "title", focus, pattern);
    }

    private boolean checkCode(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, String path, String code, String system, String display, boolean checkDisplay, NodeStack stack) throws TerminologyServiceException {
        long t = System.nanoTime();
        boolean ss = this.context.supportsSystem(system);
        this.timeTracker.tx(t);
        if (ss) {
            t = System.nanoTime();
            IWorkerContext.ValidationResult s = this.checkCodeOnServer(stack, code, system, display, checkDisplay);
            this.timeTracker.tx(t);
            if (s == null) {
                return true;
            }
            if (s.isOk()) {
                if (s.getMessage() != null) {
                    this.txWarning(errors, s.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, s == null, "Terminology_PassThrough_TX_Message", s.getMessage(), system, code);
                }
                return true;
            }
            if (s.getErrorClass() != null && s.getErrorClass().isInfrastructure()) {
                this.txWarning(errors, s.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, s == null, s.getMessage(), new Object[0]);
            } else if (s.getSeverity() == ValidationMessage.IssueSeverity.INFORMATION) {
                this.txHint(errors, s.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, s == null, s.getMessage(), new Object[0]);
            } else if (s.getSeverity() == ValidationMessage.IssueSeverity.WARNING) {
                this.txWarning(errors, s.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, s == null, s.getMessage(), new Object[0]);
            } else {
                return this.txRule(errors, s.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, s == null, "Terminology_PassThrough_TX_Message", s.getMessage(), system, code);
            }
            return true;
        }
        if (system.startsWith("http://build.fhir.org") || system.startsWith("https://build.fhir.org")) {
            this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "TERMINOLOGY_TX_SYSTEM_WRONG_BUILD", system, this.suggestSystemForBuild(system));
            return false;
        }
        if (system.startsWith("http://hl7.org/fhir") || system.startsWith("https://hl7.org/fhir") || system.startsWith("http://www.hl7.org/fhir") || system.startsWith("https://www.hl7.org/fhir")) {
            if (Utilities.existsInList((String)system, (String[])new String[]{"http://hl7.org/fhir/sid/icd-10", "http://hl7.org/fhir/sid/cvx", "http://hl7.org/fhir/sid/icd-10", "http://hl7.org/fhir/sid/icd-10-cm", "http://hl7.org/fhir/sid/icd-9-cm", "http://hl7.org/fhir/sid/icd-9", "http://hl7.org/fhir/sid/ndc", "http://hl7.org/fhir/sid/srt"})) {
                return true;
            }
            if (system.startsWith("http://hl7.org/fhir/test")) {
                return true;
            }
            if (system.endsWith(".html")) {
                this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "TERMINOLOGY_TX_SYSTEM_WRONG_HTML", system, this.suggestSystemForPage(system));
                return false;
            }
            CodeSystem cs = this.getCodeSystem(system);
            if (this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, cs != null, "Terminology_TX_System_Unknown", system)) {
                CodeSystem.ConceptDefinitionComponent def = this.getCodeDefinition(cs, code);
                if (this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, def != null, "Terminology_TX_Code_Unknown", system, code)) {
                    return this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, display == null || display.equals(def.getDisplay()), "Terminology_TX_Display_Wrong", def.getDisplay());
                }
            }
            return false;
        }
        if (this.context.isNoTerminologyServer() && Utilities.existsInList((String)system, (String[])new String[]{"http://loinc.org", "http://unitsofmeasure.org", "http://hl7.org/fhir/sid/icd-9-cm", "http://snomed.info/sct", "http://www.nlm.nih.gov/research/umls/rxnorm"})) {
            return true;
        }
        if (this.startsWithButIsNot(system, "http://snomed.info/sct", "http://loinc.org", "http://unitsofmeasure.org", "http://www.nlm.nih.gov/research/umls/rxnorm")) {
            this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_System_Invalid", system);
            return false;
        }
        try {
            String ns;
            CodeSystem cs;
            if (this.context.fetchResourceWithException(ValueSet.class, system) != null) {
                this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_System_ValueSet", system);
            }
            boolean done = false;
            if (system.startsWith("https:") && system.length() > 7 && ((cs = this.getCodeSystem(ns = "http:" + system.substring(6))) != null || Utilities.existsInList((String)system, (String[])new String[]{"https://loinc.org", "https://unitsofmeasure.org", "https://snomed.info/sct", "https://www.nlm.nih.gov/research/umls/rxnorm"}))) {
                this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "TERMINOLOGY_TX_SYSTEM_HTTPS", system);
                done = true;
            }
            this.hint(errors, ValidationMessage.IssueType.UNKNOWN, element.line(), element.col(), path, done, "Terminology_TX_System_NotKnown", system);
            return true;
        }
        catch (Exception e) {
            return true;
        }
    }

    private Object suggestSystemForPage(String system) {
        if (system.contains("/codesystem-")) {
            String s = system.substring(system.indexOf("/codesystem-") + 12);
            String url = "http://hl7.org/fhir/" + s.replace(".html", "");
            if (this.context.fetchCodeSystem(url) != null) {
                return url;
            }
            return "{unable to determine intended url}";
        }
        if (system.contains("/valueset-")) {
            String s = system.substring(system.indexOf("/valueset-") + 8);
            String url = "http://hl7.org/fhir/" + s.replace(".html", "");
            if (this.context.fetchCodeSystem(url) != null) {
                return url;
            }
            return "{unable to determine intended url}";
        }
        return "{unable to determine intended url}";
    }

    private Object suggestSystemForBuild(String system) {
        if (system.contains("/codesystem-")) {
            String s = system.substring(system.indexOf("/codesystem-") + 12);
            String url = "http://hl7.org/fhir/" + s.replace(".html", "");
            if (this.context.fetchCodeSystem(url) != null) {
                return url;
            }
            return "{unable to determine intended url}";
        }
        if (system.contains("/valueset-")) {
            String s = system.substring(system.indexOf("/valueset-") + 8);
            String url = "http://hl7.org/fhir/" + s.replace(".html", "");
            if (this.context.fetchCodeSystem(url) != null) {
                return url;
            }
            return "{unable to determine intended url}";
        }
        if ((system = system.replace("https://", "http://")).length() < 22) {
            return "{unable to determine intended url}";
        }
        system = "http://hl7.org/fhir/" + system.substring(22).replace(".html", "");
        if (this.context.fetchCodeSystem(system) != null) {
            return system;
        }
        return "{unable to determine intended url}";
    }

    private boolean startsWithButIsNot(String system, String ... uri) {
        for (String s : uri) {
            if (system.equals(s) || !system.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    private boolean hasErrors(List<ValidationMessage> errors) {
        if (errors != null) {
            for (ValidationMessage vm : errors) {
                if (vm.getLevel() != ValidationMessage.IssueSeverity.FATAL && vm.getLevel() != ValidationMessage.IssueSeverity.ERROR) continue;
                return true;
            }
        }
        return false;
    }

    private void checkCodeableConcept(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, CodeableConcept fixed, String fixedSource, boolean pattern) {
        block7: {
            ArrayList codings;
            block6: {
                this.checkFixedValue(errors, path + ".text", focus.getNamedChild("text"), (org.hl7.fhir.r5.model.Element)fixed.getTextElement(), fixedSource, "text", focus, pattern);
                codings = new ArrayList();
                focus.getNamedChildren("coding", codings);
                if (!pattern) break block6;
                if (!this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, codings.size() >= fixed.getCoding().size(), "Terminology_TX_Coding_Count", Integer.toString(fixed.getCoding().size()), Integer.toString(codings.size()))) break block7;
                for (int i = 0; i < fixed.getCoding().size(); ++i) {
                    Coding fixedCoding = (Coding)fixed.getCoding().get(i);
                    boolean found = false;
                    ArrayList allErrorsFixed = new ArrayList();
                    for (int j = 0; j < codings.size() && !found; ++j) {
                        ArrayList<ValidationMessage> errorsFixed = new ArrayList<ValidationMessage>();
                        this.checkFixedValue(errorsFixed, path + ".coding", (org.hl7.fhir.r5.elementmodel.Element)codings.get(j), (org.hl7.fhir.r5.model.Element)fixedCoding, fixedSource, "coding", focus, pattern);
                        if (!this.hasErrors(errorsFixed)) {
                            found = true;
                            continue;
                        }
                        errorsFixed.stream().filter(t -> t.getLevel().ordinal() >= ValidationMessage.IssueSeverity.ERROR.ordinal()).forEach(t -> allErrorsFixed.add(t));
                    }
                    if (found) continue;
                    if (fixedCoding.hasUserSelected()) {
                        this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, false, pattern ? "TYPE_CHECKS_PATTERN_CC_US" : "TYPE_CHECKS_FIXED_CC_US", fixedCoding.getSystemElement().asStringValue(), fixedCoding.getCodeElement().asStringValue(), fixedCoding.getDisplayElement().asStringValue(), fixedSource, allErrorsFixed, fixedCoding.getUserSelected());
                        continue;
                    }
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, false, pattern ? "TYPE_CHECKS_PATTERN_CC" : "TYPE_CHECKS_FIXED_CC", fixedCoding.getSystemElement().asStringValue(), fixedCoding.getCodeElement().asStringValue(), fixedCoding.getDisplayElement().asStringValue(), fixedSource, allErrorsFixed);
                }
                break block7;
            }
            if (this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, codings.size() == fixed.getCoding().size(), "Terminology_TX_Coding_Count", Integer.toString(fixed.getCoding().size()), Integer.toString(codings.size()))) {
                for (int i = 0; i < codings.size(); ++i) {
                    this.checkFixedValue(errors, path + ".coding", (org.hl7.fhir.r5.elementmodel.Element)codings.get(i), (org.hl7.fhir.r5.model.Element)fixed.getCoding().get(i), fixedSource, "coding", focus, false);
                }
            }
        }
    }

    private boolean checkCodeableConcept(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition profile, ElementDefinition theElementCntext, NodeStack stack) {
        boolean res = true;
        if (!this.noTerminologyChecks && theElementCntext != null && theElementCntext.hasBinding()) {
            ElementDefinition.ElementDefinitionBindingComponent binding = theElementCntext.getBinding();
            if (this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, binding != null, "Terminology_TX_Binding_Missing", path)) {
                if (binding.hasValueSet()) {
                    ValueSet valueset = this.resolveBindingReference((DomainResource)profile, binding.getValueSet(), profile.getUrl());
                    if (this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, valueset != null, "Terminology_TX_ValueSet_NotFound", this.describeReference(binding.getValueSet()))) {
                        try {
                            CodeableConcept cc = ObjectConverter.readAsCodeableConcept((org.hl7.fhir.r5.elementmodel.Element)element);
                            if (!cc.hasCoding()) {
                                if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                                    this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Code_ValueSet", this.describeReference(binding.getValueSet()), valueset.getUrl());
                                } else if (binding.getStrength() == Enumerations.BindingStrength.EXTENSIBLE) {
                                    if (binding.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")) {
                                        this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Code_ValueSetMax", this.describeReference(ToolingExtensions.readStringExtension((org.hl7.fhir.r5.model.Element)binding, (String)"http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")), valueset.getUrl());
                                    } else {
                                        this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Code_ValueSet_Ext", this.describeReference(binding.getValueSet()), valueset.getUrl());
                                    }
                                }
                            } else {
                                long t = System.nanoTime();
                                boolean bindingsOk = true;
                                if (binding.getStrength() != Enumerations.BindingStrength.EXAMPLE) {
                                    if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                                        this.removeTrackedMessagesForLocation(errors, element, path);
                                    }
                                    boolean atLeastOneSystemIsSupported = false;
                                    for (Coding nextCoding : cc.getCoding()) {
                                        String nextSystem = nextCoding.getSystem();
                                        if (!StringUtils.isNotBlank((CharSequence)nextSystem) || !this.context.supportsSystem(nextSystem)) continue;
                                        atLeastOneSystemIsSupported = true;
                                        break;
                                    }
                                    if (atLeastOneSystemIsSupported || binding.getStrength() != Enumerations.BindingStrength.EXAMPLE) {
                                        IWorkerContext.ValidationResult vr = this.checkCodeOnServer(stack, valueset, cc, true);
                                        if (!vr.isOk()) {
                                            bindingsOk = false;
                                            if (vr.getErrorClass() != null && vr.getErrorClass() == ValueSetExpander.TerminologyServiceErrorClass.NOSERVICE) {
                                                if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED || binding.getStrength() == Enumerations.BindingStrength.EXTENSIBLE && binding.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")) {
                                                    this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "TERMINOLOGY_TX_NOSVC_BOUND_REQ", this.describeReference(binding.getValueSet()));
                                                } else if (binding.getStrength() == Enumerations.BindingStrength.EXTENSIBLE) {
                                                    this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "TERMINOLOGY_TX_NOSVC_BOUND_EXT", this.describeReference(binding.getValueSet()));
                                                }
                                            } else if (vr.getErrorClass() != null && vr.getErrorClass().isInfrastructure()) {
                                                if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                                                    this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Confirm_1_CC", this.describeReference(binding.getValueSet()), vr.getErrorClass().toString());
                                                } else if (binding.getStrength() == Enumerations.BindingStrength.EXTENSIBLE) {
                                                    if (binding.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")) {
                                                        this.checkMaxValueSet(errors, path, element, profile, ToolingExtensions.readStringExtension((org.hl7.fhir.r5.model.Element)binding, (String)"http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet"), cc, stack);
                                                    } else if (!this.noExtensibleWarnings) {
                                                        this.txWarningForLaterRemoval(element, errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Confirm_2_CC", this.describeReference(binding.getValueSet()), vr.getErrorClass().toString());
                                                    }
                                                } else if (binding.getStrength() == Enumerations.BindingStrength.PREFERRED && this.baseOnly) {
                                                    this.txHint(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Confirm_3_CC", this.describeReference(binding.getValueSet()), vr.getErrorClass().toString());
                                                }
                                            } else if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                                                this.txRule(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_1_CC", this.describeReference(binding.getValueSet()), valueset.getUrl(), this.ccSummary(cc));
                                            } else if (binding.getStrength() == Enumerations.BindingStrength.EXTENSIBLE) {
                                                if (binding.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")) {
                                                    this.checkMaxValueSet(errors, path, element, profile, ToolingExtensions.readStringExtension((org.hl7.fhir.r5.model.Element)binding, (String)"http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet"), cc, stack);
                                                }
                                                if (!this.noExtensibleWarnings) {
                                                    this.txWarningForLaterRemoval(element, errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_2_CC", this.describeReference(binding.getValueSet()), valueset.getUrl(), this.ccSummary(cc));
                                                }
                                            } else if (binding.getStrength() == Enumerations.BindingStrength.PREFERRED && this.baseOnly) {
                                                this.txHint(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_3_CC", this.describeReference(binding.getValueSet()), valueset.getUrl(), this.ccSummary(cc));
                                            }
                                        } else if (vr.getMessage() != null) {
                                            res = false;
                                            this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, vr.getMessage(), new Object[0]);
                                        } else {
                                            res = false;
                                        }
                                    }
                                    if (bindingsOk) {
                                        for (Coding nextCoding : cc.getCoding()) {
                                            this.checkBindings(errors, path, element, stack, valueset, nextCoding);
                                        }
                                    }
                                    this.timeTracker.tx(t);
                                }
                            }
                        }
                        catch (Exception e) {
                            this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Error_CodeableConcept", e.getMessage());
                        }
                    }
                } else if (binding.hasValueSet()) {
                    this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Binding_CantCheck");
                } else if (!this.noBindingMsgSuppressed) {
                    this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Binding_NoSource", path);
                }
            }
        }
        return res;
    }

    public void checkBindings(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack, ValueSet valueset, Coding nextCoding) {
        IWorkerContext.ValidationResult vr;
        if (StringUtils.isNotBlank((CharSequence)nextCoding.getCode()) && StringUtils.isNotBlank((CharSequence)nextCoding.getSystem()) && this.context.supportsSystem(nextCoding.getSystem()) && (vr = this.checkCodeOnServer(stack, valueset, nextCoding, false)).getSeverity() != null) {
            if (vr.getSeverity() == ValidationMessage.IssueSeverity.INFORMATION) {
                this.txHint(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, vr.getMessage(), new Object[0]);
            } else if (vr.getSeverity() == ValidationMessage.IssueSeverity.WARNING) {
                this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, vr.getMessage(), new Object[0]);
            } else {
                this.txRule(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, vr.getMessage(), new Object[0]);
            }
        }
    }

    private boolean checkTerminologyCodeableConcept(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition profile, ElementDefinition theElementCntext, NodeStack stack, StructureDefinition logical) {
        boolean res = true;
        if (!this.noTerminologyChecks && theElementCntext != null && theElementCntext.hasBinding()) {
            ElementDefinition.ElementDefinitionBindingComponent binding = theElementCntext.getBinding();
            if (this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, binding != null, "Terminology_TX_Binding_Missing", path)) {
                if (binding.hasValueSet()) {
                    ValueSet valueset = this.resolveBindingReference((DomainResource)profile, binding.getValueSet(), profile.getUrl());
                    if (this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, valueset != null, "Terminology_TX_ValueSet_NotFound", this.describeReference(binding.getValueSet()))) {
                        try {
                            CodeableConcept cc = this.convertToCodeableConcept(element, logical);
                            if (!cc.hasCoding()) {
                                if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                                    this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "No code provided, and a code is required from the value set " + this.describeReference(binding.getValueSet()) + " (" + valueset.getUrl(), new Object[0]);
                                } else if (binding.getStrength() == Enumerations.BindingStrength.EXTENSIBLE) {
                                    if (binding.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")) {
                                        this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Code_ValueSetMax", this.describeReference(ToolingExtensions.readStringExtension((org.hl7.fhir.r5.model.Element)binding, (String)"http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")), valueset.getUrl());
                                    } else {
                                        this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Code_ValueSet_Ext", this.describeReference(binding.getValueSet()), valueset.getUrl());
                                    }
                                }
                            } else {
                                long t = System.nanoTime();
                                boolean bindingsOk = true;
                                if (binding.getStrength() != Enumerations.BindingStrength.EXAMPLE) {
                                    if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                                        this.removeTrackedMessagesForLocation(errors, element, path);
                                    }
                                    boolean atLeastOneSystemIsSupported = false;
                                    for (Coding nextCoding : cc.getCoding()) {
                                        String nextSystem = nextCoding.getSystem();
                                        if (!StringUtils.isNotBlank((CharSequence)nextSystem) || !this.context.supportsSystem(nextSystem)) continue;
                                        atLeastOneSystemIsSupported = true;
                                        break;
                                    }
                                    if (atLeastOneSystemIsSupported || binding.getStrength() != Enumerations.BindingStrength.EXAMPLE) {
                                        IWorkerContext.ValidationResult vr = this.checkCodeOnServer(stack, valueset, cc, false);
                                        if (!vr.isOk()) {
                                            bindingsOk = false;
                                            if (vr.getErrorClass() != null && vr.getErrorClass().isInfrastructure()) {
                                                if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                                                    this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Confirm_1_CC", this.describeReference(binding.getValueSet()), vr.getErrorClass().toString());
                                                } else if (binding.getStrength() == Enumerations.BindingStrength.EXTENSIBLE) {
                                                    if (binding.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")) {
                                                        this.checkMaxValueSet(errors, path, element, profile, ToolingExtensions.readStringExtension((org.hl7.fhir.r5.model.Element)binding, (String)"http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet"), cc, stack);
                                                    } else if (!this.noExtensibleWarnings) {
                                                        this.txWarningForLaterRemoval(element, errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Confirm_2_CC", this.describeReference(binding.getValueSet()), vr.getErrorClass().toString());
                                                    }
                                                } else if (binding.getStrength() == Enumerations.BindingStrength.PREFERRED && this.baseOnly) {
                                                    this.txHint(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Confirm_3_CC", this.describeReference(binding.getValueSet()), vr.getErrorClass().toString());
                                                }
                                            } else if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                                                this.txRule(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_1_CC", this.describeReference(binding.getValueSet()), valueset.getUrl(), this.ccSummary(cc));
                                            } else if (binding.getStrength() == Enumerations.BindingStrength.EXTENSIBLE) {
                                                if (binding.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")) {
                                                    this.checkMaxValueSet(errors, path, element, profile, ToolingExtensions.readStringExtension((org.hl7.fhir.r5.model.Element)binding, (String)"http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet"), cc, stack);
                                                }
                                                if (!this.noExtensibleWarnings) {
                                                    this.txWarningForLaterRemoval(element, errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_2_CC", this.describeReference(binding.getValueSet()), valueset.getUrl(), this.ccSummary(cc));
                                                }
                                            } else if (binding.getStrength() == Enumerations.BindingStrength.PREFERRED && this.baseOnly) {
                                                this.txHint(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_3_CC", this.describeReference(binding.getValueSet()), valueset.getUrl(), this.ccSummary(cc));
                                            }
                                        } else if (vr.getMessage() != null) {
                                            res = false;
                                            this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, vr.getMessage(), new Object[0]);
                                        } else {
                                            res = false;
                                        }
                                    }
                                    if (bindingsOk) {
                                        for (Coding nextCoding : cc.getCoding()) {
                                            IWorkerContext.ValidationResult vr;
                                            String nextCode = nextCoding.getCode();
                                            String nextSystem = nextCoding.getSystem();
                                            if (!StringUtils.isNotBlank((CharSequence)nextCode) || !StringUtils.isNotBlank((CharSequence)nextSystem) || !this.context.supportsSystem(nextSystem) || (vr = this.checkCodeOnServer(stack, nextCode, nextSystem, null, false)).isOk()) continue;
                                            this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Code_NotValid", nextCode, nextSystem);
                                        }
                                    }
                                    this.timeTracker.tx(t);
                                }
                            }
                        }
                        catch (Exception e) {
                            this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Error_CodeableConcept", e.getMessage());
                        }
                        if (this.getMapping("http://hl7.org/fhir/terminology-pattern", logical, logical.getSnapshot().getElementFirstRep()).contains("Coding")) {
                            this.checkTerminologyCoding(errors, path, element, profile, theElementCntext, true, true, stack, logical);
                        }
                    }
                } else if (binding.hasValueSet()) {
                    this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Binding_CantCheck");
                } else if (!this.noBindingMsgSuppressed) {
                    this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Binding_NoSource", path);
                }
            }
        }
        return res;
    }

    private void checkTerminologyCoding(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition profile, ElementDefinition theElementCntext, boolean inCodeableConcept, boolean checkDisplay, NodeStack stack, StructureDefinition logical) {
        block31: {
            Coding c = this.convertToCoding(element, logical);
            String code = c.getCode();
            String system = c.getSystem();
            String display = c.getDisplay();
            this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, this.isAbsolute(system), "Terminology_TX_System_Relative", new Object[0]);
            if (system != null && code != null && !this.noTerminologyChecks) {
                this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, !this.isValueSet(system), "Terminology_TX_System_ValueSet2", system);
                try {
                    if (!this.checkCode(errors, element, path, code, system, display, checkDisplay, stack) || theElementCntext == null || !theElementCntext.hasBinding()) break block31;
                    ElementDefinition.ElementDefinitionBindingComponent binding = theElementCntext.getBinding();
                    if (!this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, binding != null, "Terminology_TX_Binding_Missing2", path)) break block31;
                    if (binding.hasValueSet()) {
                        ValueSet valueset = this.resolveBindingReference((DomainResource)profile, binding.getValueSet(), profile.getUrl());
                        if (!this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, valueset != null, "Terminology_TX_ValueSet_NotFound", this.describeReference(binding.getValueSet()))) break block31;
                        try {
                            long t = System.nanoTime();
                            IWorkerContext.ValidationResult vr = null;
                            if (binding.getStrength() != Enumerations.BindingStrength.EXAMPLE) {
                                vr = this.checkCodeOnServer(stack, valueset, c, true);
                            }
                            if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                                this.removeTrackedMessagesForLocation(errors, element, path);
                            }
                            this.timeTracker.tx(t);
                            if (vr != null && !vr.isOk()) {
                                if (vr.IsNoService()) {
                                    this.txHint(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Binding_NoServer", new Object[0]);
                                } else if (vr.getErrorClass() != null && vr.getErrorClass().isInfrastructure()) {
                                    if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                                        this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Confirm_4a", this.describeReference(binding.getValueSet(), (CanonicalResource)valueset), vr.getMessage(), system + "#" + code);
                                    } else if (binding.getStrength() == Enumerations.BindingStrength.EXTENSIBLE) {
                                        if (binding.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")) {
                                            this.checkMaxValueSet(errors, path, element, profile, ToolingExtensions.readStringExtension((org.hl7.fhir.r5.model.Element)binding, (String)"http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet"), c, stack);
                                        } else if (!this.noExtensibleWarnings) {
                                            this.txWarningForLaterRemoval(element, errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Confirm_5", this.describeReference(binding.getValueSet(), (CanonicalResource)valueset));
                                        }
                                    } else if (binding.getStrength() == Enumerations.BindingStrength.PREFERRED && this.baseOnly) {
                                        this.txHint(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Confirm_6", this.describeReference(binding.getValueSet(), (CanonicalResource)valueset));
                                    }
                                } else if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                                    this.txRule(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_4", this.describeReference(binding.getValueSet(), (CanonicalResource)valueset), vr.getMessage() != null ? " (error message = " + vr.getMessage() + ")" : "", system + "#" + code);
                                } else if (binding.getStrength() == Enumerations.BindingStrength.EXTENSIBLE) {
                                    if (binding.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")) {
                                        this.checkMaxValueSet(errors, path, element, profile, ToolingExtensions.readStringExtension((org.hl7.fhir.r5.model.Element)binding, (String)"http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet"), c, stack);
                                    } else {
                                        this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_5", this.describeReference(binding.getValueSet(), (CanonicalResource)valueset), vr.getMessage() != null ? " (error message = " + vr.getMessage() + ")" : "", system + "#" + code);
                                    }
                                } else if (binding.getStrength() == Enumerations.BindingStrength.PREFERRED && this.baseOnly) {
                                    this.txHint(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_6", this.describeReference(binding.getValueSet(), (CanonicalResource)valueset), vr.getMessage() != null ? " (error message = " + vr.getMessage() + ")" : "", system + "#" + code);
                                }
                            }
                            break block31;
                        }
                        catch (Exception e) {
                            this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Error_Coding1", e.getMessage());
                        }
                        break block31;
                    }
                    if (binding.hasValueSet()) {
                        this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Binding_CantCheck");
                    } else if (!inCodeableConcept && !this.noBindingMsgSuppressed) {
                        this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Binding_NoSource", path);
                    }
                }
                catch (Exception e) {
                    this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Error_Coding2", e.getMessage(), e.toString());
                }
            }
        }
    }

    private CodeableConcept convertToCodeableConcept(org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition logical) {
        CodeableConcept res = new CodeableConcept();
        for (ElementDefinition ed : logical.getSnapshot().getElement()) {
            if (Utilities.charCount((String)ed.getPath(), (char)'.') != 1) continue;
            List<String> maps = this.getMapping("http://hl7.org/fhir/terminology-pattern", logical, ed);
            for (String m : maps) {
                String name = this.tail(ed.getPath());
                ArrayList list = new ArrayList();
                element.getNamedChildren(name, list);
                if (list.isEmpty()) continue;
                if ("Coding.code".equals(m)) {
                    res.getCodingFirstRep().setCode(((org.hl7.fhir.r5.elementmodel.Element)list.get(0)).primitiveValue());
                    continue;
                }
                if ("Coding.system[fmt:OID]".equals(m)) {
                    String oid = ((org.hl7.fhir.r5.elementmodel.Element)list.get(0)).primitiveValue();
                    String url = this.context.oid2Uri(oid);
                    if (url != null) {
                        res.getCodingFirstRep().setSystem(url);
                        continue;
                    }
                    res.getCodingFirstRep().setSystem("urn:oid:" + oid);
                    continue;
                }
                if ("Coding.version".equals(m)) {
                    res.getCodingFirstRep().setVersion(((org.hl7.fhir.r5.elementmodel.Element)list.get(0)).primitiveValue());
                    continue;
                }
                if ("Coding.display".equals(m)) {
                    res.getCodingFirstRep().setDisplay(((org.hl7.fhir.r5.elementmodel.Element)list.get(0)).primitiveValue());
                    continue;
                }
                if ("CodeableConcept.text".equals(m)) {
                    res.setText(((org.hl7.fhir.r5.elementmodel.Element)list.get(0)).primitiveValue());
                    continue;
                }
                if (!"CodeableConcept.coding".equals(m)) continue;
                StructureDefinition c = this.context.fetchTypeDefinition(ed.getTypeFirstRep().getCode());
                for (org.hl7.fhir.r5.elementmodel.Element e : list) {
                    res.addCoding(this.convertToCoding(e, c));
                }
            }
        }
        return res;
    }

    private Coding convertToCoding(org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition logical) {
        Coding res = new Coding();
        for (ElementDefinition ed : logical.getSnapshot().getElement()) {
            if (Utilities.charCount((String)ed.getPath(), (char)'.') != 1) continue;
            List<String> maps = this.getMapping("http://hl7.org/fhir/terminology-pattern", logical, ed);
            for (String m : maps) {
                String name = this.tail(ed.getPath());
                ArrayList list = new ArrayList();
                element.getNamedChildren(name, list);
                if (list.isEmpty()) continue;
                if ("Coding.code".equals(m)) {
                    res.setCode(((org.hl7.fhir.r5.elementmodel.Element)list.get(0)).primitiveValue());
                    continue;
                }
                if ("Coding.system[fmt:OID]".equals(m)) {
                    String oid = ((org.hl7.fhir.r5.elementmodel.Element)list.get(0)).primitiveValue();
                    String url = this.context.oid2Uri(oid);
                    if (url != null) {
                        res.setSystem(url);
                        continue;
                    }
                    res.setSystem("urn:oid:" + oid);
                    continue;
                }
                if ("Coding.version".equals(m)) {
                    res.setVersion(((org.hl7.fhir.r5.elementmodel.Element)list.get(0)).primitiveValue());
                    continue;
                }
                if (!"Coding.display".equals(m)) continue;
                res.setDisplay(((org.hl7.fhir.r5.elementmodel.Element)list.get(0)).primitiveValue());
            }
        }
        return res;
    }

    private void checkMaxValueSet(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition profile, String maxVSUrl, CodeableConcept cc, NodeStack stack) {
        ValueSet valueset = this.resolveBindingReference((DomainResource)profile, maxVSUrl, profile.getUrl());
        if (this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, valueset != null, "Terminology_TX_ValueSet_NotFound", this.describeReference(maxVSUrl))) {
            try {
                long t = System.nanoTime();
                IWorkerContext.ValidationResult vr = this.checkCodeOnServer(stack, valueset, cc, false);
                this.timeTracker.tx(t);
                if (!vr.isOk()) {
                    if (vr.getErrorClass() != null && vr.getErrorClass().isInfrastructure()) {
                        this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_7", this.describeReference(maxVSUrl), valueset.getUrl(), vr.getMessage());
                    } else {
                        this.txRule(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_8", this.describeReference(maxVSUrl), valueset.getUrl(), this.ccSummary(cc));
                    }
                }
            }
            catch (Exception e) {
                this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Error_CodeableConcept_Max", e.getMessage());
            }
        }
    }

    private void checkMaxValueSet(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition profile, String maxVSUrl, Coding c, NodeStack stack) {
        ValueSet valueset = this.resolveBindingReference((DomainResource)profile, maxVSUrl, profile.getUrl());
        if (this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, valueset != null, "Terminology_TX_ValueSet_NotFound", this.describeReference(maxVSUrl))) {
            try {
                long t = System.nanoTime();
                IWorkerContext.ValidationResult vr = this.checkCodeOnServer(stack, valueset, c, true);
                this.timeTracker.tx(t);
                if (!vr.isOk()) {
                    if (vr.getErrorClass() != null && vr.getErrorClass().isInfrastructure()) {
                        this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_9", this.describeReference(maxVSUrl), valueset.getUrl(), vr.getMessage());
                    } else {
                        this.txRule(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_10", this.describeReference(maxVSUrl), valueset.getUrl(), c.getSystem(), c.getCode());
                    }
                }
            }
            catch (Exception e) {
                this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Error_CodeableConcept_Max", e.getMessage());
            }
        }
    }

    private void checkMaxValueSet(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition profile, String maxVSUrl, String value, NodeStack stack) {
        ValueSet valueset = this.resolveBindingReference((DomainResource)profile, maxVSUrl, profile.getUrl());
        if (this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, valueset != null, "Terminology_TX_ValueSet_NotFound", this.describeReference(maxVSUrl))) {
            try {
                long t = System.nanoTime();
                IWorkerContext.ValidationResult vr = this.checkCodeOnServer(stack, valueset, value, new ValidationOptions(stack.getWorkingLang()));
                this.timeTracker.tx(t);
                if (!vr.isOk()) {
                    if (vr.getErrorClass() != null && vr.getErrorClass().isInfrastructure()) {
                        this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_9", this.describeReference(maxVSUrl), valueset.getUrl(), vr.getMessage());
                    } else {
                        this.txRule(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_11", this.describeReference(maxVSUrl), valueset.getUrl(), "), and a code from this value set is required) (code = " + value + "), (error = " + vr.getMessage() + ")");
                    }
                }
            }
            catch (Exception e) {
                this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Error_CodeableConcept_Max", e.getMessage());
            }
        }
    }

    private String ccSummary(CodeableConcept cc) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (Coding c : cc.getCoding()) {
            b.append(c.getSystem() + "#" + c.getCode());
        }
        return b.toString();
    }

    private void checkCoding(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, Coding fixed, String fixedSource, boolean pattern) {
        this.checkFixedValue(errors, path + ".system", focus.getNamedChild("system"), (org.hl7.fhir.r5.model.Element)fixed.getSystemElement(), fixedSource, "system", focus, pattern);
        this.checkFixedValue(errors, path + ".version", focus.getNamedChild("version"), (org.hl7.fhir.r5.model.Element)fixed.getVersionElement(), fixedSource, "version", focus, pattern);
        this.checkFixedValue(errors, path + ".code", focus.getNamedChild("code"), (org.hl7.fhir.r5.model.Element)fixed.getCodeElement(), fixedSource, "code", focus, pattern);
        this.checkFixedValue(errors, path + ".display", focus.getNamedChild("display"), (org.hl7.fhir.r5.model.Element)fixed.getDisplayElement(), fixedSource, "display", focus, pattern);
        this.checkFixedValue(errors, path + ".userSelected", focus.getNamedChild("userSelected"), (org.hl7.fhir.r5.model.Element)fixed.getUserSelectedElement(), fixedSource, "userSelected", focus, pattern);
    }

    private void checkCoding(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition profile, ElementDefinition theElementCntext, boolean inCodeableConcept, boolean checkDisplay, NodeStack stack) {
        String code = element.getNamedChildValue("code");
        String system = element.getNamedChildValue("system");
        String display = element.getNamedChildValue("display");
        this.checkCodedElement(errors, path, element, profile, theElementCntext, inCodeableConcept, checkDisplay, stack, code, system, display);
    }

    private void checkCodedElement(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition profile, ElementDefinition theElementCntext, boolean inCodeableConcept, boolean checkDisplay, NodeStack stack, String theCode, String theSystem, String theDisplay) {
        block32: {
            this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, this.isAbsolute(theSystem), "Terminology_TX_System_Relative", new Object[0]);
            this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, Utilities.noString((String)theCode) || !Utilities.noString((String)theSystem), "TERMINOLOGY_TX_SYSTEM_NO_CODE", new Object[0]);
            if (theSystem != null && theCode != null && !this.noTerminologyChecks) {
                this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, !this.isValueSet(theSystem), "Terminology_TX_System_ValueSet2", theSystem);
                try {
                    if (!this.checkCode(errors, element, path, theCode, theSystem, theDisplay, checkDisplay, stack) || theElementCntext == null || !theElementCntext.hasBinding()) break block32;
                    ElementDefinition.ElementDefinitionBindingComponent binding = theElementCntext.getBinding();
                    if (!this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, binding != null, "Terminology_TX_Binding_Missing2", path)) break block32;
                    if (binding.hasValueSet()) {
                        ValueSet valueset = this.resolveBindingReference((DomainResource)profile, binding.getValueSet(), profile.getUrl());
                        if (!this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, valueset != null, "Terminology_TX_ValueSet_NotFound", this.describeReference(binding.getValueSet()))) break block32;
                        try {
                            Coding c = ObjectConverter.readAsCoding((org.hl7.fhir.r5.elementmodel.Element)element);
                            long t = System.nanoTime();
                            IWorkerContext.ValidationResult vr = null;
                            if (binding.getStrength() != Enumerations.BindingStrength.EXAMPLE) {
                                vr = this.checkCodeOnServer(stack, valueset, c, true);
                            }
                            this.timeTracker.tx(t);
                            if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                                this.removeTrackedMessagesForLocation(errors, element, path);
                            }
                            if (vr != null && !vr.isOk()) {
                                if (vr.IsNoService()) {
                                    this.txHint(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Binding_NoServer", new Object[0]);
                                } else if (vr.getErrorClass() != null && !vr.getErrorClass().isInfrastructure()) {
                                    if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                                        this.txRule(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Confirm_4a", this.describeReference(binding.getValueSet(), (CanonicalResource)valueset), vr.getMessage(), theSystem + "#" + theCode);
                                    } else if (binding.getStrength() == Enumerations.BindingStrength.EXTENSIBLE) {
                                        if (binding.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")) {
                                            this.checkMaxValueSet(errors, path, element, profile, ToolingExtensions.readStringExtension((org.hl7.fhir.r5.model.Element)binding, (String)"http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet"), c, stack);
                                        } else if (!this.noExtensibleWarnings) {
                                            this.txWarningForLaterRemoval(element, errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Confirm_5", this.describeReference(binding.getValueSet(), (CanonicalResource)valueset));
                                        }
                                    } else if (binding.getStrength() == Enumerations.BindingStrength.PREFERRED && this.baseOnly) {
                                        this.txHint(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Confirm_6", this.describeReference(binding.getValueSet(), (CanonicalResource)valueset));
                                    }
                                } else if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                                    this.txRule(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_12", this.describeReference(binding.getValueSet(), (CanonicalResource)valueset), this.getErrorMessage(vr.getMessage()), theSystem + "#" + theCode);
                                } else if (binding.getStrength() == Enumerations.BindingStrength.EXTENSIBLE) {
                                    if (binding.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")) {
                                        this.checkMaxValueSet(errors, path, element, profile, ToolingExtensions.readStringExtension((org.hl7.fhir.r5.model.Element)binding, (String)"http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet"), c, stack);
                                    } else if (!this.noExtensibleWarnings) {
                                        this.txWarningForLaterRemoval(element, errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_13", this.describeReference(binding.getValueSet(), (CanonicalResource)valueset), this.getErrorMessage(vr.getMessage()), c.getSystem() + "#" + c.getCode());
                                    }
                                } else if (binding.getStrength() == Enumerations.BindingStrength.PREFERRED && this.baseOnly) {
                                    this.txHint(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_14", this.describeReference(binding.getValueSet(), (CanonicalResource)valueset), this.getErrorMessage(vr.getMessage()), theSystem + "#" + theCode);
                                }
                            }
                            break block32;
                        }
                        catch (Exception e) {
                            this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Error_Coding1", e.getMessage());
                        }
                        break block32;
                    }
                    if (binding.hasValueSet()) {
                        this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Binding_CantCheck");
                    } else if (!inCodeableConcept && !this.noBindingMsgSuppressed) {
                        this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Binding_NoSource", path);
                    }
                }
                catch (Exception e) {
                    this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Error_Coding2", e.getMessage(), e.toString());
                }
            }
        }
    }

    private boolean isValueSet(String url) {
        try {
            ValueSet vs = (ValueSet)this.context.fetchResourceWithException(ValueSet.class, url);
            return vs != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void checkContactPoint(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, ContactPoint fixed, String fixedSource, boolean pattern) {
        this.checkFixedValue(errors, path + ".system", focus.getNamedChild("system"), (org.hl7.fhir.r5.model.Element)fixed.getSystemElement(), fixedSource, "system", focus, pattern);
        this.checkFixedValue(errors, path + ".value", focus.getNamedChild("value"), (org.hl7.fhir.r5.model.Element)fixed.getValueElement(), fixedSource, "value", focus, pattern);
        this.checkFixedValue(errors, path + ".use", focus.getNamedChild("use"), (org.hl7.fhir.r5.model.Element)fixed.getUseElement(), fixedSource, "use", focus, pattern);
        this.checkFixedValue(errors, path + ".period", focus.getNamedChild("period"), (org.hl7.fhir.r5.model.Element)fixed.getPeriod(), fixedSource, "period", focus, pattern);
    }

    private StructureDefinition checkExtension(ValidatorHostContext hostContext, List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element container, org.hl7.fhir.r5.elementmodel.Element element, ElementDefinition def, StructureDefinition profile, NodeStack stack, NodeStack containerStack, String extensionUrl) throws FHIRException {
        String url = element.getNamedChildValue("url");
        boolean isModifier = element.getName().equals("modifierExtension");
        long t = System.nanoTime();
        StructureDefinition ex = Utilities.isAbsoluteUrl((String)url) ? (StructureDefinition)this.context.fetchResource(StructureDefinition.class, url) : null;
        this.timeTracker.sd(t);
        if (ex == null) {
            ex = this.getXverExt(errors, path, element, url);
        }
        if (ex == null) {
            if (extensionUrl != null && !this.isAbsolute(url)) {
                if (extensionUrl.equals(profile.getUrl())) {
                    this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path + "[url='" + url + "']", this.hasExtensionSlice(profile, url), "Extension_EXT_SubExtension_Invalid", url, profile.getUrl());
                }
            } else if (SpecialExtensions.isKnownExtension(url)) {
                ex = SpecialExtensions.getDefinition(url);
            } else if (this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, this.allowUnknownExtension(url), "Extension_EXT_Unknown_NotHere", url)) {
                this.hint(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, this.isKnownExtension(url), "Extension_EXT_Unknown", url);
            }
        }
        if (ex != null) {
            this.trackUsage(ex, hostContext, element);
            if (def.getIsModifier()) {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path + "[url='" + url + "']", ((ElementDefinition)ex.getSnapshot().getElement().get(0)).getIsModifier(), "Extension_EXT_Modifier_MismatchY", new Object[0]);
            } else {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path + "[url='" + url + "']", !((ElementDefinition)ex.getSnapshot().getElement().get(0)).getIsModifier(), "Extension_EXT_Modifier_MismatchN", new Object[0]);
            }
            this.checkExtensionContext(errors, resource, container, ex, containerStack, hostContext);
            if (isModifier) {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path + "[url='" + url + "']", ((ElementDefinition)ex.getSnapshot().getElement().get(0)).getIsModifier(), "Extension_EXT_Modifier_Y", url);
            } else {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path + "[url='" + url + "']", !((ElementDefinition)ex.getSnapshot().getElement().get(0)).getIsModifier(), "Extension_EXT_Modifier_N", url);
            }
            Set<String> allowedTypes = this.listExtensionTypes(ex);
            String actualType = this.getExtensionType(element);
            if (actualType == null) {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, allowedTypes.isEmpty(), "Extension_EXT_Simple", url);
            } else {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, allowedTypes.contains(actualType), "Extension_EXT_Type", url, allowedTypes.toString(), actualType);
            }
            this.validateElement(hostContext, errors, ex, (ElementDefinition)ex.getSnapshot().getElement().get(0), null, null, resource, element, "Extension", stack, false, true, url);
        }
        return ex;
    }

    private boolean hasExtensionSlice(StructureDefinition profile, String sliceName) {
        for (ElementDefinition ed : profile.getSnapshot().getElement()) {
            if (!ed.getPath().equals("Extension.extension.url") || !ed.hasFixed() || !sliceName.equals(ed.getFixed().primitiveValue())) continue;
            return true;
        }
        return false;
    }

    private String getExtensionType(org.hl7.fhir.r5.elementmodel.Element element) {
        for (org.hl7.fhir.r5.elementmodel.Element e : element.getChildren()) {
            if (!e.getName().startsWith("value")) continue;
            String tn = e.getName().substring(5);
            String ltn = Utilities.uncapitalize((String)tn);
            if (this.isPrimitiveType(ltn)) {
                return ltn;
            }
            return tn;
        }
        return null;
    }

    private Set<String> listExtensionTypes(StructureDefinition ex) {
        ElementDefinition vd = null;
        for (ElementDefinition ed : ex.getSnapshot().getElement()) {
            if (!ed.getPath().startsWith("Extension.value")) continue;
            vd = ed;
            break;
        }
        HashSet<String> res = new HashSet<String>();
        if (vd != null && !"0".equals(vd.getMax())) {
            for (ElementDefinition.TypeRefComponent tr : vd.getType()) {
                res.add(tr.getWorkingCode());
            }
        }
        return res;
    }

    private boolean checkExtensionContext(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element container, StructureDefinition definition, NodeStack stack, ValidatorHostContext hostContext) {
        String extUrl = definition.getUrl();
        boolean ok = false;
        CommaSeparatedStringBuilder contexts = new CommaSeparatedStringBuilder();
        ArrayList<String> plist = new ArrayList<String>();
        plist.add(this.stripIndexes(stack.getLiteralPath()));
        for (String s : stack.getLogicalPaths()) {
            String p = this.stripIndexes(s);
            if (Utilities.existsInList((String)p, (String[])new String[]{"ElementDefinition.example.value", "ElementDefinition.pattern", "ElementDefinition.fixed"})) {
                return true;
            }
            plist.add(p);
        }
        block1: for (StructureDefinition.StructureDefinitionContextComponent ctxt : this.fixContexts(extUrl, definition.getContext())) {
            if (ok) break;
            if (ctxt.getType() == StructureDefinition.ExtensionContextType.ELEMENT) {
                String en = ctxt.getExpression();
                contexts.append("e:" + en);
                if (Utilities.existsInList((String)en, (String[])new String[]{"Element", "Any"})) {
                    ok = true;
                } else if (en.equals("Resource") && container.isResource()) {
                    ok = true;
                }
                block2: for (String p : plist) {
                    if (ok) continue block1;
                    if (p.equals(en)) {
                        ok = true;
                        continue;
                    }
                    String pn = p;
                    String pt = "";
                    if (p.contains(".")) {
                        pn = p.substring(0, p.indexOf("."));
                        pt = p.substring(p.indexOf("."));
                    }
                    StructureDefinition sd = this.context.fetchTypeDefinition(pn);
                    while (sd != null) {
                        if ((sd.getType() + pt).equals(en)) {
                            ok = true;
                            continue block2;
                        }
                        if (sd.getBaseDefinition() != null) {
                            sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition());
                            continue;
                        }
                        sd = null;
                    }
                }
                continue;
            }
            if (ctxt.getType() == StructureDefinition.ExtensionContextType.EXTENSION) {
                contexts.append("x:" + ctxt.getExpression());
                NodeStack estack = stack.getParent();
                if (estack == null || !estack.getElement().fhirType().equals("Extension")) continue;
                String ext = estack.getElement().getNamedChildValue("url");
                if (!ctxt.getExpression().equals(ext)) continue;
                ok = true;
                continue;
            }
            if (ctxt.getType() == StructureDefinition.ExtensionContextType.FHIRPATH) {
                contexts.append("p:" + ctxt.getExpression());
                List res = this.fpe.evaluate((Object)hostContext, (Base)resource, (Base)hostContext.getRootResource(), (Base)resource, this.fpe.parse(ctxt.getExpression()));
                if (!res.contains(container)) continue;
                ok = true;
                continue;
            }
            throw new Error(this.context.formatMessage("Unrecognised_extension_context_", new Object[]{ctxt.getTypeElement().asStringValue()}));
        }
        if (!ok) {
            if (definition.hasUserData("XVER_EXT_MARKER")) {
                this.warning(errors, ValidationMessage.IssueType.STRUCTURE, container.line(), container.col(), stack.getLiteralPath(), false, "EXTENSION_EXT_CONTEXT_WRONG_XVER", extUrl, contexts.toString(), ((Object)plist).toString());
            } else {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, container.line(), container.col(), stack.getLiteralPath(), false, "Extension_EXT_Context_Wrong", extUrl, contexts.toString(), ((Object)plist).toString());
            }
            return false;
        }
        if (definition.hasContextInvariant()) {
            for (String s : definition.getContextInvariant()) {
                if (this.fpe.evaluateToBoolean((Object)hostContext, (Base)resource, (Base)hostContext.getRootResource(), (Base)container, this.fpe.parse((String)s.getValue()))) continue;
                if (definition.hasUserData("XVER_EXT_MARKER")) {
                    this.warning(errors, ValidationMessage.IssueType.STRUCTURE, container.line(), container.col(), stack.getLiteralPath(), false, "Profile_EXT_Not_Here", extUrl, s.getValue());
                    return true;
                }
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, container.line(), container.col(), stack.getLiteralPath(), false, "Profile_EXT_Not_Here", extUrl, s.getValue());
                return false;
            }
        }
        return true;
    }

    private List<StructureDefinition.StructureDefinitionContextComponent> fixContexts(String extUrl, List<StructureDefinition.StructureDefinitionContextComponent> list) {
        ArrayList<StructureDefinition.StructureDefinitionContextComponent> res = new ArrayList<StructureDefinition.StructureDefinitionContextComponent>();
        for (StructureDefinition.StructureDefinitionContextComponent ctxt : list) {
            res.add(ctxt.copy());
        }
        if ("http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type".equals(extUrl)) {
            list.get(0).setExpression("ElementDefinition.type");
        }
        if ("http://hl7.org/fhir/StructureDefinition/regex".equals(extUrl)) {
            list.get(1).setExpression("ElementDefinition.type");
        }
        if ("http://hl7.org/fhir/StructureDefinition/structuredefinition-normative-version".equals(extUrl)) {
            list.get(0).setExpression("Element");
        }
        if (!VersionUtilities.isThisOrLater((String)"4.6", (String)this.context.getVersion()) && Utilities.existsInList((String)extUrl, (String[])new String[]{"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation", "http://hl7.org/fhir/StructureDefinition/capabilitystatement-prohibited"})) {
            list.get(0).setExpression("Element");
        }
        return list;
    }

    private String stripIndexes(String path) {
        boolean skip = false;
        StringBuilder b = new StringBuilder();
        for (char c : path.toCharArray()) {
            if (skip) {
                if (c != ']') continue;
                skip = false;
                continue;
            }
            if (c == '[') {
                skip = true;
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    private void checkFixedValue(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, org.hl7.fhir.r5.model.Element fixed, String fixedSource, String propName, org.hl7.fhir.r5.elementmodel.Element parent, boolean pattern) {
        if (fixed != null && !fixed.isEmpty() || focus != null) {
            if ((fixed == null || fixed.isEmpty()) && focus != null) {
                this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, pattern, "Profile_VAL_NotAllowed", focus.getName(), pattern ? "pattern" : "fixed value");
            } else if (fixed != null && !fixed.isEmpty() && focus == null) {
                this.rule(errors, ValidationMessage.IssueType.VALUE, parent == null ? -1 : parent.line(), parent == null ? -1 : parent.col(), path, false, "Profile_VAL_MissingElement", propName, fixedSource);
            } else {
                String value = focus.primitiveValue();
                if (fixed instanceof BooleanType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((BooleanType)fixed).asStringValue(), value), "_DT_Fixed_Wrong", value, ((BooleanType)fixed).asStringValue());
                } else if (fixed instanceof IntegerType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((IntegerType)fixed).asStringValue(), value), "_DT_Fixed_Wrong", value, ((IntegerType)fixed).asStringValue());
                } else if (fixed instanceof DecimalType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((DecimalType)fixed).asStringValue(), value), "_DT_Fixed_Wrong", value, ((DecimalType)fixed).asStringValue());
                } else if (fixed instanceof Base64BinaryType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((Base64BinaryType)fixed).asStringValue(), value), "_DT_Fixed_Wrong", value, ((Base64BinaryType)fixed).asStringValue());
                } else if (fixed instanceof InstantType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((Date)((InstantType)fixed).getValue()).toString(), value), "_DT_Fixed_Wrong", value, ((InstantType)fixed).asStringValue());
                } else if (fixed instanceof CodeType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check((String)((CodeType)fixed).getValue(), value), "_DT_Fixed_Wrong", value, ((CodeType)fixed).getValue());
                } else if (fixed instanceof Enumeration) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((Enumeration)fixed).asStringValue(), value), "_DT_Fixed_Wrong", value, ((Enumeration)fixed).asStringValue());
                } else if (fixed instanceof StringType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check((String)((StringType)fixed).getValue(), value), "_DT_Fixed_Wrong", value, ((StringType)fixed).getValue());
                } else if (fixed instanceof UriType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check((String)((UriType)fixed).getValue(), value), "_DT_Fixed_Wrong", value, ((UriType)fixed).getValue());
                } else if (fixed instanceof DateType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((Date)((DateType)fixed).getValue()).toString(), value), "_DT_Fixed_Wrong", value, ((DateType)fixed).getValue());
                } else if (fixed instanceof DateTimeType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((Date)((DateTimeType)fixed).getValue()).toString(), value), "_DT_Fixed_Wrong", value, ((DateTimeType)fixed).getValue());
                } else if (fixed instanceof OidType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check((String)((OidType)fixed).getValue(), value), "_DT_Fixed_Wrong", value, ((OidType)fixed).getValue());
                } else if (fixed instanceof UuidType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check((String)((UuidType)fixed).getValue(), value), "_DT_Fixed_Wrong", value, ((UuidType)fixed).getValue());
                } else if (fixed instanceof IdType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((IdType)fixed).getValue(), value), "_DT_Fixed_Wrong", value, ((IdType)fixed).getValue());
                } else if (fixed instanceof Quantity) {
                    this.checkQuantity(errors, path, focus, (Quantity)fixed, fixedSource, pattern);
                } else if (fixed instanceof Address) {
                    this.checkAddress(errors, path, focus, (Address)fixed, fixedSource, pattern);
                } else if (fixed instanceof ContactPoint) {
                    this.checkContactPoint(errors, path, focus, (ContactPoint)fixed, fixedSource, pattern);
                } else if (fixed instanceof Attachment) {
                    this.checkAttachment(errors, path, focus, (Attachment)fixed, fixedSource, pattern);
                } else if (fixed instanceof Identifier) {
                    this.checkIdentifier(errors, path, focus, (Identifier)fixed, fixedSource, pattern);
                } else if (fixed instanceof Coding) {
                    this.checkCoding(errors, path, focus, (Coding)fixed, fixedSource, pattern);
                } else if (fixed instanceof HumanName) {
                    this.checkHumanName(errors, path, focus, (HumanName)fixed, fixedSource, pattern);
                } else if (fixed instanceof CodeableConcept) {
                    this.checkCodeableConcept(errors, path, focus, (CodeableConcept)fixed, fixedSource, pattern);
                } else if (fixed instanceof Timing) {
                    this.checkTiming(errors, path, focus, (Timing)fixed, fixedSource, pattern);
                } else if (fixed instanceof Period) {
                    this.checkPeriod(errors, path, focus, (Period)fixed, fixedSource, pattern);
                } else if (fixed instanceof Range) {
                    this.checkRange(errors, path, focus, (Range)fixed, fixedSource, pattern);
                } else if (fixed instanceof Ratio) {
                    this.checkRatio(errors, path, focus, (Ratio)fixed, fixedSource, pattern);
                } else if (fixed instanceof SampledData) {
                    this.checkSampledData(errors, path, focus, (SampledData)fixed, fixedSource, pattern);
                } else if (fixed instanceof Reference) {
                    this.checkReference(errors, path, focus, (Reference)fixed, fixedSource, pattern);
                } else {
                    this.rule(errors, ValidationMessage.IssueType.EXCEPTION, focus.line(), focus.col(), path, false, "Internal_INT_Bad_Type", fixed.fhirType());
                }
                ArrayList<org.hl7.fhir.r5.elementmodel.Element> extensions = new ArrayList<org.hl7.fhir.r5.elementmodel.Element>();
                focus.getNamedChildren("extension", extensions);
                if (fixed.getExtension().size() == 0) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, extensions.size() == 0, "Extension_EXT_Fixed_Banned", new Object[0]);
                } else if (this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, extensions.size() == fixed.getExtension().size(), "Extension_EXT_Count_Mismatch", Integer.toString(fixed.getExtension().size()), Integer.toString(extensions.size()))) {
                    for (Extension e : fixed.getExtension()) {
                        org.hl7.fhir.r5.elementmodel.Element ex = this.getExtensionByUrl(extensions, e.getUrl());
                        if (!this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, ex != null, "Extension_EXT_Count_NotFound", e.getUrl())) continue;
                        this.checkFixedValue(errors, path, ex.getNamedChild("extension").getNamedChild("value"), (org.hl7.fhir.r5.model.Element)e.getValue(), fixedSource, "extension.value", ex.getNamedChild("extension"), false);
                    }
                }
            }
        }
    }

    private void checkHumanName(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, HumanName fixed, String fixedSource, boolean pattern) {
        int i;
        this.checkFixedValue(errors, path + ".use", focus.getNamedChild("use"), (org.hl7.fhir.r5.model.Element)fixed.getUseElement(), fixedSource, "use", focus, pattern);
        this.checkFixedValue(errors, path + ".text", focus.getNamedChild("text"), (org.hl7.fhir.r5.model.Element)fixed.getTextElement(), fixedSource, "text", focus, pattern);
        this.checkFixedValue(errors, path + ".period", focus.getNamedChild("period"), (org.hl7.fhir.r5.model.Element)fixed.getPeriod(), fixedSource, "period", focus, pattern);
        ArrayList parts = new ArrayList();
        if (!pattern || fixed.hasFamily()) {
            focus.getNamedChildren("family", parts);
            if (this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, parts.size() > 0 == fixed.hasFamily(), "Fixed_Type_Checks_DT_Name_Family", fixed.hasFamily() ? "1" : "0", Integer.toString(parts.size()))) {
                for (i = 0; i < parts.size(); ++i) {
                    this.checkFixedValue(errors, path + ".family", (org.hl7.fhir.r5.elementmodel.Element)parts.get(i), (org.hl7.fhir.r5.model.Element)fixed.getFamilyElement(), fixedSource, "family", focus, pattern);
                }
            }
        }
        if (!pattern || fixed.hasGiven()) {
            focus.getNamedChildren("given", parts);
            if (this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, parts.size() == fixed.getGiven().size(), "Fixed_Type_Checks_DT_Name_Given", Integer.toString(fixed.getGiven().size()), Integer.toString(parts.size()))) {
                for (i = 0; i < parts.size(); ++i) {
                    this.checkFixedValue(errors, path + ".given", (org.hl7.fhir.r5.elementmodel.Element)parts.get(i), (org.hl7.fhir.r5.model.Element)fixed.getGiven().get(i), fixedSource, "given", focus, pattern);
                }
            }
        }
        if (!pattern || fixed.hasPrefix()) {
            focus.getNamedChildren("prefix", parts);
            if (this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, parts.size() == fixed.getPrefix().size(), "Fixed_Type_Checks_DT_Name_Prefix", Integer.toString(fixed.getPrefix().size()), Integer.toString(parts.size()))) {
                for (i = 0; i < parts.size(); ++i) {
                    this.checkFixedValue(errors, path + ".prefix", (org.hl7.fhir.r5.elementmodel.Element)parts.get(i), (org.hl7.fhir.r5.model.Element)fixed.getPrefix().get(i), fixedSource, "prefix", focus, pattern);
                }
            }
        }
        if (!pattern || fixed.hasSuffix()) {
            focus.getNamedChildren("suffix", parts);
            if (this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, parts.size() == fixed.getSuffix().size(), "Fixed_Type_Checks_DT_Name_Suffix", Integer.toString(fixed.getSuffix().size()), Integer.toString(parts.size()))) {
                for (i = 0; i < parts.size(); ++i) {
                    this.checkFixedValue(errors, path + ".suffix", (org.hl7.fhir.r5.elementmodel.Element)parts.get(i), (org.hl7.fhir.r5.model.Element)fixed.getSuffix().get(i), fixedSource, "suffix", focus, pattern);
                }
            }
        }
    }

    private void checkIdentifier(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, ElementDefinition context) {
        String system = element.getNamedChildValue("system");
        this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, this.isAbsolute(system), "Type_Specific_Checks_DT_Identifier_System", new Object[0]);
        if ("urn:ietf:rfc:3986".equals(system)) {
            String value = element.getNamedChildValue("value");
            this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, this.isAbsolute(value), "TYPE_SPECIFIC_CHECKS_DT_IDENTIFIER_IETF_SYSTEM_VALUE", new Object[0]);
        }
    }

    private void checkIdentifier(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, Identifier fixed, String fixedSource, boolean pattern) {
        this.checkFixedValue(errors, path + ".use", focus.getNamedChild("use"), (org.hl7.fhir.r5.model.Element)fixed.getUseElement(), fixedSource, "use", focus, pattern);
        this.checkFixedValue(errors, path + ".type", focus.getNamedChild("type"), (org.hl7.fhir.r5.model.Element)fixed.getType(), fixedSource, "type", focus, pattern);
        this.checkFixedValue(errors, path + ".system", focus.getNamedChild("system"), (org.hl7.fhir.r5.model.Element)fixed.getSystemElement(), fixedSource, "system", focus, pattern);
        this.checkFixedValue(errors, path + ".value", focus.getNamedChild("value"), (org.hl7.fhir.r5.model.Element)fixed.getValueElement(), fixedSource, "value", focus, pattern);
        this.checkFixedValue(errors, path + ".period", focus.getNamedChild("period"), (org.hl7.fhir.r5.model.Element)fixed.getPeriod(), fixedSource, "period", focus, pattern);
        this.checkFixedValue(errors, path + ".assigner", focus.getNamedChild("assigner"), (org.hl7.fhir.r5.model.Element)fixed.getAssigner(), fixedSource, "assigner", focus, pattern);
    }

    private void checkPeriod(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, Period fixed, String fixedSource, boolean pattern) {
        this.checkFixedValue(errors, path + ".start", focus.getNamedChild("start"), (org.hl7.fhir.r5.model.Element)fixed.getStartElement(), fixedSource, "start", focus, pattern);
        this.checkFixedValue(errors, path + ".end", focus.getNamedChild("end"), (org.hl7.fhir.r5.model.Element)fixed.getEndElement(), fixedSource, "end", focus, pattern);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkPrimitive(Object appContext, List<ValidationMessage> errors, String path, String type, ElementDefinition context, org.hl7.fhir.r5.elementmodel.Element e, StructureDefinition profile, NodeStack node) throws FHIRException {
        XhtmlNode xhtml;
        Number v;
        String encoded;
        TimeType ex3;
        String url;
        block64: {
            IResourceValidator.ReferenceValidationPolicy rp;
            boolean found;
            block65: {
                if (StringUtils.isBlank((CharSequence)e.primitiveValue())) {
                    if (e.primitiveValue() == null) {
                        this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.hasChildren(), "Type_Specific_Checks_DT_Primitive_ValueExt", new Object[0]);
                    } else if (e.primitiveValue().length() == 0) {
                        this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.hasChildren(), "Type_Specific_Checks_DT_Primitive_NotEmpty", new Object[0]);
                    } else if (StringUtils.isWhitespace((CharSequence)e.primitiveValue())) {
                        this.warning(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.hasChildren(), "Type_Specific_Checks_DT_Primitive_WS", new Object[0]);
                    }
                    if (context.hasBinding()) {
                        this.rule(errors, ValidationMessage.IssueType.CODEINVALID, e.line(), e.col(), path, context.getBinding().getStrength() != Enumerations.BindingStrength.REQUIRED, "Terminology_TX_Code_ValueSet_MISSING", new Object[0]);
                    }
                    return;
                }
                String regex = context.getExtensionString("http://hl7.org/fhir/StructureDefinition/regex");
                if (regex != null) {
                    this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.primitiveValue().matches(regex), "Type_Specific_Checks_DT_Primitive_Regex", e.primitiveValue(), regex);
                }
                if (!"xhtml".equals(type)) {
                    if (this.securityChecks) {
                        this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !this.containsHtmlTags(e.primitiveValue()), "SECURITY_STRING_CONTENT_ERROR", new Object[0]);
                    } else {
                        this.hint(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !this.containsHtmlTags(e.primitiveValue()), "SECURITY_STRING_CONTENT_WARNING");
                    }
                }
                if (type.equals("boolean")) {
                    this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, "true".equals(e.primitiveValue()) || "false".equals(e.primitiveValue()), "Type_Specific_Checks_DT_Boolean_Value", new Object[0]);
                }
                if (!type.equals("uri") && !type.equals("oid") && !type.equals("uuid") && !type.equals("url") && !type.equals("canonical")) break block64;
                url = e.primitiveValue();
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !url.startsWith("oid:"), "Type_Specific_Checks_DT_URI_OID", new Object[0]);
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !url.startsWith("uuid:"), "Type_Specific_Checks_DT_URI_UUID", new Object[0]);
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, url.equals(url.trim().replace(" ", "")) || "http://www.acme.com/identifiers/patient or urn:ietf:rfc:3986 if the Identifier.value itself is a full uri".equals(url), "Type_Specific_Checks_DT_URI_WS", url);
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !context.hasMaxLength() || context.getMaxLength() == 0 || url.length() <= context.getMaxLength(), "Type_Specific_Checks_DT_Primitive_Length", context.getMaxLength());
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !context.hasMaxLength() || context.getMaxLength() == 0 || e.primitiveValue().length() <= context.getMaxLength(), "Type_Specific_Checks_DT_Primitive_Length", context.getMaxLength());
                if (type.equals("oid") && this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, url.startsWith("urn:oid:"), "Type_Specific_Checks_DT_OID_Start", new Object[0])) {
                    this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, Utilities.isOid((String)url.substring(8)), "Type_Specific_Checks_DT_OID_Valid", new Object[0]);
                }
                if (type.equals("uuid")) {
                    this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, url.startsWith("urn:uuid:"), "Type_Specific_Checks_DT_UUID_Strat", new Object[0]);
                    try {
                        UUID.fromString(url.substring(8));
                    }
                    catch (Exception ex2) {
                        this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "Type_Specific_Checks_DT_UUID_Vaid", ex2.getMessage());
                    }
                }
                if (type.equals("canonical")) {
                    this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, url.startsWith("#") || Utilities.isAbsoluteUrl((String)url), "TYPE_SPECIFIC_CHECKS_CANONICAL_ABSOLUTE", url);
                }
                if (this.isCanonicalURLElement(e) || this.fetcher == null || type.equals("uuid")) break block64;
                try {
                    found = this.isDefinitionURL(url) || this.allowExamples && (url.contains("example.org") || url.contains("acme.com")) || url.contains("acme.org") || url.startsWith("http://hl7.org/fhir/tools") || SpecialExtensions.isKnownExtension(url) || this.isXverUrl(url) || this.fetcher.resolveURL(appContext, path, url, type);
                }
                catch (IOException e1) {
                    found = false;
                }
                if (found) break block65;
                if (type.equals("canonical")) {
                    rp = this.fetcher.validationPolicy(appContext, path, url);
                    if (rp == IResourceValidator.ReferenceValidationPolicy.CHECK_EXISTS || rp == IResourceValidator.ReferenceValidationPolicy.CHECK_EXISTS_AND_TYPE) {
                        this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, found, "TYPE_SPECIFIC_CHECKS_DT_CANONICAL_RESOLVE", url);
                        break block64;
                    } else {
                        this.hint(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, found, "TYPE_SPECIFIC_CHECKS_DT_CANONICAL_RESOLVE", url);
                    }
                    break block64;
                } else if (url.contains("hl7.org") || url.contains("fhir.org")) {
                    this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, found, "Type_Specific_Checks_DT_URL_Resolve", url);
                    break block64;
                } else {
                    this.warning(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, found, "Type_Specific_Checks_DT_URL_Resolve", url);
                }
                break block64;
            }
            if (type.equals("canonical") && ((rp = this.fetcher.validationPolicy(appContext, path, url)) == IResourceValidator.ReferenceValidationPolicy.CHECK_EXISTS_AND_TYPE || rp == IResourceValidator.ReferenceValidationPolicy.CHECK_TYPE_IF_EXISTS || rp == IResourceValidator.ReferenceValidationPolicy.CHECK_VALID)) {
                try {
                    CanonicalResource r = this.fetcher.fetchCanonicalResource(url);
                    if (r == null) {
                        this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, found, "TYPE_SPECIFIC_CHECKS_DT_CANONICAL_RESOLVE", url);
                    } else if (this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, this.isCorrectCanonicalType((Resource)r, context), "TYPE_SPECIFIC_CHECKS_DT_CANONICAL_TYPE", url, r.fhirType(), this.listExpectedCanonicalTypes(context)) && rp != IResourceValidator.ReferenceValidationPolicy.CHECK_VALID) {
                        // empty if block
                    }
                }
                catch (Exception r) {
                    // empty catch block
                }
            }
        }
        if (type.equals("id") && !context.getPath().equals("ElementDefinition.id")) {
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, FormatUtilities.isValidId((String)e.primitiveValue()), "Type_Specific_Checks_DT_ID_Valid", e.primitiveValue());
        }
        if (type.equalsIgnoreCase("string") && e.hasPrimitiveValue() && this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.primitiveValue() == null || e.primitiveValue().length() > 0, "Type_Specific_Checks_DT_Primitive_NotEmpty", new Object[0])) {
            this.warning(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.primitiveValue() == null || e.primitiveValue().trim().equals(e.primitiveValue()), "Type_Specific_Checks_DT_String_WS", new Object[0]);
            if (this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.primitiveValue().length() <= 0x100000, "Type_Specific_Checks_DT_String_Length", new Object[0])) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !context.hasMaxLength() || context.getMaxLength() == 0 || e.primitiveValue().length() <= context.getMaxLength(), "Type_Specific_Checks_DT_Primitive_Length", context.getMaxLength());
            }
        }
        if (type.equals("dateTime")) {
            this.warning(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, this.yearIsValid(e.primitiveValue()), "Type_Specific_Checks_DT_DateTime_Reasonable", e.primitiveValue());
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.primitiveValue().matches("([0-9]([0-9]([0-9][1-9]|[1-9]0)|[1-9]00)|[1-9]000)(-(0[1-9]|1[0-2])(-(0[1-9]|[1-2][0-9]|3[0-1])(T([01][0-9]|2[0-3]):[0-5][0-9]:([0-5][0-9]|60)(\\.[0-9]+)?(Z|(\\+|-)((0[0-9]|1[0-3]):[0-5][0-9]|14:00))?)?)?)?"), "Type_Specific_Checks_DT_DateTime_Valid", e.primitiveValue());
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !this.hasTime(e.primitiveValue()) || this.hasTimeZone(e.primitiveValue()), "Type_Specific_Checks_DT_DateTime_TZ", new Object[0]);
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !context.hasMaxLength() || context.getMaxLength() == 0 || e.primitiveValue().length() <= context.getMaxLength(), "Type_Specific_Checks_DT_Primitive_Length", context.getMaxLength());
            try {
                url = new DateTimeType(e.primitiveValue());
            }
            catch (Exception ex3) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "Type_Specific_Checks_DT_DateTime_Valid", ex3.getMessage());
            }
        }
        if (type.equals("time")) {
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.primitiveValue().matches("([01][0-9]|2[0-3]):[0-5][0-9]:([0-5][0-9]|60)"), "Type_Specific_Checks_DT_Time_Valid", new Object[0]);
            try {
                ex3 = new TimeType(e.primitiveValue());
            }
            catch (Exception ex4) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "Type_Specific_Checks_DT_Time_Valid", ex4.getMessage());
            }
        }
        if (type.equals("date")) {
            this.warning(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, this.yearIsValid(e.primitiveValue()), "Type_Specific_Checks_DT_DateTime_Reasonable", e.primitiveValue());
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.primitiveValue().matches("([0-9]([0-9]([0-9][1-9]|[1-9]0)|[1-9]00)|[1-9]000)(-(0[1-9]|1[0-2])(-(0[1-9]|[1-2][0-9]|3[0-1]))?)?"), "Type_Specific_Checks_DT_Date_Valid", new Object[0]);
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !context.hasMaxLength() || context.getMaxLength() == 0 || e.primitiveValue().length() <= context.getMaxLength(), "Type_Specific_Checks_DT_Primitive_Length", context.getMaxLength());
            try {
                ex3 = new DateType(e.primitiveValue());
            }
            catch (Exception ex5) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "Type_Specific_Checks_DT_Date_Valid", ex5.getMessage());
            }
        }
        if (type.equals("base64Binary") && StringUtils.isNotBlank((CharSequence)(encoded = e.primitiveValue()))) {
            boolean ok = this.isValidBase64(encoded);
            if (!ok) {
                String value = encoded.length() < 100 ? encoded : "(snip)";
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "Type_Specific_Checks_DT_Base64_Valid", value);
            }
            if (ok && context.hasExtension("http://hl7.org/fhir/StructureDefinition/maxSize")) {
                int size = this.countBase64DecodedBytes(encoded);
                long def = Long.parseLong(ToolingExtensions.readStringExtension((org.hl7.fhir.r5.model.Element)context, (String)"http://hl7.org/fhir/StructureDefinition/maxSize"));
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, e.line(), e.col(), path, (long)size <= def, "TYPE_SPECIFIC_CHECKS_DT_BASE64_TOO_LONG", size, def);
            }
        }
        if ((type.equals("integer") || type.equals("unsignedInt") || type.equals("positiveInt")) && this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, Utilities.isInteger((String)e.primitiveValue()), "Type_Specific_Checks_DT_Integer_Valid", e.primitiveValue())) {
            v = (int)new Integer(e.getValue());
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !context.hasMaxValueIntegerType() || !context.getMaxValueIntegerType().hasValue() || (Integer)context.getMaxValueIntegerType().getValue() >= (Integer)v, "Type_Specific_Checks_DT_Integer_GT", context.hasMaxValueIntegerType() ? context.getMaxValueIntegerType() : "");
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !context.hasMinValueIntegerType() || !context.getMinValueIntegerType().hasValue() || (Integer)context.getMinValueIntegerType().getValue() <= (Integer)v, "Type_Specific_Checks_DT_Integer_LT", context.hasMinValueIntegerType() ? context.getMinValueIntegerType() : "");
            if (type.equals("unsignedInt")) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, (Integer)v >= 0, "Type_Specific_Checks_DT_Integer_LT0", new Object[0]);
            }
            if (type.equals("positiveInt")) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, (Integer)v > 0, "Type_Specific_Checks_DT_Integer_LT1", new Object[0]);
            }
        }
        if (type.equals("integer64") && this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, Utilities.isLong((String)e.primitiveValue()), "Type_Specific_Checks_DT_Integer64_Valid", e.primitiveValue())) {
            v = (long)new Long(e.getValue());
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !context.hasMaxValueInteger64Type() || !context.getMaxValueInteger64Type().hasValue() || (Long)context.getMaxValueInteger64Type().getValue() >= (Long)v, "Type_Specific_Checks_DT_Integer_GT", context.hasMaxValueInteger64Type() ? context.getMaxValueInteger64Type() : "");
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !context.hasMinValueInteger64Type() || !context.getMinValueInteger64Type().hasValue() || (Long)context.getMinValueInteger64Type().getValue() <= (Long)v, "Type_Specific_Checks_DT_Integer_LT", context.hasMinValueInteger64Type() ? context.getMinValueInteger64Type() : "");
            if (type.equals("unsignedInt")) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, (Long)v >= 0L, "Type_Specific_Checks_DT_Integer_LT0", new Object[0]);
            }
            if (type.equals("positiveInt")) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, (Long)v > 0L, "Type_Specific_Checks_DT_Integer_LT1", new Object[0]);
            }
        }
        if (type.equals("decimal")) {
            if (e.primitiveValue() != null) {
                Utilities.DecimalStatus ds = Utilities.checkDecimal((String)e.primitiveValue(), (boolean)true, (boolean)false);
                if (this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, ds == Utilities.DecimalStatus.OK || ds == Utilities.DecimalStatus.RANGE, "Type_Specific_Checks_DT_Decimal_Valid", e.primitiveValue())) {
                    this.warning(errors, ValidationMessage.IssueType.VALUE, e.line(), e.col(), path, ds != Utilities.DecimalStatus.RANGE, "Type_Specific_Checks_DT_Decimal_Range", e.primitiveValue());
                }
            }
            if (context.hasExtension("http://hl7.org/fhir/StructureDefinition/maxDecimalPlaces")) {
                int dp = e.primitiveValue().contains(".") ? e.primitiveValue().substring(e.primitiveValue().indexOf(".") + 1).length() : 0;
                int def = Integer.parseInt(ToolingExtensions.readStringExtension((org.hl7.fhir.r5.model.Element)context, (String)"http://hl7.org/fhir/StructureDefinition/maxDecimalPlaces"));
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, e.line(), e.col(), path, dp <= def, "TYPE_SPECIFIC_CHECKS_DT_DECIMAL_CHARS", dp, def);
            }
        }
        if (type.equals("instant")) {
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.primitiveValue().matches("-?[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])T([01][0-9]|2[0-3]):[0-5][0-9]:([0-5][0-9]|60)(\\.[0-9]+)?(Z|(\\+|-)((0[0-9]|1[0-3]):[0-5][0-9]|14:00))"), "Type_Specific_Checks_DT_DateTime_Regex", e.primitiveValue());
            this.warning(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, this.yearIsValid(e.primitiveValue()), "Type_Specific_Checks_DT_DateTime_Reasonable", e.primitiveValue());
            try {
                InstantType dp = new InstantType(e.primitiveValue());
            }
            catch (Exception ex6) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "Type_Specific_Checks_DT_Instant_Valid", ex6.getMessage());
            }
        }
        if (type.equals("code") && e.primitiveValue() != null) {
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, this.passesCodeWhitespaceRules(e.primitiveValue()), "Type_Specific_Checks_DT_Code_WS", e.primitiveValue());
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !context.hasMaxLength() || context.getMaxLength() == 0 || e.primitiveValue().length() <= context.getMaxLength(), "Type_Specific_Checks_DT_Primitive_Length", context.getMaxLength());
        }
        if (context.hasBinding() && e.primitiveValue() != null) {
            this.checkPrimitiveBinding(errors, path, type, context, e, profile, node);
        }
        if (type.equals("xhtml") && (xhtml = e.getXhtml()) != null) {
            String ns = xhtml.getNsDecl();
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, "http://www.w3.org/1999/xhtml".equals(ns), "XHTML_XHTML_NS_InValid", ns, "http://www.w3.org/1999/xhtml");
            this.checkInnerNS(errors, e, path, xhtml.getChildNodes());
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, "div".equals(xhtml.getName()), "XHTML_XHTML_Name_Invalid", ns);
            this.checkInnerNames(errors, e, path, xhtml.getChildNodes(), false);
            this.checkUrls(errors, e, path, xhtml.getChildNodes());
        }
        if (context.hasFixed()) {
            this.checkFixedValue(errors, path, e, (org.hl7.fhir.r5.model.Element)context.getFixed(), profile.getUrl(), context.getSliceName(), null, false);
        }
        if (context.hasPattern()) {
            this.checkFixedValue(errors, path, e, (org.hl7.fhir.r5.model.Element)context.getPattern(), profile.getUrl(), context.getSliceName(), null, true);
        }
    }

    private List<String> listExpectedCanonicalTypes(ElementDefinition context) {
        ArrayList<String> res = new ArrayList<String>();
        ElementDefinition.TypeRefComponent tr = context.getType("canonical");
        if (tr != null) {
            for (CanonicalType p : tr.getTargetProfile()) {
                String url = (String)p.getValue();
                if (url == null || !url.startsWith("http://hl7.org/fhir/StructureDefinition/")) continue;
                res.add(url.substring("http://hl7.org/fhir/StructureDefinition/".length()));
            }
        }
        return res;
    }

    private boolean isCorrectCanonicalType(Resource r, ElementDefinition context) {
        ElementDefinition.TypeRefComponent tr = context.getType("canonical");
        if (tr != null) {
            for (CanonicalType p : tr.getTargetProfile()) {
                if (!this.isCorrectCanonicalType(r, p)) continue;
                return true;
            }
            if (tr.getTargetProfile().isEmpty()) {
                return true;
            }
        }
        return false;
    }

    private boolean isCorrectCanonicalType(Resource r, CanonicalType p) {
        String url = (String)p.getValue();
        if (url != null && url.startsWith("http://hl7.org/fhir/StructureDefinition/")) {
            url = url.substring("http://hl7.org/fhir/StructureDefinition/".length());
            return Utilities.existsInList((String)url, (String[])new String[]{"Resource", "CanonicalResource"}) || url.equals(r.fhirType());
        }
        return false;
    }

    private boolean isCanonicalURLElement(org.hl7.fhir.r5.elementmodel.Element e) {
        if (e.getProperty() == null || e.getProperty().getDefinition() == null) {
            return false;
        }
        String path = e.getProperty().getDefinition().getBase().getPath();
        if (path == null) {
            return false;
        }
        String[] p = path.split("\\.");
        if (p.length != 2) {
            return false;
        }
        if (!"url".equals(p[1])) {
            return false;
        }
        return Utilities.existsInList((String)p[0], (List)VersionUtilities.getCanonicalResourceNames((String)this.context.getVersion()));
    }

    private boolean containsHtmlTags(String cnt) {
        int i = cnt.indexOf("<");
        while (i > -1) {
            String s;
            cnt = cnt.substring(i + 1);
            i = cnt.indexOf("<");
            int e = cnt.indexOf(">");
            if (e <= -1 || e >= i || !(s = cnt.substring(0, e)).matches(HTML_FRAGMENT_REGEX)) continue;
            return true;
        }
        return false;
    }

    private boolean isValidBase64(String theEncoded) {
        if (theEncoded == null) {
            return false;
        }
        int charCount = 0;
        boolean ok = true;
        for (int i = 0; i < theEncoded.length(); ++i) {
            char nextChar = theEncoded.charAt(i);
            if (Character.isWhitespace(nextChar)) continue;
            if (Character.isLetterOrDigit(nextChar)) {
                ++charCount;
            }
            if (nextChar != '/' && nextChar != '=' && nextChar != '+') continue;
            ++charCount;
        }
        if (charCount > 0 && charCount % 4 != 0) {
            ok = false;
        }
        return ok;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int countBase64DecodedBytes(String theEncoded) {
        Base64InputStream inputStream = new Base64InputStream((InputStream)new ByteArrayInputStream(theEncoded.getBytes(StandardCharsets.UTF_8)));
        try {
            try {
                int counter = 0;
                while (true) {
                    if (inputStream.read() == -1) {
                        int n = counter;
                        return n;
                    }
                    ++counter;
                }
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private boolean isDefinitionURL(String url) {
        return Utilities.existsInList((String)url, (String[])new String[]{"http://hl7.org/fhirpath/System.Boolean", "http://hl7.org/fhirpath/System.String", "http://hl7.org/fhirpath/System.Integer", "http://hl7.org/fhirpath/System.Decimal", "http://hl7.org/fhirpath/System.Date", "http://hl7.org/fhirpath/System.Time", "http://hl7.org/fhirpath/System.DateTime", "http://hl7.org/fhirpath/System.Quantity"});
    }

    private void checkInnerNames(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element e, String path, List<XhtmlNode> list, boolean inPara) {
        for (XhtmlNode node : list) {
            if (node.getNodeType() == NodeType.Comment) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !node.getContent().startsWith("DOCTYPE"), "XHTML_XHTML_DOCTYPE_ILLEGAL", new Object[0]);
            }
            if (node.getNodeType() != NodeType.Element) continue;
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, Utilities.existsInList((String)node.getName(), (String[])new String[]{"p", "br", "div", "h1", "h2", "h3", "h4", "h5", "h6", "a", "span", "b", "em", "i", "strong", "small", "big", "tt", "small", "dfn", "q", "var", "abbr", "acronym", "cite", "blockquote", "hr", "address", "bdo", "kbd", "q", "sub", "sup", "ul", "ol", "li", "dl", "dt", "dd", "pre", "table", "caption", "colgroup", "col", "thead", "tr", "tfoot", "tbody", "th", "td", "code", "samp", "img", "map", "area"}), "XHTML_XHTML_Element_Illegal", node.getName());
            for (String an : node.getAttributes().keySet()) {
                boolean ok = an.startsWith("xmlns") || Utilities.existsInList((String)an, (String[])new String[]{"title", "style", "class", "id", "lang", "xml:lang", "dir", "accesskey", "tabindex", "span", "width", "align", "valign", "char", "charoff", "abbr", "axis", "headers", "scope", "rowspan", "colspan"}) || Utilities.existsInList((String)(node.getName() + "." + an), (String[])new String[]{"a.href", "a.name", "img.src", "img.border", "div.xmlns", "blockquote.cite", "q.cite", "a.charset", "a.type", "a.name", "a.href", "a.hreflang", "a.rel", "a.rev", "a.shape", "a.coords", "img.src", "img.alt", "img.longdesc", "img.height", "img.width", "img.usemap", "img.ismap", "map.name", "area.shape", "area.coords", "area.href", "area.nohref", "area.alt", "table.summary", "table.width", "table.border", "table.frame", "table.rules", "table.cellspacing", "table.cellpadding", "pre.space", "td.nowrap"});
                if (ok) continue;
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "XHTML_XHTML_Attribute_Illegal", an, node.getName());
            }
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !inPara || !Utilities.existsInList((String)node.getName(), (String[])new String[]{"div", "blockquote", "table", "ol", "ul", "p"}), "XHTML_XHTML_ELEMENT_ILLEGAL_IN_PARA", node.getName());
            this.checkInnerNames(errors, e, path, node.getChildNodes(), inPara || "p".equals(node.getName()));
        }
    }

    private void checkUrls(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element e, String path, List<XhtmlNode> list) {
        for (XhtmlNode node : list) {
            String msg;
            if (node.getNodeType() != NodeType.Element) continue;
            if ("a".equals(node.getName())) {
                msg = this.checkValidUrl(node.getAttribute("href"));
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, msg == null, "XHTML_URL_INVALID", node.getAttribute("href"), msg);
            } else if ("img".equals(node.getName())) {
                msg = this.checkValidUrl(node.getAttribute("src"));
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, msg == null, "XHTML_URL_INVALID", node.getAttribute("src"), msg);
            }
            this.checkUrls(errors, e, path, node.getChildNodes());
        }
    }

    private String checkValidUrl(String value) {
        if (value == null) {
            return null;
        }
        if (Utilities.noString((String)value)) {
            return this.context.formatMessage("XHTML_URL_EMPTY", new Object[0]);
        }
        if (value.startsWith("data:")) {
            String mMsg;
            String[] p = value.substring(5).split("\\,");
            if (p.length < 2) {
                return this.context.formatMessage("XHTML_URL_DATA_NO_DATA", new Object[]{value});
            }
            if (p.length > 2) {
                return this.context.formatMessage("XHTML_URL_DATA_DATA_INVALID_COMMA", new Object[]{value});
            }
            if (!p[0].endsWith(";base64") || !this.isValidBase64(p[1])) {
                return this.context.formatMessage("XHTML_URL_DATA_DATA_INVALID", new Object[]{value});
            }
            if (p[0].startsWith(" ")) {
                p[0] = p[0].trim();
            }
            if ((mMsg = this.checkValidMimeType(p[0].substring(0, p[0].lastIndexOf(";")))) != null) {
                return this.context.formatMessage("XHTML_URL_DATA_MIMETYPE", new Object[]{value, mMsg});
            }
            return null;
        }
        HashSet<Character> invalidChars = new HashSet<Character>();
        for (char ch : value.toCharArray()) {
            if (Character.isDigit(ch) || Character.isAlphabetic(ch) || Utilities.existsInList((int)ch, (int[])new int[]{59, 63, 58, 64, 38, 61, 43, 36, 46, 44, 47, 37, 45, 95, 126, 35, 91, 93, 33, 39, 40, 41, 42})) continue;
            invalidChars.add(Character.valueOf(ch));
        }
        if (invalidChars.isEmpty()) {
            return null;
        }
        return this.context.formatMessage("XHTML_URL_INVALID_CHARS", new Object[]{((Object)invalidChars).toString()});
    }

    private String checkValidMimeType(String mt) {
        if (!mt.matches("^(\\w+|\\*)\\/(\\w+|\\*)((;\\s*(\\w+)=\\s*(\\S+))?)$")) {
            return "Mime type invalid";
        }
        return null;
    }

    private void checkInnerNS(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element e, String path, List<XhtmlNode> list) {
        for (XhtmlNode node : list) {
            if (node.getNodeType() != NodeType.Element) continue;
            String ns = node.getNsDecl();
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, ns == null || "http://www.w3.org/1999/xhtml".equals(ns), "XHTML_XHTML_NS_InValid", ns, "http://www.w3.org/1999/xhtml");
            this.checkInnerNS(errors, e, path, node.getChildNodes());
        }
    }

    private void checkPrimitiveBinding(List<ValidationMessage> errors, String path, String type, ElementDefinition elementContext, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition profile, NodeStack stack) {
        if (!(element.hasPrimitiveValue() && ("code".equals(type) || "string".equals(type) || "uri".equals(type) || "url".equals(type) || "canonical".equals(type)))) {
            return;
        }
        if (this.noTerminologyChecks) {
            return;
        }
        String value = element.primitiveValue();
        ElementDefinition.ElementDefinitionBindingComponent binding = elementContext.getBinding();
        if (binding.hasValueSet()) {
            ValueSet vs = this.resolveBindingReference((DomainResource)profile, binding.getValueSet(), profile.getUrl());
            if (this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, vs != null, "Terminology_TX_ValueSet_NotFound2", this.describeReference(binding.getValueSet()))) {
                long t = System.nanoTime();
                IWorkerContext.ValidationResult vr = null;
                if (binding.getStrength() != Enumerations.BindingStrength.EXAMPLE) {
                    ValidationOptions options = new ValidationOptions(stack.getWorkingLang()).guessSystem();
                    vr = this.checkCodeOnServer(stack, vs, value, options);
                }
                this.timeTracker.tx(t);
                if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                    this.removeTrackedMessagesForLocation(errors, element, path);
                }
                if (vr != null && !vr.isOk()) {
                    if (vr.IsNoService()) {
                        this.txHint(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_15", value);
                    } else if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                        this.txRule(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_16", value, this.describeReference(binding.getValueSet()), vs.getUrl(), this.getErrorMessage(vr.getMessage()));
                    } else if (binding.getStrength() == Enumerations.BindingStrength.EXTENSIBLE) {
                        if (binding.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")) {
                            this.checkMaxValueSet(errors, path, element, profile, ToolingExtensions.readStringExtension((org.hl7.fhir.r5.model.Element)binding, (String)"http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet"), value, stack);
                        } else if (!this.noExtensibleWarnings && !this.isOkExtension(value, vs)) {
                            this.txWarningForLaterRemoval(element, errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_17", value, this.describeReference(binding.getValueSet()), vs.getUrl(), this.getErrorMessage(vr.getMessage()));
                        }
                    } else if (binding.getStrength() == Enumerations.BindingStrength.PREFERRED && this.baseOnly) {
                        this.txHint(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_18", value, this.describeReference(binding.getValueSet()), vs.getUrl(), this.getErrorMessage(vr.getMessage()));
                    }
                }
            }
        } else if (!this.noBindingMsgSuppressed) {
            this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, !type.equals("code"), "Terminology_TX_Binding_NoSource2");
        }
    }

    private boolean isOkExtension(String value, ValueSet vs) {
        if ("http://hl7.org/fhir/ValueSet/defined-types".equals(vs.getUrl())) {
            return value.startsWith("http://hl7.org/fhirpath/System.");
        }
        return false;
    }

    private void checkQuantity(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, Quantity fixed, String fixedSource, boolean pattern) {
        this.checkFixedValue(errors, path + ".value", focus.getNamedChild("value"), (org.hl7.fhir.r5.model.Element)fixed.getValueElement(), fixedSource, "value", focus, pattern);
        this.checkFixedValue(errors, path + ".comparator", focus.getNamedChild("comparator"), (org.hl7.fhir.r5.model.Element)fixed.getComparatorElement(), fixedSource, "comparator", focus, pattern);
        this.checkFixedValue(errors, path + ".units", focus.getNamedChild("unit"), (org.hl7.fhir.r5.model.Element)fixed.getUnitElement(), fixedSource, "units", focus, pattern);
        this.checkFixedValue(errors, path + ".system", focus.getNamedChild("system"), (org.hl7.fhir.r5.model.Element)fixed.getSystemElement(), fixedSource, "system", focus, pattern);
        this.checkFixedValue(errors, path + ".code", focus.getNamedChild("code"), (org.hl7.fhir.r5.model.Element)fixed.getCodeElement(), fixedSource, "code", focus, pattern);
    }

    private void checkQuantity(List<ValidationMessage> theErrors, String thePath, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition theProfile, ElementDefinition definition, NodeStack theStack) {
        String code;
        String unit = element.hasChild("unit") ? element.getNamedChild("unit").getValue() : null;
        String system = element.hasChild("system") ? element.getNamedChild("system").getValue() : null;
        String string = code = element.hasChild("code") ? element.getNamedChild("code").getValue() : null;
        if (definition.hasExtension("http://hl7.org/fhir/StructureDefinition/maxDecimalPlaces")) {
            String dec = element.getChildValue("value");
            int dp = dec.contains(".") ? dec.substring(dec.indexOf(".") + 1).length() : 0;
            int def = Integer.parseInt(ToolingExtensions.readStringExtension((org.hl7.fhir.r5.model.Element)definition, (String)"http://hl7.org/fhir/StructureDefinition/maxDecimalPlaces"));
            this.rule(theErrors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), thePath, dp <= def, "TYPE_SPECIFIC_CHECKS_DT_DECIMAL_CHARS", dp, def);
        }
        if (system != null || code != null) {
            this.checkCodedElement(theErrors, thePath, element, theProfile, definition, false, false, theStack, code, system, unit);
        }
        if (code != null && "http://unitsofmeasure.org".equals(system)) {
            int b = code.indexOf("{");
            int e = code.indexOf("}");
            if (b >= 0 && e > 0 && b < e) {
                this.bpCheck(theErrors, ValidationMessage.IssueType.BUSINESSRULE, element.line(), element.col(), thePath, !code.contains("{"), "TYPE_SPECIFIC_CHECKS_DT_QTY_NO_ANNOTATIONS", code.substring(b, e + 1));
            }
        }
    }

    private void checkAttachment(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition theProfile, ElementDefinition definition, boolean theInCodeableConcept, boolean theCheckDisplayInContext, NodeStack theStack) {
        long size = -1L;
        String fetchError = null;
        if (element.hasChild("data")) {
            String b64 = element.getChildValue("data");
            boolean ok = this.isValidBase64(b64);
            if (ok && element.hasChild("size")) {
                size = this.countBase64DecodedBytes(b64);
                String sz = element.getChildValue("size");
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, Long.toString(size).equals(sz), "TYPE_SPECIFIC_CHECKS_DT_ATT_SIZE_CORRECT", sz, size);
            }
        } else if (element.hasChild("size")) {
            String sz = element.getChildValue("size");
            if (this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, Utilities.isLong((String)sz), "TYPE_SPECIFIC_CHECKS_DT_ATT_SIZE_INVALID", sz)) {
                size = Long.parseLong(sz);
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, size >= 0L, "TYPE_SPECIFIC_CHECKS_DT_ATT_SIZE_INVALID", sz);
            }
        } else if (element.hasChild("url")) {
            String url = element.getChildValue("url");
            if (definition.hasExtension("http://hl7.org/fhir/StructureDefinition/maxSize")) {
                try {
                    if (url.startsWith("http://") || url.startsWith("https://")) {
                        if (this.fetcher == null) {
                            fetchError = this.context.formatMessage("TYPE_SPECIFIC_CHECKS_DT_ATT_NO_FETCHER", new Object[]{url});
                        } else {
                            byte[] cnt = this.fetcher.fetchRaw(url);
                            size = cnt.length;
                        }
                    } else if (url.startsWith("file:")) {
                        size = new File(url.substring(5)).length();
                    } else {
                        fetchError = this.context.formatMessage("TYPE_SPECIFIC_CHECKS_DT_ATT_UNKNOWN_URL_SCHEME", new Object[]{url});
                    }
                }
                catch (Exception e) {
                    fetchError = this.context.formatMessage("TYPE_SPECIFIC_CHECKS_DT_ATT_URL_ERROR", new Object[]{url, e.getMessage()});
                }
            }
        }
        if (definition.hasExtension("http://hl7.org/fhir/StructureDefinition/maxSize") && this.warning(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, size >= 0L, fetchError, new Object[0])) {
            long def = Long.parseLong(ToolingExtensions.readStringExtension((org.hl7.fhir.r5.model.Element)definition, (String)"http://hl7.org/fhir/StructureDefinition/maxSize"));
            this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, size <= def, "TYPE_SPECIFIC_CHECKS_DT_ATT_TOO_LONG", size, def);
        }
        this.warning(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, element.hasChild("data") || element.hasChild("url") || element.hasChild("contentType") || element.hasChild("language"), "TYPE_SPECIFIC_CHECKS_DT_ATT_NO_CONTENT", new Object[0]);
    }

    private void checkRange(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, Range fixed, String fixedSource, boolean pattern) {
        this.checkFixedValue(errors, path + ".low", focus.getNamedChild("low"), (org.hl7.fhir.r5.model.Element)fixed.getLow(), fixedSource, "low", focus, pattern);
        this.checkFixedValue(errors, path + ".high", focus.getNamedChild("high"), (org.hl7.fhir.r5.model.Element)fixed.getHigh(), fixedSource, "high", focus, pattern);
    }

    private void checkRatio(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, Ratio fixed, String fixedSource, boolean pattern) {
        this.checkFixedValue(errors, path + ".numerator", focus.getNamedChild("numerator"), (org.hl7.fhir.r5.model.Element)fixed.getNumerator(), fixedSource, "numerator", focus, pattern);
        this.checkFixedValue(errors, path + ".denominator", focus.getNamedChild("denominator"), (org.hl7.fhir.r5.model.Element)fixed.getDenominator(), fixedSource, "denominator", focus, pattern);
    }

    private void checkReference(ValidatorHostContext hostContext, List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition profile, ElementDefinition container, String parentType, NodeStack stack) throws FHIRException {
        IResourceValidator.ReferenceValidationPolicy pol;
        Reference reference = ObjectConverter.readAsReference((org.hl7.fhir.r5.elementmodel.Element)element);
        String ref = reference.getReference();
        if (Utilities.noString((String)ref)) {
            if (!path.contains("element.pattern") && Utilities.noString((String)reference.getIdentifier().getSystem()) && Utilities.noString((String)reference.getIdentifier().getValue())) {
                this.warning(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, !Utilities.noString((String)element.getNamedChildValue("display")), "Reference_REF_NoDisplay", new Object[0]);
            }
            return;
        }
        if (Utilities.existsInList((String)ref, (String[])new String[]{"http://tools.ietf.org/html/bcp47"})) {
            return;
        }
        this.warning(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, !this.isSuspiciousReference(ref), "REFERENCE_REF_SUSPICIOUS", ref);
        ResolvedReference we = this.localResolve(ref, stack, errors, path, (org.hl7.fhir.r5.elementmodel.Element)hostContext.getAppContext(), element);
        String refType = ref.startsWith("#") ? "contained" : (we == null ? "remote" : "bundled");
        IResourceValidator.ReferenceValidationPolicy referenceValidationPolicy = refType.equals("contained") || refType.equals("bundled") ? IResourceValidator.ReferenceValidationPolicy.CHECK_VALID : (pol = this.fetcher == null ? IResourceValidator.ReferenceValidationPolicy.IGNORE : this.fetcher.validationPolicy(hostContext.getAppContext(), path, ref));
        if (pol.checkExists()) {
            if (we == null && !refType.equals("contained")) {
                if (this.fetcher == null) {
                    throw new FHIRException(this.context.formatMessage("Resource_resolution_services_not_provided", new Object[0]));
                }
                org.hl7.fhir.r5.elementmodel.Element ext = null;
                if (this.fetchCache.containsKey(ref)) {
                    ext = this.fetchCache.get(ref);
                } else {
                    try {
                        ext = this.fetcher.fetch(hostContext.getAppContext(), ref);
                    }
                    catch (IOException e) {
                        throw new FHIRException((Throwable)e);
                    }
                    if (ext != null) {
                        InstanceValidator.setParents(ext);
                        this.fetchCache.put(ref, ext);
                    }
                }
                we = ext == null ? null : this.makeExternalRef(ext, path);
            }
            boolean ok = this.allowExamples && (ref.contains("example.org") || ref.contains("acme.com")) || we != null || pol == IResourceValidator.ReferenceValidationPolicy.CHECK_TYPE_IF_EXISTS;
            this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, ok, "Reference_REF_CantResolve", ref);
        }
        String ft = we != null ? we.getType() : this.tryParse(ref);
        if (reference.hasType()) {
            String tu = this.isAbsolute(reference.getType()) ? reference.getType() : "http://hl7.org/fhir/StructureDefinition/" + reference.getType();
            ElementDefinition.TypeRefComponent containerType = container.getType("Reference");
            if (!(containerType.hasTargetProfile(tu) || containerType.hasTargetProfile("http://hl7.org/fhir/StructureDefinition/Resource") || containerType.getTargetProfile().isEmpty())) {
                boolean matchingResource = false;
                for (Object target : containerType.getTargetProfile()) {
                    StructureDefinition sd = this.resolveProfile(profile, target.asStringValue());
                    if (!this.rule(errors, ValidationMessage.IssueType.NOTFOUND, element.line(), element.col(), path, sd != null, "Reference_REF_CantResolveProfile", target.asStringValue()) || !("http://hl7.org/fhir/StructureDefinition/" + sd.getType()).equals(tu)) continue;
                    matchingResource = true;
                    break;
                }
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, matchingResource, "Reference_REF_WrongTarget", reference.getType(), container.getType("Reference").getTargetProfile());
            }
            this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, ft == null || ft.equals(reference.getType()), "Reference_REF_BadTargetType", reference.getType(), ft);
        }
        if (we != null && pol.checkType() && this.warning(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, ft != null, "Reference_REF_NoType", new Object[0])) {
            boolean ok = false;
            ElementDefinition.TypeRefComponent type = this.getReferenceTypeRef(container.getType());
            if (type.hasTargetProfile() && !type.hasTargetProfile("http://hl7.org/fhir/StructureDefinition/Resource")) {
                HashSet<String> types = new HashSet<String>();
                ArrayList<StructureDefinition> profiles = new ArrayList<StructureDefinition>();
                for (UriType u : type.getTargetProfile()) {
                    StructureDefinition sd = this.resolveProfile(profile, (String)u.getValue());
                    if (!this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, sd != null, "Reference_REF_CantResolveProfile", u.getValue())) continue;
                    types.add(sd.getType());
                    if (!ft.equals(sd.getType())) continue;
                    ok = true;
                    profiles.add(sd);
                }
                if (!pol.checkValid()) {
                    this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, profiles.size() > 0, "Reference_REF_CantMatchType", ref, StringUtils.join((Object[])new Object[]{"; ", type.getTargetProfile()}));
                } else {
                    HashMap<StructureDefinition, ArrayList<ValidationMessage>> badProfiles = new HashMap<StructureDefinition, ArrayList<ValidationMessage>>();
                    HashMap<StructureDefinition, ArrayList<ValidationMessage>> goodProfiles = new HashMap<StructureDefinition, ArrayList<ValidationMessage>>();
                    int goodCount = 0;
                    for (StructureDefinition pr : profiles) {
                        ArrayList<ValidationMessage> profileErrors = new ArrayList<ValidationMessage>();
                        this.validateResource(we.hostContext(hostContext, pr), profileErrors, we.getResource(), we.getFocus(), pr, IResourceValidator.IdStatus.OPTIONAL, we.getStack().resetIds());
                        if (!this.hasErrors(profileErrors)) {
                            ++goodCount;
                            goodProfiles.put(pr, profileErrors);
                            this.trackUsage(pr, hostContext, element);
                            continue;
                        }
                        badProfiles.put(pr, profileErrors);
                    }
                    if (goodCount == 1) {
                        if (this.showMessagesFromReferences) {
                            for (ValidationMessage vm : (List)goodProfiles.values().iterator().next()) {
                                if (errors.contains(vm)) continue;
                                errors.add(vm);
                            }
                        }
                    } else if (goodProfiles.size() == 0) {
                        if (!this.isShowMessagesFromReferences()) {
                            this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, this.areAllBaseProfiles(profiles), "Reference_REF_CantMatchChoice", ref, this.asList(type.getTargetProfile()));
                            for (StructureDefinition sd : badProfiles.keySet()) {
                                this.slicingHint(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, false, this.context.formatMessage("Details_for__matching_against_Profile_", new Object[]{ref, sd.getUrl()}), this.errorSummaryForSlicingAsHtml((List)badProfiles.get(sd)));
                            }
                        } else {
                            this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, profiles.size() == 1, "Reference_REF_CantMatchChoice", ref, this.asList(type.getTargetProfile()));
                            for (List messages : badProfiles.values()) {
                                for (ValidationMessage vm : messages) {
                                    if (errors.contains(vm)) continue;
                                    errors.add(vm);
                                }
                            }
                        }
                    } else if (!this.isShowMessagesFromReferences()) {
                        this.warning(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, false, "Reference_REF_MultipleMatches", ref, this.asListByUrl(goodProfiles.keySet()));
                        for (StructureDefinition sd : badProfiles.keySet()) {
                            this.slicingHint(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, false, this.context.formatMessage("Details_for__matching_against_Profile_", new Object[]{ref, sd.getUrl()}), this.errorSummaryForSlicingAsHtml((List)badProfiles.get(sd)));
                        }
                    } else {
                        this.warning(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, false, "Reference_REF_MultipleMatches", ref, this.asListByUrl(goodProfiles.keySet()));
                        for (List messages : goodProfiles.values()) {
                            for (ValidationMessage vm : messages) {
                                if (errors.contains(vm)) continue;
                                errors.add(vm);
                            }
                        }
                    }
                }
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, ok, "Reference_REF_BadTargetType", ft, ((Object)types).toString());
            }
            if (type.hasAggregation() && !this.noCheckAggregation) {
                boolean modeOk = false;
                CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
                for (Enumeration mode : type.getAggregation()) {
                    b.append(mode.getCode());
                    if (((ElementDefinition.AggregationMode)mode.getValue()).equals((Object)ElementDefinition.AggregationMode.CONTAINED) && refType.equals("contained")) {
                        modeOk = true;
                        continue;
                    }
                    if (((ElementDefinition.AggregationMode)mode.getValue()).equals((Object)ElementDefinition.AggregationMode.BUNDLED) && refType.equals("bundled")) {
                        modeOk = true;
                        continue;
                    }
                    if (!((ElementDefinition.AggregationMode)mode.getValue()).equals((Object)ElementDefinition.AggregationMode.REFERENCED) || !refType.equals("bundled") && !refType.equals("remote")) continue;
                    modeOk = true;
                }
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, modeOk, "Reference_REF_Aggregation", refType, b.toString());
            }
        }
        if (we == null) {
            ElementDefinition.TypeRefComponent type = this.getReferenceTypeRef(container.getType());
            boolean okToRef = !type.hasAggregation() || type.hasAggregation(ElementDefinition.AggregationMode.REFERENCED);
            this.rule(errors, ValidationMessage.IssueType.REQUIRED, -1, -1, path, okToRef, "Reference_REF_NotFound_Bundle", ref);
        }
        if (we == null && ft != null && this.assumeValidRestReferences) {
            ElementDefinition.TypeRefComponent type = this.getReferenceTypeRef(container.getType());
            HashSet<String> types = new HashSet<String>();
            StructureDefinition sdFT = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + ft);
            boolean ok = false;
            block13: for (CanonicalType tp : type.getTargetProfile()) {
                StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, (String)tp.getValue());
                if (sd != null) {
                    types.add(sd.getType());
                }
                StructureDefinition sdF = sdFT;
                while (sdF != null) {
                    if (sdF.getType().equals(sd.getType())) {
                        ok = true;
                        continue block13;
                    }
                    sdF = sdF.hasBaseDefinition() ? (StructureDefinition)this.context.fetchResource(StructureDefinition.class, sdF.getBaseDefinition()) : null;
                }
            }
            this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, types.isEmpty() || ok, "Reference_REF_BadTargetType2", ft, ref, types);
        }
        if (pol == IResourceValidator.ReferenceValidationPolicy.CHECK_VALID) {
            // empty if block
        }
    }

    private boolean isSuspiciousReference(String url) {
        if (!this.assumeValidRestReferences || url == null || Utilities.isAbsoluteUrl((String)url)) {
            return false;
        }
        String[] parts = url.split("\\/");
        if (parts.length == 2 && this.context.getResourceNames().contains(parts[0]) && Utilities.isValidId((String)parts[1])) {
            return false;
        }
        return parts.length != 4 || !this.context.getResourceNames().contains(parts[0]) || !Utilities.isValidId((String)parts[1]) || !"_history".equals(parts[2]) || !Utilities.isValidId((String)parts[3]);
    }

    private String asListByUrl(Collection<StructureDefinition> list) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (StructureDefinition sd : list) {
            b.append(sd.getUrl());
        }
        return b.toString();
    }

    private String asList(Collection<CanonicalType> list) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (CanonicalType c : list) {
            b.append((String)c.getValue());
        }
        return b.toString();
    }

    private boolean areAllBaseProfiles(List<StructureDefinition> profiles) {
        for (StructureDefinition sd : profiles) {
            if (sd.getUrl().startsWith("http://hl7.org/fhir/StructureDefinition/")) continue;
            return false;
        }
        return true;
    }

    private String errorSummaryForSlicing(List<ValidationMessage> list) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (ValidationMessage vm : list) {
            if (vm.getLevel() != ValidationMessage.IssueSeverity.ERROR && vm.getLevel() != ValidationMessage.IssueSeverity.FATAL && !vm.isSlicingHint()) continue;
            b.append(vm.getLocation() + ": " + vm.getMessage());
        }
        return b.toString();
    }

    private String errorSummaryForSlicingAsHtml(List<ValidationMessage> list) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (ValidationMessage vm : list) {
            if (vm.isSlicingHint()) {
                b.append("<li>" + vm.getLocation() + ": " + vm.getSliceHtml() + "</li>");
                continue;
            }
            if (vm.getLevel() != ValidationMessage.IssueSeverity.ERROR && vm.getLevel() != ValidationMessage.IssueSeverity.FATAL) continue;
            b.append("<li>" + vm.getLocation() + ": " + vm.getHtml() + "</li>");
        }
        return "<ul>" + b.toString() + "</ul>";
    }

    private ElementDefinition.TypeRefComponent getReferenceTypeRef(List<ElementDefinition.TypeRefComponent> types) {
        for (ElementDefinition.TypeRefComponent tr : types) {
            if (!"Reference".equals(tr.getCode())) continue;
            return tr;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkResourceType(String type) {
        long t = System.nanoTime();
        try {
            if (this.context.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + type) != null) {
                String string = type;
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.timeTracker.sd(t);
        }
    }

    private void checkSampledData(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, SampledData fixed, String fixedSource, boolean pattern) {
        this.checkFixedValue(errors, path + ".origin", focus.getNamedChild("origin"), (org.hl7.fhir.r5.model.Element)fixed.getOrigin(), fixedSource, "origin", focus, pattern);
        this.checkFixedValue(errors, path + ".period", focus.getNamedChild("period"), (org.hl7.fhir.r5.model.Element)fixed.getPeriodElement(), fixedSource, "period", focus, pattern);
        this.checkFixedValue(errors, path + ".factor", focus.getNamedChild("factor"), (org.hl7.fhir.r5.model.Element)fixed.getFactorElement(), fixedSource, "factor", focus, pattern);
        this.checkFixedValue(errors, path + ".lowerLimit", focus.getNamedChild("lowerLimit"), (org.hl7.fhir.r5.model.Element)fixed.getLowerLimitElement(), fixedSource, "lowerLimit", focus, pattern);
        this.checkFixedValue(errors, path + ".upperLimit", focus.getNamedChild("upperLimit"), (org.hl7.fhir.r5.model.Element)fixed.getUpperLimitElement(), fixedSource, "upperLimit", focus, pattern);
        this.checkFixedValue(errors, path + ".dimensions", focus.getNamedChild("dimensions"), (org.hl7.fhir.r5.model.Element)fixed.getDimensionsElement(), fixedSource, "dimensions", focus, pattern);
        this.checkFixedValue(errors, path + ".data", focus.getNamedChild("data"), (org.hl7.fhir.r5.model.Element)fixed.getDataElement(), fixedSource, "data", focus, pattern);
    }

    private void checkReference(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, Reference fixed, String fixedSource, boolean pattern) {
        this.checkFixedValue(errors, path + ".reference", focus.getNamedChild("reference"), (org.hl7.fhir.r5.model.Element)fixed.getReferenceElement_(), fixedSource, "reference", focus, pattern);
        this.checkFixedValue(errors, path + ".type", focus.getNamedChild("type"), (org.hl7.fhir.r5.model.Element)fixed.getTypeElement(), fixedSource, "type", focus, pattern);
        this.checkFixedValue(errors, path + ".identifier", focus.getNamedChild("identifier"), (org.hl7.fhir.r5.model.Element)fixed.getIdentifier(), fixedSource, "identifier", focus, pattern);
        this.checkFixedValue(errors, path + ".display", focus.getNamedChild("display"), (org.hl7.fhir.r5.model.Element)fixed.getDisplayElement(), fixedSource, "display", focus, pattern);
    }

    private void checkTiming(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, Timing fixed, String fixedSource, boolean pattern) {
        this.checkFixedValue(errors, path + ".repeat", focus.getNamedChild("repeat"), (org.hl7.fhir.r5.model.Element)fixed.getRepeat(), fixedSource, "value", focus, pattern);
        ArrayList events = new ArrayList();
        focus.getNamedChildren("event", events);
        if (this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, events.size() == fixed.getEvent().size(), "Bundle_MSG_Event_Count", Integer.toString(fixed.getEvent().size()), Integer.toString(events.size()))) {
            for (int i = 0; i < events.size(); ++i) {
                this.checkFixedValue(errors, path + ".event", (org.hl7.fhir.r5.elementmodel.Element)events.get(i), (org.hl7.fhir.r5.model.Element)fixed.getEvent().get(i), fixedSource, "event", focus, pattern);
            }
        }
    }

    private boolean codeinExpansion(ValueSet.ValueSetExpansionContainsComponent cnt, String system, String code) {
        for (ValueSet.ValueSetExpansionContainsComponent c : cnt.getContains()) {
            if (code.equals(c.getCode()) && system.equals(c.getSystem().toString())) {
                return true;
            }
            if (!this.codeinExpansion(c, system, code)) continue;
            return true;
        }
        return false;
    }

    private boolean codeInExpansion(ValueSet vs, String system, String code) {
        for (ValueSet.ValueSetExpansionContainsComponent c : vs.getExpansion().getContains()) {
            if (code.equals(c.getCode()) && (system == null || system.equals(c.getSystem()))) {
                return true;
            }
            if (!this.codeinExpansion(c, system, code)) continue;
            return true;
        }
        return false;
    }

    private String describeReference(String reference, CanonicalResource target) {
        if (reference == null && target == null) {
            return "null";
        }
        if (reference == null) {
            return target.getUrl();
        }
        if (target == null) {
            return reference;
        }
        if (reference.equals(target.getUrl())) {
            return reference;
        }
        return reference + "(which actually refers to " + target.getUrl() + ")";
    }

    private String describeTypes(List<ElementDefinition.TypeRefComponent> types) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (ElementDefinition.TypeRefComponent t : types) {
            b.append(t.getWorkingCode());
        }
        return b.toString();
    }

    protected ElementDefinition findElement(StructureDefinition profile, String name) {
        for (ElementDefinition c : profile.getSnapshot().getElement()) {
            if (!c.getPath().equals(name)) continue;
            return c;
        }
        return null;
    }

    public IResourceValidator.BestPracticeWarningLevel getBestPracticeWarningLevel() {
        return this.bpWarnings;
    }

    public IResourceValidator.CheckDisplayOption getCheckDisplay() {
        return this.checkDisplay;
    }

    private CodeSystem.ConceptDefinitionComponent getCodeDefinition(CodeSystem.ConceptDefinitionComponent c, String code) {
        if (code.equals(c.getCode())) {
            return c;
        }
        for (CodeSystem.ConceptDefinitionComponent g : c.getConcept()) {
            CodeSystem.ConceptDefinitionComponent r = this.getCodeDefinition(g, code);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    private CodeSystem.ConceptDefinitionComponent getCodeDefinition(CodeSystem cs, String code) {
        for (CodeSystem.ConceptDefinitionComponent c : cs.getConcept()) {
            CodeSystem.ConceptDefinitionComponent r = this.getCodeDefinition(c, code);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    private IndexedElement getContainedById(org.hl7.fhir.r5.elementmodel.Element container, String id) {
        ArrayList contained = new ArrayList();
        container.getNamedChildren("contained", contained);
        for (int i = 0; i < contained.size(); ++i) {
            org.hl7.fhir.r5.elementmodel.Element we = (org.hl7.fhir.r5.elementmodel.Element)contained.get(i);
            if (!id.equals(we.getNamedChildValue("id"))) continue;
            return new IndexedElement(i, we, null);
        }
        return null;
    }

    public IWorkerContext getContext() {
        return this.context;
    }

    private List<ElementDefinition> getCriteriaForDiscriminator(String path, ElementDefinition element, String discriminator, StructureDefinition profile, boolean removeResolve) throws FHIRException {
        ArrayList<ElementDefinition> elements = new ArrayList<ElementDefinition>();
        if ("value".equals(discriminator) && element.hasFixed()) {
            elements.add(element);
            return elements;
        }
        if (removeResolve) {
            if (discriminator.equals("resolve()")) {
                elements.add(element);
                return elements;
            }
            if (discriminator.endsWith(".resolve()")) {
                discriminator = discriminator.substring(0, discriminator.length() - 10);
            }
        }
        ElementDefinition ed = null;
        String fp = this.fixExpr(discriminator, null);
        ExpressionNode expr = null;
        try {
            expr = this.fpe.parse(fp);
        }
        catch (Exception e) {
            throw new FHIRException(this.context.formatMessage("DISCRIMINATOR_BAD_PATH", new Object[]{e.getMessage(), fp}), (Throwable)e);
        }
        long t2 = System.nanoTime();
        ed = this.fpe.evaluateDefinition(expr, profile, element);
        this.timeTracker.sd(t2);
        if (ed != null) {
            elements.add(ed);
        }
        for (ElementDefinition.TypeRefComponent type : element.getType()) {
            for (CanonicalType p : type.getProfile()) {
                String id = p.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-profile-element") ? p.getExtensionString("http://hl7.org/fhir/StructureDefinition/elementdefinition-profile-element") : null;
                StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, (String)p.getValue());
                if (sd == null) {
                    throw new DefinitionException(this.context.formatMessage("Unable_to_resolve_profile_", new Object[]{p}));
                }
                profile = sd;
                if (id == null) {
                    element = sd.getSnapshot().getElementFirstRep();
                } else {
                    element = null;
                    for (ElementDefinition t : sd.getSnapshot().getElement()) {
                        if (!id.equals(t.getId())) continue;
                        element = t;
                    }
                    if (element == null) {
                        throw new DefinitionException(this.context.formatMessage("Unable_to_resolve_element__in_profile_", new Object[]{id, p}));
                    }
                }
                expr = this.fpe.parse(fp);
                t2 = System.nanoTime();
                ed = this.fpe.evaluateDefinition(expr, profile, element);
                this.timeTracker.sd(t2);
                if (ed == null) continue;
                elements.add(ed);
            }
        }
        return elements;
    }

    private org.hl7.fhir.r5.elementmodel.Element getExtensionByUrl(List<org.hl7.fhir.r5.elementmodel.Element> extensions, String urlSimple) {
        for (org.hl7.fhir.r5.elementmodel.Element e : extensions) {
            if (!urlSimple.equals(e.getNamedChildValue("url"))) continue;
            return e;
        }
        return null;
    }

    public List<String> getExtensionDomains() {
        return this.extensionDomains;
    }

    public List<ImplementationGuide> getImplementationGuides() {
        return this.igs;
    }

    private StructureDefinition getProfileForType(String type, List<ElementDefinition.TypeRefComponent> list) {
        for (ElementDefinition.TypeRefComponent tr : list) {
            String url = tr.getWorkingCode();
            if (!Utilities.isAbsoluteUrl((String)url)) {
                url = "http://hl7.org/fhir/StructureDefinition/" + url;
            }
            long t = System.nanoTime();
            StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, url);
            this.timeTracker.sd(t);
            if (sd == null || !sd.getType().equals(type) && !sd.getUrl().equals(type) || !sd.hasSnapshot()) continue;
            return sd;
        }
        return null;
    }

    private org.hl7.fhir.r5.elementmodel.Element getValueForDiscriminator(Object appContext, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, String discriminator, ElementDefinition criteria, NodeStack stack) throws FHIRException, IOException {
        String[] dlist;
        String p = stack.getLiteralPath() + "." + element.getName();
        org.hl7.fhir.r5.elementmodel.Element focus = element;
        for (String d : dlist = discriminator.split("\\.")) {
            if (focus.fhirType().equals("Reference") && d.equals("reference")) {
                String url = focus.getChildValue("reference");
                if (Utilities.noString((String)url)) {
                    throw new FHIRException(this.context.formatMessage("No_reference_resolving_discriminator__from_", new Object[]{discriminator, element.getProperty().getName()}));
                }
                org.hl7.fhir.r5.elementmodel.Element target = this.resolve(appContext, url, stack, errors, p);
                if (target == null) {
                    throw new FHIRException(this.context.formatMessage("Unable_to_find_resource__at__resolving_discriminator__from_", new Object[]{url, d, discriminator, element.getProperty().getName()}));
                }
                focus = target;
                continue;
            }
            if (d.equals("value") && focus.isPrimitive()) {
                return focus;
            }
            List children = focus.getChildren(d);
            if (children.isEmpty()) {
                throw new FHIRException(this.context.formatMessage("Unable_to_find__resolving_discriminator__from_", new Object[]{d, discriminator, element.getProperty().getName()}));
            }
            if (children.size() > 1) {
                throw new FHIRException(this.context.formatMessage("Found__items_for__resolving_discriminator__from_", new Object[]{Integer.toString(children.size()), d, discriminator, element.getProperty().getName()}));
            }
            focus = (org.hl7.fhir.r5.elementmodel.Element)children.get(0);
            p = p + "." + d;
        }
        return focus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CodeSystem getCodeSystem(String system) {
        long t = System.nanoTime();
        try {
            CodeSystem codeSystem = this.context.fetchCodeSystem(system);
            return codeSystem;
        }
        finally {
            this.timeTracker.tx(t);
        }
    }

    private boolean hasTime(String fmt) {
        return fmt.contains("T");
    }

    private boolean hasTimeZone(String fmt) {
        return fmt.length() > 10 && (fmt.substring(10).contains("-") || fmt.substring(10).contains("+") || fmt.substring(10).contains("Z"));
    }

    private boolean isAbsolute(String uri) {
        return Utilities.noString((String)uri) || uri.startsWith("http:") || uri.startsWith("https:") || uri.startsWith("urn:uuid:") || uri.startsWith("urn:oid:") || uri.startsWith("urn:ietf:") || uri.startsWith("urn:iso:") || uri.startsWith("urn:iso-astm:") || uri.startsWith("mailto:") || this.isValidFHIRUrn(uri);
    }

    private boolean isValidFHIRUrn(String uri) {
        return uri.equals("urn:x-fhir:uk:id:nhs-number") || uri.startsWith("urn:");
    }

    public boolean isAnyExtensionsAllowed() {
        return this.anyExtensionsAllowed;
    }

    public boolean isErrorForUnknownProfiles() {
        return this.errorForUnknownProfiles;
    }

    public void setErrorForUnknownProfiles(boolean errorForUnknownProfiles) {
        this.errorForUnknownProfiles = errorForUnknownProfiles;
    }

    private boolean isParametersEntry(String path) {
        String[] parts = path.split("\\.");
        return parts.length > 2 && parts[parts.length - 1].equals("resource") && (InstanceValidator.pathEntryHasName(parts[parts.length - 2], "parameter") || InstanceValidator.pathEntryHasName(parts[parts.length - 2], "part"));
    }

    private boolean isBundleEntry(String path) {
        String[] parts = path.split("\\.");
        return parts.length > 2 && parts[parts.length - 1].equals("resource") && InstanceValidator.pathEntryHasName(parts[parts.length - 2], "entry");
    }

    private boolean isBundleOutcome(String path) {
        String[] parts = path.split("\\.");
        return parts.length > 2 && parts[parts.length - 1].equals("outcome") && InstanceValidator.pathEntryHasName(parts[parts.length - 2], "response");
    }

    private static boolean pathEntryHasName(String thePathEntry, String theName) {
        if (thePathEntry.equals(theName)) {
            return true;
        }
        return thePathEntry.length() >= theName.length() + 3 && thePathEntry.startsWith(theName) && thePathEntry.charAt(theName.length()) == '[';
    }

    public boolean isPrimitiveType(String code) {
        StructureDefinition sd = this.context.fetchTypeDefinition(code);
        return sd != null && sd.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE;
    }

    private String getErrorMessage(String message) {
        return message != null ? " (error message = " + message + ")" : "";
    }

    public boolean isSuppressLoincSnomedMessages() {
        return this.suppressLoincSnomedMessages;
    }

    private boolean nameMatches(String name, String tail) {
        if (tail.endsWith("[x]")) {
            return name.startsWith(tail.substring(0, tail.length() - 3));
        }
        return name.equals(tail);
    }

    private boolean passesCodeWhitespaceRules(String v) {
        if (!v.trim().equals(v)) {
            return false;
        }
        boolean lastWasSpace = true;
        for (char c : v.toCharArray()) {
            if (c == ' ') {
                if (lastWasSpace) {
                    return false;
                }
                lastWasSpace = true;
                continue;
            }
            if (Character.isWhitespace(c)) {
                return false;
            }
            lastWasSpace = false;
        }
        return true;
    }

    private ResolvedReference localResolve(String ref, NodeStack stack, List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element hostContext, org.hl7.fhir.r5.elementmodel.Element source) {
        String type;
        if (ref.startsWith("#")) {
            boolean wasContained = false;
            for (NodeStack nstack = stack; nstack != null && nstack.getElement() != null; nstack = nstack.getParent()) {
                if (nstack.getElement().getProperty().isResource()) {
                    IndexedElement res;
                    if (ref.equals("#") && nstack.getElement().getSpecial() != Element.SpecialElement.CONTAINED && wasContained) {
                        ResolvedReference rr = new ResolvedReference();
                        rr.setResource(nstack.getElement());
                        rr.setFocus(nstack.getElement());
                        rr.setExternal(false);
                        rr.setStack(nstack.push(nstack.getElement(), -1, nstack.getElement().getProperty().getDefinition(), nstack.getElement().getProperty().getDefinition()));
                        rr.getStack().qualifyPath(".ofType(" + nstack.getElement().fhirType() + ")");
                        return rr;
                    }
                    if (nstack.getElement().getSpecial() == Element.SpecialElement.CONTAINED) {
                        wasContained = true;
                    }
                    if ((res = this.getContainedById(nstack.getElement(), ref.substring(1))) != null) {
                        ResolvedReference rr = new ResolvedReference();
                        rr.setResource(nstack.getElement());
                        rr.setFocus(res.getMatch());
                        rr.setExternal(false);
                        rr.setStack(nstack.push(res.getMatch(), res.getIndex(), res.getMatch().getProperty().getDefinition(), res.getMatch().getProperty().getDefinition()));
                        rr.getStack().qualifyPath(".ofType(" + nstack.getElement().fhirType() + ")");
                        return rr;
                    }
                }
                if (nstack.getElement().getSpecial() != Element.SpecialElement.BUNDLE_ENTRY && nstack.getElement().getSpecial() != Element.SpecialElement.PARAMETER) continue;
                return null;
            }
            if (ref.equals("#")) {
                for (org.hl7.fhir.r5.elementmodel.Element e = stack.getElement(); e != null; e = e.getParentForValidator()) {
                    if (!e.getProperty().isResource() || e.getSpecial() == Element.SpecialElement.CONTAINED) continue;
                    ResolvedReference rr = new ResolvedReference();
                    rr.setResource(e);
                    rr.setFocus(e);
                    rr.setExternal(false);
                    rr.setStack(stack.push(e, -1, e.getProperty().getDefinition(), e.getProperty().getDefinition()));
                    rr.getStack().qualifyPath(".ofType(" + e.fhirType() + ")");
                    return rr;
                }
            }
            return null;
        }
        String fullUrl = null;
        while (stack != null && stack.getElement() != null) {
            NodeStack tgt;
            if (stack.getElement().getSpecial() == Element.SpecialElement.BUNDLE_ENTRY && fullUrl == null && stack.getParent() != null && stack.getParent().getElement().getName().equals("entry")) {
                type = stack.getParent().getParent().getElement().getChildValue("type");
                fullUrl = stack.getParent().getElement().getChildValue("fullUrl");
                if (fullUrl == null) {
                    this.rule(errors, ValidationMessage.IssueType.REQUIRED, stack.getParent().getElement().line(), stack.getParent().getElement().col(), stack.getParent().getLiteralPath(), Utilities.existsInList((String)type, (String[])new String[]{"batch-response", "transaction-response"}) || fullUrl != null, "Bundle_BUNDLE_Entry_NoFullUrl", new Object[0]);
                }
            }
            if ("Bundle".equals(stack.getElement().getType())) {
                type = stack.getElement().getChildValue("type");
                IndexedElement res = this.getFromBundle(stack.getElement(), ref, fullUrl, errors, path, type, "transaction".equals(type));
                if (res == null) {
                    return null;
                }
                ResolvedReference rr = new ResolvedReference();
                rr.setResource(res.getMatch());
                rr.setFocus(res.getMatch());
                rr.setExternal(false);
                rr.setStack(stack.push(res.getEntry(), res.getIndex(), res.getEntry().getProperty().getDefinition(), res.getEntry().getProperty().getDefinition()).push(res.getMatch(), -1, res.getMatch().getProperty().getDefinition(), res.getMatch().getProperty().getDefinition()));
                rr.getStack().qualifyPath(".ofType(" + rr.getResource().fhirType() + ")");
                return rr;
            }
            if (stack.getElement().getSpecial() == Element.SpecialElement.PARAMETER && stack.getParent() != null && (tgt = this.findInParams(stack.getParent().getParent(), ref)) != null) {
                ResolvedReference rr = new ResolvedReference();
                rr.setResource(tgt.getElement());
                rr.setFocus(tgt.getElement());
                rr.setExternal(false);
                rr.setStack(tgt);
                rr.getStack().qualifyPath(".ofType(" + tgt.getElement().fhirType() + ")");
                return rr;
            }
            stack = stack.getParent();
        }
        if (hostContext != null && "Bundle".equals(hostContext.fhirType())) {
            type = hostContext.getChildValue("type");
            org.hl7.fhir.r5.elementmodel.Element entry = this.getEntryForSource(hostContext, source);
            fullUrl = entry.getChildValue("fullUrl");
            IndexedElement res = this.getFromBundle(hostContext, ref, fullUrl, errors, path, type, "transaction".equals(type));
            if (res == null) {
                return null;
            }
            ResolvedReference rr = new ResolvedReference();
            rr.setResource(res.getMatch());
            rr.setFocus(res.getMatch());
            rr.setExternal(false);
            rr.setStack(new NodeStack(this.context, hostContext, this.validationLanguage).push(res.getEntry(), res.getIndex(), res.getEntry().getProperty().getDefinition(), res.getEntry().getProperty().getDefinition()).push(res.getMatch(), -1, res.getMatch().getProperty().getDefinition(), res.getMatch().getProperty().getDefinition()));
            rr.getStack().qualifyPath(".ofType(" + rr.getResource().fhirType() + ")");
            return rr;
        }
        return null;
    }

    private NodeStack findInParams(NodeStack params, String ref) {
        int i = 0;
        for (org.hl7.fhir.r5.elementmodel.Element child : params.getElement().getChildren("parameter")) {
            org.hl7.fhir.r5.elementmodel.Element res;
            NodeStack p = params.push(child, i, child.getProperty().getDefinition(), child.getProperty().getDefinition());
            if (child.hasChild("resource") && ((res = child.getNamedChild("resource")).fhirType() + "/" + res.getIdBase()).equals(ref)) {
                return p.push(res, -1, res.getProperty().getDefinition(), res.getProperty().getDefinition());
            }
            NodeStack pc = this.findInParamParts(p, child, ref);
            if (pc == null) continue;
            return pc;
        }
        return null;
    }

    private NodeStack findInParamParts(NodeStack pp, org.hl7.fhir.r5.elementmodel.Element param, String ref) {
        int i = 0;
        for (org.hl7.fhir.r5.elementmodel.Element child : param.getChildren("part")) {
            org.hl7.fhir.r5.elementmodel.Element res;
            NodeStack p = pp.push(child, i, child.getProperty().getDefinition(), child.getProperty().getDefinition());
            if (child.hasChild("resource") && ((res = child.getNamedChild("resource")).fhirType() + "/" + res.getIdBase()).equals(ref)) {
                return p.push(res, -1, res.getProperty().getDefinition(), res.getProperty().getDefinition());
            }
            NodeStack pc = this.findInParamParts(p, child, ref);
            if (pc == null) continue;
            return pc;
        }
        return null;
    }

    private org.hl7.fhir.r5.elementmodel.Element getEntryForSource(org.hl7.fhir.r5.elementmodel.Element bundle, org.hl7.fhir.r5.elementmodel.Element element) {
        ArrayList entries = new ArrayList();
        bundle.getNamedChildren("entry", entries);
        for (org.hl7.fhir.r5.elementmodel.Element entry : entries) {
            if (!entry.hasDescendant(element)) continue;
            return entry;
        }
        return null;
    }

    private ResolvedReference makeExternalRef(org.hl7.fhir.r5.elementmodel.Element external, String path) {
        ResolvedReference res = new ResolvedReference();
        res.setResource(external);
        res.setFocus(external);
        res.setExternal(true);
        res.setStack(new NodeStack(this.context, external, path, this.validationLanguage));
        return res;
    }

    private org.hl7.fhir.r5.elementmodel.Element resolve(Object appContext, String ref, NodeStack stack, List<ValidationMessage> errors, String path) throws IOException, FHIRException {
        org.hl7.fhir.r5.elementmodel.Element local = this.localResolve(ref, stack, errors, path, null, null).getFocus();
        if (local != null) {
            return local;
        }
        if (this.fetcher == null) {
            return null;
        }
        if (this.fetchCache.containsKey(ref)) {
            return this.fetchCache.get(ref);
        }
        org.hl7.fhir.r5.elementmodel.Element res = this.fetcher.fetch(appContext, ref);
        InstanceValidator.setParents(res);
        this.fetchCache.put(ref, res);
        return res;
    }

    private ElementDefinition resolveNameReference(StructureDefinition.StructureDefinitionSnapshotComponent snapshot, String contentReference) {
        for (ElementDefinition ed : snapshot.getElement()) {
            if (!contentReference.equals("#" + ed.getId())) continue;
            return ed;
        }
        return null;
    }

    private StructureDefinition resolveProfile(StructureDefinition profile, String pr) {
        if (pr.startsWith("#")) {
            for (Resource r : profile.getContained()) {
                if (!r.getId().equals(pr.substring(1)) || !(r instanceof StructureDefinition)) continue;
                return (StructureDefinition)r;
            }
            return null;
        }
        long t = System.nanoTime();
        StructureDefinition fr = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, pr);
        this.timeTracker.sd(t);
        return fr;
    }

    private ElementDefinition resolveType(String type, List<ElementDefinition.TypeRefComponent> list) {
        for (ElementDefinition.TypeRefComponent tr : list) {
            String url = tr.getWorkingCode();
            if (!Utilities.isAbsoluteUrl((String)url)) {
                url = "http://hl7.org/fhir/StructureDefinition/" + url;
            }
            long t = System.nanoTime();
            StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, url);
            this.timeTracker.sd(t);
            if (sd == null || !sd.getType().equals(type) && !sd.getUrl().equals(type) || !sd.hasSnapshot()) continue;
            return (ElementDefinition)sd.getSnapshot().getElement().get(0);
        }
        return null;
    }

    public void setAnyExtensionsAllowed(boolean anyExtensionsAllowed) {
        this.anyExtensionsAllowed = anyExtensionsAllowed;
    }

    public IResourceValidator setBestPracticeWarningLevel(IResourceValidator.BestPracticeWarningLevel value) {
        this.bpWarnings = value;
        return this;
    }

    public void setCheckDisplay(IResourceValidator.CheckDisplayOption checkDisplay) {
        this.checkDisplay = checkDisplay;
    }

    public void setSuppressLoincSnomedMessages(boolean suppressLoincSnomedMessages) {
        this.suppressLoincSnomedMessages = suppressLoincSnomedMessages;
    }

    public IResourceValidator.IdStatus getResourceIdRule() {
        return this.resourceIdRule;
    }

    public void setResourceIdRule(IResourceValidator.IdStatus resourceIdRule) {
        this.resourceIdRule = resourceIdRule;
    }

    public boolean isAllowXsiLocation() {
        return this.allowXsiLocation;
    }

    public void setAllowXsiLocation(boolean allowXsiLocation) {
        this.allowXsiLocation = allowXsiLocation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean sliceMatches(ValidatorHostContext hostContext, org.hl7.fhir.r5.elementmodel.Element element, String path, ElementDefinition slicer, ElementDefinition ed, StructureDefinition profile, List<ValidationMessage> errors, List<ValidationMessage> sliceInfo, NodeStack stack) throws DefinitionException, FHIRException {
        ValidatorHostContext shc;
        boolean pass;
        if (!slicer.getSlicing().hasDiscriminator()) {
            return false;
        }
        ExpressionNode n = (ExpressionNode)ed.getUserData("slice.expression.cache");
        if (n == null) {
            long t = System.nanoTime();
            StringBuilder expression = new StringBuilder("true");
            boolean anyFound = false;
            HashSet<String> discriminators = new HashSet<String>();
            for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent s : slicer.getSlicing().getDiscriminator()) {
                String discriminator = s.getPath();
                discriminators.add(discriminator);
                List<ElementDefinition> criteriaElements = this.getCriteriaForDiscriminator(path, ed, discriminator, profile, s.getType() == ElementDefinition.DiscriminatorType.PROFILE);
                boolean found = false;
                for (ElementDefinition criteriaElement : criteriaElements) {
                    found = true;
                    if (s.getType() == ElementDefinition.DiscriminatorType.TYPE) {
                        String type = null;
                        if (!criteriaElement.getPath().contains("[") && discriminator.contains("[")) {
                            discriminator = discriminator.substring(0, discriminator.indexOf(91));
                            String lastNode = this.tail(discriminator);
                            type = this.tail(criteriaElement.getPath()).substring(lastNode.length());
                            type = type.substring(0, 1).toLowerCase() + type.substring(1);
                        } else if (!criteriaElement.hasType() || criteriaElement.getType().size() == 1) {
                            if (discriminator.contains("[")) {
                                discriminator = discriminator.substring(0, discriminator.indexOf(91));
                            }
                            if (criteriaElement.hasType()) {
                                type = ((ElementDefinition.TypeRefComponent)criteriaElement.getType().get(0)).getWorkingCode();
                            } else {
                                if (criteriaElement.getPath().contains(".")) throw new DefinitionException(this.context.formatMessage("Discriminator__is_based_on_type_but_slice__in__has_no_types", new Object[]{discriminator, ed.getId(), profile.getUrl()}));
                                type = criteriaElement.getPath();
                            }
                        } else {
                            if (criteriaElement.getType().size() <= 1) throw new DefinitionException(this.context.formatMessage("Discriminator__is_based_on_type_but_slice__in__has_no_types", new Object[]{discriminator, ed.getId(), profile.getUrl()}));
                            throw new DefinitionException(this.context.formatMessage("Discriminator__is_based_on_type_but_slice__in__has_multiple_types_", new Object[]{discriminator, ed.getId(), profile.getUrl(), criteriaElement.typeSummary()}));
                        }
                        if (discriminator.isEmpty()) {
                            expression.append(" and $this is " + type);
                        } else {
                            expression.append(" and " + discriminator + " is " + type);
                        }
                    } else if (s.getType() == ElementDefinition.DiscriminatorType.PROFILE) {
                        List list;
                        if (criteriaElement.getType().size() == 0) {
                            throw new DefinitionException(this.context.formatMessage("Profile_based_discriminators_must_have_a_type__in_profile_", new Object[]{criteriaElement.getId(), profile.getUrl()}));
                        }
                        if (criteriaElement.getType().size() != 1) {
                            throw new DefinitionException(this.context.formatMessage("Profile_based_discriminators_must_have_only_one_type__in_profile_", new Object[]{criteriaElement.getId(), profile.getUrl()}));
                        }
                        List list2 = list = discriminator.endsWith(".resolve()") || discriminator.equals("resolve()") ? ((ElementDefinition.TypeRefComponent)criteriaElement.getType().get(0)).getTargetProfile() : ((ElementDefinition.TypeRefComponent)criteriaElement.getType().get(0)).getProfile();
                        if (list.size() == 0) {
                            throw new DefinitionException(this.context.formatMessage("Profile_based_discriminators_must_have_a_type_with_a_profile__in_profile_", new Object[]{criteriaElement.getId(), profile.getUrl()}));
                        }
                        if (list.size() > 1) {
                            CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder(" or ");
                            for (CanonicalType c : list) {
                                b.append(discriminator + ".conformsTo('" + (String)c.getValue() + "')");
                            }
                            expression.append(" and (" + b + ")");
                        } else {
                            expression.append(" and " + discriminator + ".conformsTo('" + (String)((CanonicalType)list.get(0)).getValue() + "')");
                        }
                    } else if (s.getType() == ElementDefinition.DiscriminatorType.EXISTS) {
                        if (criteriaElement.hasMin() && criteriaElement.getMin() >= 1) {
                            expression.append(" and (" + discriminator + ".exists())");
                        } else {
                            if (!criteriaElement.hasMax() || !criteriaElement.getMax().equals("0")) throw new FHIRException(this.context.formatMessage("Discriminator__is_based_on_element_existence_but_slice__neither_sets_min1_or_max0", new Object[]{discriminator, ed.getId()}));
                            expression.append(" and (" + discriminator + ".exists().not())");
                        }
                    } else if (criteriaElement.hasFixed()) {
                        this.buildFixedExpression(ed, expression, discriminator, criteriaElement);
                    } else if (criteriaElement.hasPattern()) {
                        this.buildPattternExpression(ed, expression, discriminator, criteriaElement);
                    } else if (criteriaElement.hasBinding() && criteriaElement.getBinding().hasStrength() && criteriaElement.getBinding().getStrength().equals((Object)Enumerations.BindingStrength.REQUIRED) && criteriaElement.getBinding().hasValueSet()) {
                        expression.append(" and (" + discriminator + " memberOf '" + criteriaElement.getBinding().getValueSet() + "')");
                    } else {
                        found = false;
                    }
                    if (!found) continue;
                    break;
                }
                if (!found) continue;
                anyFound = true;
            }
            if (!anyFound) {
                if (slicer.getSlicing().getDiscriminator().size() <= 1) throw new DefinitionException(this.context.formatMessage("Could_not_match_discriminator__for_slice__in_profile___the_discriminator__does_not_have_fixed_value_binding_or_existence_assertions", new Object[]{discriminators, ed.getId(), profile.getUrl(), discriminators}));
                throw new DefinitionException(this.context.formatMessage("Could_not_match_any_discriminators__for_slice__in_profile___None_of_the_discriminator__have_fixed_value_binding_or_existence_assertions", new Object[]{discriminators, ed.getId(), profile.getUrl(), discriminators}));
            }
            try {
                n = this.fpe.parse(this.fixExpr(expression.toString(), null));
            }
            catch (FHIRLexer.FHIRLexerException e) {
                throw new FHIRException(this.context.formatMessage("Problem_processing_expression__in_profile__path__", new Object[]{expression, profile.getUrl(), path, e.getMessage()}));
            }
            this.timeTracker.fpe(t);
            ed.setUserData("slice.expression.cache", (Object)n);
        }
        if (pass = this.evaluateSlicingExpression(shc = hostContext.forSlicing(), element, path, profile, n)) return pass;
        this.slicingHint(sliceInfo, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, false, this.context.formatMessage("Does_not_match_slice_", new Object[]{ed.getSliceName()}), "discriminator = " + Utilities.escapeXml((String)n.toString()));
        for (String url : shc.getSliceRecords().keySet()) {
            this.slicingHint(sliceInfo, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, false, this.context.formatMessage("Details_for__matching_against_Profile_", new Object[]{stack.getLiteralPath(), url}), this.context.formatMessage("Profile__does_not_match_for__because_of_the_following_profile_issues__", new Object[]{url, stack.getLiteralPath(), this.errorSummaryForSlicingAsHtml(shc.getSliceRecords().get(url))}));
        }
        return pass;
    }

    public boolean evaluateSlicingExpression(ValidatorHostContext hostContext, org.hl7.fhir.r5.elementmodel.Element element, String path, StructureDefinition profile, ExpressionNode n) throws FHIRException {
        boolean ok;
        try {
            long t = System.nanoTime();
            ok = this.fpe.evaluateToBoolean((Object)hostContext.forProfile(profile), (Base)hostContext.getResource(), (Base)hostContext.getRootResource(), (Base)element, n);
            this.timeTracker.fpe(t);
            String msg = this.fpe.forLog();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new FHIRException(this.context.formatMessage("Problem_evaluating_slicing_expression_for_element_in_profile__path__fhirPath___", new Object[]{profile.getUrl(), path, n, ex.getMessage()}));
        }
        return ok;
    }

    private void buildPattternExpression(ElementDefinition ed, StringBuilder expression, String discriminator, ElementDefinition criteriaElement) throws DefinitionException {
        DataType pattern = criteriaElement.getPattern();
        if (pattern instanceof CodeableConcept) {
            CodeableConcept cc = (CodeableConcept)pattern;
            expression.append(" and ");
            this.buildCodeableConceptExpression(ed, expression, discriminator, cc);
        } else if (pattern instanceof Coding) {
            Coding c = (Coding)pattern;
            expression.append(" and ");
            this.buildCodingExpression(ed, expression, discriminator, c);
        } else if (pattern instanceof BooleanType || pattern instanceof IntegerType || pattern instanceof DecimalType) {
            expression.append(" and ");
            this.buildPrimitiveExpression(ed, expression, discriminator, pattern, false);
        } else if (pattern instanceof PrimitiveType) {
            expression.append(" and ");
            this.buildPrimitiveExpression(ed, expression, discriminator, pattern, true);
        } else if (pattern instanceof Identifier) {
            Identifier ii = (Identifier)pattern;
            expression.append(" and ");
            this.buildIdentifierExpression(ed, expression, discriminator, ii);
        } else if (pattern instanceof HumanName) {
            HumanName name = (HumanName)pattern;
            expression.append(" and ");
            this.buildHumanNameExpression(ed, expression, discriminator, name);
        } else if (pattern instanceof Address) {
            Address add = (Address)pattern;
            expression.append(" and ");
            this.buildAddressExpression(ed, expression, discriminator, add);
        } else {
            throw new DefinitionException(this.context.formatMessage("Unsupported_fixed_pattern_type_for_discriminator_for_slice__", new Object[]{discriminator, ed.getId(), pattern.fhirType()}));
        }
    }

    private void buildIdentifierExpression(ElementDefinition ed, StringBuilder expression, String discriminator, Identifier ii) throws DefinitionException {
        if (ii.hasExtension()) {
            throw new DefinitionException(this.context.formatMessage("Unsupported_Identifier_pattern__extensions_are_not_allowed__for_discriminator_for_slice_", new Object[]{discriminator, ed.getId()}));
        }
        boolean first = true;
        expression.append(discriminator + ".where(");
        if (ii.hasSystem()) {
            first = false;
            expression.append("system = '" + ii.getSystem() + "'");
        }
        if (ii.hasValue()) {
            if (first) {
                first = false;
            } else {
                expression.append(" and ");
            }
            expression.append("value = '" + ii.getValue() + "'");
        }
        if (ii.hasUse()) {
            if (first) {
                first = false;
            } else {
                expression.append(" and ");
            }
            expression.append("use = '" + ii.getUse() + "'");
        }
        if (ii.hasType()) {
            if (first) {
                first = false;
            } else {
                expression.append(" and ");
            }
            this.buildCodeableConceptExpression(ed, expression, "type", ii.getType());
        }
        if (first) {
            throw new DefinitionException(this.context.formatMessage("UNSUPPORTED_IDENTIFIER_PATTERN_NO_PROPERTY_NOT_SUPPORTED_FOR_DISCRIMINATOR_FOR_SLICE", new Object[]{discriminator, ed.getId(), ii.fhirType()}));
        }
        expression.append(").exists()");
    }

    private void buildHumanNameExpression(ElementDefinition ed, StringBuilder expression, String discriminator, HumanName name) throws DefinitionException {
        if (name.hasExtension()) {
            throw new DefinitionException(this.context.formatMessage("Unsupported_Identifier_pattern__extensions_are_not_allowed__for_discriminator_for_slice_", new Object[]{discriminator, ed.getId()}));
        }
        boolean first = true;
        expression.append(discriminator + ".where(");
        if (name.hasUse()) {
            first = false;
            expression.append("use = '" + name.getUse().toCode() + "'");
        }
        if (name.hasText()) {
            if (first) {
                first = false;
            } else {
                expression.append(" and ");
            }
            expression.append("text = '" + name.getText() + "'");
        }
        if (name.hasFamily()) {
            if (first) {
                first = false;
            } else {
                expression.append(" and ");
            }
            expression.append("family = '" + name.getFamily() + "'");
        }
        if (name.hasGiven()) {
            throw new DefinitionException(this.context.formatMessage("UNSUPPORTED_IDENTIFIER_PATTERN_PROPERTY_NOT_SUPPORTED_FOR_DISCRIMINATOR_FOR_SLICE", new Object[]{discriminator, ed.getId(), name.fhirType(), "given"}));
        }
        if (name.hasPrefix()) {
            throw new DefinitionException(this.context.formatMessage("UNSUPPORTED_IDENTIFIER_PATTERN_PROPERTY_NOT_SUPPORTED_FOR_DISCRIMINATOR_FOR_SLICE", new Object[]{discriminator, ed.getId(), name.fhirType(), "prefix"}));
        }
        if (name.hasSuffix()) {
            throw new DefinitionException(this.context.formatMessage("UNSUPPORTED_IDENTIFIER_PATTERN_PROPERTY_NOT_SUPPORTED_FOR_DISCRIMINATOR_FOR_SLICE", new Object[]{discriminator, ed.getId(), name.fhirType(), "suffix"}));
        }
        if (name.hasPeriod()) {
            throw new DefinitionException(this.context.formatMessage("UNSUPPORTED_IDENTIFIER_PATTERN_PROPERTY_NOT_SUPPORTED_FOR_DISCRIMINATOR_FOR_SLICE", new Object[]{discriminator, ed.getId(), name.fhirType(), "period"}));
        }
        if (first) {
            throw new DefinitionException(this.context.formatMessage("UNSUPPORTED_IDENTIFIER_PATTERN_NO_PROPERTY_NOT_SUPPORTED_FOR_DISCRIMINATOR_FOR_SLICE", new Object[]{discriminator, ed.getId(), name.fhirType()}));
        }
        expression.append(").exists()");
    }

    private void buildAddressExpression(ElementDefinition ed, StringBuilder expression, String discriminator, Address add) throws DefinitionException {
        if (add.hasExtension()) {
            throw new DefinitionException(this.context.formatMessage("Unsupported_Identifier_pattern__extensions_are_not_allowed__for_discriminator_for_slice_", new Object[]{discriminator, ed.getId()}));
        }
        boolean first = true;
        expression.append(discriminator + ".where(");
        if (add.hasUse()) {
            first = false;
            expression.append("use = '" + add.getUse().toCode() + "'");
        }
        if (add.hasType()) {
            if (first) {
                first = false;
            } else {
                expression.append(" and ");
            }
            expression.append("type = '" + add.getType().toCode() + "'");
        }
        if (add.hasText()) {
            if (first) {
                first = false;
            } else {
                expression.append(" and ");
            }
            expression.append("text = '" + add.getText() + "'");
        }
        if (add.hasCity()) {
            if (first) {
                first = false;
            } else {
                expression.append(" and ");
            }
            expression.append("city = '" + add.getCity() + "'");
        }
        if (add.hasDistrict()) {
            if (first) {
                first = false;
            } else {
                expression.append(" and ");
            }
            expression.append("district = '" + add.getDistrict() + "'");
        }
        if (add.hasState()) {
            if (first) {
                first = false;
            } else {
                expression.append(" and ");
            }
            expression.append("state = '" + add.getState() + "'");
        }
        if (add.hasPostalCode()) {
            if (first) {
                first = false;
            } else {
                expression.append(" and ");
            }
            expression.append("postalCode = '" + add.getPostalCode() + "'");
        }
        if (add.hasCountry()) {
            if (first) {
                first = false;
            } else {
                expression.append(" and ");
            }
            expression.append("country = '" + add.getCountry() + "'");
        }
        if (add.hasLine()) {
            throw new DefinitionException(this.context.formatMessage("UNSUPPORTED_IDENTIFIER_PATTERN_PROPERTY_NOT_SUPPORTED_FOR_DISCRIMINATOR_FOR_SLICE", new Object[]{discriminator, ed.getId(), add.fhirType(), "line"}));
        }
        if (add.hasPeriod()) {
            throw new DefinitionException(this.context.formatMessage("UNSUPPORTED_IDENTIFIER_PATTERN_PROPERTY_NOT_SUPPORTED_FOR_DISCRIMINATOR_FOR_SLICE", new Object[]{discriminator, ed.getId(), add.fhirType(), "period"}));
        }
        if (first) {
            throw new DefinitionException(this.context.formatMessage("UNSUPPORTED_IDENTIFIER_PATTERN_NO_PROPERTY_NOT_SUPPORTED_FOR_DISCRIMINATOR_FOR_SLICE", new Object[]{discriminator, ed.getId(), add.fhirType()}));
        }
        expression.append(").exists()");
    }

    private void buildCodeableConceptExpression(ElementDefinition ed, StringBuilder expression, String discriminator, CodeableConcept cc) throws DefinitionException {
        if (cc.hasText()) {
            throw new DefinitionException(this.context.formatMessage("Unsupported_CodeableConcept_pattern__using_text__for_discriminator_for_slice_", new Object[]{discriminator, ed.getId()}));
        }
        if (!cc.hasCoding()) {
            throw new DefinitionException(this.context.formatMessage("Unsupported_CodeableConcept_pattern__must_have_at_least_one_coding__for_discriminator_for_slice_", new Object[]{discriminator, ed.getId()}));
        }
        if (cc.hasExtension()) {
            throw new DefinitionException(this.context.formatMessage("Unsupported_CodeableConcept_pattern__extensions_are_not_allowed__for_discriminator_for_slice_", new Object[]{discriminator, ed.getId()}));
        }
        boolean firstCoding = true;
        for (Coding c : cc.getCoding()) {
            if (c.hasExtension()) {
                throw new DefinitionException(this.context.formatMessage("Unsupported_CodeableConcept_pattern__extensions_are_not_allowed__for_discriminator_for_slice_", new Object[]{discriminator, ed.getId()}));
            }
            if (firstCoding) {
                firstCoding = false;
            } else {
                expression.append(" and ");
            }
            expression.append(discriminator + ".coding.where(");
            boolean first = true;
            if (c.hasSystem()) {
                first = false;
                expression.append("system = '" + c.getSystem() + "'");
            }
            if (c.hasVersion()) {
                if (first) {
                    first = false;
                } else {
                    expression.append(" and ");
                }
                expression.append("version = '" + c.getVersion() + "'");
            }
            if (c.hasCode()) {
                if (first) {
                    first = false;
                } else {
                    expression.append(" and ");
                }
                expression.append("code = '" + c.getCode() + "'");
            }
            if (c.hasDisplay()) {
                if (first) {
                    first = false;
                } else {
                    expression.append(" and ");
                }
                expression.append("display = '" + c.getDisplay() + "'");
            }
            if (first) {
                throw new DefinitionException(this.context.formatMessage("UNSUPPORTED_IDENTIFIER_PATTERN_NO_PROPERTY_NOT_SUPPORTED_FOR_DISCRIMINATOR_FOR_SLICE", new Object[]{discriminator, ed.getId(), cc.fhirType()}));
            }
            expression.append(").exists()");
        }
    }

    private void buildCodingExpression(ElementDefinition ed, StringBuilder expression, String discriminator, Coding c) throws DefinitionException {
        if (c.hasExtension()) {
            throw new DefinitionException(this.context.formatMessage("Unsupported_CodeableConcept_pattern__extensions_are_not_allowed__for_discriminator_for_slice_", new Object[]{discriminator, ed.getId()}));
        }
        expression.append(discriminator + ".where(");
        boolean first = true;
        if (c.hasSystem()) {
            first = false;
            expression.append("system = '" + c.getSystem() + "'");
        }
        if (c.hasVersion()) {
            if (first) {
                first = false;
            } else {
                expression.append(" and ");
            }
            expression.append("version = '" + c.getVersion() + "'");
        }
        if (c.hasCode()) {
            if (first) {
                first = false;
            } else {
                expression.append(" and ");
            }
            expression.append("code = '" + c.getCode() + "'");
        }
        if (c.hasDisplay()) {
            if (first) {
                first = false;
            } else {
                expression.append(" and ");
            }
            expression.append("display = '" + c.getDisplay() + "'");
        }
        if (first) {
            throw new DefinitionException(this.context.formatMessage("UNSUPPORTED_IDENTIFIER_PATTERN_NO_PROPERTY_NOT_SUPPORTED_FOR_DISCRIMINATOR_FOR_SLICE", new Object[]{discriminator, ed.getId(), c.fhirType()}));
        }
        expression.append(").exists()");
    }

    private void buildPrimitiveExpression(ElementDefinition ed, StringBuilder expression, String discriminator, DataType p, boolean quotes) throws DefinitionException {
        if (p.hasExtension()) {
            throw new DefinitionException(this.context.formatMessage("Unsupported_CodeableConcept_pattern__extensions_are_not_allowed__for_discriminator_for_slice_", new Object[]{discriminator, ed.getId()}));
        }
        if (quotes) {
            expression.append(discriminator + ".where(value = '" + p.primitiveValue() + "'");
        } else {
            expression.append(discriminator + ".where(value = " + p.primitiveValue() + "");
        }
        expression.append(").exists()");
    }

    private void buildFixedExpression(ElementDefinition ed, StringBuilder expression, String discriminator, ElementDefinition criteriaElement) throws DefinitionException {
        DataType fixed = criteriaElement.getFixed();
        if (fixed instanceof CodeableConcept) {
            CodeableConcept cc = (CodeableConcept)fixed;
            expression.append(" and ");
            this.buildCodeableConceptExpression(ed, expression, discriminator, cc);
        } else if (fixed instanceof Identifier) {
            Identifier ii = (Identifier)fixed;
            expression.append(" and ");
            this.buildIdentifierExpression(ed, expression, discriminator, ii);
        } else if (fixed instanceof Coding) {
            Coding c = (Coding)fixed;
            expression.append(" and ");
            this.buildCodingExpression(ed, expression, discriminator, c);
        } else {
            expression.append(" and (");
            if (fixed instanceof StringType) {
                Gson gson = new Gson();
                String json = gson.toJson((Object)((StringType)fixed));
                String escapedString = json.substring(json.indexOf(":") + 2);
                escapedString = escapedString.substring(0, escapedString.indexOf(",\"myStringValue") - 1);
                expression.append("'" + escapedString + "'");
            } else if (fixed instanceof UriType) {
                expression.append("'" + ((UriType)fixed).asStringValue() + "'");
            } else if (fixed instanceof IntegerType) {
                expression.append(((IntegerType)fixed).asStringValue());
            } else if (fixed instanceof DecimalType) {
                expression.append(((IntegerType)fixed).asStringValue());
            } else if (fixed instanceof BooleanType) {
                expression.append(((BooleanType)fixed).asStringValue());
            } else {
                throw new DefinitionException(this.context.formatMessage("Unsupported_fixed_value_type_for_discriminator_for_slice__", new Object[]{discriminator, ed.getId(), fixed.getClass().getName()}));
            }
            expression.append(" in " + discriminator + ")");
        }
    }

    private void start(ValidatorHostContext hostContext, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition defn, NodeStack stack) throws FHIRException {
        this.checkLang(resource, stack);
        this.signpost(errors, ValidationMessage.IssueType.INFORMATIONAL, element.line(), element.col(), stack.getLiteralPath(), !this.crumbTrails, "VALIDATION_VAL_PROFILE_SIGNPOST", defn.getUrl());
        if ("Bundle".equals(element.fhirType())) {
            this.resolveBundleReferences(element, new ArrayList<org.hl7.fhir.r5.elementmodel.Element>());
        }
        this.startInner(hostContext, errors, resource, element, defn, stack, hostContext.isCheckSpecials());
        org.hl7.fhir.r5.elementmodel.Element meta = element.getNamedChild("meta");
        if (meta != null) {
            ArrayList profiles = new ArrayList();
            meta.getNamedChildren("profile", profiles);
            int i = 0;
            for (org.hl7.fhir.r5.elementmodel.Element profile : profiles) {
                StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, profile.primitiveValue());
                if (!defn.getUrl().equals(profile.primitiveValue())) {
                    VersionUtilities.VersionURLInfo vu = VersionUtilities.parseVersionUrl((String)profile.primitiveValue());
                    if (vu != null) {
                        if (!VersionUtilities.versionsCompatible((String)vu.getVersion(), (String)this.context.getVersion())) {
                            this.hint(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath() + ".meta.profile[" + i + "]", false, "VALIDATION_VAL_PROFILE_OTHER_VERSION", vu.getVersion());
                        } else if (vu.getUrl().equals(defn.getUrl())) {
                            this.hint(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath() + ".meta.profile[" + i + "]", false, "VALIDATION_VAL_PROFILE_THIS_VERSION_OK");
                        } else {
                            StructureDefinition sdt = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, vu.getUrl());
                            this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath() + ".meta.profile[" + i + "]", false, "VALIDATION_VAL_PROFILE_THIS_VERSION_OTHER", sdt == null ? "null" : sdt.getType());
                        }
                    } else {
                        if (sd == null) {
                            if (this.fetcher == null) {
                                this.warning(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath() + ".meta.profile[" + i + "]", false, "Validation_VAL_Profile_Unknown", profile.primitiveValue());
                            } else if (!this.fetcher.fetchesCanonicalResource(profile.primitiveValue())) {
                                this.warning(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath() + ".meta.profile[" + i + "]", false, "VALIDATION_VAL_PROFILE_UNKNOWN_NOT_POLICY", profile.primitiveValue());
                            } else {
                                try {
                                    sd = (StructureDefinition)this.fetcher.fetchCanonicalResource(profile.primitiveValue());
                                }
                                catch (Exception e) {
                                    this.warning(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath() + ".meta.profile[" + i + "]", false, "VALIDATION_VAL_PROFILE_UNKNOWN_ERROR", profile.primitiveValue(), e.getMessage());
                                }
                                if (sd != null) {
                                    this.context.cacheResource((Resource)sd);
                                }
                            }
                        }
                        if (sd != null) {
                            this.signpost(errors, ValidationMessage.IssueType.INFORMATIONAL, element.line(), element.col(), stack.getLiteralPath(), !this.crumbTrails, "VALIDATION_VAL_PROFILE_SIGNPOST_META", sd.getUrl());
                            stack.resetIds();
                            this.startInner(hostContext, errors, resource, element, sd, stack, false);
                        }
                    }
                }
                ++i;
            }
        }
        String rt = element.fhirType();
        for (ImplementationGuide ig : this.igs) {
            for (ImplementationGuide.ImplementationGuideGlobalComponent gl : ig.getGlobal()) {
                if (!rt.equals(gl.getType())) continue;
                StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, gl.getProfile());
                if (!this.warning(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath(), sd != null, "VALIDATION_VAL_GLOBAL_PROFILE_UNKNOWN", gl.getProfile())) continue;
                this.signpost(errors, ValidationMessage.IssueType.INFORMATIONAL, element.line(), element.col(), stack.getLiteralPath(), !this.crumbTrails, "VALIDATION_VAL_PROFILE_SIGNPOST_GLOBAL", sd.getUrl(), ig.getUrl());
                stack.resetIds();
                this.startInner(hostContext, errors, resource, element, sd, stack, false);
            }
        }
    }

    private void resolveBundleReferences(org.hl7.fhir.r5.elementmodel.Element element, List<org.hl7.fhir.r5.elementmodel.Element> bundles) {
        if (!element.hasUserData("validator.bundle.resolved")) {
            element.setUserData("validator.bundle.resolved", (Object)true);
            ArrayList<org.hl7.fhir.r5.elementmodel.Element> list = new ArrayList<org.hl7.fhir.r5.elementmodel.Element>();
            list.addAll(bundles);
            list.add(0, element);
            List entries = element.getChildrenByName("entry");
            for (org.hl7.fhir.r5.elementmodel.Element entry : entries) {
                String fu = entry.getChildValue("fullUrl");
                org.hl7.fhir.r5.elementmodel.Element r = entry.getNamedChild("resource");
                if (r == null) continue;
                this.resolveBundleReferencesInResource(list, r, fu);
            }
        }
    }

    private void resolveBundleReferencesInResource(List<org.hl7.fhir.r5.elementmodel.Element> bundles, org.hl7.fhir.r5.elementmodel.Element r, String fu) {
        r.setUserData("validator.bundle.resolution-resource", null);
        if ("Bundle".equals(r.fhirType())) {
            this.resolveBundleReferences(r, bundles);
        } else {
            for (org.hl7.fhir.r5.elementmodel.Element child : r.getChildren()) {
                this.resolveBundleReferencesForElement(bundles, r, fu, child);
            }
        }
    }

    private void resolveBundleReferencesForElement(List<org.hl7.fhir.r5.elementmodel.Element> bundles, org.hl7.fhir.r5.elementmodel.Element resource, String fu, org.hl7.fhir.r5.elementmodel.Element element) {
        if ("Reference".equals(element.fhirType())) {
            String ref = element.getChildValue("reference");
            if (!Utilities.noString((String)ref)) {
                for (org.hl7.fhir.r5.elementmodel.Element bundle : bundles) {
                    List entries = bundle.getChildren("entry");
                    org.hl7.fhir.r5.elementmodel.Element tgt = this.resolveInBundle(entries, ref, fu, resource.fhirType(), resource.getIdBase());
                    if (tgt == null) continue;
                    element.setUserData("validator.bundle.resolution", (Object)tgt.getNamedChild("resource"));
                    return;
                }
                element.setUserData("validator.bundle.resolution-failed", (Object)ref);
            }
        } else {
            element.setUserData("validator.bundle.resolution-noref", null);
            for (org.hl7.fhir.r5.elementmodel.Element child : element.getChildren()) {
                this.resolveBundleReferencesForElement(bundles, resource, fu, child);
            }
        }
    }

    public void startInner(ValidatorHostContext hostContext, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition defn, NodeStack stack, boolean checkSpecials) {
        ResourceValidationTracker resTracker = this.getResourceTracker(element);
        List<ValidationMessage> cachedErrors = resTracker.getOutcomes(defn);
        if (cachedErrors != null) {
            for (ValidationMessage vm : cachedErrors) {
                if (errors.contains(vm)) continue;
                errors.add(vm);
            }
            return;
        }
        if (this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath(), defn.hasSnapshot(), "Validation_VAL_Profile_NoSnapshot", new Object[0])) {
            ArrayList<ValidationMessage> localErrors = new ArrayList<ValidationMessage>();
            resTracker.startValidating(defn);
            this.trackUsage(defn, hostContext, element);
            this.validateElement(hostContext, localErrors, defn, (ElementDefinition)defn.getSnapshot().getElement().get(0), null, null, resource, element, element.getName(), stack, false, true, null);
            resTracker.storeOutcomes(defn, localErrors);
            for (ValidationMessage vm : localErrors) {
                if (errors.contains(vm)) continue;
                errors.add(vm);
            }
        }
        if (checkSpecials) {
            this.checkSpecials(hostContext, errors, element, stack, checkSpecials);
            this.validateResourceRules(errors, element, stack);
        }
    }

    public void checkSpecials(ValidatorHostContext hostContext, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack, boolean checkSpecials) {
        if (element.getType().equals("Bundle")) {
            new BundleValidator(this.context, this.serverBase, this, this.xverManager).validateBundle(errors, element, stack, checkSpecials, hostContext);
        } else if (element.getType().equals("Observation")) {
            this.validateObservation(errors, element, stack);
        } else if (element.getType().equals("Questionnaire")) {
            new QuestionnaireValidator(this.context, this.myEnableWhenEvaluator, this.fpe, this.timeTracker, this.questionnaireMode, this.xverManager).validateQuestionannaire(errors, element, element, stack);
        } else if (element.getType().equals("QuestionnaireResponse")) {
            new QuestionnaireValidator(this.context, this.myEnableWhenEvaluator, this.fpe, this.timeTracker, this.questionnaireMode, this.xverManager).validateQuestionannaireResponse(hostContext, errors, element, stack);
        } else if (element.getType().equals("Measure")) {
            new MeasureValidator(this.context, this.timeTracker, this.xverManager).validateMeasure(hostContext, errors, element, stack);
        } else if (element.getType().equals("MeasureReport")) {
            new MeasureValidator(this.context, this.timeTracker, this.xverManager).validateMeasureReport(hostContext, errors, element, stack);
        } else if (element.getType().equals("CapabilityStatement")) {
            this.validateCapabilityStatement(errors, element, stack);
        } else if (element.getType().equals("CodeSystem")) {
            new CodeSystemValidator(this.context, this.timeTracker, this.xverManager).validateCodeSystem(errors, element, stack, new ValidationOptions(stack.getWorkingLang()));
        } else if (element.getType().equals("SearchParameter")) {
            new SearchParameterValidator(this.context, this.timeTracker, this.fpe, this.xverManager).validateSearchParameter(errors, element, stack);
        } else if (element.getType().equals("StructureDefinition")) {
            new StructureDefinitionValidator(this.context, this.timeTracker, this.fpe, this.wantCheckSnapshotUnchanged, this.xverManager).validateStructureDefinition(errors, element, stack);
        } else if (element.getType().equals("ValueSet")) {
            new ValueSetValidator(this.context, this.timeTracker, this, this.xverManager).validateValueSet(errors, element, stack);
        }
    }

    private ResourceValidationTracker getResourceTracker(org.hl7.fhir.r5.elementmodel.Element element) {
        ResourceValidationTracker res = this.resourceTracker.get(element);
        if (res == null) {
            res = new ResourceValidationTracker();
            this.resourceTracker.put(element, res);
        }
        return res;
    }

    private void checkLang(org.hl7.fhir.r5.elementmodel.Element resource, NodeStack stack) {
        String lang = resource.getNamedChildValue("language");
        if (!Utilities.noString((String)lang)) {
            stack.setWorkingLang(lang);
        }
    }

    private void validateResourceRules(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack) {
        org.hl7.fhir.r5.elementmodel.Element meta;
        String lang = element.getNamedChildValue("language");
        org.hl7.fhir.r5.elementmodel.Element text = element.getNamedChild("text");
        if (text != null) {
            org.hl7.fhir.r5.elementmodel.Element div = text.getNamedChild("div");
            if (lang != null && div != null) {
                XhtmlNode xhtml = div.getXhtml();
                String l = xhtml.getAttribute("lang");
                String xl = xhtml.getAttribute("xml:lang");
                if (l == null && xl == null) {
                    this.warning(errors, ValidationMessage.IssueType.BUSINESSRULE, div.line(), div.col(), stack.getLiteralPath(), false, "Language_XHTML_Lang_Missing1", new Object[0]);
                } else {
                    if (l == null) {
                        this.warning(errors, ValidationMessage.IssueType.BUSINESSRULE, div.line(), div.col(), stack.getLiteralPath(), false, "Language_XHTML_Lang_Missing2", new Object[0]);
                    } else if (!l.equals(lang)) {
                        this.warning(errors, ValidationMessage.IssueType.BUSINESSRULE, div.line(), div.col(), stack.getLiteralPath(), false, "Language_XHTML_Lang_Different1", lang, l);
                    }
                    if (xl == null) {
                        this.warning(errors, ValidationMessage.IssueType.BUSINESSRULE, div.line(), div.col(), stack.getLiteralPath(), false, "Language_XHTML_Lang_Missing3", new Object[0]);
                    } else if (!xl.equals(lang)) {
                        this.warning(errors, ValidationMessage.IssueType.BUSINESSRULE, div.line(), div.col(), stack.getLiteralPath(), false, "Language_XHTML_Lang_Different2", lang, xl);
                    }
                }
            }
        }
        if ((meta = element.getNamedChild("meta")) != null) {
            HashSet<String> tags = new HashSet<String>();
            ArrayList list = new ArrayList();
            meta.getNamedChildren("security", list);
            int i = 0;
            for (org.hl7.fhir.r5.elementmodel.Element e : list) {
                String s = e.getNamedChildValue("system") + "#" + e.getNamedChildValue("code");
                this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, e.line(), e.col(), stack.getLiteralPath() + ".meta.profile[" + Integer.toString(i) + "]", !tags.contains(s), "Meta_RES_Security_Duplicate", s);
                tags.add(s);
                ++i;
            }
        }
    }

    private void validateCapabilityStatement(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element cs, NodeStack stack) {
        int iRest = 0;
        for (org.hl7.fhir.r5.elementmodel.Element rest : cs.getChildrenByName("rest")) {
            int iResource = 0;
            for (org.hl7.fhir.r5.elementmodel.Element resource : rest.getChildrenByName("resource")) {
                int iSP = 0;
                for (org.hl7.fhir.r5.elementmodel.Element searchParam : resource.getChildrenByName("searchParam")) {
                    SearchParameter sp;
                    String ref = searchParam.getChildValue("definition");
                    String type = searchParam.getChildValue("type");
                    if (!Utilities.noString((String)ref) && (sp = (SearchParameter)this.context.fetchResource(SearchParameter.class, ref)) != null) {
                        this.rule(errors, ValidationMessage.IssueType.INVALID, searchParam.line(), searchParam.col(), stack.getLiteralPath() + ".rest[" + iRest + "].resource[" + iResource + "].searchParam[" + iSP + "]", sp.getType().toCode().equals(type), "CapabalityStatement_CS_SP_WrongType", sp.getUrl(), sp.getType().toCode(), type);
                    }
                    ++iSP;
                }
                ++iResource;
            }
            ++iRest;
        }
    }

    private void validateContains(ValidatorHostContext hostContext, List<ValidationMessage> errors, String path, ElementDefinition child, ElementDefinition context, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack, IResourceValidator.IdStatus idstatus) throws FHIRException {
        String resourceName = element.getType();
        ElementDefinition.TypeRefComponent trr = null;
        CommaSeparatedStringBuilder bt = new CommaSeparatedStringBuilder();
        for (ElementDefinition.TypeRefComponent tr : child.getType()) {
            bt.append(tr.getCode());
            if (!tr.getCode().equals("Resource") && !tr.getCode().equals(resourceName)) continue;
            trr = tr;
            break;
        }
        stack.qualifyPath(".ofType(" + resourceName + ")");
        if (trr == null) {
            this.rule(errors, ValidationMessage.IssueType.INFORMATIONAL, element.line(), element.col(), stack.getLiteralPath(), false, "Bundle_BUNDLE_Entry_Type", resourceName, bt.toString());
        } else if (this.isValidResourceType(resourceName, trr)) {
            ValidatorHostContext hc = null;
            if (element.getSpecial() == Element.SpecialElement.BUNDLE_ENTRY || element.getSpecial() == Element.SpecialElement.BUNDLE_OUTCOME || element.getSpecial() == Element.SpecialElement.PARAMETER) {
                resource = element;
                hc = hostContext.forEntry(element);
            } else {
                hc = hostContext.forContained(element);
            }
            stack.resetIds();
            if (element.getSpecial() != null) {
                switch (element.getSpecial()) {
                    case BUNDLE_ENTRY: {
                        idstatus = IResourceValidator.IdStatus.OPTIONAL;
                        break;
                    }
                    case BUNDLE_OUTCOME: {
                        idstatus = IResourceValidator.IdStatus.OPTIONAL;
                        break;
                    }
                    case CONTAINED: {
                        idstatus = IResourceValidator.IdStatus.REQUIRED;
                        break;
                    }
                    case PARAMETER: {
                        idstatus = IResourceValidator.IdStatus.OPTIONAL;
                        break;
                    }
                }
            }
            if (trr.getProfile().size() == 1) {
                long t = System.nanoTime();
                StructureDefinition profile = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, ((CanonicalType)trr.getProfile().get(0)).asStringValue());
                this.timeTracker.sd(t);
                this.trackUsage(profile, hostContext, element);
                if (this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), profile != null, "Bundle_BUNDLE_Entry_NoProfile", resourceName)) {
                    this.validateResource(hc, errors, resource, element, profile, idstatus, stack);
                }
            } else if (trr.getProfile().size() == 0) {
                long t = System.nanoTime();
                StructureDefinition profile = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + resourceName);
                this.timeTracker.sd(t);
                this.trackUsage(profile, hostContext, element);
                if (this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), profile != null, "Bundle_BUNDLE_Entry_NoProfile", resourceName)) {
                    this.validateResource(hc, errors, resource, element, profile, idstatus, stack);
                }
            } else {
                CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
                for (CanonicalType u : trr.getProfile()) {
                    b.append(u.asStringValue());
                }
                this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), false, "BUNDLE_BUNDLE_ENTRY_MULTIPLE_PROFILES", trr.getCode(), b.toString());
            }
        } else {
            ArrayList<String> types = new ArrayList<String>();
            for (UriType u : trr.getProfile()) {
                StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, (String)u.getValue());
                if (sd == null || types.contains(sd.getType())) continue;
                types.add(sd.getType());
            }
            if (types.size() == 1) {
                this.rule(errors, ValidationMessage.IssueType.INFORMATIONAL, element.line(), element.col(), stack.getLiteralPath(), false, "Bundle_BUNDLE_Entry_Type2", resourceName, types.get(0));
            } else {
                this.rule(errors, ValidationMessage.IssueType.INFORMATIONAL, element.line(), element.col(), stack.getLiteralPath(), false, "Bundle_BUNDLE_Entry_Type3", resourceName, types);
            }
        }
    }

    private boolean isValidResourceType(String type, ElementDefinition.TypeRefComponent def) {
        if (!def.hasProfile() && def.getCode().equals("Resource")) {
            return true;
        }
        if (def.getCode().equals(type)) {
            return true;
        }
        ArrayList<StructureDefinition> list = new ArrayList<StructureDefinition>();
        for (UriType u : def.getProfile()) {
            StructureDefinition sdt = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, (String)u.getValue());
            if (sdt == null) continue;
            list.add(sdt);
        }
        StructureDefinition sdt = this.context.fetchTypeDefinition(type);
        while (sdt != null) {
            if (def.getWorkingCode().equals("Resource")) {
                for (StructureDefinition sd : list) {
                    if (sd.getUrl().equals(sdt.getUrl())) {
                        return true;
                    }
                    if (!sd.getType().equals(sdt.getType())) continue;
                    return true;
                }
            }
            sdt = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, sdt.getBaseDefinition());
        }
        return false;
    }

    private void validateElement(ValidatorHostContext hostContext, List<ValidationMessage> errors, StructureDefinition profile, ElementDefinition definition, StructureDefinition cprofile, ElementDefinition context, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element element, String actualType, NodeStack stack, boolean inCodeableConcept, boolean checkDisplayInContext, String extensionUrl) throws FHIRException {
        List<ElementDefinition> childDefinitions;
        String id = element.getChildValue("id");
        if (!Utilities.noString((String)id)) {
            if (stack.getIds().containsKey(id) && stack.getIds().get(id) != element) {
                this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, element.line(), element.col(), stack.getLiteralPath(), false, "DUPLICATE_ID", id);
            }
            if (!stack.isResetPoint()) {
                stack.getIds().put(id, element);
            }
        }
        if (definition.getPath().equals("StructureDefinition.snapshot")) {
            stack.resetIds();
        }
        this.checkInvariants(hostContext, errors, profile, definition, resource, element, stack, false);
        if (definition.getFixed() != null) {
            this.checkFixedValue(errors, stack.getLiteralPath(), element, (org.hl7.fhir.r5.model.Element)definition.getFixed(), profile.getUrl(), definition.getSliceName(), null, false);
        }
        if (definition.getPattern() != null) {
            this.checkFixedValue(errors, stack.getLiteralPath(), element, (org.hl7.fhir.r5.model.Element)definition.getPattern(), profile.getUrl(), definition.getSliceName(), null, true);
        }
        if ((childDefinitions = this.profileUtilities.getChildMap(profile, definition)).isEmpty()) {
            if (actualType == null) {
                return;
            }
            childDefinitions = this.getActualTypeChildren(hostContext, element, actualType);
        } else if (definition.getType().size() > 1) {
            if (actualType == null) {
                return;
            }
            List<ElementDefinition> typeChildDefinitions = this.getActualTypeChildren(hostContext, element, actualType);
            this.mergeChildLists(childDefinitions, typeChildDefinitions, definition.getPath(), actualType);
        }
        List<ElementInfo> children = this.listChildren(element, stack);
        List<String> problematicPaths = this.assignChildren(hostContext, errors, profile, resource, stack, childDefinitions, children);
        this.checkCardinalities(errors, profile, element, stack, childDefinitions, children, problematicPaths);
        for (ElementInfo ei : children) {
            this.checkChild(hostContext, errors, profile, definition, resource, element, actualType, stack, inCodeableConcept, checkDisplayInContext, ei, extensionUrl);
        }
    }

    private void mergeChildLists(List<ElementDefinition> master, List<ElementDefinition> additional, String masterPath, String typePath) {
        for (ElementDefinition ed : additional) {
            boolean inMaster = false;
            for (ElementDefinition t : master) {
                String tp = masterPath + ed.getPath().substring(typePath.length());
                if (!t.getPath().equals(tp)) continue;
                inMaster = true;
            }
            if (inMaster) continue;
            master.add(ed);
        }
    }

    public List<ElementDefinition> getActualTypeChildren(ValidatorHostContext hostContext, org.hl7.fhir.r5.elementmodel.Element element, String actualType) {
        StructureDefinition dt = null;
        dt = this.isAbsolute(actualType) ? (StructureDefinition)this.context.fetchResource(StructureDefinition.class, actualType) : (StructureDefinition)this.context.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + actualType);
        if (dt == null) {
            throw new DefinitionException(this.context.formatMessage("Unable_to_resolve_actual_type_", new Object[]{actualType}));
        }
        this.trackUsage(dt, hostContext, element);
        List childDefinitions = this.profileUtilities.getChildMap(dt, (ElementDefinition)dt.getSnapshot().getElement().get(0));
        return childDefinitions;
    }

    public void checkChild(ValidatorHostContext hostContext, List<ValidationMessage> errors, StructureDefinition profile, ElementDefinition definition, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element element, String actualType, NodeStack stack, boolean inCodeableConcept, boolean checkDisplayInContext, ElementInfo ei, String extensionUrl) throws FHIRException, DefinitionException {
        if (this.debug && ei.definition != null && ei.slice != null) {
            System.out.println(Utilities.padLeft((String)"", (char)' ', (int)stack.depth()) + "Check " + ei.getPath() + " against both " + ei.definition.getId() + " and " + ei.slice.getId());
        }
        if (ei.definition != null) {
            if (this.debug) {
                System.out.println(Utilities.padLeft((String)"", (char)' ', (int)stack.depth()) + "Check " + ei.getPath() + " against defn " + ei.definition.getId() + " from " + profile.getUrl());
            }
            this.checkChildByDefinition(hostContext, errors, profile, definition, resource, element, actualType, stack, inCodeableConcept, checkDisplayInContext, ei, extensionUrl, ei.definition, false);
        }
        if (ei.slice != null) {
            if (this.debug) {
                System.out.println(Utilities.padLeft((String)"", (char)' ', (int)stack.depth()) + "Check " + ei.getPath() + " against slice " + ei.slice.getId());
            }
            this.checkChildByDefinition(hostContext, errors, profile, definition, resource, element, actualType, stack, inCodeableConcept, checkDisplayInContext, ei, extensionUrl, ei.slice, true);
        }
    }

    public void checkChildByDefinition(ValidatorHostContext hostContext, List<ValidationMessage> errors, StructureDefinition profile, ElementDefinition definition, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element element, String actualType, NodeStack stack, boolean inCodeableConcept, boolean checkDisplayInContext, ElementInfo ei, String extensionUrl, ElementDefinition checkDefn, boolean isSlice) {
        String prefix;
        ArrayList<Object> profiles = new ArrayList<Object>();
        String type = null;
        ElementDefinition typeDefn = null;
        this.checkMustSupport(profile, ei);
        if (!(checkDefn.getType().size() != 1 || "*".equals(((ElementDefinition.TypeRefComponent)checkDefn.getType().get(0)).getWorkingCode()) || "Element".equals(((ElementDefinition.TypeRefComponent)checkDefn.getType().get(0)).getWorkingCode()) || "BackboneElement".equals(((ElementDefinition.TypeRefComponent)checkDefn.getType().get(0)).getWorkingCode()))) {
            type = ((ElementDefinition.TypeRefComponent)checkDefn.getType().get(0)).getWorkingCode();
            String stype = ei.getElement().fhirType();
            if (checkDefn.isChoice() && !stype.equals(type) && !"Extension".equals(profile.getType())) {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), ei.getPath(), false, "Extension_PROF_Type", profile.getUrl(), type, stype);
            }
            if (((ElementDefinition.TypeRefComponent)checkDefn.getType().get(0)).hasProfile()) {
                for (CanonicalType p : ((ElementDefinition.TypeRefComponent)checkDefn.getType().get(0)).getProfile()) {
                    profiles.add(p.getValue());
                }
            }
        } else if (checkDefn.getType().size() == 1 && "*".equals(((ElementDefinition.TypeRefComponent)checkDefn.getType().get(0)).getWorkingCode())) {
            prefix = this.tail(checkDefn.getPath());
            assert (prefix.endsWith("[x]"));
            type = ei.getName().substring(prefix.length() - 3);
            if (this.isPrimitiveType(type)) {
                type = Utilities.uncapitalize((String)type);
            }
            if (((ElementDefinition.TypeRefComponent)checkDefn.getType().get(0)).hasProfile()) {
                for (CanonicalType p : ((ElementDefinition.TypeRefComponent)checkDefn.getType().get(0)).getProfile()) {
                    profiles.add(p.getValue());
                }
            }
        } else if (checkDefn.getType().size() > 1) {
            prefix = this.tail(checkDefn.getPath());
            assert (this.typesAreAllReference(checkDefn.getType()) || checkDefn.hasRepresentation(ElementDefinition.PropertyRepresentation.TYPEATTR) || prefix.endsWith("[x]") || this.isResourceAndTypes(checkDefn)) : "Multiple Types allowed, but name is wrong @ " + checkDefn.getPath() + ": " + checkDefn.typeSummaryVB();
            if (checkDefn.hasRepresentation(ElementDefinition.PropertyRepresentation.TYPEATTR)) {
                type = ei.getElement().getType();
            } else if (ei.getElement().isResource()) {
                type = ei.getElement().fhirType();
            } else {
                prefix = prefix.substring(0, prefix.length() - 3);
                for (ElementDefinition.TypeRefComponent t : checkDefn.getType()) {
                    if (!(prefix + Utilities.capitalize((String)t.getWorkingCode())).equals(ei.getName())) continue;
                    type = t.getWorkingCode();
                    if (!t.hasProfile() || type.equals("Reference")) continue;
                    profiles.add(((CanonicalType)t.getProfile().get(0)).getValue());
                }
            }
            if (type == null) {
                ElementDefinition.TypeRefComponent trc = (ElementDefinition.TypeRefComponent)checkDefn.getType().get(0);
                if (trc.getWorkingCode().equals("Reference")) {
                    type = "Reference";
                } else {
                    this.rule(errors, ValidationMessage.IssueType.STRUCTURE, ei.line(), ei.col(), stack.getLiteralPath(), false, "Validation_VAL_Profile_NoType", ei.getName(), this.describeTypes(checkDefn.getType()));
                }
            }
        } else if (checkDefn.getContentReference() != null) {
            typeDefn = this.resolveNameReference(profile.getSnapshot(), checkDefn.getContentReference());
        } else if (checkDefn.getType().size() == 1 && ("Element".equals(((ElementDefinition.TypeRefComponent)checkDefn.getType().get(0)).getWorkingCode()) || "BackboneElement".equals(((ElementDefinition.TypeRefComponent)checkDefn.getType().get(0)).getWorkingCode())) && ((ElementDefinition.TypeRefComponent)checkDefn.getType().get(0)).hasProfile()) {
            CanonicalType pu = (CanonicalType)((ElementDefinition.TypeRefComponent)checkDefn.getType().get(0)).getProfile().get(0);
            if (pu.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-profile-element")) {
                profiles.add((String)pu.getValue() + "#" + pu.getExtensionString("http://hl7.org/fhir/StructureDefinition/elementdefinition-profile-element"));
            } else {
                profiles.add(pu.getValue());
            }
        }
        if (type != null && type.startsWith("@")) {
            checkDefn = this.findElement(profile, type.substring(1));
            if (isSlice) {
                ei.slice = ei.definition;
            } else {
                ei.definition = ei.definition;
            }
            type = null;
        }
        NodeStack localStack = stack.push(ei.getElement(), ei.count, checkDefn, type == null ? typeDefn : this.resolveType(type, checkDefn.getType()));
        String localStackLiterapPath = localStack.getLiteralPath();
        String eiPath = ei.getPath();
        assert (eiPath.equals(localStackLiterapPath)) : "ei.path: " + ei.getPath() + "  -  localStack.getLiteralPath: " + localStackLiterapPath;
        boolean thisIsCodeableConcept = false;
        String thisExtension = null;
        boolean checkDisplay = true;
        this.checkInvariants(hostContext, errors, profile, typeDefn != null ? typeDefn : checkDefn, resource, ei.getElement(), localStack, true);
        ei.getElement().markValidation(profile, checkDefn);
        boolean elementValidated = false;
        if (type != null) {
            StructureDefinition defn;
            if (this.isPrimitiveType(type)) {
                this.checkPrimitive(hostContext, errors, ei.getPath(), type, checkDefn, ei.getElement(), profile, stack);
            } else {
                if (checkDefn.hasFixed()) {
                    this.checkFixedValue(errors, ei.getPath(), ei.getElement(), (org.hl7.fhir.r5.model.Element)checkDefn.getFixed(), profile.getUrl(), checkDefn.getSliceName(), null, false);
                }
                if (checkDefn.hasPattern()) {
                    this.checkFixedValue(errors, ei.getPath(), ei.getElement(), (org.hl7.fhir.r5.model.Element)checkDefn.getPattern(), profile.getUrl(), checkDefn.getSliceName(), null, true);
                }
            }
            if (type.equals("Identifier")) {
                this.checkIdentifier(errors, ei.getPath(), ei.getElement(), checkDefn);
            } else if (type.equals("Coding")) {
                this.checkCoding(errors, ei.getPath(), ei.getElement(), profile, checkDefn, inCodeableConcept, checkDisplayInContext, stack);
            } else if (type.equals("Quantity")) {
                this.checkQuantity(errors, ei.getPath(), ei.getElement(), profile, checkDefn, stack);
            } else if (type.equals("Attachment")) {
                this.checkAttachment(errors, ei.getPath(), ei.getElement(), profile, checkDefn, inCodeableConcept, checkDisplayInContext, stack);
            } else if (type.equals("CodeableConcept")) {
                checkDisplay = this.checkCodeableConcept(errors, ei.getPath(), ei.getElement(), profile, checkDefn, stack);
                thisIsCodeableConcept = true;
            } else if (type.equals("Reference")) {
                this.checkReference(hostContext, errors, ei.getPath(), ei.getElement(), profile, checkDefn, actualType, localStack);
            } else if (type.equals("Extension")) {
                org.hl7.fhir.r5.elementmodel.Element eurl = ei.getElement().getNamedChild("url");
                if (this.rule(errors, ValidationMessage.IssueType.INVALID, ei.getPath(), eurl != null, "Extension_EXT_Url_NotFound", new Object[0])) {
                    String url;
                    thisExtension = url = eurl.primitiveValue();
                    if (this.rule(errors, ValidationMessage.IssueType.INVALID, ei.getPath(), !Utilities.noString((String)url), "Extension_EXT_Url_NotFound", new Object[0]) && this.rule(errors, ValidationMessage.IssueType.INVALID, ei.getPath(), extensionUrl != null || Utilities.isAbsoluteUrl((String)url), "Extension_EXT_URL_Absolute", new Object[0])) {
                        this.checkExtension(hostContext, errors, ei.getPath(), resource, element, ei.getElement(), checkDefn, profile, localStack, stack, extensionUrl);
                    }
                }
            } else if (type.equals("Resource") || this.isResource(type)) {
                this.validateContains(hostContext, errors, ei.getPath(), checkDefn, definition, resource, ei.getElement(), localStack, this.idStatusForEntry(element, ei));
                elementValidated = true;
            } else if (Utilities.isAbsoluteUrl((String)type) && (defn = this.context.fetchTypeDefinition(type)) != null && this.hasMapping("http://hl7.org/fhir/terminology-pattern", defn, defn.getSnapshot().getElementFirstRep())) {
                List<String> txtype = this.getMapping("http://hl7.org/fhir/terminology-pattern", defn, defn.getSnapshot().getElementFirstRep());
                if (txtype.contains("CodeableConcept")) {
                    this.checkTerminologyCodeableConcept(errors, ei.getPath(), ei.getElement(), profile, checkDefn, stack, defn);
                    thisIsCodeableConcept = true;
                } else if (txtype.contains("Coding")) {
                    this.checkTerminologyCoding(errors, ei.getPath(), ei.getElement(), profile, checkDefn, inCodeableConcept, checkDisplayInContext, stack, defn);
                }
            }
        } else if (this.rule(errors, ValidationMessage.IssueType.STRUCTURE, ei.line(), ei.col(), stack.getLiteralPath(), checkDefn != null, "Validation_VAL_Content_Unknown", ei.getName())) {
            this.validateElement(hostContext, errors, profile, checkDefn, null, null, resource, ei.getElement(), type, localStack, false, true, null);
        }
        StructureDefinition p = null;
        String tail = null;
        if (profiles.isEmpty()) {
            if (type != null) {
                p = this.getProfileForType(type, checkDefn.getType());
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, ei.line(), ei.col(), ei.getPath(), p != null, "Validation_VAL_NoType", type);
            }
        } else if (profiles.size() == 1) {
            String url = (String)profiles.get(0);
            if (url.contains("#")) {
                tail = url.substring(url.indexOf("#") + 1);
                url = url.substring(0, url.indexOf("#"));
            }
            p = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, url);
            this.rule(errors, ValidationMessage.IssueType.STRUCTURE, ei.line(), ei.col(), ei.getPath(), p != null, "Validation_VAL_Unknown_Profile", profiles.get(0));
        } else {
            elementValidated = true;
            HashMap<String, ArrayList<ValidationMessage>> goodProfiles = new HashMap<String, ArrayList<ValidationMessage>>();
            HashMap<String, ArrayList<ValidationMessage>> badProfiles = new HashMap<String, ArrayList<ValidationMessage>>();
            Iterator<Object> iterator = profiles.iterator();
            while (iterator.hasNext()) {
                String typeProfile;
                String url = typeProfile = (String)iterator.next();
                tail = null;
                if (url.contains("#")) {
                    tail = url.substring(url.indexOf("#") + 1);
                    url = url.substring(0, url.indexOf("#"));
                }
                p = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, typeProfile);
                if (!this.rule(errors, ValidationMessage.IssueType.STRUCTURE, ei.line(), ei.col(), ei.getPath(), p != null, "Validation_VAL_Unknown_Profile", typeProfile)) continue;
                ArrayList<ValidationMessage> profileErrors = new ArrayList<ValidationMessage>();
                this.validateElement(hostContext, profileErrors, p, this.getElementByTail(p, tail), profile, checkDefn, resource, ei.getElement(), type, localStack, thisIsCodeableConcept, checkDisplay, thisExtension);
                if (this.hasErrors(profileErrors)) {
                    badProfiles.put(typeProfile, profileErrors);
                    continue;
                }
                goodProfiles.put(typeProfile, profileErrors);
            }
            if (goodProfiles.size() == 1) {
                errors.addAll((Collection)goodProfiles.values().iterator().next());
            } else if (goodProfiles.size() == 0) {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, ei.line(), ei.col(), ei.getPath(), false, "Validation_VAL_Profile_NoMatch", StringUtils.join((Object[])new Object[]{"; ", profiles}));
                for (String m : badProfiles.keySet()) {
                    p = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, m);
                    for (ValidationMessage message : (List)badProfiles.get(m)) {
                        message.setMessage(message.getMessage() + " (validating against " + p.getUrl() + (p.hasVersion() ? "|" + p.getVersion() : "") + " [" + p.getName() + "])");
                        errors.add(message);
                    }
                }
            } else {
                this.warning(errors, ValidationMessage.IssueType.STRUCTURE, ei.line(), ei.col(), ei.getPath(), false, "Validation_VAL_Profile_MultipleMatches", StringUtils.join((Object[])new Object[]{"; ", goodProfiles.keySet()}));
                for (String m : goodProfiles.keySet()) {
                    p = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, m);
                    for (ValidationMessage message : (List)goodProfiles.get(m)) {
                        message.setMessage(message.getMessage() + " (validating against " + p.getUrl() + (p.hasVersion() ? "|" + p.getVersion() : "") + " [" + p.getName() + "])");
                        errors.add(message);
                    }
                }
            }
        }
        if (p != null) {
            String nextPath;
            int index;
            this.trackUsage(p, hostContext, element);
            if (!elementValidated) {
                if (ei.getElement().getSpecial() == Element.SpecialElement.BUNDLE_ENTRY || ei.getElement().getSpecial() == Element.SpecialElement.BUNDLE_OUTCOME || ei.getElement().getSpecial() == Element.SpecialElement.PARAMETER) {
                    this.validateElement(hostContext, errors, p, this.getElementByTail(p, tail), profile, checkDefn, ei.getElement(), ei.getElement(), type, localStack.resetIds(), thisIsCodeableConcept, checkDisplay, thisExtension);
                } else {
                    this.validateElement(hostContext, errors, p, this.getElementByTail(p, tail), profile, checkDefn, resource, ei.getElement(), type, localStack, thisIsCodeableConcept, checkDisplay, thisExtension);
                }
            }
            if ((index = profile.getSnapshot().getElement().indexOf(checkDefn)) < profile.getSnapshot().getElement().size() - 1 && !(nextPath = ((ElementDefinition)profile.getSnapshot().getElement().get(index + 1)).getPath()).equals(checkDefn.getPath()) && nextPath.startsWith(checkDefn.getPath())) {
                this.validateElement(hostContext, errors, profile, checkDefn, null, null, resource, ei.getElement(), type, localStack, thisIsCodeableConcept, checkDisplay, thisExtension);
            }
        }
    }

    private boolean isResourceAndTypes(ElementDefinition ed) {
        if (!Utilities.existsInList((String)ed.getBase().getPath(), (String[])new String[]{"Bundle.entry.resource", "Bundle.entry.response.outcome", "DomainResource.contained", "Parameters.parameter.resource", "Parameters.parameter.part.resource"})) {
            return false;
        }
        for (ElementDefinition.TypeRefComponent tr : ed.getType()) {
            if (this.isResource(tr.getCode())) continue;
            return false;
        }
        return true;
    }

    private boolean isResource(String type) {
        StructureDefinition sd = this.context.fetchTypeDefinition(type);
        return sd != null && sd.getKind().equals((Object)StructureDefinition.StructureDefinitionKind.RESOURCE);
    }

    private void trackUsage(StructureDefinition profile, ValidatorHostContext hostContext, org.hl7.fhir.r5.elementmodel.Element element) {
        if (this.tracker != null) {
            this.tracker.recordProfileUsage(profile, hostContext.getAppContext(), element);
        }
    }

    private boolean hasMapping(String url, StructureDefinition defn, ElementDefinition elem) {
        String id = null;
        for (StructureDefinition.StructureDefinitionMappingComponent m : defn.getMapping()) {
            if (!url.equals(m.getUri())) continue;
            id = m.getIdentity();
            break;
        }
        if (id != null) {
            for (StructureDefinition.StructureDefinitionMappingComponent m : elem.getMapping()) {
                if (!id.equals(m.getIdentity())) continue;
                return true;
            }
        }
        return false;
    }

    private List<String> getMapping(String url, StructureDefinition defn, ElementDefinition elem) {
        ArrayList<String> res = new ArrayList<String>();
        String id = null;
        for (StructureDefinition.StructureDefinitionMappingComponent m : defn.getMapping()) {
            if (!url.equals(m.getUri())) continue;
            id = m.getIdentity();
            break;
        }
        if (id != null) {
            for (StructureDefinition.StructureDefinitionMappingComponent m : elem.getMapping()) {
                if (!id.equals(m.getIdentity())) continue;
                res.add(m.getMap());
            }
        }
        return res;
    }

    public void checkMustSupport(StructureDefinition profile, ElementInfo ei) {
        String elementSupported;
        String usesMustSupport = profile.getUserString("usesMustSupport");
        if (usesMustSupport == null) {
            usesMustSupport = "N";
            for (ElementDefinition pe : profile.getSnapshot().getElement()) {
                if (!pe.getMustSupport()) continue;
                usesMustSupport = "Y";
                break;
            }
            profile.setUserData("usesMustSupport", (Object)usesMustSupport);
        }
        if (usesMustSupport.equals("Y") && ((elementSupported = ei.getElement().getUserString("elementSupported")) == null || ei.definition.getMustSupport()) && ei.definition.getMustSupport()) {
            ei.getElement().setUserData("elementSupported", (Object)"Y");
        }
    }

    public void checkCardinalities(List<ValidationMessage> errors, StructureDefinition profile, org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack, List<ElementDefinition> childDefinitions, List<ElementInfo> children, List<String> problematicPaths) throws DefinitionException {
        for (ElementDefinition ed : childDefinitions) {
            if (!ed.getRepresentation().isEmpty()) continue;
            int count = 0;
            List slices = null;
            if (ed.hasSlicing()) {
                slices = this.profileUtilities.getSliceList(profile, ed);
            }
            block1: for (ElementInfo ei : children) {
                if (ei.definition == ed) {
                    ++count;
                    continue;
                }
                if (slices == null) continue;
                for (ElementDefinition sed : slices) {
                    if (ei.definition != sed) continue;
                    ++count;
                    continue block1;
                }
            }
            if (ed.getMin() > 0) {
                if (problematicPaths.contains(ed.getPath())) {
                    this.hint(errors, ValidationMessage.IssueType.NOTSUPPORTED, element.line(), element.col(), stack.getLiteralPath(), count >= ed.getMin(), "Validation_VAL_Profile_NoCheckMin", profile.getUrl(), ed.getPath(), ed.getId(), ed.getSliceName(), ed.getLabel(), stack.getLiteralPath(), Integer.toString(ed.getMin()));
                } else if (count < ed.getMin()) {
                    this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath(), false, "Validation_VAL_Profile_Minimum", profile.getUrl(), ed.getPath(), ed.getId(), ed.getSliceName(), ed.getLabel(), stack.getLiteralPath(), Integer.toString(ed.getMin()), Integer.toString(count));
                }
            }
            if (!ed.hasMax() || ed.getMax().equals("*")) continue;
            if (problematicPaths.contains(ed.getPath())) {
                this.hint(errors, ValidationMessage.IssueType.NOTSUPPORTED, element.line(), element.col(), stack.getLiteralPath(), count <= Integer.parseInt(ed.getMax()), "Validation_VAL_Profile_NoCheckMax", profile.getUrl(), ed.getPath(), ed.getId(), ed.getSliceName(), ed.getLabel(), stack.getLiteralPath(), ed.getMax());
                continue;
            }
            if (count <= Integer.parseInt(ed.getMax())) continue;
            this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath(), false, "Validation_VAL_Profile_Maximum", profile.getUrl(), ed.getPath(), ed.getId(), ed.getSliceName(), ed.getLabel(), stack.getLiteralPath(), ed.getMax(), Integer.toString(count));
        }
    }

    public List<String> assignChildren(ValidatorHostContext hostContext, List<ValidationMessage> errors, StructureDefinition profile, org.hl7.fhir.r5.elementmodel.Element resource, NodeStack stack, List<ElementDefinition> childDefinitions, List<ElementInfo> children) throws DefinitionException {
        ElementDefinition slicer = null;
        boolean unsupportedSlicing = false;
        ArrayList<String> problematicPaths = new ArrayList<String>();
        String slicingPath = null;
        int sliceOffset = 0;
        for (int i = 0; i < childDefinitions.size(); ++i) {
            ElementDefinition ed = childDefinitions.get(i);
            boolean childUnsupportedSlicing = false;
            boolean process = true;
            if (ed.hasSlicing() && !ed.getSlicing().getOrdered()) {
                slicingPath = ed.getPath();
            } else if (!(slicingPath != null && ed.getPath().equals(slicingPath) || slicingPath == null || ed.getPath().startsWith(slicingPath))) {
                slicingPath = null;
            }
            if (ed.hasSlicing()) {
                if (slicer != null && slicer.getPath().equals(ed.getPath())) {
                    Object errorContext = "profile " + profile.getUrl();
                    if (!resource.getChildValue("id").isEmpty()) {
                        errorContext = (String)errorContext + "; instance " + resource.getChildValue("id");
                    }
                    throw new DefinitionException(this.context.formatMessage("Slice_encountered_midway_through_set_path___id___", new Object[]{slicer.getPath(), slicer.getId(), errorContext}));
                }
                slicer = ed;
                process = false;
                sliceOffset = i;
            } else if (slicer != null && !slicer.getPath().equals(ed.getPath())) {
                slicer = null;
            }
            for (ElementInfo ei : children) {
                if (ei.sliceInfo == null) {
                    ei.sliceInfo = new ArrayList<ValidationMessage>();
                }
                unsupportedSlicing = this.matchSlice(hostContext, errors, ei.sliceInfo, profile, stack, slicer, unsupportedSlicing, problematicPaths, sliceOffset, i, ed, childUnsupportedSlicing, ei);
            }
        }
        int last = -1;
        int lastSlice = -1;
        for (ElementInfo ei : children) {
            String sliceInfo = "";
            if (slicer != null) {
                sliceInfo = " (slice: " + slicer.getPath() + ")";
            }
            if (!unsupportedSlicing) {
                if (ei.additionalSlice && ei.definition != null) {
                    if (ei.definition.getSlicing().getRules().equals((Object)ElementDefinition.SlicingRules.OPEN) || ei.definition.getSlicing().getRules().equals((Object)ElementDefinition.SlicingRules.OPENATEND)) {
                        this.slicingHint(errors, ValidationMessage.IssueType.INFORMATIONAL, ei.line(), ei.col(), ei.getPath(), false, this.context.formatMessage("This_element_does_not_match_any_known_slice_", new Object[]{profile == null ? "" : " defined in the profile " + profile.getUrl()}), this.context.formatMessage("This_element_does_not_match_any_known_slice_", new Object[]{profile == null ? "" : "defined_in_the_profile" + profile.getUrl()}) + this.errorSummaryForSlicingAsHtml(ei.sliceInfo));
                    } else if (ei.definition.getSlicing().getRules().equals((Object)ElementDefinition.SlicingRules.CLOSED)) {
                        this.rule(errors, ValidationMessage.IssueType.INVALID, ei.line(), ei.col(), ei.getPath(), false, "Validation_VAL_Profile_NotSlice", profile == null ? "" : " defined in the profile " + profile.getUrl(), this.errorSummaryForSlicing(ei.sliceInfo));
                    }
                } else if (!profile.getAbstract()) {
                    this.rule(errors, ValidationMessage.IssueType.NOTSUPPORTED, ei.line(), ei.col(), ei.getPath(), ei.definition != null, "Validation_VAL_Profile_NotAllowed", profile.getUrl());
                }
            }
            boolean isXmlAttr = false;
            if (ei.definition != null) {
                for (Enumeration r : ei.definition.getRepresentation()) {
                    if (r.getValue() != ElementDefinition.PropertyRepresentation.XMLATTR) continue;
                    isXmlAttr = true;
                    break;
                }
            }
            if (!ToolingExtensions.readBoolExtension((DomainResource)profile, (String)"http://hl7.org/fhir/StructureDefinition/structuredefinition-xml-no-order")) {
                boolean ok = ei.definition == null || ei.index >= last || isXmlAttr;
                this.rule(errors, ValidationMessage.IssueType.INVALID, ei.line(), ei.col(), ei.getPath(), ok, "Validation_VAL_Profile_OutOfOrder", profile.getUrl(), ei.getName());
            }
            if (ei.slice != null && ei.index == last && ei.slice.getSlicing().getOrdered()) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, ei.line(), ei.col(), ei.getPath(), ei.definition == null || ei.sliceindex >= lastSlice || isXmlAttr, "Validation_VAL_Profile_SliceOrder", profile.getUrl(), ei.getName());
            }
            if (ei.definition == null || !isXmlAttr) {
                last = ei.index;
            }
            if (ei.slice != null) {
                lastSlice = ei.sliceindex;
                continue;
            }
            lastSlice = -1;
        }
        return problematicPaths;
    }

    public List<ElementInfo> listChildren(org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack) {
        ArrayList<ElementInfo> children = new ArrayList<ElementInfo>();
        ChildIterator iter = new ChildIterator(this, stack.getLiteralPath(), element);
        while (iter.next()) {
            children.add(new ElementInfo(iter.name(), iter.element(), iter.path(), iter.count()));
        }
        return children;
    }

    public void checkInvariants(ValidatorHostContext hostContext, List<ValidationMessage> errors, StructureDefinition profile, ElementDefinition definition, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack, boolean onlyNonInherited) throws FHIRException {
        this.checkInvariants(hostContext, errors, stack.getLiteralPath(), profile, definition, null, null, resource, element, onlyNonInherited);
    }

    public boolean matchSlice(ValidatorHostContext hostContext, List<ValidationMessage> errors, List<ValidationMessage> sliceInfo, StructureDefinition profile, NodeStack stack, ElementDefinition slicer, boolean unsupportedSlicing, List<String> problematicPaths, int sliceOffset, int i, ElementDefinition ed, boolean childUnsupportedSlicing, ElementInfo ei) {
        boolean match = false;
        if (slicer == null || slicer == ed) {
            match = this.nameMatches(ei.getName(), this.tail(ed.getPath()));
        } else if (this.nameMatches(ei.getName(), this.tail(ed.getPath()))) {
            try {
                match = this.sliceMatches(hostContext, ei.getElement(), ei.getPath(), slicer, ed, profile, errors, sliceInfo, stack);
                if (match) {
                    ei.slice = slicer;
                    ei.additionalSlice = false;
                } else if (ei.slice == null) {
                    ei.additionalSlice = true;
                }
            }
            catch (FHIRException e) {
                this.rule(errors, ValidationMessage.IssueType.PROCESSING, ei.line(), ei.col(), ei.getPath(), false, "SLICING_CANNOT_BE_EVALUATED", e.getMessage());
                unsupportedSlicing = true;
                childUnsupportedSlicing = true;
            }
        }
        if (match) {
            boolean isOk = ei.definition == null || ei.definition == slicer || ei.definition.getPath().endsWith("[x]") && ed.getPath().startsWith(ei.definition.getPath().replace("[x]", ""));
            Object[] objectArray = new Object[3];
            objectArray[0] = profile.getUrl();
            objectArray[1] = ei.definition == null || !ei.definition.hasSliceName() ? "" : ei.definition.getSliceName();
            Object object = objectArray[2] = ed.hasSliceName() ? ed.getSliceName() : "";
            if (this.rule(errors, ValidationMessage.IssueType.INVALID, ei.line(), ei.col(), ei.getPath(), isOk, "Validation_VAL_Profile_MatchMultiple", objectArray)) {
                ei.definition = ed;
                if (ei.slice == null) {
                    ei.index = i;
                } else {
                    ei.index = sliceOffset;
                    ei.sliceindex = i - (sliceOffset + 1);
                }
            }
        } else if (childUnsupportedSlicing) {
            problematicPaths.add(ed.getPath());
        }
        return unsupportedSlicing;
    }

    private ElementDefinition getElementByTail(StructureDefinition p, String tail) throws DefinitionException {
        if (tail == null) {
            return (ElementDefinition)p.getSnapshot().getElement().get(0);
        }
        for (ElementDefinition t : p.getSnapshot().getElement()) {
            if (!tail.equals(t.getId())) continue;
            return t;
        }
        throw new DefinitionException(this.context.formatMessage("Unable_to_find_element_with_id_", new Object[]{tail}));
    }

    private IResourceValidator.IdStatus idStatusForEntry(org.hl7.fhir.r5.elementmodel.Element ep, ElementInfo ei) {
        if (this.isBundleEntry(ei.getPath())) {
            org.hl7.fhir.r5.elementmodel.Element req = ep.getNamedChild("request");
            org.hl7.fhir.r5.elementmodel.Element resp = ep.getNamedChild("response");
            org.hl7.fhir.r5.elementmodel.Element fullUrl = ep.getNamedChild("fullUrl");
            org.hl7.fhir.r5.elementmodel.Element method = null;
            org.hl7.fhir.r5.elementmodel.Element url = null;
            if (req != null) {
                method = req.getNamedChild("method");
                url = req.getNamedChild("url");
            }
            if (resp != null) {
                return IResourceValidator.IdStatus.OPTIONAL;
            }
            if (method == null) {
                if (fullUrl == null) {
                    return IResourceValidator.IdStatus.REQUIRED;
                }
                if (fullUrl.primitiveValue().startsWith("urn:uuid:") || fullUrl.primitiveValue().startsWith("urn:oid:")) {
                    return IResourceValidator.IdStatus.OPTIONAL;
                }
                return IResourceValidator.IdStatus.REQUIRED;
            }
            String s = method.primitiveValue();
            if (s.equals("PUT")) {
                if (url == null) {
                    return IResourceValidator.IdStatus.REQUIRED;
                }
                return IResourceValidator.IdStatus.OPTIONAL;
            }
            if (s.equals("POST")) {
                return IResourceValidator.IdStatus.OPTIONAL;
            }
            return IResourceValidator.IdStatus.OPTIONAL;
        }
        if (this.isParametersEntry(ei.getPath()) || this.isBundleOutcome(ei.getPath())) {
            return IResourceValidator.IdStatus.OPTIONAL;
        }
        return IResourceValidator.IdStatus.REQUIRED;
    }

    private void checkInvariants(ValidatorHostContext hostContext, List<ValidationMessage> errors, String path, StructureDefinition profile, ElementDefinition ed, String typename, String typeProfile, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element element, boolean onlyNonInherited) throws FHIRException, FHIRException {
        if (this.noInvariantChecks) {
            return;
        }
        for (ElementDefinition.ElementDefinitionConstraintComponent inv : ed.getConstraint()) {
            HashSet<String> invList;
            if (!inv.hasExpression() || onlyNonInherited && inv.hasSource() && (this.isInheritedProfile(profile, inv.getSource()) || this.isInheritedProfile(ed.getType(), inv.getSource()))) continue;
            HashSet<String> hashSet = invList = this.executionId.equals(element.getUserString(EXECUTION_ID)) ? (HashSet<String>)element.getUserData(EXECUTED_CONSTRAINT_LIST) : null;
            if (invList == null) {
                invList = new HashSet<String>();
                element.setUserData(EXECUTED_CONSTRAINT_LIST, invList);
                element.setUserData(EXECUTION_ID, (Object)this.executionId);
            }
            if (invList.contains(inv.getKey())) continue;
            invList.add(inv.getKey());
            this.checkInvariant(hostContext, errors, path, profile, resource, element, inv);
        }
    }

    private boolean isInheritedProfile(List<ElementDefinition.TypeRefComponent> types, String source) {
        for (ElementDefinition.TypeRefComponent type : types) {
            for (CanonicalType c : type.getProfile()) {
                StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, c.asStringValue());
                if (sd == null) continue;
                if (sd.getUrl().equals(source)) {
                    return true;
                }
                if (!this.isInheritedProfile(sd, source)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isInheritedProfile(StructureDefinition profile, String source) {
        if (source.equals(profile.getUrl())) {
            return false;
        }
        while (profile != null) {
            if ((profile = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, profile.getBaseDefinition())) == null || !source.equals(profile.getUrl())) continue;
            return true;
        }
        return false;
    }

    public void checkInvariant(ValidatorHostContext hostContext, List<ValidationMessage> errors, String path, StructureDefinition profile, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element element, ElementDefinition.ElementDefinitionConstraintComponent inv) throws FHIRException {
        String msg;
        boolean ok;
        ExpressionNode n = (ExpressionNode)inv.getUserData("validator.expression.cache");
        if (n == null) {
            long t = System.nanoTime();
            try {
                n = this.fpe.parse(this.fixExpr(inv.getExpression(), inv.getKey()));
            }
            catch (FHIRLexer.FHIRLexerException e) {
                throw new FHIRException(this.context.formatMessage("Problem_processing_expression__in_profile__path__", new Object[]{inv.getExpression(), profile.getUrl(), path, e.getMessage()}));
            }
            this.timeTracker.fpe(t);
            inv.setUserData("validator.expression.cache", (Object)n);
        }
        try {
            long t = System.nanoTime();
            ok = this.fpe.evaluateToBoolean((Object)hostContext, (Base)resource, (Base)hostContext.getRootResource(), (Base)element, n);
            this.timeTracker.fpe(t);
            msg = this.fpe.forLog();
        }
        catch (Exception ex) {
            ok = false;
            msg = ex.getMessage();
        }
        if (!ok) {
            if (!Utilities.noString((String)msg)) {
                msg = " (" + msg + ")";
            }
            if (inv.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-bestpractice") && ToolingExtensions.readBooleanExtension((org.hl7.fhir.r5.model.Element)inv, (String)"http://hl7.org/fhir/StructureDefinition/elementdefinition-bestpractice").booleanValue()) {
                if (this.bpWarnings == IResourceValidator.BestPracticeWarningLevel.Hint) {
                    this.hint(errors, ValidationMessage.IssueType.INVARIANT, element.line(), element.col(), path, ok, inv.getKey() + ": '" + inv.getHuman() + "' " + (Utilities.noString((String)msg) ? "failed" : msg));
                } else if (this.bpWarnings == IResourceValidator.BestPracticeWarningLevel.Warning) {
                    this.warning(errors, ValidationMessage.IssueType.INVARIANT, element.line(), element.col(), path, ok, inv.getKey() + ": '" + inv.getHuman() + "' " + (Utilities.noString((String)msg) ? "failed" : msg), new Object[0]);
                } else if (this.bpWarnings == IResourceValidator.BestPracticeWarningLevel.Error) {
                    this.rule(errors, ValidationMessage.IssueType.INVARIANT, element.line(), element.col(), path, ok, inv.getKey() + ": '" + inv.getHuman() + "' " + (Utilities.noString((String)msg) ? "failed" : msg), new Object[0]);
                }
            } else if (inv.getSeverity() == ElementDefinition.ConstraintSeverity.ERROR) {
                this.rule(errors, ValidationMessage.IssueType.INVARIANT, element.line(), element.col(), path, ok, inv.getKey() + ": '" + inv.getHuman() + "' " + (Utilities.noString((String)msg) ? "failed" : msg), new Object[0]);
            } else if (inv.getSeverity() == ElementDefinition.ConstraintSeverity.WARNING) {
                this.warning(errors, ValidationMessage.IssueType.INVARIANT, element.line(), element.line(), path, ok, inv.getKey() + ": '" + inv.getHuman() + "' " + (Utilities.noString((String)msg) ? "failed" : msg), new Object[0]);
            }
        }
    }

    private void validateObservation(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack) {
        this.bpCheck(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), element.getNamedChild("subject") != null, "All_observations_should_have_a_subject", new Object[0]);
        ArrayList performers = new ArrayList();
        element.getNamedChildren("performer", performers);
        this.bpCheck(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), performers.size() > 0, "All_observations_should_have_a_performer", new Object[0]);
        this.bpCheck(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), element.getNamedChild("effectiveDateTime") != null || element.getNamedChild("effectivePeriod") != null, "All_observations_should_have_an_effectiveDateTime_or_an_effectivePeriod", new Object[0]);
    }

    private void validateResource(ValidatorHostContext hostContext, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition defn, IResourceValidator.IdStatus idstatus, NodeStack stack) throws FHIRException {
        NodeStack first;
        String type;
        assert (stack != null);
        assert (resource != null);
        boolean ok = true;
        String resourceName = element.getType();
        if (defn == null) {
            long t = System.nanoTime();
            defn = element.getProperty().getStructure();
            if (defn == null) {
                defn = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + resourceName);
            }
            this.timeTracker.sd(t);
            ok = this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.addToLiteralPath(resourceName), defn != null, "Validation_VAL_Profile_NoDefinition", resourceName);
        }
        String string = type = defn.getKind() == StructureDefinition.StructureDefinitionKind.LOGICAL ? defn.getId() : defn.getType();
        if (!type.equals(resourceName) && resourceName.equals("Bundle") && (first = this.getFirstEntry(stack)) != null && first.getElement().getType().equals(type)) {
            element = first.getElement();
            stack = first;
            resourceName = element.getType();
            idstatus = IResourceValidator.IdStatus.OPTIONAL;
        }
        if (ok = this.rule(errors, ValidationMessage.IssueType.INVALID, -1, -1, stack.getLiteralPath(), type.equals(resourceName), "Validation_VAL_Profile_WrongType", type, resourceName)) {
            if (idstatus == IResourceValidator.IdStatus.REQUIRED && element.getNamedChild("id") == null) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), false, "Resource_RES_ID_Missing", new Object[0]);
            } else if (idstatus == IResourceValidator.IdStatus.PROHIBITED && element.getNamedChild("id") != null) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), false, "Resource_RES_ID_Prohibited", new Object[0]);
            }
            this.start(hostContext, errors, element, element, defn, stack);
        }
    }

    private NodeStack getFirstEntry(NodeStack bundle) {
        ArrayList list = new ArrayList();
        bundle.getElement().getNamedChildren("entry", list);
        if (list.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.elementmodel.Element resource = ((org.hl7.fhir.r5.elementmodel.Element)list.get(0)).getNamedChild("resource");
        if (resource == null) {
            return null;
        }
        NodeStack entry = bundle.push((org.hl7.fhir.r5.elementmodel.Element)list.get(0), 0, ((org.hl7.fhir.r5.elementmodel.Element)list.get(0)).getProperty().getDefinition(), ((org.hl7.fhir.r5.elementmodel.Element)list.get(0)).getProperty().getDefinition());
        return entry.push(resource, -1, resource.getProperty().getDefinition(), this.context.fetchTypeDefinition(resource.fhirType()).getSnapshot().getElementFirstRep());
    }

    private boolean valueMatchesCriteria(org.hl7.fhir.r5.elementmodel.Element value, ElementDefinition criteria, StructureDefinition profile) throws FHIRException {
        if (criteria.hasFixed()) {
            ArrayList<ValidationMessage> msgs = new ArrayList<ValidationMessage>();
            this.checkFixedValue(msgs, "{virtual}", value, (org.hl7.fhir.r5.model.Element)criteria.getFixed(), profile.getUrl(), "value", null, false);
            return msgs.size() == 0;
        }
        if (criteria.hasBinding() && criteria.getBinding().getStrength() == Enumerations.BindingStrength.REQUIRED && criteria.getBinding().hasValueSet()) {
            throw new FHIRException(this.context.formatMessage("Unable_to_resolve_slice_matching__slice_matching_by_value_set_not_done", new Object[0]));
        }
        throw new FHIRException(this.context.formatMessage("Unable_to_resolve_slice_matching__no_fixed_value_or_required_value_set", new Object[0]));
    }

    private boolean yearIsValid(String v) {
        if (v == null) {
            return false;
        }
        try {
            int i = Integer.parseInt(v.substring(0, Math.min(4, v.length())));
            return i >= 1800 && i <= this.thisYear() + 80;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private int thisYear() {
        return Calendar.getInstance().get(1);
    }

    public String reportTimes() {
        String s = String.format("Times (ms): overall = %d, tx = %d, sd = %d, load = %d, fpe = %d", this.timeTracker.getOverall() / 1000000L, this.timeTracker.getTxTime() / 1000000L, this.timeTracker.getSdTime() / 1000000L, this.timeTracker.getLoadTime() / 1000000L, this.timeTracker.getFpeTime() / 1000000L);
        this.timeTracker.reset();
        return s;
    }

    public boolean isNoBindingMsgSuppressed() {
        return this.noBindingMsgSuppressed;
    }

    public IResourceValidator setNoBindingMsgSuppressed(boolean noBindingMsgSuppressed) {
        this.noBindingMsgSuppressed = noBindingMsgSuppressed;
        return this;
    }

    public boolean isNoTerminologyChecks() {
        return this.noTerminologyChecks;
    }

    public IResourceValidator setNoTerminologyChecks(boolean noTerminologyChecks) {
        this.noTerminologyChecks = noTerminologyChecks;
        return this;
    }

    public void checkAllInvariants() {
        for (StructureDefinition sd : this.context.allStructures()) {
            if (sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION) continue;
            for (ElementDefinition ed : sd.getSnapshot().getElement()) {
                for (ElementDefinition.ElementDefinitionConstraintComponent inv : ed.getConstraint()) {
                    if (!inv.hasExpression()) continue;
                    try {
                        ExpressionNode n = (ExpressionNode)inv.getUserData("validator.expression.cache");
                        if (n == null) {
                            n = this.fpe.parse(this.fixExpr(inv.getExpression(), inv.getKey()));
                            inv.setUserData("validator.expression.cache", (Object)n);
                        }
                        this.fpe.check(null, sd.getKind() == StructureDefinition.StructureDefinitionKind.RESOURCE ? sd.getType() : "DomainResource", ed.getPath(), n);
                    }
                    catch (Exception e) {
                        System.out.println("Error processing structure [" + sd.getId() + "] path " + ed.getPath() + ":" + inv.getKey() + " ('" + inv.getExpression() + "'): " + e.getMessage());
                    }
                }
            }
        }
    }

    private String fixExpr(String expr, String key) {
        if ("probability is decimal implies (probability as decimal) <= 100".equals(expr)) {
            return "probablility.empty() or ((probability is decimal) implies ((probability as decimal) <= 100))";
        }
        if ("enableWhen.count() > 2 implies enableBehavior.exists()".equals(expr)) {
            return "enableWhen.count() >= 2 implies enableBehavior.exists()";
        }
        if ("txt-2".equals(key)) {
            return "htmlChecks2()";
        }
        if ("(component.empty() and hasMember.empty()) implies (dataAbsentReason or value)".equals(expr)) {
            return "(component.empty() and hasMember.empty()) implies (dataAbsentReason.exists() or value.exists())";
        }
        if ("isModifier implies isModifierReason.exists()".equals(expr)) {
            return "(isModifier.exists() and isModifier) implies isModifierReason.exists()";
        }
        if ("(%resource.kind = 'logical' or element.first().path.startsWith(%resource.type)) and (element.tail().not() or  element.tail().all(path.startsWith(%resource.differential.element.first().path.replaceMatches('\\\\..*','')&'.')))".equals(expr)) {
            return "(%resource.kind = 'logical' or element.first().path.startsWith(%resource.type)) and (element.tail().empty() or  element.tail().all(path.startsWith(%resource.differential.element.first().path.replaceMatches('\\\\..*','')&'.')))";
        }
        if ("differential.element.all(id) and differential.element.id.trace('ids').isDistinct()".equals(expr)) {
            return "differential.element.all(id.exists()) and differential.element.id.trace('ids').isDistinct()";
        }
        if ("snapshot.element.all(id) and snapshot.element.id.trace('ids').isDistinct()".equals(expr)) {
            return "snapshot.element.all(id.exists()) and snapshot.element.id.trace('ids').isDistinct()";
        }
        if ("(code or value.empty()) and (system.empty() or system = 'urn:iso:std:iso:4217')".equals(expr)) {
            return "(code.exists() or value.empty()) and (system.empty() or system = 'urn:iso:std:iso:4217')";
        }
        if ("value.empty() or code!=component.code".equals(expr)) {
            return "value.empty() or (code in component.code).not()";
        }
        if ("(code or value.empty()) and (system.empty() or system = %ucum) and (value.empty() or value > 0)".equals(expr)) {
            return "(code.exists() or value.empty()) and (system.empty() or system = %ucum) and (value.empty() or value > 0)";
        }
        if ("element.all(definition and min and max)".equals(expr)) {
            return "element.all(definition.exists() and min.exists() and max.exists())";
        }
        if ("telecom or endpoint".equals(expr)) {
            return "telecom.exists() or endpoint.exists()";
        }
        if ("(code or value.empty()) and (system.empty() or system = %ucum) and (value.empty() or value > 0)".equals(expr)) {
            return "(code.exists() or value.empty()) and (system.empty() or system = %ucum) and (value.empty() or value > 0)";
        }
        if ("searchType implies type = 'string'".equals(expr)) {
            return "searchType.exists() implies type = 'string'";
        }
        if ("abatement.empty() or (abatement as boolean).not()  or clinicalStatus='resolved' or clinicalStatus='remission' or clinicalStatus='inactive'".equals(expr)) {
            return "abatement.empty() or (abatement is boolean).not() or (abatement as boolean).not() or (clinicalStatus = 'resolved') or (clinicalStatus = 'remission') or (clinicalStatus = 'inactive')";
        }
        if ("(component.empty() and related.empty()) implies (dataAbsentReason or value)".equals(expr)) {
            return "(component.empty() and related.empty()) implies (dataAbsentReason.exists() or value.exists())";
        }
        if ("reference.startsWith('#').not() or (reference.substring(1).trace('url') in %rootResource.contained.id.trace('ids'))".equals(expr)) {
            return "(reference = '#') or reference.startsWith('#').not() or (reference.substring(1).trace('url') in %rootResource.contained.id.trace('ids'))";
        }
        if ("reference.startsWith('#').not() or (reference.substring(1).trace('url') in %resource.contained.id.trace('ids'))".equals(expr)) {
            return "(reference = '#') or reference.startsWith('#').not() or (reference.substring(1).trace('url') in %resource.contained.id.trace('ids'))";
        }
        if ("".equals(expr)) {
            return "";
        }
        return expr;
    }

    public FHIRPathEngine.IEvaluationContext getExternalHostServices() {
        return this.externalHostServices;
    }

    public String getValidationLanguage() {
        return this.validationLanguage;
    }

    public void setValidationLanguage(String validationLanguage) {
        this.validationLanguage = validationLanguage;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    private String tail(String path) {
        return path.substring(path.lastIndexOf(".") + 1);
    }

    private String tryParse(String ref) {
        String[] parts = ref.split("\\/");
        switch (parts.length) {
            case 1: {
                return null;
            }
            case 2: {
                return this.checkResourceType(parts[0]);
            }
        }
        if (parts[parts.length - 2].equals("_history") && parts.length >= 4) {
            return this.checkResourceType(parts[parts.length - 4]);
        }
        return this.checkResourceType(parts[parts.length - 2]);
    }

    private boolean typesAreAllReference(List<ElementDefinition.TypeRefComponent> theType) {
        for (ElementDefinition.TypeRefComponent typeRefComponent : theType) {
            if (typeRefComponent.getCode().equals("Reference")) continue;
            return false;
        }
        return true;
    }

    public IWorkerContext.ValidationResult checkCodeOnServer(NodeStack stack, ValueSet vs, String value, ValidationOptions options) {
        return this.context.validateCode(options, value, vs);
    }

    public IWorkerContext.ValidationResult checkCodeOnServer(NodeStack stack, String code, String system, String display, boolean checkDisplay) {
        return this.context.validateCode(new ValidationOptions(stack.getWorkingLang()), system, code, checkDisplay ? display : null);
    }

    public IWorkerContext.ValidationResult checkCodeOnServer(NodeStack stack, ValueSet valueset, Coding c, boolean checkMembership) {
        if (checkMembership) {
            return this.context.validateCode(new ValidationOptions(stack.getWorkingLang()), c, valueset);
        }
        return this.context.validateCode(new ValidationOptions(stack.getWorkingLang()).noCheckValueSetMembership(), c, valueset);
    }

    public IWorkerContext.ValidationResult checkCodeOnServer(NodeStack stack, ValueSet valueset, CodeableConcept cc, boolean vsOnly) {
        if (vsOnly) {
            return this.context.validateCode(new ValidationOptions(stack.getWorkingLang()).checkValueSetOnly(), cc, valueset);
        }
        return this.context.validateCode(new ValidationOptions(stack.getWorkingLang()), cc, valueset);
    }

    public boolean isSecurityChecks() {
        return this.securityChecks;
    }

    public void setSecurityChecks(boolean securityChecks) {
        this.securityChecks = securityChecks;
    }

    public List<IResourceValidator.BundleValidationRule> getBundleValidationRules() {
        return this.bundleValidationRules;
    }

    public boolean isValidateValueSetCodesOnTxServer() {
        return this.validateValueSetCodesOnTxServer;
    }

    public void setValidateValueSetCodesOnTxServer(boolean value) {
        this.validateValueSetCodesOnTxServer = value;
    }

    public boolean isNoCheckAggregation() {
        return this.noCheckAggregation;
    }

    public void setNoCheckAggregation(boolean noCheckAggregation) {
        this.noCheckAggregation = noCheckAggregation;
    }

    public static void setParents(org.hl7.fhir.r5.elementmodel.Element element) {
        if (element != null && !element.hasParentForValidator()) {
            element.setParentForValidator(null);
            InstanceValidator.setParentsInner(element);
        }
    }

    public static void setParentsInner(org.hl7.fhir.r5.elementmodel.Element element) {
        for (org.hl7.fhir.r5.elementmodel.Element child : element.getChildren()) {
            child.setParentForValidator(element);
            InstanceValidator.setParentsInner(child);
        }
    }

    public void setQuestionnaireMode(QuestionnaireMode questionnaireMode) {
        this.questionnaireMode = questionnaireMode;
    }

    public QuestionnaireMode getQuestionnaireMode() {
        return this.questionnaireMode;
    }

    public boolean isWantCheckSnapshotUnchanged() {
        return this.wantCheckSnapshotUnchanged;
    }

    public void setWantCheckSnapshotUnchanged(boolean wantCheckSnapshotUnchanged) {
        this.wantCheckSnapshotUnchanged = wantCheckSnapshotUnchanged;
    }

    private class ValidatorHostServices
    implements FHIRPathEngine.IEvaluationContext {
        private ValidatorHostServices() {
        }

        public Base resolveConstant(Object appContext, String name, boolean beforeContext) throws PathEngineException {
            ValidatorHostContext c = (ValidatorHostContext)appContext;
            if (InstanceValidator.this.externalHostServices != null) {
                return InstanceValidator.this.externalHostServices.resolveConstant(c.getAppContext(), name, beforeContext);
            }
            return null;
        }

        public TypeDetails resolveConstantType(Object appContext, String name) throws PathEngineException {
            ValidatorHostContext c = (ValidatorHostContext)appContext;
            if (InstanceValidator.this.externalHostServices != null) {
                return InstanceValidator.this.externalHostServices.resolveConstantType(c.getAppContext(), name);
            }
            return null;
        }

        public boolean log(String argument, List<Base> focus) {
            if (InstanceValidator.this.externalHostServices != null) {
                return InstanceValidator.this.externalHostServices.log(argument, focus);
            }
            return false;
        }

        public FHIRPathEngine.IEvaluationContext.FunctionDetails resolveFunction(String functionName) {
            throw new Error(InstanceValidator.this.context.formatMessage("Not_done_yet_ValidatorHostServicesresolveFunction_", new Object[]{functionName}));
        }

        public TypeDetails checkFunction(Object appContext, String functionName, List<TypeDetails> parameters) throws PathEngineException {
            throw new Error(InstanceValidator.this.context.formatMessage("Not_done_yet_ValidatorHostServicescheckFunction", new Object[0]));
        }

        public List<Base> executeFunction(Object appContext, List<Base> focus, String functionName, List<List<Base>> parameters) {
            throw new Error(InstanceValidator.this.context.formatMessage("Not_done_yet_ValidatorHostServicesexecuteFunction", new Object[0]));
        }

        public Base resolveReference(Object appContext, String url, Base refContext) throws FHIRException {
            Base res;
            ValidatorHostContext c = (ValidatorHostContext)appContext;
            if (refContext != null && refContext.hasUserData("validator.bundle.resolution")) {
                return (Base)refContext.getUserData("validator.bundle.resolution");
            }
            if (c.getAppContext() instanceof org.hl7.fhir.r5.elementmodel.Element) {
                for (org.hl7.fhir.r5.elementmodel.Element element = (org.hl7.fhir.r5.elementmodel.Element)c.getAppContext(); element != null; element = element.getParentForValidator()) {
                    Base res2 = InstanceValidator.this.resolveInBundle(url, element);
                    if (res2 == null) continue;
                    return res2;
                }
            }
            if ((res = InstanceValidator.this.resolveInBundle(url, c.getResource())) != null) {
                return res;
            }
            for (org.hl7.fhir.r5.elementmodel.Element element = c.getRootResource(); element != null; element = element.getParentForValidator()) {
                res = InstanceValidator.this.resolveInBundle(url, element);
                if (res == null) continue;
                return res;
            }
            if (InstanceValidator.this.externalHostServices != null) {
                return InstanceValidator.this.externalHostServices.resolveReference(c.getAppContext(), url, refContext);
            }
            if (InstanceValidator.this.fetcher != null) {
                try {
                    return InstanceValidator.this.fetcher.fetch(c.getAppContext(), url);
                }
                catch (IOException e) {
                    throw new FHIRException((Throwable)e);
                }
            }
            throw new Error(InstanceValidator.this.context.formatMessage("Not_done_yet__resolve__locally_2", new Object[]{url}));
        }

        public boolean conformsToProfile(Object appContext, Base item, String url) throws FHIRException {
            org.hl7.fhir.r5.elementmodel.Element e;
            ValidatorHostContext ctxt = (ValidatorHostContext)appContext;
            StructureDefinition sd = (StructureDefinition)InstanceValidator.this.context.fetchResource(StructureDefinition.class, url);
            if (sd == null) {
                throw new FHIRException(InstanceValidator.this.context.formatMessage("Unable_to_resolve_", new Object[]{url}));
            }
            InstanceValidator self = InstanceValidator.this;
            ArrayList valerrors = new ArrayList();
            if (item instanceof Resource) {
                try {
                    e = new ObjectConverter(InstanceValidator.this.context).convert((Resource)item);
                    InstanceValidator.setParents(e);
                    self.validateResource(new ValidatorHostContext(ctxt.getAppContext(), e), valerrors, e, e, sd, IResourceValidator.IdStatus.OPTIONAL, new NodeStack(InstanceValidator.this.context, e, InstanceValidator.this.validationLanguage));
                }
                catch (IOException e1) {
                    throw new FHIRException((Throwable)e1);
                }
            } else if (item instanceof org.hl7.fhir.r5.elementmodel.Element) {
                e = (org.hl7.fhir.r5.elementmodel.Element)item;
                self.validateResource(new ValidatorHostContext(ctxt.getAppContext(), e), valerrors, e, e, sd, IResourceValidator.IdStatus.OPTIONAL, new NodeStack(InstanceValidator.this.context, e, InstanceValidator.this.validationLanguage));
            } else {
                throw new NotImplementedException(InstanceValidator.this.context.formatMessage("Not_done_yet_ValidatorHostServicesconformsToProfile_when_item_is_not_an_element", new Object[0]));
            }
            boolean ok = true;
            ArrayList<ValidationMessage> record = new ArrayList<ValidationMessage>();
            for (ValidationMessage v : valerrors) {
                boolean bl = ok = ok && !v.getLevel().isError();
                if (!v.getLevel().isError() && !v.isSlicingHint()) continue;
                record.add(v);
            }
            if (!ok && !record.isEmpty()) {
                ctxt.sliceNotes(url, record);
            }
            return ok;
        }

        public ValueSet resolveValueSet(Object appContext, String url) {
            ValidatorHostContext c = (ValidatorHostContext)appContext;
            if (c.getProfile() != null && url.startsWith("#")) {
                for (Resource r : c.getProfile().getContained()) {
                    if (!r.getId().equals(url.substring(1))) continue;
                    if (r instanceof ValueSet) {
                        return (ValueSet)r;
                    }
                    throw new FHIRException(InstanceValidator.this.context.formatMessage("Reference__refers_to_a__not_a_ValueSet", new Object[]{url, r.fhirType()}));
                }
                return null;
            }
            return (ValueSet)InstanceValidator.this.context.fetchResource(ValueSet.class, url);
        }
    }
}

