/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.cli.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.hl7.fhir.r5.utils.IResourceValidator;
import org.hl7.fhir.validation.Validator;

public class CliContext {
    @JsonProperty(value="doNative")
    private boolean doNative = false;
    @JsonProperty(value="anyExtensionsAllowed")
    private boolean anyExtensionsAllowed = true;
    @JsonProperty(value="hintAboutNonMustSupport")
    private boolean hintAboutNonMustSupport = false;
    @JsonProperty(value="recursive")
    private boolean recursive = false;
    @JsonProperty(value="doDebug")
    private boolean doDebug = false;
    @JsonProperty(value="assumeValidRestReferences")
    private boolean assumeValidRestReferences = false;
    @JsonProperty(value="canDoNative")
    private boolean canDoNative = false;
    @JsonProperty(value="noInternalCaching")
    private boolean noInternalCaching = false;
    @JsonProperty(value="noExtensibleBindingMessages")
    private boolean noExtensibleBindingMessages = false;
    @JsonProperty(value="map")
    private String map = null;
    @JsonProperty(value="output")
    private String output = null;
    @JsonProperty(value="txServer")
    private String txServer = "http://tx.fhir.org";
    @JsonProperty(value="sv")
    private String sv = null;
    @JsonProperty(value="txLog")
    private String txLog = null;
    @JsonProperty(value="mapLog")
    private String mapLog = null;
    @JsonProperty(value="lang")
    private String lang = null;
    @JsonProperty(value="fhirpath")
    private String fhirpath = null;
    @JsonProperty(value="snomedCT")
    private String snomedCT = "900000000000207008";
    @JsonProperty(value="targetVer")
    private String targetVer = null;
    @JsonProperty(value="igs")
    private List<String> igs = new ArrayList<String>();
    @JsonProperty(value="questionnaires")
    private List<String> questionnaires = new ArrayList<String>();
    @JsonProperty(value="profiles")
    private List<String> profiles = new ArrayList<String>();
    @JsonProperty(value="sources")
    private List<String> sources = new ArrayList<String>();
    @JsonProperty(value="mode")
    private Validator.EngineMode mode = Validator.EngineMode.VALIDATION;
    @JsonProperty(value="securityChecks")
    private boolean securityChecks = false;
    @JsonProperty(value="crumbTrails")
    private boolean crumbTrails = false;
    @JsonProperty(value="showTimes")
    private boolean showTimes = false;
    @JsonProperty(value="locale")
    private String locale = Locale.ENGLISH.getDisplayLanguage();
    @JsonProperty(value="locations")
    private Map<String, String> locations = new HashMap<String, String>();
    private List<IResourceValidator.BundleValidationRule> bundleValidationRules = new ArrayList<IResourceValidator.BundleValidationRule>();

    @JsonProperty(value="map")
    public String getMap() {
        return this.map;
    }

    @JsonProperty(value="map")
    public CliContext setMap(String map) {
        this.map = map;
        return this;
    }

    @JsonProperty(value="igs")
    public List<String> getIgs() {
        return this.igs;
    }

    @JsonProperty(value="igs")
    public CliContext setIgs(List<String> igs) {
        this.igs = igs;
        return this;
    }

    public List<IResourceValidator.BundleValidationRule> getBundleValidationRules() {
        return this.bundleValidationRules;
    }

    public CliContext addIg(String ig) {
        if (this.igs == null) {
            this.igs = new ArrayList<String>();
        }
        this.igs.add(ig);
        return this;
    }

    @JsonProperty(value="questionnaires")
    public List<String> getQuestionnaires() {
        return this.questionnaires;
    }

    @JsonProperty(value="questionnaires")
    public CliContext setQuestionnaires(List<String> questionnaires) {
        this.questionnaires = questionnaires;
        return this;
    }

    public CliContext addQuestionnaire(String questionnaire) {
        if (this.questionnaires == null) {
            this.questionnaires = new ArrayList<String>();
        }
        this.questionnaires.add(questionnaire);
        return this;
    }

    @JsonProperty(value="txServer")
    public String getTxServer() {
        return this.txServer;
    }

    @JsonProperty(value="txServer")
    public CliContext setTxServer(String txServer) {
        this.txServer = txServer;
        return this;
    }

    @JsonProperty(value="doNative")
    public boolean isDoNative() {
        return this.doNative;
    }

    @JsonProperty(value="doNative")
    public CliContext setDoNative(boolean doNative) {
        this.doNative = doNative;
        return this;
    }

    @JsonProperty(value="anyExtensionsAllowed")
    public boolean isAnyExtensionsAllowed() {
        return this.anyExtensionsAllowed;
    }

    @JsonProperty(value="anyExtensionsAllowed")
    public CliContext setAnyExtensionsAllowed(boolean anyExtensionsAllowed) {
        this.anyExtensionsAllowed = anyExtensionsAllowed;
        return this;
    }

    @JsonProperty(value="hintAboutNonMustSupport")
    public boolean isHintAboutNonMustSupport() {
        return this.hintAboutNonMustSupport;
    }

    @JsonProperty(value="hintAboutNonMustSupport")
    public CliContext setHintAboutNonMustSupport(boolean hintAboutNonMustSupport) {
        this.hintAboutNonMustSupport = hintAboutNonMustSupport;
        return this;
    }

    @JsonProperty(value="recursive")
    public boolean isRecursive() {
        return this.recursive;
    }

    @JsonProperty(value="recursive")
    public CliContext setRecursive(boolean recursive) {
        this.recursive = recursive;
        return this;
    }

    @JsonProperty(value="locale")
    public String getLanguageCode() {
        return this.locale;
    }

    public Locale getLocale() {
        return Locale.forLanguageTag(this.locale);
    }

    @JsonProperty(value="locale")
    public CliContext setLocale(String languageString) {
        this.locale = languageString;
        return this;
    }

    public CliContext setLocale(Locale locale) {
        this.locale = locale.getDisplayLanguage();
        return this;
    }

    @JsonProperty(value="profiles")
    public List<String> getProfiles() {
        return this.profiles;
    }

    @JsonProperty(value="profiles")
    public CliContext setProfiles(List<String> profiles) {
        this.profiles = profiles;
        return this;
    }

    public CliContext addProfile(String profile) {
        if (this.profiles == null) {
            this.profiles = new ArrayList<String>();
        }
        this.profiles.add(profile);
        return this;
    }

    @JsonProperty(value="mode")
    public Validator.EngineMode getMode() {
        return this.mode;
    }

    @JsonProperty(value="mode")
    public CliContext setMode(Validator.EngineMode mode) {
        this.mode = mode;
        return this;
    }

    @JsonProperty(value="output")
    public String getOutput() {
        return this.output;
    }

    @JsonProperty(value="output")
    public CliContext setOutput(String output) {
        this.output = output;
        return this;
    }

    @JsonProperty(value="canDoNative")
    public boolean getCanDoNative() {
        return this.canDoNative;
    }

    @JsonProperty(value="canDoNative")
    public CliContext setCanDoNative(boolean canDoNative) {
        this.canDoNative = canDoNative;
        return this;
    }

    @JsonProperty(value="sources")
    public List<String> getSources() {
        return this.sources;
    }

    @JsonProperty(value="sources")
    public CliContext setSources(List<String> sources) {
        this.sources = sources;
        return this;
    }

    public CliContext addSource(String source) {
        if (this.sources == null) {
            this.sources = new ArrayList<String>();
        }
        this.sources.add(source);
        return this;
    }

    @JsonProperty(value="locations")
    public Map<String, String> getLocations() {
        return this.locations;
    }

    @JsonProperty(value="locations")
    public CliContext setLocations(Map<String, String> locations) {
        this.locations = locations;
        return this;
    }

    public CliContext addLocation(String profile, String location) {
        this.locations.put(profile, location);
        return this;
    }

    @JsonProperty(value="sv")
    public String getSv() {
        return this.sv;
    }

    @JsonProperty(value="sv")
    public CliContext setSv(String sv) {
        this.sv = sv;
        return this;
    }

    @JsonProperty(value="txLog")
    public String getTxLog() {
        return this.txLog;
    }

    @JsonProperty(value="txLog")
    public CliContext setTxLog(String txLog) {
        this.txLog = txLog;
        return this;
    }

    @JsonProperty(value="mapLog")
    public String getMapLog() {
        return this.mapLog;
    }

    @JsonProperty(value="mapLog")
    public CliContext setMapLog(String mapLog) {
        this.mapLog = mapLog;
        return this;
    }

    @JsonProperty(value="lang")
    public String getLang() {
        return this.lang;
    }

    @JsonProperty(value="lang")
    public CliContext setLang(String lang) {
        this.lang = lang;
        return this;
    }

    @JsonProperty(value="fhirpath")
    public String getFhirpath() {
        return this.fhirpath;
    }

    @JsonProperty(value="fhirpath")
    public CliContext setFhirpath(String fhirpath) {
        this.fhirpath = fhirpath;
        return this;
    }

    @JsonProperty(value="snomedCT")
    public String getSnomedCTCode() {
        if ("intl".equals(this.snomedCT)) {
            return "900000000000207008";
        }
        if ("us".equals(this.snomedCT)) {
            return "731000124108";
        }
        if ("uk".equals(this.snomedCT)) {
            return "999000041000000102";
        }
        if ("au".equals(this.snomedCT)) {
            return "32506021000036107";
        }
        if ("ca".equals(this.snomedCT)) {
            return "20611000087101";
        }
        if ("nl".equals(this.snomedCT)) {
            return "11000146104";
        }
        if ("se".equals(this.snomedCT)) {
            return "45991000052106";
        }
        if ("es".equals(this.snomedCT)) {
            return "449081005";
        }
        if ("dk".equals(this.snomedCT)) {
            return "554471000005108";
        }
        return this.snomedCT;
    }

    @JsonProperty(value="snomedCT")
    public CliContext setSnomedCT(String snomedCT) {
        this.snomedCT = snomedCT;
        return this;
    }

    @JsonProperty(value="targetVer")
    public String getTargetVer() {
        return this.targetVer;
    }

    @JsonProperty(value="targetVer")
    public CliContext setTargetVer(String targetVer) {
        this.targetVer = targetVer;
        return this;
    }

    @JsonProperty(value="doDebug")
    public boolean isDoDebug() {
        return this.doDebug;
    }

    @JsonProperty(value="doDebug")
    public CliContext setDoDebug(boolean doDebug) {
        this.doDebug = doDebug;
        return this;
    }

    @JsonProperty(value="assumeValidRestReferences")
    public boolean isAssumeValidRestReferences() {
        return this.assumeValidRestReferences;
    }

    @JsonProperty(value="assumeValidRestReferences")
    public CliContext setAssumeValidRestReferences(boolean assumeValidRestReferences) {
        this.assumeValidRestReferences = assumeValidRestReferences;
        return this;
    }

    @JsonProperty(value="noInternalCaching")
    public boolean isNoInternalCaching() {
        return this.noInternalCaching;
    }

    @JsonProperty(value="noInternalCaching")
    public CliContext setNoInternalCaching(boolean noInternalCaching) {
        this.noInternalCaching = noInternalCaching;
        return this;
    }

    @JsonProperty(value="noExtensibleBindingMessages")
    public boolean isNoExtensibleBindingMessages() {
        return this.noExtensibleBindingMessages;
    }

    @JsonProperty(value="noExtensibleBindingMessages")
    public CliContext setNoExtensibleBindingMessages(boolean noExtensibleBindingMessages) {
        this.noExtensibleBindingMessages = noExtensibleBindingMessages;
        return this;
    }

    @JsonProperty(value="securityChecks")
    public boolean isSecurityChecks() {
        return this.securityChecks;
    }

    @JsonProperty(value="securityChecks")
    public CliContext setSecurityChecks(boolean securityChecks) {
        this.securityChecks = securityChecks;
        return this;
    }

    public boolean isCrumbTrails() {
        return this.crumbTrails;
    }

    public void setCrumbTrails(boolean crumbTrails) {
        this.crumbTrails = crumbTrails;
    }

    public boolean isShowTimes() {
        return this.showTimes;
    }

    public void setShowTimes(boolean showTimes) {
        this.showTimes = showTimes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CliContext that = (CliContext)o;
        return this.doNative == that.doNative && this.anyExtensionsAllowed == that.anyExtensionsAllowed && this.hintAboutNonMustSupport == that.hintAboutNonMustSupport && this.recursive == that.recursive && this.doDebug == that.doDebug && this.assumeValidRestReferences == that.assumeValidRestReferences && this.canDoNative == that.canDoNative && this.noInternalCaching == that.noInternalCaching && this.noExtensibleBindingMessages == that.noExtensibleBindingMessages && Objects.equals(this.map, that.map) && Objects.equals(this.output, that.output) && Objects.equals(this.txServer, that.txServer) && Objects.equals(this.sv, that.sv) && Objects.equals(this.txLog, that.txLog) && Objects.equals(this.mapLog, that.mapLog) && Objects.equals(this.lang, that.lang) && Objects.equals(this.fhirpath, that.fhirpath) && Objects.equals(this.snomedCT, that.snomedCT) && Objects.equals(this.targetVer, that.targetVer) && Objects.equals(this.igs, that.igs) && Objects.equals(this.questionnaires, that.questionnaires) && Objects.equals(this.profiles, that.profiles) && Objects.equals(this.sources, that.sources) && Objects.equals(this.crumbTrails, that.crumbTrails) && Objects.equals(this.showTimes, that.showTimes) && this.mode == that.mode && Objects.equals(this.locale, that.locale) && Objects.equals(this.locations, that.locations);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.doNative, this.anyExtensionsAllowed, this.hintAboutNonMustSupport, this.recursive, this.doDebug, this.assumeValidRestReferences, this.canDoNative, this.noInternalCaching, this.noExtensibleBindingMessages, this.map, this.output, this.txServer, this.sv, this.txLog, this.mapLog, this.lang, this.fhirpath, this.snomedCT, this.targetVer, this.igs, this.questionnaires, this.profiles, this.sources, this.mode, this.locale, this.locations, this.crumbTrails, this.showTimes});
    }
}

