/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.hl7.fhir.convertors.VersionConvertorAdvisor50;
import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.convertors.VersionConvertor_10_40;
import org.hl7.fhir.convertors.VersionConvertor_10_50;
import org.hl7.fhir.convertors.VersionConvertor_14_30;
import org.hl7.fhir.convertors.VersionConvertor_14_40;
import org.hl7.fhir.convertors.VersionConvertor_14_50;
import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.convertors.loaders.BaseLoaderR5;
import org.hl7.fhir.convertors.loaders.R2016MayToR5Loader;
import org.hl7.fhir.convertors.loaders.R2ToR5Loader;
import org.hl7.fhir.convertors.loaders.R3ToR5Loader;
import org.hl7.fhir.convertors.loaders.R4ToR5Loader;
import org.hl7.fhir.convertors.loaders.R5ToR5Loader;
import org.hl7.fhir.convertors.misc.IGR2ConvertorAdvisor5;
import org.hl7.fhir.convertors.txClient.TerminologyClientFactory;
import org.hl7.fhir.dstu2.formats.IParser;
import org.hl7.fhir.dstu2016may.formats.IParser;
import org.hl7.fhir.dstu2016may.formats.JsonParser;
import org.hl7.fhir.dstu3.formats.IParser;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.formats.IParser;
import org.hl7.fhir.r4.formats.XmlParser;
import org.hl7.fhir.r4.utils.StructureMapUtilities;
import org.hl7.fhir.r5.conformance.ProfileUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.context.SimpleWorkerContext;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.elementmodel.ObjectConverter;
import org.hl7.fhir.r5.formats.FormatUtilities;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.FhirPublication;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.renderers.RendererFactory;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.terminologies.ConceptMapEngine;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.r5.utils.FHIRPathEngine;
import org.hl7.fhir.r5.utils.IResourceValidator;
import org.hl7.fhir.r5.utils.OperationOutcomeUtilities;
import org.hl7.fhir.r5.utils.StructureMapUtilities;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.utilities.IniFile;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.cache.FilesystemPackageCacheManager;
import org.hl7.fhir.utilities.cache.NpmPackage;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;
import org.hl7.fhir.validation.cli.services.StandAloneValidatorFetcher;
import org.hl7.fhir.validation.instance.InstanceValidator;
import org.xml.sax.SAXException;

public class ValidationEngine
implements IResourceValidator.IValidatorResourceFetcher,
StandAloneValidatorFetcher.IPackageInstaller {
    private SimpleWorkerContext context;
    private Map<String, byte[]> binaries = new HashMap<String, byte[]>();
    private boolean doNative;
    private boolean noInvariantChecks;
    private boolean hintAboutNonMustSupport;
    private boolean anyExtensionsAllowed = false;
    private String version;
    private String language;
    private FilesystemPackageCacheManager pcm;
    private PrintWriter mapLog;
    private boolean debug;
    private IResourceValidator.IValidatorResourceFetcher fetcher;
    private boolean assumeValidRestReferences;
    private boolean noExtensibleBindingMessages;
    private boolean securityChecks;
    private boolean crumbTrails;
    private Locale locale;
    private List<ImplementationGuide> igs = new ArrayList<ImplementationGuide>();
    private boolean showTimes;
    private List<IResourceValidator.BundleValidationRule> bundleValidationRules = new ArrayList<IResourceValidator.BundleValidationRule>();
    private static final int BUFFER_SIZE = 4096;

    public ValidationEngine() throws IOException {
        this.pcm = new FilesystemPackageCacheManager(true, 3);
        this.context = SimpleWorkerContext.fromNothing();
    }

    public void setTerminologyServer(String src, String log, FhirPublication version) throws FHIRException, URISyntaxException {
        this.connectToTSServer(src, log, version);
    }

    public boolean isHintAboutNonMustSupport() {
        return this.hintAboutNonMustSupport;
    }

    public void setHintAboutNonMustSupport(boolean hintAboutNonMustSupport) {
        this.hintAboutNonMustSupport = hintAboutNonMustSupport;
    }

    public boolean isAnyExtensionsAllowed() {
        return this.anyExtensionsAllowed;
    }

    public void setAnyExtensionsAllowed(boolean anyExtensionsAllowed) {
        this.anyExtensionsAllowed = anyExtensionsAllowed;
    }

    public boolean isShowTimes() {
        return this.showTimes;
    }

    public void setShowTimes(boolean showTimes) {
        this.showTimes = showTimes;
    }

    public ValidationEngine(String src, String txsrvr, String txLog, FhirPublication version, boolean canRunWithoutTerminologyServer, String vString) throws FHIRException, IOException, URISyntaxException {
        this.pcm = new FilesystemPackageCacheManager(true, 3);
        this.loadCoreDefinitions(src, false);
        this.context.setCanRunWithoutTerminology(canRunWithoutTerminologyServer);
        this.setTerminologyServer(txsrvr, txLog, version);
        this.version = vString;
    }

    public ValidationEngine(String src, String txsrvr, String txLog, FhirPublication version, String vString) throws FHIRException, IOException, URISyntaxException {
        this.pcm = new FilesystemPackageCacheManager(true, 3);
        this.loadCoreDefinitions(src, false);
        this.setTerminologyServer(txsrvr, txLog, version);
        this.version = vString;
    }

    public ValidationEngine(String src) throws FHIRException, IOException {
        this.loadCoreDefinitions(src, false);
        this.pcm = new FilesystemPackageCacheManager(true, 3);
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    private void loadCoreDefinitions(String src, boolean recursive) throws FHIRException, IOException {
        NpmPackage npm;
        if (this.pcm == null) {
            this.pcm = new FilesystemPackageCacheManager(true, 3);
        }
        if ((npm = this.pcm.loadPackage(src, null)) != null) {
            this.version = npm.fhirVersion();
            this.context = SimpleWorkerContext.fromPackage((NpmPackage)npm, (IWorkerContext.IContextResourceLoader)this.loaderForVersion());
        } else {
            Map<String, byte[]> source = this.loadIgSource(src, recursive, true);
            if (this.version == null) {
                this.version = this.getVersionFromPack(source);
            }
            this.context = SimpleWorkerContext.fromDefinitions(source, (IWorkerContext.IContextResourceLoader)this.loaderForVersion(), (IWorkerContext.PackageVersion)new IWorkerContext.PackageVersion(src));
            this.grabNatives(source, "http://hl7.org/fhir");
        }
        this.context.setCacheId(UUID.randomUUID().toString());
        this.context.setAllowLoadingDuplicates(true);
        this.context.setExpansionProfile(this.makeExpProfile());
        NpmPackage npmX = this.pcm.loadPackage("hl7.fhir.xver-extensions", "0.0.4");
        this.context.loadFromPackage(npmX, null);
    }

    private IWorkerContext.IContextResourceLoader loaderForVersion() {
        return this.loaderForVersion(this.version);
    }

    private IWorkerContext.IContextResourceLoader loaderForVersion(String version) {
        if (Utilities.noString((String)version)) {
            return null;
        }
        if (version.startsWith("1.0")) {
            return new R2ToR5Loader(new String[]{"Conformance", "StructureDefinition", "ValueSet", "SearchParameter", "OperationDefinition", "Questionnaire", "ConceptMap", "StructureMap", "NamingSystem"}, (BaseLoaderR5.ILoaderKnowledgeProvider)new BaseLoaderR5.NullLoaderKnowledgeProvider());
        }
        if (version.startsWith("1.4")) {
            return new R2016MayToR5Loader(new String[]{"Conformance", "StructureDefinition", "ValueSet", "CodeSystem", "SearchParameter", "OperationDefinition", "Questionnaire", "ConceptMap", "StructureMap", "NamingSystem"}, (BaseLoaderR5.ILoaderKnowledgeProvider)new BaseLoaderR5.NullLoaderKnowledgeProvider());
        }
        if (version.startsWith("3.0")) {
            return new R3ToR5Loader(new String[]{"CapabilityStatement", "StructureDefinition", "ValueSet", "CodeSystem", "SearchParameter", "OperationDefinition", "Questionnaire", "ConceptMap", "StructureMap", "NamingSystem"}, (BaseLoaderR5.ILoaderKnowledgeProvider)new BaseLoaderR5.NullLoaderKnowledgeProvider());
        }
        if (version.startsWith("4.0")) {
            return new R4ToR5Loader(new String[]{"CapabilityStatement", "StructureDefinition", "ValueSet", "CodeSystem", "SearchParameter", "OperationDefinition", "Questionnaire", "ConceptMap", "StructureMap", "NamingSystem"}, (BaseLoaderR5.ILoaderKnowledgeProvider)new BaseLoaderR5.NullLoaderKnowledgeProvider());
        }
        if (version.startsWith("5.0")) {
            return new R5ToR5Loader(new String[]{"CapabilityStatement", "StructureDefinition", "ValueSet", "CodeSystem", "SearchParameter", "OperationDefinition", "Questionnaire", "ConceptMap", "StructureMap", "NamingSystem"}, (BaseLoaderR5.ILoaderKnowledgeProvider)new BaseLoaderR5.NullLoaderKnowledgeProvider());
        }
        return null;
    }

    private String getVersionFromPack(Map<String, byte[]> source) {
        if (source.containsKey("version.info")) {
            IniFile vi = new IniFile((InputStream)new ByteArrayInputStream(this.removeBom(source.get("version.info"))));
            return vi.getStringProperty("FHIR", "version");
        }
        throw new Error("Missing version.info?");
    }

    private byte[] removeBom(byte[] bs) {
        if (bs.length > 3 && bs[0] == -17 && bs[1] == -69 && bs[2] == -65) {
            return Arrays.copyOfRange(bs, 3, bs.length);
        }
        return bs;
    }

    private Parameters makeExpProfile() {
        Parameters ep = new Parameters();
        ep.addParameter("profile-url", "http://hl7.org/fhir/ExpansionProfile/dc8fd4bc-091a-424a-8a3b-6198ef146891");
        return ep;
    }

    private byte[] loadProfileSource(String src) throws FHIRException, FileNotFoundException, IOException {
        if (Utilities.noString((String)src)) {
            throw new FHIRException("Profile Source '" + src + "' could not be processed");
        }
        if (src.startsWith("https:") || src.startsWith("http:")) {
            return this.loadProfileFromUrl(src);
        }
        if (new File(src).exists()) {
            return this.loadProfileFromFile(src);
        }
        throw new FHIRException("Definitions Source '" + src + "' could not be processed");
    }

    private byte[] loadProfileFromUrl(String src) throws FHIRException {
        try {
            URL url = new URL(src + "?nocache=" + System.currentTimeMillis());
            URLConnection c = url.openConnection();
            return IOUtils.toByteArray((InputStream)c.getInputStream());
        }
        catch (Exception e) {
            throw new FHIRException("Unable to find definitions at URL '" + src + "': " + e.getMessage(), (Throwable)e);
        }
    }

    private byte[] loadProfileFromFile(String src) throws FileNotFoundException, IOException {
        File f = new File(src);
        if (f.isDirectory()) {
            throw new IOException("You must provide a file name, not a directory name");
        }
        return TextFile.fileToBytes((String)src);
    }

    private Map<String, byte[]> loadIgSource(String src, boolean recursive, boolean explore) throws FHIRException, IOException {
        if (src.startsWith("https:") || src.startsWith("http:")) {
            String pid;
            String v = null;
            if (src.contains("|")) {
                v = src.substring(src.indexOf("|") + 1);
                src = src.substring(0, src.indexOf("|"));
            }
            if (!Utilities.noString((String)(pid = this.pcm.getPackageId(src)))) {
                return this.fetchByPackage(pid + (v == null ? "" : "#" + v));
            }
            return this.fetchFromUrl(src + (v == null ? "" : "|" + v), explore);
        }
        File f = new File(Utilities.path((String[])new String[]{src}));
        if (f.exists()) {
            if (f.isDirectory() && new File(Utilities.path((String[])new String[]{src, "package.tgz"})).exists()) {
                return this.loadPackage(new FileInputStream(Utilities.path((String[])new String[]{src, "package.tgz"})), Utilities.path((String[])new String[]{src, "package.tgz"}));
            }
            if (f.isDirectory() && new File(Utilities.path((String[])new String[]{src, "igpack.zip"})).exists()) {
                return this.readZip(new FileInputStream(Utilities.path((String[])new String[]{src, "igpack.zip"})));
            }
            if (f.isDirectory() && new File(Utilities.path((String[])new String[]{src, "validator.pack"})).exists()) {
                return this.readZip(new FileInputStream(Utilities.path((String[])new String[]{src, "validator.pack"})));
            }
            if (f.isDirectory()) {
                return this.scanDirectory(f, recursive);
            }
            if (src.endsWith(".tgz")) {
                return this.loadPackage(new FileInputStream(src), src);
            }
            if (src.endsWith(".pack")) {
                return this.readZip(new FileInputStream(src));
            }
            if (src.endsWith("igpack.zip")) {
                return this.readZip(new FileInputStream(src));
            }
            Manager.FhirFormat fmt = this.checkIsResource(src);
            if (fmt != null) {
                HashMap<String, byte[]> res = new HashMap<String, byte[]>();
                res.put(Utilities.changeFileExt((String)src, (String)("." + fmt.getExtension())), TextFile.fileToBytesNCS((String)src));
                return res;
            }
        } else if ((src.matches("^[a-z][a-z0-9\\_\\-]*(\\.[a-z0-9\\_\\-]+)+$") || src.matches("^[a-z][a-z0-9\\_\\-]*(\\.[a-z0-9\\_\\-]+)+\\#[a-z0-9\\-\\_]+(\\.[a-z0-9\\-\\_]+)*$")) && !src.endsWith(".zip") && !src.endsWith(".tgz")) {
            return this.fetchByPackage(src);
        }
        throw new FHIRException("Unable to find/resolve/read -ig " + src);
    }

    private Map<String, byte[]> loadIgSourceForVersion(String src, boolean recursive, boolean explore, VersionSourceInformation versions) throws FHIRException, IOException {
        if (src.startsWith("https:") || src.startsWith("http:")) {
            String pid;
            String v = null;
            if (src.contains("|")) {
                v = src.substring(src.indexOf("|") + 1);
                src = src.substring(0, src.indexOf("|"));
            }
            if (!Utilities.noString((String)(pid = this.pcm.getPackageId(src)))) {
                versions.see(this.fetchVersionByPackage(pid + (v == null ? "" : "#" + v)), "Package " + src);
                return null;
            }
            return this.fetchVersionFromUrl(src + (v == null ? "" : "|" + v), explore, versions);
        }
        File f = new File(Utilities.path((String[])new String[]{src}));
        if (f.exists()) {
            if (f.isDirectory() && new File(Utilities.path((String[])new String[]{src, "package.tgz"})).exists()) {
                versions.see(this.loadPackageForVersion(new FileInputStream(Utilities.path((String[])new String[]{src, "package.tgz"})), Utilities.path((String[])new String[]{src, "package.tgz"})), "Package " + src);
                return null;
            }
            if (f.isDirectory() && new File(Utilities.path((String[])new String[]{src, "igpack.zip"})).exists()) {
                return this.readZip(new FileInputStream(Utilities.path((String[])new String[]{src, "igpack.zip"})));
            }
            if (f.isDirectory() && new File(Utilities.path((String[])new String[]{src, "validator.pack"})).exists()) {
                return this.readZip(new FileInputStream(Utilities.path((String[])new String[]{src, "validator.pack"})));
            }
            if (f.isDirectory()) {
                return this.scanDirectory(f, recursive);
            }
            if (src.endsWith(".tgz")) {
                versions.see(this.loadPackageForVersion(new FileInputStream(src), src), "Package " + src);
                return null;
            }
            if (src.endsWith(".pack")) {
                return this.readZip(new FileInputStream(src));
            }
            if (src.endsWith("igpack.zip")) {
                return this.readZip(new FileInputStream(src));
            }
            Manager.FhirFormat fmt = this.checkIsResource(src);
            if (fmt != null) {
                HashMap<String, byte[]> res = new HashMap<String, byte[]>();
                res.put(Utilities.changeFileExt((String)src, (String)("." + fmt.getExtension())), TextFile.fileToBytesNCS((String)src));
                return res;
            }
        } else if ((src.matches("^[a-z][a-z0-9\\_\\-]*(\\.[a-z0-9\\_\\-]+)+$") || src.matches("^[a-z][a-z0-9\\_\\-]*(\\.[a-z0-9\\_\\-]+)+\\#[a-z0-9\\-\\_]+(\\.[a-z0-9\\-\\_]+)*$")) && !src.endsWith(".zip") && !src.endsWith(".tgz")) {
            versions.see(this.fetchVersionByPackage(src), "Package " + src);
            return null;
        }
        throw new FHIRException("Unable to find/resolve/read -ig " + src);
    }

    private Map<String, byte[]> fetchFromUrl(String src, boolean explore) throws FHIRException, IOException {
        byte[] cnt;
        Manager.FhirFormat fmt;
        if (src.endsWith(".tgz")) {
            return this.loadPackage(this.fetchFromUrlSpecific(src, false), src);
        }
        if (src.endsWith(".pack")) {
            return this.readZip(this.fetchFromUrlSpecific(src, false));
        }
        if (src.endsWith("igpack.zip")) {
            return this.readZip(this.fetchFromUrlSpecific(src, false));
        }
        InputStream stream = null;
        if (explore) {
            stream = this.fetchFromUrlSpecific(Utilities.pathURL((String[])new String[]{src, "package.tgz"}), true);
            if (stream != null) {
                return this.loadPackage(stream, Utilities.pathURL((String[])new String[]{src, "package.tgz"}));
            }
            stream = this.fetchFromUrlSpecific(Utilities.pathURL((String[])new String[]{src, "igpack.zip"}), true);
            if (stream != null) {
                return this.readZip(stream);
            }
            stream = this.fetchFromUrlSpecific(Utilities.pathURL((String[])new String[]{src, "validator.pack"}), true);
            if (stream != null) {
                return this.readZip(stream);
            }
            stream = this.fetchFromUrlSpecific(Utilities.pathURL((String[])new String[]{src, "validator.pack"}), true);
        }
        if ((fmt = this.checkIsResource(cnt = stream == null ? this.fetchFromUrlSpecific(src, "application/json", true) : TextFile.streamToBytes(stream), src)) != null) {
            HashMap<String, byte[]> res = new HashMap<String, byte[]>();
            res.put(Utilities.changeFileExt((String)src, (String)("." + fmt.getExtension())), cnt);
            return res;
        }
        throw new FHIRException("Unable to find/resolve/read -ig " + src);
    }

    private Map<String, byte[]> fetchVersionFromUrl(String src, boolean explore, VersionSourceInformation versions) throws FHIRException, IOException {
        byte[] cnt;
        Manager.FhirFormat fmt;
        if (src.endsWith(".tgz")) {
            versions.see(this.loadPackageForVersion(this.fetchFromUrlSpecific(src, false), src), "From Package " + src);
            return null;
        }
        if (src.endsWith(".pack")) {
            return this.readZip(this.fetchFromUrlSpecific(src, false));
        }
        if (src.endsWith("igpack.zip")) {
            return this.readZip(this.fetchFromUrlSpecific(src, false));
        }
        InputStream stream = null;
        if (explore) {
            stream = this.fetchFromUrlSpecific(Utilities.pathURL((String[])new String[]{src, "package.tgz"}), true);
            if (stream != null) {
                versions.see(this.loadPackageForVersion(stream, Utilities.pathURL((String[])new String[]{src, "package.tgz"})), "From Package at " + src);
                return null;
            }
            stream = this.fetchFromUrlSpecific(Utilities.pathURL((String[])new String[]{src, "igpack.zip"}), true);
            if (stream != null) {
                return this.readZip(stream);
            }
            stream = this.fetchFromUrlSpecific(Utilities.pathURL((String[])new String[]{src, "validator.pack"}), true);
            if (stream != null) {
                return this.readZip(stream);
            }
            stream = this.fetchFromUrlSpecific(Utilities.pathURL((String[])new String[]{src, "validator.pack"}), true);
        }
        if ((fmt = this.checkIsResource(cnt = stream == null ? this.fetchFromUrlSpecific(src, "application/json", true) : TextFile.streamToBytes(stream), src)) != null) {
            HashMap<String, byte[]> res = new HashMap<String, byte[]>();
            res.put(Utilities.changeFileExt((String)src, (String)("." + fmt.getExtension())), cnt);
            return res;
        }
        throw new FHIRException("Unable to find/resolve/read -ig " + src);
    }

    private InputStream fetchFromUrlSpecific(String source, boolean optional) throws FHIRException, IOException {
        try {
            URL url = new URL(source + "?nocache=" + System.currentTimeMillis());
            URLConnection c = url.openConnection();
            return c.getInputStream();
        }
        catch (IOException e) {
            if (optional) {
                return null;
            }
            throw e;
        }
    }

    private byte[] fetchFromUrlSpecific(String source, String contentType, boolean optional) throws FHIRException, IOException {
        try {
            URL url = new URL(source + "?nocache=" + System.currentTimeMillis());
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestProperty("Accept", contentType);
            return TextFile.streamToBytes((InputStream)conn.getInputStream());
        }
        catch (IOException e) {
            if (optional) {
                return null;
            }
            throw e;
        }
    }

    private Map<String, byte[]> scanDirectory(File f, boolean recursive) throws FileNotFoundException, IOException {
        HashMap<String, byte[]> res = new HashMap<String, byte[]>();
        for (File ff : f.listFiles()) {
            Manager.FhirFormat fmt;
            if (ff.isDirectory() && recursive) {
                res.putAll(this.scanDirectory(ff, true));
                continue;
            }
            if (this.isIgnoreFile(ff) || (fmt = this.checkIsResource(ff.getAbsolutePath())) == null) continue;
            res.put(Utilities.changeFileExt((String)ff.getName(), (String)("." + fmt.getExtension())), TextFile.fileToBytes((String)ff.getAbsolutePath()));
        }
        return res;
    }

    private boolean isIgnoreFile(File ff) {
        if (ff.getName().startsWith(".") || ff.getAbsolutePath().contains(".git")) {
            return true;
        }
        return Utilities.existsInList((String)Utilities.getFileExtension((String)ff.getName()).toLowerCase(), (String[])new String[]{"md", "css", "js", "png", "gif", "jpg", "html", "tgz", "pack", "zip"});
    }

    private Map<String, byte[]> loadPackage(InputStream stream, String name) throws FHIRException, IOException {
        return this.loadPackage(NpmPackage.fromPackage((InputStream)stream));
    }

    private String loadPackageForVersion(InputStream stream, String name) throws FHIRException, IOException {
        return NpmPackage.fromPackage((InputStream)stream).fhirVersion();
    }

    public Map<String, byte[]> loadPackage(NpmPackage pi) throws FHIRException, IOException {
        this.context.getLoadedPackages().add(pi.name() + "#" + pi.version());
        HashMap<String, byte[]> res = new HashMap<String, byte[]>();
        for (String s : pi.dependencies()) {
            if (this.context.getLoadedPackages().contains(s) || VersionUtilities.isCorePackage((String)s)) continue;
            System.out.println("+  .. load IG from " + s);
            res.putAll(this.fetchByPackage(s));
        }
        for (String s : pi.listResources(new String[]{"CodeSystem", "ConceptMap", "ImplementationGuide", "CapabilityStatement", "SearchParameter", "Conformance", "StructureMap", "ValueSet", "StructureDefinition"})) {
            res.put(s, TextFile.streamToBytes((InputStream)pi.load("package", s)));
        }
        String ini = "[FHIR]\r\nversion=" + pi.fhirVersion() + "\r\n";
        res.put("version.info", ini.getBytes());
        return res;
    }

    private Map<String, byte[]> readZip(InputStream stream) throws IOException {
        ZipEntry ze;
        HashMap<String, byte[]> res = new HashMap<String, byte[]>();
        ZipInputStream zip = new ZipInputStream(stream);
        while ((ze = zip.getNextEntry()) != null) {
            int n;
            String name = ze.getName();
            ZipInputStream in = zip;
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((n = ((InputStream)in).read(buf, 0, 1024)) > -1) {
                b.write(buf, 0, n);
            }
            res.put(name, b.toByteArray());
            zip.closeEntry();
        }
        zip.close();
        return res;
    }

    public void log(String message) {
        System.out.println(message);
    }

    private Map<String, byte[]> fetchByPackage(String src) throws FHIRException, IOException {
        String id = src;
        String version = null;
        if (src.contains("#")) {
            id = src.substring(0, src.indexOf("#"));
            version = src.substring(src.indexOf("#") + 1);
        }
        if (this.pcm == null) {
            this.log("Creating Package manager?");
            this.pcm = new FilesystemPackageCacheManager(true, 3);
        }
        if (version == null) {
            version = this.pcm.getLatestVersion(id);
        }
        NpmPackage pi = null;
        if (version == null) {
            pi = this.pcm.loadPackageFromCacheOnly(id);
            if (pi != null) {
                this.log("   ... Using version " + pi.version());
            }
        } else {
            pi = this.pcm.loadPackageFromCacheOnly(id, version);
        }
        if (pi == null) {
            return this.resolvePackage(id, version);
        }
        return this.loadPackage(pi);
    }

    private String fetchVersionByPackage(String src) throws FHIRException, IOException {
        String id = src;
        String version = null;
        if (src.contains("#")) {
            id = src.substring(0, src.indexOf("#"));
            version = src.substring(src.indexOf("#") + 1);
        }
        if (this.pcm == null) {
            this.log("Creating Package manager?");
            this.pcm = new FilesystemPackageCacheManager(true, 3);
        }
        if (version == null) {
            version = this.pcm.getLatestVersion(id);
        }
        NpmPackage pi = null;
        if (version == null) {
            pi = this.pcm.loadPackageFromCacheOnly(id);
            if (pi != null) {
                this.log("   ... Using version " + pi.version());
            }
        } else {
            pi = this.pcm.loadPackageFromCacheOnly(id, version);
        }
        if (pi == null) {
            return this.resolvePackageForVersion(id, version);
        }
        return pi.fhirVersion();
    }

    private Map<String, byte[]> resolvePackage(String id, String v) throws FHIRException, IOException {
        NpmPackage pi = this.pcm.loadPackage(id, v);
        if (pi != null && v == null) {
            this.log("   ... Using version " + pi.version());
        }
        return this.loadPackage(pi);
    }

    private String resolvePackageForVersion(String id, String v) throws FHIRException, IOException {
        NpmPackage pi = this.pcm.loadPackage(id, v);
        return pi.fhirVersion();
    }

    public SimpleWorkerContext getContext() {
        return this.context;
    }

    public boolean isNoInvariantChecks() {
        return this.noInvariantChecks;
    }

    public void setNoInvariantChecks(boolean value) {
        this.noInvariantChecks = value;
    }

    private Manager.FhirFormat checkIsResource(byte[] cnt, String filename) {
        System.out.println("   ..Detect format for " + filename);
        try {
            Manager.parse((IWorkerContext)this.context, (InputStream)new ByteArrayInputStream(cnt), (Manager.FhirFormat)Manager.FhirFormat.JSON);
            return Manager.FhirFormat.JSON;
        }
        catch (Exception exception) {
            try {
                Manager.parse((IWorkerContext)this.context, (InputStream)new ByteArrayInputStream(cnt), (Manager.FhirFormat)Manager.FhirFormat.XML);
                return Manager.FhirFormat.XML;
            }
            catch (Exception exception2) {
                try {
                    Manager.parse((IWorkerContext)this.context, (InputStream)new ByteArrayInputStream(cnt), (Manager.FhirFormat)Manager.FhirFormat.TURTLE);
                    return Manager.FhirFormat.TURTLE;
                }
                catch (Exception exception3) {
                    try {
                        new org.hl7.fhir.r5.utils.StructureMapUtilities((IWorkerContext)this.context, null, null).parse(TextFile.bytesToString((byte[])cnt), null);
                        return Manager.FhirFormat.TEXT;
                    }
                    catch (Exception exception4) {
                        if (this.debug) {
                            System.out.println("     .. not a resource: " + filename);
                        }
                        return null;
                    }
                }
            }
        }
    }

    private Manager.FhirFormat checkIsResource(String path) throws IOException {
        String ext = Utilities.getFileExtension((String)path);
        if (Utilities.existsInList((String)ext, (String[])new String[]{"xml"})) {
            return Manager.FhirFormat.XML;
        }
        if (Utilities.existsInList((String)ext, (String[])new String[]{"json"})) {
            return Manager.FhirFormat.JSON;
        }
        if (Utilities.existsInList((String)ext, (String[])new String[]{"ttl"})) {
            return Manager.FhirFormat.TURTLE;
        }
        if (Utilities.existsInList((String)ext, (String[])new String[]{"map"})) {
            return Manager.FhirFormat.TEXT;
        }
        if (Utilities.existsInList((String)ext, (String[])new String[]{"txt"})) {
            return Manager.FhirFormat.TEXT;
        }
        return this.checkIsResource(TextFile.fileToBytes((String)path), path);
    }

    public void connectToTSServer(String url, String log, FhirPublication version) throws URISyntaxException, FHIRException {
        this.context.setTlogging(false);
        if (url == null) {
            this.context.setCanRunWithoutTerminology(true);
        } else {
            try {
                this.context.connectToTSServer(TerminologyClientFactory.makeClient((String)url, (FhirPublication)version), log);
            }
            catch (Exception e) {
                if (this.context.isCanRunWithoutTerminology()) {
                    System.out.println("Running without Terminology Server (error: " + e.getMessage() + ")");
                }
                throw e;
            }
        }
    }

    public void loadProfile(String src) throws FHIRException, IOException {
        if (this.context.hasResource(StructureDefinition.class, src)) {
            return;
        }
        if (this.context.hasResource(ImplementationGuide.class, src)) {
            return;
        }
        byte[] source = this.loadProfileSource(src);
        Manager.FhirFormat fmt = FormatUtilities.determineFormat((byte[])source);
        Resource r = FormatUtilities.makeParser((Manager.FhirFormat)fmt).parse(source);
        this.context.cacheResource(r);
    }

    public void scanForIgVersion(String src, boolean recursive, VersionSourceInformation versions) throws IOException, FHIRException, Exception {
        Map<String, byte[]> source = this.loadIgSourceForVersion(src, recursive, true, versions);
        if (source != null && source.containsKey("version.info")) {
            versions.see(this.readInfoVersion(source.get("version.info")), "version.info in " + src);
        }
    }

    @Override
    public void loadIg(String src, boolean recursive) throws IOException, FHIRException {
        NpmPackage npm;
        NpmPackage npmPackage = npm = src.matches("^[a-z][a-z0-9\\_\\-]*(\\.[a-z0-9\\_\\-]+)+(\\#[a-z0-9\\-\\_]+(\\.[a-z0-9\\-\\_]+)*)$") ? this.pcm.loadPackage(src, null) : null;
        if (npm != null) {
            for (String s : npm.dependencies()) {
                if (this.context.getLoadedPackages().contains(s) || VersionUtilities.isCorePackage((String)s)) continue;
                this.loadIg(s, false);
            }
            this.context.loadFromPackage(npm, this.loaderForVersion(npm.fhirVersion()));
        } else {
            String canonical = null;
            Map<String, byte[]> source = this.loadIgSource(src, recursive, true);
            String version = "4.5.0";
            if (this.version != null) {
                version = this.version;
            }
            if (source.containsKey("version.info")) {
                version = this.readInfoVersion(source.get("version.info"));
            }
            for (Map.Entry<String, byte[]> t : source.entrySet()) {
                Resource r;
                String fn = t.getKey();
                if (this.exemptFile(fn) || (r = this.loadFileWithErrorChecking(version, t, fn)) == null) continue;
                this.context.cacheResource(r);
                if (!(r instanceof ImplementationGuide)) continue;
                canonical = ((ImplementationGuide)r).getUrl();
                this.igs.add((ImplementationGuide)r);
                if (!canonical.contains("/ImplementationGuide/")) continue;
                Resource r2 = r.copy();
                ((ImplementationGuide)r2).setUrl(canonical.substring(0, canonical.indexOf("/ImplementationGuide/")));
                this.context.cacheResource(r2);
            }
            if (canonical != null) {
                this.grabNatives(source, canonical);
            }
        }
    }

    public Resource loadFileWithErrorChecking(String version, Map.Entry<String, byte[]> t, String fn) {
        Resource r;
        block5: {
            if (this.debug) {
                System.out.print("* load file: " + fn);
            }
            r = null;
            try {
                r = this.loadResourceByVersion(version, t.getValue(), fn);
                if (this.debug) {
                    System.out.println(" .. success");
                }
            }
            catch (Exception e) {
                if (!this.debug) {
                    System.out.print("* load file: " + fn);
                }
                System.out.println(" - ignored due to error: " + (e.getMessage() == null ? " (null - NPE)" : e.getMessage()));
                if (!this.debug && (e.getMessage() == null || !e.getMessage().contains("cannot be cast"))) break block5;
                e.printStackTrace();
            }
        }
        return r;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Resource loadResourceByVersion(String version, byte[] content, String fn) throws IOException, FHIRException {
        if (version.startsWith("3.0")) {
            org.hl7.fhir.dstu3.model.Resource res;
            if (fn.endsWith(".xml") && !fn.endsWith("template.xml")) {
                res = new org.hl7.fhir.dstu3.formats.XmlParser().parse((InputStream)new ByteArrayInputStream(content));
                return VersionConvertor_30_50.convertResource((org.hl7.fhir.dstu3.model.Resource)res, (boolean)false);
            } else if (fn.endsWith(".json") && !fn.endsWith("template.json")) {
                res = new org.hl7.fhir.dstu3.formats.JsonParser().parse((InputStream)new ByteArrayInputStream(content));
                return VersionConvertor_30_50.convertResource((org.hl7.fhir.dstu3.model.Resource)res, (boolean)false);
            } else {
                if (!fn.endsWith(".txt")) {
                    if (!fn.endsWith(".map")) throw new FHIRException("Unsupported format for " + fn);
                }
                res = new org.hl7.fhir.dstu3.utils.StructureMapUtilities(null).parse(new String(content));
            }
            return VersionConvertor_30_50.convertResource((org.hl7.fhir.dstu3.model.Resource)res, (boolean)false);
        }
        if (version.startsWith("4.0")) {
            org.hl7.fhir.r4.model.Resource res;
            if (fn.endsWith(".xml") && !fn.endsWith("template.xml")) {
                res = new XmlParser().parse((InputStream)new ByteArrayInputStream(content));
                return VersionConvertor_40_50.convertResource((org.hl7.fhir.r4.model.Resource)res);
            } else if (fn.endsWith(".json") && !fn.endsWith("template.json")) {
                res = new org.hl7.fhir.r4.formats.JsonParser().parse((InputStream)new ByteArrayInputStream(content));
                return VersionConvertor_40_50.convertResource((org.hl7.fhir.r4.model.Resource)res);
            } else {
                if (!fn.endsWith(".txt")) {
                    if (!fn.endsWith(".map")) throw new FHIRException("Unsupported format for " + fn);
                }
                res = new StructureMapUtilities(null).parse(new String(content), fn);
            }
            return VersionConvertor_40_50.convertResource((org.hl7.fhir.r4.model.Resource)res);
        }
        if (version.startsWith("1.4")) {
            org.hl7.fhir.dstu2016may.model.Resource res;
            if (fn.endsWith(".xml") && !fn.endsWith("template.xml")) {
                res = new org.hl7.fhir.dstu2016may.formats.XmlParser().parse((InputStream)new ByteArrayInputStream(content));
                return VersionConvertor_14_50.convertResource((org.hl7.fhir.dstu2016may.model.Resource)res);
            } else {
                if (!fn.endsWith(".json")) throw new FHIRException("Unsupported format for " + fn);
                if (fn.endsWith("template.json")) throw new FHIRException("Unsupported format for " + fn);
                res = new JsonParser().parse((InputStream)new ByteArrayInputStream(content));
            }
            return VersionConvertor_14_50.convertResource((org.hl7.fhir.dstu2016may.model.Resource)res);
        }
        if (version.startsWith("1.0")) {
            org.hl7.fhir.dstu2.model.Resource res;
            if (fn.endsWith(".xml") && !fn.endsWith("template.xml")) {
                res = new org.hl7.fhir.dstu2.formats.JsonParser().parse((InputStream)new ByteArrayInputStream(content));
            } else {
                if (!fn.endsWith(".json")) throw new FHIRException("Unsupported format for " + fn);
                if (fn.endsWith("template.json")) throw new FHIRException("Unsupported format for " + fn);
                res = new org.hl7.fhir.dstu2.formats.JsonParser().parse((InputStream)new ByteArrayInputStream(content));
            }
            IGR2ConvertorAdvisor5 advisor = new IGR2ConvertorAdvisor5();
            return VersionConvertor_10_50.convertResource((org.hl7.fhir.dstu2.model.Resource)res, (VersionConvertorAdvisor50)advisor);
        }
        if (!version.equals("4.5.0")) {
            if (!"current".equals(version)) throw new FHIRException("Unsupported version " + version);
        }
        if (fn.endsWith(".xml") && !fn.endsWith("template.xml")) {
            return new org.hl7.fhir.r5.formats.XmlParser().parse((InputStream)new ByteArrayInputStream(content));
        }
        if (fn.endsWith(".json") && !fn.endsWith("template.json")) {
            return new org.hl7.fhir.r5.formats.JsonParser().parse((InputStream)new ByteArrayInputStream(content));
        }
        if (fn.endsWith(".txt")) {
            return new org.hl7.fhir.r5.utils.StructureMapUtilities((IWorkerContext)this.context, null, null).parse(TextFile.bytesToString((byte[])content), fn);
        }
        if (fn.endsWith(".txt")) return new org.hl7.fhir.r5.utils.StructureMapUtilities(null).parse(new String(content), fn);
        if (!fn.endsWith(".map")) throw new FHIRException("Unsupported format for " + fn);
        return new org.hl7.fhir.r5.utils.StructureMapUtilities(null).parse(new String(content), fn);
    }

    private boolean exemptFile(String fn) {
        return Utilities.existsInList((String)fn, (String[])new String[]{"spec.internals", "version.info", "schematron.zip", "package.json"});
    }

    private String readInfoVersion(byte[] bs) throws IOException {
        String is = TextFile.bytesToString((byte[])bs);
        is = is.trim();
        IniFile ini = new IniFile((InputStream)new ByteArrayInputStream(TextFile.stringToBytes((String)is, (boolean)false)));
        return ini.getStringProperty("FHIR", "version");
    }

    private void grabNatives(Map<String, byte[]> source, String prefix) {
        for (Map.Entry<String, byte[]> e : source.entrySet()) {
            if (!e.getKey().endsWith(".zip")) continue;
            this.binaries.put(prefix + "#" + e.getKey(), e.getValue());
        }
    }

    public void setQuestionnaires(List<String> questionnaires) {
    }

    public void setNative(boolean doNative) {
        this.doNative = doNative;
    }

    public Content loadContent(String source, String opName) throws FHIRException, IOException {
        Map<String, byte[]> s = this.loadIgSource(source, false, false);
        Content res = new Content();
        if (s.size() != 1) {
            throw new FHIRException("Unable to find resource " + source + " to " + opName);
        }
        for (Map.Entry<String, byte[]> t : s.entrySet()) {
            res.focus = t.getValue();
            if (t.getKey().endsWith(".json")) {
                res.cntType = Manager.FhirFormat.JSON;
                continue;
            }
            if (t.getKey().endsWith(".xml")) {
                res.cntType = Manager.FhirFormat.XML;
                continue;
            }
            if (t.getKey().endsWith(".ttl")) {
                res.cntType = Manager.FhirFormat.TURTLE;
                continue;
            }
            if (t.getKey().endsWith(".txt") || t.getKey().endsWith(".map")) {
                res.cntType = Manager.FhirFormat.TEXT;
                continue;
            }
            throw new FHIRException("Todo: Determining resource type is not yet done");
        }
        return res;
    }

    public OperationOutcome validate(Manager.FhirFormat format, InputStream stream, List<String> profiles) throws FHIRException, IOException, EOperationOutcome {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        InstanceValidator validator = this.getValidator();
        validator.validate(null, messages, stream, format, this.asSdList(profiles));
        return this.messagesToOutcome(messages);
    }

    public List<StructureDefinition> asSdList(List<String> profiles) throws Error {
        ArrayList<StructureDefinition> list = new ArrayList<StructureDefinition>();
        if (profiles != null) {
            for (String p : profiles) {
                StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, p);
                if (sd == null) {
                    throw new Error("Unable to resolve profile " + p);
                }
                list.add(sd);
            }
        }
        return list;
    }

    public OperationOutcome validate(String source, List<String> profiles) throws FHIRException, IOException {
        ArrayList<String> l = new ArrayList<String>();
        l.add(source);
        return (OperationOutcome)this.validate(l, profiles);
    }

    public List<ScanOutputItem> validateScan(List<String> sources, Set<String> guides) throws FHIRException, IOException, EOperationOutcome {
        ArrayList<String> refs = new ArrayList<String>();
        this.handleSources(sources, refs);
        ArrayList<ScanOutputItem> res = new ArrayList<ScanOutputItem>();
        InstanceValidator validator = this.getValidator();
        for (String ref : refs) {
            Content cnt = this.loadContent(ref, "validate");
            ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
            org.hl7.fhir.r5.elementmodel.Element e = null;
            try {
                System.out.println("Validate " + ref);
                messages.clear();
                e = validator.validate(null, messages, new ByteArrayInputStream(cnt.focus), cnt.cntType);
                res.add(new ScanOutputItem(ref, null, null, this.messagesToOutcome(messages)));
            }
            catch (Exception ex) {
                res.add(new ScanOutputItem(ref, null, null, this.exceptionToOutcome(ex)));
            }
            if (e == null) continue;
            String rt = e.fhirType();
            for (String u : guides) {
                ImplementationGuide ig = (ImplementationGuide)this.context.fetchResource(ImplementationGuide.class, u);
                System.out.println("Check Guide " + ig.getUrl());
                String canonical = ig.getUrl().contains("/Impl") ? ig.getUrl().substring(0, ig.getUrl().indexOf("/Impl")) : ig.getUrl();
                String url = this.getGlobal(ig, rt);
                if (url != null) {
                    try {
                        System.out.println("Validate " + ref + " against " + ig.getUrl());
                        messages.clear();
                        validator.validate(null, messages, (InputStream)new ByteArrayInputStream(cnt.focus), cnt.cntType, url);
                        res.add(new ScanOutputItem(ref, ig, null, this.messagesToOutcome(messages)));
                    }
                    catch (Exception ex) {
                        res.add(new ScanOutputItem(ref, ig, null, this.exceptionToOutcome(ex)));
                    }
                }
                HashSet<String> done = new HashSet<String>();
                for (StructureDefinition sd : this.context.allStructures()) {
                    if (done.contains(sd.getUrl())) continue;
                    done.add(sd.getUrl());
                    if (!sd.getUrl().startsWith(canonical) || !rt.equals(sd.getType())) continue;
                    try {
                        System.out.println("Validate " + ref + " against " + sd.getUrl());
                        messages.clear();
                        validator.validate(null, messages, (InputStream)new ByteArrayInputStream(cnt.focus), cnt.cntType, this.asSdList(sd));
                        res.add(new ScanOutputItem(ref, ig, sd, this.messagesToOutcome(messages)));
                    }
                    catch (Exception ex) {
                        res.add(new ScanOutputItem(ref, ig, sd, this.exceptionToOutcome(ex)));
                    }
                }
            }
        }
        return res;
    }

    private List<StructureDefinition> asSdList(StructureDefinition sd) {
        ArrayList<StructureDefinition> res = new ArrayList<StructureDefinition>();
        res.add(sd);
        return res;
    }

    private Resource resolve(Reference reference) {
        return null;
    }

    private String getGlobal(ImplementationGuide ig, String rt) {
        for (ImplementationGuide.ImplementationGuideGlobalComponent igg : ig.getGlobal()) {
            if (!rt.equals(igg.getType())) continue;
            return igg.getProfile();
        }
        return null;
    }

    public void scanForVersions(List<String> sources, VersionSourceInformation versions) throws FHIRException, IOException {
        ArrayList<String> refs = new ArrayList<String>();
        this.handleSources(sources, refs);
        for (String ref : refs) {
            Content cnt = this.loadContent(ref, "validate");
            String s = TextFile.bytesToString((byte[])cnt.focus);
            if (s.contains("http://hl7.org/fhir/3.0")) {
                versions.see("3.0", "Profile in " + ref);
            }
            if (s.contains("http://hl7.org/fhir/1.0")) {
                versions.see("1.0", "Profile in " + ref);
            }
            if (s.contains("http://hl7.org/fhir/4.0")) {
                versions.see("4.0", "Profile in " + ref);
            }
            if (!s.contains("http://hl7.org/fhir/1.4")) continue;
            versions.see("1.4", "Profile in " + ref);
        }
    }

    public Resource validate(List<String> sources, List<String> profiles) throws FHIRException, IOException {
        ArrayList<String> refs = new ArrayList<String>();
        boolean asBundle = this.handleSources(sources, refs);
        Bundle results = new Bundle();
        results.setType(Bundle.BundleType.COLLECTION);
        for (String ref : refs) {
            Content cnt = this.loadContent(ref, "validate");
            if (refs.size() > 1) {
                System.out.println("Validate " + ref);
            }
            try {
                OperationOutcome outcome = this.validate(ref, cnt.focus, cnt.cntType, profiles);
                ToolingExtensions.addStringExtension((DomainResource)outcome, (String)"http://hl7.org/fhir/StructureDefinition/operationoutcome-file", (String)ref);
                if (refs.size() > 1) {
                    this.produceValidationSummary(outcome);
                }
                results.addEntry().setResource((Resource)outcome);
            }
            catch (Exception e) {
                System.out.println("Validation Infrastructure fail validating " + ref + ": " + e.getMessage());
                throw new FHIRException((Throwable)e);
            }
        }
        if (asBundle) {
            return results;
        }
        return results.getEntryFirstRep().getResource();
    }

    private void produceValidationSummary(OperationOutcome oo) {
        for (OperationOutcome.OperationOutcomeIssueComponent iss : oo.getIssue()) {
            if (iss.getSeverity() != OperationOutcome.IssueSeverity.ERROR && iss.getSeverity() != OperationOutcome.IssueSeverity.FATAL) continue;
            System.out.println("  " + iss.getSeverity().toCode() + ": " + iss.getDetails().getText());
        }
    }

    public OperationOutcome validateString(String location, String source, Manager.FhirFormat format, List<String> profiles) throws FHIRException, IOException, EOperationOutcome, SAXException {
        return this.validate(location, source.getBytes(), format, profiles);
    }

    public boolean handleSources(List<String> sources, List<String> refs) throws IOException {
        boolean asBundle = sources.size() > 1;
        for (String source : sources) {
            if (!this.handleSource(source, refs)) continue;
            asBundle = true;
        }
        return asBundle;
    }

    private boolean handleSource(String name, List<String> refs) throws IOException {
        boolean isBundle = false;
        if (name.startsWith("https:") || name.startsWith("http:")) {
            refs.add(name);
        } else if (name.contains("*")) {
            isBundle = true;
            AsteriskFilter filter = new AsteriskFilter(name);
            File[] files = new File(filter.getDir()).listFiles(filter);
            for (int i = 0; i < files.length; ++i) {
                refs.add(files[i].getPath());
            }
        } else {
            File file = new File(name);
            if (!file.exists()) {
                if (System.console() != null) {
                    System.console().printf(this.context.formatMessage("Bad_file_path_error", new Object[]{name}), new Object[0]);
                } else {
                    System.out.println(this.context.formatMessage("Bad_file_path_error", new Object[]{name}));
                }
                throw new IOException("File " + name + " does not exist");
            }
            if (file.isFile()) {
                refs.add(name);
            } else {
                isBundle = true;
                for (int i = 0; i < file.listFiles().length; ++i) {
                    File[] fileList = file.listFiles();
                    if (!fileList[i].isFile()) continue;
                    refs.add(fileList[i].getPath());
                }
            }
        }
        return isBundle;
    }

    public OperationOutcome validate(byte[] source, Manager.FhirFormat cntType, List<String> profiles) throws FHIRException, IOException, EOperationOutcome {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        InstanceValidator validator = this.getValidator();
        validator.validate(null, messages, (InputStream)new ByteArrayInputStream(source), cntType, this.asSdList(profiles));
        return this.messagesToOutcome(messages);
    }

    public OperationOutcome validate(String location, byte[] source, Manager.FhirFormat cntType, List<String> profiles) throws FHIRException, IOException, EOperationOutcome, SAXException {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        if (this.doNative) {
            if (cntType == Manager.FhirFormat.JSON) {
                this.validateJsonSchema(location, messages);
            }
            if (cntType == Manager.FhirFormat.XML) {
                this.validateXmlSchema(location, messages);
            }
            if (cntType == Manager.FhirFormat.TURTLE) {
                this.validateSHEX(location, messages);
            }
        }
        InstanceValidator validator = this.getValidator();
        validator.validate(null, messages, (InputStream)new ByteArrayInputStream(source), cntType, this.asSdList(profiles));
        if (this.showTimes) {
            System.out.println(location + ": " + validator.reportTimes());
        }
        return this.messagesToOutcome(messages);
    }

    public OperationOutcome validate(String location, byte[] source, Manager.FhirFormat cntType, List<String> profiles, IResourceValidator.IdStatus resourceIdRule, boolean anyExtensionsAllowed, IResourceValidator.BestPracticeWarningLevel bpWarnings, IResourceValidator.CheckDisplayOption displayOption) throws FHIRException, IOException, EOperationOutcome, SAXException {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        if (this.doNative) {
            if (cntType == Manager.FhirFormat.JSON) {
                this.validateJsonSchema(location, messages);
            }
            if (cntType == Manager.FhirFormat.XML) {
                this.validateXmlSchema(location, messages);
            }
            if (cntType == Manager.FhirFormat.TURTLE) {
                this.validateSHEX(location, messages);
            }
        }
        InstanceValidator validator = this.getValidator();
        validator.setResourceIdRule(resourceIdRule);
        validator.setBestPracticeWarningLevel(bpWarnings);
        validator.setCheckDisplay(displayOption);
        validator.validate(null, messages, (InputStream)new ByteArrayInputStream(source), cntType, this.asSdList(profiles));
        return this.messagesToOutcome(messages);
    }

    private void validateSHEX(String location, List<ValidationMessage> messages) {
        messages.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.INFORMATIONAL, location, "SHEX Validation is not done yet", ValidationMessage.IssueSeverity.INFORMATION));
    }

    private void validateXmlSchema(String location, List<ValidationMessage> messages) throws FileNotFoundException, IOException, SAXException {
        messages.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.INFORMATIONAL, location, "XML Schema Validation is not done yet", ValidationMessage.IssueSeverity.INFORMATION));
    }

    private Map<String, byte[]> loadSchemas() throws IOException {
        HashMap<String, byte[]> res = new HashMap<String, byte[]>();
        for (Map.Entry<String, byte[]> e : this.readZip(new ByteArrayInputStream(this.binaries.get("http://hl7.org/fhir#fhir-all-xsd.zip"))).entrySet()) {
            if (e.getKey().equals("fhir-single.xsd")) {
                res.put(e.getKey(), e.getValue());
            }
            if (!e.getKey().equals("fhir-invariants.sch")) continue;
            res.put(e.getKey(), e.getValue());
        }
        return res;
    }

    private Map<String, byte[]> loadTransforms() throws IOException {
        HashMap<String, byte[]> res = new HashMap<String, byte[]>();
        for (Map.Entry<String, byte[]> e : this.readZip(new ByteArrayInputStream(this.binaries.get("http://hl7.org/fhir#fhir-all-xsd.zip"))).entrySet()) {
            if (!e.getKey().endsWith(".xsl")) continue;
            res.put(e.getKey(), e.getValue());
        }
        return res;
    }

    private void validateJsonSchema(String location, List<ValidationMessage> messages) {
        messages.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.INFORMATIONAL, location, "JSON Schema Validation is not done yet", ValidationMessage.IssueSeverity.INFORMATION));
    }

    private List<ValidationMessage> filterMessages(List<ValidationMessage> messages) {
        ArrayList<ValidationMessage> filteredValidation = new ArrayList<ValidationMessage>();
        for (ValidationMessage e : messages) {
            if (filteredValidation.contains(e)) continue;
            filteredValidation.add(e);
        }
        filteredValidation.sort(null);
        return filteredValidation;
    }

    private OperationOutcome exceptionToOutcome(Exception ex) throws IOException, FHIRException, EOperationOutcome {
        OperationOutcome op = new OperationOutcome();
        op.addIssue().setCode(OperationOutcome.IssueType.EXCEPTION).setSeverity(OperationOutcome.IssueSeverity.FATAL).getDetails().setText(ex.getMessage());
        RenderingContext rc = new RenderingContext((IWorkerContext)this.context, null, null, "http://hl7.org/fhir", "", null, RenderingContext.ResourceRendererMode.RESOURCE);
        RendererFactory.factory((Resource)op, (RenderingContext)rc).render((DomainResource)op);
        return op;
    }

    private OperationOutcome messagesToOutcome(List<ValidationMessage> messages) throws IOException, FHIRException, EOperationOutcome {
        OperationOutcome op = new OperationOutcome();
        for (ValidationMessage vm : this.filterMessages(messages)) {
            FHIRPathEngine fpe = new FHIRPathEngine((IWorkerContext)this.context);
            try {
                fpe.parse(vm.getLocation());
            }
            catch (Exception e) {
                System.out.println("Internal error in location for message: '" + e.getMessage() + "', loc = '" + vm.getLocation() + "', err = '" + vm.getMessage() + "'");
            }
            op.getIssue().add(OperationOutcomeUtilities.convertToIssue((ValidationMessage)vm, (OperationOutcome)op));
        }
        if (!op.hasIssue()) {
            op.addIssue().setSeverity(OperationOutcome.IssueSeverity.INFORMATION).setCode(OperationOutcome.IssueType.INFORMATIONAL).getDetails().setText(this.context.formatMessage("ALL_OK", new Object[0]));
        }
        RenderingContext rc = new RenderingContext((IWorkerContext)this.context, null, null, "http://hl7.org/fhir", "", null, RenderingContext.ResourceRendererMode.RESOURCE);
        RendererFactory.factory((Resource)op, (RenderingContext)rc).render((DomainResource)op);
        return op;
    }

    public static String issueSummary(OperationOutcome.OperationOutcomeIssueComponent issue) {
        String source = ToolingExtensions.readStringExtension((Element)issue, (String)"http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-source");
        return issue.getSeverity().toString() + " @ " + issue.getLocation() + " " + issue.getDetails().getText() + (source != null ? " (src = " + source + ")" : "");
    }

    public org.hl7.fhir.r5.elementmodel.Element transform(String source, String map) throws FHIRException, IOException {
        Content cnt = this.loadContent(source, "validate");
        return this.transform(cnt.focus, cnt.cntType, map);
    }

    public org.hl7.fhir.r5.elementmodel.Element transform(byte[] source, Manager.FhirFormat cntType, String mapUri) throws FHIRException, IOException {
        ArrayList<Base> outputs = new ArrayList<Base>();
        org.hl7.fhir.r5.utils.StructureMapUtilities scu = new org.hl7.fhir.r5.utils.StructureMapUtilities((IWorkerContext)this.context, (StructureMapUtilities.ITransformerServices)new TransformSupportServices(outputs));
        org.hl7.fhir.r5.elementmodel.Element src = Manager.parse((IWorkerContext)this.context, (InputStream)new ByteArrayInputStream(source), (Manager.FhirFormat)cntType);
        StructureMap map = this.context.getTransform(mapUri);
        if (map == null) {
            throw new Error("Unable to find map " + mapUri + " (Known Maps = " + this.context.listMapUrls() + ")");
        }
        org.hl7.fhir.r5.elementmodel.Element resource = this.getTargetResourceFromStructureMap(map);
        scu.transform(null, (Base)src, map, (Base)resource);
        return resource;
    }

    private org.hl7.fhir.r5.elementmodel.Element getTargetResourceFromStructureMap(StructureMap map) {
        String targetTypeUrl = null;
        for (StructureMap.StructureMapStructureComponent component : map.getStructure()) {
            if (component.getMode() != StructureMap.StructureMapModelMode.TARGET) continue;
            targetTypeUrl = component.getUrl();
            break;
        }
        if (targetTypeUrl == null) {
            throw new FHIRException("Unable to determine resource URL for target type");
        }
        StructureDefinition structureDefinition = null;
        for (StructureDefinition sd : this.context.getStructures()) {
            if (!sd.getUrl().equalsIgnoreCase(targetTypeUrl)) continue;
            structureDefinition = sd;
            break;
        }
        if (structureDefinition == null) {
            throw new FHIRException("Unable to find StructureDefinition for target type ('" + targetTypeUrl + "')");
        }
        return Manager.build((IWorkerContext)this.getContext(), structureDefinition);
    }

    public DomainResource generate(String source, String version) throws FHIRException, IOException, EOperationOutcome {
        Content cnt = this.loadContent(source, "validate");
        Resource res = this.loadResourceByVersion(version, cnt.focus, source);
        RenderingContext rc = new RenderingContext((IWorkerContext)this.context, null, null, "http://hl7.org/fhir", "", null, RenderingContext.ResourceRendererMode.RESOURCE);
        RendererFactory.factory((Resource)res, (RenderingContext)rc).render((DomainResource)res);
        return (DomainResource)res;
    }

    public void convert(String source, String output) throws FHIRException, IOException {
        Content cnt = this.loadContent(source, "validate");
        org.hl7.fhir.r5.elementmodel.Element e = Manager.parse((IWorkerContext)this.context, (InputStream)new ByteArrayInputStream(cnt.focus), (Manager.FhirFormat)cnt.cntType);
        Manager.compose((IWorkerContext)this.context, (org.hl7.fhir.r5.elementmodel.Element)e, (OutputStream)new FileOutputStream(output), (Manager.FhirFormat)(output.endsWith(".json") ? Manager.FhirFormat.JSON : Manager.FhirFormat.XML), (IParser.OutputStyle)IParser.OutputStyle.PRETTY, null);
    }

    public String evaluateFhirPath(String source, String expression) throws FHIRException, IOException {
        Content cnt = this.loadContent(source, "validate");
        FHIRPathEngine fpe = new FHIRPathEngine((IWorkerContext)this.context);
        org.hl7.fhir.r5.elementmodel.Element e = Manager.parse((IWorkerContext)this.context, (InputStream)new ByteArrayInputStream(cnt.focus), (Manager.FhirFormat)cnt.cntType);
        return fpe.evaluateToString((Base)e, expression);
    }

    public StructureDefinition snapshot(String source, String version) throws FHIRException, IOException {
        Content cnt = this.loadContent(source, "validate");
        Resource res = this.loadResourceByVersion(version, cnt.focus, Utilities.getFileNameForName((String)source));
        if (!(res instanceof StructureDefinition)) {
            throw new FHIRException("Require a StructureDefinition for generating a snapshot");
        }
        StructureDefinition sd = (StructureDefinition)res;
        StructureDefinition base = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition());
        new ProfileUtilities((IWorkerContext)this.context, null, null).setAutoFixSliceNames(true).generateSnapshot(base, sd, sd.getUrl(), null, sd.getName());
        return sd;
    }

    public void seeResource(Resource r) throws FHIRException {
        this.context.cacheResource(r);
    }

    public void dropResource(String type, String id) {
        this.context.dropResource(type, id);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public InstanceValidator getValidator() {
        InstanceValidator validator = new InstanceValidator((IWorkerContext)this.context, null);
        validator.setHintAboutNonMustSupport(this.hintAboutNonMustSupport);
        validator.setAnyExtensionsAllowed(this.anyExtensionsAllowed);
        validator.setNoInvariantChecks(this.isNoInvariantChecks());
        validator.setValidationLanguage(this.language);
        validator.setAssumeValidRestReferences(this.assumeValidRestReferences);
        validator.setNoExtensibleWarnings(this.noExtensibleBindingMessages);
        validator.setSecurityChecks(this.securityChecks);
        validator.setCrumbTrails(this.crumbTrails);
        validator.getContext().setLocale(this.locale);
        validator.setFetcher(this);
        validator.getImplementationGuides().addAll(this.igs);
        validator.getBundleValidationRules().addAll(this.bundleValidationRules);
        return validator;
    }

    public void setMapLog(String mapLog) throws FileNotFoundException {
        this.mapLog = new PrintWriter(mapLog);
    }

    public void prepare() {
        for (StructureDefinition sd : this.context.allStructures()) {
            try {
                this.makeSnapshot(sd);
            }
            catch (Exception e) {
                System.out.println("Process Note: Unable to generate snapshot for " + sd.present() + ": " + e.getMessage());
                if (!this.debug) continue;
                e.printStackTrace();
            }
        }
    }

    private void makeSnapshot(StructureDefinition sd) throws DefinitionException, FHIRException {
        if (sd.hasSnapshot()) {
            return;
        }
        StructureDefinition sdb = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition());
        if (sdb != null) {
            this.makeSnapshot(sdb);
            new ProfileUtilities((IWorkerContext)this.context, null, null).setAutoFixSliceNames(true).generateSnapshot(sdb, sd, sd.getUrl(), null, sd.getName());
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void genScanOutput(String folder, List<ScanOutputItem> items) throws IOException, FHIRException, EOperationOutcome {
        Object sd;
        Object ig;
        String f = Utilities.path((String[])new String[]{folder, "comparison.zip"});
        this.download("http://fhir.org/archive/comparison.zip", f);
        this.unzip(f, folder);
        for (int i = 0; i < items.size(); ++i) {
            items.get(i).setId("c" + Integer.toString(i));
            this.genScanOutputItem(items.get(i), Utilities.path((String[])new String[]{folder, items.get(i).getId() + ".html"}));
        }
        StringBuilder b = new StringBuilder();
        b.append("<html>");
        b.append("<head>");
        b.append("<title>Implementation Guide Scan</title>");
        b.append("<link rel=\"stylesheet\" href=\"fhir.css\"/>\r\n");
        b.append("<style>\r\n");
        b.append("th \r\n");
        b.append("{\r\n");
        b.append("  vertical-align: bottom;\r\n");
        b.append("  text-align: center;\r\n");
        b.append("}\r\n");
        b.append("\r\n");
        b.append("th span\r\n");
        b.append("{\r\n");
        b.append("  -ms-writing-mode: tb-rl;\r\n");
        b.append("  -webkit-writing-mode: vertical-rl;\r\n");
        b.append("  writing-mode: vertical-rl;\r\n");
        b.append("  transform: rotate(180deg);\r\n");
        b.append("  white-space: nowrap;\r\n");
        b.append("}\r\n");
        b.append("</style>\r\n");
        b.append("</head>");
        b.append("<body>");
        b.append("<h2>Implementation Guide Scan</h2>");
        HashSet<String> refs = new HashSet<String>();
        HashSet<String> igs = new HashSet<String>();
        HashMap profiles = new HashMap();
        for (ScanOutputItem item : items) {
            refs.add(item.ref);
            if (item.ig == null) continue;
            igs.add(item.ig.getUrl());
            if (!profiles.containsKey(item.ig.getUrl())) {
                profiles.put(item.ig.getUrl(), new HashSet());
            }
            if (item.profile == null) continue;
            ((Set)profiles.get(item.ig.getUrl())).add(item.profile.getUrl());
        }
        b.append("<h2>By reference</h2>\r\n");
        b.append("<table class=\"grid\">");
        b.append("<tr><th></th><th></th>");
        for (String s : this.sorted(igs)) {
            ig = (ImplementationGuide)this.context.fetchResource(ImplementationGuide.class, s);
            b.append("<th colspan=\"" + Integer.toString(((Set)profiles.get(s)).size() + 1) + "\"><b title=\"" + s + "\">" + ig.present() + "</b></th>");
        }
        b.append("</tr>\r\n");
        b.append("<tr><th><b>Source</b></th><th><span>Core Spec</span></th>");
        for (String s : this.sorted(igs)) {
            ig = (ImplementationGuide)this.context.fetchResource(ImplementationGuide.class, s);
            b.append("<th><span>Global</span></th>");
            for (String sp : this.sorted((Set)profiles.get(s))) {
                sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, sp);
                b.append("<th><b title=\"" + sp + "\"><span>" + sd.present() + "</span></b></th>");
            }
        }
        b.append("</tr>\r\n");
        for (String s : this.sorted(refs)) {
            b.append("<tr>");
            b.append("<td>" + s + "</td>");
            b.append(this.genOutcome(items, s, null, null));
            for (String si : this.sorted(igs)) {
                ImplementationGuide ig2 = (ImplementationGuide)this.context.fetchResource(ImplementationGuide.class, si);
                b.append(this.genOutcome(items, s, si, null));
                for (String sp : this.sorted((Set)profiles.get(ig2.getUrl()))) {
                    b.append(this.genOutcome(items, s, si, sp));
                }
            }
            b.append("</tr>\r\n");
        }
        b.append("</table>\r\n");
        b.append("<h2>By IG</h2>\r\n");
        b.append("<table class=\"grid\">");
        b.append("<tr><th></th><th></th>");
        for (String s : this.sorted(refs)) {
            b.append("<th><span>" + s + "</span></th>");
        }
        b.append("</tr>\r\n");
        b.append("<tr><td></td><td>Core Spec</td>");
        for (String s : this.sorted(refs)) {
            b.append(this.genOutcome(items, s, null, null));
        }
        b.append("</tr>\r\n");
        for (String si : this.sorted(igs)) {
            b.append("<tr>");
            ig = (ImplementationGuide)this.context.fetchResource(ImplementationGuide.class, si);
            b.append("<td><b title=\"" + si + "\">" + ig.present() + "</b></td>");
            b.append("<td>Global</td>");
            for (String s : this.sorted(refs)) {
                b.append(this.genOutcome(items, s, si, null));
            }
            b.append("</tr>\r\n");
            for (String sp : this.sorted((Set)profiles.get(ig.getUrl()))) {
                b.append("<tr>");
                sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, sp);
                b.append("<td></td><td><b title=\"" + sp + "\">" + sd.present() + "</b></td>");
                for (String s : this.sorted(refs)) {
                    b.append(this.genOutcome(items, s, si, sp));
                }
                b.append("</tr>\r\n");
            }
        }
        b.append("</table>\r\n");
        b.append("</body>");
        b.append("</html>");
        TextFile.stringToFile((String)b.toString(), (String)Utilities.path((String[])new String[]{folder, "scan.html"}));
    }

    private String genOutcome(List<ScanOutputItem> items, String src, String ig, String profile) {
        ScanOutputItem item = null;
        for (ScanOutputItem t : items) {
            boolean match = true;
            if (!t.ref.equals(src)) {
                match = false;
            }
            if (!(ig == null && t.ig == null || ig != null && t.ig != null && ig.equals(t.ig.getUrl()))) {
                match = false;
            }
            if (!(profile == null && t.profile == null || profile != null && t.profile != null && profile.equals(t.profile.getUrl()))) {
                match = false;
            }
            if (!match) continue;
            item = t;
            break;
        }
        if (item == null) {
            return "<td></td>";
        }
        boolean ok = true;
        for (OperationOutcome.OperationOutcomeIssueComponent iss : item.outcome.getIssue()) {
            if (iss.getSeverity() != OperationOutcome.IssueSeverity.ERROR && iss.getSeverity() != OperationOutcome.IssueSeverity.FATAL) continue;
            ok = false;
        }
        if (ok) {
            return "<td style=\"background-color: #e6ffe6\"><a href=\"" + item.getId() + ".html\">\u2714</a></td>";
        }
        return "<td style=\"background-color: #ffe6e6\"><a href=\"" + item.getId() + ".html\">\u2716</a></td>";
    }

    public void unzip(String zipFilePath, String destDirectory) throws IOException {
        File destDir = new File(destDirectory);
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFilePath));
        ZipEntry entry = zipIn.getNextEntry();
        while (entry != null) {
            String filePath = destDirectory + File.separator + entry.getName();
            if (!entry.isDirectory()) {
                this.extractFile(zipIn, filePath);
            } else {
                File dir = new File(filePath);
                dir.mkdir();
            }
            zipIn.closeEntry();
            entry = zipIn.getNextEntry();
        }
        zipIn.close();
    }

    private void extractFile(ZipInputStream zipIn, String filePath) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));
        byte[] bytesIn = new byte[4096];
        int read = 0;
        while ((read = zipIn.read(bytesIn)) != -1) {
            bos.write(bytesIn, 0, read);
        }
        bos.close();
    }

    private void download(String address, String filename) throws IOException {
        URL url = new URL(address);
        URLConnection c = url.openConnection();
        InputStream s = c.getInputStream();
        FileOutputStream f = new FileOutputStream(filename);
        ValidationEngine.transfer(s, f, 1024);
        f.close();
    }

    public static void transfer(InputStream in, OutputStream out, int buffer) throws IOException {
        byte[] read = new byte[buffer];
        while (0 < (buffer = in.read(read))) {
            out.write(read, 0, buffer);
        }
    }

    private void genScanOutputItem(ScanOutputItem item, String filename) throws IOException, FHIRException, EOperationOutcome {
        RenderingContext rc = new RenderingContext((IWorkerContext)this.context, null, null, "http://hl7.org/fhir", "", null, RenderingContext.ResourceRendererMode.RESOURCE);
        rc.setNoSlowLookup(true);
        RendererFactory.factory((Resource)item.outcome, (RenderingContext)rc).render((DomainResource)item.outcome);
        String s = new XhtmlComposer(false).compose(item.outcome.getText().getDiv());
        String title = item.getTitle();
        StringBuilder b = new StringBuilder();
        b.append("<html>");
        b.append("<head>");
        b.append("<title>" + title + "</title>");
        b.append("<link rel=\"stylesheet\" href=\"fhir.css\"/>\r\n");
        b.append("</head>");
        b.append("<body>");
        b.append("<h2>" + title + "</h2>");
        b.append(s);
        b.append("</body>");
        b.append("</html>");
        TextFile.stringToFile((String)b.toString(), (String)filename);
    }

    private List<String> sorted(Set<String> keys) {
        ArrayList<String> names = new ArrayList<String>();
        if (keys != null) {
            names.addAll(keys);
        }
        Collections.sort(names);
        return names;
    }

    public org.hl7.fhir.r5.elementmodel.Element fetch(Object appContext, String url) throws FHIRException, IOException {
        Resource resource = this.context.fetchResource(Resource.class, url);
        if (resource != null) {
            return new ObjectConverter((IWorkerContext)this.context).convert(resource);
        }
        if (this.fetcher != null) {
            return this.fetcher.fetch(appContext, url);
        }
        return null;
    }

    public IResourceValidator.ReferenceValidationPolicy validationPolicy(Object appContext, String path, String url) {
        Resource resource = this.context.fetchResource(StructureDefinition.class, url);
        if (resource != null) {
            return IResourceValidator.ReferenceValidationPolicy.CHECK_VALID;
        }
        if (!url.startsWith("http://hl7.org/fhir")) {
            return IResourceValidator.ReferenceValidationPolicy.IGNORE;
        }
        if (this.fetcher != null) {
            return this.fetcher.validationPolicy(appContext, path, url);
        }
        return IResourceValidator.ReferenceValidationPolicy.CHECK_EXISTS_AND_TYPE;
    }

    public boolean resolveURL(Object appContext, String path, String url) throws IOException, FHIRException {
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            return true;
        }
        if (this.context.fetchResource(Resource.class, url) != null) {
            return true;
        }
        if (Utilities.existsInList((String)url, (String[])new String[]{"http://hl7.org/fhir/sid/us-ssn", "http://hl7.org/fhir/sid/cvx", "http://hl7.org/fhir/sid/ndc", "http://hl7.org/fhir/sid/us-npi", "http://hl7.org/fhir/sid/icd-10", "http://hl7.org/fhir/sid/icd-10-vn", "http://hl7.org/fhir/sid/icd-10-cm", "http://hl7.org/fhir/sid/icd-9-cm", "http://hl7.org/fhir/w5", "http://hl7.org/fhir/fivews", "http://hl7.org/fhir/workflow", "http://hl7.org/fhir/ConsentPolicy/opt-out", "http://hl7.org/fhir/ConsentPolicy/opt-in"})) {
            return true;
        }
        if (Utilities.existsInList((String)url, (String[])new String[]{"http://loinc.org", "http://unitsofmeasure.org", "http://snomed.info/sct"})) {
            return true;
        }
        if (this.fetcher != null) {
            return this.fetcher.resolveURL(appContext, path, url);
        }
        return false;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void handleOutput(Resource r, String output, String version) throws FHIRException, IOException {
        if (output.startsWith("http://") || output.startsWith("http://")) {
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            this.handleOutputToStream(r, output, bs, version);
            URL url = new URL(output);
            HttpURLConnection c = (HttpURLConnection)url.openConnection();
            c.setDoOutput(true);
            c.setDoInput(true);
            c.setRequestMethod("POST");
            c.setRequestProperty("Content-type", "application/fhir+xml");
            c.setRequestProperty("Accept", "application/fhir+xml");
            c.getOutputStream().write(bs.toByteArray());
            c.getOutputStream().close();
            if (c.getResponseCode() >= 300) {
                throw new IOException("Unable to PUT to " + output + ": " + c.getResponseMessage());
            }
        } else {
            FileOutputStream s = new FileOutputStream(output);
            this.handleOutputToStream(r, output, s, version);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleOutputToStream(Resource r, String fn, OutputStream s, String version) throws FHIRException, IOException {
        if (fn.endsWith(".html") || fn.endsWith(".htm") && r instanceof DomainResource) {
            new XhtmlComposer(false, true).compose(s, ((DomainResource)r).getText().getDiv());
        } else if (version.startsWith("3.0")) {
            org.hl7.fhir.dstu3.model.Resource res = VersionConvertor_30_50.convertResource((Resource)r, (boolean)false);
            if (fn.endsWith(".xml") && !fn.endsWith("template.xml")) {
                new org.hl7.fhir.dstu3.formats.XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(s, res);
            } else if (fn.endsWith(".json") && !fn.endsWith("template.json")) {
                new org.hl7.fhir.dstu3.formats.JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(s, res);
            } else {
                if (!fn.endsWith(".txt") && !fn.endsWith(".map")) throw new FHIRException("Unsupported format for " + fn);
                TextFile.stringToStream((String)org.hl7.fhir.dstu3.utils.StructureMapUtilities.render((org.hl7.fhir.dstu3.model.StructureMap)((org.hl7.fhir.dstu3.model.StructureMap)res)), (OutputStream)s, (boolean)false);
            }
        } else if (version.startsWith("4.0")) {
            org.hl7.fhir.r4.model.Resource res = VersionConvertor_40_50.convertResource((Resource)r);
            if (fn.endsWith(".xml") && !fn.endsWith("template.xml")) {
                new XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(s, res);
            } else if (fn.endsWith(".json") && !fn.endsWith("template.json")) {
                new org.hl7.fhir.r4.formats.JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(s, res);
            } else {
                if (!fn.endsWith(".txt") && !fn.endsWith(".map")) throw new FHIRException("Unsupported format for " + fn);
                TextFile.stringToStream((String)StructureMapUtilities.render((org.hl7.fhir.r4.model.StructureMap)((org.hl7.fhir.r4.model.StructureMap)res)), (OutputStream)s, (boolean)false);
            }
        } else if (version.startsWith("1.4")) {
            org.hl7.fhir.dstu2016may.model.Resource res = VersionConvertor_14_50.convertResource((Resource)r);
            if (fn.endsWith(".xml") && !fn.endsWith("template.xml")) {
                new org.hl7.fhir.dstu2016may.formats.XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(s, res);
            } else {
                if (!fn.endsWith(".json") || fn.endsWith("template.json")) throw new FHIRException("Unsupported format for " + fn);
                new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(s, res);
            }
        } else if (version.startsWith("1.0")) {
            IGR2ConvertorAdvisor5 advisor = new IGR2ConvertorAdvisor5();
            org.hl7.fhir.dstu2.model.Resource res = VersionConvertor_10_50.convertResource((Resource)r, (VersionConvertorAdvisor50)advisor);
            if (fn.endsWith(".xml") && !fn.endsWith("template.xml")) {
                new org.hl7.fhir.dstu2.formats.JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(s, res);
            } else {
                if (!fn.endsWith(".json") || fn.endsWith("template.json")) throw new FHIRException("Unsupported format for " + fn);
                new org.hl7.fhir.dstu2.formats.JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(s, res);
            }
        } else {
            if (!version.equals("4.5.0")) throw new FHIRException("Encounted unsupported configured version " + version + " loading " + fn);
            if (fn.endsWith(".xml") && !fn.endsWith("template.xml")) {
                new org.hl7.fhir.r5.formats.XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(s, r);
            } else if (fn.endsWith(".json") && !fn.endsWith("template.json")) {
                new org.hl7.fhir.r5.formats.JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(s, r);
            } else {
                if (!fn.endsWith(".txt") && !fn.endsWith(".map")) throw new FHIRException("Unsupported format for " + fn);
                TextFile.stringToStream((String)org.hl7.fhir.r5.utils.StructureMapUtilities.render((StructureMap)((StructureMap)r)), (OutputStream)s, (boolean)false);
            }
        }
        s.close();
    }

    public void setSnomedExtension(String sct) {
        this.context.getExpansionParameters().addParameter("system-version", "http://snomed.info/sct|http://snomed.info/sct/" + sct);
    }

    public IResourceValidator.IValidatorResourceFetcher getFetcher() {
        return this.fetcher;
    }

    public void setFetcher(IResourceValidator.IValidatorResourceFetcher fetcher) {
        this.fetcher = fetcher;
    }

    public void setAssumeValidRestReferences(boolean assumeValidRestReferences) {
        this.assumeValidRestReferences = assumeValidRestReferences;
    }

    public boolean isNoExtensibleBindingMessages() {
        return this.noExtensibleBindingMessages;
    }

    public void setNoExtensibleBindingMessages(boolean noExtensibleBindingMessages) {
        this.noExtensibleBindingMessages = noExtensibleBindingMessages;
    }

    public boolean isSecurityChecks() {
        return this.securityChecks;
    }

    public void setSecurityChecks(boolean securityChecks) {
        this.securityChecks = securityChecks;
    }

    public boolean isCrumbTrails() {
        return this.crumbTrails;
    }

    public void setCrumbTrails(boolean crumbTrails) {
        this.crumbTrails = crumbTrails;
    }

    public byte[] transformVersion(String source, String targetVer, Manager.FhirFormat format, Boolean canDoNative) throws FHIRException, IOException, Exception {
        Content cnt = this.loadContent(source, "validate");
        org.hl7.fhir.r5.elementmodel.Element src = Manager.parse((IWorkerContext)this.context, (InputStream)new ByteArrayInputStream(cnt.focus), (Manager.FhirFormat)cnt.cntType);
        if (canDoNative == null && src.hasChild("url") || canDoNative != null && canDoNative.booleanValue()) {
            try {
                if (VersionUtilities.isR2Ver((String)this.version)) {
                    return this.convertVersionNativeR2(targetVer, cnt, format);
                }
                if (VersionUtilities.isR2BVer((String)this.version)) {
                    return this.convertVersionNativeR2b(targetVer, cnt, format);
                }
                if (VersionUtilities.isR3Ver((String)this.version)) {
                    return this.convertVersionNativeR3(targetVer, cnt, format);
                }
                if (VersionUtilities.isR4Ver((String)this.version)) {
                    return this.convertVersionNativeR4(targetVer, cnt, format);
                }
                throw new FHIRException("Source version not supported yet: " + this.version);
            }
            catch (Exception e) {
                System.out.println("Conversion failed using Java convertor: " + e.getMessage());
            }
        }
        System.out.println("Loading hl7.fhir.xver.r4");
        this.loadIg("hl7.fhir.xver.r4", false);
        String type = src.fhirType();
        String url = this.getMapId(type, targetVer);
        ArrayList<Base> outputs = new ArrayList<Base>();
        org.hl7.fhir.r5.utils.StructureMapUtilities scu = new org.hl7.fhir.r5.utils.StructureMapUtilities((IWorkerContext)this.context, (StructureMapUtilities.ITransformerServices)new TransformSupportServices(outputs));
        StructureMap map = this.context.getTransform(url);
        if (map == null) {
            throw new Error("Unable to find map " + url + " (Known Maps = " + this.context.listMapUrls() + ")");
        }
        org.hl7.fhir.r5.elementmodel.Element resource = this.getTargetResourceFromStructureMap(map);
        scu.transform(null, (Base)src, map, (Base)resource);
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        Manager.compose((IWorkerContext)this.context, (org.hl7.fhir.r5.elementmodel.Element)resource, (OutputStream)bs, (Manager.FhirFormat)format, (IParser.OutputStyle)IParser.OutputStyle.PRETTY, null);
        return bs.toByteArray();
    }

    private String getMapId(String type, String targetVer) {
        if (VersionUtilities.isR2Ver((String)this.version)) {
            if (VersionUtilities.isR3Ver((String)targetVer)) {
                return "http://hl7.org/fhir/StructureMap/" + type + "2to3";
            }
        } else if (VersionUtilities.isR3Ver((String)this.version)) {
            if (VersionUtilities.isR2Ver((String)targetVer)) {
                return "http://hl7.org/fhir/StructureMap/" + type + "3to2";
            }
            if (VersionUtilities.isR4Ver((String)targetVer)) {
                return "http://hl7.org/fhir/StructureMap/" + type + "3to4";
            }
        } else if (VersionUtilities.isR4Ver((String)this.version) && VersionUtilities.isR3Ver((String)targetVer)) {
            return "http://hl7.org/fhir/StructureMap/" + type + "4to3";
        }
        throw new FHIRException("Source/Target version not supported: " + this.version + " -> " + targetVer);
    }

    public byte[] convertVersionNativeR2(String targetVer, Content cnt, Manager.FhirFormat format) throws IOException, Exception {
        org.hl7.fhir.dstu2.model.Resource r2;
        switch (cnt.cntType) {
            case JSON: {
                r2 = new org.hl7.fhir.dstu2.formats.JsonParser().parse(cnt.focus);
                break;
            }
            case XML: {
                r2 = new org.hl7.fhir.dstu2.formats.XmlParser().parse(cnt.focus);
                break;
            }
            default: {
                throw new FHIRException("Unsupported input format: " + cnt.cntType.toString());
            }
        }
        if (VersionUtilities.isR2Ver((String)targetVer)) {
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            switch (format) {
                case JSON: {
                    new org.hl7.fhir.dstu2.formats.JsonParser().compose((OutputStream)bs, r2);
                    return bs.toByteArray();
                }
                case XML: {
                    new org.hl7.fhir.dstu2.formats.XmlParser().compose((OutputStream)bs, r2);
                    return bs.toByteArray();
                }
            }
            throw new FHIRException("Unsupported output format: " + cnt.cntType.toString());
        }
        if (VersionUtilities.isR2BVer((String)targetVer)) {
            org.hl7.fhir.dstu3.model.Resource r3 = VersionConvertor_10_30.convertResource((org.hl7.fhir.dstu2.model.Resource)r2);
            org.hl7.fhir.dstu2016may.model.Resource r2b = VersionConvertor_14_30.convertResource((org.hl7.fhir.dstu3.model.Resource)r3);
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            switch (format) {
                case JSON: {
                    new JsonParser().compose((OutputStream)bs, r2b);
                    return bs.toByteArray();
                }
                case XML: {
                    new org.hl7.fhir.dstu2016may.formats.XmlParser().compose((OutputStream)bs, r2b);
                    return bs.toByteArray();
                }
            }
            throw new FHIRException("Unsupported output format: " + cnt.cntType.toString());
        }
        if (VersionUtilities.isR3Ver((String)targetVer)) {
            org.hl7.fhir.dstu3.model.Resource r3 = VersionConvertor_10_30.convertResource((org.hl7.fhir.dstu2.model.Resource)r2);
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            switch (format) {
                case JSON: {
                    new org.hl7.fhir.dstu3.formats.JsonParser().compose((OutputStream)bs, r3);
                    return bs.toByteArray();
                }
                case XML: {
                    new org.hl7.fhir.dstu3.formats.XmlParser().compose((OutputStream)bs, r3);
                    return bs.toByteArray();
                }
            }
            throw new FHIRException("Unsupported output format: " + cnt.cntType.toString());
        }
        if (VersionUtilities.isR4Ver((String)targetVer)) {
            org.hl7.fhir.r4.model.Resource r4 = VersionConvertor_10_40.convertResource((org.hl7.fhir.dstu2.model.Resource)r2);
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            switch (format) {
                case JSON: {
                    new org.hl7.fhir.r4.formats.JsonParser().compose((OutputStream)bs, r4);
                    return bs.toByteArray();
                }
                case XML: {
                    new XmlParser().compose((OutputStream)bs, r4);
                    return bs.toByteArray();
                }
            }
            throw new FHIRException("Unsupported output format: " + cnt.cntType.toString());
        }
        throw new FHIRException("Target Version not supported yet: " + targetVer);
    }

    public byte[] convertVersionNativeR2b(String targetVer, Content cnt, Manager.FhirFormat format) throws IOException, Exception {
        org.hl7.fhir.dstu2016may.model.Resource r2b;
        switch (cnt.cntType) {
            case JSON: {
                r2b = new JsonParser().parse(cnt.focus);
                break;
            }
            case XML: {
                r2b = new org.hl7.fhir.dstu2016may.formats.XmlParser().parse(cnt.focus);
                break;
            }
            default: {
                throw new FHIRException("Unsupported input format: " + cnt.cntType.toString());
            }
        }
        if (VersionUtilities.isR2Ver((String)targetVer)) {
            org.hl7.fhir.dstu3.model.Resource r3 = VersionConvertor_14_30.convertResource((org.hl7.fhir.dstu2016may.model.Resource)r2b);
            org.hl7.fhir.dstu2.model.Resource r2 = VersionConvertor_10_30.convertResource((org.hl7.fhir.dstu3.model.Resource)r3);
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            switch (format) {
                case JSON: {
                    new org.hl7.fhir.dstu2.formats.JsonParser().compose((OutputStream)bs, r2);
                    return bs.toByteArray();
                }
                case XML: {
                    new org.hl7.fhir.dstu2.formats.XmlParser().compose((OutputStream)bs, r2);
                    return bs.toByteArray();
                }
            }
            throw new FHIRException("Unsupported output format: " + cnt.cntType.toString());
        }
        if (VersionUtilities.isR2BVer((String)targetVer)) {
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            switch (format) {
                case JSON: {
                    new JsonParser().compose((OutputStream)bs, r2b);
                    return bs.toByteArray();
                }
                case XML: {
                    new org.hl7.fhir.dstu2016may.formats.XmlParser().compose((OutputStream)bs, r2b);
                    return bs.toByteArray();
                }
            }
            throw new FHIRException("Unsupported output format: " + cnt.cntType.toString());
        }
        if (VersionUtilities.isR3Ver((String)targetVer)) {
            org.hl7.fhir.dstu3.model.Resource r3 = VersionConvertor_14_30.convertResource((org.hl7.fhir.dstu2016may.model.Resource)r2b);
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            switch (format) {
                case JSON: {
                    new org.hl7.fhir.dstu3.formats.JsonParser().compose((OutputStream)bs, r3);
                    return bs.toByteArray();
                }
                case XML: {
                    new org.hl7.fhir.dstu3.formats.XmlParser().compose((OutputStream)bs, r3);
                    return bs.toByteArray();
                }
            }
            throw new FHIRException("Unsupported output format: " + cnt.cntType.toString());
        }
        if (VersionUtilities.isR4Ver((String)targetVer)) {
            org.hl7.fhir.r4.model.Resource r4 = VersionConvertor_14_40.convertResource((org.hl7.fhir.dstu2016may.model.Resource)r2b);
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            switch (format) {
                case JSON: {
                    new org.hl7.fhir.r4.formats.JsonParser().compose((OutputStream)bs, r4);
                    return bs.toByteArray();
                }
                case XML: {
                    new XmlParser().compose((OutputStream)bs, r4);
                    return bs.toByteArray();
                }
            }
            throw new FHIRException("Unsupported output format: " + cnt.cntType.toString());
        }
        throw new FHIRException("Target Version not supported yet: " + targetVer);
    }

    public byte[] convertVersionNativeR3(String targetVer, Content cnt, Manager.FhirFormat format) throws IOException, Exception {
        org.hl7.fhir.dstu3.model.Resource r3;
        switch (cnt.cntType) {
            case JSON: {
                r3 = new org.hl7.fhir.dstu3.formats.JsonParser().parse(cnt.focus);
                break;
            }
            case XML: {
                r3 = new org.hl7.fhir.dstu3.formats.XmlParser().parse(cnt.focus);
                break;
            }
            default: {
                throw new FHIRException("Unsupported input format: " + cnt.cntType.toString());
            }
        }
        if (VersionUtilities.isR2Ver((String)targetVer)) {
            org.hl7.fhir.dstu2.model.Resource r2 = VersionConvertor_10_30.convertResource((org.hl7.fhir.dstu3.model.Resource)r3);
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            switch (format) {
                case JSON: {
                    new org.hl7.fhir.dstu2.formats.JsonParser().compose((OutputStream)bs, r2);
                    return bs.toByteArray();
                }
                case XML: {
                    new org.hl7.fhir.dstu2.formats.XmlParser().compose((OutputStream)bs, r2);
                    return bs.toByteArray();
                }
            }
            throw new FHIRException("Unsupported output format: " + cnt.cntType.toString());
        }
        if (VersionUtilities.isR2BVer((String)targetVer)) {
            org.hl7.fhir.dstu2016may.model.Resource r2b = VersionConvertor_14_30.convertResource((org.hl7.fhir.dstu3.model.Resource)r3);
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            switch (format) {
                case JSON: {
                    new JsonParser().compose((OutputStream)bs, r2b);
                    return bs.toByteArray();
                }
                case XML: {
                    new org.hl7.fhir.dstu2016may.formats.XmlParser().compose((OutputStream)bs, r2b);
                    return bs.toByteArray();
                }
            }
            throw new FHIRException("Unsupported output format: " + cnt.cntType.toString());
        }
        if (VersionUtilities.isR3Ver((String)targetVer)) {
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            switch (format) {
                case JSON: {
                    new org.hl7.fhir.dstu3.formats.JsonParser().compose((OutputStream)bs, r3);
                    return bs.toByteArray();
                }
                case XML: {
                    new org.hl7.fhir.dstu3.formats.XmlParser().compose((OutputStream)bs, r3);
                    return bs.toByteArray();
                }
            }
            throw new FHIRException("Unsupported output format: " + cnt.cntType.toString());
        }
        if (VersionUtilities.isR4Ver((String)targetVer)) {
            org.hl7.fhir.r4.model.Resource r4 = VersionConvertor_30_40.convertResource((org.hl7.fhir.dstu3.model.Resource)r3, (boolean)false);
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            switch (format) {
                case JSON: {
                    new org.hl7.fhir.r4.formats.JsonParser().compose((OutputStream)bs, r4);
                    return bs.toByteArray();
                }
                case XML: {
                    new XmlParser().compose((OutputStream)bs, r4);
                    return bs.toByteArray();
                }
            }
            throw new FHIRException("Unsupported output format: " + cnt.cntType.toString());
        }
        throw new FHIRException("Target Version not supported yet: " + targetVer);
    }

    public byte[] convertVersionNativeR4(String targetVer, Content cnt, Manager.FhirFormat format) throws IOException, Exception {
        org.hl7.fhir.r4.model.Resource r4;
        switch (cnt.cntType) {
            case JSON: {
                r4 = new org.hl7.fhir.r4.formats.JsonParser().parse(cnt.focus);
                break;
            }
            case XML: {
                r4 = new XmlParser().parse(cnt.focus);
                break;
            }
            default: {
                throw new FHIRException("Unsupported input format: " + cnt.cntType.toString());
            }
        }
        if (VersionUtilities.isR2Ver((String)targetVer)) {
            org.hl7.fhir.dstu2.model.Resource r2 = VersionConvertor_10_40.convertResource((org.hl7.fhir.r4.model.Resource)r4);
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            switch (format) {
                case JSON: {
                    new org.hl7.fhir.dstu2.formats.JsonParser().compose((OutputStream)bs, r2);
                    return bs.toByteArray();
                }
                case XML: {
                    new org.hl7.fhir.dstu2.formats.XmlParser().compose((OutputStream)bs, r2);
                    return bs.toByteArray();
                }
            }
            throw new FHIRException("Unsupported output format: " + cnt.cntType.toString());
        }
        if (VersionUtilities.isR2BVer((String)targetVer)) {
            org.hl7.fhir.dstu2016may.model.Resource r2b = VersionConvertor_14_40.convertResource((org.hl7.fhir.r4.model.Resource)r4);
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            switch (format) {
                case JSON: {
                    new JsonParser().compose((OutputStream)bs, r2b);
                    return bs.toByteArray();
                }
                case XML: {
                    new org.hl7.fhir.dstu2016may.formats.XmlParser().compose((OutputStream)bs, r2b);
                    return bs.toByteArray();
                }
            }
            throw new FHIRException("Unsupported output format: " + cnt.cntType.toString());
        }
        if (VersionUtilities.isR3Ver((String)targetVer)) {
            org.hl7.fhir.dstu3.model.Resource r3 = VersionConvertor_30_40.convertResource((org.hl7.fhir.r4.model.Resource)r4, (boolean)false);
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            switch (format) {
                case JSON: {
                    new org.hl7.fhir.dstu3.formats.JsonParser().compose((OutputStream)bs, r3);
                    return bs.toByteArray();
                }
                case XML: {
                    new org.hl7.fhir.dstu3.formats.XmlParser().compose((OutputStream)bs, r3);
                    return bs.toByteArray();
                }
            }
            throw new FHIRException("Unsupported output format: " + cnt.cntType.toString());
        }
        if (VersionUtilities.isR4Ver((String)targetVer)) {
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            switch (format) {
                case JSON: {
                    new org.hl7.fhir.r4.formats.JsonParser().compose((OutputStream)bs, r4);
                    return bs.toByteArray();
                }
                case XML: {
                    new XmlParser().compose((OutputStream)bs, r4);
                    return bs.toByteArray();
                }
            }
            throw new FHIRException("Unsupported output format: " + cnt.cntType.toString());
        }
        throw new FHIRException("Target Version not supported yet: " + targetVer);
    }

    public byte[] fetchRaw(String source) throws IOException {
        URL url = new URL(source);
        URLConnection c = url.openConnection();
        return TextFile.streamToBytes((InputStream)c.getInputStream());
    }

    public void doneLoading(long loadStart) {
        if (this.showTimes) {
            String s = String.format("Load Time (ms): %d", (System.nanoTime() - loadStart) / 1000000L);
            System.out.println(s);
        }
    }

    public FilesystemPackageCacheManager getPcm() {
        return this.pcm;
    }

    public List<IResourceValidator.BundleValidationRule> getBundleValidationRules() {
        return this.bundleValidationRules;
    }

    private class Content {
        byte[] focus = null;
        Manager.FhirFormat cntType = null;

        private Content() {
        }
    }

    private class AsteriskFilter
    implements FilenameFilter {
        String dir;
        String regex;

        public AsteriskFilter(String filter) throws IOException {
            if (!filter.matches("(.*(\\\\|\\/))*(.*)\\*(.*)")) {
                throw new IOException("Filter names must have the following syntax: [directorypath][prefix]?*[suffix]?   I.e. The asterisk must be in the filename, not the directory path");
            }
            this.dir = filter.replaceAll("(.*(\\\\|\\/))*(.*)\\*(.*)", "$1");
            String expression = filter.replaceAll("(.*(\\\\|\\/))*(.*)", "$3");
            this.regex = "";
            for (int i = 0; i < expression.length(); ++i) {
                this.regex = Character.isAlphabetic(expression.codePointAt(i)) || Character.isDigit(expression.codePointAt(i)) ? this.regex + expression.charAt(i) : (expression.charAt(i) == '*' ? this.regex + ".*" : this.regex + "\\" + expression.charAt(i));
            }
            File f = new File(this.dir);
            if (!f.exists()) {
                throw new IOException("Directory " + this.dir + " does not exist");
            }
            if (!f.isDirectory()) {
                throw new IOException("Directory " + this.dir + " is not a directory");
            }
        }

        @Override
        public boolean accept(File dir, String s) {
            boolean match = s.matches(this.regex);
            return match;
        }

        public String getDir() {
            return this.dir;
        }
    }

    public class TransformSupportServices
    implements StructureMapUtilities.ITransformerServices {
        private List<Base> outputs;

        public TransformSupportServices(List<Base> outputs) {
            this.outputs = outputs;
        }

        public void log(String message) {
            if (ValidationEngine.this.mapLog != null) {
                ValidationEngine.this.mapLog.println(message);
            }
            System.out.println(message);
        }

        public Base createType(Object appInfo, String name) throws FHIRException {
            StructureDefinition sd = (StructureDefinition)ValidationEngine.this.context.fetchResource(StructureDefinition.class, name);
            return Manager.build((IWorkerContext)ValidationEngine.this.context, (StructureDefinition)sd);
        }

        public Base createResource(Object appInfo, Base res, boolean atRootofTransform) {
            if (atRootofTransform) {
                this.outputs.add(res);
            }
            return res;
        }

        public Coding translate(Object appInfo, Coding source, String conceptMapUrl) throws FHIRException {
            ConceptMapEngine cme = new ConceptMapEngine(ValidationEngine.this.context);
            return cme.translate(source, conceptMapUrl);
        }

        public Base resolveReference(Object appContext, String url) throws FHIRException {
            throw new FHIRException("resolveReference is not supported yet");
        }

        public List<Base> performSearch(Object appContext, String url) throws FHIRException {
            throw new FHIRException("performSearch is not supported yet");
        }
    }

    public class ScanOutputItem {
        private String ref;
        private ImplementationGuide ig;
        private StructureDefinition profile;
        private OperationOutcome outcome;
        private String id;

        public ScanOutputItem(String ref, ImplementationGuide ig, StructureDefinition profile, OperationOutcome outcome) {
            this.ref = ref;
            this.ig = ig;
            this.profile = profile;
            this.outcome = outcome;
        }

        public String getRef() {
            return this.ref;
        }

        public ImplementationGuide getIg() {
            return this.ig;
        }

        public StructureDefinition getProfile() {
            return this.profile;
        }

        public OperationOutcome getOutcome() {
            return this.outcome;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getTitle() {
            if (this.profile != null) {
                return "Validate " + this.ref + " against " + this.profile.present() + " (" + this.profile.getUrl() + ")";
            }
            if (this.ig != null) {
                return "Validate " + this.ref + " against global profile specified in " + this.ig.present() + " (" + this.ig.getUrl() + ")";
            }
            return "Validate " + this.ref + " against FHIR Spec";
        }
    }

    public static class VersionSourceInformation {
        private List<String> report = new ArrayList<String>();
        private List<String> versions = new ArrayList<String>();

        public void see(String version, String src) {
            version = VersionUtilities.getMajMin((String)version);
            this.report.add(src + ": " + version);
            if (!this.versions.contains(version)) {
                this.versions.add(version);
                Collections.sort(this.versions);
            }
        }

        public boolean isEmpty() {
            return this.versions.isEmpty();
        }

        public int size() {
            return this.versions.size();
        }

        public String version() {
            return this.versions.get(0);
        }

        public List<String> getReport() {
            if (this.report.isEmpty()) {
                this.report.add("(nothing found)");
            }
            return this.report;
        }
    }
}

