/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.cli.services;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Locale;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.utils.IResourceValidator;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.cache.BasePackageCacheManager;
import org.hl7.fhir.utilities.cache.FilesystemPackageCacheManager;
import org.hl7.fhir.utilities.cache.NpmPackage;

public class StandAloneValidatorFetcher
implements IResourceValidator.IValidatorResourceFetcher {
    private BasePackageCacheManager pcm;
    private IWorkerContext context;
    private IPackageInstaller installer;

    public StandAloneValidatorFetcher(FilesystemPackageCacheManager pcm, IWorkerContext context, IPackageInstaller installer) {
        this.pcm = pcm;
        this.context = context;
        this.installer = installer;
    }

    public Element fetch(Object appContext, String url) throws FHIRFormatError, DefinitionException, FHIRException, IOException {
        throw new Error("Not done yet");
    }

    public IResourceValidator.ReferenceValidationPolicy validationPolicy(Object appContext, String path, String url) {
        throw new Error("Not done yet");
    }

    public boolean resolveURL(Object appContext, String path, String url) throws IOException, FHIRException {
        String ver;
        if (!Utilities.isAbsoluteUrl((String)url)) {
            return false;
        }
        VersionUtilities.VersionURLInfo vu = VersionUtilities.parseVersionUrl((String)url);
        if (vu != null) {
            NpmPackage pi = this.pcm.loadPackage(VersionUtilities.packageForVersion((String)vu.getVersion()), VersionUtilities.getCurrentVersion((String)vu.getVersion()));
            return pi.hasCanonical(vu.getUrl());
        }
        String base = this.findBaseUrl(url);
        String pid = this.pcm.getPackageId(base);
        String string = ver = url.contains("|") ? url.substring(url.indexOf("|") + 1) : null;
        if (pid != null && this.installer.packageExists(pid, ver)) {
            this.installer.loadPackage(pid, ver);
            NpmPackage pi = this.pcm.loadPackage(pid);
            return pi.hasCanonical(url);
        }
        return !url.startsWith("http://hl7.org/fhir");
    }

    private String findBaseUrl(String url) {
        String[] p = url.split("\\/");
        for (int i = 1; i < p.length; ++i) {
            if (!Utilities.existsInList((String)p[i], (List)this.context.getResourceNames())) continue;
            StringBuilder b = new StringBuilder(p[0]);
            for (int j = 1; j < i; ++j) {
                b.append("/");
                b.append(p[j]);
            }
            return b.toString();
        }
        return null;
    }

    public byte[] fetchRaw(String url) throws MalformedURLException, IOException {
        throw new Error("Not done yet");
    }

    public void setLocale(Locale locale) {
        throw new Error("Not done yet");
    }

    public static interface IPackageInstaller {
        public boolean packageExists(String var1, String var2) throws IOException, FHIRException;

        public void loadPackage(String var1, String var2) throws IOException, FHIRException;
    }
}

