/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class ValidatorHostContext {
    private Object appContext;
    private Element container;
    private Element resource;
    private Element rootResource;
    private StructureDefinition profile;
    private boolean checkSpecials = true;
    private Map<String, List<ValidationMessage>> sliceRecords;

    public ValidatorHostContext(Object appContext) {
        this.appContext = appContext;
    }

    public ValidatorHostContext(Object appContext, Element element) {
        this.appContext = appContext;
        this.resource = element;
        this.rootResource = element;
    }

    public Object getAppContext() {
        return this.appContext;
    }

    public ValidatorHostContext setAppContext(Object appContext) {
        this.appContext = appContext;
        return this;
    }

    public Element getContainer() {
        return this.container;
    }

    public ValidatorHostContext setContainer(Element container) {
        this.container = container;
        return this;
    }

    public ValidatorHostContext setResource(Element resource) {
        this.resource = resource;
        return this;
    }

    public Element getRootResource() {
        return this.rootResource;
    }

    public ValidatorHostContext setRootResource(Element rootResource) {
        this.rootResource = rootResource;
        return this;
    }

    public StructureDefinition getProfile() {
        return this.profile;
    }

    public ValidatorHostContext setProfile(StructureDefinition profile) {
        this.profile = profile;
        return this;
    }

    public Map<String, List<ValidationMessage>> getSliceRecords() {
        return this.sliceRecords;
    }

    public ValidatorHostContext setSliceRecords(Map<String, List<ValidationMessage>> sliceRecords) {
        this.sliceRecords = sliceRecords;
        return this;
    }

    public boolean isCheckSpecials() {
        return this.checkSpecials;
    }

    public void setCheckSpecials(boolean checkSpecials) {
        this.checkSpecials = checkSpecials;
    }

    public Element getResource() {
        return this.resource;
    }

    public void sliceNotes(String url, List<ValidationMessage> record) {
        this.sliceRecords.put(url, record);
    }

    public ValidatorHostContext forContained(Element element) {
        ValidatorHostContext res = new ValidatorHostContext(this.appContext);
        res.rootResource = this.resource;
        res.resource = element;
        res.container = this.resource;
        res.profile = this.profile;
        return res;
    }

    public ValidatorHostContext forEntry(Element element) {
        ValidatorHostContext res = new ValidatorHostContext(this.appContext);
        res.rootResource = element;
        res.resource = element;
        res.container = this.resource;
        res.profile = this.profile;
        return res;
    }

    public ValidatorHostContext forProfile(StructureDefinition profile) {
        ValidatorHostContext res = new ValidatorHostContext(this.appContext);
        res.resource = this.resource;
        res.rootResource = this.rootResource;
        res.container = this.container;
        res.profile = profile;
        res.sliceRecords = this.sliceRecords != null ? this.sliceRecords : new HashMap<String, List<ValidationMessage>>();
        return res;
    }

    public ValidatorHostContext forLocalReference(StructureDefinition profile, Element resource) {
        ValidatorHostContext res = new ValidatorHostContext(this.appContext);
        res.resource = resource;
        res.rootResource = resource;
        res.container = this.container;
        res.profile = profile;
        res.checkSpecials = false;
        return res;
    }

    public ValidatorHostContext forRemoteReference(StructureDefinition profile, Element resource) {
        ValidatorHostContext res = new ValidatorHostContext(this.appContext);
        res.resource = resource;
        res.rootResource = resource;
        res.container = resource;
        res.profile = profile;
        res.checkSpecials = false;
        return res;
    }

    public ValidatorHostContext forSlicing() {
        ValidatorHostContext res = new ValidatorHostContext(this.appContext);
        res.resource = this.resource;
        res.rootResource = this.resource;
        res.container = this.resource;
        res.profile = this.profile;
        res.checkSpecials = false;
        res.sliceRecords = new HashMap<String, List<ValidationMessage>>();
        return res;
    }
}

