/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.cli.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.javalin.http.Context;
import org.hl7.fhir.validation.ValidationEngine;
import org.hl7.fhir.validation.cli.model.ValidationRequest;
import org.hl7.fhir.validation.cli.model.ValidationResponse;
import org.hl7.fhir.validation.cli.services.ValidationService;

public class ValidationController {
    private ValidationEngine myValidationEngine;

    public ValidationController(ValidationEngine validationEngine) {
        this.myValidationEngine = validationEngine;
    }

    public void handleValidationRequest(Context ctx) {
        ValidationRequest request = (ValidationRequest)ctx.bodyAsClass(ValidationRequest.class);
        ValidationResponse response = null;
        try {
            response = ValidationService.validateSources(request, this.myValidationEngine);
            ObjectMapper Obj = new ObjectMapper();
            String jsonStr = Obj.writeValueAsString((Object)response);
            ctx.status(200).json((Object)jsonStr);
        }
        catch (Exception e) {
            ctx.status(500).result(e.getLocalizedMessage());
        }
    }
}

