/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.cli;

import io.javalin.Javalin;
import org.hl7.fhir.validation.ValidationEngine;
import org.hl7.fhir.validation.cli.controller.CliContextController;
import org.hl7.fhir.validation.cli.controller.UIController;
import org.hl7.fhir.validation.cli.controller.ValidationController;
import org.hl7.fhir.validation.cli.model.CliContext;

public class RestEndpoints {
    public UIController myUIController;
    public CliContextController myCliContextController;
    public ValidationController myValidationController;

    public void initRestEndpoints(Javalin app, CliContext cliContext, ValidationEngine validationEngine) {
        this.myUIController = new UIController();
        this.myCliContextController = new CliContextController(cliContext);
        this.myValidationController = new ValidationController(validationEngine);
        app.get("/home", this.myUIController.renderLandingPage);
        app.get("/context", this.myCliContextController::handleGetCurrentCliContext);
        app.post("/context", this.myCliContextController::handleSetCurrentCliContext);
        app.post("/validate", this.myValidationController::handleValidationRequest);
    }
}

