/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.type;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.hl7.fhir.convertors.VersionConvertor_10_50;
import org.hl7.fhir.convertors.VersionConvertor_14_50;
import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.formats.JsonParser;
import org.hl7.fhir.r5.conformance.ProfileUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.model.ExpressionNode;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.utils.FHIRPathEngine;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.validation.BaseValidator;
import org.hl7.fhir.validation.TimeTracker;
import org.hl7.fhir.validation.instance.utils.NodeStack;

public class StructureDefinitionValidator
extends BaseValidator {
    private FHIRPathEngine fpe;

    public StructureDefinitionValidator(IWorkerContext context, TimeTracker timeTracker, FHIRPathEngine fpe) {
        super(context);
        this.source = ValidationMessage.Source.InstanceValidator;
        this.fpe = fpe;
        this.timeTracker = timeTracker;
    }

    public void validateStructureDefinition(List<ValidationMessage> errors, Element src, NodeStack stack) {
        try {
            StructureDefinition sd = this.loadAsSD(src);
            List snapshot = sd.getSnapshot().getElement();
            sd.setSnapshot(null);
            StructureDefinition base = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition());
            if (this.warning(errors, ValidationMessage.IssueType.NOTFOUND, stack.getLiteralPath(), base != null, "Unable_to_find_base__for_", sd.getBaseDefinition(), "StructureDefinition, so can't check the differential")) {
                ArrayList msgs = new ArrayList();
                ProfileUtilities pu = new ProfileUtilities(this.context, msgs, null);
                pu.generateSnapshot(base, sd, sd.getUrl(), "http://hl7.org/fhir", sd.getName());
                if (msgs.size() > 0) {
                    for (ValidationMessage msg : msgs) {
                        String loc = msg.getLocation();
                        if (loc.contains("#")) {
                            msg.setLocation(stack.getLiteralPath() + ".differential.element.where(path = '" + loc.substring(loc.indexOf("#") + 1) + "')");
                        } else {
                            msg.setLocation(stack.getLiteralPath());
                        }
                        errors.add(msg);
                    }
                }
            }
            if (!snapshot.isEmpty()) {
                System.out.print("?");
            }
        }
        catch (IOException | FHIRException e) {
            this.rule(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), false, "ERROR_GENERATING_SNAPSHOT", e.getMessage());
        }
    }

    private StructureDefinition loadAsSD(Element src) throws FHIRException, IOException {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        Manager.compose((IWorkerContext)this.context, (Element)src, (OutputStream)bs, (Manager.FhirFormat)Manager.FhirFormat.JSON, (IParser.OutputStyle)IParser.OutputStyle.NORMAL, null);
        if (VersionUtilities.isR2Ver((String)this.context.getVersion())) {
            org.hl7.fhir.dstu2.model.Resource r2 = new org.hl7.fhir.dstu2.formats.JsonParser().parse(bs.toByteArray());
            return (StructureDefinition)VersionConvertor_10_50.convertResource((org.hl7.fhir.dstu2.model.Resource)r2);
        }
        if (VersionUtilities.isR2BVer((String)this.context.getVersion())) {
            org.hl7.fhir.dstu2016may.model.Resource r2b = new org.hl7.fhir.dstu2016may.formats.JsonParser().parse(bs.toByteArray());
            return (StructureDefinition)VersionConvertor_14_50.convertResource((org.hl7.fhir.dstu2016may.model.Resource)r2b);
        }
        if (VersionUtilities.isR3Ver((String)this.context.getVersion())) {
            Resource r3 = new org.hl7.fhir.dstu3.formats.JsonParser().parse(bs.toByteArray());
            return (StructureDefinition)VersionConvertor_30_50.convertResource((Resource)r3, (boolean)false);
        }
        if (VersionUtilities.isR4Ver((String)this.context.getVersion())) {
            org.hl7.fhir.r4.model.Resource r4 = new JsonParser().parse(bs.toByteArray());
            return (StructureDefinition)VersionConvertor_40_50.convertResource((org.hl7.fhir.r4.model.Resource)r4);
        }
        return (StructureDefinition)new org.hl7.fhir.r5.formats.JsonParser().parse(bs.toByteArray());
    }

    public class FhirPathSorter
    implements Comparator<ExpressionNode> {
        @Override
        public int compare(ExpressionNode arg0, ExpressionNode arg1) {
            return arg0.toString().compareTo(arg1.toString());
        }
    }
}

