/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.type;

import java.util.List;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.validation.BaseValidator;
import org.hl7.fhir.validation.TimeTracker;
import org.hl7.fhir.validation.instance.utils.NodeStack;

public class SearchParameterValidator
extends BaseValidator {
    public SearchParameterValidator(IWorkerContext context, TimeTracker timeTracker) {
        super(context);
        this.source = ValidationMessage.Source.InstanceValidator;
        this.timeTracker = timeTracker;
    }

    public void validateSearchParameter(List<ValidationMessage> errors, Element cs, NodeStack stack) {
        String url = cs.getNamedChildValue("url");
        String master = cs.getNamedChildValue("derivedFrom");
        if (!Utilities.noString((String)master)) {
            SearchParameter sp = (SearchParameter)this.context.fetchResource(SearchParameter.class, master);
            if (this.warning(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), sp != null, "SEARCHPARAMETER_NOTFOUND", master)) {
                List bl = cs.getChildren("base");
                for (Element b : bl) {
                    this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), sp.hasBase(b.primitiveValue()), "SEARCHPARAMETER_BASE_WRONG", master, b.primitiveValue());
                }
                this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), !cs.hasChild("type") || sp.getType().toCode().equals(cs.getNamedChildValue("type")), "SEARCHPARAMETER_TYPE_WRONG", master, sp.getType().toCode(), cs.getNamedChildValue("type"));
                this.warning(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), !cs.hasChild("expression") || sp.getExpression().equals(cs.getNamedChildValue("expression")), "SEARCHPARAMETER_EXP_WRONG", master, sp.getExpression(), cs.getNamedChildValue("expression"));
            }
        }
    }
}

