/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.type;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.ObjectConverter;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.FhirPublication;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Measure;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.utils.NarrativeGenerator;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.xml.XMLUtil;
import org.hl7.fhir.validation.BaseValidator;
import org.hl7.fhir.validation.TimeTracker;
import org.hl7.fhir.validation.instance.type.MeasureContext;
import org.hl7.fhir.validation.instance.utils.NodeStack;
import org.hl7.fhir.validation.instance.utils.ValidatorHostContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MeasureValidator
extends BaseValidator {
    public MeasureValidator(IWorkerContext context, TimeTracker timeTracker) {
        super(context);
        this.source = ValidationMessage.Source.InstanceValidator;
        this.timeTracker = timeTracker;
    }

    public void validateMeasure(ValidatorHostContext hostContext, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack) throws FHIRException {
        MeasureContext mctxt = new MeasureContext();
        List libs = element.getChildrenByName("library");
        for (org.hl7.fhir.r5.elementmodel.Element lib : libs) {
            String ref = lib.isPrimitive() ? lib.primitiveValue() : lib.getChildValue("reference");
            if (Utilities.noString((String)ref)) continue;
            Library l = (Library)this.context.fetchResource(Library.class, ref);
            if (!this.hint(errors, ValidationMessage.IssueType.NOTFOUND, lib.line(), lib.col(), stack.getLiteralPath(), l != null, "MEASURE_M_LIB_UNKNOWN", ref)) continue;
            mctxt.seeLibrary(l);
        }
        List groups = element.getChildrenByName("group");
        if (this.warning(errors, ValidationMessage.IssueType.REQUIRED, element.line(), element.col(), stack.getLiteralPath(), groups.size() > 0, "MEASURE_M_NO_GROUPS", new Object[0])) {
            int c = 0;
            for (org.hl7.fhir.r5.elementmodel.Element group : groups) {
                NodeStack ns = stack.push(group, c, null, null);
                this.warning(errors, ValidationMessage.IssueType.REQUIRED, group.line(), group.col(), ns.getLiteralPath(), groups.size() == 1 || group.hasChild("code"), "MEASURE_M_GROUP_CODE", new Object[0]);
                this.warning(errors, ValidationMessage.IssueType.REQUIRED, group.line(), group.col(), ns.getLiteralPath(), group.hasChildren("population"), "MEASURE_M_GROUP_POP", new Object[0]);
                int c1 = 0;
                List pl = group.getChildrenByName("population");
                for (org.hl7.fhir.r5.elementmodel.Element p : pl) {
                    NodeStack ns2 = ns.push(p, c1, null, null);
                    this.warning(errors, ValidationMessage.IssueType.REQUIRED, p.line(), p.col(), ns2.getLiteralPath(), pl.size() == 1 || p.hasChild("code"), "MEASURE_M_GROUP_POP_NO_CODE", new Object[0]);
                    ++c1;
                }
                c1 = 0;
                List stl = group.getChildrenByName("stratifier");
                for (org.hl7.fhir.r5.elementmodel.Element st : stl) {
                    NodeStack ns2 = ns.push(st, c1, null, null);
                    this.warning(errors, ValidationMessage.IssueType.REQUIRED, st.line(), st.col(), ns2.getLiteralPath(), stl.size() == 1 || st.hasChild("code"), "MEASURE_M_GROUP_STRATA_NO_CODE", new Object[0]);
                    if (st.hasChild("criteria")) {
                        org.hl7.fhir.r5.elementmodel.Element crit = st.getNamedChild("criteria");
                        NodeStack nsc = ns2.push(crit, -1, null, null);
                        this.validateMeasureCriteria(hostContext, errors, mctxt, crit, nsc);
                    }
                    int c2 = 0;
                    List cpl = group.getChildrenByName("component");
                    for (org.hl7.fhir.r5.elementmodel.Element cp : cpl) {
                        NodeStack ns3 = ns2.push(cp, c2, null, null);
                        this.warning(errors, ValidationMessage.IssueType.REQUIRED, cp.line(), cp.col(), ns3.getLiteralPath(), cpl.size() == 1 || cp.hasChild("code"), "MEASURE_M_GROUP_STRATA_COMP_NO_CODE", new Object[0]);
                        if (cp.hasChild("criteria")) {
                            org.hl7.fhir.r5.elementmodel.Element crit = cp.getNamedChild("criteria");
                            NodeStack nsc = ns3.push(crit, -1, null, null);
                            this.validateMeasureCriteria(hostContext, errors, mctxt, crit, nsc);
                        }
                        ++c2;
                    }
                    ++c1;
                }
                ++c;
            }
        }
    }

    private void validateMeasureCriteria(ValidatorHostContext hostContext, List<ValidationMessage> errors, MeasureContext mctxt, org.hl7.fhir.r5.elementmodel.Element crit, NodeStack nsc) {
        String mimeType = crit.getChildValue("language");
        if (!Utilities.noString((String)mimeType)) {
            if ("text/cql".equals(mimeType)) {
                String cqlRef = crit.getChildValue("expression");
                Library lib = null;
                if (this.rule(errors, ValidationMessage.IssueType.INVALID, crit.line(), crit.col(), nsc.getLiteralPath(), mctxt.libraries().size() > 0, "MEASURE_M_CRITERIA_CQL_NO_LIB", new Object[0])) {
                    if (cqlRef.contains(".")) {
                        String name = cqlRef.substring(0, cqlRef.indexOf("."));
                        cqlRef = cqlRef.substring(cqlRef.indexOf(".") + 1);
                        for (Library l : mctxt.libraries()) {
                            if (!name.equals(l.getName()) || !this.rule(errors, ValidationMessage.IssueType.INVALID, crit.line(), crit.col(), nsc.getLiteralPath(), lib == null, "MEASURE_M_CRITERIA_CQL_LIB_DUPL", new Object[0])) continue;
                            lib = l;
                        }
                        this.rule(errors, ValidationMessage.IssueType.INVALID, crit.line(), crit.col(), nsc.getLiteralPath(), lib != null, "MEASURE_M_CRITERIA_CQL_LIB_NOT_FOUND", name);
                    } else if (this.rule(errors, ValidationMessage.IssueType.INVALID, crit.line(), crit.col(), nsc.getLiteralPath(), mctxt.libraries().size() == 1, "MEASURE_M_CRITERIA_CQL_ONLY_ONE_LIB", new Object[0])) {
                        lib = mctxt.libraries().get(0);
                    }
                }
                if (lib != null && this.rule(errors, ValidationMessage.IssueType.INVALID, crit.line(), crit.col(), nsc.getLiteralPath(), lib.hasUserData("validator.ELM"), "MEASURE_M_CRITERIA_CQL_NO_ELM", lib.getUrl())) {
                    if (lib.getUserData("validator.ELM") instanceof String) {
                        this.rule(errors, ValidationMessage.IssueType.INVALID, crit.line(), crit.col(), nsc.getLiteralPath(), false, "MEASURE_M_CRITERIA_CQL_ERROR", lib.getUrl(), lib.getUserString("validator.ELM"));
                    } else if (lib.getUserData("validator.ELM") instanceof Document) {
                        Element elm = ((Document)lib.getUserData("validator.ELM")).getDocumentElement();
                        if (this.rule(errors, ValidationMessage.IssueType.INVALID, crit.line(), crit.col(), nsc.getLiteralPath(), this.isValidElm(elm), "MEASURE_M_CRITERIA_CQL_ELM_NOT_VALID", lib.getUrl(), cqlRef)) {
                            this.rule(errors, ValidationMessage.IssueType.INVALID, crit.line(), crit.col(), nsc.getLiteralPath(), this.hasCqlTarget(elm, cqlRef), "MEASURE_M_CRITERIA_CQL_NOT_FOUND", lib.getUrl(), cqlRef);
                        }
                    }
                }
            } else if ("text/fhirpath".equals(mimeType)) {
                this.warning(errors, ValidationMessage.IssueType.REQUIRED, crit.line(), crit.col(), nsc.getLiteralPath(), false, "MEASURE_M_CRITERIA_UNKNOWN", mimeType);
            } else if ("application/x-fhir-query".equals(mimeType)) {
                this.warning(errors, ValidationMessage.IssueType.REQUIRED, crit.line(), crit.col(), nsc.getLiteralPath(), false, "MEASURE_M_CRITERIA_UNKNOWN", mimeType);
            } else {
                this.warning(errors, ValidationMessage.IssueType.REQUIRED, crit.line(), crit.col(), nsc.getLiteralPath(), false, "MEASURE_M_CRITERIA_UNKNOWN", mimeType);
            }
        }
    }

    private boolean isValidElm(Element elm) {
        return elm != null && "library".equals(elm.getNodeName()) && "urn:hl7-org:elm:r1".equals(elm.getNamespaceURI());
    }

    private boolean hasCqlTarget(Element element, String cqlRef) {
        Element stmts = XMLUtil.getNamedChild((Element)element, (String)"statements");
        if (stmts != null) {
            for (Element def : XMLUtil.getNamedChildren((Element)stmts, (String)"def")) {
                if (!cqlRef.equals(def.getAttribute("name"))) continue;
                return true;
            }
        }
        return false;
    }

    public void validateMeasureReport(ValidatorHostContext hostContext, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack) throws FHIRException {
        org.hl7.fhir.r5.elementmodel.Element m = element.getNamedChild("measure");
        String measure = null;
        if (m != null) {
            if (StringUtils.isNotBlank((CharSequence)m.getValue())) {
                measure = m.getValue();
            } else if (StringUtils.isNotBlank((CharSequence)m.getChildValue("reference"))) {
                measure = m.getChildValue("reference");
            }
        }
        if (this.hint(errors, ValidationMessage.IssueType.REQUIRED, element.line(), element.col(), stack.getLiteralPath(), measure != null, "Measure_MR_M_None")) {
            long t = System.nanoTime();
            Measure msrc = measure.startsWith("#") ? this.loadMeasure(element, measure.substring(1)) : (Measure)this.context.fetchResource(Measure.class, measure);
            this.timeTracker.sd(t, System.nanoTime());
            if (this.warning(errors, ValidationMessage.IssueType.REQUIRED, m.line(), m.col(), stack.getLiteralPath(), msrc != null, "Measure_MR_M_NotFound", measure)) {
                boolean inComplete = !"complete".equals(element.getNamedChildValue("status"));
                MeasureContext mc = new MeasureContext(msrc, element);
                NodeStack ns = stack.push(m, -1, m.getProperty().getDefinition(), m.getProperty().getDefinition());
                this.hint(errors, ValidationMessage.IssueType.BUSINESSRULE, m.line(), m.col(), ns.getLiteralPath(), Utilities.existsInList((String)mc.scoring(), (String[])new String[]{"proportion", "ratio", "continuous-variable", "cohort"}), "MEASURE_MR_M_SCORING_UNK");
                this.validateMeasureReportGroups(hostContext, mc, errors, element, stack, inComplete);
            }
        }
    }

    private Measure loadMeasure(org.hl7.fhir.r5.elementmodel.Element resource, String id) throws FHIRException {
        try {
            for (org.hl7.fhir.r5.elementmodel.Element contained : resource.getChildren("contained")) {
                if (!contained.getIdBase().equals(id)) continue;
                FhirPublication v = FhirPublication.fromCode((String)this.context.getVersion());
                ByteArrayOutputStream bs = new ByteArrayOutputStream();
                new org.hl7.fhir.r5.elementmodel.JsonParser(this.context).compose(contained, (OutputStream)bs, IParser.OutputStyle.NORMAL, id);
                byte[] json = bs.toByteArray();
                switch (v) {
                    case DSTU1: {
                        throw new FHIRException(this.context.formatMessage("Unsupported_version_R1", new Object[0]));
                    }
                    case DSTU2: {
                        throw new FHIRException(this.context.formatMessage("Unsupported_version_R2", new Object[0]));
                    }
                    case DSTU2016May: {
                        throw new FHIRException(this.context.formatMessage("Unsupported_version_R2B", new Object[0]));
                    }
                    case STU3: {
                        org.hl7.fhir.dstu3.model.Resource r3 = new org.hl7.fhir.dstu3.formats.JsonParser().parse(json);
                        Resource r5 = VersionConvertor_30_50.convertResource((org.hl7.fhir.dstu3.model.Resource)r3, (boolean)false);
                        if (r5 instanceof Measure) {
                            return (Measure)r5;
                        }
                        return null;
                    }
                    case R4: {
                        org.hl7.fhir.r4.model.Resource r4 = new org.hl7.fhir.r4.formats.JsonParser().parse(json);
                        Resource r5 = VersionConvertor_40_50.convertResource((org.hl7.fhir.r4.model.Resource)r4);
                        if (r5 instanceof Measure) {
                            return (Measure)r5;
                        }
                        return null;
                    }
                    case R5: {
                        Resource r5 = new JsonParser().parse(json);
                        if (r5 instanceof Measure) {
                            return (Measure)r5;
                        }
                        return null;
                    }
                }
            }
            return null;
        }
        catch (IOException e) {
            throw new FHIRException((Throwable)e);
        }
    }

    private void validateMeasureReportGroups(ValidatorHostContext hostContext, MeasureContext m, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element mr, NodeStack stack, boolean inProgress) {
        NarrativeGenerator gen = new NarrativeGenerator(null, null, this.context);
        ArrayList<Measure.MeasureGroupComponent> groups = new ArrayList<Measure.MeasureGroupComponent>();
        List glist = mr.getChildrenByName("group");
        if (glist.size() == 1 && m.groups().size() == 1) {
            org.hl7.fhir.r5.elementmodel.Element mrg = (org.hl7.fhir.r5.elementmodel.Element)glist.get(0);
            NodeStack ns = stack.push(mrg, 0, mrg.getProperty().getDefinition(), mrg.getProperty().getDefinition());
            if (m.groups().get(0).hasCode() && mrg.hasChild("code")) {
                CodeableConcept cc = ObjectConverter.readAsCodeableConcept((org.hl7.fhir.r5.elementmodel.Element)mrg.getNamedChild("code"));
                if (this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, mrg.line(), mrg.col(), ns.getLiteralPath(), this.hasUseableCode(cc), "MEASURE_MR_GRP_NO_USABLE_CODE", new Object[0])) {
                    this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, mrg.line(), mrg.col(), ns.getLiteralPath(), cc.matches(m.groups().get(0).getCode()), "MEASURE_MR_GRP_NO_WRONG_CODE", gen.gen(cc), gen.gen(m.groups().get(0).getCode()));
                }
            }
            this.validateMeasureReportGroup(hostContext, m, m.groups().get(0), errors, mrg, ns, inProgress, gen);
        } else {
            int i = 0;
            for (org.hl7.fhir.r5.elementmodel.Element mrg : glist) {
                NodeStack ns = stack.push(mrg, i, mrg.getProperty().getDefinition(), mrg.getProperty().getDefinition());
                CodeableConcept cc = ObjectConverter.readAsCodeableConcept((org.hl7.fhir.r5.elementmodel.Element)mrg.getNamedChild("code"));
                if (this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, mrg.line(), mrg.col(), ns.getLiteralPath(), cc != null, "MEASURE_MR_GRP_NO_CODE", new Object[0])) {
                    Measure.MeasureGroupComponent mg = this.getGroupForCode(cc, m.measure());
                    if (this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, mrg.line(), mrg.col(), ns.getLiteralPath(), mg != null, "MEASURE_MR_GRP_UNK_CODE", new Object[0]) && this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, mrg.line(), mrg.col(), ns.getLiteralPath(), !groups.contains(mg), "MEASURE_MR_GRP_DUPL_CODE", new Object[0])) {
                        groups.add(mg);
                        this.validateMeasureReportGroup(hostContext, m, mg, errors, mrg, ns, inProgress, gen);
                    }
                }
                ++i;
            }
            for (Measure.MeasureGroupComponent mg : m.groups()) {
                if (groups.contains(mg)) continue;
                this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, mr.line(), mr.col(), stack.getLiteralPath(), groups.contains(mg), "MEASURE_MR_GRP_MISSING_BY_CODE", gen.gen(mg.getCode()));
            }
        }
    }

    private void validateMeasureReportGroup(ValidatorHostContext hostContext, MeasureContext m, Measure.MeasureGroupComponent mg, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element mrg, NodeStack ns, boolean inProgress, NarrativeGenerator gen) {
        this.validateMeasureReportGroupPopulations(hostContext, m, mg, errors, mrg, ns, inProgress, gen);
        this.validateScore(hostContext, m, errors, mrg, ns, inProgress, gen);
        this.validateMeasureReportGroupStratifiers(hostContext, m, mg, errors, mrg, ns, inProgress, gen);
    }

    private void validateScore(ValidatorHostContext hostContext, MeasureContext m, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element mrg, NodeStack stack, boolean inProgress, NarrativeGenerator gen) {
        org.hl7.fhir.r5.elementmodel.Element ms = mrg.getNamedChild("measureScore");
        if ("data-collection".equals(m.reportType())) {
            this.banned(errors, stack, ms, "MEASURE_MR_SCORE_PROHIBITED_RT", new Object[0]);
        } else if ("cohort".equals(m.scoring())) {
            this.banned(errors, stack, ms, "MEASURE_MR_SCORE_PROHIBITED_MS", new Object[0]);
        } else if (Utilities.existsInList((String)m.scoring(), (String[])new String[]{"proportion", "ratio", "continuous-variable"}) && this.rule(errors, ValidationMessage.IssueType.REQUIRED, mrg.line(), mrg.col(), stack.getLiteralPath(), ms != null, "MEASURE_MR_SCORE_REQUIRED", m.scoring())) {
            NodeStack ns = stack.push(ms, -1, ms.getProperty().getDefinition(), ms.getProperty().getDefinition());
            org.hl7.fhir.r5.elementmodel.Element v = ms.getNamedChild("value");
            if ("proportion".equals(m.scoring())) {
                this.banned(errors, ns, ms, "unit", "MEASURE_MR_SCORE_UNIT_PROHIBITED", "proportion");
                this.banned(errors, ns, ms, "system", "MEASURE_MR_SCORE_UNIT_PROHIBITED", "proportion");
                this.banned(errors, ns, ms, "code", "MEASURE_MR_SCORE_UNIT_PROHIBITED", "proportion");
                if (this.rule(errors, ValidationMessage.IssueType.REQUIRED, ms.line(), ms.col(), ns.getLiteralPath(), v != null, "MEASURE_MR_SCORE_VALUE_REQUIRED", new Object[0])) {
                    try {
                        BigDecimal dec = new BigDecimal(v.primitiveValue());
                        NodeStack nsv = ns.push(v, -1, v.getProperty().getDefinition(), v.getProperty().getDefinition());
                        this.rule(errors, ValidationMessage.IssueType.REQUIRED, v.line(), v.col(), nsv.getLiteralPath(), dec.compareTo(new BigDecimal(0)) >= 0 && dec.compareTo(new BigDecimal(1)) <= 0, "MEASURE_MR_SCORE_VALUE_INVALID_01", new Object[0]);
                    }
                    catch (Exception dec) {}
                }
            } else if ("ratio".equals(m.scoring())) {
                if (this.rule(errors, ValidationMessage.IssueType.REQUIRED, ms.line(), ms.col(), ns.getLiteralPath(), v != null, "MEASURE_MR_SCORE_VALUE_REQUIRED", new Object[0])) {
                    Coding c;
                    org.hl7.fhir.r5.elementmodel.Element unit = ms.getNamedChild("code");
                    Coding coding = c = m.measure().hasExtension("http://hl7.org/fhir/StructureDefinition/questionnaire-unit") ? (Coding)m.measure().getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/questionnaire-unit").getValue() : null;
                    if (unit != null) {
                        if (c != null) {
                            NodeStack nsc = ns.push(unit, -1, unit.getProperty().getDefinition(), unit.getProperty().getDefinition());
                            this.rule(errors, ValidationMessage.IssueType.CODEINVALID, unit.line(), unit.col(), nsc.getLiteralPath(), c.getCode().equals(unit.primitiveValue()), "MEASURE_MR_SCORE_FIXED", c.getCode());
                            org.hl7.fhir.r5.elementmodel.Element system = ms.getNamedChild("system");
                            if (system == null) {
                                NodeStack nss = system == null ? ns : ns.push(system, -1, system.getProperty().getDefinition(), system.getProperty().getDefinition());
                                this.rule(errors, ValidationMessage.IssueType.CODEINVALID, system.line(), system.col(), nss.getLiteralPath(), c.getSystem().equals(system.primitiveValue()), "MEASURE_MR_SCORE_FIXED", c.getSystem());
                            } else {
                                this.rule(errors, ValidationMessage.IssueType.CODEINVALID, ms.line(), ms.col(), ns.getLiteralPath(), c.getSystem().equals(system.primitiveValue()), "MEASURE_MR_SCORE_FIXED", c.getSystem());
                            }
                        }
                    } else if (c != null) {
                        this.rule(errors, ValidationMessage.IssueType.NOTFOUND, ms.line(), ms.col(), ns.getLiteralPath(), false, "MEASURE_MR_SCORE_FIXED", gen.gen(c));
                    } else {
                        this.warning(errors, ValidationMessage.IssueType.NOTFOUND, ms.line(), ms.col(), ns.getLiteralPath(), false, "MEASURE_MR_SCORE_UNIT_REQUIRED", "ratio");
                    }
                }
            } else if ("continuous-variable".equals(m.scoring()) && this.rule(errors, ValidationMessage.IssueType.REQUIRED, ms.line(), ms.col(), ns.getLiteralPath(), v != null, "MEASURE_MR_SCORE_VALUE_REQUIRED", new Object[0])) {
                Coding c;
                org.hl7.fhir.r5.elementmodel.Element unit = ms.getNamedChild("code");
                Coding coding = c = m.measure().hasExtension("http://hl7.org/fhir/StructureDefinition/questionnaire-unit") ? (Coding)m.measure().getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/questionnaire-unit").getValue() : null;
                if (unit != null) {
                    if (c != null) {
                        NodeStack nsc = ns.push(unit, -1, unit.getProperty().getDefinition(), unit.getProperty().getDefinition());
                        this.rule(errors, ValidationMessage.IssueType.CODEINVALID, unit.line(), unit.col(), nsc.getLiteralPath(), c.getCode().equals(unit.primitiveValue()), "MEASURE_MR_SCORE_FIXED", c.getCode());
                        org.hl7.fhir.r5.elementmodel.Element system = ms.getNamedChild("system");
                        if (system == null) {
                            NodeStack nss = system == null ? ns : ns.push(system, -1, system.getProperty().getDefinition(), system.getProperty().getDefinition());
                            this.rule(errors, ValidationMessage.IssueType.CODEINVALID, system.line(), system.col(), nss.getLiteralPath(), c.getSystem().equals(system.primitiveValue()), "MEASURE_MR_SCORE_FIXED", c.getSystem());
                        } else {
                            this.rule(errors, ValidationMessage.IssueType.CODEINVALID, ms.line(), ms.col(), ns.getLiteralPath(), c.getSystem().equals(system.primitiveValue()), "MEASURE_MR_SCORE_FIXED", c.getSystem());
                        }
                    }
                } else if (c != null) {
                    this.rule(errors, ValidationMessage.IssueType.NOTFOUND, ms.line(), ms.col(), ns.getLiteralPath(), false, "MEASURE_MR_SCORE_FIXED", gen.gen(c));
                }
            }
        }
    }

    private void banned(List<ValidationMessage> errors, NodeStack stack, org.hl7.fhir.r5.elementmodel.Element parent, String childName, String msgId, Object ... params) {
        org.hl7.fhir.r5.elementmodel.Element child = parent.getNamedChild(childName);
        this.banned(errors, stack, child, msgId, params);
    }

    private void banned(List<ValidationMessage> errors, NodeStack stack, org.hl7.fhir.r5.elementmodel.Element e, String msgId, Object ... params) {
        if (e != null) {
            NodeStack ns = stack.push(e, -1, e.getProperty().getDefinition(), e.getProperty().getDefinition());
            this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, e.line(), e.col(), ns.getLiteralPath(), false, msgId, params);
        }
    }

    private void validateMeasureReportGroupPopulations(ValidatorHostContext hostContext, MeasureContext m, Measure.MeasureGroupComponent mg, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element mrg, NodeStack stack, boolean inProgress, NarrativeGenerator gen) {
        ArrayList<Measure.MeasureGroupPopulationComponent> pops = new ArrayList<Measure.MeasureGroupPopulationComponent>();
        List plist = mrg.getChildrenByName("population");
        int i = 0;
        for (org.hl7.fhir.r5.elementmodel.Element mrgp : plist) {
            NodeStack ns = stack.push(mrgp, i, mrgp.getProperty().getDefinition(), mrgp.getProperty().getDefinition());
            CodeableConcept cc = ObjectConverter.readAsCodeableConcept((org.hl7.fhir.r5.elementmodel.Element)mrgp.getNamedChild("code"));
            if (this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, mrgp.line(), mrgp.col(), ns.getLiteralPath(), cc != null, "MEASURE_MR_GRP_POP_NO_CODE", new Object[0])) {
                Measure.MeasureGroupPopulationComponent mgp = this.getGroupPopForCode(cc, mg);
                if (this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, mrg.line(), mrg.col(), ns.getLiteralPath(), mgp != null, "MEASURE_MR_GRP_POP_UNK_CODE", new Object[0]) && this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, mrg.line(), mrg.col(), ns.getLiteralPath(), !pops.contains(mgp), "MEASURE_MR_GRP_POP_DUPL_CODE", new Object[0])) {
                    pops.add(mgp);
                    this.validateMeasureReportGroupPopulation(hostContext, m, mgp, errors, mrgp, ns, inProgress);
                }
            }
            ++i;
        }
        for (Measure.MeasureGroupPopulationComponent mgp : mg.getPopulation()) {
            if (pops.contains(mgp) || mgp.getCode().hasCoding("http://terminology.hl7.org/CodeSystem/measure-population", "measure-observation")) continue;
            this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, mrg.line(), mrg.col(), stack.getLiteralPath(), pops.contains(mg), "MEASURE_MR_GRP_MISSING_BY_CODE", gen.gen(mgp.getCode()));
        }
    }

    private void validateMeasureReportGroupPopulation(ValidatorHostContext hostContext, MeasureContext m, Measure.MeasureGroupPopulationComponent mgp, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element mrgp, NodeStack ns, boolean inProgress) {
        List sr = mrgp.getChildrenByName("subjectResults");
        if ("subject-list".equals(m.reportType())) {
            try {
                int c = Integer.parseInt(mrgp.getChildValue("count"));
                this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, mrgp.line(), mrgp.col(), ns.getLiteralPath(), c == sr.size(), "MEASURE_MR_GRP_POP_COUNT_MISMATCH", c, sr.size());
            }
            catch (Exception exception) {}
        } else {
            this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, mrgp.line(), mrgp.col(), ns.getLiteralPath(), sr.size() == 0, "MEASURE_MR_GRP_POP_NO_SUBJECTS", new Object[0]);
            this.warning(errors, ValidationMessage.IssueType.BUSINESSRULE, mrgp.line(), mrgp.col(), ns.getLiteralPath(), mrgp.hasChild("count"), "MEASURE_MR_GRP_POP_NO_COUNT", new Object[0]);
        }
    }

    private void validateMeasureReportGroupStratifiers(ValidatorHostContext hostContext, MeasureContext m, Measure.MeasureGroupComponent mg, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element mrg, NodeStack stack, boolean inProgress, NarrativeGenerator gen) {
        ArrayList<Measure.MeasureGroupStratifierComponent> strats = new ArrayList<Measure.MeasureGroupStratifierComponent>();
        List slist = mrg.getChildrenByName("stratifier");
        int i = 0;
        for (org.hl7.fhir.r5.elementmodel.Element mrgs : slist) {
            NodeStack ns = stack.push(mrgs, i, mrgs.getProperty().getDefinition(), mrgs.getProperty().getDefinition());
            CodeableConcept cc = ObjectConverter.readAsCodeableConcept((org.hl7.fhir.r5.elementmodel.Element)mrgs.getNamedChild("code"));
            if (this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, mrgs.line(), mrgs.col(), ns.getLiteralPath(), cc != null, "MEASURE_MR_GRP_POP_NO_CODE", new Object[0])) {
                Measure.MeasureGroupStratifierComponent mgs = this.getGroupStratifierForCode(cc, mg);
                if (this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, mrg.line(), mrg.col(), ns.getLiteralPath(), mgs != null, "MEASURE_MR_GRP_POP_UNK_CODE", new Object[0]) && this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, mrg.line(), mrg.col(), ns.getLiteralPath(), !strats.contains(mgs), "MEASURE_MR_GRP_POP_DUPL_CODE", new Object[0])) {
                    strats.add(mgs);
                    this.validateMeasureReportGroupStratifier(hostContext, m, mgs, errors, mrgs, ns, inProgress);
                }
            }
            ++i;
        }
        for (Measure.MeasureGroupStratifierComponent mgs : mg.getStratifier()) {
            if (strats.contains(mgs)) continue;
            this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, mrg.line(), mrg.col(), stack.getLiteralPath(), strats.contains(mg), "MEASURE_MR_GRP_MISSING_BY_CODE", gen.gen(mgs.getCode()));
        }
    }

    private void validateMeasureReportGroupStratifier(ValidatorHostContext hostContext, MeasureContext m, Measure.MeasureGroupStratifierComponent mgs, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element mrgs, NodeStack ns, boolean inProgress) {
    }

    private Measure.MeasureGroupStratifierComponent getGroupStratifierForCode(CodeableConcept cc, Measure.MeasureGroupComponent mg) {
        for (Measure.MeasureGroupStratifierComponent t : mg.getStratifier()) {
            if (!t.hasCode()) continue;
            for (Coding c : t.getCode().getCoding()) {
                if (!cc.hasCoding(c.getSystem(), c.getCode())) continue;
                return t;
            }
            if (cc.hasCoding() || t.getCode().hasCoding() || !cc.hasText() || !t.getCode().hasText() || !cc.getText().equals(t.getCode().getText())) continue;
            return t;
        }
        return null;
    }

    private boolean hasUseableCode(CodeableConcept cc) {
        for (Coding c : cc.getCoding()) {
            if (!c.hasSystem() || !c.hasCode()) continue;
            return true;
        }
        return false;
    }

    private Measure.MeasureGroupPopulationComponent getGroupPopForCode(CodeableConcept cc, Measure.MeasureGroupComponent mg) {
        for (Measure.MeasureGroupPopulationComponent t : mg.getPopulation()) {
            if (!t.hasCode()) continue;
            for (Coding c : t.getCode().getCoding()) {
                if (!cc.hasCoding(c.getSystem(), c.getCode())) continue;
                return t;
            }
        }
        return null;
    }

    private Measure.MeasureGroupComponent getGroupForCode(CodeableConcept cc, Measure m) {
        for (Measure.MeasureGroupComponent t : m.getGroup()) {
            if (!t.hasCode()) continue;
            for (Coding c : t.getCode().getCoding()) {
                if (!cc.hasCoding(c.getSystem(), c.getCode())) continue;
                return t;
            }
        }
        return null;
    }
}

