/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.validation;

import ca.uhn.fhir.util.ObjectUtil;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.convertors.VersionConvertor_10_50;
import org.hl7.fhir.convertors.VersionConvertor_14_50;
import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.dstu2016may.formats.JsonParser;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.PathEngineException;
import org.hl7.fhir.exceptions.TerminologyServiceException;
import org.hl7.fhir.r5.conformance.ProfileUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.elementmodel.ObjectConverter;
import org.hl7.fhir.r5.elementmodel.ParserBase;
import org.hl7.fhir.r5.elementmodel.XmlParser;
import org.hl7.fhir.r5.formats.FormatUtilities;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.model.Address;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Base64BinaryType;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.ExpressionNode;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.FhirPublication;
import org.hl7.fhir.r5.model.HumanName;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.OidType;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Ratio;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.SampledData;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.TimeType;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.Type;
import org.hl7.fhir.r5.model.TypeDetails;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UuidType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.ValueSetUtilities;
import org.hl7.fhir.r5.utils.FHIRLexer;
import org.hl7.fhir.r5.utils.FHIRPathEngine;
import org.hl7.fhir.r5.utils.IResourceValidator;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.r5.utils.ValidationProfileSet;
import org.hl7.fhir.r5.validation.BaseValidator;
import org.hl7.fhir.r5.validation.EnableWhenEvaluator;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.TerminologyServiceOptions;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InstanceValidator
extends BaseValidator
implements IResourceValidator {
    private IWorkerContext context;
    private FHIRPathEngine fpe;
    private IResourceValidator.CheckDisplayOption checkDisplay;
    private boolean anyExtensionsAllowed;
    private boolean errorForUnknownProfiles;
    private boolean noInvariantChecks;
    private boolean noTerminologyChecks;
    private boolean hintAboutNonMustSupport;
    private IResourceValidator.BestPracticeWarningLevel bpWarnings;
    private String validationLanguage;
    private List<String> extensionDomains = new ArrayList<String>();
    private IResourceValidator.IdStatus resourceIdRule;
    private boolean allowXsiLocation;
    private boolean suppressLoincSnomedMessages;
    private long overall = 0L;
    private long txTime = 0L;
    private long sdTime = 0L;
    private long loadTime = 0L;
    private long fpeTime = 0L;
    private boolean noBindingMsgSuppressed;
    private HashMap<org.hl7.fhir.r5.elementmodel.Element, ResourceProfiles> resourceProfilesMap;
    private IResourceValidator.IValidatorResourceFetcher fetcher;
    long time = 0L;
    private ValidationProfileSet providedProfiles;
    private FHIRPathEngine.IEvaluationContext externalHostServices;
    private boolean noExtensibleWarnings;
    private String serverBase;
    private EnableWhenEvaluator myEnableWhenEvaluator = new EnableWhenEvaluator();
    private String executionId;
    public static final String URI_REGEX3 = "((http|https)://([A-Za-z0-9\\\\\\.\\:\\%\\$]*\\/)*)?(Account|ActivityDefinition|AllergyIntolerance|AdverseEvent|Appointment|AppointmentResponse|AuditEvent|Basic|Binary|BodySite|Bundle|CapabilityStatement|CarePlan|CareTeam|ChargeItem|Claim|ClaimResponse|ClinicalImpression|CodeSystem|Communication|CommunicationRequest|CompartmentDefinition|Composition|ConceptMap|Condition (aka Problem)|Consent|Contract|Coverage|DataElement|DetectedIssue|Device|DeviceComponent|DeviceMetric|DeviceRequest|DeviceUseStatement|DiagnosticReport|DocumentManifest|DocumentReference|EligibilityRequest|EligibilityResponse|Encounter|Endpoint|EnrollmentRequest|EnrollmentResponse|EpisodeOfCare|ExpansionProfile|ExplanationOfBenefit|FamilyMemberHistory|Flag|Goal|GraphDefinition|Group|GuidanceResponse|HealthcareService|ImagingManifest|ImagingStudy|Immunization|ImmunizationRecommendation|ImplementationGuide|Library|Linkage|List|Location|Measure|MeasureReport|Media|Medication|MedicationAdministration|MedicationDispense|MedicationRequest|MedicationStatement|MessageDefinition|MessageHeader|NamingSystem|NutritionOrder|Observation|OperationDefinition|OperationOutcome|Organization|Parameters|Patient|PaymentNotice|PaymentReconciliation|Person|PlanDefinition|Practitioner|PractitionerRole|Procedure|ProcedureRequest|ProcessRequest|ProcessResponse|Provenance|Questionnaire|QuestionnaireResponse|ReferralRequest|RelatedPerson|RequestGroup|ResearchStudy|ResearchSubject|RiskAssessment|Schedule|SearchParameter|Sequence|ServiceDefinition|Slot|Specimen|StructureDefinition|StructureMap|Subscription|Substance|SupplyDelivery|SupplyRequest|Task|TestScript|TestReport|ValueSet|VisionPrescription)\\/[A-Za-z0-9\\-\\.]{1,64}(\\/_history\\/[A-Za-z0-9\\-\\.]{1,64})?";
    private static final String EXECUTED_CONSTRAINT_LIST = "validator.executed.invariant.list";
    private static final String EXECUTION_ID = "validator.execution.id";

    public InstanceValidator(IWorkerContext theContext, FHIRPathEngine.IEvaluationContext hostServices) {
        this.context = theContext;
        this.externalHostServices = hostServices;
        this.fpe = new FHIRPathEngine(this.context);
        this.fpe.setHostServices((FHIRPathEngine.IEvaluationContext)new ValidatorHostServices());
        if (theContext.getVersion().startsWith("3.0") || theContext.getVersion().startsWith("1.0")) {
            this.fpe.setLegacyMode(true);
        }
        this.source = ValidationMessage.Source.InstanceValidator;
    }

    public boolean isNoExtensibleWarnings() {
        return this.noExtensibleWarnings;
    }

    public IResourceValidator setNoExtensibleWarnings(boolean noExtensibleWarnings) {
        this.noExtensibleWarnings = noExtensibleWarnings;
        return this;
    }

    public boolean isNoInvariantChecks() {
        return this.noInvariantChecks;
    }

    public IResourceValidator setNoInvariantChecks(boolean value) {
        this.noInvariantChecks = value;
        return this;
    }

    public IResourceValidator.IValidatorResourceFetcher getFetcher() {
        return this.fetcher;
    }

    public IResourceValidator setFetcher(IResourceValidator.IValidatorResourceFetcher value) {
        this.fetcher = value;
        return this;
    }

    public boolean isHintAboutNonMustSupport() {
        return this.hintAboutNonMustSupport;
    }

    public void setHintAboutNonMustSupport(boolean hintAboutNonMustSupport) {
        this.hintAboutNonMustSupport = hintAboutNonMustSupport;
    }

    private boolean allowUnknownExtension(String url) {
        if (url.contains("example.org") || url.contains("acme.com") || url.contains("nema.org") || url.startsWith("http://hl7.org/fhir/tools/StructureDefinition/") || url.equals("http://hl7.org/fhir/StructureDefinition/structuredefinition-expression")) {
            return true;
        }
        for (String s : this.extensionDomains) {
            if (!url.startsWith(s)) continue;
            return true;
        }
        return this.anyExtensionsAllowed;
    }

    private boolean isKnownExtension(String url) {
        if (url.contains("example.org") || url.contains("acme.com") || url.contains("nema.org") || url.startsWith("http://hl7.org/fhir/tools/StructureDefinition/") || url.equals("http://hl7.org/fhir/StructureDefinition/structuredefinition-expression") || url.equals("http://hl7.org/fhir/4.0/StructureDefinition/extension-ImplentationGuide.dependency.packageId")) {
            return true;
        }
        for (String s : this.extensionDomains) {
            if (!url.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    private void bpCheck(List<ValidationMessage> errors, ValidationMessage.IssueType invalid, int line, int col, String literalPath, boolean test, String message) {
        if (this.bpWarnings != null) {
            switch (this.bpWarnings) {
                case Error: {
                    this.rule(errors, invalid, line, col, literalPath, test, message, new Object[0]);
                    break;
                }
                case Warning: {
                    this.warning(errors, invalid, line, col, literalPath, test, message, new Object[0]);
                    break;
                }
                case Hint: {
                    this.hint(errors, invalid, line, col, literalPath, test, message);
                    break;
                }
            }
        }
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, InputStream stream, Manager.FhirFormat format) throws FHIRException {
        return this.validate(appContext, errors, stream, format, new ValidationProfileSet());
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, InputStream stream, Manager.FhirFormat format, String profile) throws FHIRException {
        return this.validate(appContext, errors, stream, format, new ValidationProfileSet(profile, true));
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, InputStream stream, Manager.FhirFormat format, StructureDefinition profile) throws FHIRException {
        return this.validate(appContext, errors, stream, format, new ValidationProfileSet(profile));
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, InputStream stream, Manager.FhirFormat format, ValidationProfileSet profiles) throws FHIRException {
        org.hl7.fhir.r5.elementmodel.Element e;
        ParserBase parser = Manager.makeParser((IWorkerContext)this.context, (Manager.FhirFormat)format);
        if (parser instanceof XmlParser) {
            ((XmlParser)parser).setAllowXsiLocation(this.allowXsiLocation);
        }
        parser.setupValidation(ParserBase.ValidationPolicy.EVERYTHING, errors);
        long t = System.nanoTime();
        try {
            e = parser.parse(stream);
        }
        catch (IOException e1) {
            throw new FHIRException((Throwable)e1);
        }
        this.loadTime = System.nanoTime() - t;
        if (e != null) {
            this.validate(appContext, errors, e, profiles);
        }
        return e;
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, Resource resource) throws FHIRException {
        return this.validate(appContext, errors, resource, new ValidationProfileSet());
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, Resource resource, String profile) throws FHIRException {
        return this.validate(appContext, errors, resource, new ValidationProfileSet(profile, true));
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, Resource resource, StructureDefinition profile) throws FHIRException {
        return this.validate(appContext, errors, resource, new ValidationProfileSet(profile));
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, Resource resource, ValidationProfileSet profiles) throws FHIRException {
        org.hl7.fhir.r5.elementmodel.Element e;
        long t = System.nanoTime();
        try {
            e = new ObjectConverter(this.context).convert(resource);
        }
        catch (IOException e1) {
            throw new FHIRException((Throwable)e1);
        }
        this.loadTime = System.nanoTime() - t;
        this.validate(appContext, errors, e, profiles);
        return e;
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, Element element) throws FHIRException {
        return this.validate(appContext, errors, element, new ValidationProfileSet());
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, Element element, String profile) throws FHIRException {
        return this.validate(appContext, errors, element, new ValidationProfileSet(profile, true));
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, Element element, StructureDefinition profile) throws FHIRException {
        return this.validate(appContext, errors, element, new ValidationProfileSet(profile));
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, Element element, ValidationProfileSet profiles) throws FHIRException {
        org.hl7.fhir.r5.elementmodel.Element e;
        XmlParser parser = new XmlParser(this.context);
        parser.setupValidation(ParserBase.ValidationPolicy.EVERYTHING, errors);
        long t = System.nanoTime();
        try {
            e = parser.parse(element);
        }
        catch (IOException e1) {
            throw new FHIRException((Throwable)e1);
        }
        this.loadTime = System.nanoTime() - t;
        if (e != null) {
            this.validate(appContext, errors, e, profiles);
        }
        return e;
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, Document document) throws FHIRException {
        return this.validate(appContext, errors, document, new ValidationProfileSet());
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, Document document, String profile) throws FHIRException {
        return this.validate(appContext, errors, document, new ValidationProfileSet(profile, true));
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, Document document, StructureDefinition profile) throws FHIRException {
        return this.validate(appContext, errors, document, new ValidationProfileSet(profile));
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, Document document, ValidationProfileSet profiles) throws FHIRException {
        org.hl7.fhir.r5.elementmodel.Element e;
        XmlParser parser = new XmlParser(this.context);
        parser.setupValidation(ParserBase.ValidationPolicy.EVERYTHING, errors);
        long t = System.nanoTime();
        try {
            e = parser.parse(document);
        }
        catch (IOException e1) {
            throw new FHIRException((Throwable)e1);
        }
        this.loadTime = System.nanoTime() - t;
        if (e != null) {
            this.validate(appContext, errors, e, profiles);
        }
        return e;
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, JsonObject object) throws FHIRException {
        return this.validate(appContext, errors, object, new ValidationProfileSet());
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, JsonObject object, String profile) throws FHIRException {
        return this.validate(appContext, errors, object, new ValidationProfileSet(profile, true));
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, JsonObject object, StructureDefinition profile) throws FHIRException {
        return this.validate(appContext, errors, object, new ValidationProfileSet(profile));
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, JsonObject object, ValidationProfileSet profiles) throws FHIRException {
        org.hl7.fhir.r5.elementmodel.JsonParser parser = new org.hl7.fhir.r5.elementmodel.JsonParser(this.context);
        parser.setupValidation(ParserBase.ValidationPolicy.EVERYTHING, errors);
        long t = System.nanoTime();
        org.hl7.fhir.r5.elementmodel.Element e = parser.parse(object);
        this.loadTime = System.nanoTime() - t;
        if (e != null) {
            this.validate(appContext, errors, e, profiles);
        }
        return e;
    }

    public void validate(Object appContext, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element) throws FHIRException {
        ValidationProfileSet profileSet = new ValidationProfileSet();
        this.validate(appContext, errors, element, profileSet);
    }

    private void validateRemainder(Object appContext, List<ValidationMessage> errors) throws IOException, FHIRException {
        boolean processedResource;
        do {
            processedResource = false;
            HashSet<org.hl7.fhir.r5.elementmodel.Element> keys = new HashSet<org.hl7.fhir.r5.elementmodel.Element>();
            keys.addAll(this.resourceProfilesMap.keySet());
            for (org.hl7.fhir.r5.elementmodel.Element resource : keys) {
                ResourceProfiles rp = this.resourceProfilesMap.get(resource);
                if (!rp.hasUncheckedProfiles()) continue;
                processedResource = true;
                this.start(new ValidatorHostContext(appContext), errors, rp.getOwner(), resource, null, rp.getStack());
            }
        } while (processedResource);
    }

    public void validate(Object appContext, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, String profile) throws FHIRException {
        this.validate(appContext, errors, element, new ValidationProfileSet(profile, true));
    }

    public void validate(Object appContext, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition profile) throws FHIRException {
        this.validate(appContext, errors, element, new ValidationProfileSet(profile));
    }

    public void validate(Object appContext, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, ValidationProfileSet profiles) throws FHIRException {
        this.providedProfiles = profiles;
        long t = System.nanoTime();
        boolean isRoot = false;
        if (this.resourceProfilesMap == null) {
            this.resourceProfilesMap = new HashMap();
            isRoot = true;
        }
        try {
            this.validateResource(new ValidatorHostContext(appContext, element), errors, element, element, null, profiles, this.resourceIdRule, new NodeStack(element), true);
            if (isRoot) {
                this.validateRemainder(appContext, errors);
                this.resourceProfilesMap = null;
                if (this.hintAboutNonMustSupport) {
                    this.checkElementUsage(errors, element, new NodeStack(element));
                }
            }
        }
        catch (IOException e) {
            throw new FHIRException((Throwable)e);
        }
        this.overall = System.nanoTime() - t;
    }

    private void checkElementUsage(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack) {
        String elementUsage = element.getUserString("elementSupported");
        this.hint(errors, ValidationMessage.IssueType.INFORMATIONAL, element.line(), element.col(), stack.getLiteralPath(), elementUsage == null || elementUsage.equals("Y"), String.format("The element %s is not marked as 'mustSupport' in the profile %s. Consider not using the element, or marking the element as must-Support in the profile", element.getName(), element.getProperty().getStructure().getUrl()));
        if (element.hasChildren()) {
            String prevName = "";
            int elementCount = 0;
            for (org.hl7.fhir.r5.elementmodel.Element ce : element.getChildren()) {
                if (ce.getName().equals(prevName)) {
                    ++elementCount;
                } else {
                    elementCount = 1;
                    prevName = ce.getName();
                }
                this.checkElementUsage(errors, ce, stack.push(ce, elementCount, null, null));
            }
        }
    }

    private boolean check(String v1, String v2) {
        return v1 == null ? Utilities.noString((String)v1) : v1.equals(v2);
    }

    private void checkAddress(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, Address fixed) {
        this.checkFixedValue(errors, path + ".use", focus.getNamedChild("use"), (org.hl7.fhir.r5.model.Element)fixed.getUseElement(), "use", focus);
        this.checkFixedValue(errors, path + ".text", focus.getNamedChild("text"), (org.hl7.fhir.r5.model.Element)fixed.getTextElement(), "text", focus);
        this.checkFixedValue(errors, path + ".city", focus.getNamedChild("city"), (org.hl7.fhir.r5.model.Element)fixed.getCityElement(), "city", focus);
        this.checkFixedValue(errors, path + ".state", focus.getNamedChild("state"), (org.hl7.fhir.r5.model.Element)fixed.getStateElement(), "state", focus);
        this.checkFixedValue(errors, path + ".country", focus.getNamedChild("country"), (org.hl7.fhir.r5.model.Element)fixed.getCountryElement(), "country", focus);
        this.checkFixedValue(errors, path + ".zip", focus.getNamedChild("zip"), (org.hl7.fhir.r5.model.Element)fixed.getPostalCodeElement(), "postalCode", focus);
        ArrayList lines = new ArrayList();
        focus.getNamedChildren("line", lines);
        if (this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, lines.size() == fixed.getLine().size(), "Expected " + Integer.toString(fixed.getLine().size()) + " but found " + Integer.toString(lines.size()) + " line elements", new Object[0])) {
            for (int i = 0; i < lines.size(); ++i) {
                this.checkFixedValue(errors, path + ".coding", (org.hl7.fhir.r5.elementmodel.Element)lines.get(i), (org.hl7.fhir.r5.model.Element)fixed.getLine().get(i), "coding", focus);
            }
        }
    }

    private void checkAttachment(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, Attachment fixed) {
        this.checkFixedValue(errors, path + ".contentType", focus.getNamedChild("contentType"), (org.hl7.fhir.r5.model.Element)fixed.getContentTypeElement(), "contentType", focus);
        this.checkFixedValue(errors, path + ".language", focus.getNamedChild("language"), (org.hl7.fhir.r5.model.Element)fixed.getLanguageElement(), "language", focus);
        this.checkFixedValue(errors, path + ".data", focus.getNamedChild("data"), (org.hl7.fhir.r5.model.Element)fixed.getDataElement(), "data", focus);
        this.checkFixedValue(errors, path + ".url", focus.getNamedChild("url"), (org.hl7.fhir.r5.model.Element)fixed.getUrlElement(), "url", focus);
        this.checkFixedValue(errors, path + ".size", focus.getNamedChild("size"), (org.hl7.fhir.r5.model.Element)fixed.getSizeElement(), "size", focus);
        this.checkFixedValue(errors, path + ".hash", focus.getNamedChild("hash"), (org.hl7.fhir.r5.model.Element)fixed.getHashElement(), "hash", focus);
        this.checkFixedValue(errors, path + ".title", focus.getNamedChild("title"), (org.hl7.fhir.r5.model.Element)fixed.getTitleElement(), "title", focus);
    }

    private boolean checkCode(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, String path, String code, String system, String display, boolean checkDisplay, NodeStack stack) throws TerminologyServiceException {
        long t = System.nanoTime();
        boolean ss = this.context.supportsSystem(system);
        this.txTime += System.nanoTime() - t;
        if (ss) {
            t = System.nanoTime();
            IWorkerContext.ValidationResult s = this.context.validateCode(new TerminologyServiceOptions(stack.workingLang), system, code, checkDisplay ? display : null);
            this.txTime += System.nanoTime() - t;
            if (s == null) {
                return true;
            }
            if (s.isOk()) {
                if (s.getMessage() != null) {
                    this.txWarning(errors, s.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, s == null, s.getMessage(), new Object[0]);
                }
                return true;
            }
            if (s.getErrorClass() != null && s.getErrorClass().isInfrastructure()) {
                this.txWarning(errors, s.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, s == null, s.getMessage(), new Object[0]);
            } else if (s.getSeverity() == ValidationMessage.IssueSeverity.INFORMATION) {
                this.txHint(errors, s.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, s == null, s.getMessage(), new Object[0]);
            } else if (s.getSeverity() == ValidationMessage.IssueSeverity.WARNING) {
                this.txWarning(errors, s.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, s == null, s.getMessage(), new Object[0]);
            } else {
                return this.txRule(errors, s.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, s == null, s.getMessage() + " for '" + system + "#" + code + "'", new Object[0]);
            }
            return true;
        }
        if (system.startsWith("http://hl7.org/fhir")) {
            if (Utilities.existsInList((String)system, (String[])new String[]{"http://hl7.org/fhir/sid/icd-10", "http://hl7.org/fhir/sid/cvx", "http://hl7.org/fhir/sid/icd-10-cm", "http://hl7.org/fhir/sid/icd-9", "http://hl7.org/fhir/sid/ndc", "http://hl7.org/fhir/sid/srt"})) {
                return true;
            }
            if (system.startsWith("http://hl7.org/fhir/test")) {
                return true;
            }
            CodeSystem cs = this.getCodeSystem(system);
            if (this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, cs != null, "Unknown Code System " + system, new Object[0])) {
                CodeSystem.ConceptDefinitionComponent def = this.getCodeDefinition(cs, code);
                if (this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, def != null, "Unknown Code (" + system + "#" + code + ")", new Object[0])) {
                    return this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, display == null || display.equals(def.getDisplay()), "Display should be '" + def.getDisplay() + "'", new Object[0]);
                }
            }
            return false;
        }
        if (this.context.isNoTerminologyServer() && Utilities.existsInList((String)system, (String[])new String[]{"http://loinc.org", "http://unitsofmeasure.org", "http://snomed.info/sct", "http://www.nlm.nih.gov/research/umls/rxnorm"})) {
            return true;
        }
        if (this.startsWithButIsNot(system, "http://snomed.info/sct", "http://loinc.org", "http://unitsofmeasure.org", "http://www.nlm.nih.gov/research/umls/rxnorm")) {
            this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Invalid System URI: " + system, new Object[0]);
            return false;
        }
        try {
            if (this.context.fetchResourceWithException(ValueSet.class, system) != null) {
                this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Invalid System URI: " + system + " - cannot use a value set URI as a system", new Object[0]);
            }
            return true;
        }
        catch (Exception e) {
            return true;
        }
    }

    private boolean startsWithButIsNot(String system, String ... uri) {
        for (String s : uri) {
            if (system.equals(s) || !system.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    private boolean hasErrors(List<ValidationMessage> errors) {
        if (errors != null) {
            for (ValidationMessage vm : errors) {
                if (vm.getLevel() != ValidationMessage.IssueSeverity.FATAL && vm.getLevel() != ValidationMessage.IssueSeverity.ERROR) continue;
                return true;
            }
        }
        return false;
    }

    private void checkCodeableConcept(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, CodeableConcept fixed, boolean pattern) {
        block7: {
            ArrayList codings;
            block6: {
                this.checkFixedValue(errors, path + ".text", focus.getNamedChild("text"), (org.hl7.fhir.r5.model.Element)fixed.getTextElement(), "text", focus);
                codings = new ArrayList();
                focus.getNamedChildren("coding", codings);
                if (!pattern) break block6;
                if (!this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, codings.size() >= fixed.getCoding().size(), "Expected " + Integer.toString(fixed.getCoding().size()) + " but found " + Integer.toString(codings.size()) + " coding elements", new Object[0])) break block7;
                for (int i = 0; i < fixed.getCoding().size(); ++i) {
                    Coding fixedCoding = (Coding)fixed.getCoding().get(i);
                    boolean found = false;
                    ArrayList allErrorsFixed = new ArrayList();
                    for (int j = 0; j < codings.size() && !found; ++j) {
                        ArrayList<ValidationMessage> errorsFixed = new ArrayList<ValidationMessage>();
                        this.checkFixedValue(errorsFixed, path + ".coding", (org.hl7.fhir.r5.elementmodel.Element)codings.get(j), (org.hl7.fhir.r5.model.Element)fixedCoding, "coding", focus);
                        if (!this.hasErrors(errorsFixed)) {
                            found = true;
                            continue;
                        }
                        errorsFixed.stream().filter(t -> t.getLevel().ordinal() >= ValidationMessage.IssueSeverity.ERROR.ordinal()).forEach(t -> allErrorsFixed.add(t));
                    }
                    if (found) continue;
                    String message = "Expected fixed CodeableConcept not found for system: " + fixedCoding.getSystemElement().asStringValue() + " code: " + fixedCoding.getCodeElement().asStringValue() + " display: " + fixedCoding.getDisplayElement().asStringValue();
                    if (fixedCoding.hasUserSelected()) {
                        message = message + " userSelected: " + fixedCoding.getUserSelected();
                    }
                    message = message + " - Issues: " + allErrorsFixed;
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, false, message, new Object[0]);
                }
                break block7;
            }
            if (this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, codings.size() == fixed.getCoding().size(), "Expected " + Integer.toString(fixed.getCoding().size()) + " but found " + Integer.toString(codings.size()) + " coding elements", new Object[0])) {
                for (int i = 0; i < codings.size(); ++i) {
                    this.checkFixedValue(errors, path + ".coding", (org.hl7.fhir.r5.elementmodel.Element)codings.get(i), (org.hl7.fhir.r5.model.Element)fixed.getCoding().get(i), "coding", focus);
                }
            }
        }
    }

    private boolean checkCodeableConcept(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition profile, ElementDefinition theElementCntext, NodeStack stack) {
        boolean res = true;
        if (!this.noTerminologyChecks && theElementCntext != null && theElementCntext.hasBinding()) {
            ElementDefinition.ElementDefinitionBindingComponent binding = theElementCntext.getBinding();
            if (this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, binding != null, "Binding for " + path + " missing (cc)", new Object[0])) {
                if (binding.hasValueSet()) {
                    ValueSet valueset = this.resolveBindingReference((DomainResource)profile, binding.getValueSet(), profile.getUrl());
                    if (this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, valueset != null, "ValueSet " + this.describeReference(binding.getValueSet()) + " not found by validator", new Object[0])) {
                        try {
                            CodeableConcept cc = ObjectConverter.readAsCodeableConcept((org.hl7.fhir.r5.elementmodel.Element)element);
                            if (!cc.hasCoding()) {
                                if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                                    this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "No code provided, and a code is required from the value set " + this.describeReference(binding.getValueSet()) + " (" + valueset.getUrl(), new Object[0]);
                                } else if (binding.getStrength() == Enumerations.BindingStrength.EXTENSIBLE) {
                                    if (binding.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")) {
                                        this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "No code provided, and a code must be provided from the value set " + this.describeReference(ToolingExtensions.readStringExtension((org.hl7.fhir.r5.model.Element)binding, (String)"http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")) + " (max value set " + valueset.getUrl() + ")", new Object[0]);
                                    } else {
                                        this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "No code provided, and a code should be provided from the value set " + this.describeReference(binding.getValueSet()) + " (" + valueset.getUrl() + ")", new Object[0]);
                                    }
                                }
                            } else {
                                long t = System.nanoTime();
                                boolean bindingsOk = true;
                                if (binding.getStrength() != Enumerations.BindingStrength.EXAMPLE) {
                                    boolean atLeastOneSystemIsSupported = false;
                                    for (Coding nextCoding : cc.getCoding()) {
                                        String nextSystem = nextCoding.getSystem();
                                        if (!StringUtils.isNotBlank((CharSequence)nextSystem) || !this.context.supportsSystem(nextSystem)) continue;
                                        atLeastOneSystemIsSupported = true;
                                        break;
                                    }
                                    if (atLeastOneSystemIsSupported || binding.getStrength() != Enumerations.BindingStrength.EXAMPLE) {
                                        IWorkerContext.ValidationResult vr = this.context.validateCode(new TerminologyServiceOptions(stack.workingLang), cc, valueset);
                                        res = false;
                                        if (!vr.isOk()) {
                                            bindingsOk = false;
                                            if (vr.getErrorClass() != null && vr.getErrorClass().isInfrastructure()) {
                                                if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                                                    this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Could not confirm that the codes provided are in the value set " + this.describeReference(binding.getValueSet()) + " and a code from this value set is required (class = " + vr.getErrorClass().toString() + ")", new Object[0]);
                                                } else if (binding.getStrength() == Enumerations.BindingStrength.EXTENSIBLE) {
                                                    if (binding.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")) {
                                                        this.checkMaxValueSet(errors, path, element, profile, ToolingExtensions.readStringExtension((org.hl7.fhir.r5.model.Element)binding, (String)"http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet"), cc, stack);
                                                    } else if (!this.noExtensibleWarnings) {
                                                        this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Could not confirm that the codes provided are in the value set " + this.describeReference(binding.getValueSet()) + " and a code should come from this value set unless it has no suitable code (class = " + vr.getErrorClass().toString() + ")", new Object[0]);
                                                    }
                                                } else if (binding.getStrength() == Enumerations.BindingStrength.PREFERRED) {
                                                    this.txHint(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Could not confirm that the codes provided are in the value set " + this.describeReference(binding.getValueSet()) + " and a code is recommended to come from this value set (class = " + vr.getErrorClass().toString() + ")", new Object[0]);
                                                }
                                            } else if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                                                this.txRule(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "None of the codes provided are in the value set " + this.describeReference(binding.getValueSet()) + " (" + valueset.getUrl() + ", and a code from this value set is required) (codes = " + this.ccSummary(cc) + ")", new Object[0]);
                                            } else if (binding.getStrength() == Enumerations.BindingStrength.EXTENSIBLE) {
                                                if (binding.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")) {
                                                    this.checkMaxValueSet(errors, path, element, profile, ToolingExtensions.readStringExtension((org.hl7.fhir.r5.model.Element)binding, (String)"http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet"), cc, stack);
                                                } else if (!this.noExtensibleWarnings) {
                                                    this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "None of the codes provided are in the value set " + this.describeReference(binding.getValueSet()) + " (" + valueset.getUrl() + ", and a code should come from this value set unless it has no suitable code) (codes = " + this.ccSummary(cc) + ")", new Object[0]);
                                                }
                                            } else if (binding.getStrength() == Enumerations.BindingStrength.PREFERRED) {
                                                this.txHint(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "None of the codes provided are in the value set " + this.describeReference(binding.getValueSet()) + " (" + valueset.getUrl() + ", and a code is recommended to come from this value set) (codes = " + this.ccSummary(cc) + ")", new Object[0]);
                                            }
                                        } else if (vr.getMessage() != null) {
                                            this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, vr.getMessage(), new Object[0]);
                                        }
                                    }
                                    if (bindingsOk) {
                                        for (Coding nextCoding : cc.getCoding()) {
                                            IWorkerContext.ValidationResult vr;
                                            String nextCode = nextCoding.getCode();
                                            String nextSystem = nextCoding.getSystem();
                                            if (!StringUtils.isNotBlank((CharSequence)nextCode) || !StringUtils.isNotBlank((CharSequence)nextSystem) || !this.context.supportsSystem(nextSystem) || (vr = this.context.validateCode(new TerminologyServiceOptions(stack.workingLang), nextSystem, nextCode, null)).isOk()) continue;
                                            this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Code {0} is not a valid code in code system {1}", nextCode, nextSystem);
                                        }
                                    }
                                    this.txTime += System.nanoTime() - t;
                                }
                            }
                        }
                        catch (Exception e) {
                            this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Error " + e.getMessage() + " validating CodeableConcept", new Object[0]);
                        }
                    }
                } else if (binding.hasValueSet()) {
                    this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Binding by URI reference cannot be checked");
                } else if (!this.noBindingMsgSuppressed) {
                    this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Binding for path " + path + " has no source, so can't be checked");
                }
            }
        }
        return res;
    }

    private void checkMaxValueSet(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition profile, String maxVSUrl, CodeableConcept cc, NodeStack stack) {
        ValueSet valueset = this.resolveBindingReference((DomainResource)profile, maxVSUrl, profile.getUrl());
        if (this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, valueset != null, "ValueSet " + this.describeReference(maxVSUrl) + " not found by validator", new Object[0])) {
            try {
                long t = System.nanoTime();
                IWorkerContext.ValidationResult vr = this.context.validateCode(new TerminologyServiceOptions(stack.workingLang), cc, valueset);
                this.txTime += System.nanoTime() - t;
                if (!vr.isOk()) {
                    if (vr.getErrorClass() != null && vr.getErrorClass().isInfrastructure()) {
                        this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "None of the codes provided could be validated against the maximum value set " + this.describeReference(maxVSUrl) + " (" + valueset.getUrl() + "), (error = " + vr.getMessage() + ")", new Object[0]);
                    } else {
                        this.txRule(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "None of the codes provided are in the maximum value set " + this.describeReference(maxVSUrl) + " (" + valueset.getUrl() + ", and a code from this value set is required) (codes = " + this.ccSummary(cc) + ")", new Object[0]);
                    }
                }
            }
            catch (Exception e) {
                this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Error " + e.getMessage() + " validating CodeableConcept using maxValueSet", new Object[0]);
            }
        }
    }

    private void checkMaxValueSet(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition profile, String maxVSUrl, Coding c, NodeStack stack) {
        ValueSet valueset = this.resolveBindingReference((DomainResource)profile, maxVSUrl, profile.getUrl());
        if (this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, valueset != null, "ValueSet " + this.describeReference(maxVSUrl) + " not found by validator", new Object[0])) {
            try {
                long t = System.nanoTime();
                IWorkerContext.ValidationResult vr = this.context.validateCode(new TerminologyServiceOptions(stack.workingLang), c, valueset);
                this.txTime += System.nanoTime() - t;
                if (!vr.isOk()) {
                    if (vr.getErrorClass() != null && vr.getErrorClass().isInfrastructure()) {
                        this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "The code provided could not be validated against the maximum value set " + this.describeReference(maxVSUrl) + " (" + valueset.getUrl() + "), (error = " + vr.getMessage() + ")", new Object[0]);
                    } else {
                        this.txRule(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "The code provided is not in the maximum value set " + this.describeReference(maxVSUrl) + " (" + valueset.getUrl() + ", and a code from this value set is required) (code = " + c.getSystem() + "#" + c.getCode() + ")", new Object[0]);
                    }
                }
            }
            catch (Exception e) {
                this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Error " + e.getMessage() + " validating CodeableConcept using maxValueSet", new Object[0]);
            }
        }
    }

    private void checkMaxValueSet(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition profile, String maxVSUrl, String value, NodeStack stack) {
        ValueSet valueset = this.resolveBindingReference((DomainResource)profile, maxVSUrl, profile.getUrl());
        if (this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, valueset != null, "ValueSet " + this.describeReference(maxVSUrl) + " not found by validator", new Object[0])) {
            try {
                long t = System.nanoTime();
                IWorkerContext.ValidationResult vr = this.context.validateCode(new TerminologyServiceOptions(stack.workingLang), value, valueset);
                this.txTime += System.nanoTime() - t;
                if (!vr.isOk()) {
                    if (vr.getErrorClass() != null && vr.getErrorClass().isInfrastructure()) {
                        this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "The code provided could not be validated against the maximum value set " + this.describeReference(maxVSUrl) + " (" + valueset.getUrl() + "), (error = " + vr.getMessage() + ")", new Object[0]);
                    } else {
                        this.txRule(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "The code provided is not in the maximum value set " + this.describeReference(maxVSUrl) + " (" + valueset.getUrl() + "), and a code from this value set is required) (code = " + value + "), (error = " + vr.getMessage() + ")", new Object[0]);
                    }
                }
            }
            catch (Exception e) {
                this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Error " + e.getMessage() + " validating CodeableConcept using maxValueSet", new Object[0]);
            }
        }
    }

    private String ccSummary(CodeableConcept cc) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (Coding c : cc.getCoding()) {
            b.append(c.getSystem() + "#" + c.getCode());
        }
        return b.toString();
    }

    private void checkCoding(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, Coding fixed) {
        this.checkFixedValue(errors, path + ".system", focus.getNamedChild("system"), (org.hl7.fhir.r5.model.Element)fixed.getSystemElement(), "system", focus);
        this.checkFixedValue(errors, path + ".code", focus.getNamedChild("code"), (org.hl7.fhir.r5.model.Element)fixed.getCodeElement(), "code", focus);
        this.checkFixedValue(errors, path + ".display", focus.getNamedChild("display"), (org.hl7.fhir.r5.model.Element)fixed.getDisplayElement(), "display", focus);
        this.checkFixedValue(errors, path + ".userSelected", focus.getNamedChild("userSelected"), (org.hl7.fhir.r5.model.Element)fixed.getUserSelectedElement(), "userSelected", focus);
    }

    private void checkCoding(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition profile, ElementDefinition theElementCntext, boolean inCodeableConcept, boolean checkDisplay, NodeStack stack) {
        block30: {
            String code = element.getNamedChildValue("code");
            String system = element.getNamedChildValue("system");
            String display = element.getNamedChildValue("display");
            this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, this.isAbsolute(system), "Coding.system must be an absolute reference, not a local reference", new Object[0]);
            if (system != null && code != null && !this.noTerminologyChecks) {
                this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, !this.isValueSet(system), "The Coding references a value set, not a code system (\"" + system + "\")", new Object[0]);
                try {
                    if (!this.checkCode(errors, element, path, code, system, display, checkDisplay, stack) || theElementCntext == null || !theElementCntext.hasBinding()) break block30;
                    ElementDefinition.ElementDefinitionBindingComponent binding = theElementCntext.getBinding();
                    if (!this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, binding != null, "Binding for " + path + " missing", new Object[0])) break block30;
                    if (binding.hasValueSet()) {
                        ValueSet valueset = this.resolveBindingReference((DomainResource)profile, binding.getValueSet(), profile.getUrl());
                        if (!this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, valueset != null, "ValueSet " + this.describeReference(binding.getValueSet()) + " not found by validator", new Object[0])) break block30;
                        try {
                            Coding c = ObjectConverter.readAsCoding((org.hl7.fhir.r5.elementmodel.Element)element);
                            long t = System.nanoTime();
                            IWorkerContext.ValidationResult vr = null;
                            if (binding.getStrength() != Enumerations.BindingStrength.EXAMPLE) {
                                vr = this.context.validateCode(new TerminologyServiceOptions(stack.workingLang), c, valueset);
                            }
                            this.txTime += System.nanoTime() - t;
                            if (vr != null && !vr.isOk()) {
                                if (vr.IsNoService()) {
                                    this.txHint(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "The value provided could not be validated in the absence of a terminology server", new Object[0]);
                                } else if (vr.getErrorClass() != null && !vr.getErrorClass().isInfrastructure()) {
                                    if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                                        this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Could not confirm that the codes provided are in the value set " + this.describeReference(binding.getValueSet()) + " (" + valueset.getUrl() + ", and a code from this value set is required)", new Object[0]);
                                    } else if (binding.getStrength() == Enumerations.BindingStrength.EXTENSIBLE) {
                                        if (binding.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")) {
                                            this.checkMaxValueSet(errors, path, element, profile, ToolingExtensions.readStringExtension((org.hl7.fhir.r5.model.Element)binding, (String)"http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet"), c, stack);
                                        } else if (!this.noExtensibleWarnings) {
                                            this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Could not confirm that the codes provided are in the value set " + this.describeReference(binding.getValueSet()) + " (" + valueset.getUrl() + ", and a code should come from this value set unless it has no suitable code)", new Object[0]);
                                        }
                                    } else if (binding.getStrength() == Enumerations.BindingStrength.PREFERRED) {
                                        this.txHint(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Could not confirm that the codes provided are in the value set " + this.describeReference(binding.getValueSet()) + " (" + valueset.getUrl() + ", and a code is recommended to come from this value set)", new Object[0]);
                                    }
                                } else if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                                    this.txRule(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "The Coding provided is not in the value set " + this.describeReference(binding.getValueSet()) + " (" + valueset.getUrl() + ", and a code is required from this value set)" + (vr.getMessage() != null ? " (error message = " + vr.getMessage() + ")" : ""), new Object[0]);
                                } else if (binding.getStrength() == Enumerations.BindingStrength.EXTENSIBLE) {
                                    if (binding.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")) {
                                        this.checkMaxValueSet(errors, path, element, profile, ToolingExtensions.readStringExtension((org.hl7.fhir.r5.model.Element)binding, (String)"http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet"), c, stack);
                                    } else {
                                        this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "The Coding provided is not in the value set " + this.describeReference(binding.getValueSet()) + " (" + valueset.getUrl() + ", and a code should come from this value set unless it has no suitable code)" + (vr.getMessage() != null ? " (error message = " + vr.getMessage() + ")" : ""), new Object[0]);
                                    }
                                } else if (binding.getStrength() == Enumerations.BindingStrength.PREFERRED) {
                                    this.txHint(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "The Coding provided is not in the value set " + this.describeReference(binding.getValueSet()) + " (" + valueset.getUrl() + ", and a code is recommended to come from this value set)" + (vr.getMessage() != null ? " (error message = " + vr.getMessage() + ")" : ""), new Object[0]);
                                }
                            }
                            break block30;
                        }
                        catch (Exception e) {
                            this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Error " + e.getMessage() + " validating Coding", new Object[0]);
                        }
                        break block30;
                    }
                    if (binding.hasValueSet()) {
                        this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Binding by URI reference cannot be checked");
                    } else if (!inCodeableConcept && !this.noBindingMsgSuppressed) {
                        this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Binding for path " + path + " has no source, so can't be checked");
                    }
                }
                catch (Exception e) {
                    this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Error " + e.getMessage() + " validating Coding: " + e.toString(), new Object[0]);
                }
            }
        }
    }

    private boolean isValueSet(String url) {
        try {
            ValueSet vs = (ValueSet)this.context.fetchResourceWithException(ValueSet.class, url);
            return vs != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void checkContactPoint(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, ContactPoint fixed) {
        this.checkFixedValue(errors, path + ".system", focus.getNamedChild("system"), (org.hl7.fhir.r5.model.Element)fixed.getSystemElement(), "system", focus);
        this.checkFixedValue(errors, path + ".value", focus.getNamedChild("value"), (org.hl7.fhir.r5.model.Element)fixed.getValueElement(), "value", focus);
        this.checkFixedValue(errors, path + ".use", focus.getNamedChild("use"), (org.hl7.fhir.r5.model.Element)fixed.getUseElement(), "use", focus);
        this.checkFixedValue(errors, path + ".period", focus.getNamedChild("period"), (org.hl7.fhir.r5.model.Element)fixed.getPeriod(), "period", focus);
    }

    protected void checkDeclaredProfiles(ResourceProfiles resourceProfiles, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack) throws FHIRException {
        org.hl7.fhir.r5.elementmodel.Element meta = element.getNamedChild("meta");
        if (meta != null) {
            ArrayList profiles = new ArrayList();
            meta.getNamedChildren("profile", profiles);
            int i = 0;
            for (org.hl7.fhir.r5.elementmodel.Element profile : profiles) {
                String ref = profile.primitiveValue();
                String p = stack.addToLiteralPath("meta", "profile", ":" + Integer.toString(i));
                if (!this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), p, !Utilities.noString((String)ref), "StructureDefinition reference invalid", new Object[0])) continue;
                long t = System.nanoTime();
                resourceProfiles.addProfile(errors, ref, this.errorForUnknownProfiles, p, element, null);
                ++i;
            }
        }
    }

    private StructureDefinition checkExtension(ValidatorHostContext hostContext, List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element element, ElementDefinition def, StructureDefinition profile, NodeStack stack) throws FHIRException, IOException {
        String url = element.getNamedChildValue("url");
        boolean isModifier = element.getName().equals("modifierExtension");
        long t = System.nanoTime();
        StructureDefinition ex = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, url);
        this.sdTime += System.nanoTime() - t;
        if (ex == null) {
            if (!url.startsWith("http://hl7.org/fhir/4.0/StructureDefinition/extension-") && this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, this.allowUnknownExtension(url), "The extension " + url + " is unknown, and not allowed here", new Object[0])) {
                this.hint(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, this.isKnownExtension(url), "Unknown extension " + url);
            }
        } else {
            if (def.getIsModifier()) {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path + "[url='" + url + "']", ((ElementDefinition)ex.getSnapshot().getElement().get(0)).getIsModifier(), "Extension modifier mismatch: the extension element is labelled as a modifier, but the underlying extension is not", new Object[0]);
            } else {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path + "[url='" + url + "']", !((ElementDefinition)ex.getSnapshot().getElement().get(0)).getIsModifier(), "Extension modifier mismatch: the extension element is not labelled as a modifier, but the underlying extension is", new Object[0]);
            }
            this.checkExtensionContext(errors, element, ex, stack, ex.getUrl());
            if (isModifier) {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path + "[url='" + url + "']", ((ElementDefinition)ex.getSnapshot().getElement().get(0)).getIsModifier(), "The Extension '" + url + "' must be used as a modifierExtension", new Object[0]);
            } else {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path + "[url='" + url + "']", !((ElementDefinition)ex.getSnapshot().getElement().get(0)).getIsModifier(), "The Extension '" + url + "' must not be used as an extension (it's a modifierExtension)", new Object[0]);
            }
            Set<String> allowedTypes = this.listExtensionTypes(ex);
            String actualType = this.getExtensionType(element);
            if (actualType == null) {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path + "[url='" + url + "']", allowedTypes.isEmpty(), "The Extension '" + url + "' definition is for a simple extension, so it must contain a value, not extensions", new Object[0]);
            } else {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path + "[url='" + url + "']", allowedTypes.contains(actualType), "The Extension '" + url + "' definition allows for the types " + allowedTypes.toString() + " but found type " + actualType, new Object[0]);
            }
            this.validateElement(hostContext, errors, ex, (ElementDefinition)ex.getSnapshot().getElement().get(0), null, null, resource, element, "Extension", stack, false, true);
        }
        return ex;
    }

    private String getExtensionType(org.hl7.fhir.r5.elementmodel.Element element) {
        for (org.hl7.fhir.r5.elementmodel.Element e : element.getChildren()) {
            if (!e.getName().startsWith("value")) continue;
            String tn = e.getName().substring(5);
            String ltn = Utilities.uncapitalize((String)tn);
            if (this.isPrimitiveType(ltn)) {
                return ltn;
            }
            return tn;
        }
        return null;
    }

    private Set<String> listExtensionTypes(StructureDefinition ex) {
        ElementDefinition vd = null;
        for (ElementDefinition ed : ex.getSnapshot().getElement()) {
            if (!ed.getPath().startsWith("Extension.value")) continue;
            vd = ed;
            break;
        }
        HashSet<String> res = new HashSet<String>();
        if (vd != null && !"0".equals(vd.getMax())) {
            for (ElementDefinition.TypeRefComponent tr : vd.getType()) {
                res.add(tr.getWorkingCode());
            }
        }
        return res;
    }

    private boolean checkExtensionContext(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition definition, NodeStack stack, String extensionParent) {
        return true;
    }

    private void checkFixedValue(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, org.hl7.fhir.r5.model.Element fixed, String propName, org.hl7.fhir.r5.elementmodel.Element parent) {
        this.checkFixedValue(errors, path, focus, fixed, propName, parent, false);
    }

    private void checkFixedValue(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, org.hl7.fhir.r5.model.Element fixed, String propName, org.hl7.fhir.r5.elementmodel.Element parent, boolean pattern) {
        if (fixed != null && !fixed.isEmpty() || focus != null) {
            if (fixed == null && focus != null) {
                this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, false, "Unexpected element " + focus.getName(), new Object[0]);
            } else if (fixed != null && !fixed.isEmpty() && focus == null) {
                this.rule(errors, ValidationMessage.IssueType.VALUE, parent == null ? -1 : parent.line(), parent == null ? -1 : parent.col(), path, false, "Missing element '" + propName + "'", new Object[0]);
            } else {
                String value = focus.primitiveValue();
                if (fixed instanceof BooleanType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((BooleanType)fixed).asStringValue(), value), "Value is '" + value + "' but must be '" + ((BooleanType)fixed).asStringValue() + "'", new Object[0]);
                } else if (fixed instanceof IntegerType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((IntegerType)fixed).asStringValue(), value), "Value is '" + value + "' but must be '" + ((IntegerType)fixed).asStringValue() + "'", new Object[0]);
                } else if (fixed instanceof DecimalType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((DecimalType)fixed).asStringValue(), value), "Value is '" + value + "' but must be '" + ((DecimalType)fixed).asStringValue() + "'", new Object[0]);
                } else if (fixed instanceof Base64BinaryType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((Base64BinaryType)fixed).asStringValue(), value), "Value is '" + value + "' but must be '" + ((Base64BinaryType)fixed).asStringValue() + "'", new Object[0]);
                } else if (fixed instanceof InstantType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((Date)((InstantType)fixed).getValue()).toString(), value), "Value is '" + value + "' but must be '" + ((InstantType)fixed).asStringValue() + "'", new Object[0]);
                } else if (fixed instanceof CodeType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check((String)((CodeType)fixed).getValue(), value), "Value is '" + value + "' but must be '" + (String)((CodeType)fixed).getValue() + "'", new Object[0]);
                } else if (fixed instanceof Enumeration) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((Enumeration)fixed).asStringValue(), value), "Value is '" + value + "' but must be '" + ((Enumeration)fixed).asStringValue() + "'", new Object[0]);
                } else if (fixed instanceof StringType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check((String)((StringType)fixed).getValue(), value), "Value is '" + value + "' but must be '" + (String)((StringType)fixed).getValue() + "'", new Object[0]);
                } else if (fixed instanceof UriType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check((String)((UriType)fixed).getValue(), value), "Value is '" + value + "' but must be '" + (String)((UriType)fixed).getValue() + "'", new Object[0]);
                } else if (fixed instanceof DateType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((Date)((DateType)fixed).getValue()).toString(), value), "Value is '" + value + "' but must be '" + ((DateType)fixed).getValue() + "'", new Object[0]);
                } else if (fixed instanceof DateTimeType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((Date)((DateTimeType)fixed).getValue()).toString(), value), "Value is '" + value + "' but must be '" + ((DateTimeType)fixed).getValue() + "'", new Object[0]);
                } else if (fixed instanceof OidType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check((String)((OidType)fixed).getValue(), value), "Value is '" + value + "' but must be '" + (String)((OidType)fixed).getValue() + "'", new Object[0]);
                } else if (fixed instanceof UuidType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check((String)((UuidType)fixed).getValue(), value), "Value is '" + value + "' but must be '" + (String)((UuidType)fixed).getValue() + "'", new Object[0]);
                } else if (fixed instanceof IdType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((IdType)fixed).getValue(), value), "Value is '" + value + "' but must be '" + ((IdType)fixed).getValue() + "'", new Object[0]);
                } else if (fixed instanceof Quantity) {
                    this.checkQuantity(errors, path, focus, (Quantity)fixed);
                } else if (fixed instanceof Address) {
                    this.checkAddress(errors, path, focus, (Address)fixed);
                } else if (fixed instanceof ContactPoint) {
                    this.checkContactPoint(errors, path, focus, (ContactPoint)fixed);
                } else if (fixed instanceof Attachment) {
                    this.checkAttachment(errors, path, focus, (Attachment)fixed);
                } else if (fixed instanceof Identifier) {
                    this.checkIdentifier(errors, path, focus, (Identifier)fixed);
                } else if (fixed instanceof Coding) {
                    this.checkCoding(errors, path, focus, (Coding)fixed);
                } else if (fixed instanceof HumanName) {
                    this.checkHumanName(errors, path, focus, (HumanName)fixed);
                } else if (fixed instanceof CodeableConcept) {
                    this.checkCodeableConcept(errors, path, focus, (CodeableConcept)fixed, pattern);
                } else if (fixed instanceof Timing) {
                    this.checkTiming(errors, path, focus, (Timing)fixed);
                } else if (fixed instanceof Period) {
                    this.checkPeriod(errors, path, focus, (Period)fixed);
                } else if (fixed instanceof Range) {
                    this.checkRange(errors, path, focus, (Range)fixed);
                } else if (fixed instanceof Ratio) {
                    this.checkRatio(errors, path, focus, (Ratio)fixed);
                } else if (fixed instanceof SampledData) {
                    this.checkSampledData(errors, path, focus, (SampledData)fixed);
                } else {
                    this.rule(errors, ValidationMessage.IssueType.EXCEPTION, focus.line(), focus.col(), path, false, "Unhandled fixed value type " + fixed.getClass().getName(), new Object[0]);
                }
                ArrayList<org.hl7.fhir.r5.elementmodel.Element> extensions = new ArrayList<org.hl7.fhir.r5.elementmodel.Element>();
                focus.getNamedChildren("extension", extensions);
                if (fixed.getExtension().size() == 0) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, extensions.size() == 0, "No extensions allowed, as the specified fixed value doesn't contain any extensions", new Object[0]);
                } else if (this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, extensions.size() == fixed.getExtension().size(), "Extensions count mismatch: expected " + Integer.toString(fixed.getExtension().size()) + " but found " + Integer.toString(extensions.size()), new Object[0])) {
                    for (Extension e : fixed.getExtension()) {
                        org.hl7.fhir.r5.elementmodel.Element ex = this.getExtensionByUrl(extensions, e.getUrl());
                        if (!this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, ex != null, "Extension count mismatch: unable to find extension: " + e.getUrl(), new Object[0])) continue;
                        this.checkFixedValue(errors, path, ex.getNamedChild("extension").getNamedChild("value"), (org.hl7.fhir.r5.model.Element)e.getValue(), "extension.value", ex.getNamedChild("extension"));
                    }
                }
            }
        }
    }

    private void checkHumanName(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, HumanName fixed) {
        int i;
        this.checkFixedValue(errors, path + ".use", focus.getNamedChild("use"), (org.hl7.fhir.r5.model.Element)fixed.getUseElement(), "use", focus);
        this.checkFixedValue(errors, path + ".text", focus.getNamedChild("text"), (org.hl7.fhir.r5.model.Element)fixed.getTextElement(), "text", focus);
        this.checkFixedValue(errors, path + ".period", focus.getNamedChild("period"), (org.hl7.fhir.r5.model.Element)fixed.getPeriod(), "period", focus);
        ArrayList parts = new ArrayList();
        focus.getNamedChildren("family", parts);
        if (this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, parts.size() > 0 == fixed.hasFamily(), "Expected " + (fixed.hasFamily() ? "1" : "0") + " but found " + Integer.toString(parts.size()) + " family elements", new Object[0])) {
            for (i = 0; i < parts.size(); ++i) {
                this.checkFixedValue(errors, path + ".family", (org.hl7.fhir.r5.elementmodel.Element)parts.get(i), (org.hl7.fhir.r5.model.Element)fixed.getFamilyElement(), "family", focus);
            }
        }
        focus.getNamedChildren("given", parts);
        if (this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, parts.size() == fixed.getGiven().size(), "Expected " + Integer.toString(fixed.getGiven().size()) + " but found " + Integer.toString(parts.size()) + " given elements", new Object[0])) {
            for (i = 0; i < parts.size(); ++i) {
                this.checkFixedValue(errors, path + ".given", (org.hl7.fhir.r5.elementmodel.Element)parts.get(i), (org.hl7.fhir.r5.model.Element)fixed.getGiven().get(i), "given", focus);
            }
        }
        focus.getNamedChildren("prefix", parts);
        if (this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, parts.size() == fixed.getPrefix().size(), "Expected " + Integer.toString(fixed.getPrefix().size()) + " but found " + Integer.toString(parts.size()) + " prefix elements", new Object[0])) {
            for (i = 0; i < parts.size(); ++i) {
                this.checkFixedValue(errors, path + ".prefix", (org.hl7.fhir.r5.elementmodel.Element)parts.get(i), (org.hl7.fhir.r5.model.Element)fixed.getPrefix().get(i), "prefix", focus);
            }
        }
        focus.getNamedChildren("suffix", parts);
        if (this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, parts.size() == fixed.getSuffix().size(), "Expected " + Integer.toString(fixed.getSuffix().size()) + " but found " + Integer.toString(parts.size()) + " suffix elements", new Object[0])) {
            for (i = 0; i < parts.size(); ++i) {
                this.checkFixedValue(errors, path + ".suffix", (org.hl7.fhir.r5.elementmodel.Element)parts.get(i), (org.hl7.fhir.r5.model.Element)fixed.getSuffix().get(i), "suffix", focus);
            }
        }
    }

    private void checkIdentifier(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, ElementDefinition context) {
        String system = element.getNamedChildValue("system");
        this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, this.isAbsolute(system), "Identifier.system must be an absolute reference, not a local reference", new Object[0]);
    }

    private void checkIdentifier(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, Identifier fixed) {
        this.checkFixedValue(errors, path + ".use", focus.getNamedChild("use"), (org.hl7.fhir.r5.model.Element)fixed.getUseElement(), "use", focus);
        this.checkFixedValue(errors, path + ".type", focus.getNamedChild("type"), (org.hl7.fhir.r5.model.Element)fixed.getType(), "type", focus);
        this.checkFixedValue(errors, path + ".system", focus.getNamedChild("system"), (org.hl7.fhir.r5.model.Element)fixed.getSystemElement(), "system", focus);
        this.checkFixedValue(errors, path + ".value", focus.getNamedChild("value"), (org.hl7.fhir.r5.model.Element)fixed.getValueElement(), "value", focus);
        this.checkFixedValue(errors, path + ".period", focus.getNamedChild("period"), (org.hl7.fhir.r5.model.Element)fixed.getPeriod(), "period", focus);
        this.checkFixedValue(errors, path + ".assigner", focus.getNamedChild("assigner"), (org.hl7.fhir.r5.model.Element)fixed.getAssigner(), "assigner", focus);
    }

    private void checkPeriod(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, Period fixed) {
        this.checkFixedValue(errors, path + ".start", focus.getNamedChild("start"), (org.hl7.fhir.r5.model.Element)fixed.getStartElement(), "start", focus);
        this.checkFixedValue(errors, path + ".end", focus.getNamedChild("end"), (org.hl7.fhir.r5.model.Element)fixed.getEndElement(), "end", focus);
    }

    private void checkPrimitive(Object appContext, List<ValidationMessage> errors, String path, String type, ElementDefinition context, org.hl7.fhir.r5.elementmodel.Element e, StructureDefinition profile, NodeStack node) throws FHIRException, IOException {
        XhtmlNode xhtml;
        Utilities.DecimalStatus ds;
        String encoded;
        TimeType ex3;
        if (StringUtils.isBlank((CharSequence)e.primitiveValue())) {
            if (e.primitiveValue() == null) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.hasChildren(), "Primitive types must have a value or must have child extensions", new Object[0]);
            } else if (e.primitiveValue().length() == 0) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.hasChildren(), "Primitive types must have a value that is not empty", new Object[0]);
            } else if (StringUtils.isWhitespace((CharSequence)e.primitiveValue())) {
                this.warning(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.hasChildren(), "Primitive types should not only be whitespace", new Object[0]);
            }
            return;
        }
        String regex = context.getExtensionString("http://hl7.org/fhir/StructureDefinition/regex");
        if (regex != null) {
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.primitiveValue().matches(regex), "Element value '" + e.primitiveValue() + "' does not meet regex '" + regex + "'", new Object[0]);
        }
        if (type.equals("boolean")) {
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, "true".equals(e.primitiveValue()) || "false".equals(e.primitiveValue()), "boolean values must be 'true' or 'false'", new Object[0]);
        }
        if (type.equals("uri") || type.equals("oid") || type.equals("uuid") || type.equals("url") || type.equals("canonical")) {
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !e.primitiveValue().startsWith("oid:"), "URI values cannot start with oid:", new Object[0]);
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !e.primitiveValue().startsWith("uuid:"), "URI values cannot start with uuid:", new Object[0]);
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.primitiveValue().equals(e.primitiveValue().trim().replace(" ", "")), "URI values cannot have whitespace", new Object[0]);
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !context.hasMaxLength() || context.getMaxLength() == 0 || e.primitiveValue().length() <= context.getMaxLength(), "value is longer than permitted maximum length of " + context.getMaxLength(), new Object[0]);
            if (type.equals("oid") && this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.primitiveValue().startsWith("urn:oid:"), "OIDs must start with urn:oid:", new Object[0])) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, Utilities.isOid((String)e.primitiveValue().substring(8)), "OIDs must be valid", new Object[0]);
            }
            if (type.equals("uuid")) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.primitiveValue().startsWith("urn:uuid:"), "UUIDs must start with urn:uuid:", new Object[0]);
                try {
                    UUID.fromString(e.primitiveValue().substring(8));
                }
                catch (Exception ex2) {
                    this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "UUIDs must be valid (" + ex2.getMessage() + ")", new Object[0]);
                }
            }
            if (this.fetcher != null) {
                boolean found = this.fetcher.resolveURL(appContext, path, e.primitiveValue());
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, found, "URL value '" + e.primitiveValue() + "' does not resolve", new Object[0]);
            }
        }
        if (type.equals("id")) {
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, FormatUtilities.isValidId((String)e.primitiveValue()), "id value '" + e.primitiveValue() + "' is not valid", new Object[0]);
        }
        if (type.equalsIgnoreCase("string") && e.hasPrimitiveValue() && this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.primitiveValue() == null || e.primitiveValue().length() > 0, "@value cannot be empty", new Object[0])) {
            this.warning(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.primitiveValue() == null || e.primitiveValue().trim().equals(e.primitiveValue()), "value should not start or finish with whitespace", new Object[0]);
            if (this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.primitiveValue().length() <= 0x100000, "value is longer than permitted maximum length of 1 MB (1048576 bytes)", new Object[0])) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !context.hasMaxLength() || context.getMaxLength() == 0 || e.primitiveValue().length() <= context.getMaxLength(), "value is longer than permitted maximum length of " + context.getMaxLength(), new Object[0]);
            }
        }
        if (type.equals("dateTime")) {
            this.warning(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, this.yearIsValid(e.primitiveValue()), "The value '" + e.primitiveValue() + "' is outside the range of reasonable years - check for data entry error", new Object[0]);
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.primitiveValue().matches("([0-9]([0-9]([0-9][1-9]|[1-9]0)|[1-9]00)|[1-9]000)(-(0[1-9]|1[0-2])(-(0[1-9]|[1-2][0-9]|3[0-1])(T([01][0-9]|2[0-3]):[0-5][0-9]:([0-5][0-9]|60)(\\.[0-9]+)?(Z|(\\+|-)((0[0-9]|1[0-3]):[0-5][0-9]|14:00))?)?)?)?"), "Not a valid date time", new Object[0]);
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !this.hasTime(e.primitiveValue()) || this.hasTimeZone(e.primitiveValue()), "if a date has a time, it must have a timezone", new Object[0]);
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !context.hasMaxLength() || context.getMaxLength() == 0 || e.primitiveValue().length() <= context.getMaxLength(), "value is longer than permitted maximum length of " + context.getMaxLength(), new Object[0]);
            try {
                DateTimeType found = new DateTimeType(e.primitiveValue());
            }
            catch (Exception ex3) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "Not a valid date/time (" + ex3.getMessage() + ")", new Object[0]);
            }
        }
        if (type.equals("time")) {
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.primitiveValue().matches("([01][0-9]|2[0-3]):[0-5][0-9]:([0-5][0-9]|60)"), "Not a valid time", new Object[0]);
            try {
                ex3 = new TimeType(e.primitiveValue());
            }
            catch (Exception ex4) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "Not a valid time (" + ex4.getMessage() + ")", new Object[0]);
            }
        }
        if (type.equals("date")) {
            this.warning(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, this.yearIsValid(e.primitiveValue()), "The value '" + e.primitiveValue() + "' is outside the range of reasonable years - check for data entry error", new Object[0]);
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.primitiveValue().matches("([0-9]([0-9]([0-9][1-9]|[1-9]0)|[1-9]00)|[1-9]000)(-(0[1-9]|1[0-2])(-(0[1-9]|[1-2][0-9]|3[0-1]))?)?"), "Not a valid date", new Object[0]);
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !context.hasMaxLength() || context.getMaxLength() == 0 || e.primitiveValue().length() <= context.getMaxLength(), "value is longer than permitted maximum value of " + context.getMaxLength(), new Object[0]);
            try {
                ex3 = new DateType(e.primitiveValue());
            }
            catch (Exception ex5) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "Not a valid date (" + ex5.getMessage() + ")", new Object[0]);
            }
        }
        if (type.equals("base64Binary") && StringUtils.isNotBlank((CharSequence)(encoded = e.primitiveValue()))) {
            int charCount = 0;
            for (int i = 0; i < encoded.length(); ++i) {
                char nextChar = encoded.charAt(i);
                if (Character.isWhitespace(nextChar)) continue;
                if (Character.isLetterOrDigit(nextChar)) {
                    ++charCount;
                }
                if (nextChar != '/' && nextChar != '=' && nextChar != '+') continue;
                ++charCount;
            }
            if (charCount > 0 && charCount % 4 != 0) {
                String value = encoded.length() < 100 ? encoded : "(snip)";
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "The value \"{0}\" is not a valid Base64 value", value);
            }
        }
        if ((type.equals("integer") || type.equals("unsignedInt") || type.equals("positiveInt")) && this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, Utilities.isInteger((String)e.primitiveValue()), "The value '" + e.primitiveValue() + "' is not a valid integer", new Object[0])) {
            Integer v = (int)new Integer(e.getValue());
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !context.hasMaxValueIntegerType() || !context.getMaxValueIntegerType().hasValue() || (Integer)context.getMaxValueIntegerType().getValue() >= v, "value is greater than permitted maximum value of " + (context.hasMaxValueIntegerType() ? context.getMaxValueIntegerType() : ""), new Object[0]);
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !context.hasMinValueIntegerType() || !context.getMinValueIntegerType().hasValue() || (Integer)context.getMinValueIntegerType().getValue() <= v, "value is less than permitted minimum value of " + (context.hasMinValueIntegerType() ? context.getMinValueIntegerType() : ""), new Object[0]);
            if (type.equals("unsignedInt")) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, v >= 0, "value is less than permitted minimum value of 0", new Object[0]);
            }
            if (type.equals("positiveInt")) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, v > 0, "value is less than permitted minimum value of 1", new Object[0]);
            }
        }
        if (type.equals("decimal") && e.primitiveValue() != null) {
            ds = Utilities.checkDecimal((String)e.primitiveValue(), (boolean)true, (boolean)false);
            if (this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, ds == Utilities.DecimalStatus.OK || ds == Utilities.DecimalStatus.RANGE, "The value '" + e.primitiveValue() + "' is not a valid decimal", new Object[0])) {
                this.warning(errors, ValidationMessage.IssueType.VALUE, e.line(), e.col(), path, ds != Utilities.DecimalStatus.RANGE, "The value '" + e.primitiveValue() + "' is outside the range of commonly/reasonably supported decimals", new Object[0]);
            }
        }
        if (type.equals("instant")) {
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.primitiveValue().matches("-?[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])T([01][0-9]|2[0-3]):[0-5][0-9]:([0-5][0-9]|60)(\\.[0-9]+)?(Z|(\\+|-)((0[0-9]|1[0-3]):[0-5][0-9]|14:00))"), "The instant '" + e.primitiveValue() + "' is not valid (by regex)", new Object[0]);
            this.warning(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, this.yearIsValid(e.primitiveValue()), "The value '" + e.primitiveValue() + "' is outside the range of reasonable years - check for data entry error", new Object[0]);
            try {
                ds = new InstantType(e.primitiveValue());
            }
            catch (Exception ex6) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "Not a valid instant (" + ex6.getMessage() + ")", new Object[0]);
            }
        }
        if (type.equals("code") && e.primitiveValue() != null) {
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, this.passesCodeWhitespaceRules(e.primitiveValue()), "The code '" + e.primitiveValue() + "' is not valid (whitespace rules)", new Object[0]);
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !context.hasMaxLength() || context.getMaxLength() == 0 || e.primitiveValue().length() <= context.getMaxLength(), "value is longer than permitted maximum length of " + context.getMaxLength(), new Object[0]);
        }
        if (context.hasBinding() && e.primitiveValue() != null) {
            this.checkPrimitiveBinding(errors, path, type, context, e, profile, node);
        }
        if (type.equals("xhtml") && (xhtml = e.getXhtml()) != null) {
            String ns = xhtml.getNsDecl();
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, "http://www.w3.org/1999/xhtml".equals(ns), "Wrong namespace on the XHTML ('" + ns + "', should be '" + "http://www.w3.org/1999/xhtml" + "')", new Object[0]);
            this.checkInnerNS(errors, e, path, xhtml.getChildNodes());
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, "div".equals(xhtml.getName()), "Wrong name on the XHTML ('" + ns + "') - must start with div", new Object[0]);
            this.checkInnerNames(errors, e, path, xhtml.getChildNodes());
        }
        if (context.hasFixed()) {
            this.checkFixedValue(errors, path, e, (org.hl7.fhir.r5.model.Element)context.getFixed(), context.getSliceName(), null, false);
        }
        if (context.hasPattern()) {
            this.checkFixedValue(errors, path, e, (org.hl7.fhir.r5.model.Element)context.getPattern(), context.getSliceName(), null, true);
        }
    }

    private void checkInnerNames(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element e, String path, List<XhtmlNode> list) {
        for (XhtmlNode node : list) {
            if (node.getNodeType() != NodeType.Element) continue;
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, Utilities.existsInList((String)node.getName(), (String[])new String[]{"p", "br", "div", "h1", "h2", "h3", "h4", "h5", "h6", "a", "span", "b", "em", "i", "strong", "small", "big", "tt", "small", "dfn", "q", "var", "abbr", "acronym", "cite", "blockquote", "hr", "address", "bdo", "kbd", "q", "sub", "sup", "ul", "ol", "li", "dl", "dt", "dd", "pre", "table", "caption", "colgroup", "col", "thead", "tr", "tfoot", "tbody", "th", "td", "code", "samp", "img", "map", "area"}), "Illegal element name in the XHTML ('" + node.getName() + "')", new Object[0]);
            for (String an : node.getAttributes().keySet()) {
                boolean ok = an.startsWith("xmlns") || Utilities.existsInList((String)an, (String[])new String[]{"title", "style", "class", "id", "lang", "xml:lang", "dir", "accesskey", "tabindex", "span", "width", "align", "valign", "char", "charoff", "abbr", "axis", "headers", "scope", "rowspan", "colspan"}) || Utilities.existsInList((String)(node.getName() + "." + an), (String[])new String[]{"a.href", "a.name", "img.src", "img.border", "div.xmlns", "blockquote.cite", "q.cite", "a.charset", "a.type", "a.name", "a.href", "a.hreflang", "a.rel", "a.rev", "a.shape", "a.coords", "img.src", "img.alt", "img.longdesc", "img.height", "img.width", "img.usemap", "img.ismap", "map.name", "area.shape", "area.coords", "area.href", "area.nohref", "area.alt", "table.summary", "table.width", "table.border", "table.frame", "table.rules", "table.cellspacing", "table.cellpadding", "pre.space", "td.nowrap"});
                if (ok) continue;
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "Illegal attribute name in the XHTML ('" + an + "' on '" + node.getName() + "')", new Object[0]);
            }
            this.checkInnerNames(errors, e, path, node.getChildNodes());
        }
    }

    private void checkInnerNS(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element e, String path, List<XhtmlNode> list) {
        for (XhtmlNode node : list) {
            if (node.getNodeType() != NodeType.Element) continue;
            String ns = node.getNsDecl();
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, ns == null || "http://www.w3.org/1999/xhtml".equals(ns), "Wrong namespace on the XHTML ('" + ns + "', should be '" + "http://www.w3.org/1999/xhtml" + "')", new Object[0]);
            this.checkInnerNS(errors, e, path, node.getChildNodes());
        }
    }

    private void checkPrimitiveBinding(List<ValidationMessage> errors, String path, String type, ElementDefinition elementContext, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition profile, NodeStack stack) {
        if (!(element.hasPrimitiveValue() && ("code".equals(type) || "string".equals(type) || "uri".equals(type) || "url".equals(type) || "canonical".equals(type)))) {
            return;
        }
        if (this.noTerminologyChecks) {
            return;
        }
        String value = element.primitiveValue();
        ElementDefinition.ElementDefinitionBindingComponent binding = elementContext.getBinding();
        if (binding.hasValueSet()) {
            ValueSet vs = this.resolveBindingReference((DomainResource)profile, binding.getValueSet(), profile.getUrl());
            if (this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, vs != null, "ValueSet {0} not found by validator", this.describeReference(binding.getValueSet()))) {
                long t = System.nanoTime();
                IWorkerContext.ValidationResult vr = null;
                if (binding.getStrength() != Enumerations.BindingStrength.EXAMPLE) {
                    vr = this.context.validateCode(new TerminologyServiceOptions(stack.workingLang), value, vs);
                }
                this.txTime += System.nanoTime() - t;
                if (vr != null && !vr.isOk()) {
                    if (vr.IsNoService()) {
                        this.txHint(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "The value provided ('" + value + "') could not be validated in the absence of a terminology server", new Object[0]);
                    } else if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                        this.txRule(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "The value provided ('" + value + "') is not in the value set " + this.describeReference(binding.getValueSet()) + " (" + vs.getUrl() + ", and a code is required from this value set)" + (vr.getMessage() != null ? " (error message = " + vr.getMessage() + ")" : ""), new Object[0]);
                    } else if (binding.getStrength() == Enumerations.BindingStrength.EXTENSIBLE) {
                        if (binding.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")) {
                            this.checkMaxValueSet(errors, path, element, profile, ToolingExtensions.readStringExtension((org.hl7.fhir.r5.model.Element)binding, (String)"http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet"), value, stack);
                        } else if (!this.noExtensibleWarnings) {
                            this.txWarning(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "The value provided ('" + value + "') is not in the value set " + this.describeReference(binding.getValueSet()) + " (" + vs.getUrl() + ", and a code should come from this value set unless it has no suitable code)" + (vr.getMessage() != null ? " (error message = " + vr.getMessage() + ")" : ""), new Object[0]);
                        }
                    } else if (binding.getStrength() == Enumerations.BindingStrength.PREFERRED) {
                        this.txHint(errors, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "The value provided ('" + value + "') is not in the value set " + this.describeReference(binding.getValueSet()) + " (" + vs.getUrl() + ", and a code is recommended to come from this value set)" + (vr.getMessage() != null ? " (error message = " + vr.getMessage() + ")" : ""), new Object[0]);
                    }
                }
            }
        } else if (!this.noBindingMsgSuppressed) {
            this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, !type.equals("code"), "Binding has no source, so can't be checked");
        }
    }

    private void checkQuantity(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, Quantity fixed) {
        this.checkFixedValue(errors, path + ".value", focus.getNamedChild("value"), (org.hl7.fhir.r5.model.Element)fixed.getValueElement(), "value", focus);
        this.checkFixedValue(errors, path + ".comparator", focus.getNamedChild("comparator"), (org.hl7.fhir.r5.model.Element)fixed.getComparatorElement(), "comparator", focus);
        this.checkFixedValue(errors, path + ".units", focus.getNamedChild("unit"), (org.hl7.fhir.r5.model.Element)fixed.getUnitElement(), "units", focus);
        this.checkFixedValue(errors, path + ".system", focus.getNamedChild("system"), (org.hl7.fhir.r5.model.Element)fixed.getSystemElement(), "system", focus);
        this.checkFixedValue(errors, path + ".code", focus.getNamedChild("code"), (org.hl7.fhir.r5.model.Element)fixed.getCodeElement(), "code", focus);
    }

    private void checkRange(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, Range fixed) {
        this.checkFixedValue(errors, path + ".low", focus.getNamedChild("low"), (org.hl7.fhir.r5.model.Element)fixed.getLow(), "low", focus);
        this.checkFixedValue(errors, path + ".high", focus.getNamedChild("high"), (org.hl7.fhir.r5.model.Element)fixed.getHigh(), "high", focus);
    }

    private void checkRatio(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, Ratio fixed) {
        this.checkFixedValue(errors, path + ".numerator", focus.getNamedChild("numerator"), (org.hl7.fhir.r5.model.Element)fixed.getNumerator(), "numerator", focus);
        this.checkFixedValue(errors, path + ".denominator", focus.getNamedChild("denominator"), (org.hl7.fhir.r5.model.Element)fixed.getDenominator(), "denominator", focus);
    }

    private void checkReference(ValidatorHostContext hostContext, List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition profile, ElementDefinition container, String parentType, NodeStack stack) throws FHIRException, IOException {
        IResourceValidator.ReferenceValidationPolicy pol;
        Reference reference = ObjectConverter.readAsReference((org.hl7.fhir.r5.elementmodel.Element)element);
        String ref = reference.getReference();
        if (Utilities.noString((String)ref)) {
            if (Utilities.noString((String)reference.getIdentifier().getSystem()) && Utilities.noString((String)reference.getIdentifier().getValue())) {
                this.warning(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, !Utilities.noString((String)element.getNamedChildValue("display")), "A Reference without an actual reference or identifier should have a display", new Object[0]);
            }
            return;
        }
        org.hl7.fhir.r5.elementmodel.Element we = this.localResolve(ref, stack, errors, path);
        String refType = ref.startsWith("#") ? "contained" : (we == null ? "remote" : "bundled");
        IResourceValidator.ReferenceValidationPolicy referenceValidationPolicy = refType.equals("contained") || refType.equals("bundled") ? IResourceValidator.ReferenceValidationPolicy.CHECK_VALID : (pol = this.fetcher == null ? IResourceValidator.ReferenceValidationPolicy.IGNORE : this.fetcher.validationPolicy(hostContext.appContext, path, ref));
        if (pol.checkExists()) {
            if (we == null) {
                if (this.fetcher == null) {
                    if (!refType.equals("contained")) {
                        throw new FHIRException("Resource resolution services not provided");
                    }
                } else {
                    we = this.fetcher.fetch(hostContext.appContext, ref);
                }
            }
            this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, we != null || pol == IResourceValidator.ReferenceValidationPolicy.CHECK_TYPE_IF_EXISTS, "Unable to resolve resource '" + ref + "'", new Object[0]);
        }
        String ft = we != null ? we.getType() : this.tryParse(ref);
        if (reference.hasType()) {
            String tu = this.isAbsolute(reference.getType()) ? reference.getType() : "http://hl7.org/fhir/StructureDefinition/" + reference.getType();
            ElementDefinition.TypeRefComponent containerType = container.getType("Reference");
            if (!containerType.hasTargetProfile(tu) && !containerType.hasTargetProfile("http://hl7.org/fhir/StructureDefinition/Resource")) {
                boolean matchingResource = false;
                for (CanonicalType target : containerType.getTargetProfile()) {
                    StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, target.asStringValue());
                    if (!("http://hl7.org/fhir/StructureDefinition/" + sd.getType()).equals(tu)) continue;
                    matchingResource = true;
                    break;
                }
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, matchingResource, "The type '" + reference.getType() + "' is not a valid Target for this element (must be one of " + container.getType("Reference").getTargetProfile() + ")", new Object[0]);
            }
            this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, ft == null || ft.equals(reference.getType()), "The specified type '" + reference.getType() + "' does not match the found type '" + ft + "'", new Object[0]);
        }
        if (we != null && pol.checkType() && this.warning(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, ft != null, "Unable to determine type of target resource", new Object[0])) {
            boolean ok = false;
            CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
            for (ElementDefinition.TypeRefComponent type : container.getType()) {
                if (!ok && type.getWorkingCode().equals("Reference")) {
                    if (!type.hasTargetProfile() || type.hasTargetProfile("http://hl7.org/fhir/StructureDefinition/Resource")) {
                        ok = true;
                    } else {
                        ArrayList<String> candidateProfiles = new ArrayList<String>();
                        for (UriType u : type.getTargetProfile()) {
                            String pr = (String)u.getValue();
                            String bt = this.getBaseType(profile, pr);
                            StructureDefinition structureDefinition = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + bt);
                            if (!this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, bt != null, "Unable to resolve the profile reference '" + pr + "'", new Object[0])) continue;
                            b.append(bt);
                            if (!bt.equals(ft)) continue;
                            ok = true;
                            if (we == null || !pol.checkValid()) continue;
                            candidateProfiles.add(pr);
                        }
                        HashMap<String, ArrayList<ValidationMessage>> goodProfiles = new HashMap<String, ArrayList<ValidationMessage>>();
                        ArrayList<ArrayList<ValidationMessage>> badProfiles = new ArrayList<ArrayList<ValidationMessage>>();
                        ArrayList<String> profiles = new ArrayList<String>();
                        if (!candidateProfiles.isEmpty()) {
                            for (String string : candidateProfiles) {
                                profiles.add(string);
                                ArrayList<ValidationMessage> profileErrors = new ArrayList<ValidationMessage>();
                                this.doResourceProfile(hostContext, we, string, profileErrors, stack.push(we, -1, null, null), path, element, profile);
                                if (this.hasErrors(profileErrors)) {
                                    badProfiles.add(profileErrors);
                                } else {
                                    goodProfiles.put(string, profileErrors);
                                }
                                if (!type.hasAggregation()) continue;
                                boolean modeOk = false;
                                for (Enumeration mode : type.getAggregation()) {
                                    if (((ElementDefinition.AggregationMode)mode.getValue()).equals((Object)ElementDefinition.AggregationMode.CONTAINED) && refType.equals("contained")) {
                                        modeOk = true;
                                        continue;
                                    }
                                    if (((ElementDefinition.AggregationMode)mode.getValue()).equals((Object)ElementDefinition.AggregationMode.BUNDLED) && refType.equals("bundled")) {
                                        modeOk = true;
                                        continue;
                                    }
                                    if (!((ElementDefinition.AggregationMode)mode.getValue()).equals((Object)ElementDefinition.AggregationMode.REFERENCED) || !refType.equals("bundled") && !refType.equals("remote")) continue;
                                    modeOk = true;
                                }
                                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, modeOk, "Reference is " + refType + " which isn't supported by the specified aggregation mode(s) for the reference", new Object[0]);
                            }
                            if (goodProfiles.size() == 1) {
                                errors.addAll((Collection)goodProfiles.values().iterator().next());
                            } else if (goodProfiles.size() == 0) {
                                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, profiles.size() == 1, "Unable to find matching profile among choices: " + StringUtils.join((Object[])new Object[]{"; ", profiles}), new Object[0]);
                                for (List list : badProfiles) {
                                    errors.addAll(list);
                                }
                            } else {
                                this.warning(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, false, "Found multiple matching profiles among choices: " + StringUtils.join((Object[])new Object[]{"; ", goodProfiles.keySet()}), new Object[0]);
                                for (List list : goodProfiles.values()) {
                                    errors.addAll(list);
                                }
                            }
                        }
                    }
                }
                if (ok || !type.getCode().equals("*")) continue;
                ok = true;
            }
            this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, ok, "Invalid Resource target type. Found " + ft + ", but expected one of (" + b.toString() + ")", new Object[0]);
        }
        if (we == null) {
            boolean missingRef = false;
            block7: for (ElementDefinition.TypeRefComponent type : container.getType()) {
                if (missingRef || !type.getCode().equals("Reference") || !type.hasAggregation()) continue;
                for (Enumeration mode : type.getAggregation()) {
                    if (!((ElementDefinition.AggregationMode)mode.getValue()).equals((Object)ElementDefinition.AggregationMode.CONTAINED) && !((ElementDefinition.AggregationMode)mode.getValue()).equals((Object)ElementDefinition.AggregationMode.BUNDLED)) continue;
                    missingRef = true;
                    continue block7;
                }
            }
            this.rule(errors, ValidationMessage.IssueType.REQUIRED, -1, -1, path, !missingRef, "Bundled or contained reference not found within the bundle/resource " + ref, new Object[0]);
        }
        if (pol == IResourceValidator.ReferenceValidationPolicy.CHECK_VALID) {
            // empty if block
        }
    }

    private void doResourceProfile(ValidatorHostContext hostContext, org.hl7.fhir.r5.elementmodel.Element resource, String profile, List<ValidationMessage> errors, NodeStack stack, String path, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition containingProfile) throws FHIRException, IOException {
        ResourceProfiles resourceProfiles = this.addResourceProfile(errors, resource, profile, path, element, stack, containingProfile);
        if (resourceProfiles.isProcessed()) {
            this.start(hostContext, errors, resource, resource, null, stack);
        }
    }

    private ResourceProfiles getResourceProfiles(org.hl7.fhir.r5.elementmodel.Element resource, NodeStack stack) {
        ResourceProfiles resourceProfiles = this.resourceProfilesMap.get(resource);
        if (resourceProfiles == null) {
            resourceProfiles = new ResourceProfiles(resource, stack);
            this.resourceProfilesMap.put(resource, resourceProfiles);
        }
        return resourceProfiles;
    }

    private ResourceProfiles addResourceProfile(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element resource, String profile, String path, org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack, StructureDefinition containingProfile) {
        ResourceProfiles resourceProfiles = this.getResourceProfiles(resource, stack);
        resourceProfiles.addProfile(errors, profile, this.errorForUnknownProfiles, path, element, containingProfile);
        return resourceProfiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkResourceType(String type) {
        long t = System.nanoTime();
        try {
            if (this.context.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + type) != null) {
                String string = type;
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.sdTime += System.nanoTime() - t;
        }
    }

    private void checkSampledData(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, SampledData fixed) {
        this.checkFixedValue(errors, path + ".origin", focus.getNamedChild("origin"), (org.hl7.fhir.r5.model.Element)fixed.getOrigin(), "origin", focus);
        this.checkFixedValue(errors, path + ".period", focus.getNamedChild("period"), (org.hl7.fhir.r5.model.Element)fixed.getPeriodElement(), "period", focus);
        this.checkFixedValue(errors, path + ".factor", focus.getNamedChild("factor"), (org.hl7.fhir.r5.model.Element)fixed.getFactorElement(), "factor", focus);
        this.checkFixedValue(errors, path + ".lowerLimit", focus.getNamedChild("lowerLimit"), (org.hl7.fhir.r5.model.Element)fixed.getLowerLimitElement(), "lowerLimit", focus);
        this.checkFixedValue(errors, path + ".upperLimit", focus.getNamedChild("upperLimit"), (org.hl7.fhir.r5.model.Element)fixed.getUpperLimitElement(), "upperLimit", focus);
        this.checkFixedValue(errors, path + ".dimensions", focus.getNamedChild("dimensions"), (org.hl7.fhir.r5.model.Element)fixed.getDimensionsElement(), "dimensions", focus);
        this.checkFixedValue(errors, path + ".data", focus.getNamedChild("data"), (org.hl7.fhir.r5.model.Element)fixed.getDataElement(), "data", focus);
    }

    private void checkTiming(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, Timing fixed) {
        this.checkFixedValue(errors, path + ".repeat", focus.getNamedChild("repeat"), (org.hl7.fhir.r5.model.Element)fixed.getRepeat(), "value", focus);
        ArrayList events = new ArrayList();
        focus.getNamedChildren("event", events);
        if (this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, events.size() == fixed.getEvent().size(), "Expected " + Integer.toString(fixed.getEvent().size()) + " but found " + Integer.toString(events.size()) + " event elements", new Object[0])) {
            for (int i = 0; i < events.size(); ++i) {
                this.checkFixedValue(errors, path + ".event", (org.hl7.fhir.r5.elementmodel.Element)events.get(i), (org.hl7.fhir.r5.model.Element)fixed.getEvent().get(i), "event", focus);
            }
        }
    }

    private boolean codeinExpansion(ValueSet.ValueSetExpansionContainsComponent cnt, String system, String code) {
        for (ValueSet.ValueSetExpansionContainsComponent c : cnt.getContains()) {
            if (code.equals(c.getCode()) && system.equals(c.getSystem().toString())) {
                return true;
            }
            if (!this.codeinExpansion(c, system, code)) continue;
            return true;
        }
        return false;
    }

    private boolean codeInExpansion(ValueSet vs, String system, String code) {
        for (ValueSet.ValueSetExpansionContainsComponent c : vs.getExpansion().getContains()) {
            if (code.equals(c.getCode()) && (system == null || system.equals(c.getSystem()))) {
                return true;
            }
            if (!this.codeinExpansion(c, system, code)) continue;
            return true;
        }
        return false;
    }

    private String describeReference(String reference) {
        if (reference == null) {
            return "null";
        }
        return reference;
    }

    private String describeTypes(List<ElementDefinition.TypeRefComponent> types) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (ElementDefinition.TypeRefComponent t : types) {
            b.append(t.getWorkingCode());
        }
        return b.toString();
    }

    protected ElementDefinition findElement(StructureDefinition profile, String name) {
        for (ElementDefinition c : profile.getSnapshot().getElement()) {
            if (!c.getPath().equals(name)) continue;
            return c;
        }
        return null;
    }

    public IResourceValidator.BestPracticeWarningLevel getBestPracticeWarningLevel() {
        return this.bpWarnings;
    }

    private String getBaseType(StructureDefinition profile, String pr) {
        StructureDefinition p = this.resolveProfile(profile, pr);
        if (p == null) {
            return null;
        }
        return p.getType();
    }

    public IResourceValidator.CheckDisplayOption getCheckDisplay() {
        return this.checkDisplay;
    }

    private CodeSystem.ConceptDefinitionComponent getCodeDefinition(CodeSystem.ConceptDefinitionComponent c, String code) {
        if (code.equals(c.getCode())) {
            return c;
        }
        for (CodeSystem.ConceptDefinitionComponent g : c.getConcept()) {
            CodeSystem.ConceptDefinitionComponent r = this.getCodeDefinition(g, code);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    private CodeSystem.ConceptDefinitionComponent getCodeDefinition(CodeSystem cs, String code) {
        for (CodeSystem.ConceptDefinitionComponent c : cs.getConcept()) {
            CodeSystem.ConceptDefinitionComponent r = this.getCodeDefinition(c, code);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    private org.hl7.fhir.r5.elementmodel.Element getContainedById(org.hl7.fhir.r5.elementmodel.Element container, String id) {
        ArrayList contained = new ArrayList();
        container.getNamedChildren("contained", contained);
        for (org.hl7.fhir.r5.elementmodel.Element we : contained) {
            if (!id.equals(we.getNamedChildValue("id"))) continue;
            return we;
        }
        return null;
    }

    public IWorkerContext getContext() {
        return this.context;
    }

    private List<ElementDefinition> getCriteriaForDiscriminator(String path, ElementDefinition element, String discriminator, StructureDefinition profile, boolean removeResolve) throws FHIRException {
        ArrayList<ElementDefinition> elements = new ArrayList<ElementDefinition>();
        if ("value".equals(discriminator) && element.hasFixed()) {
            elements.add(element);
            return elements;
        }
        if (removeResolve) {
            if (discriminator.equals("resolve()")) {
                elements.add(element);
                return elements;
            }
            if (discriminator.endsWith(".resolve()")) {
                discriminator = discriminator.substring(0, discriminator.length() - 10);
            }
        }
        ElementDefinition ed = null;
        ExpressionNode expr = this.fpe.parse(this.fixExpr(discriminator));
        long t2 = System.nanoTime();
        ed = this.fpe.evaluateDefinition(expr, profile, element);
        this.sdTime += System.nanoTime() - t2;
        if (ed != null) {
            elements.add(ed);
        }
        for (ElementDefinition.TypeRefComponent type : element.getType()) {
            for (CanonicalType p : type.getProfile()) {
                String id = p.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-profile-element") ? p.getExtensionString("http://hl7.org/fhir/StructureDefinition/elementdefinition-profile-element") : null;
                StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, (String)p.getValue());
                if (sd == null) {
                    throw new DefinitionException("Unable to resolve profile " + p);
                }
                profile = sd;
                if (id == null) {
                    element = sd.getSnapshot().getElementFirstRep();
                } else {
                    element = null;
                    for (ElementDefinition t : sd.getSnapshot().getElement()) {
                        if (!id.equals(t.getId())) continue;
                        element = t;
                    }
                    if (element == null) {
                        throw new DefinitionException("Unable to resolve element " + id + " in profile " + p);
                    }
                }
                expr = this.fpe.parse(this.fixExpr(discriminator));
                t2 = System.nanoTime();
                ed = this.fpe.evaluateDefinition(expr, profile, element);
                this.sdTime += System.nanoTime() - t2;
                if (ed == null) continue;
                elements.add(ed);
            }
        }
        return elements;
    }

    private org.hl7.fhir.r5.elementmodel.Element getExtensionByUrl(List<org.hl7.fhir.r5.elementmodel.Element> extensions, String urlSimple) {
        for (org.hl7.fhir.r5.elementmodel.Element e : extensions) {
            if (!urlSimple.equals(e.getNamedChildValue("url"))) continue;
            return e;
        }
        return null;
    }

    public List<String> getExtensionDomains() {
        return this.extensionDomains;
    }

    private org.hl7.fhir.r5.elementmodel.Element getFromBundle(org.hl7.fhir.r5.elementmodel.Element bundle, String ref, String fullUrl, List<ValidationMessage> errors, String path, String type) {
        String targetUrl = null;
        String version = "";
        String resourceType = null;
        if (ref.startsWith("http") || ref.startsWith("urn")) {
            if (ref.contains("/_history/")) {
                targetUrl = ref.substring(0, ref.indexOf("/_history/") - 1);
                version = ref.substring(ref.indexOf("/_history/") + 10);
            } else {
                targetUrl = ref;
            }
        } else {
            int i;
            String[] parts;
            if (fullUrl == null) {
                this.rule(errors, ValidationMessage.IssueType.REQUIRED, -1, -1, path, Utilities.existsInList((String)type, (String[])new String[]{"batch-response", "transaction-response"}) || path.startsWith("Bundle.signature"), "Relative Reference appears inside Bundle whose entry is missing a fullUrl", new Object[0]);
                return null;
            }
            if (ref.split("/").length != 2 && ref.split("/").length != 4) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, -1, -1, path, false, "Relative URLs must be of the format [ResourceName]/[id].  Encountered " + ref, new Object[0]);
                return null;
            }
            String base = "";
            if (fullUrl.startsWith("urn")) {
                parts = fullUrl.split("\\:");
                for (i = 0; i < parts.length - 1; ++i) {
                    base = base + parts[i] + ":";
                }
            } else {
                parts = fullUrl.split("/");
                for (i = 0; i < parts.length - 2; ++i) {
                    base = base + parts[i] + "/";
                }
            }
            String id = null;
            if (ref.contains("/_history/")) {
                version = ref.substring(ref.indexOf("/_history/") + 10);
                String[] refBaseParts = ref.substring(0, ref.indexOf("/_history/")).split("/");
                resourceType = refBaseParts[0];
                id = refBaseParts[1];
            } else if (base.startsWith("urn")) {
                resourceType = ref.split("/")[0];
                id = ref.split("/")[1];
            } else {
                id = ref;
            }
            targetUrl = base + id;
        }
        ArrayList entries = new ArrayList();
        bundle.getNamedChildren("entry", entries);
        org.hl7.fhir.r5.elementmodel.Element match = null;
        for (org.hl7.fhir.r5.elementmodel.Element we : entries) {
            if (!targetUrl.equals(we.getChildValue("fullUrl"))) continue;
            org.hl7.fhir.r5.elementmodel.Element r = we.getNamedChild("resource");
            if (version.isEmpty()) {
                this.rule(errors, ValidationMessage.IssueType.FORBIDDEN, -1, -1, path, match == null, "Multiple matches in bundle for reference " + ref, new Object[0]);
                match = r;
                continue;
            }
            try {
                if (!version.equals(((org.hl7.fhir.r5.elementmodel.Element)r.getChildren("meta").get(0)).getChildValue("versionId"))) continue;
                this.rule(errors, ValidationMessage.IssueType.FORBIDDEN, -1, -1, path, match == null, "Multiple matches in bundle for reference " + ref, new Object[0]);
                match = r;
            }
            catch (Exception e) {
                this.warning(errors, ValidationMessage.IssueType.REQUIRED, -1, -1, path, r.getChildren("meta").size() == 1 && ((org.hl7.fhir.r5.elementmodel.Element)r.getChildren("meta").get(0)).getChildValue("versionId") != null, "Entries matching fullURL " + targetUrl + " should declare meta/versionId because there are version-specific references", new Object[0]);
            }
        }
        if (match != null && resourceType != null) {
            this.rule(errors, ValidationMessage.IssueType.REQUIRED, -1, -1, path, match.getType().equals(resourceType), "Matching reference for reference " + ref + " has resourceType " + match.getType(), new Object[0]);
        }
        if (match == null) {
            this.warning(errors, ValidationMessage.IssueType.REQUIRED, -1, -1, path, !ref.startsWith("urn"), "URN reference is not locally contained within the bundle " + ref, new Object[0]);
        }
        return match;
    }

    private StructureDefinition getProfileForType(String type, List<ElementDefinition.TypeRefComponent> list) {
        for (ElementDefinition.TypeRefComponent tr : list) {
            String url = tr.getWorkingCode();
            if (!Utilities.isAbsoluteUrl((String)url)) {
                url = "http://hl7.org/fhir/StructureDefinition/" + url;
            }
            long t = System.nanoTime();
            StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, url);
            this.sdTime += System.nanoTime() - t;
            if (sd == null || !sd.getType().equals(type) && !sd.getUrl().equals(type) || !sd.hasSnapshot()) continue;
            return sd;
        }
        return null;
    }

    private org.hl7.fhir.r5.elementmodel.Element getValueForDiscriminator(Object appContext, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, String discriminator, ElementDefinition criteria, NodeStack stack) throws FHIRException, IOException {
        String[] dlist;
        String p = stack.getLiteralPath() + "." + element.getName();
        org.hl7.fhir.r5.elementmodel.Element focus = element;
        for (String d : dlist = discriminator.split("\\.")) {
            if (focus.fhirType().equals("Reference") && d.equals("reference")) {
                String url = focus.getChildValue("reference");
                if (Utilities.noString((String)url)) {
                    throw new FHIRException("No reference resolving discriminator " + discriminator + " from " + element.getProperty().getName());
                }
                org.hl7.fhir.r5.elementmodel.Element target = this.resolve(appContext, url, stack, errors, p);
                if (target == null) {
                    throw new FHIRException("Unable to find resource " + url + " at " + d + " resolving discriminator " + discriminator + " from " + element.getProperty().getName());
                }
                focus = target;
                continue;
            }
            if (d.equals("value") && focus.isPrimitive()) {
                return focus;
            }
            List children = focus.getChildren(d);
            if (children.isEmpty()) {
                throw new FHIRException("Unable to find " + d + " resolving discriminator " + discriminator + " from " + element.getProperty().getName());
            }
            if (children.size() > 1) {
                throw new FHIRException("Found " + Integer.toString(children.size()) + " items for " + d + " resolving discriminator " + discriminator + " from " + element.getProperty().getName());
            }
            focus = (org.hl7.fhir.r5.elementmodel.Element)children.get(0);
            p = p + "." + d;
        }
        return focus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CodeSystem getCodeSystem(String system) {
        long t = System.nanoTime();
        try {
            CodeSystem codeSystem = this.context.fetchCodeSystem(system);
            return codeSystem;
        }
        finally {
            this.txTime += System.nanoTime() - t;
        }
    }

    private boolean hasTime(String fmt) {
        return fmt.contains("T");
    }

    private boolean hasTimeZone(String fmt) {
        return fmt.length() > 10 && (fmt.substring(10).contains("-") || fmt.substring(10).contains("+") || fmt.substring(10).contains("Z"));
    }

    private boolean isAbsolute(String uri) {
        return Utilities.noString((String)uri) || uri.startsWith("http:") || uri.startsWith("https:") || uri.startsWith("urn:uuid:") || uri.startsWith("urn:oid:") || uri.startsWith("urn:ietf:") || uri.startsWith("urn:iso:") || uri.startsWith("urn:iso-astm:") || this.isValidFHIRUrn(uri);
    }

    private boolean isValidFHIRUrn(String uri) {
        return uri.equals("urn:x-fhir:uk:id:nhs-number") || uri.startsWith("urn:");
    }

    public boolean isAnyExtensionsAllowed() {
        return this.anyExtensionsAllowed;
    }

    public boolean isErrorForUnknownProfiles() {
        return this.errorForUnknownProfiles;
    }

    public void setErrorForUnknownProfiles(boolean errorForUnknownProfiles) {
        this.errorForUnknownProfiles = errorForUnknownProfiles;
    }

    private boolean isParametersEntry(String path) {
        String[] parts = path.split("\\.");
        return parts.length > 2 && parts[parts.length - 1].equals("resource") && (InstanceValidator.pathEntryHasName(parts[parts.length - 2], "parameter") || InstanceValidator.pathEntryHasName(parts[parts.length - 2], "part"));
    }

    private boolean isBundleEntry(String path) {
        String[] parts = path.split("\\.");
        return parts.length > 2 && parts[parts.length - 1].equals("resource") && InstanceValidator.pathEntryHasName(parts[parts.length - 2], "entry");
    }

    private boolean isBundleOutcome(String path) {
        String[] parts = path.split("\\.");
        return parts.length > 2 && parts[parts.length - 1].equals("outcome") && InstanceValidator.pathEntryHasName(parts[parts.length - 2], "response");
    }

    private static boolean pathEntryHasName(String thePathEntry, String theName) {
        if (thePathEntry.equals(theName)) {
            return true;
        }
        return thePathEntry.length() >= theName.length() + 3 && thePathEntry.startsWith(theName) && thePathEntry.charAt(theName.length()) == '[';
    }

    private boolean isPrimitiveType(String code) {
        StructureDefinition sd = this.context.fetchTypeDefinition(code);
        return sd != null && sd.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE;
    }

    public boolean isSuppressLoincSnomedMessages() {
        return this.suppressLoincSnomedMessages;
    }

    private boolean nameMatches(String name, String tail) {
        if (tail.endsWith("[x]")) {
            return name.startsWith(tail.substring(0, tail.length() - 3));
        }
        return name.equals(tail);
    }

    private boolean passesCodeWhitespaceRules(String v) {
        if (!v.trim().equals(v)) {
            return false;
        }
        boolean lastWasSpace = true;
        for (char c : v.toCharArray()) {
            if (c == ' ') {
                if (lastWasSpace) {
                    return false;
                }
                lastWasSpace = true;
                continue;
            }
            if (Character.isWhitespace(c)) {
                return false;
            }
            lastWasSpace = false;
        }
        return true;
    }

    private org.hl7.fhir.r5.elementmodel.Element localResolve(String ref, NodeStack stack, List<ValidationMessage> errors, String path) {
        if (ref.startsWith("#")) {
            while (stack != null && stack.getElement() != null) {
                org.hl7.fhir.r5.elementmodel.Element res;
                if (stack.getElement().getProperty().isResource() && (res = this.getContainedById(stack.getElement(), ref.substring(1))) != null) {
                    return res;
                }
                if (stack.getElement().getSpecial() == Element.SpecialElement.BUNDLE_ENTRY) {
                    return null;
                }
                stack = stack.parent;
            }
            return null;
        }
        String fullUrl = null;
        while (stack != null && stack.getElement() != null) {
            String type;
            if (stack.getElement().getSpecial() == Element.SpecialElement.BUNDLE_ENTRY && fullUrl == null && stack.parent != null && stack.parent.getElement().getName().equals("entry")) {
                type = stack.parent.parent.element.getChildValue("type");
                fullUrl = stack.parent.getElement().getChildValue("fullUrl");
                if (fullUrl == null) {
                    this.rule(errors, ValidationMessage.IssueType.REQUIRED, stack.parent.getElement().line(), stack.parent.getElement().col(), stack.parent.getLiteralPath(), Utilities.existsInList((String)type, (String[])new String[]{"batch-response", "transaction-response"}) || fullUrl != null, "Bundle entry missing fullUrl", new Object[0]);
                }
            }
            if ("Bundle".equals(stack.getElement().getType())) {
                type = stack.getElement().getChildValue("type");
                org.hl7.fhir.r5.elementmodel.Element res = this.getFromBundle(stack.getElement(), ref, fullUrl, errors, path, type);
                return res;
            }
            stack = stack.parent;
        }
        return null;
    }

    private org.hl7.fhir.r5.elementmodel.Element resolve(Object appContext, String ref, NodeStack stack, List<ValidationMessage> errors, String path) throws IOException, FHIRException {
        org.hl7.fhir.r5.elementmodel.Element local = this.localResolve(ref, stack, errors, path);
        if (local != null) {
            return local;
        }
        if (this.fetcher == null) {
            return null;
        }
        return this.fetcher.fetch(appContext, ref);
    }

    private ValueSet resolveBindingReference(DomainResource ctxt, String reference, String uri) {
        if (reference != null) {
            if (reference.startsWith("#")) {
                for (Resource c : ctxt.getContained()) {
                    if (!c.getId().equals(reference.substring(1)) || !(c instanceof ValueSet)) continue;
                    return (ValueSet)c;
                }
                return null;
            }
            long t = System.nanoTime();
            ValueSet fr = (ValueSet)this.context.fetchResource(ValueSet.class, reference);
            if (fr == null && !Utilities.isAbsoluteUrl((String)reference)) {
                reference = this.resolve(uri, reference);
                fr = (ValueSet)this.context.fetchResource(ValueSet.class, reference);
            }
            if (fr == null) {
                fr = ValueSetUtilities.generateImplicitValueSet((String)reference);
            }
            this.txTime += System.nanoTime() - t;
            return fr;
        }
        return null;
    }

    private String resolve(String uri, String ref) {
        if (StringUtils.isBlank((CharSequence)uri)) {
            return ref;
        }
        String[] up = uri.split("\\/");
        String[] rp = ref.split("\\/");
        if (this.context.getResourceNames().contains(up[up.length - 2]) && this.context.getResourceNames().contains(rp[0])) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < up.length - 2; ++i) {
                b.append(up[i]);
                b.append("/");
            }
            b.append(ref);
            return b.toString();
        }
        return ref;
    }

    private org.hl7.fhir.r5.elementmodel.Element resolveInBundle(List<org.hl7.fhir.r5.elementmodel.Element> entries, String ref, String fullUrl, String type, String id) {
        String[] parts;
        if (Utilities.isAbsoluteUrl((String)ref)) {
            for (org.hl7.fhir.r5.elementmodel.Element entry : entries) {
                String fu = entry.getNamedChildValue("fullUrl");
                if (!ref.equals(fu)) continue;
                return entry;
            }
            return null;
        }
        String u = null;
        if (fullUrl != null && fullUrl.endsWith(type + "/" + id)) {
            u = fullUrl.substring(0, fullUrl.length() - (type + "/" + id).length()) + ref;
        }
        if ((parts = ref.split("\\/")).length >= 2) {
            String t = parts[0];
            String i = parts[1];
            for (org.hl7.fhir.r5.elementmodel.Element entry : entries) {
                String fu = entry.getNamedChildValue("fullUrl");
                if (u != null && fu.equals(u)) {
                    return entry;
                }
                if (u != null) continue;
                org.hl7.fhir.r5.elementmodel.Element resource = entry.getNamedChild("resource");
                String et = resource.getType();
                String eid = resource.getNamedChildValue("id");
                if (!t.equals(et) || !i.equals(eid)) continue;
                return entry;
            }
        }
        return null;
    }

    private ElementDefinition resolveNameReference(StructureDefinition.StructureDefinitionSnapshotComponent snapshot, String contentReference) {
        for (ElementDefinition ed : snapshot.getElement()) {
            if (!contentReference.equals("#" + ed.getId())) continue;
            return ed;
        }
        return null;
    }

    private StructureDefinition resolveProfile(StructureDefinition profile, String pr) {
        if (pr.startsWith("#")) {
            for (Resource r : profile.getContained()) {
                if (!r.getId().equals(pr.substring(1)) || !(r instanceof StructureDefinition)) continue;
                return (StructureDefinition)r;
            }
            return null;
        }
        long t = System.nanoTime();
        StructureDefinition fr = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, pr);
        this.sdTime += System.nanoTime() - t;
        return fr;
    }

    private ElementDefinition resolveType(String type, List<ElementDefinition.TypeRefComponent> list) {
        for (ElementDefinition.TypeRefComponent tr : list) {
            String url = tr.getWorkingCode();
            if (!Utilities.isAbsoluteUrl((String)url)) {
                url = "http://hl7.org/fhir/StructureDefinition/" + url;
            }
            long t = System.nanoTime();
            StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, url);
            this.sdTime += System.nanoTime() - t;
            if (sd == null || !sd.getType().equals(type) && !sd.getUrl().equals(type) || !sd.hasSnapshot()) continue;
            return (ElementDefinition)sd.getSnapshot().getElement().get(0);
        }
        return null;
    }

    public void setAnyExtensionsAllowed(boolean anyExtensionsAllowed) {
        this.anyExtensionsAllowed = anyExtensionsAllowed;
    }

    public IResourceValidator setBestPracticeWarningLevel(IResourceValidator.BestPracticeWarningLevel value) {
        this.bpWarnings = value;
        return this;
    }

    public void setCheckDisplay(IResourceValidator.CheckDisplayOption checkDisplay) {
        this.checkDisplay = checkDisplay;
    }

    public void setSuppressLoincSnomedMessages(boolean suppressLoincSnomedMessages) {
        this.suppressLoincSnomedMessages = suppressLoincSnomedMessages;
    }

    public IResourceValidator.IdStatus getResourceIdRule() {
        return this.resourceIdRule;
    }

    public void setResourceIdRule(IResourceValidator.IdStatus resourceIdRule) {
        this.resourceIdRule = resourceIdRule;
    }

    public boolean isAllowXsiLocation() {
        return this.allowXsiLocation;
    }

    public void setAllowXsiLocation(boolean allowXsiLocation) {
        this.allowXsiLocation = allowXsiLocation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean sliceMatches(ValidatorHostContext hostContext, org.hl7.fhir.r5.elementmodel.Element element, String path, ElementDefinition slicer, ElementDefinition ed, StructureDefinition profile, List<ValidationMessage> errors, NodeStack stack) throws DefinitionException, FHIRException, IOException {
        if (!slicer.getSlicing().hasDiscriminator()) {
            return false;
        }
        ExpressionNode n = (ExpressionNode)ed.getUserData("slice.expression.cache");
        if (n != null) return this.evaluateSlicingExpression(hostContext, element, path, profile, n);
        long t = System.nanoTime();
        StringBuilder expression = new StringBuilder("true");
        boolean anyFound = false;
        HashSet<String> discriminators = new HashSet<String>();
        for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent s : slicer.getSlicing().getDiscriminator()) {
            String discriminator = s.getPath();
            discriminators.add(discriminator);
            List<ElementDefinition> criteriaElements = this.getCriteriaForDiscriminator(path, ed, discriminator, profile, s.getType() == ElementDefinition.DiscriminatorType.PROFILE);
            boolean found = false;
            for (ElementDefinition criteriaElement : criteriaElements) {
                found = true;
                if (s.getType() == ElementDefinition.DiscriminatorType.TYPE) {
                    String type = null;
                    if (!criteriaElement.getPath().contains("[") && discriminator.contains("[")) {
                        discriminator = discriminator.substring(0, discriminator.indexOf(91));
                        String lastNode = this.tail(discriminator);
                        type = this.tail(criteriaElement.getPath()).substring(lastNode.length());
                        type = type.substring(0, 1).toLowerCase() + type.substring(1);
                    } else if (!criteriaElement.hasType() || criteriaElement.getType().size() == 1) {
                        if (discriminator.contains("[")) {
                            discriminator = discriminator.substring(0, discriminator.indexOf(91));
                        }
                        type = ((ElementDefinition.TypeRefComponent)criteriaElement.getType().get(0)).getWorkingCode();
                    } else {
                        if (criteriaElement.getType().size() <= 1) throw new DefinitionException("Discriminator (" + discriminator + ") is based on type, but slice " + ed.getId() + " in " + profile.getUrl() + " has no types");
                        throw new DefinitionException("Discriminator (" + discriminator + ") is based on type, but slice " + ed.getId() + " in " + profile.getUrl() + " has multiple types: " + criteriaElement.typeSummary());
                    }
                    if (discriminator.isEmpty()) {
                        expression.append(" and this is " + type);
                    } else {
                        expression.append(" and " + discriminator + " is " + type);
                    }
                } else if (s.getType() == ElementDefinition.DiscriminatorType.PROFILE) {
                    List list;
                    if (criteriaElement.getType().size() == 0) {
                        throw new DefinitionException("Profile based discriminators must have a type (" + criteriaElement.getId() + ")");
                    }
                    if (criteriaElement.getType().size() != 1) {
                        throw new DefinitionException("Profile based discriminators must have only one type (" + criteriaElement.getId() + ")");
                    }
                    List list2 = list = discriminator.endsWith(".resolve()") || discriminator.equals("resolve()") ? ((ElementDefinition.TypeRefComponent)criteriaElement.getType().get(0)).getTargetProfile() : ((ElementDefinition.TypeRefComponent)criteriaElement.getType().get(0)).getProfile();
                    if (list.size() == 0) {
                        throw new DefinitionException("Profile based discriminators must have a type with a profile (" + criteriaElement.getId() + ")");
                    }
                    if (list.size() > 1) {
                        throw new DefinitionException("Profile based discriminators must have a type with only one profile (" + criteriaElement.getId() + ")");
                    }
                    expression.append(" and " + discriminator + ".conformsTo('" + (String)((CanonicalType)list.get(0)).getValue() + "')");
                } else if (s.getType() == ElementDefinition.DiscriminatorType.EXISTS) {
                    if (criteriaElement.hasMin() && criteriaElement.getMin() >= 1) {
                        expression.append(" and (" + discriminator + ".exists())");
                    } else {
                        if (!criteriaElement.hasMax() || !criteriaElement.getMax().equals("0")) throw new FHIRException("Discriminator (" + discriminator + ") is based on element existence, but slice " + ed.getId() + " neither sets min>=1 or max=0");
                        expression.append(" and (" + discriminator + ".exists().not())");
                    }
                } else if (criteriaElement.hasFixed()) {
                    this.buildFixedExpression(ed, expression, discriminator, criteriaElement);
                } else if (criteriaElement.hasPattern()) {
                    this.buildPattternExpression(ed, expression, discriminator, criteriaElement);
                } else if (criteriaElement.hasBinding() && criteriaElement.getBinding().hasStrength() && criteriaElement.getBinding().getStrength().equals((Object)Enumerations.BindingStrength.REQUIRED) && criteriaElement.getBinding().hasValueSet()) {
                    expression.append(" and (" + discriminator + " memberOf '" + criteriaElement.getBinding().getValueSet() + "')");
                } else {
                    found = false;
                }
                if (!found) continue;
                break;
            }
            if (!found) continue;
            anyFound = true;
        }
        if (!anyFound) {
            if (slicer.getSlicing().getDiscriminator().size() <= 1) throw new DefinitionException("Could not match discriminator (" + discriminators + ") for slice " + ed.getId() + " in profile " + profile.getUrl() + " - the discriminator " + discriminators + " does not have fixed value, binding or existence assertions");
            throw new DefinitionException("Could not match any discriminators (" + discriminators + ") for slice " + ed.getId() + " in profile " + profile.getUrl() + " - None of the discriminator " + discriminators + " have fixed value, binding or existence assertions");
        }
        try {
            n = this.fpe.parse(this.fixExpr(expression.toString()));
        }
        catch (FHIRLexer.FHIRLexerException e) {
            throw new FHIRException("Problem processing expression " + expression + " in profile " + profile.getUrl() + " path " + path + ": " + e.getMessage());
        }
        this.fpeTime += System.nanoTime() - t;
        ed.setUserData("slice.expression.cache", (Object)n);
        return this.evaluateSlicingExpression(hostContext, element, path, profile, n);
    }

    public boolean evaluateSlicingExpression(ValidatorHostContext hostContext, org.hl7.fhir.r5.elementmodel.Element element, String path, StructureDefinition profile, ExpressionNode n) throws FHIRException {
        boolean ok;
        try {
            long t = System.nanoTime();
            ok = this.fpe.evaluateToBoolean((Object)hostContext.forProfile(profile), (Base)hostContext.resource, (Base)hostContext.rootResource, (Base)element, n);
            this.fpeTime += System.nanoTime() - t;
            String msg = this.fpe.forLog();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new FHIRException("Problem evaluating slicing expression for element in profile " + profile.getUrl() + " path " + path + " (fhirPath = " + n + "): " + ex.getMessage());
        }
        return ok;
    }

    private void buildPattternExpression(ElementDefinition ed, StringBuilder expression, String discriminator, ElementDefinition criteriaElement) throws DefinitionException {
        Type pattern = criteriaElement.getPattern();
        if (pattern instanceof CodeableConcept) {
            CodeableConcept cc = (CodeableConcept)pattern;
            expression.append(" and ");
            this.buildCodeableConceptExpression(ed, expression, discriminator, cc);
        } else if (pattern instanceof Identifier) {
            Identifier ii = (Identifier)pattern;
            expression.append(" and ");
            this.buildIdentifierExpression(ed, expression, discriminator, ii);
        } else {
            throw new DefinitionException("Unsupported fixed pattern type for discriminator(" + discriminator + ") for slice " + ed.getId() + ": " + pattern.getClass().getName());
        }
    }

    private void buildIdentifierExpression(ElementDefinition ed, StringBuilder expression, String discriminator, Identifier ii) throws DefinitionException {
        if (ii.hasExtension()) {
            throw new DefinitionException("Unsupported Identifier pattern - extensions are not allowed - for discriminator(" + discriminator + ") for slice " + ed.getId());
        }
        boolean first = true;
        expression.append(discriminator + ".where(");
        if (ii.hasSystem()) {
            first = false;
            expression.append("system = '" + ii.getSystem() + "'");
        }
        if (ii.hasValue()) {
            if (first) {
                first = false;
            } else {
                expression.append(" and ");
            }
            expression.append("value = '" + ii.getValue() + "'");
        }
        if (ii.hasUse()) {
            if (first) {
                first = false;
            } else {
                expression.append(" and ");
            }
            expression.append("use = '" + ii.getUse() + "'");
        }
        if (ii.hasType()) {
            if (first) {
                first = false;
            } else {
                expression.append(" and ");
            }
            this.buildCodeableConceptExpression(ed, expression, "type", ii.getType());
        }
        expression.append(").exists()");
    }

    private void buildCodeableConceptExpression(ElementDefinition ed, StringBuilder expression, String discriminator, CodeableConcept cc) throws DefinitionException {
        if (cc.hasText()) {
            throw new DefinitionException("Unsupported CodeableConcept pattern - using text - for discriminator(" + discriminator + ") for slice " + ed.getId());
        }
        if (!cc.hasCoding()) {
            throw new DefinitionException("Unsupported CodeableConcept pattern - must have at least one coding - for discriminator(" + discriminator + ") for slice " + ed.getId());
        }
        if (cc.hasExtension()) {
            throw new DefinitionException("Unsupported CodeableConcept pattern - extensions are not allowed - for discriminator(" + discriminator + ") for slice " + ed.getId());
        }
        boolean firstCoding = true;
        for (Coding c : cc.getCoding()) {
            if (c.hasExtension()) {
                throw new DefinitionException("Unsupported CodeableConcept pattern - extensions are not allowed - for discriminator(" + discriminator + ") for slice " + ed.getId());
            }
            if (firstCoding) {
                firstCoding = false;
            } else {
                expression.append(" and ");
            }
            expression.append(discriminator + ".coding.where(");
            boolean first = true;
            if (c.hasSystem()) {
                first = false;
                expression.append("system = '" + c.getSystem() + "'");
            }
            if (c.hasVersion()) {
                if (first) {
                    first = false;
                } else {
                    expression.append(" and ");
                }
                expression.append("version = '" + c.getVersion() + "'");
            }
            if (c.hasCode()) {
                if (first) {
                    first = false;
                } else {
                    expression.append(" and ");
                }
                expression.append("code = '" + c.getCode() + "'");
            }
            if (c.hasDisplay()) {
                if (first) {
                    first = false;
                } else {
                    expression.append(" and ");
                }
                expression.append("display = '" + c.getDisplay() + "'");
            }
            expression.append(").exists()");
        }
    }

    private void buildFixedExpression(ElementDefinition ed, StringBuilder expression, String discriminator, ElementDefinition criteriaElement) throws DefinitionException {
        Type fixed = criteriaElement.getFixed();
        if (fixed instanceof CodeableConcept) {
            CodeableConcept cc = (CodeableConcept)fixed;
            expression.append(" and ");
            this.buildCodeableConceptExpression(ed, expression, discriminator, cc);
        } else if (fixed instanceof Identifier) {
            Identifier ii = (Identifier)fixed;
            expression.append(" and ");
            this.buildIdentifierExpression(ed, expression, discriminator, ii);
        } else {
            expression.append(" and (");
            if (fixed instanceof StringType) {
                Gson gson = new Gson();
                String json = gson.toJson((Object)((StringType)fixed));
                String escapedString = json.substring(json.indexOf(":") + 2);
                escapedString = escapedString.substring(0, escapedString.indexOf(",\"myStringValue") - 1);
                expression.append("'" + escapedString + "'");
            } else if (fixed instanceof UriType) {
                expression.append("'" + ((UriType)fixed).asStringValue() + "'");
            } else if (fixed instanceof IntegerType) {
                expression.append(((IntegerType)fixed).asStringValue());
            } else if (fixed instanceof DecimalType) {
                expression.append(((IntegerType)fixed).asStringValue());
            } else if (fixed instanceof BooleanType) {
                expression.append(((BooleanType)fixed).asStringValue());
            } else {
                throw new DefinitionException("Unsupported fixed value type for discriminator(" + discriminator + ") for slice " + ed.getId() + ": " + fixed.getClass().getName());
            }
            expression.append(" in " + discriminator + ")");
        }
    }

    private void start(ValidatorHostContext hostContext, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition defn, NodeStack stack) throws FHIRException, FHIRException, IOException {
        this.checkLang(resource, stack);
        ResourceProfiles resourceProfiles = this.getResourceProfiles(element, stack);
        if (!resourceProfiles.isProcessed()) {
            this.checkDeclaredProfiles(resourceProfiles, errors, resource, element, stack);
        }
        if (!resourceProfiles.isProcessed()) {
            resourceProfiles.setProcessed();
            if (!resourceProfiles.hasProfiles() && this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath(), defn.hasSnapshot(), "StructureDefinition has no snapshot - validation is against the snapshot, so it must be provided", new Object[0])) {
                this.validateElement(hostContext, errors, defn, (ElementDefinition)defn.getSnapshot().getElement().get(0), null, null, resource, element, element.getName(), stack, false, true);
            }
            if (element.getType().equals("Bundle")) {
                this.validateBundle(errors, element, stack);
            } else if (element.getType().equals("Observation")) {
                this.validateObservation(errors, element, stack);
            } else if (element.getType().equals("Questionnaire")) {
                this.validateQuestionannaire(errors, element, stack);
            } else if (element.getType().equals("QuestionnaireResponse")) {
                this.validateQuestionannaireResponse(hostContext, errors, element, stack);
            } else if (element.getType().equals("CodeSystem")) {
                this.validateCodeSystem(errors, element, stack);
            }
            this.validateResourceRules(errors, element, stack);
        }
        for (ProfileUsage profileUsage : resourceProfiles.uncheckedProfiles()) {
            profileUsage.setChecked();
            this.validateElement(hostContext, errors, profileUsage.getProfile(), (ElementDefinition)profileUsage.getProfile().getSnapshot().getElement().get(0), null, null, resource, element, element.getName(), stack, false, true);
        }
    }

    private void validateQuestionannaire(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack) {
        List<org.hl7.fhir.r5.elementmodel.Element> list = this.getItems(element);
        for (int i = 0; i < list.size(); ++i) {
            org.hl7.fhir.r5.elementmodel.Element e = list.get(i);
            NodeStack ns = stack.push(element, i, e.getProperty().getDefinition(), e.getProperty().getDefinition());
            this.validateQuestionnaireElement(errors, ns, element, e, new ArrayList<org.hl7.fhir.r5.elementmodel.Element>());
        }
    }

    private void validateQuestionnaireElement(List<ValidationMessage> errors, NodeStack ns, org.hl7.fhir.r5.elementmodel.Element questionnaire, org.hl7.fhir.r5.elementmodel.Element item, List<org.hl7.fhir.r5.elementmodel.Element> parents) {
        if (Enumerations.FHIRVersion.isR4Plus((String)this.context.getVersion()) && item.hasChild("enableWhen")) {
            org.hl7.fhir.r5.elementmodel.Element ew = item.getNamedChild("enableWhen");
            String ql = ew.getNamedChildValue("question");
            if (this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, ns.literalPath, ql != null, "Questions with an enableWhen must have a value for the question link")) {
                org.hl7.fhir.r5.elementmodel.Element tgt = this.getQuestionById(item, ql);
                if (this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, ns.literalPath, tgt == null, "Questions with an enableWhen cannot refer to an inner question for it's enableWhen condition")) {
                    tgt = this.getQuestionById(questionnaire, ql);
                    if (this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, ns.literalPath, tgt != null, "Unable to find " + ql + " target for this question enableWhen") && this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, ns.literalPath, tgt != item, "Target for this question enableWhen can't reference itself")) {
                        this.warning(errors, ValidationMessage.IssueType.BUSINESSRULE, ns.literalPath, this.isBefore(item, tgt, parents), "The target of this enableWhen rule (" + ql + ") comes after the question itself");
                    }
                }
            }
        }
    }

    private boolean isBefore(org.hl7.fhir.r5.elementmodel.Element item, org.hl7.fhir.r5.elementmodel.Element tgt, List<org.hl7.fhir.r5.elementmodel.Element> parents) {
        for (org.hl7.fhir.r5.elementmodel.Element p : parents) {
            int i = this.findIndex(p, item);
            int t = this.findIndex(p, tgt);
            if (i <= -1 || t <= -1) continue;
            return i > t;
        }
        return false;
    }

    private int findIndex(org.hl7.fhir.r5.elementmodel.Element parent, org.hl7.fhir.r5.elementmodel.Element descendant) {
        for (int i = 0; i < parent.getChildren().size(); ++i) {
            if (parent.getChildren().get(i) != descendant && !this.isChild((org.hl7.fhir.r5.elementmodel.Element)parent.getChildren().get(i), descendant)) continue;
            return i;
        }
        return -1;
    }

    private boolean isChild(org.hl7.fhir.r5.elementmodel.Element element, org.hl7.fhir.r5.elementmodel.Element descendant) {
        for (org.hl7.fhir.r5.elementmodel.Element e : element.getChildren()) {
            if (e == descendant) {
                return true;
            }
            if (!this.isChild(element, descendant)) continue;
            return true;
        }
        return false;
    }

    private org.hl7.fhir.r5.elementmodel.Element getQuestionById(org.hl7.fhir.r5.elementmodel.Element focus, String ql) {
        List<org.hl7.fhir.r5.elementmodel.Element> list = this.getItems(focus);
        for (org.hl7.fhir.r5.elementmodel.Element item : list) {
            String v = item.getNamedChildValue("linkId");
            if (ql.equals(v)) {
                return item;
            }
            org.hl7.fhir.r5.elementmodel.Element tgt = this.getQuestionById(item, ql);
            if (tgt == null) continue;
            return tgt;
        }
        return null;
    }

    private List<org.hl7.fhir.r5.elementmodel.Element> getItems(org.hl7.fhir.r5.elementmodel.Element element) {
        ArrayList<org.hl7.fhir.r5.elementmodel.Element> list = new ArrayList<org.hl7.fhir.r5.elementmodel.Element>();
        element.getNamedChildren("item", list);
        return list;
    }

    private void checkLang(org.hl7.fhir.r5.elementmodel.Element resource, NodeStack stack) {
        String lang = resource.getNamedChildValue("language");
        if (!Utilities.noString((String)lang)) {
            stack.workingLang = lang;
        }
    }

    private void validateResourceRules(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack) {
        org.hl7.fhir.r5.elementmodel.Element meta;
        String lang = element.getNamedChildValue("language");
        org.hl7.fhir.r5.elementmodel.Element text = element.getNamedChild("text");
        if (text != null) {
            org.hl7.fhir.r5.elementmodel.Element div = text.getNamedChild("div");
            if (lang != null && div != null) {
                XhtmlNode xhtml = div.getXhtml();
                String xl = xhtml.getAttribute("lang");
                if (xl == null) {
                    this.warning(errors, ValidationMessage.IssueType.BUSINESSRULE, div.line(), div.col(), stack.getLiteralPath(), false, "Resource has a language, but the XHTML does not have a language tag", new Object[0]);
                } else if (!xl.equals(lang)) {
                    this.warning(errors, ValidationMessage.IssueType.BUSINESSRULE, div.line(), div.col(), stack.getLiteralPath(), false, "Resource has a language (" + lang + "), and the XHTML has a language (" + xl + "), but they differ ", new Object[0]);
                }
            }
        }
        if ((meta = element.getNamedChild("meta")) != null) {
            HashSet<String> tags = new HashSet<String>();
            ArrayList list = new ArrayList();
            meta.getNamedChildren("security", list);
            int i = 0;
            for (org.hl7.fhir.r5.elementmodel.Element e : list) {
                String s = e.getNamedChildValue("system") + "#" + e.getNamedChildValue("code");
                this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, e.line(), e.col(), stack.getLiteralPath() + ".meta.profile[" + Integer.toString(i) + "]", !tags.contains(s), "Duplicate Security Label " + s, new Object[0]);
                tags.add(s);
                ++i;
            }
        }
    }

    private void validateCodeSystem(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element cs, NodeStack stack) {
        String url = cs.getNamedChildValue("url");
        String vsu = cs.getNamedChildValue("valueSet");
        if (!Utilities.noString((String)vsu)) {
            ValueSet vs;
            try {
                vs = (ValueSet)this.context.fetchResourceWithException(ValueSet.class, vsu);
            }
            catch (FHIRException e) {
                vs = null;
            }
            if (vs != null && this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), vs.hasCompose() && !vs.hasExpansion(), "CodeSystem " + url + " has a 'all system' value set of " + vsu + ", but it is an expansion") && this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), vs.getCompose().getInclude().size() == 1, "CodeSystem " + url + " has a 'all system' value set of " + vsu + ", but doesn't have a single include") && this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), ((ValueSet.ConceptSetComponent)vs.getCompose().getInclude().get(0)).getSystem().equals(url), "CodeSystem " + url + " has a 'all system' value set of " + vsu + ", but doesn't have a matching system (" + ((ValueSet.ConceptSetComponent)vs.getCompose().getInclude().get(0)).getSystem() + ")")) {
                this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), !((ValueSet.ConceptSetComponent)vs.getCompose().getInclude().get(0)).hasValueSet() && !((ValueSet.ConceptSetComponent)vs.getCompose().getInclude().get(0)).hasConcept() && !((ValueSet.ConceptSetComponent)vs.getCompose().getInclude().get(0)).hasFilter(), "CodeSystem " + url + " has a 'all system' value set of " + vsu + ", but the include has extra details");
            }
        }
    }

    private void validateQuestionannaireResponse(ValidatorHostContext hostContext, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack) throws FHIRException, IOException {
        org.hl7.fhir.r5.elementmodel.Element q = element.getNamedChild("questionnaire");
        String questionnaire = null;
        if (q != null) {
            if (StringUtils.isNotBlank((CharSequence)q.getValue())) {
                questionnaire = q.getValue();
            } else if (StringUtils.isNotBlank((CharSequence)q.getChildValue("reference"))) {
                questionnaire = q.getChildValue("reference");
            }
        }
        if (this.hint(errors, ValidationMessage.IssueType.REQUIRED, element.line(), element.col(), stack.getLiteralPath(), questionnaire != null, "No questionnaire is identified, so no validation can be performed against the base questionnaire")) {
            long t = System.nanoTime();
            Questionnaire qsrc = questionnaire.startsWith("#") ? this.loadQuestionnaire(element, questionnaire.substring(1)) : (Questionnaire)this.context.fetchResource(Questionnaire.class, questionnaire);
            this.sdTime += System.nanoTime() - t;
            if (this.warning(errors, ValidationMessage.IssueType.REQUIRED, q.line(), q.col(), stack.getLiteralPath(), qsrc != null, "The questionnaire \"" + questionnaire + "\" could not be resolved, so no validation can be performed against the base questionnaire", new Object[0])) {
                boolean inProgress = "in-progress".equals(element.getNamedChildValue("status"));
                this.validateQuestionannaireResponseItems(hostContext, qsrc, qsrc.getItem(), errors, element, stack, inProgress, element, new EnableWhenEvaluator.QStack(qsrc, element));
            }
        }
    }

    private Questionnaire loadQuestionnaire(org.hl7.fhir.r5.elementmodel.Element resource, String id) throws FHIRException, IOException {
        for (org.hl7.fhir.r5.elementmodel.Element contained : resource.getChildren("contained")) {
            if (!contained.getIdBase().equals(id)) continue;
            FhirPublication v = FhirPublication.fromCode((String)this.context.getVersion());
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            new org.hl7.fhir.r5.elementmodel.JsonParser(this.context).compose(contained, (OutputStream)bs, IParser.OutputStyle.NORMAL, id);
            byte[] json = bs.toByteArray();
            switch (v) {
                case DSTU1: {
                    throw new FHIRException("Unsupported version R1");
                }
                case DSTU2: {
                    org.hl7.fhir.dstu2.model.Resource r2 = new org.hl7.fhir.dstu2.formats.JsonParser().parse(json);
                    Resource r5 = new VersionConvertor_10_50(null).convertResource(r2);
                    if (r5 instanceof Questionnaire) {
                        return (Questionnaire)r5;
                    }
                    return null;
                }
                case DSTU2016May: {
                    org.hl7.fhir.dstu2016may.model.Resource r2a = new JsonParser().parse(json);
                    Resource r5 = VersionConvertor_14_50.convertResource((org.hl7.fhir.dstu2016may.model.Resource)r2a);
                    if (r5 instanceof Questionnaire) {
                        return (Questionnaire)r5;
                    }
                    return null;
                }
                case STU3: {
                    org.hl7.fhir.dstu3.model.Resource r3 = new org.hl7.fhir.dstu3.formats.JsonParser().parse(json);
                    Resource r5 = VersionConvertor_30_50.convertResource((org.hl7.fhir.dstu3.model.Resource)r3, (boolean)false);
                    if (r5 instanceof Questionnaire) {
                        return (Questionnaire)r5;
                    }
                    return null;
                }
                case R4: {
                    org.hl7.fhir.r4.model.Resource r4 = new org.hl7.fhir.r4.formats.JsonParser().parse(json);
                    Resource r5 = VersionConvertor_40_50.convertResource((org.hl7.fhir.r4.model.Resource)r4);
                    if (r5 instanceof Questionnaire) {
                        return (Questionnaire)r5;
                    }
                    return null;
                }
                case R5: {
                    Resource r5 = new org.hl7.fhir.r5.formats.JsonParser().parse(json);
                    if (r5 instanceof Questionnaire) {
                        return (Questionnaire)r5;
                    }
                    return null;
                }
            }
        }
        return null;
    }

    private void validateQuestionnaireResponseItem(ValidatorHostContext hostContext, Questionnaire qsrc, Questionnaire.QuestionnaireItemComponent qItem, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack, boolean inProgress, org.hl7.fhir.r5.elementmodel.Element questionnaireResponseRoot, EnableWhenEvaluator.QStack qstack) {
        String text = element.getNamedChildValue("text");
        this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), Utilities.noString((String)text) || text.equals(qItem.getText()), "If text exists, it must match the questionnaire definition for linkId " + qItem.getLinkId(), new Object[0]);
        ArrayList<org.hl7.fhir.r5.elementmodel.Element> answers = new ArrayList<org.hl7.fhir.r5.elementmodel.Element>();
        element.getNamedChildren("answer", answers);
        if (inProgress) {
            this.warning(errors, ValidationMessage.IssueType.REQUIRED, element.line(), element.col(), stack.getLiteralPath(), this.isAnswerRequirementFulfilled(qItem, answers), "No response answer found for required item " + qItem.getLinkId(), new Object[0]);
        } else if (this.myEnableWhenEvaluator.isQuestionEnabled(hostContext, qItem, qstack, this.fpe)) {
            this.rule(errors, ValidationMessage.IssueType.REQUIRED, element.line(), element.col(), stack.getLiteralPath(), this.isAnswerRequirementFulfilled(qItem, answers), "No response answer found for required item " + qItem.getLinkId(), new Object[0]);
        } else if (!answers.isEmpty()) {
            // empty if block
        }
        if (answers.size() > 1) {
            this.rule(errors, ValidationMessage.IssueType.INVALID, ((org.hl7.fhir.r5.elementmodel.Element)answers.get(1)).line(), ((org.hl7.fhir.r5.elementmodel.Element)answers.get(1)).col(), stack.getLiteralPath(), qItem.getRepeats(), "Only one response answer item with this linkId allowed", new Object[0]);
        }
        for (org.hl7.fhir.r5.elementmodel.Element answer : answers) {
            NodeStack ns = stack.push(answer, -1, null, null);
            if (qItem.getType() != null) {
                switch (qItem.getType()) {
                    case GROUP: {
                        this.rule(errors, ValidationMessage.IssueType.STRUCTURE, answer.line(), answer.col(), stack.getLiteralPath(), false, "Items of type group should not have answers", new Object[0]);
                        break;
                    }
                    case DISPLAY: {
                        break;
                    }
                    case BOOLEAN: {
                        this.validateQuestionnaireResponseItemType(errors, answer, ns, "boolean");
                        break;
                    }
                    case DECIMAL: {
                        this.validateQuestionnaireResponseItemType(errors, answer, ns, "decimal");
                        break;
                    }
                    case INTEGER: {
                        this.validateQuestionnaireResponseItemType(errors, answer, ns, "integer");
                        break;
                    }
                    case DATE: {
                        this.validateQuestionnaireResponseItemType(errors, answer, ns, "date");
                        break;
                    }
                    case DATETIME: {
                        this.validateQuestionnaireResponseItemType(errors, answer, ns, "dateTime");
                        break;
                    }
                    case TIME: {
                        this.validateQuestionnaireResponseItemType(errors, answer, ns, "time");
                        break;
                    }
                    case STRING: {
                        this.validateQuestionnaireResponseItemType(errors, answer, ns, "string");
                        break;
                    }
                    case TEXT: {
                        this.validateQuestionnaireResponseItemType(errors, answer, ns, "text");
                        break;
                    }
                    case URL: {
                        this.validateQuestionnaireResponseItemType(errors, answer, ns, "uri");
                        break;
                    }
                    case ATTACHMENT: {
                        this.validateQuestionnaireResponseItemType(errors, answer, ns, "Attachment");
                        break;
                    }
                    case REFERENCE: {
                        this.validateQuestionnaireResponseItemType(errors, answer, ns, "Reference");
                        break;
                    }
                    case QUANTITY: {
                        if (!"Quantity".equals(this.validateQuestionnaireResponseItemType(errors, answer, ns, "Quantity")) || !qItem.hasExtension("???")) break;
                        this.validateQuestionnaireResponseItemQuantity(errors, answer, ns);
                        break;
                    }
                    case CHOICE: {
                        String itemType = this.validateQuestionnaireResponseItemType(errors, answer, ns, "Coding", "date", "time", "integer", "string");
                        if (itemType == null) break;
                        if (itemType.equals("Coding")) {
                            this.validateAnswerCode(errors, answer, ns, qsrc, qItem, false);
                            break;
                        }
                        if (itemType.equals("date")) {
                            this.checkOption(errors, answer, ns, qsrc, qItem, "date");
                            break;
                        }
                        if (itemType.equals("time")) {
                            this.checkOption(errors, answer, ns, qsrc, qItem, "time");
                            break;
                        }
                        if (itemType.equals("integer")) {
                            this.checkOption(errors, answer, ns, qsrc, qItem, "integer");
                            break;
                        }
                        if (!itemType.equals("string")) break;
                        this.checkOption(errors, answer, ns, qsrc, qItem, "string");
                        break;
                    }
                    case OPENCHOICE: {
                        String itemType = this.validateQuestionnaireResponseItemType(errors, answer, ns, "Coding", "date", "time", "integer", "string");
                        if (itemType == null) break;
                        if (itemType.equals("Coding")) {
                            this.validateAnswerCode(errors, answer, ns, qsrc, qItem, true);
                            break;
                        }
                        if (itemType.equals("date")) {
                            this.checkOption(errors, answer, ns, qsrc, qItem, "date");
                            break;
                        }
                        if (itemType.equals("time")) {
                            this.checkOption(errors, answer, ns, qsrc, qItem, "time");
                            break;
                        }
                        if (itemType.equals("integer")) {
                            this.checkOption(errors, answer, ns, qsrc, qItem, "integer");
                            break;
                        }
                        if (!itemType.equals("string")) break;
                        this.checkOption(errors, answer, ns, qsrc, qItem, "string", true);
                        break;
                    }
                }
            }
            this.validateQuestionannaireResponseItems(hostContext, qsrc, qItem.getItem(), errors, answer, stack, inProgress, questionnaireResponseRoot, qstack);
        }
        if (qItem.getType() == null) {
            this.fail(errors, ValidationMessage.IssueType.REQUIRED, element.line(), element.col(), stack.getLiteralPath(), false, "Definition for item " + qItem.getLinkId() + " does not contain a type");
        } else if (qItem.getType() == Questionnaire.QuestionnaireItemType.DISPLAY) {
            ArrayList items = new ArrayList();
            element.getNamedChildren("item", items);
            this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath(), items.isEmpty(), "Items not of type DISPLAY should not have items - linkId {0}", qItem.getLinkId());
        } else {
            this.validateQuestionannaireResponseItems(hostContext, qsrc, qItem.getItem(), errors, element, stack, inProgress, questionnaireResponseRoot, qstack);
        }
    }

    private boolean isAnswerRequirementFulfilled(Questionnaire.QuestionnaireItemComponent qItem, List<org.hl7.fhir.r5.elementmodel.Element> answers) {
        return !answers.isEmpty() || !qItem.getRequired() || qItem.getType() == Questionnaire.QuestionnaireItemType.GROUP;
    }

    private void validateQuestionnaireResponseItem(ValidatorHostContext hostcontext, Questionnaire qsrc, Questionnaire.QuestionnaireItemComponent qItem, List<ValidationMessage> errors, List<org.hl7.fhir.r5.elementmodel.Element> elements, NodeStack stack, boolean inProgress, org.hl7.fhir.r5.elementmodel.Element questionnaireResponseRoot, EnableWhenEvaluator.QStack qstack) {
        if (elements.size() > 1) {
            this.rule(errors, ValidationMessage.IssueType.INVALID, elements.get(1).line(), elements.get(1).col(), stack.getLiteralPath(), qItem.getRepeats(), "Only one response item with this linkId allowed - " + qItem.getLinkId(), new Object[0]);
        }
        int i = 0;
        for (org.hl7.fhir.r5.elementmodel.Element element : elements) {
            NodeStack ns = stack.push(element, i, null, null);
            this.validateQuestionnaireResponseItem(hostcontext, qsrc, qItem, errors, element, ns, inProgress, questionnaireResponseRoot, qstack.push(qItem, element));
            ++i;
        }
    }

    private int getLinkIdIndex(List<Questionnaire.QuestionnaireItemComponent> qItems, String linkId) {
        for (int i = 0; i < qItems.size(); ++i) {
            if (!linkId.equals(qItems.get(i).getLinkId())) continue;
            return i;
        }
        return -1;
    }

    private void validateQuestionannaireResponseItems(ValidatorHostContext hostContext, Questionnaire qsrc, List<Questionnaire.QuestionnaireItemComponent> qItems, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack, boolean inProgress, org.hl7.fhir.r5.elementmodel.Element questionnaireResponseRoot, EnableWhenEvaluator.QStack qstack) {
        ArrayList items = new ArrayList();
        element.getNamedChildren("item", items);
        HashMap<String, List> map = new HashMap<String, List>();
        int lastIndex = -1;
        for (org.hl7.fhir.r5.elementmodel.Element item : items) {
            String linkId = item.getNamedChildValue("linkId");
            if (!this.rule(errors, ValidationMessage.IssueType.REQUIRED, item.line(), item.col(), stack.getLiteralPath(), !Utilities.noString((String)linkId), "No LinkId, so can't be validated", new Object[0])) continue;
            int index = this.getLinkIdIndex(qItems, linkId);
            if (index == -1) {
                Questionnaire.QuestionnaireItemComponent qItem = this.findQuestionnaireItem(qsrc, linkId);
                if (qItem != null) {
                    this.rule(errors, ValidationMessage.IssueType.STRUCTURE, item.line(), item.col(), stack.getLiteralPath(), index > -1, this.misplacedItemError(qItem), new Object[0]);
                    NodeStack ns = stack.push(item, -1, null, null);
                    this.validateQuestionnaireResponseItem(hostContext, qsrc, qItem, errors, item, ns, inProgress, questionnaireResponseRoot, qstack.push(qItem, item));
                    continue;
                }
                this.rule(errors, ValidationMessage.IssueType.NOTFOUND, item.line(), item.col(), stack.getLiteralPath(), index > -1, "LinkId \"" + linkId + "\" not found in questionnaire", new Object[0]);
                continue;
            }
            this.rule(errors, ValidationMessage.IssueType.STRUCTURE, item.line(), item.col(), stack.getLiteralPath(), index >= lastIndex, "Structural Error: items are out of order", new Object[0]);
            lastIndex = index;
            if (!item.hasChildren("answer") && !item.hasChildren("item")) continue;
            List mapItem = map.computeIfAbsent(linkId, key -> new ArrayList());
            mapItem.add(item);
        }
        for (Questionnaire.QuestionnaireItemComponent qItem : qItems) {
            List mapItem = (List)map.get(qItem.getLinkId());
            this.validateQuestionnaireResponseItem(hostContext, qsrc, errors, element, stack, inProgress, questionnaireResponseRoot, qItem, mapItem, qstack);
        }
    }

    public void validateQuestionnaireResponseItem(ValidatorHostContext hostContext, Questionnaire qsrc, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack, boolean inProgress, org.hl7.fhir.r5.elementmodel.Element questionnaireResponseRoot, Questionnaire.QuestionnaireItemComponent qItem, List<org.hl7.fhir.r5.elementmodel.Element> mapItem, EnableWhenEvaluator.QStack qstack) {
        boolean enabled = this.myEnableWhenEvaluator.isQuestionEnabled(hostContext, qItem, qstack, this.fpe);
        if (mapItem != null) {
            if (!enabled) {
                int i = 0;
                for (org.hl7.fhir.r5.elementmodel.Element e : mapItem) {
                    NodeStack ns = stack.push(e, i, e.getProperty().getDefinition(), e.getProperty().getDefinition());
                    this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), ns.getLiteralPath(), enabled, "Item has answer, even though it is not enabled (item id = '" + qItem.getLinkId() + "')", new Object[0]);
                    ++i;
                }
            }
            this.validateQuestionnaireResponseItem(hostContext, qsrc, qItem, errors, mapItem, stack, inProgress, questionnaireResponseRoot, qstack);
        } else if (enabled && qItem.getRequired()) {
            String message = "No response found for required item with id = '" + qItem.getLinkId() + "'";
            if (inProgress) {
                this.warning(errors, ValidationMessage.IssueType.REQUIRED, element.line(), element.col(), stack.getLiteralPath(), false, message, new Object[0]);
            } else {
                this.rule(errors, ValidationMessage.IssueType.REQUIRED, element.line(), element.col(), stack.getLiteralPath(), false, message, new Object[0]);
            }
        }
    }

    private String misplacedItemError(Questionnaire.QuestionnaireItemComponent qItem) {
        return qItem.hasLinkId() ? String.format("Structural Error: item with linkid %s is in the wrong place", qItem.getLinkId()) : "Structural Error: item is in the wrong place";
    }

    private void validateQuestionnaireResponseItemQuantity(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element answer, NodeStack stack) {
    }

    private String validateQuestionnaireResponseItemType(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack, String ... types) {
        ArrayList values = new ArrayList();
        element.getNamedChildrenWithWildcard("value[x]", values);
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].equals("text")) continue;
            types[i] = "string";
        }
        if (values.size() > 0) {
            NodeStack ns = stack.push((org.hl7.fhir.r5.elementmodel.Element)values.get(0), -1, null, null);
            CommaSeparatedStringBuilder l = new CommaSeparatedStringBuilder();
            for (String s : types) {
                l.append(s);
                if (!((org.hl7.fhir.r5.elementmodel.Element)values.get(0)).getName().equals("value" + Utilities.capitalize((String)s))) continue;
                return s;
            }
            if (types.length == 1) {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, ((org.hl7.fhir.r5.elementmodel.Element)values.get(0)).line(), ((org.hl7.fhir.r5.elementmodel.Element)values.get(0)).col(), ns.getLiteralPath(), false, "Answer value must be of type " + types[0], new Object[0]);
            } else {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, ((org.hl7.fhir.r5.elementmodel.Element)values.get(0)).line(), ((org.hl7.fhir.r5.elementmodel.Element)values.get(0)).col(), ns.getLiteralPath(), false, "Answer value must be one of the types " + l.toString(), new Object[0]);
            }
        }
        return null;
    }

    private Questionnaire.QuestionnaireItemComponent findQuestionnaireItem(Questionnaire qSrc, String linkId) {
        return this.findItem(qSrc.getItem(), linkId);
    }

    private Questionnaire.QuestionnaireItemComponent findItem(List<Questionnaire.QuestionnaireItemComponent> list, String linkId) {
        for (Questionnaire.QuestionnaireItemComponent item : list) {
            if (linkId.equals(item.getLinkId())) {
                return item;
            }
            Questionnaire.QuestionnaireItemComponent result = this.findItem(item.getItem(), linkId);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private void validateAnswerCode(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element value, NodeStack stack, Questionnaire qSrc, String ref, boolean theOpenChoice) {
        ValueSet vs = this.resolveBindingReference((DomainResource)qSrc, ref, qSrc.getUrl());
        if (this.warning(errors, ValidationMessage.IssueType.CODEINVALID, value.line(), value.col(), stack.getLiteralPath(), vs != null, "ValueSet " + this.describeReference(ref) + " not found by validator", new Object[0])) {
            try {
                Coding c = ObjectConverter.readAsCoding((org.hl7.fhir.r5.elementmodel.Element)value);
                if (StringUtils.isBlank((CharSequence)c.getCode()) && StringUtils.isBlank((CharSequence)c.getSystem()) && StringUtils.isNotBlank((CharSequence)c.getDisplay()) && theOpenChoice) {
                    return;
                }
                long t = System.nanoTime();
                IWorkerContext.ValidationResult res = this.context.validateCode(new TerminologyServiceOptions(stack.workingLang), c, vs);
                this.txTime += System.nanoTime() - t;
                if (!res.isOk()) {
                    this.txRule(errors, res.getTxLink(), ValidationMessage.IssueType.CODEINVALID, value.line(), value.col(), stack.getLiteralPath(), false, "The value provided (" + c.getSystem() + "::" + c.getCode() + ") is not in the options value set in the questionnaire", new Object[0]);
                } else if (res.getSeverity() != null) {
                    super.addValidationMessage(errors, ValidationMessage.IssueType.CODEINVALID, value.line(), value.col(), stack.getLiteralPath(), res.getMessage(), res.getSeverity(), ValidationMessage.Source.TerminologyEngine);
                }
            }
            catch (Exception e) {
                this.warning(errors, ValidationMessage.IssueType.CODEINVALID, value.line(), value.col(), stack.getLiteralPath(), false, "Error " + e.getMessage() + " validating Coding against Questionnaire Options", new Object[0]);
            }
        }
    }

    private void validateAnswerCode(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element answer, NodeStack stack, Questionnaire qSrc, Questionnaire.QuestionnaireItemComponent qItem, boolean theOpenChoice) {
        org.hl7.fhir.r5.elementmodel.Element v = answer.getNamedChild("valueCoding");
        NodeStack ns = stack.push(v, -1, null, null);
        if (qItem.getAnswerOption().size() > 0) {
            this.checkCodingOption(errors, answer, stack, qSrc, qItem, theOpenChoice);
        } else if (qItem.hasAnswerValueSet()) {
            this.validateAnswerCode(errors, v, stack, qSrc, qItem.getAnswerValueSet(), theOpenChoice);
        } else {
            this.hint(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Cannot validate options because no option or options are provided");
        }
    }

    private void checkOption(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element answer, NodeStack stack, Questionnaire qSrc, Questionnaire.QuestionnaireItemComponent qItem, String type) {
        this.checkOption(errors, answer, stack, qSrc, qItem, type, false);
    }

    private void checkOption(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element answer, NodeStack stack, Questionnaire qSrc, Questionnaire.QuestionnaireItemComponent qItem, String type, boolean openChoice) {
        if (type.equals("integer")) {
            this.checkIntegerOption(errors, answer, stack, qSrc, qItem, openChoice);
        } else if (type.equals("date")) {
            this.checkDateOption(errors, answer, stack, qSrc, qItem, openChoice);
        } else if (type.equals("time")) {
            this.checkTimeOption(errors, answer, stack, qSrc, qItem, openChoice);
        } else if (type.equals("string")) {
            this.checkStringOption(errors, answer, stack, qSrc, qItem, openChoice);
        } else if (type.equals("Coding")) {
            this.checkCodingOption(errors, answer, stack, qSrc, qItem, openChoice);
        }
    }

    private void checkIntegerOption(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element answer, NodeStack stack, Questionnaire qSrc, Questionnaire.QuestionnaireItemComponent qItem, boolean openChoice) {
        org.hl7.fhir.r5.elementmodel.Element v = answer.getNamedChild("valueInteger");
        NodeStack ns = stack.push(v, -1, null, null);
        if (qItem.getAnswerOption().size() > 0) {
            ArrayList<IntegerType> list = new ArrayList<IntegerType>();
            for (Questionnaire.QuestionnaireItemAnswerOptionComponent components : qItem.getAnswerOption()) {
                try {
                    list.add(components.getValueIntegerType());
                }
                catch (FHIRException fHIRException) {}
            }
            if (list.isEmpty() && !openChoice) {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Option list has no option values of type integer", new Object[0]);
            } else {
                boolean found = false;
                for (IntegerType item : list) {
                    if ((Integer)item.getValue() != Integer.parseInt(v.primitiveValue())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.rule(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), found, "The integer " + v.primitiveValue() + " is not a valid option", new Object[0]);
                }
            }
        } else {
            this.hint(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Cannot validate integer answer option because no option list is provided");
        }
    }

    private void checkDateOption(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element answer, NodeStack stack, Questionnaire qSrc, Questionnaire.QuestionnaireItemComponent qItem, boolean openChoice) {
        org.hl7.fhir.r5.elementmodel.Element v = answer.getNamedChild("valueDate");
        NodeStack ns = stack.push(v, -1, null, null);
        if (qItem.getAnswerOption().size() > 0) {
            ArrayList<DateType> list = new ArrayList<DateType>();
            for (Questionnaire.QuestionnaireItemAnswerOptionComponent components : qItem.getAnswerOption()) {
                try {
                    list.add(components.getValueDateType());
                }
                catch (FHIRException fHIRException) {}
            }
            if (list.isEmpty() && !openChoice) {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Option list has no option values of type date", new Object[0]);
            } else {
                boolean found = false;
                for (DateType item : list) {
                    if (!((Date)item.getValue()).equals(v.primitiveValue())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.rule(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), found, "The date " + v.primitiveValue() + " is not a valid option", new Object[0]);
                }
            }
        } else {
            this.hint(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Cannot validate date answer option because no option list is provided");
        }
    }

    private void checkTimeOption(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element answer, NodeStack stack, Questionnaire qSrc, Questionnaire.QuestionnaireItemComponent qItem, boolean openChoice) {
        org.hl7.fhir.r5.elementmodel.Element v = answer.getNamedChild("valueTime");
        NodeStack ns = stack.push(v, -1, null, null);
        if (qItem.getAnswerOption().size() > 0) {
            ArrayList<TimeType> list = new ArrayList<TimeType>();
            for (Questionnaire.QuestionnaireItemAnswerOptionComponent components : qItem.getAnswerOption()) {
                try {
                    list.add(components.getValueTimeType());
                }
                catch (FHIRException fHIRException) {}
            }
            if (list.isEmpty() && !openChoice) {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Option list has no option values of type time", new Object[0]);
            } else {
                boolean found = false;
                for (TimeType item : list) {
                    if (!((String)item.getValue()).equals(v.primitiveValue())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.rule(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), found, "The time " + v.primitiveValue() + " is not a valid option", new Object[0]);
                }
            }
        } else {
            this.hint(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Cannot validate time answer option because no option list is provided");
        }
    }

    private void checkStringOption(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element answer, NodeStack stack, Questionnaire qSrc, Questionnaire.QuestionnaireItemComponent qItem, boolean openChoice) {
        org.hl7.fhir.r5.elementmodel.Element v = answer.getNamedChild("valueString");
        NodeStack ns = stack.push(v, -1, null, null);
        if (qItem.getAnswerOption().size() > 0) {
            ArrayList<StringType> list = new ArrayList<StringType>();
            for (Questionnaire.QuestionnaireItemAnswerOptionComponent components : qItem.getAnswerOption()) {
                try {
                    if (components.getValue() == null) continue;
                    list.add(components.getValueStringType());
                }
                catch (FHIRException fHIRException) {}
            }
            if (!openChoice) {
                if (list.isEmpty()) {
                    this.rule(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Option list has no option values of type string", new Object[0]);
                } else {
                    boolean found = false;
                    for (StringType item : list) {
                        if (!((String)item.getValue()).equals(v.primitiveValue())) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        this.rule(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), found, "The string " + v.primitiveValue() + " is not a valid option", new Object[0]);
                    }
                }
            }
        } else {
            this.hint(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Cannot validate string answer option because no option list is provided");
        }
    }

    private void checkCodingOption(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element answer, NodeStack stack, Questionnaire qSrc, Questionnaire.QuestionnaireItemComponent qItem, boolean openChoice) {
        org.hl7.fhir.r5.elementmodel.Element v = answer.getNamedChild("valueCoding");
        String system = v.getNamedChildValue("system");
        String code = v.getNamedChildValue("code");
        NodeStack ns = stack.push(v, -1, null, null);
        if (qItem.getAnswerOption().size() > 0) {
            ArrayList<Coding> list = new ArrayList<Coding>();
            for (Questionnaire.QuestionnaireItemAnswerOptionComponent components : qItem.getAnswerOption()) {
                try {
                    if (components.getValue() == null) continue;
                    list.add(components.getValueCoding());
                }
                catch (FHIRException fHIRException) {}
            }
            if (list.isEmpty() && !openChoice) {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Option list has no option values of type coding", new Object[0]);
            } else {
                boolean found = false;
                for (Coding item : list) {
                    if (!ObjectUtil.equals((Object)item.getSystem(), (Object)system) || !ObjectUtil.equals((Object)item.getCode(), (Object)code)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.rule(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), found, "The code " + system + "::" + code + " is not a valid option", new Object[0]);
                }
            }
        } else {
            this.hint(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Cannot validate Coding option because no option list is provided");
        }
    }

    private String tail(String path) {
        return path.substring(path.lastIndexOf(".") + 1);
    }

    private String tryParse(String ref) {
        String[] parts = ref.split("\\/");
        switch (parts.length) {
            case 1: {
                return null;
            }
            case 2: {
                return this.checkResourceType(parts[0]);
            }
        }
        if (parts[parts.length - 2].equals("_history")) {
            return this.checkResourceType(parts[parts.length - 4]);
        }
        return this.checkResourceType(parts[parts.length - 2]);
    }

    private boolean typesAreAllReference(List<ElementDefinition.TypeRefComponent> theType) {
        for (ElementDefinition.TypeRefComponent typeRefComponent : theType) {
            if (typeRefComponent.getCode().equals("Reference")) continue;
            return false;
        }
        return true;
    }

    private void validateBundle(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element bundle, NodeStack stack) {
        String id;
        String fullUrl;
        ArrayList<org.hl7.fhir.r5.elementmodel.Element> entries = new ArrayList<org.hl7.fhir.r5.elementmodel.Element>();
        bundle.getNamedChildren("entry", entries);
        String type = bundle.getNamedChildValue("type");
        type = StringUtils.defaultString((String)type);
        if (entries.size() == 0) {
            this.rule(errors, ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), !type.equals("document") && !type.equals("message"), "Documents or Messages must contain at least one entry");
        } else {
            org.hl7.fhir.r5.elementmodel.Element resource;
            org.hl7.fhir.r5.elementmodel.Element firstEntry = (org.hl7.fhir.r5.elementmodel.Element)entries.get(0);
            NodeStack firstStack = stack.push(firstEntry, 1, null, null);
            fullUrl = firstEntry.getNamedChildValue("fullUrl");
            if (type.equals("document")) {
                resource = firstEntry.getNamedChild("resource");
                id = resource.getNamedChildValue("id");
                if (this.rule(errors, ValidationMessage.IssueType.INVALID, firstEntry.line(), firstEntry.col(), stack.addToLiteralPath("entry", ":0"), resource != null, "No resource on first entry", new Object[0])) {
                    this.validateDocument(errors, entries, resource, firstStack.push(resource, -1, null, null), fullUrl, id);
                }
                this.checkAllInterlinked(errors, entries, stack, bundle);
            }
            if (type.equals("message")) {
                resource = firstEntry.getNamedChild("resource");
                id = resource.getNamedChildValue("id");
                if (this.rule(errors, ValidationMessage.IssueType.INVALID, firstEntry.line(), firstEntry.col(), stack.addToLiteralPath("entry", ":0"), resource != null, "No resource on first entry", new Object[0])) {
                    this.validateMessage(errors, entries, resource, firstStack.push(resource, -1, null, null), fullUrl, id);
                }
                this.checkAllInterlinked(errors, entries, stack, bundle);
            }
        }
        for (org.hl7.fhir.r5.elementmodel.Element entry : entries) {
            fullUrl = entry.getNamedChildValue("fullUrl");
            String url = this.getCanonicalURLForEntry(entry);
            id = this.getIdForEntry(entry);
            if (url == null) continue;
            if (!(!url.equals(fullUrl) || url.matches(this.uriRegexForVersion()) && url.endsWith("/" + id) || this.isV3orV2Url(url))) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, entry.line(), entry.col(), stack.addToLiteralPath("entry", ":0"), false, "The canonical URL (" + url + ") cannot match the fullUrl (" + fullUrl + ") unless the resource id (" + id + ") also matches", new Object[0]);
            }
            this.rule(errors, ValidationMessage.IssueType.INVALID, entry.line(), entry.col(), stack.addToLiteralPath("entry", ":0"), !url.equals(fullUrl) || this.serverBase == null || url.equals(Utilities.pathURL((String[])new String[]{this.serverBase, entry.getNamedChild("resource").fhirType(), id})), "The canonical URL (" + url + ") cannot match the fullUrl (" + fullUrl + ") unless on the canonical server itself", new Object[0]);
        }
    }

    private boolean isV3orV2Url(String url) {
        return url.startsWith("http://hl7.org/fhir/v3/") || url.startsWith("http://hl7.org/fhir/v2/");
    }

    private String uriRegexForVersion() {
        if (VersionUtilities.isR3Ver((String)this.context.getVersion())) {
            return URI_REGEX3;
        }
        return "((http|https)://([A-Za-z0-9\\\\\\.\\:\\%\\$]*\\/)*)?(Account|ActivityDefinition|AdministrableProductDefinition|AdverseEvent|AllergyIntolerance|Appointment|AppointmentResponse|AuditEvent|Basic|Binary|BiologicallyDerivedProduct|BodyStructure|Bundle|CapabilityStatement|CapabilityStatement2|CarePlan|CareTeam|CatalogEntry|ChargeItem|ChargeItemDefinition|Claim|ClaimResponse|ClinicalImpression|ClinicalUseIssue|CodeSystem|Communication|CommunicationRequest|CompartmentDefinition|Composition|ConceptMap|Condition|ConditionDefinition|Consent|Contract|Coverage|CoverageEligibilityRequest|CoverageEligibilityResponse|DetectedIssue|Device|DeviceDefinition|DeviceMetric|DeviceRequest|DeviceUseStatement|DiagnosticReport|DocumentManifest|DocumentReference|Encounter|Endpoint|EnrollmentRequest|EnrollmentResponse|EpisodeOfCare|EventDefinition|Evidence|EvidenceVariable|ExampleScenario|ExplanationOfBenefit|FamilyMemberHistory|Flag|Goal|GraphDefinition|Group|GuidanceResponse|HealthcareService|ImagingStudy|Immunization|ImmunizationEvaluation|ImmunizationRecommendation|ImplementationGuide|Ingredient|InsurancePlan|Invoice|Library|Linkage|List|Location|ManufacturedItemDefinition|Measure|MeasureReport|Medication|MedicationAdministration|MedicationDispense|MedicationKnowledge|MedicationRequest|MedicationUsage|MedicinalProductDefinition|MessageDefinition|MessageHeader|MolecularSequence|NamingSystem|NutritionIntake|NutritionOrder|Observation|ObservationDefinition|OperationDefinition|OperationOutcome|Organization|OrganizationAffiliation|PackagedProductDefinition|Patient|PaymentNotice|PaymentReconciliation|Person|PlanDefinition|Practitioner|PractitionerRole|Procedure|Provenance|Questionnaire|QuestionnaireResponse|RegulatedAuthorization|RelatedPerson|RequestGroup|ResearchStudy|ResearchSubject|RiskAssessment|Schedule|SearchParameter|ServiceRequest|Slot|Specimen|SpecimenDefinition|StructureDefinition|StructureMap|Subscription|Substance|SubstanceDefinition|SubstanceNucleicAcid|SubstancePolymer|SubstanceProtein|SubstanceReferenceInformation|SubstanceSourceMaterial|SupplyDelivery|SupplyRequest|Task|TerminologyCapabilities|TestReport|TestScript|Topic|ValueSet|VerificationResult|VisionPrescription)\\/[A-Za-z0-9\\-\\.]{1,64}(\\/_history\\/[A-Za-z0-9\\-\\.]{1,64})?";
    }

    private String getCanonicalURLForEntry(org.hl7.fhir.r5.elementmodel.Element entry) {
        org.hl7.fhir.r5.elementmodel.Element e = entry.getNamedChild("resource");
        if (e == null) {
            return null;
        }
        return e.getNamedChildValue("url");
    }

    private String getIdForEntry(org.hl7.fhir.r5.elementmodel.Element entry) {
        org.hl7.fhir.r5.elementmodel.Element e = entry.getNamedChild("resource");
        if (e == null) {
            return null;
        }
        return e.getNamedChildValue("id");
    }

    private void validateResourceIds(List<ValidationMessage> errors, List<org.hl7.fhir.r5.elementmodel.Element> entries, NodeStack stack) {
        int i = 1;
        for (org.hl7.fhir.r5.elementmodel.Element entry : entries) {
            String id;
            String fullUrl = entry.getNamedChildValue("fullUrl");
            org.hl7.fhir.r5.elementmodel.Element resource = entry.getNamedChild("resource");
            String string = id = resource != null ? resource.getNamedChildValue("id") : null;
            if (id != null && fullUrl != null) {
                String urlId = null;
                if (fullUrl.startsWith("https://") || fullUrl.startsWith("http://")) {
                    urlId = fullUrl.substring(fullUrl.lastIndexOf(47) + 1);
                } else if (fullUrl.startsWith("urn:uuid") || fullUrl.startsWith("urn:oid")) {
                    urlId = fullUrl.substring(fullUrl.lastIndexOf(58) + 1);
                }
                this.rule(errors, ValidationMessage.IssueType.INVALID, entry.line(), entry.col(), stack.addToLiteralPath("entry[" + i + "]"), urlId.equals(id), "Resource ID does not match the ID in the entry full URL ('" + id + "' vs '" + fullUrl + "') ", new Object[0]);
            }
            ++i;
        }
    }

    private void checkAllInterlinked(List<ValidationMessage> errors, List<org.hl7.fhir.r5.elementmodel.Element> entries, NodeStack stack, org.hl7.fhir.r5.elementmodel.Element bundle) {
        boolean reverseLinksFound;
        HashMap<String, org.hl7.fhir.r5.elementmodel.Element> visitedResources = new HashMap<String, org.hl7.fhir.r5.elementmodel.Element>();
        HashMap<org.hl7.fhir.r5.elementmodel.Element, org.hl7.fhir.r5.elementmodel.Element> candidateEntries = new HashMap<org.hl7.fhir.r5.elementmodel.Element, org.hl7.fhir.r5.elementmodel.Element>();
        ArrayList<org.hl7.fhir.r5.elementmodel.Element> candidateResources = new ArrayList<org.hl7.fhir.r5.elementmodel.Element>();
        for (org.hl7.fhir.r5.elementmodel.Element entry : entries) {
            candidateEntries.put(entry.getNamedChild("resource"), entry);
            candidateResources.add(entry.getNamedChild("resource"));
        }
        ArrayList<String> sheets = new ArrayList<String>();
        List links = bundle.getChildren("link");
        for (org.hl7.fhir.r5.elementmodel.Element link : links) {
            if (!link.getChildValue("relation").equals("stylesheet")) continue;
            sheets.add(link.getChildValue("url"));
        }
        if (!sheets.isEmpty()) {
            for (org.hl7.fhir.r5.elementmodel.Element r : candidateResources) {
                String url = r.getChildValue("fullUrl");
                if (!sheets.contains(url)) continue;
                visitedResources.put(url, r);
            }
        }
        ArrayList<org.hl7.fhir.r5.elementmodel.Element> unusedResources = new ArrayList<org.hl7.fhir.r5.elementmodel.Element>();
        do {
            reverseLinksFound = false;
            this.followResourceLinks(entries.get(0), visitedResources, candidateEntries, candidateResources, errors, stack);
            unusedResources.clear();
            unusedResources.addAll(candidateResources);
            unusedResources.removeAll(visitedResources.values());
            for (org.hl7.fhir.r5.elementmodel.Element unusedResource : unusedResources) {
                List<String> references = this.findReferences(unusedResource);
                for (String reference : references) {
                    if (visitedResources.containsKey(reference)) continue;
                    visitedResources.put(reference, unusedResource);
                    reverseLinksFound = true;
                }
            }
        } while (reverseLinksFound);
        int i = 0;
        for (org.hl7.fhir.r5.elementmodel.Element entry : entries) {
            this.rule(errors, ValidationMessage.IssueType.INFORMATIONAL, entry.line(), entry.col(), stack.addToLiteralPath("entry[" + (i + 1) + ']'), !unusedResources.contains(entry.getNamedChild("resource")), "Entry isn't reachable by traversing from first Bundle entry", new Object[0]);
            ++i;
        }
    }

    private void followResourceLinks(org.hl7.fhir.r5.elementmodel.Element entry, Map<String, org.hl7.fhir.r5.elementmodel.Element> visitedResources, Map<org.hl7.fhir.r5.elementmodel.Element, org.hl7.fhir.r5.elementmodel.Element> candidateEntries, List<org.hl7.fhir.r5.elementmodel.Element> candidateResources, List<ValidationMessage> errors, NodeStack stack) {
        this.followResourceLinks(entry, visitedResources, candidateEntries, candidateResources, errors, stack, 0);
    }

    private void followResourceLinks(org.hl7.fhir.r5.elementmodel.Element entry, Map<String, org.hl7.fhir.r5.elementmodel.Element> visitedResources, Map<org.hl7.fhir.r5.elementmodel.Element, org.hl7.fhir.r5.elementmodel.Element> candidateEntries, List<org.hl7.fhir.r5.elementmodel.Element> candidateResources, List<ValidationMessage> errors, NodeStack stack, int depth) {
        org.hl7.fhir.r5.elementmodel.Element resource = entry.getNamedChild("resource");
        if (visitedResources.containsValue(resource)) {
            return;
        }
        visitedResources.put(entry.getNamedChildValue("fullUrl"), resource);
        String type = null;
        List<String> references = this.findReferences(resource);
        for (String reference : references) {
            org.hl7.fhir.r5.elementmodel.Element r = this.getFromBundle(stack.getElement(), reference, entry.getChildValue("fullUrl"), new ArrayList<ValidationMessage>(), stack.addToLiteralPath("entry[" + candidateResources.indexOf(resource) + "]"), type);
            if (r == null || visitedResources.containsValue(r)) continue;
            this.followResourceLinks(candidateEntries.get(r), visitedResources, candidateEntries, candidateResources, errors, stack, depth + 1);
        }
    }

    private List<String> findReferences(org.hl7.fhir.r5.elementmodel.Element start) {
        ArrayList<String> references = new ArrayList<String>();
        this.findReferences(start, references);
        return references;
    }

    private void findReferences(org.hl7.fhir.r5.elementmodel.Element start, List<String> references) {
        for (org.hl7.fhir.r5.elementmodel.Element child : start.getChildren()) {
            String ref;
            if (child.getType().equals("Reference") && (ref = child.getChildValue("reference")) != null && !ref.startsWith("#")) {
                references.add(ref);
            }
            this.findReferences(child, references);
        }
    }

    private void validateBundleReference(List<ValidationMessage> errors, List<org.hl7.fhir.r5.elementmodel.Element> entries, org.hl7.fhir.r5.elementmodel.Element ref, String name, NodeStack stack, String fullUrl, String type, String id) {
        String reference = null;
        try {
            reference = ref.getNamedChildValue("reference");
        }
        catch (Error error) {
            // empty catch block
        }
        if (ref != null && !Utilities.noString((String)reference)) {
            org.hl7.fhir.r5.elementmodel.Element target = this.resolveInBundle(entries, reference, fullUrl, type, id);
            this.rule(errors, ValidationMessage.IssueType.INVALID, ref.line(), ref.col(), stack.addToLiteralPath("reference"), target != null, "Can't find '" + reference + "' in the bundle (" + name + ")", new Object[0]);
        }
    }

    private void validateContains(ValidatorHostContext hostContext, List<ValidationMessage> errors, String path, ElementDefinition child, ElementDefinition context, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack, IResourceValidator.IdStatus idstatus) throws FHIRException, FHIRException, IOException {
        String resourceName = element.getType();
        long t = System.nanoTime();
        StructureDefinition profile = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + resourceName);
        this.sdTime += System.nanoTime() - t;
        if (element.getSpecial() == Element.SpecialElement.BUNDLE_ENTRY || element.getSpecial() == Element.SpecialElement.BUNDLE_OUTCOME || element.getSpecial() == Element.SpecialElement.PARAMETER) {
            resource = element;
        }
        if (this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), profile != null, "No profile found for contained resource of type '" + resourceName + "'", new Object[0])) {
            this.validateResource(hostContext.forContained(element), errors, resource, element, profile, null, idstatus, stack, false);
        }
    }

    private void validateDocument(List<ValidationMessage> errors, List<org.hl7.fhir.r5.elementmodel.Element> entries, org.hl7.fhir.r5.elementmodel.Element composition, NodeStack stack, String fullUrl, String id) {
        if (this.rule(errors, ValidationMessage.IssueType.INVALID, composition.line(), composition.col(), stack.getLiteralPath(), composition.getType().equals("Composition"), "The first entry in a document must be a composition", new Object[0])) {
            this.validateDocumentReference(errors, entries, composition, stack, fullUrl, id, false, "subject", "Composition");
            this.validateDocumentReference(errors, entries, composition, stack, fullUrl, id, true, "author", "Composition");
            this.validateDocumentReference(errors, entries, composition, stack, fullUrl, id, false, "encounter", "Composition");
            this.validateDocumentReference(errors, entries, composition, stack, fullUrl, id, false, "custodian", "Composition");
            this.validateDocumentSubReference(errors, entries, composition, stack, fullUrl, id, "Composition", "attester", false, "party");
            this.validateDocumentSubReference(errors, entries, composition, stack, fullUrl, id, "Composition", "event", true, "detail");
            this.validateSections(errors, entries, composition, stack, fullUrl, id);
        }
    }

    public void validateDocumentSubReference(List<ValidationMessage> errors, List<org.hl7.fhir.r5.elementmodel.Element> entries, org.hl7.fhir.r5.elementmodel.Element composition, NodeStack stack, String fullUrl, String id, String title, String parent, boolean repeats, String propName) {
        ArrayList list = new ArrayList();
        composition.getNamedChildren(parent, list);
        int i = 1;
        for (org.hl7.fhir.r5.elementmodel.Element elem : list) {
            this.validateDocumentReference(errors, entries, elem, stack.push(elem, i, null, null), fullUrl, id, repeats, propName, title + "." + parent);
            ++i;
        }
    }

    public void validateDocumentReference(List<ValidationMessage> errors, List<org.hl7.fhir.r5.elementmodel.Element> entries, org.hl7.fhir.r5.elementmodel.Element composition, NodeStack stack, String fullUrl, String id, boolean repeats, String propName, String title) {
        if (repeats) {
            ArrayList list = new ArrayList();
            composition.getNamedChildren(propName, list);
            int i = 1;
            for (org.hl7.fhir.r5.elementmodel.Element elem : list) {
                this.validateBundleReference(errors, entries, elem, title + "." + propName, stack.push(elem, i, null, null), fullUrl, "Composition", id);
                ++i;
            }
        } else {
            org.hl7.fhir.r5.elementmodel.Element elem = composition.getNamedChild(propName);
            if (elem != null) {
                this.validateBundleReference(errors, entries, elem, title + "." + propName, stack.push(elem, -1, null, null), fullUrl, "Composition", id);
            }
        }
    }

    private void validateElement(ValidatorHostContext hostContext, List<ValidationMessage> errors, StructureDefinition profile, ElementDefinition definition, StructureDefinition cprofile, ElementDefinition context, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element element, String actualType, NodeStack stack, boolean inCodeableConcept, boolean checkDisplayInContext) throws FHIRException, FHIRException, IOException {
        this.checkInvariants(hostContext, errors, profile, definition, resource, element, stack);
        List childDefinitions = ProfileUtilities.getChildMap((StructureDefinition)profile, (ElementDefinition)definition);
        if (childDefinitions.isEmpty()) {
            if (actualType == null) {
                return;
            }
            StructureDefinition dt = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + actualType);
            if (dt == null) {
                throw new DefinitionException("Unable to resolve actual type " + actualType);
            }
            childDefinitions = ProfileUtilities.getChildMap((StructureDefinition)dt, (ElementDefinition)((ElementDefinition)dt.getSnapshot().getElement().get(0)));
        }
        List<ElementInfo> children = this.listChildren(element, stack);
        List<String> problematicPaths = this.assignChildren(hostContext, errors, profile, resource, stack, childDefinitions, children);
        this.checkCardinalities(errors, profile, element, stack, childDefinitions, children, problematicPaths);
        for (ElementInfo ei : children) {
            this.checkChild(hostContext, errors, profile, definition, resource, element, actualType, stack, inCodeableConcept, checkDisplayInContext, ei);
        }
    }

    public void checkChild(ValidatorHostContext hostContext, List<ValidationMessage> errors, StructureDefinition profile, ElementDefinition definition, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element element, String actualType, NodeStack stack, boolean inCodeableConcept, boolean checkDisplayInContext, ElementInfo ei) throws FHIRException, IOException, DefinitionException {
        ArrayList<String> profiles = new ArrayList<String>();
        if (ei.definition != null) {
            String prefix;
            String elementSupported;
            String type = null;
            ElementDefinition typeDefn = null;
            String usesMustSupport = profile.getUserString("usesMustSupport");
            if (usesMustSupport == null) {
                usesMustSupport = "N";
                for (Object pe : profile.getSnapshot().getElement()) {
                    if (!pe.getMustSupport()) continue;
                    usesMustSupport = "Y";
                    break;
                }
                profile.setUserData("usesMustSupport", (Object)usesMustSupport);
            }
            if (usesMustSupport.equals("Y") && ((elementSupported = ei.element.getUserString("elementSupported")) == null || ei.definition.getMustSupport())) {
                if (ei.definition.getMustSupport()) {
                    ei.element.setUserData("elementSupported", (Object)"Y");
                } else {
                    ei.element.setUserData("elementSupported", (Object)"N");
                }
            }
            if (!(ei.definition.getType().size() != 1 || "*".equals(((ElementDefinition.TypeRefComponent)ei.definition.getType().get(0)).getWorkingCode()) || "Element".equals(((ElementDefinition.TypeRefComponent)ei.definition.getType().get(0)).getWorkingCode()) || "BackboneElement".equals(((ElementDefinition.TypeRefComponent)ei.definition.getType().get(0)).getWorkingCode()))) {
                type = ((ElementDefinition.TypeRefComponent)ei.definition.getType().get(0)).getWorkingCode();
                if (((ElementDefinition.TypeRefComponent)ei.definition.getType().get(0)).hasProfile()) {
                    profiles.add((String)((CanonicalType)((ElementDefinition.TypeRefComponent)ei.definition.getType().get(0)).getProfile().get(0)).getValue());
                }
            } else if (ei.definition.getType().size() == 1 && "*".equals(((ElementDefinition.TypeRefComponent)ei.definition.getType().get(0)).getWorkingCode())) {
                prefix = this.tail(ei.definition.getPath());
                assert (prefix.endsWith("[x]"));
                type = ei.name.substring(prefix.length() - 3);
                if (this.isPrimitiveType(type)) {
                    type = Utilities.uncapitalize((String)type);
                }
                if (((ElementDefinition.TypeRefComponent)ei.definition.getType().get(0)).hasProfile() && !type.equals("Reference")) {
                    profiles.add((String)((CanonicalType)((ElementDefinition.TypeRefComponent)ei.definition.getType().get(0)).getProfile().get(0)).getValue());
                }
            } else if (ei.definition.getType().size() > 1) {
                prefix = this.tail(ei.definition.getPath());
                assert (this.typesAreAllReference(ei.definition.getType()) || ei.definition.hasRepresentation(ElementDefinition.PropertyRepresentation.TYPEATTR) || prefix.endsWith("[x]")) : prefix;
                if (ei.definition.hasRepresentation(ElementDefinition.PropertyRepresentation.TYPEATTR)) {
                    type = ei.element.getType();
                } else {
                    prefix = prefix.substring(0, prefix.length() - 3);
                    for (ElementDefinition.TypeRefComponent t : ei.definition.getType()) {
                        if (!(prefix + Utilities.capitalize((String)t.getWorkingCode())).equals(ei.name)) continue;
                        type = t.getWorkingCode();
                        if (!t.hasProfile() || type.equals("Reference")) continue;
                        profiles.add((String)((CanonicalType)t.getProfile().get(0)).getValue());
                    }
                }
                if (type == null) {
                    ElementDefinition.TypeRefComponent trc = (ElementDefinition.TypeRefComponent)ei.definition.getType().get(0);
                    if (trc.getWorkingCode().equals("Reference")) {
                        type = "Reference";
                    } else {
                        this.rule(errors, ValidationMessage.IssueType.STRUCTURE, ei.line(), ei.col(), stack.getLiteralPath(), false, "The type of element " + ei.name + " is not known, which is illegal. Valid types at this point are " + this.describeTypes(ei.definition.getType()), new Object[0]);
                    }
                }
            } else if (ei.definition.getContentReference() != null) {
                typeDefn = this.resolveNameReference(profile.getSnapshot(), ei.definition.getContentReference());
            } else if (ei.definition.getType().size() == 1 && ("Element".equals(((ElementDefinition.TypeRefComponent)ei.definition.getType().get(0)).getWorkingCode()) || "BackboneElement".equals(((ElementDefinition.TypeRefComponent)ei.definition.getType().get(0)).getWorkingCode())) && ((ElementDefinition.TypeRefComponent)ei.definition.getType().get(0)).hasProfile()) {
                CanonicalType pu = (CanonicalType)((ElementDefinition.TypeRefComponent)ei.definition.getType().get(0)).getProfile().get(0);
                if (pu.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-profile-element")) {
                    profiles.add((String)pu.getValue() + "#" + pu.getExtensionString("http://hl7.org/fhir/StructureDefinition/elementdefinition-profile-element"));
                } else {
                    profiles.add((String)pu.getValue());
                }
            }
            if (type != null && type.startsWith("@")) {
                ei.definition = this.findElement(profile, type.substring(1));
                type = null;
            }
            NodeStack localStack = stack.push(ei.element, ei.count, ei.definition, type == null ? typeDefn : this.resolveType(type, ei.definition.getType()));
            String localStackLiterapPath = localStack.getLiteralPath();
            String eiPath = ei.path;
            assert (eiPath.equals(localStackLiterapPath)) : "ei.path: " + ElementInfo.access$1800(ei) + "  -  localStack.getLiteralPath: " + localStackLiterapPath;
            boolean thisIsCodeableConcept = false;
            boolean checkDisplay = true;
            ei.element.markValidation(profile, ei.definition);
            if (type != null) {
                if (this.isPrimitiveType(type)) {
                    this.checkPrimitive(hostContext, errors, ei.path, type, ei.definition, ei.element, profile, stack);
                } else {
                    if (ei.definition.hasFixed()) {
                        this.checkFixedValue(errors, ei.path, ei.element, (org.hl7.fhir.r5.model.Element)ei.definition.getFixed(), ei.definition.getSliceName(), null);
                    }
                    if (ei.definition.hasPattern()) {
                        this.checkFixedValue(errors, ei.path, ei.element, (org.hl7.fhir.r5.model.Element)ei.definition.getPattern(), ei.definition.getSliceName(), null, true);
                    }
                }
                if (type.equals("Identifier")) {
                    this.checkIdentifier(errors, ei.path, ei.element, ei.definition);
                } else if (type.equals("Coding")) {
                    this.checkCoding(errors, ei.path, ei.element, profile, ei.definition, inCodeableConcept, checkDisplayInContext, stack);
                } else if (type.equals("CodeableConcept")) {
                    checkDisplay = this.checkCodeableConcept(errors, ei.path, ei.element, profile, ei.definition, stack);
                    thisIsCodeableConcept = true;
                } else if (type.equals("Reference")) {
                    this.checkReference(hostContext, errors, ei.path, ei.element, profile, ei.definition, actualType, localStack);
                } else if (type.equals("Extension") && ei.element.getChildValue("url") != null && ei.element.getChildValue("url").contains("/")) {
                    this.checkExtension(hostContext, errors, ei.path, resource, ei.element, ei.definition, profile, localStack);
                } else if (type.equals("Resource")) {
                    this.validateContains(hostContext, errors, ei.path, ei.definition, definition, resource, ei.element, localStack, this.idStatusForEntry(element, ei));
                }
            } else if (this.rule(errors, ValidationMessage.IssueType.STRUCTURE, ei.line(), ei.col(), stack.getLiteralPath(), ei.definition != null, "Unrecognised Content " + ei.name, new Object[0])) {
                this.validateElement(hostContext, errors, profile, ei.definition, null, null, resource, ei.element, type, localStack, false, true);
            }
            StructureDefinition p = null;
            boolean elementValidated = false;
            String tail = null;
            if (profiles.isEmpty()) {
                if (type != null) {
                    p = this.getProfileForType(type, ei.definition.getType());
                    this.rule(errors, ValidationMessage.IssueType.STRUCTURE, ei.line(), ei.col(), ei.path, p != null, "Unknown type " + type, new Object[0]);
                }
            } else if (profiles.size() == 1) {
                String url = (String)profiles.get(0);
                if (url.contains("#")) {
                    tail = url.substring(url.indexOf("#") + 1);
                    url = url.substring(0, url.indexOf("#"));
                }
                p = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, url);
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, ei.line(), ei.col(), ei.path, p != null, "Unknown profile " + (String)profiles.get(0), new Object[0]);
            } else {
                elementValidated = true;
                HashMap<String, ArrayList<ValidationMessage>> goodProfiles = new HashMap<String, ArrayList<ValidationMessage>>();
                ArrayList<ArrayList<ValidationMessage>> badProfiles = new ArrayList<ArrayList<ValidationMessage>>();
                Iterator iterator = profiles.iterator();
                while (iterator.hasNext()) {
                    String typeProfile;
                    String url = typeProfile = (String)iterator.next();
                    tail = null;
                    if (url.contains("#")) {
                        tail = url.substring(url.indexOf("#") + 1);
                        url = url.substring(0, url.indexOf("#"));
                    }
                    p = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, typeProfile);
                    if (this.rule(errors, ValidationMessage.IssueType.STRUCTURE, ei.line(), ei.col(), ei.path, p != null, "Unknown profile " + typeProfile, new Object[0])) {
                        ArrayList<ValidationMessage> profileErrors = new ArrayList<ValidationMessage>();
                        this.validateElement(hostContext, profileErrors, p, this.getElementByTail(p, tail), profile, ei.definition, resource, ei.element, type, localStack, thisIsCodeableConcept, checkDisplay);
                        if (this.hasErrors(profileErrors)) {
                            badProfiles.add(profileErrors);
                        } else {
                            goodProfiles.put(typeProfile, profileErrors);
                        }
                    }
                    if (goodProfiles.size() == 1) {
                        errors.addAll((Collection)goodProfiles.values().iterator().next());
                        continue;
                    }
                    if (goodProfiles.size() == 0) {
                        this.rule(errors, ValidationMessage.IssueType.STRUCTURE, ei.line(), ei.col(), ei.path, false, "Unable to find matching profile among choices: " + StringUtils.join((Object[])new Object[]{"; ", profiles}), new Object[0]);
                        for (List list : badProfiles) {
                            errors.addAll(list);
                        }
                        continue;
                    }
                    this.warning(errors, ValidationMessage.IssueType.STRUCTURE, ei.line(), ei.col(), ei.path, false, "Found multiple matching profiles among choices: " + StringUtils.join((Object[])new Object[]{"; ", goodProfiles.keySet()}), new Object[0]);
                    for (List list : goodProfiles.values()) {
                        errors.addAll(list);
                    }
                }
            }
            if (p != null) {
                String nextPath;
                int index;
                if (!elementValidated) {
                    if (ei.element.getSpecial() == Element.SpecialElement.BUNDLE_ENTRY || ei.element.getSpecial() == Element.SpecialElement.BUNDLE_OUTCOME || ei.element.getSpecial() == Element.SpecialElement.PARAMETER) {
                        this.validateElement(hostContext, errors, p, this.getElementByTail(p, tail), profile, ei.definition, ei.element, ei.element, type, localStack, thisIsCodeableConcept, checkDisplay);
                    } else {
                        this.validateElement(hostContext, errors, p, this.getElementByTail(p, tail), profile, ei.definition, resource, ei.element, type, localStack, thisIsCodeableConcept, checkDisplay);
                    }
                }
                if ((index = profile.getSnapshot().getElement().indexOf(ei.definition)) < profile.getSnapshot().getElement().size() - 1 && !(nextPath = ((ElementDefinition)profile.getSnapshot().getElement().get(index + 1)).getPath()).equals(ei.definition.getPath()) && nextPath.startsWith(ei.definition.getPath())) {
                    this.validateElement(hostContext, errors, profile, ei.definition, null, null, resource, ei.element, type, localStack, thisIsCodeableConcept, checkDisplay);
                }
            }
        }
    }

    public void checkCardinalities(List<ValidationMessage> errors, StructureDefinition profile, org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack, List<ElementDefinition> childDefinitions, List<ElementInfo> children, List<String> problematicPaths) throws DefinitionException {
        for (ElementDefinition ed : childDefinitions) {
            if (!ed.getRepresentation().isEmpty()) continue;
            int count = 0;
            List slices = null;
            if (ed.hasSlicing()) {
                slices = ProfileUtilities.getSliceList((StructureDefinition)profile, (ElementDefinition)ed);
            }
            block1: for (ElementInfo ei : children) {
                if (ei.definition == ed) {
                    ++count;
                    continue;
                }
                if (slices == null) continue;
                for (ElementDefinition sed : slices) {
                    if (ei.definition != sed) continue;
                    ++count;
                    continue block1;
                }
            }
            String location = "Profile " + profile.getUrl() + ", Element '" + stack.getLiteralPath() + "." + this.tail(ed.getPath()) + (ed.hasSliceName() ? "[" + ed.getSliceName() + (ed.hasLabel() ? " (" + ed.getLabel() + ")" : "") + "]" : "") + "'";
            if (ed.getMin() > 0) {
                if (problematicPaths.contains(ed.getPath())) {
                    this.hint(errors, ValidationMessage.IssueType.NOTSUPPORTED, element.line(), element.col(), stack.getLiteralPath(), count >= ed.getMin(), location + "': Unable to check minimum required (" + Integer.toString(ed.getMin()) + ") due to lack of slicing validation");
                } else {
                    this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath(), count >= ed.getMin(), location + ": minimum required = " + Integer.toString(ed.getMin()) + ", but only found " + Integer.toString(count), new Object[0]);
                }
            }
            if (!ed.hasMax() || ed.getMax().equals("*")) continue;
            if (problematicPaths.contains(ed.getPath())) {
                this.hint(errors, ValidationMessage.IssueType.NOTSUPPORTED, element.line(), element.col(), stack.getLiteralPath(), count <= Integer.parseInt(ed.getMax()), location + ": Unable to check max allowed (" + ed.getMax() + ") due to lack of slicing validation");
                continue;
            }
            this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath(), count <= Integer.parseInt(ed.getMax()), location + ": max allowed = " + ed.getMax() + ", but found " + Integer.toString(count), new Object[0]);
        }
    }

    public List<String> assignChildren(ValidatorHostContext hostContext, List<ValidationMessage> errors, StructureDefinition profile, org.hl7.fhir.r5.elementmodel.Element resource, NodeStack stack, List<ElementDefinition> childDefinitions, List<ElementInfo> children) throws DefinitionException, IOException {
        ElementDefinition slicer = null;
        boolean unsupportedSlicing = false;
        ArrayList<String> problematicPaths = new ArrayList<String>();
        String slicingPath = null;
        int sliceOffset = 0;
        for (int i = 0; i < childDefinitions.size(); ++i) {
            ElementDefinition ed = childDefinitions.get(i);
            boolean childUnsupportedSlicing = false;
            boolean process = true;
            if (ed.hasSlicing() && !ed.getSlicing().getOrdered()) {
                slicingPath = ed.getPath();
            } else if (!(slicingPath != null && ed.getPath().equals(slicingPath) || slicingPath == null || ed.getPath().startsWith(slicingPath))) {
                slicingPath = null;
            }
            if (ed.hasSlicing()) {
                if (slicer != null && slicer.getPath().equals(ed.getPath())) {
                    Object errorContext = "profile " + profile.getUrl();
                    if (!resource.getChildValue("id").isEmpty()) {
                        errorContext = (String)errorContext + "; instance " + resource.getChildValue("id");
                    }
                    throw new DefinitionException("Slice encountered midway through path on " + slicer.getPath() + "; " + (String)errorContext);
                }
                slicer = ed;
                process = false;
                sliceOffset = i;
            } else if (slicer != null && !slicer.getPath().equals(ed.getPath())) {
                slicer = null;
            }
            for (ElementInfo ei : children) {
                unsupportedSlicing = this.matchSlice(hostContext, errors, profile, stack, slicer, unsupportedSlicing, problematicPaths, sliceOffset, i, ed, childUnsupportedSlicing, ei);
            }
        }
        int last = -1;
        int lastSlice = -1;
        for (ElementInfo ei : children) {
            String sliceInfo = "";
            if (slicer != null) {
                sliceInfo = " (slice: " + slicer.getPath() + ")";
            }
            if (!unsupportedSlicing) {
                if (ei.additionalSlice && ei.definition != null) {
                    if (ei.definition.getSlicing().getRules().equals((Object)ElementDefinition.SlicingRules.OPEN) || ei.definition.getSlicing().getRules().equals((Object)ElementDefinition.SlicingRules.OPENATEND)) {
                        this.hint(errors, ValidationMessage.IssueType.INFORMATIONAL, ei.line(), ei.col(), ei.path, false, "This element does not match any known slice" + (profile == null ? "" : " for the profile " + profile.getUrl()));
                    } else if (ei.definition.getSlicing().getRules().equals((Object)ElementDefinition.SlicingRules.CLOSED)) {
                        this.rule(errors, ValidationMessage.IssueType.INVALID, ei.line(), ei.col(), ei.path, false, "This element does not match any known slice" + (profile == null ? "" : " for profile " + profile.getUrl() + " and slicing is CLOSED"), new Object[0]);
                    }
                } else if (!profile.getAbstract()) {
                    this.hint(errors, ValidationMessage.IssueType.NOTSUPPORTED, ei.line(), ei.col(), ei.path, ei.definition != null, "Could not verify slice for profile " + profile.getUrl());
                }
            }
            boolean isXmlAttr = false;
            if (ei.definition != null) {
                for (Enumeration r : ei.definition.getRepresentation()) {
                    if (r.getValue() != ElementDefinition.PropertyRepresentation.XMLATTR) continue;
                    isXmlAttr = true;
                    break;
                }
            }
            if (!ToolingExtensions.readBoolExtension((DomainResource)profile, (String)"http://hl7.org/fhir/StructureDefinition/structuredefinition-xml-no-order")) {
                boolean ok = ei.definition == null || ei.index >= last || isXmlAttr;
                this.rule(errors, ValidationMessage.IssueType.INVALID, ei.line(), ei.col(), ei.path, ok, "As specified by profile " + profile.getUrl() + ", Element '" + ei.name + "' is out of order", new Object[0]);
            }
            if (ei.slice != null && ei.index == last && ei.slice.getSlicing().getOrdered()) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, ei.line(), ei.col(), ei.path, ei.definition == null || ei.sliceindex >= lastSlice || isXmlAttr, "As specified by profile " + profile.getUrl() + ", Element '" + ei.name + "' is out of order in ordered slice", new Object[0]);
            }
            if (ei.definition == null || !isXmlAttr) {
                last = ei.index;
            }
            if (ei.slice != null) {
                lastSlice = ei.sliceindex;
                continue;
            }
            lastSlice = -1;
        }
        return problematicPaths;
    }

    public List<ElementInfo> listChildren(org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack) {
        ArrayList<ElementInfo> children = new ArrayList<ElementInfo>();
        ChildIterator iter = new ChildIterator(stack.getLiteralPath(), element);
        while (iter.next()) {
            children.add(new ElementInfo(iter.name(), iter.element(), iter.path(), iter.count()));
        }
        return children;
    }

    public void checkInvariants(ValidatorHostContext hostContext, List<ValidationMessage> errors, StructureDefinition profile, ElementDefinition definition, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack) throws FHIRException {
        this.checkInvariants(hostContext, errors, stack.getLiteralPath(), profile, definition, null, null, resource, element);
        if (definition.getFixed() != null) {
            this.checkFixedValue(errors, stack.getLiteralPath(), element, (org.hl7.fhir.r5.model.Element)definition.getFixed(), definition.getSliceName(), null);
        }
    }

    public boolean matchSlice(ValidatorHostContext hostContext, List<ValidationMessage> errors, StructureDefinition profile, NodeStack stack, ElementDefinition slicer, boolean unsupportedSlicing, List<String> problematicPaths, int sliceOffset, int i, ElementDefinition ed, boolean childUnsupportedSlicing, ElementInfo ei) throws IOException {
        boolean match = false;
        if (slicer == null || slicer == ed) {
            match = this.nameMatches(ei.name, this.tail(ed.getPath()));
        } else if (this.nameMatches(ei.name, this.tail(ed.getPath()))) {
            try {
                match = this.sliceMatches(hostContext, ei.element, ei.path, slicer, ed, profile, errors, stack);
                if (match) {
                    ei.slice = slicer;
                    ei.additionalSlice = false;
                } else if (ei.slice == null) {
                    ei.additionalSlice = true;
                }
            }
            catch (FHIRException e) {
                this.rule(errors, ValidationMessage.IssueType.PROCESSING, ei.line(), ei.col(), ei.path, false, e.getMessage(), new Object[0]);
                unsupportedSlicing = true;
                childUnsupportedSlicing = true;
            }
        }
        if (match) {
            boolean isOk = ei.definition == null || ei.definition == slicer || ei.definition.getPath().endsWith("[x]") && ed.getPath().startsWith(ei.definition.getPath().replace("[x]", ""));
            if (this.rule(errors, ValidationMessage.IssueType.INVALID, ei.line(), ei.col(), ei.path, isOk, "Profile " + profile.getUrl() + ", Element matches more than one slice - " + (ei.definition == null || !ei.definition.hasSliceName() ? "" : ei.definition.getSliceName()) + ", " + (ed.hasSliceName() ? ed.getSliceName() : ""), new Object[0])) {
                ei.definition = ed;
                if (ei.slice == null) {
                    ei.index = i;
                } else {
                    ei.index = sliceOffset;
                    ei.sliceindex = i - (sliceOffset + 1);
                }
            }
        } else if (childUnsupportedSlicing) {
            problematicPaths.add(ed.getPath());
        }
        return unsupportedSlicing;
    }

    private ElementDefinition getElementByTail(StructureDefinition p, String tail) throws DefinitionException {
        if (tail == null) {
            return (ElementDefinition)p.getSnapshot().getElement().get(0);
        }
        for (ElementDefinition t : p.getSnapshot().getElement()) {
            if (!tail.equals(t.getId())) continue;
            return t;
        }
        throw new DefinitionException("Unable to find element with id '" + tail + "'");
    }

    private IResourceValidator.IdStatus idStatusForEntry(org.hl7.fhir.r5.elementmodel.Element ep, ElementInfo ei) {
        if (this.isBundleEntry(ei.path)) {
            org.hl7.fhir.r5.elementmodel.Element req = ep.getNamedChild("request");
            org.hl7.fhir.r5.elementmodel.Element resp = ep.getNamedChild("response");
            org.hl7.fhir.r5.elementmodel.Element fullUrl = ep.getNamedChild("fullUrl");
            org.hl7.fhir.r5.elementmodel.Element method = null;
            org.hl7.fhir.r5.elementmodel.Element url = null;
            if (req != null) {
                method = req.getNamedChild("method");
                url = req.getNamedChild("url");
            }
            if (resp != null) {
                return IResourceValidator.IdStatus.OPTIONAL;
            }
            if (method == null) {
                if (fullUrl == null) {
                    return IResourceValidator.IdStatus.REQUIRED;
                }
                if (fullUrl.primitiveValue().startsWith("urn:uuid:") || fullUrl.primitiveValue().startsWith("urn:oid:")) {
                    return IResourceValidator.IdStatus.OPTIONAL;
                }
                return IResourceValidator.IdStatus.REQUIRED;
            }
            String s = method.primitiveValue();
            if (s.equals("PUT")) {
                if (url == null) {
                    return IResourceValidator.IdStatus.REQUIRED;
                }
                return IResourceValidator.IdStatus.OPTIONAL;
            }
            if (s.equals("POST")) {
                return IResourceValidator.IdStatus.OPTIONAL;
            }
            return IResourceValidator.IdStatus.OPTIONAL;
        }
        if (this.isParametersEntry(ei.path) || this.isBundleOutcome(ei.path)) {
            return IResourceValidator.IdStatus.OPTIONAL;
        }
        return IResourceValidator.IdStatus.REQUIRED;
    }

    private void checkInvariants(ValidatorHostContext hostContext, List<ValidationMessage> errors, String path, StructureDefinition profile, ElementDefinition ed, String typename, String typeProfile, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element element) throws FHIRException, FHIRException {
        if (this.noInvariantChecks) {
            return;
        }
        for (ElementDefinition.ElementDefinitionConstraintComponent inv : ed.getConstraint()) {
            HashSet<String> invList;
            if (!inv.hasExpression()) continue;
            HashSet<String> hashSet = invList = this.executionId.equals(element.getUserString(EXECUTION_ID)) ? (HashSet<String>)element.getUserData(EXECUTED_CONSTRAINT_LIST) : null;
            if (invList == null) {
                invList = new HashSet<String>();
                element.setUserData(EXECUTED_CONSTRAINT_LIST, invList);
                element.setUserData(EXECUTION_ID, (Object)this.executionId);
            }
            if (invList.contains(inv.getKey())) continue;
            invList.add(inv.getKey());
            this.checkInvariant(hostContext, errors, path, profile, resource, element, inv);
        }
    }

    public void checkInvariant(ValidatorHostContext hostContext, List<ValidationMessage> errors, String path, StructureDefinition profile, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element element, ElementDefinition.ElementDefinitionConstraintComponent inv) throws FHIRException {
        String msg;
        boolean ok;
        ExpressionNode n = (ExpressionNode)inv.getUserData("validator.expression.cache");
        if (n == null) {
            long t = System.nanoTime();
            try {
                n = this.fpe.parse(this.fixExpr(inv.getExpression()));
            }
            catch (FHIRLexer.FHIRLexerException e) {
                throw new FHIRException("Problem processing expression " + inv.getExpression() + " in profile " + profile.getUrl() + " path " + path + ": " + e.getMessage());
            }
            this.fpeTime += System.nanoTime() - t;
            inv.setUserData("validator.expression.cache", (Object)n);
        }
        try {
            long t = System.nanoTime();
            ok = this.fpe.evaluateToBoolean((Object)hostContext, (Base)resource, (Base)hostContext.rootResource, (Base)element, n);
            this.fpeTime += System.nanoTime() - t;
            msg = this.fpe.forLog();
        }
        catch (Exception ex) {
            ok = false;
            msg = ex.getMessage();
        }
        if (!ok) {
            if (!Utilities.noString((String)msg)) {
                msg = " (" + msg + ")";
            }
            if (inv.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-bestpractice") && ToolingExtensions.readBooleanExtension((org.hl7.fhir.r5.model.Element)inv, (String)"http://hl7.org/fhir/StructureDefinition/elementdefinition-bestpractice").booleanValue()) {
                if (this.bpWarnings == IResourceValidator.BestPracticeWarningLevel.Hint) {
                    this.hint(errors, ValidationMessage.IssueType.INVARIANT, element.line(), element.col(), path, ok, inv.getKey() + ": " + inv.getHuman() + msg + " [" + n.toString() + "]");
                } else if (this.bpWarnings == IResourceValidator.BestPracticeWarningLevel.Warning) {
                    this.warning(errors, ValidationMessage.IssueType.INVARIANT, element.line(), element.col(), path, ok, inv.getKey() + ": " + inv.getHuman() + msg + " [" + n.toString() + "]", new Object[0]);
                } else if (this.bpWarnings == IResourceValidator.BestPracticeWarningLevel.Error) {
                    this.rule(errors, ValidationMessage.IssueType.INVARIANT, element.line(), element.col(), path, ok, inv.getKey() + ": " + inv.getHuman() + msg + " [" + n.toString() + "]", new Object[0]);
                }
            } else if (inv.getSeverity() == ElementDefinition.ConstraintSeverity.ERROR) {
                this.rule(errors, ValidationMessage.IssueType.INVARIANT, element.line(), element.col(), path, ok, inv.getKey() + ": " + inv.getHuman() + msg + " [" + n.toString() + "]", new Object[0]);
            } else if (inv.getSeverity() == ElementDefinition.ConstraintSeverity.WARNING) {
                this.warning(errors, ValidationMessage.IssueType.INVARIANT, element.line(), element.line(), path, ok, inv.getKey() + ": " + inv.getHuman() + msg + " [" + n.toString() + "]", new Object[0]);
            }
        }
    }

    private void validateMessage(List<ValidationMessage> errors, List<org.hl7.fhir.r5.elementmodel.Element> entries, org.hl7.fhir.r5.elementmodel.Element messageHeader, NodeStack stack, String fullUrl, String id) {
        if (this.rule(errors, ValidationMessage.IssueType.INVALID, messageHeader.line(), messageHeader.col(), stack.getLiteralPath(), messageHeader.getType().equals("MessageHeader"), "The first entry in a message must be a MessageHeader", new Object[0])) {
            List elements = messageHeader.getChildren("data");
            for (org.hl7.fhir.r5.elementmodel.Element elem : elements) {
                this.validateBundleReference(errors, entries, elem, "MessageHeader Data", stack.push(elem, -1, null, null), fullUrl, "MessageHeader", id);
            }
        }
    }

    private void validateObservation(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack) {
        this.bpCheck(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), element.getNamedChild("subject") != null, "All observations should have a subject");
        ArrayList performers = new ArrayList();
        element.getNamedChildren("performer", performers);
        this.bpCheck(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), performers.size() > 0, "All observations should have a performer");
        this.bpCheck(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), element.getNamedChild("effectiveDateTime") != null || element.getNamedChild("effectivePeriod") != null, "All observations should have an effectiveDateTime or an effectivePeriod");
    }

    private void validateResource(ValidatorHostContext hostContext, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition defn, ValidationProfileSet profiles, IResourceValidator.IdStatus idstatus, NodeStack stack, boolean isEntry) throws FHIRException, FHIRException, IOException {
        org.hl7.fhir.r5.elementmodel.Element first;
        String type;
        assert (stack != null);
        assert (resource != null);
        if (isEntry || this.executionId == null) {
            this.executionId = UUID.randomUUID().toString();
        }
        boolean ok = true;
        String resourceName = element.getType();
        if (defn == null) {
            long t = System.nanoTime();
            defn = element.getProperty().getStructure();
            if (defn == null) {
                defn = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + resourceName);
            }
            if (profiles != null) {
                this.getResourceProfiles(resource, stack).addProfiles(errors, profiles, stack.getLiteralPath(), element, isEntry);
            }
            this.sdTime += System.nanoTime() - t;
            ok = this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.addToLiteralPath(resourceName), defn != null, "No definition found for resource type '" + resourceName + "'", new Object[0]);
        }
        String string = type = defn.getKind() == StructureDefinition.StructureDefinitionKind.LOGICAL ? defn.getId() : defn.getType();
        if (!type.equals(resourceName) && resourceName.equals("Bundle") && (first = this.getFirstEntry(element)) != null && first.getType().equals(type)) {
            element = first;
            resourceName = element.getType();
            idstatus = IResourceValidator.IdStatus.OPTIONAL;
        }
        if (ok = this.rule(errors, ValidationMessage.IssueType.INVALID, -1, -1, stack.getLiteralPath(), type.equals(resourceName), "Specified profile type was '" + type + "', but found type '" + resourceName + "'", new Object[0])) {
            if (idstatus == IResourceValidator.IdStatus.REQUIRED && element.getNamedChild("id") == null) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), false, "Resource requires an id, but none is present", new Object[0]);
            } else if (idstatus == IResourceValidator.IdStatus.PROHIBITED && element.getNamedChild("id") != null) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), false, "Resource has an id, but none is allowed", new Object[0]);
            }
            this.start(hostContext, errors, element, element, defn, stack);
        }
    }

    private void loadProfiles(ValidationProfileSet profiles) throws DefinitionException {
        if (profiles != null) {
            for (String profile : profiles.getCanonicalUrls()) {
                StructureDefinition p = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, profile);
                if (p == null) {
                    throw new DefinitionException("StructureDefinition '" + profile + "' not found by validator");
                }
                profiles.getDefinitions().add(p);
            }
        }
    }

    private org.hl7.fhir.r5.elementmodel.Element getFirstEntry(org.hl7.fhir.r5.elementmodel.Element bundle) {
        ArrayList list = new ArrayList();
        bundle.getNamedChildren("entry", list);
        if (list.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.elementmodel.Element resource = ((org.hl7.fhir.r5.elementmodel.Element)list.get(0)).getNamedChild("resource");
        if (resource == null) {
            return null;
        }
        return resource;
    }

    private void validateSections(List<ValidationMessage> errors, List<org.hl7.fhir.r5.elementmodel.Element> entries, org.hl7.fhir.r5.elementmodel.Element focus, NodeStack stack, String fullUrl, String id) {
        ArrayList sections = new ArrayList();
        focus.getNamedChildren("section", sections);
        int i = 1;
        for (org.hl7.fhir.r5.elementmodel.Element section : sections) {
            NodeStack localStack = stack.push(section, i, null, null);
            this.validateDocumentReference(errors, entries, section, stack, fullUrl, id, false, "author", "Section");
            this.validateDocumentReference(errors, entries, section, stack, fullUrl, id, false, "focus", "Section");
            ArrayList sectionEntries = new ArrayList();
            section.getNamedChildren("entry", sectionEntries);
            int j = 1;
            for (org.hl7.fhir.r5.elementmodel.Element sectionEntry : sectionEntries) {
                NodeStack localStack2 = localStack.push(sectionEntry, j, null, null);
                this.validateBundleReference(errors, entries, sectionEntry, "Section Entry", localStack2, fullUrl, "Composition", id);
                ++j;
            }
            this.validateSections(errors, entries, section, localStack, fullUrl, id);
            ++i;
        }
    }

    private boolean valueMatchesCriteria(org.hl7.fhir.r5.elementmodel.Element value, ElementDefinition criteria) throws FHIRException {
        if (criteria.hasFixed()) {
            ArrayList<ValidationMessage> msgs = new ArrayList<ValidationMessage>();
            this.checkFixedValue(msgs, "{virtual}", value, (org.hl7.fhir.r5.model.Element)criteria.getFixed(), "value", null);
            return msgs.size() == 0;
        }
        if (criteria.hasBinding() && criteria.getBinding().getStrength() == Enumerations.BindingStrength.REQUIRED && criteria.getBinding().hasValueSet()) {
            throw new FHIRException("Unable to resolve slice matching - slice matching by value set not done");
        }
        throw new FHIRException("Unable to resolve slice matching - no fixed value or required value set");
    }

    private boolean yearIsValid(String v) {
        if (v == null) {
            return false;
        }
        try {
            int i = Integer.parseInt(v.substring(0, Math.min(4, v.length())));
            return i >= 1800 && i <= this.thisYear() + 80;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private int thisYear() {
        return Calendar.getInstance().get(1);
    }

    public String reportTimes() {
        String s = String.format("Times: overall = %d, tx = %d, sd = %d, load = %d, fpe = %d", this.overall, this.txTime, this.sdTime, this.loadTime, this.fpeTime);
        this.overall = 0L;
        this.txTime = 0L;
        this.sdTime = 0L;
        this.loadTime = 0L;
        this.fpeTime = 0L;
        return s;
    }

    public boolean isNoBindingMsgSuppressed() {
        return this.noBindingMsgSuppressed;
    }

    public IResourceValidator setNoBindingMsgSuppressed(boolean noBindingMsgSuppressed) {
        this.noBindingMsgSuppressed = noBindingMsgSuppressed;
        return this;
    }

    public boolean isNoTerminologyChecks() {
        return this.noTerminologyChecks;
    }

    public IResourceValidator setNoTerminologyChecks(boolean noTerminologyChecks) {
        this.noTerminologyChecks = noTerminologyChecks;
        return this;
    }

    public void checkAllInvariants() {
        for (StructureDefinition sd : this.context.allStructures()) {
            if (sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION) continue;
            for (ElementDefinition ed : sd.getSnapshot().getElement()) {
                for (ElementDefinition.ElementDefinitionConstraintComponent inv : ed.getConstraint()) {
                    if (!inv.hasExpression()) continue;
                    try {
                        ExpressionNode n = (ExpressionNode)inv.getUserData("validator.expression.cache");
                        if (n == null) {
                            n = this.fpe.parse(this.fixExpr(inv.getExpression()));
                            inv.setUserData("validator.expression.cache", (Object)n);
                        }
                        this.fpe.check(null, sd.getKind() == StructureDefinition.StructureDefinitionKind.RESOURCE ? sd.getType() : "DomainResource", ed.getPath(), n);
                    }
                    catch (Exception e) {
                        System.out.println("Error processing structure [" + sd.getId() + "] path " + ed.getPath() + ":" + inv.getKey() + " (\"" + inv.getExpression() + "\"): " + e.getMessage());
                    }
                }
            }
        }
    }

    private String fixExpr(String expr) {
        if ("(component.empty() and hasMember.empty()) implies (dataAbsentReason or value)".equals(expr)) {
            return "(component.empty() and hasMember.empty()) implies (dataAbsentReason.exists() or value.exists())";
        }
        if ("isModifier implies isModifierReason.exists()".equals(expr)) {
            return "(isModifier.exists() and isModifier) implies isModifierReason.exists()";
        }
        if ("(%resource.kind = 'logical' or element.first().path.startsWith(%resource.type)) and (element.tail().not() or  element.tail().all(path.startsWith(%resource.differential.element.first().path.replaceMatches('\\\\..*','')&'.')))".equals(expr)) {
            return "(%resource.kind = 'logical' or element.first().path.startsWith(%resource.type)) and (element.tail().empty() or  element.tail().all(path.startsWith(%resource.differential.element.first().path.replaceMatches('\\\\..*','')&'.')))";
        }
        if ("differential.element.all(id) and differential.element.id.trace('ids').isDistinct()".equals(expr)) {
            return "differential.element.all(id.exists()) and differential.element.id.trace('ids').isDistinct()";
        }
        if ("snapshot.element.all(id) and snapshot.element.id.trace('ids').isDistinct()".equals(expr)) {
            return "snapshot.element.all(id.exists()) and snapshot.element.id.trace('ids').isDistinct()";
        }
        if ("(code or value.empty()) and (system.empty() or system = 'urn:iso:std:iso:4217')".equals(expr)) {
            return "(code.exists() or value.empty()) and (system.empty() or system = 'urn:iso:std:iso:4217')";
        }
        if ("value.empty() or code!=component.code".equals(expr)) {
            return "value.empty() or (code in component.code).not()";
        }
        if ("(code or value.empty()) and (system.empty() or system = %ucum) and (value.empty() or value > 0)".equals(expr)) {
            return "(code.exists() or value.empty()) and (system.empty() or system = %ucum) and (value.empty() or value > 0)";
        }
        if ("element.all(definition and min and max)".equals(expr)) {
            return "element.all(definition.exists() and min.exists() and max.exists())";
        }
        if ("telecom or endpoint".equals(expr)) {
            return "telecom.exists() or endpoint.exists()";
        }
        if ("(code or value.empty()) and (system.empty() or system = %ucum) and (value.empty() or value > 0)".equals(expr)) {
            return "(code.exists() or value.empty()) and (system.empty() or system = %ucum) and (value.empty() or value > 0)";
        }
        if ("searchType implies type = 'string'".equals(expr)) {
            return "searchType.exists() implies type = 'string'";
        }
        if ("abatement.empty() or (abatement as boolean).not()  or clinicalStatus='resolved' or clinicalStatus='remission' or clinicalStatus='inactive'".equals(expr)) {
            return "abatement.empty() or (abatement is boolean).not() or (abatement as boolean).not() or (clinicalStatus = 'resolved') or (clinicalStatus = 'remission') or (clinicalStatus = 'inactive')";
        }
        if ("(component.empty() and related.empty()) implies (dataAbsentReason or value)".equals(expr)) {
            return "(component.empty() and related.empty()) implies (dataAbsentReason.exists() or value.exists())";
        }
        if ("".equals(expr)) {
            return "";
        }
        return expr;
    }

    public FHIRPathEngine.IEvaluationContext getExternalHostServices() {
        return this.externalHostServices;
    }

    public String getValidationLanguage() {
        return this.validationLanguage;
    }

    public void setValidationLanguage(String validationLanguage) {
        this.validationLanguage = validationLanguage;
    }

    public class ElementInfo {
        public int index;
        public int sliceindex;
        public int count;
        public ElementDefinition definition;
        public ElementDefinition slice;
        public boolean additionalSlice;
        private org.hl7.fhir.r5.elementmodel.Element element;
        private String name;
        private String path;

        public ElementInfo(String name, org.hl7.fhir.r5.elementmodel.Element element, String path, int count) {
            this.name = name;
            this.element = element;
            this.path = path;
            this.count = count;
        }

        public int col() {
            return this.element.col();
        }

        public int line() {
            return this.element.line();
        }

        public String toString() {
            return this.path;
        }
    }

    public class NodeStack {
        private ElementDefinition definition;
        private org.hl7.fhir.r5.elementmodel.Element element;
        private ElementDefinition extension;
        private String literalPath;
        private List<String> logicalPaths;
        private NodeStack parent;
        private ElementDefinition type;
        private String workingLang;

        public NodeStack() {
            this.workingLang = InstanceValidator.this.validationLanguage;
        }

        public NodeStack(org.hl7.fhir.r5.elementmodel.Element element) {
            this.element = element;
            this.literalPath = element.getName();
            this.workingLang = InstanceValidator.this.validationLanguage;
        }

        public String addToLiteralPath(String ... path) {
            StringBuilder b = new StringBuilder();
            b.append(this.getLiteralPath());
            for (String p : path) {
                if (p.startsWith(":")) {
                    b.append("[");
                    b.append(p.substring(1));
                    b.append("]");
                    continue;
                }
                b.append(".");
                b.append(p);
            }
            return b.toString();
        }

        private ElementDefinition getDefinition() {
            return this.definition;
        }

        private org.hl7.fhir.r5.elementmodel.Element getElement() {
            return this.element;
        }

        protected String getLiteralPath() {
            return this.literalPath == null ? "" : this.literalPath;
        }

        private List<String> getLogicalPaths() {
            return this.logicalPaths == null ? new ArrayList() : this.logicalPaths;
        }

        private ElementDefinition getType() {
            return this.type;
        }

        private NodeStack push(org.hl7.fhir.r5.elementmodel.Element element, int count, ElementDefinition definition, ElementDefinition type) {
            NodeStack res = new NodeStack();
            res.parent = this;
            res.workingLang = this.workingLang;
            res.element = element;
            res.definition = definition;
            res.literalPath = this.getLiteralPath() + "." + element.getName();
            if (count > -1) {
                res.literalPath = res.literalPath + "[" + Integer.toString(count) + "]";
            } else if (element.getSpecial() == null && element.getProperty().isList()) {
                res.literalPath = res.literalPath + "[0]";
            } else if (element.getProperty().isChoice()) {
                String n = res.literalPath.substring(res.literalPath.lastIndexOf(".") + 1);
                Object en = element.getProperty().getName();
                String t = n.substring(((String)(en = ((String)en).substring(0, ((String)en).length() - 3))).length());
                if (InstanceValidator.this.isPrimitiveType(Utilities.uncapitalize((String)t))) {
                    t = Utilities.uncapitalize((String)t);
                }
                res.literalPath = res.literalPath.substring(0, res.literalPath.lastIndexOf(".")) + "." + (String)en + ".ofType(" + t + ")";
            }
            res.logicalPaths = new ArrayList<String>();
            if (type != null) {
                res.type = type;
                String t = InstanceValidator.this.tail(definition.getPath());
                for (String lp : this.getLogicalPaths()) {
                    res.logicalPaths.add(lp + "." + t);
                    if (!t.endsWith("[x]")) continue;
                    res.logicalPaths.add(lp + "." + t.substring(0, t.length() - 3) + type.getPath());
                }
                res.logicalPaths.add(type.getPath());
            } else if (definition != null) {
                for (String lp : this.getLogicalPaths()) {
                    res.logicalPaths.add(lp + "." + element.getName());
                }
            } else {
                res.logicalPaths.addAll(this.getLogicalPaths());
            }
            return res;
        }

        private void setType(ElementDefinition type) {
            this.type = type;
        }
    }

    public class ChildIterator {
        private String basePath;
        private org.hl7.fhir.r5.elementmodel.Element parent;
        private int cursor;
        private int lastCount;

        public ChildIterator(String path, org.hl7.fhir.r5.elementmodel.Element element) {
            this.parent = element;
            this.basePath = path;
            this.cursor = -1;
        }

        public int count() {
            String na;
            String nb = this.cursor == 0 ? "--" : ((org.hl7.fhir.r5.elementmodel.Element)this.parent.getChildren().get(this.cursor - 1)).getName();
            String string = na = this.cursor >= this.parent.getChildren().size() - 1 ? "--" : ((org.hl7.fhir.r5.elementmodel.Element)this.parent.getChildren().get(this.cursor + 1)).getName();
            if (this.name().equals(nb) || this.name().equals(na)) {
                return this.lastCount;
            }
            return -1;
        }

        public org.hl7.fhir.r5.elementmodel.Element element() {
            return (org.hl7.fhir.r5.elementmodel.Element)this.parent.getChildren().get(this.cursor);
        }

        public String name() {
            return this.element().getName();
        }

        public boolean next() {
            if (this.cursor == -1) {
                ++this.cursor;
                this.lastCount = 0;
            } else {
                String lastName = this.name();
                ++this.cursor;
                this.lastCount = this.cursor < this.parent.getChildren().size() && this.name().equals(lastName) ? ++this.lastCount : 0;
            }
            return this.cursor < this.parent.getChildren().size();
        }

        public String path() {
            int i = this.count();
            String sfx = "";
            String n = this.name();
            String fn = "";
            if (this.element().getProperty().isChoice()) {
                String en = this.element().getProperty().getName();
                String t = n.substring((en = en.substring(0, en.length() - 3)).length());
                if (InstanceValidator.this.isPrimitiveType(Utilities.uncapitalize((String)t))) {
                    t = Utilities.uncapitalize((String)t);
                }
                n = en;
                fn = ".ofType(" + t + ")";
            }
            if (i > -1 || this.element().getSpecial() == null && this.element().isList()) {
                sfx = "[" + Integer.toString(this.lastCount) + "]";
            }
            return this.basePath + "." + n + sfx + fn;
        }
    }

    public class ResourceProfiles {
        private org.hl7.fhir.r5.elementmodel.Element resource;
        private org.hl7.fhir.r5.elementmodel.Element owner;
        private NodeStack stack;
        private HashMap<StructureDefinition, ProfileUsage> profiles;
        private boolean processed;

        public ResourceProfiles(org.hl7.fhir.r5.elementmodel.Element resource, NodeStack stack) {
            this.resource = resource;
            this.owner = this.resource.getName().equals("contained") && stack.parent != null ? stack.parent.element : resource;
            this.stack = stack;
            this.profiles = new HashMap();
            this.processed = false;
        }

        public boolean isProcessed() {
            return this.processed;
        }

        public void setProcessed() {
            this.processed = true;
        }

        public NodeStack getStack() {
            return this.stack;
        }

        public org.hl7.fhir.r5.elementmodel.Element getOwner() {
            return this.owner;
        }

        public boolean hasProfiles() {
            return !this.profiles.isEmpty();
        }

        public void addProfiles(List<ValidationMessage> errors, ValidationProfileSet profiles, String path, org.hl7.fhir.r5.elementmodel.Element element, boolean external) throws FHIRException {
            for (ValidationProfileSet.ProfileRegistration profile : profiles.getCanonical()) {
                ImplementationGuide ig;
                StructureDefinition sd = profiles.fetch(profile.getProfile());
                if (sd == null) {
                    sd = (StructureDefinition)InstanceValidator.this.context.fetchResource(StructureDefinition.class, profile.getProfile());
                }
                if (sd == null && (ig = (ImplementationGuide)InstanceValidator.this.context.fetchResource(ImplementationGuide.class, profile.getProfile())) != null) {
                    ImplementationGuide.ImplementationGuideGlobalComponent t;
                    Iterator iterator = ig.getGlobal().iterator();
                    while (iterator.hasNext() && (!(t = (ImplementationGuide.ImplementationGuideGlobalComponent)iterator.next()).getType().equals(element.fhirType()) || (sd = (StructureDefinition)InstanceValidator.this.context.fetchResource(StructureDefinition.class, t.getProfile())) == null)) {
                    }
                }
                if (sd == null) {
                    errors.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.UNKNOWN, path, "Unable to locate profile " + profile.getProfile(), external ? ValidationMessage.IssueSeverity.ERROR : ValidationMessage.IssueSeverity.WARNING));
                    continue;
                }
                if (!sd.getType().equals(element.fhirType())) {
                    org.hl7.fhir.r5.elementmodel.Element res;
                    List entries;
                    boolean ok = false;
                    if (element.fhirType().equals("Bundle") && (entries = element.getChildren("entry")).size() > 0 && (res = ((org.hl7.fhir.r5.elementmodel.Element)entries.get(0)).getNamedChild("resource")) != null) {
                        ok = true;
                    }
                    if (ok) continue;
                    errors.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.UNKNOWN, path, "Profile mismatch on type for " + profile.getProfile() + ": the profile constrains " + sd.getType() + " but the element is " + element.fhirType(), ValidationMessage.IssueSeverity.ERROR));
                    continue;
                }
                this.addProfile(errors, profile.getProfile(), profile.isErrorOnMissing(), path, element, sd);
            }
        }

        public boolean addProfile(List<ValidationMessage> errors, String profile, boolean errorOnMissing, String path, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition containingProfile) {
            String effectiveProfile = profile;
            String version = null;
            if (profile.contains("|")) {
                effectiveProfile = profile.substring(0, profile.indexOf(124));
                version = profile.substring(profile.indexOf(124) + 1);
            }
            StructureDefinition sd = null;
            if (profile.startsWith("#")) {
                if (!InstanceValidator.this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path, containingProfile != null, "StructureDefinition reference \"{0}\" is local, but there is not local context", profile)) {
                    return false;
                }
                if (containingProfile.hasUserData("container")) {
                    containingProfile = (StructureDefinition)containingProfile.getUserData("container");
                }
                if ((sd = (StructureDefinition)containingProfile.getContained(profile)) != null) {
                    sd.setUserData("container", (Object)containingProfile);
                }
            } else {
                if (InstanceValidator.this.providedProfiles != null) {
                    sd = InstanceValidator.this.providedProfiles.fetch(effectiveProfile);
                }
                if (sd == null) {
                    sd = (StructureDefinition)InstanceValidator.this.context.fetchResource(StructureDefinition.class, effectiveProfile);
                }
            }
            if (InstanceValidator.this.warningOrError(errorOnMissing, errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path, sd != null, "StructureDefinition reference \"{0}\" could not be resolved", profile) && InstanceValidator.this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, version == null || sd.getVersion() != null && sd.getVersion().equals(version), "Referenced version " + version + " does not match found version " + sd.getVersion() + " for profile " + sd.getUrl(), profile) && InstanceValidator.this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, sd.hasSnapshot(), "StructureDefinition has no snapshot - validation is against the snapshot, so it must be provided", new Object[0]) && !this.profiles.containsKey(sd)) {
                this.profiles.put(sd, new ProfileUsage(sd));
                this.addAncestorProfiles(sd);
                return true;
            }
            return false;
        }

        public void addAncestorProfiles(StructureDefinition sd) {
            StructureDefinition parentSd;
            if (sd.hasDerivation() && sd.getDerivation().equals((Object)StructureDefinition.TypeDerivationRule.CONSTRAINT) && (parentSd = (StructureDefinition)InstanceValidator.this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition())) != null && !this.profiles.containsKey(parentSd)) {
                ProfileUsage pu = new ProfileUsage(parentSd);
                pu.setChecked();
                this.profiles.put(parentSd, pu);
            }
        }

        public List<ProfileUsage> uncheckedProfiles() {
            ArrayList<ProfileUsage> uncheckedProfiles = new ArrayList<ProfileUsage>();
            for (ProfileUsage profileUsage : this.profiles.values()) {
                if (profileUsage.isChecked()) continue;
                uncheckedProfiles.add(profileUsage);
            }
            return uncheckedProfiles;
        }

        public boolean hasUncheckedProfiles() {
            return !this.uncheckedProfiles().isEmpty();
        }

        public void checkProfile(StructureDefinition profile) {
            ProfileUsage profileUsage = this.profiles.get(profile);
            if (profileUsage == null) {
                throw new Error("Can't check profile that hasn't been added: " + profile.getUrl());
            }
            profileUsage.setChecked();
        }
    }

    private class ProfileUsage {
        private StructureDefinition profile;
        private boolean checked;

        public ProfileUsage(StructureDefinition profile) {
            this.profile = profile;
            this.checked = false;
        }

        public boolean isChecked() {
            return this.checked;
        }

        public void setChecked() {
            this.checked = true;
        }

        public StructureDefinition getProfile() {
            return this.profile;
        }
    }

    private class ValidatorHostServices
    implements FHIRPathEngine.IEvaluationContext {
        private ValidatorHostServices() {
        }

        public Base resolveConstant(Object appContext, String name, boolean beforeContext) throws PathEngineException {
            ValidatorHostContext c = (ValidatorHostContext)appContext;
            if (InstanceValidator.this.externalHostServices != null) {
                return InstanceValidator.this.externalHostServices.resolveConstant(c.appContext, name, beforeContext);
            }
            return null;
        }

        public TypeDetails resolveConstantType(Object appContext, String name) throws PathEngineException {
            ValidatorHostContext c = (ValidatorHostContext)appContext;
            if (InstanceValidator.this.externalHostServices != null) {
                return InstanceValidator.this.externalHostServices.resolveConstantType(c.appContext, name);
            }
            return null;
        }

        public boolean log(String argument, List<Base> focus) {
            if (InstanceValidator.this.externalHostServices != null) {
                return InstanceValidator.this.externalHostServices.log(argument, focus);
            }
            return false;
        }

        public FHIRPathEngine.IEvaluationContext.FunctionDetails resolveFunction(String functionName) {
            throw new Error("Not done yet (ValidatorHostServices.resolveFunction): " + functionName);
        }

        public TypeDetails checkFunction(Object appContext, String functionName, List<TypeDetails> parameters) throws PathEngineException {
            throw new Error("Not done yet (ValidatorHostServices.checkFunction)");
        }

        public List<Base> executeFunction(Object appContext, String functionName, List<List<Base>> parameters) {
            throw new Error("Not done yet (ValidatorHostServices.executeFunction)");
        }

        public Base resolveReference(Object appContext, String url) throws FHIRException {
            org.hl7.fhir.r5.elementmodel.Element bnd;
            Base res;
            ValidatorHostContext c = (ValidatorHostContext)appContext;
            if (c.appContext instanceof org.hl7.fhir.r5.elementmodel.Element && (res = this.resolveInBundle(url, bnd = (org.hl7.fhir.r5.elementmodel.Element)c.appContext)) != null) {
                return res;
            }
            Base res2 = this.resolveInBundle(url, c.resource);
            if (res2 != null) {
                return res2;
            }
            res2 = this.resolveInBundle(url, c.container);
            if (res2 != null) {
                return res2;
            }
            if (InstanceValidator.this.externalHostServices != null) {
                return InstanceValidator.this.externalHostServices.resolveReference(c.appContext, url);
            }
            if (InstanceValidator.this.fetcher != null) {
                try {
                    return InstanceValidator.this.fetcher.fetch(c.appContext, url);
                }
                catch (IOException e) {
                    throw new FHIRException((Throwable)e);
                }
            }
            throw new Error("Not done yet - resolve " + url + " locally (2)");
        }

        public Base resolveInBundle(String url, org.hl7.fhir.r5.elementmodel.Element bnd) {
            if (bnd == null) {
                return null;
            }
            if (bnd.fhirType().equals("Bundle")) {
                for (org.hl7.fhir.r5.elementmodel.Element be : bnd.getChildrenByName("entry")) {
                    org.hl7.fhir.r5.elementmodel.Element res = be.getNamedChild("resource");
                    if (res == null) continue;
                    String fullUrl = be.getChildValue("fullUrl");
                    String rt = res.fhirType();
                    String id = res.getChildValue("id");
                    if (url.equals(fullUrl)) {
                        return res;
                    }
                    if (!url.equals(rt + "/" + id)) continue;
                    return res;
                }
            }
            return null;
        }

        public boolean conformsToProfile(Object appContext, Base item, String url) throws FHIRException {
            InstanceValidator val = new InstanceValidator(InstanceValidator.this.context, this);
            ArrayList valerrors = new ArrayList();
            if (item instanceof Resource) {
                val.validate(appContext, valerrors, (Resource)item, url);
            } else if (item instanceof org.hl7.fhir.r5.elementmodel.Element) {
                val.validate(appContext, valerrors, (org.hl7.fhir.r5.elementmodel.Element)item, url);
            } else {
                throw new NotImplementedException("Not done yet (ValidatorHostServices.conformsToProfile), when item is element");
            }
            boolean ok = true;
            for (ValidationMessage v : valerrors) {
                ok = ok && !v.getLevel().isError();
            }
            return ok;
        }

        public ValueSet resolveValueSet(Object appContext, String url) {
            ValidatorHostContext c = (ValidatorHostContext)appContext;
            if (c.profile != null && url.startsWith("#")) {
                for (Resource r : c.profile.getContained()) {
                    if (!r.getId().equals(url.substring(1))) continue;
                    if (r instanceof ValueSet) {
                        return (ValueSet)r;
                    }
                    throw new FHIRException("Reference " + url + " refers to a " + r.fhirType() + " not a ValueSet");
                }
                return null;
            }
            return (ValueSet)InstanceValidator.this.context.fetchResource(ValueSet.class, url);
        }
    }

    public class ValidatorHostContext {
        private Object appContext;
        private org.hl7.fhir.r5.elementmodel.Element container;
        private org.hl7.fhir.r5.elementmodel.Element resource;
        private org.hl7.fhir.r5.elementmodel.Element rootResource;
        private StructureDefinition profile;

        public ValidatorHostContext(Object appContext) {
            this.appContext = appContext;
        }

        public ValidatorHostContext(Object appContext, org.hl7.fhir.r5.elementmodel.Element element) {
            this.appContext = appContext;
            this.resource = element;
            this.rootResource = element;
        }

        public ValidatorHostContext forContained(org.hl7.fhir.r5.elementmodel.Element element) {
            ValidatorHostContext res = new ValidatorHostContext(this.appContext);
            res.rootResource = this.resource;
            res.resource = element;
            res.container = this.resource;
            res.profile = this.profile;
            return res;
        }

        public ValidatorHostContext forProfile(StructureDefinition profile) {
            ValidatorHostContext res = new ValidatorHostContext(this.appContext);
            res.resource = this.resource;
            res.rootResource = this.rootResource;
            res.container = this.container;
            res.profile = profile;
            return res;
        }
    }
}

