/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.validation;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.hl7.fhir.convertors.VersionConvertorAdvisor40;
import org.hl7.fhir.convertors.VersionConvertor_10_40;
import org.hl7.fhir.convertors.VersionConvertor_14_40;
import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.elementmodel.Manager;
import org.hl7.fhir.r4.formats.FormatUtilities;
import org.hl7.fhir.r4.formats.ParserBase;
import org.hl7.fhir.r4.formats.XmlParser;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.FhirPublication;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.ValueSet;
import org.hl7.fhir.r4.utils.IResourceValidator;
import org.hl7.fhir.r4.validation.ValidationEngine;
import org.hl7.fhir.utilities.Utilities;

public class NativeHostServices {
    private ValidationEngine validator;
    private int validationCount = 0;
    private int resourceCount = 0;
    private int convertCount = 0;
    private int unConvertCount = 0;
    private int exceptionCount = 0;
    private String lastException = null;
    private Object lock = new Object();
    private VersionConvertorAdvisor40 conv_10_40_advisor = new NH_10_40_Advisor();

    public void init(String pack) throws Exception {
        this.validator = new ValidationEngine(pack);
        this.validator.getContext().setAllowLoadingDuplicates(true);
    }

    public void load(String pack) throws Exception {
        this.validator.loadIg(pack);
    }

    public void connectToTxSvc(String txServer, String log) throws Exception {
        this.validator.connectToTSServer(txServer, log, FhirPublication.R4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String status() {
        JsonObject json = new JsonObject();
        json.addProperty("custom-resource-count", (Number)this.resourceCount);
        this.validator.getContext().reportStatus(json);
        json.addProperty("validation-count", (Number)this.validationCount);
        json.addProperty("convert-count", (Number)this.convertCount);
        json.addProperty("unconvert-count", (Number)this.unConvertCount);
        json.addProperty("exception-count", (Number)this.exceptionCount);
        Object object = this.lock;
        synchronized (object) {
            json.addProperty("last-exception", this.lastException);
        }
        json.addProperty("mem-max", (Number)(Runtime.getRuntime().maxMemory() / 0x100000L));
        json.addProperty("mem-total", (Number)(Runtime.getRuntime().totalMemory() / 0x100000L));
        json.addProperty("mem-free", (Number)(Runtime.getRuntime().freeMemory() / 0x100000L));
        json.addProperty("mem-used", (Number)((Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L));
        Gson gson = new GsonBuilder().create();
        return gson.toJson((JsonElement)json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seeResource(byte[] source) throws Exception {
        try {
            org.hl7.fhir.r4.model.Resource r = new XmlParser().parse(source);
            this.validator.seeResource(r);
            ++this.resourceCount;
        }
        catch (Exception e) {
            ++this.exceptionCount;
            Object object = this.lock;
            synchronized (object) {
                this.lastException = e.getMessage();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropResource(String type, String id) throws Exception {
        try {
            this.validator.dropResource(type, id);
            --this.resourceCount;
        }
        catch (Exception e) {
            ++this.exceptionCount;
            Object object = this.lock;
            synchronized (object) {
                this.lastException = e.getMessage();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] validateResource(String location, byte[] source, String cntType, String options) throws Exception {
        try {
            IResourceValidator.IdStatus resourceIdRule = IResourceValidator.IdStatus.OPTIONAL;
            boolean anyExtensionsAllowed = true;
            IResourceValidator.BestPracticeWarningLevel bpWarnings = IResourceValidator.BestPracticeWarningLevel.Ignore;
            IResourceValidator.CheckDisplayOption displayOption = IResourceValidator.CheckDisplayOption.Ignore;
            for (String s : options.split(" ")) {
                if ("id-optional".equalsIgnoreCase(s)) {
                    resourceIdRule = IResourceValidator.IdStatus.OPTIONAL;
                    continue;
                }
                if ("id-required".equalsIgnoreCase(s)) {
                    resourceIdRule = IResourceValidator.IdStatus.REQUIRED;
                    continue;
                }
                if ("id-prohibited".equalsIgnoreCase(s)) {
                    resourceIdRule = IResourceValidator.IdStatus.PROHIBITED;
                    continue;
                }
                if ("any-extensions".equalsIgnoreCase(s)) {
                    anyExtensionsAllowed = true;
                    continue;
                }
                if ("strict-extensions".equalsIgnoreCase(s)) {
                    anyExtensionsAllowed = false;
                    continue;
                }
                if ("bp-ignore".equalsIgnoreCase(s)) {
                    bpWarnings = IResourceValidator.BestPracticeWarningLevel.Ignore;
                    continue;
                }
                if ("bp-hint".equalsIgnoreCase(s)) {
                    bpWarnings = IResourceValidator.BestPracticeWarningLevel.Hint;
                    continue;
                }
                if ("bp-warning".equalsIgnoreCase(s)) {
                    bpWarnings = IResourceValidator.BestPracticeWarningLevel.Warning;
                    continue;
                }
                if ("bp-error".equalsIgnoreCase(s)) {
                    bpWarnings = IResourceValidator.BestPracticeWarningLevel.Error;
                    continue;
                }
                if ("display-ignore".equalsIgnoreCase(s)) {
                    displayOption = IResourceValidator.CheckDisplayOption.Ignore;
                    continue;
                }
                if ("display-check".equalsIgnoreCase(s)) {
                    displayOption = IResourceValidator.CheckDisplayOption.Check;
                    continue;
                }
                if ("display-case-space".equalsIgnoreCase(s)) {
                    displayOption = IResourceValidator.CheckDisplayOption.CheckCaseAndSpace;
                    continue;
                }
                if ("display-case".equalsIgnoreCase(s)) {
                    displayOption = IResourceValidator.CheckDisplayOption.CheckCase;
                    continue;
                }
                if ("display-space".equalsIgnoreCase(s)) {
                    displayOption = IResourceValidator.CheckDisplayOption.CheckSpace;
                    continue;
                }
                if (Utilities.noString((String)s)) continue;
                throw new Exception("Unknown option " + s);
            }
            OperationOutcome oo = this.validator.validate(location, source, Manager.FhirFormat.valueOf((String)cntType), null, resourceIdRule, anyExtensionsAllowed, bpWarnings, displayOption);
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            new XmlParser().compose((OutputStream)bs, (org.hl7.fhir.r4.model.Resource)oo);
            ++this.validationCount;
            return bs.toByteArray();
        }
        catch (Exception e) {
            ++this.exceptionCount;
            Object object = this.lock;
            synchronized (object) {
                this.lastException = e.getMessage();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] convertResource(byte[] r, String fmt, String version) throws FHIRException, IOException {
        try {
            if ("3.0".equals(version) || "3.0.1".equals(version) || "r3".equals(version)) {
                org.hl7.fhir.dstu3.formats.ParserBase p3 = org.hl7.fhir.dstu3.formats.FormatUtilities.makeParser((String)fmt);
                Resource res3 = p3.parse(r);
                org.hl7.fhir.r4.model.Resource res4 = VersionConvertor_30_40.convertResource((Resource)res3, (boolean)false);
                ParserBase p4 = FormatUtilities.makeParser((String)fmt);
                ++this.convertCount;
                return p4.composeBytes(res4);
            }
            if ("1.0".equals(version) || "1.0.2".equals(version) || "r2".equals(version)) {
                org.hl7.fhir.dstu2.formats.ParserBase p2 = org.hl7.fhir.dstu2.formats.FormatUtilities.makeParser((String)fmt);
                org.hl7.fhir.dstu2.model.Resource res2 = p2.parse(r);
                VersionConvertor_10_40 conv = new VersionConvertor_10_40(this.conv_10_40_advisor);
                org.hl7.fhir.r4.model.Resource res4 = conv.convertResource(res2);
                ParserBase p4 = FormatUtilities.makeParser((String)fmt);
                ++this.convertCount;
                return p4.composeBytes(res4);
            }
            if ("1.4".equals(version) || "1.4.0".equals(version)) {
                org.hl7.fhir.dstu2016may.formats.ParserBase p2 = org.hl7.fhir.dstu2016may.formats.FormatUtilities.makeParser((String)fmt);
                org.hl7.fhir.dstu2016may.model.Resource res2 = p2.parse(r);
                org.hl7.fhir.r4.model.Resource res4 = VersionConvertor_14_40.convertResource((org.hl7.fhir.dstu2016may.model.Resource)res2);
                ParserBase p4 = FormatUtilities.makeParser((String)fmt);
                ++this.convertCount;
                return p4.composeBytes(res4);
            }
            throw new FHIRException("Unsupported version " + version);
        }
        catch (Exception e) {
            ++this.exceptionCount;
            Object object = this.lock;
            synchronized (object) {
                this.lastException = e.getMessage();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] unConvertResource(byte[] r, String fmt, String version) throws FHIRException, IOException {
        try {
            if ("3.0".equals(version) || "3.0.1".equals(version) || "r3".equals(version)) {
                ParserBase p4 = FormatUtilities.makeParser((String)fmt);
                org.hl7.fhir.r4.model.Resource res4 = p4.parse(r);
                Resource res3 = VersionConvertor_30_40.convertResource((org.hl7.fhir.r4.model.Resource)res4, (boolean)false);
                org.hl7.fhir.dstu3.formats.ParserBase p3 = org.hl7.fhir.dstu3.formats.FormatUtilities.makeParser((String)fmt);
                ++this.unConvertCount;
                return p3.composeBytes(res3);
            }
            if ("1.0".equals(version) || "1.0.2".equals(version) || "r2".equals(version)) {
                ParserBase p4 = FormatUtilities.makeParser((String)fmt);
                org.hl7.fhir.r4.model.Resource res4 = p4.parse(r);
                VersionConvertor_10_40 conv = new VersionConvertor_10_40(this.conv_10_40_advisor);
                org.hl7.fhir.dstu2.model.Resource res2 = conv.convertResource(res4);
                org.hl7.fhir.dstu2.formats.ParserBase p2 = org.hl7.fhir.dstu2.formats.FormatUtilities.makeParser((String)fmt);
                ++this.unConvertCount;
                return p2.composeBytes(res2);
            }
            if ("1.4".equals(version) || "1.4.0".equals(version)) {
                ParserBase p4 = FormatUtilities.makeParser((String)fmt);
                org.hl7.fhir.r4.model.Resource res4 = p4.parse(r);
                org.hl7.fhir.dstu2016may.model.Resource res2 = VersionConvertor_14_40.convertResource((org.hl7.fhir.r4.model.Resource)res4);
                org.hl7.fhir.dstu2016may.formats.ParserBase p2 = org.hl7.fhir.dstu2016may.formats.FormatUtilities.makeParser((String)fmt);
                ++this.unConvertCount;
                return p2.composeBytes(res2);
            }
            throw new FHIRException("Unsupported version " + version);
        }
        catch (Exception e) {
            ++this.exceptionCount;
            Object object = this.lock;
            synchronized (object) {
                this.lastException = e.getMessage();
            }
            throw e;
        }
    }

    private class NH_10_40_Advisor
    implements VersionConvertorAdvisor40 {
        private NH_10_40_Advisor() {
        }

        public boolean ignoreEntry(Bundle.BundleEntryComponent src) {
            return false;
        }

        public org.hl7.fhir.dstu2016may.model.Resource convertR2016May(org.hl7.fhir.r4.model.Resource resource) throws FHIRException {
            return null;
        }

        public org.hl7.fhir.dstu2.model.Resource convertR2(org.hl7.fhir.r4.model.Resource resource) throws FHIRException {
            return null;
        }

        public Resource convertR3(org.hl7.fhir.r4.model.Resource resource) throws FHIRException {
            return null;
        }

        public void handleCodeSystem(CodeSystem tgtcs, ValueSet source) throws FHIRException {
        }

        public CodeSystem getCodeSystem(ValueSet src) throws FHIRException {
            throw new FHIRException("Code systems cannot be handled at this time");
        }
    }
}

