/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.validation;

import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.elementmodel.Element;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Factory;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.Type;

public class EnableWhenEvaluator {
    public static final String LINKID_ELEMENT = "linkId";
    public static final String ITEM_ELEMENT = "item";
    public static final String ANSWER_ELEMENT = "answer";

    public boolean isQuestionEnabled(Questionnaire.QuestionnaireItemComponent qitem, QStack qstack) {
        if (!qitem.hasEnableWhen()) {
            return true;
        }
        List<EnableWhenResult> evaluationResults = qitem.getEnableWhen().stream().map(enableCondition -> this.evaluateCondition((Questionnaire.QuestionnaireItemEnableWhenComponent)enableCondition, qitem, qstack)).collect(Collectors.toList());
        return this.checkConditionResults(evaluationResults, qitem);
    }

    public boolean checkConditionResults(List<EnableWhenResult> evaluationResults, Questionnaire.QuestionnaireItemComponent questionnaireItem) {
        if (questionnaireItem.hasEnableBehavior() && questionnaireItem.getEnableBehavior() == Questionnaire.EnableWhenBehavior.ANY || evaluationResults.size() == 1) {
            return evaluationResults.stream().anyMatch(EnableWhenResult::isEnabled);
        }
        if (questionnaireItem.hasEnableBehavior() && questionnaireItem.getEnableBehavior() == Questionnaire.EnableWhenBehavior.ALL) {
            return evaluationResults.stream().allMatch(EnableWhenResult::isEnabled);
        }
        return true;
    }

    protected EnableWhenResult evaluateCondition(Questionnaire.QuestionnaireItemEnableWhenComponent enableCondition, Questionnaire.QuestionnaireItemComponent qitem, QStack qstack) {
        List<Element> answerItems = this.findQuestionAnswers(qstack, qitem, enableCondition);
        Questionnaire.QuestionnaireItemOperator operator = enableCondition.getOperator();
        if (operator == Questionnaire.QuestionnaireItemOperator.EXISTS) {
            Type answer2 = enableCondition.getAnswer();
            if (!(answer2 instanceof BooleanType)) {
                throw new UnprocessableEntityException("Exists-operator requires answerBoolean");
            }
            return new EnableWhenResult(((BooleanType)answer2).booleanValue() != answerItems.isEmpty(), enableCondition);
        }
        boolean result = answerItems.stream().anyMatch(answer -> this.evaluateAnswer((Element)answer, enableCondition.getAnswer(), enableCondition.getOperator()));
        return new EnableWhenResult(result, enableCondition);
    }

    private Type convertToType(Element element) throws FHIRException {
        if (element.fhirType().equals("BackboneElement")) {
            return null;
        }
        Type b = new Factory().create(element.fhirType());
        if (b instanceof PrimitiveType) {
            ((PrimitiveType)b).setValueAsString(element.primitiveValue());
        } else {
            for (Element child : element.getChildren()) {
                if (this.isExtension(child)) continue;
                b.setProperty(child.getName(), (Base)this.convertToType(child));
            }
        }
        return b;
    }

    private boolean isExtension(Element element) {
        return "Extension".equals(element.fhirType());
    }

    protected boolean evaluateAnswer(Element answer, Type expectedAnswer, Questionnaire.QuestionnaireItemOperator questionnaireItemOperator) {
        Type actualAnswer;
        if (this.isExtension(answer)) {
            return false;
        }
        try {
            actualAnswer = this.convertToType(answer);
            if (actualAnswer == null) {
                return false;
            }
        }
        catch (FHIRException e) {
            throw new UnprocessableEntityException("Unexpected answer type", (Throwable)e);
        }
        if (!actualAnswer.getClass().equals(expectedAnswer.getClass())) {
            throw new UnprocessableEntityException("Expected answer and actual answer have incompatible types");
        }
        if (expectedAnswer instanceof Coding) {
            return this.compareCodingAnswer((Coding)expectedAnswer, (Coding)actualAnswer, questionnaireItemOperator);
        }
        if (expectedAnswer instanceof PrimitiveType) {
            return this.comparePrimitiveAnswer((PrimitiveType)actualAnswer, (PrimitiveType)expectedAnswer, questionnaireItemOperator);
        }
        if (expectedAnswer instanceof Quantity) {
            return this.compareQuantityAnswer((Quantity)actualAnswer, (Quantity)expectedAnswer, questionnaireItemOperator);
        }
        throw new UnprocessableEntityException("Unimplemented answer type: " + expectedAnswer.getClass());
    }

    private boolean compareQuantityAnswer(Quantity actualAnswer, Quantity expectedAnswer, Questionnaire.QuestionnaireItemOperator questionnaireItemOperator) {
        return this.compareComparable(actualAnswer.getValue(), expectedAnswer.getValue(), questionnaireItemOperator);
    }

    private boolean comparePrimitiveAnswer(PrimitiveType<?> actualAnswer, PrimitiveType<?> expectedAnswer, Questionnaire.QuestionnaireItemOperator questionnaireItemOperator) {
        if (actualAnswer.getValue() instanceof Comparable) {
            return this.compareComparable((Comparable)actualAnswer.getValue(), (Comparable)expectedAnswer.getValue(), questionnaireItemOperator);
        }
        if (questionnaireItemOperator == Questionnaire.QuestionnaireItemOperator.EQUAL) {
            return actualAnswer.equalsShallow(expectedAnswer);
        }
        if (questionnaireItemOperator == Questionnaire.QuestionnaireItemOperator.NOT_EQUAL) {
            return !actualAnswer.equalsShallow(expectedAnswer);
        }
        throw new UnprocessableEntityException("Bad operator for PrimitiveType comparison");
    }

    private boolean compareComparable(Comparable actual, Comparable expected, Questionnaire.QuestionnaireItemOperator questionnaireItemOperator) {
        int result = actual.compareTo(expected);
        if (questionnaireItemOperator == Questionnaire.QuestionnaireItemOperator.EQUAL) {
            return result == 0;
        }
        if (questionnaireItemOperator == Questionnaire.QuestionnaireItemOperator.NOT_EQUAL) {
            return result != 0;
        }
        if (questionnaireItemOperator == Questionnaire.QuestionnaireItemOperator.GREATER_OR_EQUAL) {
            return result >= 0;
        }
        if (questionnaireItemOperator == Questionnaire.QuestionnaireItemOperator.LESS_OR_EQUAL) {
            return result <= 0;
        }
        if (questionnaireItemOperator == Questionnaire.QuestionnaireItemOperator.LESS_THAN) {
            return result < 0;
        }
        if (questionnaireItemOperator == Questionnaire.QuestionnaireItemOperator.GREATER_THAN) {
            return result > 0;
        }
        throw new UnprocessableEntityException("Bad operator for PrimitiveType comparison: " + questionnaireItemOperator.toCode());
    }

    private List<Element> findQuestionAnswers(QStack qstack, Questionnaire.QuestionnaireItemComponent sourceQ, Questionnaire.QuestionnaireItemEnableWhenComponent ew) {
        Questionnaire.QuestionnaireItemComponent targetQ = qstack.getQ().getQuestion(ew.getQuestion());
        if (targetQ != null) {
            Questionnaire.QuestionnaireItemComponent groupQ = qstack.getQ().getCommonGroup(sourceQ, targetQ);
            if (groupQ == null) {
                return this.findOnItem(qstack.getA(), ew.getQuestion());
            }
            for (int i = qstack.size() - 1; i >= 0; --i) {
                if (((QuestionnaireAnswerPair)qstack.get(i)).getQ() != groupQ) continue;
                return this.findOnItem(((QuestionnaireAnswerPair)qstack.get(i)).getA(), ew.getQuestion());
            }
        }
        return new ArrayList<Element>();
    }

    private List<Element> findOnItem(Element focus, String question) {
        ArrayList<Element> retVal = new ArrayList<Element>();
        List items = focus.getChildren(ITEM_ELEMENT);
        for (Element item : items) {
            if (this.hasLinkId(item, question)) {
                List<Element> answers = this.extractAnswer(item);
                retVal.addAll(answers);
            }
            retVal.addAll(this.findOnItem(item, question));
        }
        if (this.hasLinkId(focus, question)) {
            List<Element> answers = this.extractAnswer(focus);
            retVal.addAll(answers);
        }
        return retVal;
    }

    private List<Element> extractAnswer(Element item) {
        return item.getChildrenByName(ANSWER_ELEMENT).stream().flatMap(c -> c.getChildren().stream()).collect(Collectors.toList());
    }

    private boolean compareCodingAnswer(Coding expectedAnswer, Coding actualAnswer, Questionnaire.QuestionnaireItemOperator questionnaireItemOperator) {
        boolean result;
        boolean bl = result = this.compareSystems(expectedAnswer, actualAnswer) && this.compareCodes(expectedAnswer, actualAnswer);
        if (questionnaireItemOperator == Questionnaire.QuestionnaireItemOperator.EQUAL) {
            return result;
        }
        if (questionnaireItemOperator == Questionnaire.QuestionnaireItemOperator.NOT_EQUAL) {
            return !result;
        }
        throw new UnprocessableEntityException("Bad operator for Coding comparison");
    }

    private boolean compareCodes(Coding expectedCoding, Coding value) {
        if (expectedCoding.hasCode() != value.hasCode()) {
            return false;
        }
        if (expectedCoding.hasCode()) {
            return expectedCoding.getCode().equals(value.getCode());
        }
        return true;
    }

    private boolean compareSystems(Coding expectedCoding, Coding value) {
        if (expectedCoding.hasSystem() && !value.hasSystem()) {
            return false;
        }
        if (expectedCoding.hasSystem()) {
            return expectedCoding.getSystem().equals(value.getSystem());
        }
        return true;
    }

    private boolean hasLinkId(Element item, String linkId) {
        Element linkIdChild = item.getNamedChild(LINKID_ELEMENT);
        return linkIdChild != null && linkIdChild.getValue().equals(linkId);
    }

    public static class EnableWhenResult {
        private final boolean enabled;
        private final Questionnaire.QuestionnaireItemEnableWhenComponent enableWhenCondition;

        public EnableWhenResult(boolean enabled, Questionnaire.QuestionnaireItemEnableWhenComponent enableWhenCondition) {
            this.enabled = enabled;
            this.enableWhenCondition = enableWhenCondition;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public Questionnaire.QuestionnaireItemEnableWhenComponent getEnableWhenCondition() {
            return this.enableWhenCondition;
        }
    }

    public static class QStack
    extends ArrayList<QuestionnaireAnswerPair> {
        private static final long serialVersionUID = 1L;
        private Questionnaire q;
        private Element a;

        public QStack(Questionnaire q, Element a) {
            this.q = q;
            this.a = a;
        }

        public Questionnaire getQ() {
            return this.q;
        }

        public Element getA() {
            return this.a;
        }

        public QStack push(Questionnaire.QuestionnaireItemComponent q, Element a) {
            QStack self = new QStack(this.q, this.a);
            self.addAll(this);
            self.add(new QuestionnaireAnswerPair(q, a));
            return self;
        }
    }

    public static class QuestionnaireAnswerPair {
        private Questionnaire.QuestionnaireItemComponent q;
        private Element a;

        public QuestionnaireAnswerPair(Questionnaire.QuestionnaireItemComponent q, Element a) {
            this.q = q;
            this.a = a;
        }

        public Questionnaire.QuestionnaireItemComponent getQ() {
            return this.q;
        }

        public Element getA() {
            return this.a;
        }
    }
}

