/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.validation;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.CSFile;
import org.hl7.fhir.utilities.CSFileInputStream;
import org.hl7.fhir.utilities.Logger;
import org.hl7.fhir.utilities.SchemaInputSource;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.XsltUtilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlValidator {
    private Schema schema;
    private Map<String, byte[]> schemas;
    private Map<String, byte[]> transforms;
    private List<ValidationMessage> errors;
    private Logger logger;

    public XmlValidator(List<ValidationMessage> errors, Map<String, byte[]> schemas, Map<String, byte[]> transforms) throws FileNotFoundException, IOException, SAXException {
        this.errors = errors;
        this.schemas = schemas;
        this.transforms = transforms;
        this.load();
    }

    private void load() throws SAXException {
        int c = 0;
        for (String s : this.schemas.keySet()) {
            if (!s.endsWith(".xsd")) continue;
            ++c;
        }
        Source[] sources = new StreamSource[c];
        int i = 0;
        for (String s : this.schemas.keySet()) {
            if (!s.endsWith(".xsd")) continue;
            sources[i] = new StreamSource(new ByteArrayInputStream(this.schemas.get(s)), s);
            ++i;
        }
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        schemaFactory.setErrorHandler(new MyErrorHandler(this.errors, null));
        schemaFactory.setResourceResolver(new MyResourceResolver());
        this.schema = schemaFactory.newSchema(sources);
    }

    public XmlValidator(List<ValidationMessage> validationErrors, String srcDir, String xsltDir, String[] schemaNames) throws FileNotFoundException, IOException, SAXException {
        this.loadTransforms(xsltDir);
        this.loadSchemas(srcDir, schemaNames);
        this.load();
    }

    private void loadTransforms(String xsltDir) throws FileNotFoundException, IOException {
        HashMap<String, byte[]> res = new HashMap<String, byte[]>();
        for (String s : new File(xsltDir).list()) {
            if (!s.endsWith(".xslt")) continue;
            res.put(s, TextFile.fileToBytes((String)Utilities.path((String[])new String[]{xsltDir, s})));
        }
        this.transforms = res;
    }

    private void loadSchemas(String dir, String[] names) throws FileNotFoundException, IOException {
        HashMap<String, byte[]> res = new HashMap<String, byte[]>();
        for (String s : new File(dir).list()) {
            if (s.endsWith(".sch")) {
                res.put(s, TextFile.fileToBytes((String)Utilities.path((String[])new String[]{dir, s})));
            }
            boolean ok = false;
            for (String b : names) {
                ok = ok || b.equals(s);
            }
            if (!ok) continue;
            res.put(s, TextFile.fileToBytes((String)Utilities.path((String[])new String[]{dir, s})));
        }
        this.schemas = res;
    }

    public Element checkBySchema(String fileToCheck, boolean wantThrow) throws FileNotFoundException, SAXException, IOException, ParserConfigurationException, FHIRException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        factory.setSchema(this.schema);
        DocumentBuilder builder = factory.newDocumentBuilder();
        MyErrorHandler err = new MyErrorHandler(this.errors, fileToCheck);
        builder.setErrorHandler(err);
        CSFileInputStream f = new CSFileInputStream((File)new CSFile(fileToCheck));
        Document doc = builder.parse((InputStream)f);
        if (wantThrow && err.getErrors().size() > 0) {
            throw new FHIRException("File " + fileToCheck + " failed schema validation");
        }
        return doc.getDocumentElement();
    }

    public void checkBySchematron(String filename, String sch, boolean wantThrow) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, FHIRException {
        byte[] out;
        block5: {
            out = null;
            try {
                out = XsltUtilities.saxonTransform(this.transforms, (byte[])this.schemas.get(sch), (byte[])this.transforms.get("iso_svrl_for_xslt2.xsl"));
                out = XsltUtilities.saxonTransform(this.transforms, (byte[])TextFile.fileToBytes((String)filename), (byte[])out);
            }
            catch (Throwable e) {
                this.errors.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.STRUCTURE, -1, -1, filename + ":" + sch, e.getMessage(), ValidationMessage.IssueSeverity.ERROR));
                if (!wantThrow) break block5;
                throw new FHIRException("Error validating " + filename + " with schematrons", e);
            }
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(new ByteArrayInputStream(out));
        NodeList nl = doc.getDocumentElement().getElementsByTagNameNS("http://purl.oclc.org/dsdl/svrl", "failed-assert");
        if (nl.getLength() > 0) {
            this.logger.log("Schematron Validation Failed for " + filename, Logger.LogMessageType.Error);
            for (int i = 0; i < nl.getLength(); ++i) {
                Element e = (Element)nl.item(i);
                this.logger.log("  @" + e.getAttribute("location") + ": " + e.getTextContent(), Logger.LogMessageType.Error);
                this.errors.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.STRUCTURE, -1, -1, filename + ":" + e.getAttribute("location"), e.getTextContent(), ValidationMessage.IssueSeverity.ERROR));
            }
            if (wantThrow) {
                throw new FHIRException("Schematron Validation Failed for " + filename);
            }
        }
    }

    public class MyResourceResolver
    implements LSResourceResolver {
        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            try {
                if (!XmlValidator.this.schemas.containsKey(systemId)) {
                    return null;
                }
                return new SchemaInputSource((InputStream)new ByteArrayInputStream((byte[])XmlValidator.this.schemas.get(systemId)), publicId, systemId, namespaceURI);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public class MyErrorHandler
    implements ErrorHandler {
        private List<String> errors = new ArrayList<String>();
        private List<ValidationMessage> list;
        private String path;

        public MyErrorHandler(List<ValidationMessage> list, String path) {
            this.list = list;
            this.path = path;
        }

        @Override
        public void error(SAXParseException arg0) throws SAXException {
            if (this.list != null) {
                this.list.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.STRUCTURE, arg0.getLineNumber(), arg0.getColumnNumber(), this.path == null ? arg0.getSystemId() : this.path, arg0.getMessage(), ValidationMessage.IssueSeverity.ERROR));
            }
            if (XmlValidator.this.logger != null) {
                XmlValidator.this.logger.log("error: " + arg0.toString(), Logger.LogMessageType.Error);
            }
            this.errors.add(arg0.toString());
        }

        @Override
        public void fatalError(SAXParseException arg0) throws SAXException {
            if (this.list != null) {
                this.list.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.STRUCTURE, arg0.getLineNumber(), arg0.getColumnNumber(), this.path == null ? arg0.getSystemId() : this.path, arg0.getMessage(), ValidationMessage.IssueSeverity.FATAL));
            }
            if (XmlValidator.this.logger != null) {
                XmlValidator.this.logger.log("fatal error: " + arg0.toString(), Logger.LogMessageType.Error);
            }
        }

        @Override
        public void warning(SAXParseException arg0) throws SAXException {
            if (this.list != null) {
                this.list.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.STRUCTURE, arg0.getLineNumber(), arg0.getColumnNumber(), this.path == null ? arg0.getSystemId() : this.path, arg0.getMessage(), ValidationMessage.IssueSeverity.WARNING));
            }
        }

        public List<String> getErrors() {
            return this.errors;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }
    }
}

