/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.validation;

import java.awt.Desktop;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.hl7.fhir.r5.conformance.ProfileComparer;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.formats.XmlParser;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.FhirPublication;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.r5.validation.ValidationEngine;
import org.hl7.fhir.utilities.VersionUtil;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;

public class Validator {
    public static void main(String[] args) throws Exception {
        System.out.println("FHIR Validation tool " + VersionUtil.getVersionString());
        if (Validator.hasParam(args, "-tests")) {
            try {
                Class<?> clazz = Class.forName("org.hl7.fhir.validation.r5.tests.ValidationEngineTests");
                clazz.getMethod("execute", new Class[0]).invoke(clazz, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (args.length == 0 || Validator.hasParam(args, "help") || Validator.hasParam(args, "?") || Validator.hasParam(args, "-?") || Validator.hasParam(args, "/?")) {
            System.out.println("");
            System.out.println("The FHIR validation tool validates a FHIR resource or bundle.");
            System.out.println("The validation tool compares a resource against the base definitions and any");
            System.out.println("profiles declared in the resource (Resource.meta.profile) or specified on the ");
            System.out.println("command line");
            System.out.println("");
            System.out.println("The FHIR validation tool validates a FHIR resource or bundle.");
            System.out.println("Schema and schematron checking is performed, then some additional checks are performed. ");
            System.out.println("* XML & Json (FHIR versions 1.0, 1.4, 3.0, 3.4)");
            System.out.println("* Turtle (FHIR versions 3.0, 3.4)");
            System.out.println("");
            System.out.println("If requested, instances will also be verified against the appropriate schema");
            System.out.println("W3C XML Schema, JSON schema or ShEx, as appropriate");
            System.out.println("");
            System.out.println("Usage: org.hl7.fhir.r5.validation.ValidationEngine (parameters)");
            System.out.println("");
            System.out.println("The following parameters are supported:");
            System.out.println("[source]: a file, url, directory or pattern for resources to validate.  At");
            System.out.println("    least one source must be declared.  If there is more than one source or if");
            System.out.println("    the source is other than a single file or url and the output parameter is");
            System.out.println("    used, results will be provided as a Bundle.");
            System.out.println("    Patterns are limited to a directory followed by a filename with an embedded");
            System.out.println("    asterisk.  E.g. foo*-examples.xml or someresource.*, etc.");
            System.out.println("-version [ver]: The FHIR version to use. This can only appear once. ");
            System.out.println("    valid values 1.0 | 1.4 | 3.0 | " + "4.1.0".substring(0, 3) + " or 1.0.2 | 1.4.0 | 3.0.1 | " + "4.1.0");
            System.out.println("    Default value is  " + "4.1.0".substring(0, 3));
            System.out.println("-ig [package|file|folder|url]: an IG or profile definition to load. Can be ");
            System.out.println("     the URL of an implementation guide or a package ([id]-[ver]) for");
            System.out.println("     a built implementation guide or a local folder that contains a");
            System.out.println("     set of conformance resources.");
            System.out.println("     No default value. This parameter can appear any number of times");
            System.out.println("-tx [url]: the [base] url of a FHIR terminology service");
            System.out.println("     Default value is http://tx.fhir.org. This parameter can appear once");
            System.out.println("     To run without terminology value, specific n/a as the URL");
            System.out.println("-txLog [file]: Produce a log of the terminology server operations in [file]");
            System.out.println("     Default value is not to produce a log");
            System.out.println("-profile [url]: the canonical URL to validate against (same as if it was ");
            System.out.println("     specified in Resource.meta.profile). If no profile is specified, the ");
            System.out.println("     resource is validated against the base specification. This parameter ");
            System.out.println("     can appear any number of times.");
            System.out.println("     Note: the profile (and it's dependencies) have to be made available ");
            System.out.println("     through one of the -ig parameters. Note that package dependencies will ");
            System.out.println("     automatically be resolved");
            System.out.println("-questionnaire [file|url}: the location of a questionnaire. If provided, then the validator will validate");
            System.out.println("     any QuestionnaireResponse that claims to match the Questionnaire against it");
            System.out.println("     no default value. This parameter can appear any number of times");
            System.out.println("-output [file]: a filename for the results (OperationOutcome)");
            System.out.println("     Default: results are sent to the std out.");
            System.out.println("-debug");
            System.out.println("     Produce additional information about the loading/validation process");
            System.out.println("-native: use schema for validation as well");
            System.out.println("     * XML: w3c schema+schematron");
            System.out.println("     * JSON: json.schema");
            System.out.println("     * RDF: SHEX");
            System.out.println("     Default: false");
            System.out.println("-language: [lang]");
            System.out.println("     The language to use when validating coding displays - same value as for xml:lang");
            System.out.println("     Not used if the resource specifies language");
            System.out.println("     Default: no specified language");
            System.out.println("-strictExtensions: If present, treat extensions not defined within the specified FHIR version and any");
            System.out.println("     referenced implementation guides or profiles as errors.  (Default is to only raise information messages.)");
            System.out.println("-hintAboutNonMustSupport: If present, raise hints if the instance contains data elements that are not");
            System.out.println("     marked as mustSupport=true.  Useful to identify elements included that may be ignored by recipients");
            System.out.println("");
            System.out.println("Parameters can appear in any order");
            System.out.println("");
            System.out.println("Alternatively, you can use the validator to execute a transformation as described by a structure map.");
            System.out.println("To do this, you must provide some additional parameters:");
            System.out.println("");
            System.out.println(" -transform [map]");
            System.out.println("");
            System.out.println("* [map] the URI of the map that the transform starts with");
            System.out.println("");
            System.out.println("Any other dependency maps have to be loaded through an -ig reference ");
            System.out.println("");
            System.out.println("-transform uses the parameters -defn, -txserver, -ig (at least one with the map files), and -output");
            System.out.println("");
            System.out.println("Alternatively, you can use the validator to generate narrative for a resource.");
            System.out.println("To do this, you must provide a specific parameter:");
            System.out.println("");
            System.out.println(" -narrative");
            System.out.println("");
            System.out.println("-narrative requires the parameters -defn, -txserver, -source, and -output. ig and profile may be used");
            System.out.println("");
            System.out.println("Finally, you can use the validator to generate a snapshot for a profile.");
            System.out.println("To do this, you must provide a specific parameter:");
            System.out.println("");
            System.out.println(" -snapshot");
            System.out.println("");
            System.out.println("-snapshot requires the parameters -defn, -txserver, -source, and -output. ig may be used to provide necessary base profiles");
        } else if (Validator.hasParam(args, "-compare")) {
            String dest = Validator.getParam(args, "-dest");
            if (dest == null) {
                System.out.println("no -dest parameter provided");
            } else if (!new File(dest).isDirectory()) {
                System.out.println("Specified destination (-dest parameter) is not valid: \"" + dest + "\")");
            } else {
                String v = Validator.getParam(args, "-version");
                if (v == null) {
                    v = "4.1.0";
                } else if ("1.0".equals(v)) {
                    v = "1.0.2";
                } else if ("1.4".equals(v)) {
                    v = "1.4.0";
                } else if ("3.0".equals(v)) {
                    v = "3.0.1";
                } else if (v.startsWith("4.1.0")) {
                    v = "4.1.0";
                }
                String definitions = "hl7.fhir.core#" + v;
                System.out.println("Loading (v = " + v + ", tx server http://tx.fhir.org)");
                ValidationEngine validator = new ValidationEngine(definitions, "http://tx.fhir.org", null, FhirPublication.fromCode((String)v));
                for (int i = 0; i < args.length; ++i) {
                    String s;
                    if (!"-ig".equals(args[i])) continue;
                    if (i + 1 == args.length) {
                        throw new Error("Specified -ig without indicating ig file");
                    }
                    if ((s = args[++i]).startsWith("hl7.fhir.core-")) continue;
                    System.out.println("Load Package: " + s);
                    validator.loadIg(s);
                }
                ProfileComparer pc = new ProfileComparer((IWorkerContext)validator.getContext());
                String left = Validator.getParam(args, "-left");
                String right = Validator.getParam(args, "-right");
                StructureDefinition sdL = (StructureDefinition)validator.getContext().fetchResource(StructureDefinition.class, left);
                if (sdL == null) {
                    System.out.println("Unable to locate left profile " + left);
                } else {
                    StructureDefinition sdR = (StructureDefinition)validator.getContext().fetchResource(StructureDefinition.class, right);
                    if (sdR == null) {
                        System.out.println("Unable to locate right profile " + right);
                    } else {
                        System.out.println("Comparing " + left + " to " + right);
                        pc.compareProfiles(sdL, sdR);
                        System.out.println("Generating output...");
                        File htmlFile = new File(pc.generate(dest));
                        Desktop.getDesktop().browse(htmlFile.toURI());
                        System.out.println("Done");
                    }
                }
            }
        } else {
            System.out.print("Arguments:");
            for (String s : args) {
                System.out.print(s.contains(" ") ? " \"" + s + "\"" : " " + s);
            }
            System.out.println();
            Object definitions = "hl7.fhir.core#current";
            String map = null;
            ArrayList<Object> igs = new ArrayList<Object>();
            ArrayList<String> questionnaires = new ArrayList<String>();
            String txServer = "http://tx.fhir.org";
            boolean doNative = false;
            boolean anyExtensionsAllowed = true;
            boolean hintAboutNonMustSupport = false;
            ArrayList<String> profiles = new ArrayList<String>();
            EngineMode mode = EngineMode.VALIDATION;
            String output = null;
            ArrayList<String> sources = new ArrayList<String>();
            HashMap<String, String> locations = new HashMap<String, String>();
            String sv = null;
            String txLog = null;
            String mapLog = null;
            String lang = null;
            boolean doDebug = false;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-defn")) {
                    if (i + 1 == args.length) {
                        throw new Error("Specified -defn without indicating definition file");
                    }
                    definitions = args[++i];
                    continue;
                }
                if (args[i].equals("-version")) {
                    if ("1.0".equals(sv = args[++i])) {
                        sv = "1.0.2";
                    }
                    if ("1.4".equals(sv)) {
                        sv = "1.4.0";
                    }
                    if ("3.0".equals(sv)) {
                        sv = "3.0.1";
                    }
                    if ("4.0".equals(sv)) {
                        sv = "4.0.0";
                    }
                    if (sv.startsWith("4.1.0")) {
                        sv = "4.1.0";
                    }
                    definitions = "hl7.fhir.core#" + sv;
                    continue;
                }
                if (args[i].equals("-output")) {
                    if (i + 1 == args.length) {
                        throw new Error("Specified -output without indicating output file");
                    }
                    output = args[++i];
                    continue;
                }
                if (args[i].equals("-profile")) {
                    String p = null;
                    if (i + 1 == args.length) {
                        throw new Error("Specified -profile without indicating profile source");
                    }
                    p = args[++i];
                    profiles.add(p);
                    if (p == null || i + 1 >= args.length || !args[i + 1].equals("@")) continue;
                    if (++i + 1 == args.length) {
                        throw new Error("Specified -profile with @ without indicating profile location");
                    }
                    locations.put(p, args[++i]);
                    continue;
                }
                if (args[i].equals("-questionnaire")) {
                    if (i + 1 == args.length) {
                        throw new Error("Specified -questionnaire without indicating questionnaire file");
                    }
                    questionnaires.add(args[++i]);
                    continue;
                }
                if (args[i].equals("-native")) {
                    doNative = true;
                    continue;
                }
                if (args[i].equals("-debug")) {
                    doDebug = true;
                    continue;
                }
                if (args[i].equals("-strictExtensions")) {
                    anyExtensionsAllowed = false;
                    continue;
                }
                if (args[i].equals("-hintAboutNonMustSupport")) {
                    hintAboutNonMustSupport = true;
                    continue;
                }
                if (args[i].equals("-transform")) {
                    map = args[++i];
                    mode = EngineMode.TRANSFORM;
                    continue;
                }
                if (args[i].equals("-narrative")) {
                    mode = EngineMode.NARRATIVE;
                    continue;
                }
                if (args[i].equals("-snapshot")) {
                    mode = EngineMode.SNAPSHOT;
                    continue;
                }
                if (args[i].equals("-tx")) {
                    if (i + 1 == args.length) {
                        throw new Error("Specified -tx without indicating terminology server");
                    }
                    txServer = "n/a".equals(args[++i]) ? null : args[i];
                    continue;
                }
                if (args[i].equals("-txLog")) {
                    if (i + 1 == args.length) {
                        throw new Error("Specified -txLog without indicating file");
                    }
                    txLog = args[++i];
                    continue;
                }
                if (args[i].equals("-log")) {
                    if (i + 1 == args.length) {
                        throw new Error("Specified -log without indicating file");
                    }
                    mapLog = args[++i];
                    continue;
                }
                if (args[i].equals("-language")) {
                    if (i + 1 == args.length) {
                        throw new Error("Specified -language without indicating language");
                    }
                    lang = args[++i];
                    continue;
                }
                if (args[i].equals("-ig")) {
                    Object s;
                    if (i + 1 == args.length) {
                        throw new Error("Specified -ig without indicating ig file");
                    }
                    if (((String)(s = args[++i])).startsWith("hl7.fhir.core-")) {
                        definitions = s;
                        continue;
                    }
                    igs.add(s);
                    continue;
                }
                if (args[i].equals("-map")) {
                    if (map == null) {
                        if (i + 1 == args.length) {
                            throw new Error("Specified -map without indicating map file");
                        }
                        map = args[++i];
                        continue;
                    }
                    throw new Exception("Can only nominate a single -map parameter");
                }
                if (args[i].startsWith("-x")) {
                    ++i;
                    continue;
                }
                sources.add(args[i]);
            }
            if (sources.isEmpty()) {
                throw new Exception("Must provide at least one source file");
            }
            System.out.println("  .. connect to tx server @ " + txServer);
            System.out.println("  .. definitions from " + (String)definitions);
            ValidationEngine validator = new ValidationEngine((String)definitions, txServer, txLog, FhirPublication.fromCode((String)sv));
            validator.setDebug(doDebug);
            System.out.println("    (v" + validator.getContext().getVersion() + ")");
            if (sv != null) {
                validator.setVersion(sv);
            }
            for (String string : igs) {
                System.out.println("+  .. load IG from " + string);
                validator.loadIg(string);
            }
            validator.setQuestionnaires(questionnaires);
            validator.setNative(doNative);
            validator.setHintAboutNonMustSupport(hintAboutNonMustSupport);
            validator.setAnyExtensionsAllowed(anyExtensionsAllowed);
            validator.setLanguage(lang);
            Object x = output != null && output.endsWith(".json") ? new JsonParser() : new XmlParser();
            x.setOutputStyle(IParser.OutputStyle.PRETTY);
            if (mode == EngineMode.TRANSFORM) {
                if (sources.size() > 1) {
                    throw new Exception("Can only have one source when doing a transform (found " + sources + ")");
                }
                if (txServer == null) {
                    throw new Exception("Must provide a terminology server when doing a transform");
                }
                if (map == null) {
                    throw new Exception("Must provide a map when doing a transform");
                }
                try {
                    validator.setMapLog(mapLog);
                    Resource resource = validator.transform((String)sources.get(0), map);
                    System.out.println(" ...success");
                    if (output != null) {
                        FileOutputStream fileOutputStream = new FileOutputStream(output);
                        x.compose((OutputStream)fileOutputStream, resource);
                        fileOutputStream.close();
                    }
                }
                catch (Exception exception) {
                    System.out.println(" ...Failure: " + exception.getMessage());
                    exception.printStackTrace();
                }
            } else if (mode == EngineMode.NARRATIVE) {
                DomainResource domainResource = validator.generate((String)sources.get(0));
                System.out.println(" ...generated narrative successfully");
                if (output != null) {
                    Validator.handleOutput((Resource)domainResource, output);
                }
            } else if (mode == EngineMode.SNAPSHOT) {
                if (definitions == null) {
                    throw new Exception("Must provide a defn when generating a snapshot");
                }
                StructureDefinition structureDefinition = validator.snapshot((String)sources.get(0));
                System.out.println(" ...generated snapshot successfully");
                if (output != null) {
                    Validator.handleOutput((Resource)structureDefinition, output);
                }
            } else {
                if (definitions == null) {
                    throw new Exception("Must provide a defn when doing validation");
                }
                for (String string : profiles) {
                    if (validator.getContext().hasResource(StructureDefinition.class, string) || validator.getContext().hasResource(ImplementationGuide.class, string)) continue;
                    System.out.println("Fetch Profile from " + string);
                    validator.loadProfile(locations.getOrDefault(string, string));
                }
                if (profiles.size() > 0) {
                    System.out.println("  .. validate " + sources + " against " + ((Object)profiles).toString());
                } else {
                    System.out.println("  .. validate " + sources);
                }
                validator.prepare();
                Resource resource = validator.validate(sources, profiles);
                if (output == null) {
                    if (resource instanceof Bundle) {
                        for (Bundle.BundleEntryComponent e : ((Bundle)resource).getEntry()) {
                            Validator.displayOO((OperationOutcome)e.getResource());
                        }
                    } else {
                        Validator.displayOO((OperationOutcome)resource);
                    }
                } else {
                    FileOutputStream fileOutputStream = new FileOutputStream(output);
                    x.compose((OutputStream)fileOutputStream, resource);
                    fileOutputStream.close();
                }
            }
        }
    }

    private static String getGitBuild() {
        return "??";
    }

    private static void handleOutput(Resource r, String output) throws IOException {
        if (output.startsWith("http://") || output.startsWith("http://")) {
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            Validator.handleOutputToStream(r, output, bs);
            URL url = new URL(output);
            HttpURLConnection c = (HttpURLConnection)url.openConnection();
            c.setDoOutput(true);
            c.setDoInput(true);
            c.setRequestMethod("POST");
            c.setRequestProperty("Content-type", "application/fhir+xml");
            c.setRequestProperty("Accept", "application/fhir+xml");
            c.getOutputStream().write(bs.toByteArray());
            c.getOutputStream().close();
            if (c.getResponseCode() >= 300) {
                throw new IOException("Unable to PUT to " + output + ": " + c.getResponseMessage());
            }
        } else {
            FileOutputStream s = new FileOutputStream(output);
            Validator.handleOutputToStream(r, output, s);
        }
    }

    private static void handleOutputToStream(Resource r, String output, OutputStream s) throws IOException {
        if (output.endsWith(".html") || output.endsWith(".htm") && r instanceof DomainResource) {
            new XhtmlComposer(false, true).compose(s, ((DomainResource)r).getText().getDiv());
        } else if (output.endsWith(".json")) {
            new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(s, r);
        } else {
            new XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(s, r);
        }
        s.close();
    }

    private static void displayOO(OperationOutcome oo) {
        int error = 0;
        int warn = 0;
        int info = 0;
        String file = ToolingExtensions.readStringExtension((DomainResource)oo, (String)"http://hl7.org/fhir/StructureDefinition/operationoutcome-file");
        for (OperationOutcome.OperationOutcomeIssueComponent issue : oo.getIssue()) {
            if (issue.getSeverity() == OperationOutcome.IssueSeverity.FATAL || issue.getSeverity() == OperationOutcome.IssueSeverity.ERROR) {
                ++error;
                continue;
            }
            if (issue.getSeverity() == OperationOutcome.IssueSeverity.WARNING) {
                ++warn;
                continue;
            }
            ++info;
        }
        System.out.println((error == 0 ? "Success..." : "*FAILURE* ") + "validating " + file + ":  error:" + Integer.toString(error) + " warn:" + Integer.toString(warn) + " info:" + Integer.toString(info));
        for (OperationOutcome.OperationOutcomeIssueComponent issue : oo.getIssue()) {
            System.out.println(Validator.getIssueSummary(issue));
        }
        System.out.println();
    }

    private static String getIssueSummary(OperationOutcome.OperationOutcomeIssueComponent issue) {
        String loc = null;
        if (issue.hasExpression()) {
            int line = ToolingExtensions.readIntegerExtension((Element)issue, (String)"http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-line", (int)-1);
            int col = ToolingExtensions.readIntegerExtension((Element)issue, (String)"http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-col", (int)-1);
            loc = ((StringType)issue.getExpression().get(0)).asStringValue() + (line >= 0 && col >= 0 ? " (line " + Integer.toString(line) + ", col" + Integer.toString(col) + ")" : "");
        } else if (issue.hasLocation()) {
            loc = ((StringType)issue.getLocation().get(0)).asStringValue();
        } else {
            int line = ToolingExtensions.readIntegerExtension((Element)issue, (String)"http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-line", (int)-1);
            int col = ToolingExtensions.readIntegerExtension((Element)issue, (String)"http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-col", (int)-1);
            loc = line >= 0 && col >= 0 ? "line " + Integer.toString(line) + ", col" + Integer.toString(col) : "??";
        }
        return "  " + issue.getSeverity().getDisplay() + " @ " + loc + " : " + issue.getDetails().getText();
    }

    private static boolean hasParam(String[] args, String param) {
        for (String a : args) {
            if (!a.equals(param)) continue;
            return true;
        }
        return false;
    }

    private static String getParam(String[] args, String param) {
        for (int i = 0; i < args.length - 1; ++i) {
            if (!args[i].equals(param)) continue;
            return args[i + 1];
        }
        return null;
    }

    private static boolean hasTransformParam(String[] args) {
        for (String s : args) {
            if (!s.equals("-transform")) continue;
            return true;
        }
        return false;
    }

    public static enum EngineMode {
        VALIDATION,
        TRANSFORM,
        NARRATIVE,
        SNAPSHOT;

    }
}

