/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.common.hapi.validation.validator;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeCompositeDatatypeDefinition;
import ca.uhn.fhir.context.RuntimePrimitiveDatatypeDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.context.IWorkerContext;
import org.hl7.fhir.r4.hapi.ctx.HapiWorkerContext;
import org.hl7.fhir.r4.model.ExpressionNode;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.utils.FHIRPathEngine;

public class FHIRPathResourceGeneratorR4<T extends Resource> {
    private FhirContext ctx;
    private FHIRPathEngine engine;
    private Map<String, String> pathMapping = new HashMap<String, String>();
    private T resource = null;
    private String valueToSet = null;
    private Stack<GenerationTier> nodeStack = null;

    public FHIRPathResourceGeneratorR4() {
        this.ctx = FhirContext.forR4();
        this.engine = new FHIRPathEngine((IWorkerContext)new HapiWorkerContext(this.ctx, this.ctx.getValidationSupport()));
    }

    public FHIRPathResourceGeneratorR4(Map<String, String> mapping) {
        this();
        this.setMapping(mapping);
    }

    public void setMapping(Map<String, String> mapping) {
        this.pathMapping = mapping;
    }

    public T getResource() {
        return this.resource;
    }

    private void prepareInternalState(Class<T> resourceClass) {
        this.resource = (Resource)this.ctx.getResourceDefinition(resourceClass).newInstance();
    }

    public T generateResource(Class<T> resourceClass) {
        this.prepareInternalState(resourceClass);
        for (String fhirPath : this.sortedPaths()) {
            this.nodeStack = new Stack();
            this.nodeStack.push(new GenerationTier((BaseRuntimeElementDefinition<?>)this.ctx.getResourceDefinition(this.resource), (IBase)this.resource));
            this.valueToSet = this.pathMapping.get(fhirPath);
            block5: for (ExpressionNode pathNode = this.engine.parse(fhirPath); pathNode != null; pathNode = pathNode.getInner()) {
                switch (pathNode.getKind()) {
                    case Name: {
                        this.handleNameNode(pathNode);
                        continue block5;
                    }
                    case Function: {
                        this.handleFunctionNode(pathNode);
                        continue block5;
                    }
                }
            }
        }
        this.nodeStack = null;
        return this.resource;
    }

    private void handleNameNode(ExpressionNode fhirPath) {
        BaseRuntimeChildDefinition childDef = this.nodeStack.peek().nodeDefinition.getChildByName(fhirPath.getName());
        if (childDef == null) {
            return;
        }
        switch (childDef.getChildByName(fhirPath.getName()).getChildType()) {
            case COMPOSITE_DATATYPE: {
                this.handleCompositeNode(fhirPath);
                break;
            }
            case PRIMITIVE_DATATYPE: {
                this.handlePrimitiveNode(fhirPath);
                break;
            }
        }
    }

    private void handlePrimitiveNode(ExpressionNode fhirPath) {
        BaseRuntimeChildDefinition childDefinition = this.nodeStack.peek().nodeDefinition.getChildByName(fhirPath.getName());
        RuntimePrimitiveDatatypeDefinition primitiveTarget = (RuntimePrimitiveDatatypeDefinition)childDefinition.getChildByName(fhirPath.getName());
        for (IBase nodeElement : this.nodeStack.peek().nodes) {
            IPrimitiveType primitive = (IPrimitiveType)primitiveTarget.newInstance(childDefinition.getInstanceConstructorArguments());
            primitive.setValueAsString(this.valueToSet);
            childDefinition.getMutator().addValue(nodeElement, (IBase)primitive);
        }
    }

    private void handleCompositeNode(ExpressionNode fhirPath) {
        GenerationTier nextTier = new GenerationTier();
        nextTier.fhirPathName = fhirPath.getName();
        nextTier.childDefinition = this.nodeStack.peek().nodeDefinition.getChildByName(fhirPath.getName());
        nextTier.nodeDefinition = nextTier.childDefinition.getChildByName(nextTier.fhirPathName);
        RuntimeCompositeDatatypeDefinition compositeTarget = (RuntimeCompositeDatatypeDefinition)nextTier.nodeDefinition;
        for (IBase nodeElement : this.nodeStack.peek().nodes) {
            List containedNodes = nextTier.childDefinition.getAccessor().getValues(nodeElement);
            if (containedNodes.size() > 0) {
                nextTier.nodes.addAll(containedNodes);
                continue;
            }
            ICompositeType compositeNode = (ICompositeType)compositeTarget.newInstance(nextTier.childDefinition.getInstanceConstructorArguments());
            nextTier.childDefinition.getMutator().addValue(nodeElement, (IBase)compositeNode);
            nextTier.nodes.add((IBase)compositeNode);
        }
        this.nodeStack.push(nextTier);
    }

    private void handleFunctionNode(ExpressionNode fhirPath) {
        switch (fhirPath.getFunction()) {
            case Where: {
                this.handleWhereFunctionNode(fhirPath);
            }
        }
    }

    private void handleWhereFunctionNode(ExpressionNode fhirPath) {
        for (ExpressionNode param : fhirPath.getParameters()) {
            BaseRuntimeChildDefinition wherePropertyChild = this.nodeStack.peek().nodeDefinition.getChildByName(param.getName());
            BaseRuntimeElementDefinition wherePropertyDefinition = wherePropertyChild.getChildByName(param.getName());
            switch (wherePropertyDefinition.getChildType()) {
                case PRIMITIVE_DATATYPE: {
                    this.handleWhereFunctionParam(param);
                    break;
                }
            }
        }
    }

    private void handleWhereFunctionParam(ExpressionNode param) {
        BaseRuntimeChildDefinition wherePropertyChild = this.nodeStack.peek().nodeDefinition.getChildByName(param.getName());
        BaseRuntimeElementDefinition wherePropertyDefinition = wherePropertyChild.getChildByName(param.getName());
        String matchingValue = param.getOpNext().getConstant().toString();
        ArrayList<IBase> matchingNodes = new ArrayList<IBase>();
        ArrayList<Object> unlabeledNodes = new ArrayList<Object>();
        for (IBase node : this.nodeStack.peek().nodes) {
            List operationValues = wherePropertyChild.getAccessor().getValues(node);
            if (operationValues.size() == 0) {
                unlabeledNodes.add(node);
                continue;
            }
            for (IBase operationValue : operationValues) {
                IPrimitiveType primitive = (IPrimitiveType)operationValue;
                switch (param.getOperation()) {
                    case Equals: {
                        if (!primitive.getValueAsString().equals(matchingValue)) break;
                        matchingNodes.add(node);
                        break;
                    }
                    case NotEquals: {
                        if (primitive.getValueAsString().equals(matchingValue)) break;
                        matchingNodes.add(node);
                        break;
                    }
                }
            }
        }
        if (matchingNodes.size() == 0) {
            if (unlabeledNodes.size() == 0) {
                GenerationTier latestTier = this.nodeStack.pop();
                GenerationTier previousTier = this.nodeStack.peek();
                this.nodeStack.push(latestTier);
                RuntimeCompositeDatatypeDefinition compositeTarget = (RuntimeCompositeDatatypeDefinition)latestTier.nodeDefinition;
                ICompositeType iCompositeType = (ICompositeType)compositeTarget.newInstance(latestTier.childDefinition.getInstanceConstructorArguments());
                latestTier.childDefinition.getMutator().addValue(previousTier.nodes.get(0), (IBase)iCompositeType);
                unlabeledNodes.add(iCompositeType);
            }
            switch (param.getOperation()) {
                case Equals: {
                    RuntimePrimitiveDatatypeDefinition equalsPrimitive = (RuntimePrimitiveDatatypeDefinition)wherePropertyDefinition;
                    IPrimitiveType primitive = (IPrimitiveType)equalsPrimitive.newInstance(wherePropertyChild.getInstanceConstructorArguments());
                    primitive.setValueAsString(param.getOpNext().getConstant().toString());
                    for (IBase iBase : unlabeledNodes) {
                        wherePropertyChild.getMutator().addValue(iBase, (IBase)primitive);
                        matchingNodes.add(iBase);
                    }
                    break;
                }
                case NotEquals: {
                    matchingNodes.addAll(unlabeledNodes);
                    break;
                }
            }
        }
        this.nodeStack.peek().nodes = matchingNodes;
    }

    private List<String> sortedPaths() {
        ArrayList<String> whereEquals = new ArrayList<String>();
        ArrayList<String> whereUnequals = new ArrayList<String>();
        ArrayList<String> withoutWhere = new ArrayList<String>();
        for (String fhirPath : this.pathMapping.keySet()) {
            switch (this.getTypeOfFhirPath(fhirPath)) {
                case WHERE_EQUALS: {
                    whereEquals.add(fhirPath);
                    break;
                }
                case WHERE_UNEQUALS: {
                    whereUnequals.add(fhirPath);
                    break;
                }
                case WITHOUT_WHERE: {
                    withoutWhere.add(fhirPath);
                }
            }
        }
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(whereEquals);
        ret.addAll(whereUnequals);
        ret.addAll(withoutWhere);
        return ret;
    }

    private PathType getTypeOfFhirPath(String fhirPath) {
        for (ExpressionNode fhirPathExpression = this.engine.parse(fhirPath); fhirPathExpression != null; fhirPathExpression = fhirPathExpression.getInner()) {
            if (fhirPathExpression.getKind() != ExpressionNode.Kind.Function || fhirPathExpression.getFunction() != ExpressionNode.Function.Where) continue;
            for (ExpressionNode params : fhirPathExpression.getParameters()) {
                switch (params.getOperation()) {
                    case Equals: {
                        return PathType.WHERE_EQUALS;
                    }
                    case NotEquals: {
                        return PathType.WHERE_UNEQUALS;
                    }
                }
            }
        }
        return PathType.WITHOUT_WHERE;
    }

    public static enum PathType {
        WHERE_EQUALS,
        WHERE_UNEQUALS,
        WITHOUT_WHERE;

    }

    class GenerationTier {
        public BaseRuntimeElementDefinition<?> nodeDefinition = null;
        public List<IBase> nodes = new ArrayList<IBase>();
        public BaseRuntimeChildDefinition childDefinition = null;
        public String fhirPathName = null;

        public GenerationTier() {
        }

        public GenerationTier(BaseRuntimeElementDefinition<?> nodeDef, IBase firstNode) {
            this.nodeDefinition = nodeDef;
            this.nodes.add(firstNode);
        }
    }
}

