/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.common.hapi.validation.support;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.common.hapi.validation.support.BaseValidationSupportWrapper;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingValidationSupport
extends BaseValidationSupportWrapper
implements IValidationSupport {
    private static final Logger ourLog = LoggerFactory.getLogger(CachingValidationSupport.class);
    private final Cache<String, Object> myCache;
    private final Cache<String, Object> myValidateCodeCache = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).maximumSize(5000L).build();
    private final Cache<String, Object> myLookupCodeCache = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).maximumSize(5000L).build();

    public CachingValidationSupport(IValidationSupport theWrap) {
        super(theWrap.getFhirContext(), theWrap);
        this.myCache = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).maximumSize(5000L).build();
    }

    @Override
    public List<IBaseResource> fetchAllConformanceResources() {
        String key = "fetchAllConformanceResources";
        return this.loadFromCache(this.myCache, key, t -> super.fetchAllConformanceResources());
    }

    @Override
    public <T extends IBaseResource> List<T> fetchAllStructureDefinitions() {
        String key = "fetchAllStructureDefinitions";
        return this.loadFromCache(this.myCache, key, t -> super.fetchAllStructureDefinitions());
    }

    @Override
    public <T extends IBaseResource> T fetchResource(@Nullable Class<T> theClass, String theUri) {
        return (T)this.loadFromCache(this.myCache, "fetchResource " + theClass + " " + theUri, t -> super.fetchResource(theClass, theUri));
    }

    @Override
    public boolean isCodeSystemSupported(ValidationSupportContext theValidationSupportContext, String theSystem) {
        String key = "isCodeSystemSupported " + theSystem;
        Boolean retVal = this.loadFromCache(this.myCache, key, t -> super.isCodeSystemSupported(theValidationSupportContext, theSystem));
        assert (retVal != null);
        return retVal;
    }

    @Override
    public IValidationSupport.CodeValidationResult validateCode(ValidationSupportContext theValidationSupportContext, ConceptValidationOptions theOptions, String theCodeSystem, String theCode, String theDisplay, String theValueSetUrl) {
        String key = "validateCode " + theCodeSystem + " " + theCode + " " + (String)StringUtils.defaultIfBlank((CharSequence)theValueSetUrl, (CharSequence)"NO_VS");
        return this.loadFromCache(this.myValidateCodeCache, key, t -> super.validateCode(theValidationSupportContext, theOptions, theCodeSystem, theCode, theDisplay, theValueSetUrl));
    }

    @Override
    public IValidationSupport.LookupCodeResult lookupCode(ValidationSupportContext theValidationSupportContext, String theSystem, String theCode) {
        String key = "lookupCode " + theSystem + " " + theCode;
        return this.loadFromCache(this.myLookupCodeCache, key, t -> super.lookupCode(theValidationSupportContext, theSystem, theCode));
    }

    @Nullable
    private <T> T loadFromCache(Cache theCache, String theKey, Function<String, T> theLoader) {
        ourLog.trace("Fetching from cache: {}", (Object)theKey);
        Function<String, Optional> loaderWrapper = key -> Optional.ofNullable(theLoader.apply(theKey));
        Optional result = (Optional)theCache.get((Object)theKey, loaderWrapper);
        assert (result != null);
        return result.orElse(null);
    }

    @Override
    public IValidationSupport.CodeValidationResult validateCodeInValueSet(ValidationSupportContext theValidationSupportContext, ConceptValidationOptions theValidationOptions, String theCodeSystem, String theCode, String theDisplay, @Nonnull IBaseResource theValueSet) {
        BaseRuntimeChildDefinition urlChild = this.myCtx.getResourceDefinition(theValueSet).getChildByName("url");
        Optional<String> valueSetUrl = urlChild.getAccessor().getValues((IBase)theValueSet).stream().map(t -> ((IPrimitiveType)t).getValueAsString()).filter(t -> StringUtils.isNotBlank((CharSequence)t)).findFirst();
        if (valueSetUrl.isPresent()) {
            String key = "validateCodeInValueSet " + theValidationOptions.toString() + " " + StringUtils.defaultString((String)theCodeSystem, (String)"(null)") + " " + StringUtils.defaultString((String)theCode, (String)"(null)") + " " + StringUtils.defaultString((String)theDisplay, (String)"(null)") + " " + valueSetUrl.get();
            return this.loadFromCache(this.myValidateCodeCache, key, t -> super.validateCodeInValueSet(theValidationSupportContext, theValidationOptions, theCodeSystem, theCode, theDisplay, theValueSet));
        }
        return super.validateCodeInValueSet(theValidationSupportContext, theValidationOptions, theCodeSystem, theCode, theDisplay, theValueSet);
    }

    public void invalidateCaches() {
        this.myLookupCodeCache.invalidateAll();
        this.myCache.invalidateAll();
        this.myValidateCodeCache.invalidateAll();
    }
}

