/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.common.hapi.validation.validator;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.support.IValidationSupport;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.common.hapi.validation.support.BaseValidationSupportWrapper;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class HapiToHl7OrgDstu2ValidatingSupportWrapper
extends BaseValidationSupportWrapper
implements IValidationSupport {
    private final FhirContext myHapiCtx;

    public HapiToHl7OrgDstu2ValidatingSupportWrapper(IValidationSupport theWrap) {
        super(FhirContext.forDstu2Hl7Org(), theWrap);
        Validate.isTrue((theWrap.getFhirContext().getVersion().getVersion() == FhirVersionEnum.DSTU2 ? 1 : 0) != 0);
        this.myHapiCtx = theWrap.getFhirContext();
    }

    @Override
    public List<IBaseResource> fetchAllConformanceResources() {
        return super.fetchAllConformanceResources();
    }

    public List<IBaseResource> fetchAllStructureDefinitions() {
        return super.fetchAllStructureDefinitions().stream().map(t -> this.translate((IBaseResource)t)).collect(Collectors.toList());
    }

    @Override
    public <T extends IBaseResource> T fetchResource(Class<T> theClass, String theUri) {
        Class<? extends IBaseResource> type = this.translateTypeToHapi(theClass);
        IBaseResource output = super.fetchResource(type, theUri);
        return (T)((IBaseResource)theClass.cast(this.translate(output)));
    }

    @Override
    public IBaseResource fetchCodeSystem(String theSystem) {
        IBaseResource output = super.fetchCodeSystem(theSystem);
        return this.translate(output);
    }

    @Override
    public IBaseResource fetchValueSet(String theUri) {
        return this.translate(super.fetchValueSet(theUri));
    }

    @Override
    public IBaseResource fetchStructureDefinition(String theUrl) {
        return this.translate(super.fetchStructureDefinition(theUrl));
    }

    private Class<? extends IBaseResource> translateTypeToHapi(Class<? extends IBaseResource> theCodeSystemType) {
        String resName = this.getFhirContext().getResourceDefinition(theCodeSystemType).getName();
        return this.myHapiCtx.getResourceDefinition(resName).getImplementingClass();
    }

    private IBaseResource translate(IBaseResource theInput) {
        if (theInput == null) {
            return null;
        }
        String encoded = this.myHapiCtx.newJsonParser().encodeResourceToString(theInput);
        return this.getFhirContext().newJsonParser().parseResource(encoded);
    }
}

