/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.common.hapi.validation.validator;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.validation.IInstanceValidatorModule;
import ca.uhn.fhir.validation.IValidationContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.common.hapi.validation.validator.BaseValidatorBridge;
import org.hl7.fhir.common.hapi.validation.validator.HapiToHl7OrgDstu2ValidatingSupportWrapper;
import org.hl7.fhir.common.hapi.validation.validator.ValidatorWrapper;
import org.hl7.fhir.common.hapi.validation.validator.VersionSpecificWorkerContextWrapper;
import org.hl7.fhir.convertors.VersionConvertor_10_50;
import org.hl7.fhir.convertors.VersionConvertor_14_50;
import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.dstu2.model.ValueSet;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.PathEngineException;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.TypeDetails;
import org.hl7.fhir.r5.utils.FHIRPathEngine;
import org.hl7.fhir.r5.utils.IResourceValidator;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class FhirInstanceValidator
extends BaseValidatorBridge
implements IInstanceValidatorModule {
    private boolean myAnyExtensionsAllowed = true;
    private IResourceValidator.BestPracticeWarningLevel myBestPracticeWarningLevel;
    private IValidationSupport myValidationSupport;
    private boolean noTerminologyChecks = false;
    private volatile VersionSpecificWorkerContextWrapper myWrappedWorkerContext;
    private boolean errorForUnknownProfiles;
    private boolean assumeValidRestReferences;
    private List<String> myExtensionDomains = Collections.emptyList();
    private IResourceValidator.IValidatorResourceFetcher validatorResourceFetcher;
    private volatile FhirContext myDstu2Context;
    private volatile FhirContext myHl7OrgDstu2Context;

    public FhirInstanceValidator(FhirContext theContext) {
        this(theContext.getValidationSupport());
    }

    public FhirInstanceValidator(IValidationSupport theValidationSupport) {
        this.myValidationSupport = theValidationSupport.getFhirContext().getVersion().getVersion() == FhirVersionEnum.DSTU2 ? new HapiToHl7OrgDstu2ValidatingSupportWrapper(theValidationSupport) : theValidationSupport;
    }

    public FhirInstanceValidator setCustomExtensionDomains(List<String> extensionDomains) {
        this.myExtensionDomains = extensionDomains;
        return this;
    }

    public FhirInstanceValidator setCustomExtensionDomains(String ... extensionDomains) {
        this.myExtensionDomains = Arrays.asList(extensionDomains);
        return this;
    }

    public IResourceValidator.BestPracticeWarningLevel getBestPracticeWarningLevel() {
        return this.myBestPracticeWarningLevel;
    }

    public void setBestPracticeWarningLevel(IResourceValidator.BestPracticeWarningLevel theBestPracticeWarningLevel) {
        Validate.notNull((Object)theBestPracticeWarningLevel);
        this.myBestPracticeWarningLevel = theBestPracticeWarningLevel;
    }

    public IValidationSupport getValidationSupport() {
        return this.myValidationSupport;
    }

    public void setValidationSupport(IValidationSupport theValidationSupport) {
        this.myValidationSupport = theValidationSupport;
        this.myWrappedWorkerContext = null;
    }

    public boolean isAnyExtensionsAllowed() {
        return this.myAnyExtensionsAllowed;
    }

    public void setAnyExtensionsAllowed(boolean theAnyExtensionsAllowed) {
        this.myAnyExtensionsAllowed = theAnyExtensionsAllowed;
    }

    public boolean isErrorForUnknownProfiles() {
        return this.errorForUnknownProfiles;
    }

    public void setErrorForUnknownProfiles(boolean errorForUnknownProfiles) {
        this.errorForUnknownProfiles = errorForUnknownProfiles;
    }

    public boolean isNoTerminologyChecks() {
        return this.noTerminologyChecks;
    }

    public void setNoTerminologyChecks(boolean theNoTerminologyChecks) {
        this.noTerminologyChecks = theNoTerminologyChecks;
    }

    public List<String> getExtensionDomains() {
        return this.myExtensionDomains;
    }

    @Override
    protected List<ValidationMessage> validate(IValidationContext<?> theValidationCtx) {
        VersionSpecificWorkerContextWrapper wrappedWorkerContext = this.myWrappedWorkerContext;
        if (wrappedWorkerContext == null) {
            VersionSpecificWorkerContextWrapper.IVersionTypeConverter converter;
            switch (this.myValidationSupport.getFhirContext().getVersion().getVersion()) {
                case DSTU2: 
                case DSTU2_HL7ORG: {
                    converter = new VersionSpecificWorkerContextWrapper.IVersionTypeConverter(){

                        @Override
                        public org.hl7.fhir.r5.model.Resource toCanonical(IBaseResource theNonCanonical) {
                            ValueSet valueSet;
                            IBaseResource nonCanonical = theNonCanonical;
                            org.hl7.fhir.r5.model.Resource retVal = VersionConvertor_10_50.convertResource((org.hl7.fhir.dstu2.model.Resource)((org.hl7.fhir.dstu2.model.Resource)nonCanonical));
                            if (nonCanonical instanceof ValueSet && (valueSet = (ValueSet)nonCanonical).hasCodeSystem() && valueSet.getCodeSystem().hasSystem() && !valueSet.hasCompose()) {
                                org.hl7.fhir.r5.model.ValueSet valueSetR5 = (org.hl7.fhir.r5.model.ValueSet)retVal;
                                valueSetR5.getCompose().addInclude().setSystem(valueSet.getCodeSystem().getSystem());
                            }
                            return retVal;
                        }

                        @Override
                        public IBaseResource fromCanonical(org.hl7.fhir.r5.model.Resource theCanonical) {
                            org.hl7.fhir.dstu2.model.Resource canonical = VersionConvertor_10_50.convertResource((org.hl7.fhir.r5.model.Resource)theCanonical);
                            return canonical;
                        }
                    };
                    break;
                }
                case DSTU2_1: {
                    converter = new VersionSpecificWorkerContextWrapper.IVersionTypeConverter(){

                        @Override
                        public org.hl7.fhir.r5.model.Resource toCanonical(IBaseResource theNonCanonical) {
                            return VersionConvertor_14_50.convertResource((org.hl7.fhir.dstu2016may.model.Resource)((org.hl7.fhir.dstu2016may.model.Resource)theNonCanonical));
                        }

                        @Override
                        public IBaseResource fromCanonical(org.hl7.fhir.r5.model.Resource theCanonical) {
                            return VersionConvertor_14_50.convertResource((org.hl7.fhir.r5.model.Resource)theCanonical);
                        }
                    };
                    break;
                }
                case DSTU3: {
                    converter = new VersionSpecificWorkerContextWrapper.IVersionTypeConverter(){

                        @Override
                        public org.hl7.fhir.r5.model.Resource toCanonical(IBaseResource theNonCanonical) {
                            return VersionConvertor_30_50.convertResource((Resource)((Resource)theNonCanonical), (boolean)true);
                        }

                        @Override
                        public IBaseResource fromCanonical(org.hl7.fhir.r5.model.Resource theCanonical) {
                            return VersionConvertor_30_50.convertResource((org.hl7.fhir.r5.model.Resource)theCanonical, (boolean)true);
                        }
                    };
                    break;
                }
                case R4: {
                    converter = new VersionSpecificWorkerContextWrapper.IVersionTypeConverter(){

                        @Override
                        public org.hl7.fhir.r5.model.Resource toCanonical(IBaseResource theNonCanonical) {
                            return VersionConvertor_40_50.convertResource((org.hl7.fhir.r4.model.Resource)((org.hl7.fhir.r4.model.Resource)theNonCanonical));
                        }

                        @Override
                        public IBaseResource fromCanonical(org.hl7.fhir.r5.model.Resource theCanonical) {
                            return VersionConvertor_40_50.convertResource((org.hl7.fhir.r5.model.Resource)theCanonical);
                        }
                    };
                    break;
                }
                case R5: {
                    converter = VersionSpecificWorkerContextWrapper.IDENTITY_VERSION_TYPE_CONVERTER;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            wrappedWorkerContext = new VersionSpecificWorkerContextWrapper(this.myValidationSupport, converter);
        }
        this.myWrappedWorkerContext = wrappedWorkerContext;
        return new ValidatorWrapper().setAnyExtensionsAllowed(this.isAnyExtensionsAllowed()).setBestPracticeWarningLevel(this.getBestPracticeWarningLevel()).setErrorForUnknownProfiles(this.isErrorForUnknownProfiles()).setExtensionDomains(this.getExtensionDomains()).setNoTerminologyChecks(this.isNoTerminologyChecks()).setValidatorResourceFetcher(this.getValidatorResourceFetcher()).setAssumeValidRestReferences(this.isAssumeValidRestReferences()).validate(wrappedWorkerContext, theValidationCtx);
    }

    private FhirContext getDstu2Context() {
        FhirContext dstu2Context = this.myDstu2Context;
        if (dstu2Context == null) {
            this.myDstu2Context = dstu2Context = FhirContext.forDstu2();
        }
        return dstu2Context;
    }

    private FhirContext getHl7OrgDstu2Context() {
        FhirContext hl7OrgDstu2Context = this.myHl7OrgDstu2Context;
        if (hl7OrgDstu2Context == null) {
            this.myHl7OrgDstu2Context = hl7OrgDstu2Context = FhirContext.forDstu2Hl7Org();
        }
        return hl7OrgDstu2Context;
    }

    public IResourceValidator.IValidatorResourceFetcher getValidatorResourceFetcher() {
        return this.validatorResourceFetcher;
    }

    public void setValidatorResourceFetcher(IResourceValidator.IValidatorResourceFetcher validatorResourceFetcher) {
        this.validatorResourceFetcher = validatorResourceFetcher;
    }

    public boolean isAssumeValidRestReferences() {
        return this.assumeValidRestReferences;
    }

    public void setAssumeValidRestReferences(boolean assumeValidRestReferences) {
        this.assumeValidRestReferences = assumeValidRestReferences;
    }

    public void invalidateCaches() {
        this.myValidationSupport.invalidateCaches();
        this.myWrappedWorkerContext.invalidateCaches();
    }

    public static class NullEvaluationContext
    implements FHIRPathEngine.IEvaluationContext {
        public Base resolveConstant(Object appContext, String name, boolean beforeContext) throws PathEngineException {
            return null;
        }

        public TypeDetails resolveConstantType(Object appContext, String name) throws PathEngineException {
            return null;
        }

        public boolean log(String argument, List<Base> focus) {
            return false;
        }

        public FHIRPathEngine.IEvaluationContext.FunctionDetails resolveFunction(String functionName) {
            return null;
        }

        public TypeDetails checkFunction(Object appContext, String functionName, List<TypeDetails> parameters) throws PathEngineException {
            return null;
        }

        public List<Base> executeFunction(Object appContext, String functionName, List<List<Base>> parameters) {
            return null;
        }

        public Base resolveReference(Object appContext, String url, Base refContext) throws FHIRException {
            return null;
        }

        public boolean conformsToProfile(Object appContext, Base item, String url) throws FHIRException {
            return false;
        }

        public org.hl7.fhir.r5.model.ValueSet resolveValueSet(Object appContext, String url) {
            return null;
        }
    }
}

