/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.common.hapi.validation.support;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValueSetExpansionOptions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class ValidationSupportChain
implements IValidationSupport {
    private List<IValidationSupport> myChain = new ArrayList<IValidationSupport>();

    public ValidationSupportChain() {
    }

    public ValidationSupportChain(IValidationSupport ... theValidationSupportModules) {
        this();
        for (IValidationSupport next : theValidationSupportModules) {
            if (next == null) continue;
            this.addValidationSupport(next);
        }
    }

    public void invalidateCaches() {
        for (IValidationSupport next : this.myChain) {
            next.invalidateCaches();
        }
    }

    public boolean isValueSetSupported(IValidationSupport theRootValidationSupport, String theValueSetUrl) {
        for (IValidationSupport next : this.myChain) {
            boolean retVal = next.isValueSetSupported(theRootValidationSupport, theValueSetUrl);
            if (!retVal) continue;
            return true;
        }
        return false;
    }

    public IBaseResource generateSnapshot(IValidationSupport theRootValidationSupport, IBaseResource theInput, String theUrl, String theWebUrl, String theProfileName) {
        for (IValidationSupport next : this.myChain) {
            IBaseResource retVal = next.generateSnapshot(theRootValidationSupport, theInput, theUrl, theWebUrl, theProfileName);
            if (retVal == null) continue;
            return retVal;
        }
        return null;
    }

    public FhirContext getFhirContext() {
        if (this.myChain.size() == 0) {
            return null;
        }
        return this.myChain.get(0).getFhirContext();
    }

    public void addValidationSupport(IValidationSupport theValidationSupport) {
        int index = this.myChain.size();
        this.addValidationSupport(index, theValidationSupport);
    }

    public void addValidationSupport(int theIndex, IValidationSupport theValidationSupport) {
        Validate.notNull((Object)theValidationSupport, (String)"theValidationSupport must not be null", (Object[])new Object[0]);
        if (theValidationSupport.getFhirContext() == null) {
            String message = "Can not add validation support: getFhirContext() returns null";
            throw new ConfigurationException(message);
        }
        FhirContext existingFhirContext = this.getFhirContext();
        if (existingFhirContext != null) {
            FhirVersionEnum newVersion = theValidationSupport.getFhirContext().getVersion().getVersion();
            FhirVersionEnum existingVersion = existingFhirContext.getVersion().getVersion();
            if (!existingVersion.equals((Object)newVersion)) {
                String message = "Trying to add validation support of version " + newVersion + " to chain with " + this.myChain.size() + " entries of version " + existingVersion;
                throw new ConfigurationException(message);
            }
        }
        this.myChain.add(theIndex, theValidationSupport);
    }

    public IValidationSupport.ValueSetExpansionOutcome expandValueSet(IValidationSupport theRootValidationSupport, ValueSetExpansionOptions theExpansionOptions, IBaseResource theValueSetToExpand) {
        for (IValidationSupport next : this.myChain) {
            IValidationSupport.ValueSetExpansionOutcome expanded = next.expandValueSet(theRootValidationSupport, null, theValueSetToExpand);
            if (expanded == null) continue;
            return expanded;
        }
        return null;
    }

    public List<IBaseResource> fetchAllConformanceResources() {
        ArrayList<IBaseResource> retVal = new ArrayList<IBaseResource>();
        for (IValidationSupport next : this.myChain) {
            List candidates = next.fetchAllConformanceResources();
            if (candidates == null) continue;
            retVal.addAll(candidates);
        }
        return retVal;
    }

    public List<IBaseResource> fetchAllStructureDefinitions() {
        ArrayList<IBaseResource> retVal = new ArrayList<IBaseResource>();
        HashSet<String> urls = new HashSet<String>();
        for (IValidationSupport nextSupport : this.myChain) {
            List allStructureDefinitions = nextSupport.fetchAllStructureDefinitions();
            if (allStructureDefinitions == null) continue;
            for (IBaseResource next : allStructureDefinitions) {
                IPrimitiveType urlType = (IPrimitiveType)this.getFhirContext().newTerser().getSingleValueOrNull((IBase)next, "url", IPrimitiveType.class);
                if (urlType != null && !StringUtils.isBlank((CharSequence)urlType.getValueAsString()) && !urls.add(urlType.getValueAsString())) continue;
                retVal.add(next);
            }
        }
        return retVal;
    }

    public IBaseResource fetchCodeSystem(String theSystem) {
        for (IValidationSupport next : this.myChain) {
            IBaseResource retVal = next.fetchCodeSystem(theSystem);
            if (retVal == null) continue;
            return retVal;
        }
        return null;
    }

    public IBaseResource fetchValueSet(String theUrl) {
        for (IValidationSupport next : this.myChain) {
            IBaseResource retVal = next.fetchValueSet(theUrl);
            if (retVal == null) continue;
            return retVal;
        }
        return null;
    }

    public <T extends IBaseResource> T fetchResource(Class<T> theClass, String theUri) {
        for (IValidationSupport next : this.myChain) {
            IBaseResource retVal = next.fetchResource(theClass, theUri);
            if (retVal == null) continue;
            return (T)retVal;
        }
        return null;
    }

    public IBaseResource fetchStructureDefinition(String theUrl) {
        for (IValidationSupport next : this.myChain) {
            IBaseResource retVal = next.fetchStructureDefinition(theUrl);
            if (retVal == null) continue;
            return retVal;
        }
        return null;
    }

    public boolean isCodeSystemSupported(IValidationSupport theRootValidationSupport, String theSystem) {
        for (IValidationSupport next : this.myChain) {
            if (!next.isCodeSystemSupported(theRootValidationSupport, theSystem)) continue;
            return true;
        }
        return false;
    }

    public IValidationSupport.CodeValidationResult validateCode(IValidationSupport theRootValidationSupport, ConceptValidationOptions theOptions, String theCodeSystem, String theCode, String theDisplay, String theValueSetUrl) {
        for (IValidationSupport next : this.myChain) {
            IValidationSupport.CodeValidationResult retVal;
            if (!theOptions.isInferSystem() && (theCodeSystem == null || !next.isCodeSystemSupported(theRootValidationSupport, theCodeSystem)) || (retVal = next.validateCode(theRootValidationSupport, theOptions, theCodeSystem, theCode, theDisplay, theValueSetUrl)) == null) continue;
            return retVal;
        }
        return null;
    }

    public IValidationSupport.CodeValidationResult validateCodeInValueSet(IValidationSupport theRootValidationSupport, ConceptValidationOptions theOptions, String theCodeSystem, String theCode, String theDisplay, @Nonnull IBaseResource theValueSet) {
        for (IValidationSupport next : this.myChain) {
            IValidationSupport.CodeValidationResult retVal = next.validateCodeInValueSet(theRootValidationSupport, theOptions, theCodeSystem, theCode, theDisplay, theValueSet);
            if (retVal == null) continue;
            return retVal;
        }
        return null;
    }

    public IValidationSupport.LookupCodeResult lookupCode(IValidationSupport theRootValidationSupport, String theSystem, String theCode) {
        for (IValidationSupport next : this.myChain) {
            if (!next.isCodeSystemSupported(theRootValidationSupport, theSystem)) continue;
            return next.lookupCode(theRootValidationSupport, theSystem, theCode);
        }
        return null;
    }
}

