/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.common.hapi.validation.support;

import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeCompositeDatatypeDefinition;
import ca.uhn.fhir.context.RuntimePrimitiveDatatypeDefinition;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import java.util.ArrayList;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.common.hapi.validation.validator.ProfileKnowledgeWorkerR5;
import org.hl7.fhir.dstu3.conformance.ProfileUtilities;
import org.hl7.fhir.dstu3.context.IWorkerContext;
import org.hl7.fhir.dstu3.hapi.ctx.HapiWorkerContext;
import org.hl7.fhir.dstu3.model.ElementDefinition;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.conformance.ProfileUtilities;
import org.hl7.fhir.r4.model.ElementDefinition;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r5.conformance.ProfileUtilities;

public class SnapshotGeneratingValidationSupport
implements IValidationSupport {
    private final FhirContext myCtx;

    public SnapshotGeneratingValidationSupport(FhirContext theCtx) {
        Validate.notNull((Object)theCtx);
        this.myCtx = theCtx;
    }

    public IBaseResource generateSnapshot(IValidationSupport theValidationSupport, IBaseResource theInput, String theUrl, String theWebUrl, String theProfileName) {
        assert (theInput.getStructureFhirVersionEnum() == this.myCtx.getVersion().getVersion());
        switch (theInput.getStructureFhirVersionEnum()) {
            case DSTU3: {
                org.hl7.fhir.dstu3.model.StructureDefinition input = (org.hl7.fhir.dstu3.model.StructureDefinition)theInput;
                HapiWorkerContext context = new HapiWorkerContext(this.myCtx, theValidationSupport);
                MyProfileKnowledgeWorkerDstu3 profileKnowledgeProvider = new MyProfileKnowledgeWorkerDstu3();
                ArrayList messages = new ArrayList();
                org.hl7.fhir.dstu3.model.StructureDefinition base = (org.hl7.fhir.dstu3.model.StructureDefinition)theValidationSupport.fetchStructureDefinition(input.getBaseDefinition());
                if (base == null) {
                    throw new PreconditionFailedException("Unknown base definition: " + input.getBaseDefinition());
                }
                new org.hl7.fhir.dstu3.conformance.ProfileUtilities((IWorkerContext)context, messages, (ProfileUtilities.ProfileKnowledgeProvider)profileKnowledgeProvider).generateSnapshot(base, input, theUrl, theProfileName);
                break;
            }
            case R4: {
                StructureDefinition input = (StructureDefinition)theInput;
                org.hl7.fhir.r4.hapi.ctx.HapiWorkerContext context = new org.hl7.fhir.r4.hapi.ctx.HapiWorkerContext(this.myCtx, theValidationSupport);
                MyProfileKnowledgeWorkerR4 profileKnowledgeProvider = new MyProfileKnowledgeWorkerR4();
                ArrayList messages = new ArrayList();
                StructureDefinition base = (StructureDefinition)theValidationSupport.fetchStructureDefinition(input.getBaseDefinition());
                if (base == null) {
                    throw new PreconditionFailedException("Unknown base definition: " + input.getBaseDefinition());
                }
                new ProfileUtilities((org.hl7.fhir.r4.context.IWorkerContext)context, messages, (ProfileUtilities.ProfileKnowledgeProvider)profileKnowledgeProvider).generateSnapshot(base, input, theUrl, theWebUrl, theProfileName);
                break;
            }
            case R5: {
                org.hl7.fhir.r5.model.StructureDefinition input = (org.hl7.fhir.r5.model.StructureDefinition)theInput;
                org.hl7.fhir.r5.hapi.ctx.HapiWorkerContext context = new org.hl7.fhir.r5.hapi.ctx.HapiWorkerContext(this.myCtx, theValidationSupport);
                ProfileKnowledgeWorkerR5 profileKnowledgeProvider = new ProfileKnowledgeWorkerR5(this.myCtx);
                ArrayList messages = new ArrayList();
                org.hl7.fhir.r5.model.StructureDefinition base = (org.hl7.fhir.r5.model.StructureDefinition)theValidationSupport.fetchStructureDefinition(input.getBaseDefinition());
                if (base == null) {
                    throw new PreconditionFailedException("Unknown base definition: " + input.getBaseDefinition());
                }
                new org.hl7.fhir.r5.conformance.ProfileUtilities((org.hl7.fhir.r5.context.IWorkerContext)context, messages, (ProfileUtilities.ProfileKnowledgeProvider)profileKnowledgeProvider).generateSnapshot(base, input, theUrl, theWebUrl, theProfileName);
                break;
            }
            default: {
                throw new IllegalStateException("Can not generate snapshot for version: " + theInput.getStructureFhirVersionEnum());
            }
        }
        return theInput;
    }

    public FhirContext getFhirContext() {
        return this.myCtx;
    }

    private class MyProfileKnowledgeWorkerDstu3
    implements ProfileUtilities.ProfileKnowledgeProvider {
        private MyProfileKnowledgeWorkerDstu3() {
        }

        public boolean isDatatype(String typeSimple) {
            BaseRuntimeElementDefinition def = SnapshotGeneratingValidationSupport.this.myCtx.getElementDefinition(typeSimple);
            Validate.notNull((Object)typeSimple);
            return def instanceof RuntimePrimitiveDatatypeDefinition || def instanceof RuntimeCompositeDatatypeDefinition;
        }

        public boolean isResource(String typeSimple) {
            BaseRuntimeElementDefinition def = SnapshotGeneratingValidationSupport.this.myCtx.getElementDefinition(typeSimple);
            Validate.notNull((Object)typeSimple);
            return def instanceof RuntimeResourceDefinition;
        }

        public boolean hasLinkFor(String typeSimple) {
            return false;
        }

        public String getLinkFor(String corePath, String typeSimple) {
            return null;
        }

        public ProfileUtilities.ProfileKnowledgeProvider.BindingResolution resolveBinding(org.hl7.fhir.dstu3.model.StructureDefinition theStructureDefinition, ElementDefinition.ElementDefinitionBindingComponent theElementDefinitionBindingComponent, String theS) {
            return null;
        }

        public String getLinkForProfile(org.hl7.fhir.dstu3.model.StructureDefinition theStructureDefinition, String theS) {
            return null;
        }

        public boolean prependLinks() {
            return false;
        }
    }

    private class MyProfileKnowledgeWorkerR4
    implements ProfileUtilities.ProfileKnowledgeProvider {
        private MyProfileKnowledgeWorkerR4() {
        }

        public boolean isDatatype(String typeSimple) {
            BaseRuntimeElementDefinition def = SnapshotGeneratingValidationSupport.this.myCtx.getElementDefinition(typeSimple);
            Validate.notNull((Object)typeSimple);
            return def instanceof RuntimePrimitiveDatatypeDefinition || def instanceof RuntimeCompositeDatatypeDefinition;
        }

        public boolean isResource(String typeSimple) {
            BaseRuntimeElementDefinition def = SnapshotGeneratingValidationSupport.this.myCtx.getElementDefinition(typeSimple);
            Validate.notNull((Object)typeSimple);
            return def instanceof RuntimeResourceDefinition;
        }

        public boolean hasLinkFor(String typeSimple) {
            return false;
        }

        public String getLinkFor(String corePath, String typeSimple) {
            return null;
        }

        public ProfileUtilities.ProfileKnowledgeProvider.BindingResolution resolveBinding(StructureDefinition def, ElementDefinition.ElementDefinitionBindingComponent binding, String path) throws FHIRException {
            return null;
        }

        public ProfileUtilities.ProfileKnowledgeProvider.BindingResolution resolveBinding(StructureDefinition def, String url, String path) throws FHIRException {
            return null;
        }

        public String getLinkForProfile(StructureDefinition profile, String url) {
            return null;
        }

        public boolean prependLinks() {
            return false;
        }

        public String getLinkForUrl(String corePath, String url) {
            throw new UnsupportedOperationException();
        }
    }
}

