/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.common.hapi.validation.support;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValueSetExpansionOptions;
import ca.uhn.fhir.util.VersionIndependentConcept;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.convertors.conv10_50.ValueSet10_50;
import org.hl7.fhir.convertors.conv30_50.CodeSystem30_50;
import org.hl7.fhir.convertors.conv30_50.ValueSet30_50;
import org.hl7.fhir.convertors.conv40_50.CodeSystem40_50;
import org.hl7.fhir.convertors.conv40_50.ValueSet40_50;
import org.hl7.fhir.dstu2.model.ValueSet;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.ValueSet;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class InMemoryTerminologyServerValidationSupport
implements IValidationSupport {
    private final FhirContext myCtx;

    public InMemoryTerminologyServerValidationSupport(FhirContext theCtx) {
        Validate.notNull((Object)theCtx, (String)"theCtx must not be null", (Object[])new Object[0]);
        this.myCtx = theCtx;
    }

    public FhirContext getFhirContext() {
        return this.myCtx;
    }

    public IValidationSupport.ValueSetExpansionOutcome expandValueSet(IValidationSupport theRootValidationSupport, ValueSetExpansionOptions theExpansionOptions, IBaseResource theValueSetToExpand) {
        org.hl7.fhir.r5.model.ValueSet expansion;
        org.hl7.fhir.r5.model.ValueSet expansionR5 = this.expandValueSetToCanonical(theRootValidationSupport, theValueSetToExpand, null, null);
        if (expansionR5 == null) {
            return null;
        }
        switch (this.myCtx.getVersion().getVersion()) {
            case DSTU2_HL7ORG: {
                expansion = ValueSet10_50.convertValueSet((org.hl7.fhir.r5.model.ValueSet)expansionR5);
                break;
            }
            case DSTU3: {
                expansion = ValueSet30_50.convertValueSet((org.hl7.fhir.r5.model.ValueSet)expansionR5);
                break;
            }
            case R4: {
                expansion = ValueSet40_50.convertValueSet((org.hl7.fhir.r5.model.ValueSet)expansionR5);
                break;
            }
            case R5: {
                expansion = expansionR5;
                break;
            }
            default: {
                throw new IllegalArgumentException("Can not handle version: " + this.myCtx.getVersion().getVersion());
            }
        }
        return new IValidationSupport.ValueSetExpansionOutcome((IBaseResource)expansion, null);
    }

    private org.hl7.fhir.r5.model.ValueSet expandValueSetToCanonical(IValidationSupport theRootValidationSupport, IBaseResource theValueSetToExpand, @Nullable String theWantSystem, @Nullable String theWantCode) {
        org.hl7.fhir.r5.model.ValueSet expansionR5;
        switch (this.myCtx.getVersion().getVersion()) {
            case DSTU2_HL7ORG: 
            case DSTU2: {
                expansionR5 = this.expandValueSetDstu2Hl7Org(theRootValidationSupport, (org.hl7.fhir.dstu2.model.ValueSet)theValueSetToExpand, theWantSystem, theWantCode);
                break;
            }
            case DSTU3: {
                expansionR5 = this.expandValueSetDstu3(theRootValidationSupport, (ValueSet)theValueSetToExpand, theWantSystem, theWantCode);
                break;
            }
            case R4: {
                expansionR5 = this.expandValueSetR4(theRootValidationSupport, (org.hl7.fhir.r4.model.ValueSet)theValueSetToExpand, theWantSystem, theWantCode);
                break;
            }
            case R5: {
                expansionR5 = this.expandValueSetR5(theRootValidationSupport, (org.hl7.fhir.r5.model.ValueSet)theValueSetToExpand);
                break;
            }
            default: {
                throw new IllegalArgumentException("Can not handle version: " + this.myCtx.getVersion().getVersion());
            }
        }
        if (expansionR5 == null) {
            return null;
        }
        return expansionR5;
    }

    public IValidationSupport.CodeValidationResult validateCodeInValueSet(IValidationSupport theRootValidationSupport, ConceptValidationOptions theOptions, String theCodeSystem, String theCode, String theDisplay, @Nonnull IBaseResource theValueSet) {
        org.hl7.fhir.r5.model.ValueSet expansion = this.expandValueSetToCanonical(theRootValidationSupport, theValueSet, theCodeSystem, theCode);
        if (expansion == null) {
            return null;
        }
        return this.validateCodeInExpandedValueSet(theRootValidationSupport, theOptions, theCodeSystem, theCode, (IBaseResource)expansion);
    }

    public IValidationSupport.CodeValidationResult validateCode(IValidationSupport theRootValidationSupport, ConceptValidationOptions theOptions, String theCodeSystem, String theCode, String theDisplay, String theValueSetUrl) {
        IValidationSupport.ValueSetExpansionOutcome valueSetExpansionOutcome;
        IBaseResource vs;
        if (StringUtils.isNotBlank((CharSequence)theValueSetUrl)) {
            vs = theRootValidationSupport.fetchValueSet(theValueSetUrl);
            if (vs == null) {
                return null;
            }
        } else {
            switch (this.myCtx.getVersion().getVersion()) {
                case DSTU2_HL7ORG: {
                    vs = new org.hl7.fhir.dstu2.model.ValueSet().setCompose(new ValueSet.ValueSetComposeComponent().addInclude(new ValueSet.ConceptSetComponent().setSystem(theCodeSystem)));
                    break;
                }
                case DSTU3: {
                    vs = new ValueSet().setCompose(new ValueSet.ValueSetComposeComponent().addInclude(new ValueSet.ConceptSetComponent().setSystem(theCodeSystem)));
                    break;
                }
                case R4: {
                    vs = new org.hl7.fhir.r4.model.ValueSet().setCompose(new ValueSet.ValueSetComposeComponent().addInclude(new ValueSet.ConceptSetComponent().setSystem(theCodeSystem)));
                    break;
                }
                case R5: {
                    vs = new org.hl7.fhir.r5.model.ValueSet().setCompose(new ValueSet.ValueSetComposeComponent().addInclude(new ValueSet.ConceptSetComponent().setSystem(theCodeSystem)));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Can not handle version: " + this.myCtx.getVersion().getVersion());
                }
            }
        }
        if ((valueSetExpansionOutcome = this.expandValueSet(theRootValidationSupport, null, vs)) == null) {
            return null;
        }
        IBaseResource expansion = valueSetExpansionOutcome.getValueSet();
        return this.validateCodeInExpandedValueSet(theRootValidationSupport, theOptions, theCodeSystem, theCode, expansion);
    }

    private IValidationSupport.CodeValidationResult validateCodeInExpandedValueSet(IValidationSupport theRootValidationSupport, ConceptValidationOptions theOptions, String theCodeSystem, String theCode, IBaseResource theExpansion) {
        assert (theExpansion != null);
        boolean caseSensitive = true;
        IBaseResource system = null;
        if (!theOptions.isInferSystem() && StringUtils.isNotBlank((CharSequence)theCodeSystem) && (system = theRootValidationSupport.fetchCodeSystem(theCodeSystem)) == null) {
            return null;
        }
        ArrayList<VersionIndependentConcept> codes = new ArrayList<VersionIndependentConcept>();
        switch (theExpansion.getStructureFhirVersionEnum()) {
            case DSTU2_HL7ORG: {
                org.hl7.fhir.dstu2.model.ValueSet expansionVs = (org.hl7.fhir.dstu2.model.ValueSet)theExpansion;
                List contains = expansionVs.getExpansion().getContains();
                InMemoryTerminologyServerValidationSupport.flattenAndConvertCodesDstu2(contains, codes);
                break;
            }
            case DSTU3: {
                org.hl7.fhir.dstu2.model.ValueSet expansionVs = (ValueSet)theExpansion;
                List contains = expansionVs.getExpansion().getContains();
                InMemoryTerminologyServerValidationSupport.flattenAndConvertCodesDstu3(contains, codes);
                break;
            }
            case R4: {
                org.hl7.fhir.dstu2.model.ValueSet expansionVs = (org.hl7.fhir.r4.model.ValueSet)theExpansion;
                List contains = expansionVs.getExpansion().getContains();
                InMemoryTerminologyServerValidationSupport.flattenAndConvertCodesR4(contains, codes);
                break;
            }
            case R5: {
                org.hl7.fhir.dstu2.model.ValueSet expansionVs = (org.hl7.fhir.r5.model.ValueSet)theExpansion;
                List contains = expansionVs.getExpansion().getContains();
                InMemoryTerminologyServerValidationSupport.flattenAndConvertCodesR5(contains, codes);
                break;
            }
            default: {
                throw new IllegalArgumentException("Can not handle version: " + this.myCtx.getVersion().getVersion());
            }
        }
        String codeSystemName = null;
        String codeSystemVersion = null;
        if (system != null) {
            switch (system.getStructureFhirVersionEnum()) {
                case DSTU2_HL7ORG: {
                    caseSensitive = true;
                    break;
                }
                case DSTU3: {
                    org.hl7.fhir.dstu3.model.CodeSystem systemDstu3 = (org.hl7.fhir.dstu3.model.CodeSystem)system;
                    caseSensitive = systemDstu3.getCaseSensitive();
                    codeSystemName = systemDstu3.getName();
                    codeSystemVersion = systemDstu3.getVersion();
                    break;
                }
                case R4: {
                    CodeSystem systemR4 = (CodeSystem)system;
                    caseSensitive = systemR4.getCaseSensitive();
                    codeSystemName = systemR4.getName();
                    codeSystemVersion = systemR4.getVersion();
                    break;
                }
                case R5: {
                    org.hl7.fhir.r5.model.CodeSystem systemR5 = (org.hl7.fhir.r5.model.CodeSystem)system;
                    caseSensitive = systemR5.getCaseSensitive();
                    codeSystemName = systemR5.getName();
                    codeSystemVersion = systemR5.getVersion();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Can not handle version: " + this.myCtx.getVersion().getVersion());
                }
            }
        }
        for (VersionIndependentConcept nextExpansionCode : codes) {
            boolean codeMatches = caseSensitive ? theCode.equals(nextExpansionCode.getCode()) : theCode.equalsIgnoreCase(nextExpansionCode.getCode());
            if (!codeMatches || !theOptions.isInferSystem() && !nextExpansionCode.getSystem().equals(theCodeSystem)) continue;
            return new IValidationSupport.CodeValidationResult().setCode(theCode).setDisplay(nextExpansionCode.getDisplay()).setCodeSystemName(codeSystemName).setCodeSystemVersion(codeSystemVersion);
        }
        ValidationMessage.IssueSeverity severity = ValidationMessage.IssueSeverity.ERROR;
        String message = "Unknown code '" + (StringUtils.isNotBlank((CharSequence)theCodeSystem) ? theCodeSystem + "#" : "") + theCode + "'";
        return new IValidationSupport.CodeValidationResult().setSeverityCode(severity.toCode()).setMessage(message);
    }

    public IValidationSupport.LookupCodeResult lookupCode(IValidationSupport theRootValidationSupport, String theSystem, String theCode) {
        return this.validateCode(theRootValidationSupport, new ConceptValidationOptions(), theSystem, theCode, null, null).asLookupCodeResult(theSystem, theCode);
    }

    @Nullable
    private org.hl7.fhir.r5.model.ValueSet expandValueSetDstu2Hl7Org(IValidationSupport theRootValidationSupport, org.hl7.fhir.dstu2.model.ValueSet theInput, @Nullable String theWantSystem, @Nullable String theWantCode) {
        Function<String, org.hl7.fhir.r5.model.CodeSystem> codeSystemLoader = t -> {
            org.hl7.fhir.dstu2.model.ValueSet codeSystem = (org.hl7.fhir.dstu2.model.ValueSet)theRootValidationSupport.fetchCodeSystem(t);
            org.hl7.fhir.r5.model.CodeSystem retVal = new org.hl7.fhir.r5.model.CodeSystem();
            this.addCodesDstu2Hl7Org(codeSystem.getCodeSystem().getConcept(), retVal.getConcept());
            return retVal;
        };
        Function<String, org.hl7.fhir.r5.model.ValueSet> valueSetLoader = t -> {
            org.hl7.fhir.dstu2.model.ValueSet valueSet = (org.hl7.fhir.dstu2.model.ValueSet)theRootValidationSupport.fetchValueSet(t);
            return ValueSet10_50.convertValueSet((org.hl7.fhir.dstu2.model.ValueSet)valueSet);
        };
        org.hl7.fhir.r5.model.ValueSet input = ValueSet10_50.convertValueSet((org.hl7.fhir.dstu2.model.ValueSet)theInput);
        org.hl7.fhir.r5.model.ValueSet output = this.expandValueSetR5(theRootValidationSupport, input, codeSystemLoader, valueSetLoader, theWantSystem, theWantCode);
        return output;
    }

    public boolean isCodeSystemSupported(IValidationSupport theRootValidationSupport, String theSystem) {
        IPrimitiveType content;
        if (StringUtils.isBlank((CharSequence)theSystem)) {
            return false;
        }
        IBaseResource cs = theRootValidationSupport.fetchCodeSystem(theSystem);
        if (!this.myCtx.getVersion().getVersion().isEqualOrNewerThan(FhirVersionEnum.DSTU2_1)) {
            return cs != null;
        }
        return cs != null && !"not-present".equals((content = (IPrimitiveType)this.getFhirContext().newTerser().getSingleValueOrNull((IBase)cs, "content", IPrimitiveType.class)).getValueAsString());
    }

    public boolean isValueSetSupported(IValidationSupport theRootValidationSupport, String theValueSetUrl) {
        return StringUtils.isNotBlank((CharSequence)theValueSetUrl) && theRootValidationSupport.fetchValueSet(theValueSetUrl) != null;
    }

    private void addCodesDstu2Hl7Org(List<ValueSet.ConceptDefinitionComponent> theSourceList, List<CodeSystem.ConceptDefinitionComponent> theTargetList) {
        for (ValueSet.ConceptDefinitionComponent nextSource : theSourceList) {
            CodeSystem.ConceptDefinitionComponent targetConcept = new CodeSystem.ConceptDefinitionComponent().setCode(nextSource.getCode()).setDisplay(nextSource.getDisplay());
            theTargetList.add(targetConcept);
            this.addCodesDstu2Hl7Org(nextSource.getConcept(), targetConcept.getConcept());
        }
    }

    @Nullable
    private org.hl7.fhir.r5.model.ValueSet expandValueSetDstu3(IValidationSupport theRootValidationSupport, ValueSet theInput, @Nullable String theWantSystem, @Nullable String theWantCode) {
        Function<String, org.hl7.fhir.r5.model.CodeSystem> codeSystemLoader = t -> {
            org.hl7.fhir.dstu3.model.CodeSystem codeSystem = (org.hl7.fhir.dstu3.model.CodeSystem)theRootValidationSupport.fetchCodeSystem(t);
            return CodeSystem30_50.convertCodeSystem((org.hl7.fhir.dstu3.model.CodeSystem)codeSystem);
        };
        Function<String, org.hl7.fhir.r5.model.ValueSet> valueSetLoader = t -> {
            ValueSet valueSet = (ValueSet)theRootValidationSupport.fetchValueSet(t);
            return ValueSet30_50.convertValueSet((ValueSet)valueSet);
        };
        org.hl7.fhir.r5.model.ValueSet input = ValueSet30_50.convertValueSet((ValueSet)theInput);
        org.hl7.fhir.r5.model.ValueSet output = this.expandValueSetR5(theRootValidationSupport, input, codeSystemLoader, valueSetLoader, theWantSystem, theWantCode);
        return output;
    }

    @Nullable
    private org.hl7.fhir.r5.model.ValueSet expandValueSetR4(IValidationSupport theRootValidationSupport, org.hl7.fhir.r4.model.ValueSet theInput, @Nullable String theWantSystem, @Nullable String theWantCode) {
        Function<String, org.hl7.fhir.r5.model.CodeSystem> codeSystemLoader = t -> {
            CodeSystem codeSystem = (CodeSystem)theRootValidationSupport.fetchCodeSystem(t);
            return CodeSystem40_50.convertCodeSystem((CodeSystem)codeSystem);
        };
        Function<String, org.hl7.fhir.r5.model.ValueSet> valueSetLoader = t -> {
            org.hl7.fhir.r4.model.ValueSet valueSet = (org.hl7.fhir.r4.model.ValueSet)theRootValidationSupport.fetchValueSet(t);
            return ValueSet40_50.convertValueSet((org.hl7.fhir.r4.model.ValueSet)valueSet);
        };
        org.hl7.fhir.r5.model.ValueSet input = ValueSet40_50.convertValueSet((org.hl7.fhir.r4.model.ValueSet)theInput);
        org.hl7.fhir.r5.model.ValueSet output = this.expandValueSetR5(theRootValidationSupport, input, codeSystemLoader, valueSetLoader, theWantSystem, theWantCode);
        return output;
    }

    @Nullable
    private org.hl7.fhir.r5.model.ValueSet expandValueSetR5(IValidationSupport theRootValidationSupport, org.hl7.fhir.r5.model.ValueSet theInput) {
        Function<String, org.hl7.fhir.r5.model.CodeSystem> codeSystemLoader = t -> (org.hl7.fhir.r5.model.CodeSystem)theRootValidationSupport.fetchCodeSystem(t);
        Function<String, org.hl7.fhir.r5.model.ValueSet> valueSetLoader = t -> (org.hl7.fhir.r5.model.ValueSet)theRootValidationSupport.fetchValueSet(t);
        return this.expandValueSetR5(theRootValidationSupport, theInput, codeSystemLoader, valueSetLoader, null, null);
    }

    @Nullable
    private org.hl7.fhir.r5.model.ValueSet expandValueSetR5(IValidationSupport theRootValidationSupport, org.hl7.fhir.r5.model.ValueSet theInput, Function<String, org.hl7.fhir.r5.model.CodeSystem> theCodeSystemLoader, Function<String, org.hl7.fhir.r5.model.ValueSet> theValueSetLoader, @Nullable String theWantSystem, @Nullable String theWantCode) {
        HashSet<VersionIndependentConcept> concepts = new HashSet<VersionIndependentConcept>();
        try {
            this.expandValueSetR5IncludeOrExclude(theRootValidationSupport, concepts, theCodeSystemLoader, theValueSetLoader, theInput.getCompose().getInclude(), true, theWantSystem, theWantCode);
            this.expandValueSetR5IncludeOrExclude(theRootValidationSupport, concepts, theCodeSystemLoader, theValueSetLoader, theInput.getCompose().getExclude(), false, theWantSystem, theWantCode);
        }
        catch (ExpansionCouldNotBeCompletedInternallyException e) {
            return null;
        }
        org.hl7.fhir.r5.model.ValueSet retVal = new org.hl7.fhir.r5.model.ValueSet();
        for (VersionIndependentConcept next : concepts) {
            ValueSet.ValueSetExpansionContainsComponent contains = retVal.getExpansion().addContains();
            contains.setSystem(next.getSystem());
            contains.setCode(next.getCode());
            contains.setDisplay(next.getDisplay());
        }
        return retVal;
    }

    private void expandValueSetR5IncludeOrExclude(IValidationSupport theRootValidationSupport, Set<VersionIndependentConcept> theConcepts, Function<String, org.hl7.fhir.r5.model.CodeSystem> theCodeSystemLoader, Function<String, org.hl7.fhir.r5.model.ValueSet> theValueSetLoader, List<ValueSet.ConceptSetComponent> theComposeList, boolean theComposeListIsInclude, @Nullable String theWantSystem, @Nullable String theWantCode) throws ExpansionCouldNotBeCompletedInternallyException {
        for (ValueSet.ConceptSetComponent nextInclude : theComposeList) {
            ArrayList<VersionIndependentConcept> nextCodeList = new ArrayList<VersionIndependentConcept>();
            String system = nextInclude.getSystem();
            if (StringUtils.isNotBlank((CharSequence)system)) {
                if (theWantSystem != null && !theWantSystem.equals(system)) continue;
                org.hl7.fhir.r5.model.CodeSystem codeSystem = theCodeSystemLoader.apply(system);
                Set<String> wantCodes = nextInclude.getConcept().isEmpty() ? null : nextInclude.getConcept().stream().map(t -> t.getCode()).collect(Collectors.toSet());
                boolean ableToHandleCode = false;
                if (codeSystem == null) {
                    IValidationSupport.LookupCodeResult lookup;
                    if (theWantCode != null && (lookup = theRootValidationSupport.lookupCode(theRootValidationSupport, system, theWantCode)) != null && lookup.isFound()) {
                        CodeSystem.ConceptDefinitionComponent conceptDefinition = new CodeSystem.ConceptDefinitionComponent().addConcept().setCode(theWantCode).setDisplay(lookup.getCodeDisplay());
                        List<CodeSystem.ConceptDefinitionComponent> codesList = Collections.singletonList(conceptDefinition);
                        this.addCodes(system, codesList, nextCodeList, wantCodes);
                        ableToHandleCode = true;
                    }
                } else {
                    ableToHandleCode = true;
                }
                if (!ableToHandleCode) {
                    throw new ExpansionCouldNotBeCompletedInternallyException();
                }
                if (codeSystem != null) {
                    if (codeSystem.getContent() == CodeSystem.CodeSystemContentMode.NOTPRESENT) {
                        throw new ExpansionCouldNotBeCompletedInternallyException();
                    }
                    this.addCodes(system, codeSystem.getConcept(), nextCodeList, wantCodes);
                }
            }
            for (CanonicalType nextValueSetInclude : nextInclude.getValueSet()) {
                org.hl7.fhir.r5.model.ValueSet vs = theValueSetLoader.apply(nextValueSetInclude.getValueAsString());
                if (vs == null) continue;
                org.hl7.fhir.r5.model.ValueSet subExpansion = this.expandValueSetR5(theRootValidationSupport, vs, theCodeSystemLoader, theValueSetLoader, theWantSystem, theWantCode);
                if (subExpansion == null) {
                    throw new ExpansionCouldNotBeCompletedInternallyException();
                }
                for (ValueSet.ValueSetExpansionContainsComponent next : subExpansion.getExpansion().getContains()) {
                    nextCodeList.add(new VersionIndependentConcept(next.getSystem(), next.getCode(), next.getDisplay()));
                }
            }
            if (theComposeListIsInclude) {
                theConcepts.addAll(nextCodeList);
                continue;
            }
            theConcepts.removeAll(nextCodeList);
        }
    }

    private void addCodes(String theSystem, List<CodeSystem.ConceptDefinitionComponent> theSource, List<VersionIndependentConcept> theTarget, Set<String> theCodeFilter) {
        for (CodeSystem.ConceptDefinitionComponent next : theSource) {
            if (StringUtils.isNotBlank((CharSequence)next.getCode()) && (theCodeFilter == null || theCodeFilter.contains(next.getCode()))) {
                theTarget.add(new VersionIndependentConcept(theSystem, next.getCode(), next.getDisplay()));
            }
            this.addCodes(theSystem, next.getConcept(), theTarget, theCodeFilter);
        }
    }

    private static void flattenAndConvertCodesDstu2(List<ValueSet.ValueSetExpansionContainsComponent> theInput, List<VersionIndependentConcept> theVersionIndependentConcepts) {
        for (ValueSet.ValueSetExpansionContainsComponent next : theInput) {
            theVersionIndependentConcepts.add(new VersionIndependentConcept(next.getSystem(), next.getCode(), next.getDisplay()));
            InMemoryTerminologyServerValidationSupport.flattenAndConvertCodesDstu2(next.getContains(), theVersionIndependentConcepts);
        }
    }

    private static void flattenAndConvertCodesDstu3(List<ValueSet.ValueSetExpansionContainsComponent> theInput, List<VersionIndependentConcept> theVersionIndependentConcepts) {
        for (ValueSet.ValueSetExpansionContainsComponent next : theInput) {
            theVersionIndependentConcepts.add(new VersionIndependentConcept(next.getSystem(), next.getCode(), next.getDisplay()));
            InMemoryTerminologyServerValidationSupport.flattenAndConvertCodesDstu3(next.getContains(), theVersionIndependentConcepts);
        }
    }

    private static void flattenAndConvertCodesR4(List<ValueSet.ValueSetExpansionContainsComponent> theInput, List<VersionIndependentConcept> theVersionIndependentConcepts) {
        for (ValueSet.ValueSetExpansionContainsComponent next : theInput) {
            theVersionIndependentConcepts.add(new VersionIndependentConcept(next.getSystem(), next.getCode(), next.getDisplay()));
            InMemoryTerminologyServerValidationSupport.flattenAndConvertCodesR4(next.getContains(), theVersionIndependentConcepts);
        }
    }

    private static void flattenAndConvertCodesR5(List<ValueSet.ValueSetExpansionContainsComponent> theInput, List<VersionIndependentConcept> theVersionIndependentConcepts) {
        for (ValueSet.ValueSetExpansionContainsComponent next : theInput) {
            theVersionIndependentConcepts.add(new VersionIndependentConcept(next.getSystem(), next.getCode(), next.getDisplay()));
            InMemoryTerminologyServerValidationSupport.flattenAndConvertCodesR5(next.getContains(), theVersionIndependentConcepts);
        }
    }

    private static class ExpansionCouldNotBeCompletedInternallyException
    extends Exception {
        private ExpansionCouldNotBeCompletedInternallyException() {
        }
    }
}

