/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.common.hapi.validation.support;

import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.IValidationSupport;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hl7.fhir.common.hapi.validation.support.BaseValidationSupportWrapper;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingValidationSupport
extends BaseValidationSupportWrapper
implements IValidationSupport {
    private static final Logger ourLog = LoggerFactory.getLogger(CachingValidationSupport.class);
    private final Cache<String, Object> myCache;
    private final Cache<String, Object> myValidateCodeCache = Caffeine.newBuilder().expireAfterWrite(60L, TimeUnit.SECONDS).maximumSize(5000L).build();
    private final Cache<String, Object> myLookupCodeCache = Caffeine.newBuilder().expireAfterWrite(60L, TimeUnit.SECONDS).maximumSize(5000L).build();

    public CachingValidationSupport(IValidationSupport theWrap) {
        super(theWrap.getFhirContext(), theWrap);
        this.myCache = Caffeine.newBuilder().expireAfterWrite(60L, TimeUnit.SECONDS).maximumSize(5000L).build();
    }

    @Override
    public List<IBaseResource> fetchAllConformanceResources() {
        String key = "fetchAllConformanceResources";
        return this.loadFromCache(this.myCache, key, t -> super.fetchAllConformanceResources());
    }

    @Override
    public <T extends IBaseResource> List<T> fetchAllStructureDefinitions() {
        String key = "fetchAllStructureDefinitions";
        return this.loadFromCache(this.myCache, key, t -> super.fetchAllStructureDefinitions());
    }

    @Override
    public <T extends IBaseResource> T fetchResource(Class<T> theClass, String theUri) {
        return (T)this.loadFromCache(this.myCache, "fetchResource " + theClass.getName() + " " + theUri, t -> super.fetchResource(theClass, theUri));
    }

    @Override
    public boolean isCodeSystemSupported(IValidationSupport theRootValidationSupport, String theSystem) {
        String key = "isCodeSystemSupported " + theSystem;
        Boolean retVal = this.loadFromCache(this.myCache, key, t -> super.isCodeSystemSupported(theRootValidationSupport, theSystem));
        assert (retVal != null);
        return retVal;
    }

    @Override
    public IValidationSupport.CodeValidationResult validateCode(IValidationSupport theRootValidationSupport, ConceptValidationOptions theOptions, String theCodeSystem, String theCode, String theDisplay, String theValueSetUrl) {
        String key = "validateCode " + theCodeSystem + " " + theCode + " " + (String)StringUtils.defaultIfBlank((CharSequence)theValueSetUrl, (CharSequence)"NO_VS");
        return this.loadFromCache(this.myValidateCodeCache, key, t -> super.validateCode(theRootValidationSupport, theOptions, theCodeSystem, theCode, theDisplay, theValueSetUrl));
    }

    @Override
    public IValidationSupport.LookupCodeResult lookupCode(IValidationSupport theRootValidationSupport, String theSystem, String theCode) {
        String key = "lookupCode " + theSystem + " " + theCode;
        return this.loadFromCache(this.myLookupCodeCache, key, t -> super.lookupCode(theRootValidationSupport, theSystem, theCode));
    }

    private <T> @Nullable T loadFromCache(Cache theCache, String theKey, Function<String, T> theLoader) {
        ourLog.trace("Fetching from cache: {}", (Object)theKey);
        Function<String, Optional> loaderWrapper = key -> Optional.ofNullable(theLoader.apply(theKey));
        Optional result = (Optional)theCache.get((Object)theKey, loaderWrapper);
        assert (result != null);
        return result.orElse(null);
    }

    public void invalidateCaches() {
        this.myLookupCodeCache.invalidateAll();
        this.myCache.invalidateAll();
        this.myValidateCodeCache.invalidateAll();
    }
}

