/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.common.hapi.validation.support;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValueSetExpansionOptions;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.common.hapi.validation.support.BaseValidationSupport;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class BaseValidationSupportWrapper
extends BaseValidationSupport {
    private final IValidationSupport myWrap;

    public BaseValidationSupportWrapper(FhirContext theFhirContext, IValidationSupport theWrap) {
        super(theFhirContext);
        Validate.notNull((Object)theWrap, (String)"theWrap must not be null", (Object[])new Object[0]);
        this.myWrap = theWrap;
    }

    public List<IBaseResource> fetchAllConformanceResources() {
        return this.myWrap.fetchAllConformanceResources();
    }

    public <T extends IBaseResource> List<T> fetchAllStructureDefinitions() {
        return this.myWrap.fetchAllStructureDefinitions();
    }

    public <T extends IBaseResource> T fetchResource(Class<T> theClass, String theUri) {
        return (T)this.myWrap.fetchResource(theClass, theUri);
    }

    public boolean isCodeSystemSupported(IValidationSupport theRootValidationSupport, String theSystem) {
        return this.myWrap.isCodeSystemSupported(this.myWrap, theSystem);
    }

    public IValidationSupport.CodeValidationResult validateCode(IValidationSupport theRootValidationSupport, ConceptValidationOptions theOptions, String theCodeSystem, String theCode, String theDisplay, String theValueSetUrl) {
        return this.myWrap.validateCode(theRootValidationSupport, theOptions, theCodeSystem, theCode, theDisplay, theValueSetUrl);
    }

    public IValidationSupport.LookupCodeResult lookupCode(IValidationSupport theRootValidationSupport, String theSystem, String theCode) {
        return this.myWrap.lookupCode(theRootValidationSupport, theSystem, theCode);
    }

    public boolean isValueSetSupported(IValidationSupport theRootValidationSupport, String theValueSetUrl) {
        return this.myWrap.isValueSetSupported(this.myWrap, theValueSetUrl);
    }

    public IValidationSupport.ValueSetExpansionOutcome expandValueSet(IValidationSupport theRootValidationSupport, ValueSetExpansionOptions theExpansionOptions, IBaseResource theValueSetToExpand) {
        return this.myWrap.expandValueSet(theRootValidationSupport, null, theValueSetToExpand);
    }

    public IBaseResource fetchCodeSystem(String theSystem) {
        return this.myWrap.fetchCodeSystem(theSystem);
    }

    public IBaseResource fetchValueSet(String theUri) {
        return this.myWrap.fetchValueSet(theUri);
    }

    public IBaseResource fetchStructureDefinition(String theUrl) {
        return this.myWrap.fetchStructureDefinition(theUrl);
    }

    public IBaseResource generateSnapshot(IValidationSupport theRootValidationSupport, IBaseResource theInput, String theUrl, String theWebUrl, String theProfileName) {
        return this.myWrap.generateSnapshot(theRootValidationSupport, theInput, theUrl, theWebUrl, theProfileName);
    }

    public IValidationSupport.CodeValidationResult validateCodeInValueSet(IValidationSupport theRootValidationSupport, ConceptValidationOptions theValidationOptions, String theCodeSystem, String theCode, String theDisplay, @Nonnull IBaseResource theValueSet) {
        return this.myWrap.validateCodeInValueSet(theRootValidationSupport, theValidationOptions, theCodeSystem, theCode, theDisplay, theValueSet);
    }
}

