/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.provider.dstu2;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.model.dstu2.resource.Conformance;
import ca.uhn.fhir.model.dstu2.resource.OperationDefinition;
import ca.uhn.fhir.model.dstu2.valueset.ConditionalDeleteStatusEnum;
import ca.uhn.fhir.model.dstu2.valueset.ConformanceResourceStatusEnum;
import ca.uhn.fhir.model.dstu2.valueset.ConformanceStatementKindEnum;
import ca.uhn.fhir.model.dstu2.valueset.OperationKindEnum;
import ca.uhn.fhir.model.dstu2.valueset.OperationParameterUseEnum;
import ca.uhn.fhir.model.dstu2.valueset.ResourceTypeEnum;
import ca.uhn.fhir.model.dstu2.valueset.RestfulConformanceModeEnum;
import ca.uhn.fhir.model.dstu2.valueset.SystemRestfulInteractionEnum;
import ca.uhn.fhir.model.dstu2.valueset.TypeRestfulInteractionEnum;
import ca.uhn.fhir.model.dstu2.valueset.UnknownContentCodeEnum;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Metadata;
import ca.uhn.fhir.rest.annotation.Read;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.Bindings;
import ca.uhn.fhir.rest.server.IServerConformanceProvider;
import ca.uhn.fhir.rest.server.ResourceBinding;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.RestfulServerConfiguration;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.method.BaseMethodBinding;
import ca.uhn.fhir.rest.server.method.IParameter;
import ca.uhn.fhir.rest.server.method.OperationMethodBinding;
import ca.uhn.fhir.rest.server.method.OperationParameter;
import ca.uhn.fhir.rest.server.method.SearchMethodBinding;
import ca.uhn.fhir.rest.server.method.SearchParameter;
import ca.uhn.fhir.rest.server.util.BaseServerCapabilityStatementProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class ServerConformanceProvider
extends BaseServerCapabilityStatementProvider
implements IServerConformanceProvider<Conformance> {
    private String myPublisher = "Not provided";

    public ServerConformanceProvider() {
    }

    @Deprecated
    public ServerConformanceProvider(RestfulServer theRestfulServer) {
        this();
    }

    public ServerConformanceProvider(RestfulServerConfiguration theServerConfiguration) {
        super(theServerConfiguration);
    }

    private void checkBindingForSystemOps(Conformance.Rest rest, Set<SystemRestfulInteractionEnum> systemOps, BaseMethodBinding<?> nextMethodBinding) {
        String sysOpCode;
        if (nextMethodBinding.getRestOperationType() != null && (sysOpCode = nextMethodBinding.getRestOperationType().getCode()) != null) {
            SystemRestfulInteractionEnum sysOp = (SystemRestfulInteractionEnum)SystemRestfulInteractionEnum.VALUESET_BINDER.fromCodeString(sysOpCode);
            if (sysOp == null) {
                return;
            }
            if (!systemOps.contains((Object)sysOp)) {
                systemOps.add(sysOp);
                rest.addInteraction().setCode(sysOp);
            }
        }
    }

    private Map<String, List<BaseMethodBinding<?>>> collectMethodBindings(RequestDetails theRequestDetails) {
        String resourceName;
        TreeMap resourceToMethods = new TreeMap();
        for (ResourceBinding next : this.getServerConfiguration(theRequestDetails).getResourceBindings()) {
            resourceName = next.getResourceName();
            for (BaseMethodBinding nextMethodBinding : next.getMethodBindings()) {
                if (!resourceToMethods.containsKey(resourceName)) {
                    resourceToMethods.put(resourceName, new ArrayList());
                }
                ((List)resourceToMethods.get(resourceName)).add(nextMethodBinding);
            }
        }
        for (BaseMethodBinding nextMethodBinding : this.getServerConfiguration(theRequestDetails).getServerBindings()) {
            resourceName = "";
            if (!resourceToMethods.containsKey(resourceName)) {
                resourceToMethods.put(resourceName, new ArrayList());
            }
            ((List)resourceToMethods.get(resourceName)).add(nextMethodBinding);
        }
        return resourceToMethods;
    }

    private DateTimeDt conformanceDate(RequestDetails theRequestDetails) {
        IPrimitiveType buildDate = this.getServerConfiguration(theRequestDetails).getConformanceDate();
        if (buildDate != null && buildDate.getValue() != null) {
            try {
                return new DateTimeDt(buildDate.getValueAsString());
            }
            catch (DataFormatException dataFormatException) {
                // empty catch block
            }
        }
        return DateTimeDt.withCurrentTime();
    }

    private String createOperationName(OperationMethodBinding theMethodBinding) {
        StringBuilder retVal = new StringBuilder();
        if (theMethodBinding.getResourceName() != null) {
            retVal.append(theMethodBinding.getResourceName());
        }
        retVal.append('-');
        if (theMethodBinding.isCanOperateAtInstanceLevel()) {
            retVal.append('i');
        }
        if (theMethodBinding.isCanOperateAtServerLevel()) {
            retVal.append('s');
        }
        retVal.append('-');
        retVal.append(theMethodBinding.getName(), 1, theMethodBinding.getName().length());
        return retVal.toString();
    }

    public String getPublisher() {
        return this.myPublisher;
    }

    public void setPublisher(String thePublisher) {
        this.myPublisher = thePublisher;
    }

    @Metadata
    public Conformance getServerConformance(HttpServletRequest theRequest, RequestDetails theRequestDetails) {
        RestfulServerConfiguration serverConfiguration = this.getServerConfiguration(theRequestDetails);
        Bindings bindings = serverConfiguration.provideBindings();
        Conformance retVal = new Conformance();
        retVal.setPublisher(this.myPublisher);
        retVal.setDate(this.conformanceDate(theRequestDetails));
        retVal.setFhirVersion(FhirVersionEnum.DSTU2.getFhirVersionString());
        retVal.setAcceptUnknown(UnknownContentCodeEnum.UNKNOWN_EXTENSIONS);
        ServletContext servletContext = (ServletContext)(theRequest == null ? null : theRequest.getAttribute("ca.uhn.fhir.rest.server.RestfulServer.servlet_context"));
        String serverBase = serverConfiguration.getServerAddressStrategy().determineServerBase(servletContext, theRequest);
        retVal.getImplementation().setUrl(serverBase).setDescription(serverConfiguration.getImplementationDescription());
        retVal.setKind(ConformanceStatementKindEnum.INSTANCE);
        retVal.getSoftware().setName(serverConfiguration.getServerName());
        retVal.getSoftware().setVersion(serverConfiguration.getServerVersion());
        retVal.addFormat("application/xml+fhir");
        retVal.addFormat("application/json+fhir");
        Conformance.Rest rest = retVal.addRest();
        rest.setMode(RestfulConformanceModeEnum.SERVER);
        HashSet<SystemRestfulInteractionEnum> systemOps = new HashSet<SystemRestfulInteractionEnum>();
        HashSet<String> operationNames = new HashSet<String>();
        Map<String, List<BaseMethodBinding<?>>> resourceToMethods = this.collectMethodBindings(theRequestDetails);
        for (Map.Entry<String, List<BaseMethodBinding<?>>> nextEntry : resourceToMethods.entrySet()) {
            if (!nextEntry.getKey().isEmpty()) {
                HashSet<TypeRestfulInteractionEnum> resourceOps = new HashSet<TypeRestfulInteractionEnum>();
                Conformance.RestResource resource = rest.addResource();
                String resourceName = nextEntry.getKey();
                RuntimeResourceDefinition def = serverConfiguration.getFhirContext().getResourceDefinition(resourceName);
                resource.getTypeElement().setValue((Object)def.getName());
                resource.getProfile().setReference(new IdDt(def.getResourceProfile(serverBase)));
                TreeSet<String> includes = new TreeSet<String>();
                for (BaseMethodBinding<?> nextMethodBinding : nextEntry.getValue()) {
                    TypeRestfulInteractionEnum resOp;
                    String resOpCode;
                    if (nextMethodBinding.getRestOperationType() != null && (resOpCode = nextMethodBinding.getRestOperationType().getCode()) != null && (resOp = (TypeRestfulInteractionEnum)TypeRestfulInteractionEnum.VALUESET_BINDER.fromCodeString(resOpCode)) != null) {
                        if (!resourceOps.contains((Object)resOp)) {
                            resourceOps.add(resOp);
                            resource.addInteraction().setCode(resOp);
                        }
                        if ("vread".equals(resOpCode) && !resourceOps.contains((Object)(resOp = TypeRestfulInteractionEnum.READ))) {
                            resourceOps.add(resOp);
                            resource.addInteraction().setCode(resOp);
                        }
                        if (nextMethodBinding.isSupportsConditional()) {
                            switch (resOp) {
                                case CREATE: {
                                    resource.setConditionalCreate(true);
                                    break;
                                }
                                case DELETE: {
                                    if (nextMethodBinding.isSupportsConditionalMultiple()) {
                                        resource.setConditionalDelete(ConditionalDeleteStatusEnum.MULTIPLE_DELETES_SUPPORTED);
                                        break;
                                    }
                                    resource.setConditionalDelete(ConditionalDeleteStatusEnum.SINGLE_DELETES_SUPPORTED);
                                    break;
                                }
                                case UPDATE: {
                                    resource.setConditionalUpdate(true);
                                    break;
                                }
                            }
                        }
                    }
                    this.checkBindingForSystemOps(rest, systemOps, nextMethodBinding);
                    if (nextMethodBinding instanceof SearchMethodBinding) {
                        this.handleSearchMethodBinding(resource, def, includes, (SearchMethodBinding)nextMethodBinding, theRequestDetails);
                    } else if (nextMethodBinding instanceof OperationMethodBinding) {
                        OperationMethodBinding methodBinding = (OperationMethodBinding)nextMethodBinding;
                        String opName = (String)bindings.getOperationBindingToId().get(methodBinding);
                        if (operationNames.add(opName)) {
                            rest.addOperation().setName(methodBinding.getName().substring(1)).getDefinition().setReference("OperationDefinition/" + opName);
                        }
                    }
                    Collections.sort(resource.getInteraction(), new Comparator<Conformance.RestResourceInteraction>(){

                        @Override
                        public int compare(Conformance.RestResourceInteraction theO1, Conformance.RestResourceInteraction theO2) {
                            TypeRestfulInteractionEnum o1 = (TypeRestfulInteractionEnum)theO1.getCodeElement().getValueAsEnum();
                            TypeRestfulInteractionEnum o2 = (TypeRestfulInteractionEnum)theO2.getCodeElement().getValueAsEnum();
                            if (o1 == null && o2 == null) {
                                return 0;
                            }
                            if (o1 == null) {
                                return 1;
                            }
                            if (o2 == null) {
                                return -1;
                            }
                            return o1.ordinal() - o2.ordinal();
                        }
                    });
                }
                for (String nextInclude : includes) {
                    resource.addSearchInclude(nextInclude);
                }
                continue;
            }
            for (BaseMethodBinding<?> nextMethodBinding : nextEntry.getValue()) {
                this.checkBindingForSystemOps(rest, systemOps, nextMethodBinding);
                if (!(nextMethodBinding instanceof OperationMethodBinding)) continue;
                OperationMethodBinding methodBinding = (OperationMethodBinding)nextMethodBinding;
                String opName = (String)bindings.getOperationBindingToId().get(methodBinding);
                if (!operationNames.add(opName)) continue;
                rest.addOperation().setName(methodBinding.getName().substring(1)).getDefinition().setReference("OperationDefinition/" + opName);
            }
        }
        return retVal;
    }

    private void handleSearchMethodBinding(Conformance.RestResource resource, RuntimeResourceDefinition def, TreeSet<String> includes, SearchMethodBinding searchMethodBinding, RequestDetails theRequestDetails) {
        includes.addAll(searchMethodBinding.getIncludes());
        List params = searchMethodBinding.getParameters();
        ArrayList<SearchParameter> searchParameters = new ArrayList<SearchParameter>();
        for (IParameter iParameter : params) {
            if (!(iParameter instanceof SearchParameter)) continue;
            searchParameters.add((SearchParameter)iParameter);
        }
        this.sortSearchParameters(searchParameters);
        if (!searchParameters.isEmpty()) {
            for (SearchParameter searchParameter : searchParameters) {
                RuntimeSearchParam paramDef;
                String nextParamDescription;
                String nextParamName = searchParameter.getName();
                String chain = null;
                String nextParamUnchainedName = nextParamName;
                if (nextParamName.contains(".")) {
                    chain = nextParamName.substring(nextParamName.indexOf(46) + 1);
                    nextParamUnchainedName = nextParamName.substring(0, nextParamName.indexOf(46));
                }
                if (StringUtils.isBlank((CharSequence)(nextParamDescription = searchParameter.getDescription())) && (paramDef = def.getSearchParam(nextParamUnchainedName)) != null) {
                    nextParamDescription = paramDef.getDescription();
                }
                String finalNextParamUnchainedName = nextParamUnchainedName;
                Conformance.RestResourceSearchParam param = resource.getSearchParam().stream().filter(t -> t.getName().equals(finalNextParamUnchainedName)).findFirst().orElseGet(() -> resource.addSearchParam());
                param.setName(nextParamUnchainedName);
                if (StringUtils.isNotBlank((CharSequence)chain)) {
                    param.addChain(chain);
                } else if (searchParameter.getParamType() == RestSearchParameterTypeEnum.REFERENCE) {
                    for (String nextWhitelist : new TreeSet(searchParameter.getQualifierWhitelist())) {
                        if (!nextWhitelist.startsWith(".")) continue;
                        param.addChain(nextWhitelist.substring(1));
                    }
                }
                param.setDocumentation(nextParamDescription);
                if (searchParameter.getParamType() != null) {
                    param.getTypeElement().setValueAsString(searchParameter.getParamType().getCode());
                }
                for (Class nextTarget : searchParameter.getDeclaredTypes()) {
                    ResourceTypeEnum code;
                    RuntimeResourceDefinition targetDef = this.getServerConfiguration(theRequestDetails).getFhirContext().getResourceDefinition(nextTarget);
                    if (targetDef == null || (code = (ResourceTypeEnum)ResourceTypeEnum.VALUESET_BINDER.fromCodeString(targetDef.getName())) == null) continue;
                    param.addTarget(code);
                }
            }
        }
    }

    @Read(type=OperationDefinition.class)
    public OperationDefinition readOperationDefinition(@IdParam IdDt theId, RequestDetails theRequestDetails) {
        if (theId == null || !theId.hasIdPart()) {
            throw new ResourceNotFoundException(theId);
        }
        RestfulServerConfiguration serverConfiguration = this.getServerConfiguration(theRequestDetails);
        Bindings bindings = serverConfiguration.provideBindings();
        List sharedDescriptions = (List)bindings.getOperationIdToBindings().get(theId.getIdPart());
        if (sharedDescriptions == null || sharedDescriptions.isEmpty()) {
            throw new ResourceNotFoundException(theId);
        }
        OperationDefinition op = new OperationDefinition();
        op.setStatus(ConformanceResourceStatusEnum.ACTIVE);
        op.setKind(OperationKindEnum.OPERATION);
        op.setIdempotent(true);
        HashSet<String> inParams = new HashSet<String>();
        HashSet<String> outParams = new HashSet<String>();
        for (OperationMethodBinding sharedDescription : sharedDescriptions) {
            if (StringUtils.isNotBlank((CharSequence)sharedDescription.getDescription())) {
                op.setDescription(sharedDescription.getDescription());
            }
            if (!sharedDescription.isIdempotent()) {
                op.setIdempotent(sharedDescription.isIdempotent());
            }
            op.setCode(sharedDescription.getName().substring(1));
            if (sharedDescription.isCanOperateAtInstanceLevel()) {
                op.setInstance(sharedDescription.isCanOperateAtInstanceLevel());
            }
            if (sharedDescription.isCanOperateAtServerLevel()) {
                op.setSystem(sharedDescription.isCanOperateAtServerLevel());
            }
            if (StringUtils.isNotBlank((CharSequence)sharedDescription.getResourceName())) {
                op.addType().setValue((Object)sharedDescription.getResourceName());
            }
            for (IParameter nextParamUntyped : sharedDescription.getParameters()) {
                OperationParameter nextParam;
                if (!(nextParamUntyped instanceof OperationParameter) || !inParams.add((nextParam = (OperationParameter)nextParamUntyped).getName())) continue;
                OperationDefinition.Parameter param = op.addParameter();
                param.setUse(OperationParameterUseEnum.IN);
                if (nextParam.getParamType() != null) {
                    param.setType(nextParam.getParamType());
                }
                param.setMin(nextParam.getMin());
                param.setMax(nextParam.getMax() == -1 ? "*" : Integer.toString(nextParam.getMax()));
                param.setName(nextParam.getName());
            }
            for (OperationMethodBinding.ReturnType nextParam : sharedDescription.getReturnParams()) {
                if (!outParams.add(nextParam.getName())) continue;
                OperationDefinition.Parameter param = op.addParameter();
                param.setUse(OperationParameterUseEnum.OUT);
                if (nextParam.getType() != null) {
                    param.setType(nextParam.getType());
                }
                param.setMin(nextParam.getMin());
                param.setMax(nextParam.getMax() == -1 ? "*" : Integer.toString(nextParam.getMax()));
                param.setName(nextParam.getName());
            }
        }
        if (StringUtils.isBlank((CharSequence)op.getName())) {
            if (StringUtils.isNotBlank((CharSequence)op.getDescription())) {
                op.setName(op.getDescription());
            } else {
                op.setName(op.getCode());
            }
        }
        if (op.getSystem() == null) {
            op.setSystem(false);
        }
        if (op.getInstance() == null) {
            op.setInstance(false);
        }
        return op;
    }

    @Deprecated
    public void setCache(boolean theCache) {
    }

    public void setRestfulServer(RestfulServer theRestfulServer) {
    }

    private void sortSearchParameters(List<SearchParameter> searchParameters) {
        Collections.sort(searchParameters, new Comparator<SearchParameter>(){

            @Override
            public int compare(SearchParameter theO1, SearchParameter theO2) {
                if (theO1.isRequired() == theO2.isRequired()) {
                    return theO1.getName().compareTo(theO2.getName());
                }
                if (theO1.isRequired()) {
                    return -1;
                }
                return 1;
            }
        });
    }
}

