/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.AddressDt;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.ContactPointDt;
import ca.uhn.fhir.model.dstu2.composite.HumanNameDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;

@ResourceDef(name="Organization", profile="http://hl7.org/fhir/profiles/Organization", id="organization")
public class Organization
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="name", path="Organization.name", description="A portion of the organization's name", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="phonetic", path="Organization.name", description="A portion of the organization's name using some kind of phonetic matching algorithm", type="string")
    public static final String SP_PHONETIC = "phonetic";
    public static final StringClientParam PHONETIC = new StringClientParam("phonetic");
    @SearchParamDefinition(name="type", path="Organization.type", description="A code for the type of organization", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="identifier", path="Organization.identifier", description="Any identifier for the organization (not the accreditation issuer's identifier)", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="partof", path="Organization.partOf", description="Search all organizations that are part of the given organization", type="reference")
    public static final String SP_PARTOF = "partof";
    public static final ReferenceClientParam PARTOF = new ReferenceClientParam("partof");
    @SearchParamDefinition(name="active", path="Organization.active", description="Whether the organization's record is active", type="token")
    public static final String SP_ACTIVE = "active";
    public static final TokenClientParam ACTIVE = new TokenClientParam("active");
    @SearchParamDefinition(name="address", path="Organization.address", description="A (part of the) address of the Organization", type="string")
    public static final String SP_ADDRESS = "address";
    public static final StringClientParam ADDRESS = new StringClientParam("address");
    @SearchParamDefinition(name="address-city", path="Organization.address.city", description="A city specified in an address", type="string")
    public static final String SP_ADDRESS_CITY = "address-city";
    public static final StringClientParam ADDRESS_CITY = new StringClientParam("address-city");
    @SearchParamDefinition(name="address-state", path="Organization.address.state", description="A state specified in an address", type="string")
    public static final String SP_ADDRESS_STATE = "address-state";
    public static final StringClientParam ADDRESS_STATE = new StringClientParam("address-state");
    @SearchParamDefinition(name="address-postalcode", path="Organization.address.postalCode", description="A postal code specified in an address", type="string")
    public static final String SP_ADDRESS_POSTALCODE = "address-postalcode";
    public static final StringClientParam ADDRESS_POSTALCODE = new StringClientParam("address-postalcode");
    @SearchParamDefinition(name="address-country", path="Organization.address.country", description="A country specified in an address", type="string")
    public static final String SP_ADDRESS_COUNTRY = "address-country";
    public static final StringClientParam ADDRESS_COUNTRY = new StringClientParam("address-country");
    @SearchParamDefinition(name="address-use", path="Organization.address.use", description="A use code specified in an address", type="token")
    public static final String SP_ADDRESS_USE = "address-use";
    public static final TokenClientParam ADDRESS_USE = new TokenClientParam("address-use");
    public static final Include INCLUDE_PARTOF = new Include("Organization:partof");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="id", formalDefinition="Identifier for the organization that is used to identify the organization across multiple disparate systems")
    private List<IdentifierDt> myIdentifier;
    @Child(name="active", type={BooleanDt.class}, order=1, min=0, max=1, summary=true, modifier=true)
    @Description(shortDefinition="status", formalDefinition="Whether the organization's record is still in active use")
    private BooleanDt myActive;
    @Child(name="type", type={CodeableConceptDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="class", formalDefinition="The kind of organization that this is")
    private CodeableConceptDt myType;
    @Child(name="name", type={StringDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A name associated with the organization")
    private StringDt myName;
    @Child(name="telecom", type={ContactPointDt.class}, order=4, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A contact detail for the organization")
    private List<ContactPointDt> myTelecom;
    @Child(name="address", type={AddressDt.class}, order=5, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="An address for the organization")
    private List<AddressDt> myAddress;
    @Child(name="partOf", order=6, min=0, max=1, summary=true, modifier=false, type={Organization.class})
    @Description(shortDefinition="", formalDefinition="The organization of which this organization forms a part")
    private ResourceReferenceDt myPartOf;
    @Child(name="contact", order=7, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="")
    private List<Contact> myContact;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myActive, this.myType, this.myName, this.myTelecom, this.myAddress, this.myPartOf, this.myContact});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myActive, this.myType, this.myName, this.myTelecom, this.myAddress, this.myPartOf, this.myContact});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Organization setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public Organization addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public BooleanDt getActiveElement() {
        if (this.myActive == null) {
            this.myActive = new BooleanDt();
        }
        return this.myActive;
    }

    public Boolean getActive() {
        return (Boolean)this.getActiveElement().getValue();
    }

    public Organization setActive(BooleanDt theValue) {
        this.myActive = theValue;
        return this;
    }

    public Organization setActive(boolean theBoolean) {
        this.myActive = new BooleanDt(theBoolean);
        return this;
    }

    public CodeableConceptDt getType() {
        if (this.myType == null) {
            this.myType = new CodeableConceptDt();
        }
        return this.myType;
    }

    public Organization setType(CodeableConceptDt theValue) {
        this.myType = theValue;
        return this;
    }

    public StringDt getNameElement() {
        if (this.myName == null) {
            this.myName = new StringDt();
        }
        return this.myName;
    }

    public String getName() {
        return (String)this.getNameElement().getValue();
    }

    public Organization setName(StringDt theValue) {
        this.myName = theValue;
        return this;
    }

    public Organization setName(String theString) {
        this.myName = new StringDt(theString);
        return this;
    }

    public List<ContactPointDt> getTelecom() {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactPointDt>();
        }
        return this.myTelecom;
    }

    public Organization setTelecom(List<ContactPointDt> theValue) {
        this.myTelecom = theValue;
        return this;
    }

    public ContactPointDt addTelecom() {
        ContactPointDt newType = new ContactPointDt();
        this.getTelecom().add(newType);
        return newType;
    }

    public Organization addTelecom(ContactPointDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getTelecom().add(theValue);
        return this;
    }

    public ContactPointDt getTelecomFirstRep() {
        if (this.getTelecom().isEmpty()) {
            return this.addTelecom();
        }
        return this.getTelecom().get(0);
    }

    public List<AddressDt> getAddress() {
        if (this.myAddress == null) {
            this.myAddress = new ArrayList<AddressDt>();
        }
        return this.myAddress;
    }

    public Organization setAddress(List<AddressDt> theValue) {
        this.myAddress = theValue;
        return this;
    }

    public AddressDt addAddress() {
        AddressDt newType = new AddressDt();
        this.getAddress().add(newType);
        return newType;
    }

    public Organization addAddress(AddressDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getAddress().add(theValue);
        return this;
    }

    public AddressDt getAddressFirstRep() {
        if (this.getAddress().isEmpty()) {
            return this.addAddress();
        }
        return this.getAddress().get(0);
    }

    public ResourceReferenceDt getPartOf() {
        if (this.myPartOf == null) {
            this.myPartOf = new ResourceReferenceDt();
        }
        return this.myPartOf;
    }

    public Organization setPartOf(ResourceReferenceDt theValue) {
        this.myPartOf = theValue;
        return this;
    }

    public List<Contact> getContact() {
        if (this.myContact == null) {
            this.myContact = new ArrayList<Contact>();
        }
        return this.myContact;
    }

    public Organization setContact(List<Contact> theValue) {
        this.myContact = theValue;
        return this;
    }

    public Contact addContact() {
        Contact newType = new Contact();
        this.getContact().add(newType);
        return newType;
    }

    public Organization addContact(Contact theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getContact().add(theValue);
        return this;
    }

    public Contact getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            return this.addContact();
        }
        return this.getContact().get(0);
    }

    public String getResourceName() {
        return "Organization";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Contact
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="purpose", type={CodeableConceptDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Indicates a purpose for which the contact can be reached")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/valueset-contactentity-type")
        private CodeableConceptDt myPurpose;
        @Child(name="name", type={HumanNameDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A name associated with the contact")
        private HumanNameDt myName;
        @Child(name="telecom", type={ContactPointDt.class}, order=2, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A contact detail (e.g. a telephone number or an email address) by which the party may be contacted.")
        private List<ContactPointDt> myTelecom;
        @Child(name="address", type={AddressDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Visiting or postal addresses for the contact")
        private AddressDt myAddress;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myPurpose, this.myName, this.myTelecom, this.myAddress});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myPurpose, this.myName, this.myTelecom, this.myAddress});
        }

        public CodeableConceptDt getPurpose() {
            if (this.myPurpose == null) {
                this.myPurpose = new CodeableConceptDt();
            }
            return this.myPurpose;
        }

        public Contact setPurpose(CodeableConceptDt theValue) {
            this.myPurpose = theValue;
            return this;
        }

        public HumanNameDt getName() {
            if (this.myName == null) {
                this.myName = new HumanNameDt();
            }
            return this.myName;
        }

        public Contact setName(HumanNameDt theValue) {
            this.myName = theValue;
            return this;
        }

        public List<ContactPointDt> getTelecom() {
            if (this.myTelecom == null) {
                this.myTelecom = new ArrayList<ContactPointDt>();
            }
            return this.myTelecom;
        }

        public Contact setTelecom(List<ContactPointDt> theValue) {
            this.myTelecom = theValue;
            return this;
        }

        public ContactPointDt addTelecom() {
            ContactPointDt newType = new ContactPointDt();
            this.getTelecom().add(newType);
            return newType;
        }

        public Contact addTelecom(ContactPointDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getTelecom().add(theValue);
            return this;
        }

        public ContactPointDt getTelecomFirstRep() {
            if (this.getTelecom().isEmpty()) {
                return this.addTelecom();
            }
            return this.getTelecom().get(0);
        }

        public AddressDt getAddress() {
            if (this.myAddress == null) {
                this.myAddress = new AddressDt();
            }
            return this.myAddress;
        }

        public Contact setAddress(AddressDt theValue) {
            this.myAddress = theValue;
            return this;
        }
    }
}

