/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum IdentifierTypeCodesEnum {
    UNIVERSAL_DEVICE_IDENTIFIER("UDI", "http://hl7.org/fhir/identifier-type"),
    SERIAL_NUMBER("SNO", "http://hl7.org/fhir/identifier-type"),
    SOCIAL_BENEFICIARY_IDENTIFIER("SB", "http://hl7.org/fhir/identifier-type"),
    PLACER_IDENTIFIER("PLAC", "http://hl7.org/fhir/identifier-type"),
    FILLER_IDENTIFIER("FILL", "http://hl7.org/fhir/identifier-type"),
    DL("DL", "http://hl7.org/fhir/v2/0203"),
    PPN("PPN", "http://hl7.org/fhir/v2/0203"),
    BRN("BRN", "http://hl7.org/fhir/v2/0203"),
    MR("MR", "http://hl7.org/fhir/v2/0203"),
    MCN("MCN", "http://hl7.org/fhir/v2/0203"),
    EN("EN", "http://hl7.org/fhir/v2/0203"),
    TAX("TAX", "http://hl7.org/fhir/v2/0203"),
    NIIP("NIIP", "http://hl7.org/fhir/v2/0203"),
    PRN("PRN", "http://hl7.org/fhir/v2/0203"),
    MD("MD", "http://hl7.org/fhir/v2/0203"),
    DR("DR", "http://hl7.org/fhir/v2/0203");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "Identifier Type Codes";
    private static Map<String, IdentifierTypeCodesEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, IdentifierTypeCodesEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<IdentifierTypeCodesEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static IdentifierTypeCodesEnum forCode(String theCode) {
        IdentifierTypeCodesEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private IdentifierTypeCodesEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, IdentifierTypeCodesEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, IdentifierTypeCodesEnum>>();
        for (IdentifierTypeCodesEnum next : IdentifierTypeCodesEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<IdentifierTypeCodesEnum>(){

            public String toCodeString(IdentifierTypeCodesEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(IdentifierTypeCodesEnum theEnum) {
                return theEnum.getSystem();
            }

            public IdentifierTypeCodesEnum fromCodeString(String theCodeString) {
                return (IdentifierTypeCodesEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public IdentifierTypeCodesEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (IdentifierTypeCodesEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

