/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum BundleTypeEnum {
    DOCUMENT("document", "http://hl7.org/fhir/bundle-type"),
    MESSAGE("message", "http://hl7.org/fhir/bundle-type"),
    TRANSACTION("transaction", "http://hl7.org/fhir/bundle-type"),
    TRANSACTION_RESPONSE("transaction-response", "http://hl7.org/fhir/bundle-type"),
    BATCH("batch", "http://hl7.org/fhir/bundle-type"),
    BATCH_RESPONSE("batch-response", "http://hl7.org/fhir/bundle-type"),
    HISTORY_LIST("history", "http://hl7.org/fhir/bundle-type"),
    SEARCH_RESULTS("searchset", "http://hl7.org/fhir/bundle-type"),
    COLLECTION("collection", "http://hl7.org/fhir/bundle-type");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "BundleType";
    private static Map<String, BundleTypeEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, BundleTypeEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<BundleTypeEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static BundleTypeEnum forCode(String theCode) {
        BundleTypeEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private BundleTypeEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, BundleTypeEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, BundleTypeEnum>>();
        for (BundleTypeEnum next : BundleTypeEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<BundleTypeEnum>(){

            public String toCodeString(BundleTypeEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(BundleTypeEnum theEnum) {
                return theEnum.getSystem();
            }

            public BundleTypeEnum fromCodeString(String theCodeString) {
                return (BundleTypeEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public BundleTypeEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (BundleTypeEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

