/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.composite;

import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.ICompositeDatatype;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.dstu2.composite.CodingDt;
import ca.uhn.fhir.model.dstu2.resource.Device;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.resource.RelatedPerson;
import ca.uhn.fhir.model.primitive.Base64BinaryDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@DatatypeDef(name="Signature")
public class SignatureDt
extends BaseIdentifiableElement
implements ICompositeDatatype {
    @Child(name="type", type={CodingDt.class}, order=0, min=1, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="An indication of the reason that the entity signed this document. This may be explicitly included as part of the signature information and can be used when determining accountability for various actions concerning the document.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/valueset-signature-type")
    private List<CodingDt> myType;
    @Child(name="when", type={InstantDt.class}, order=1, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="When the digital signature was signed.")
    private InstantDt myWhen;
    @Child(name="who", order=2, min=1, max=1, summary=true, modifier=false, type={UriDt.class, Practitioner.class, RelatedPerson.class, Patient.class, Device.class, Organization.class})
    @Description(shortDefinition="", formalDefinition="A reference to an application-usable description of the person that signed the certificate (e.g. the signature used their private key)")
    private IDatatype myWho;
    @Child(name="contentType", type={CodeDt.class}, order=3, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A mime type that indicates the technical format of the signature. Important mime types are application/signature+xml for X ML DigSig, application/jwt for JWT, and image/* for a graphical image of a signature")
    private CodeDt myContentType;
    @Child(name="blob", type={Base64BinaryDt.class}, order=4, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The base64 encoding of the Signature content")
    private Base64BinaryDt myBlob;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myType, this.myWhen, this.myWho, this.myContentType, this.myBlob});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.myWhen, this.myWho, this.myContentType, this.myBlob});
    }

    public List<CodingDt> getType() {
        if (this.myType == null) {
            this.myType = new ArrayList<CodingDt>();
        }
        return this.myType;
    }

    public SignatureDt setType(List<CodingDt> theValue) {
        this.myType = theValue;
        return this;
    }

    public CodingDt addType() {
        CodingDt newType = new CodingDt();
        this.getType().add(newType);
        return newType;
    }

    public SignatureDt addType(CodingDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getType().add(theValue);
        return this;
    }

    public CodingDt getTypeFirstRep() {
        if (this.getType().isEmpty()) {
            return this.addType();
        }
        return this.getType().get(0);
    }

    public InstantDt getWhenElement() {
        if (this.myWhen == null) {
            this.myWhen = new InstantDt();
        }
        return this.myWhen;
    }

    public Date getWhen() {
        return (Date)this.getWhenElement().getValue();
    }

    public SignatureDt setWhen(InstantDt theValue) {
        this.myWhen = theValue;
        return this;
    }

    public SignatureDt setWhenWithMillisPrecision(Date theDate) {
        this.myWhen = new InstantDt(theDate);
        return this;
    }

    public SignatureDt setWhen(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myWhen = new InstantDt(theDate, thePrecision);
        return this;
    }

    public IDatatype getWho() {
        return this.myWho;
    }

    public SignatureDt setWho(IDatatype theValue) {
        this.myWho = theValue;
        return this;
    }

    public CodeDt getContentTypeElement() {
        if (this.myContentType == null) {
            this.myContentType = new CodeDt();
        }
        return this.myContentType;
    }

    public String getContentType() {
        return (String)this.getContentTypeElement().getValue();
    }

    public SignatureDt setContentType(CodeDt theValue) {
        this.myContentType = theValue;
        return this;
    }

    public SignatureDt setContentType(String theCode) {
        this.myContentType = new CodeDt(theCode);
        return this;
    }

    public Base64BinaryDt getBlobElement() {
        if (this.myBlob == null) {
            this.myBlob = new Base64BinaryDt();
        }
        return this.myBlob;
    }

    public byte[] getBlob() {
        return (byte[])this.getBlobElement().getValue();
    }

    public SignatureDt setBlob(Base64BinaryDt theValue) {
        this.myBlob = theValue;
        return this;
    }

    public SignatureDt setBlob(byte[] theBytes) {
        this.myBlob = new Base64BinaryDt(theBytes);
        return this;
    }
}

