/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.AttachmentDt;
import ca.uhn.fhir.model.dstu2.composite.BoundCodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.ContactPointDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.PeriodDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Location;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.valueset.DaysOfWeekEnum;
import ca.uhn.fhir.model.dstu2.valueset.ReferralMethodEnum;
import ca.uhn.fhir.model.dstu2.valueset.ServiceProvisionConditionsEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.TimeDt;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;

@ResourceDef(name="HealthcareService", profile="http://hl7.org/fhir/profiles/HealthcareService", id="healthcareservice")
public class HealthcareService
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="identifier", path="HealthcareService.identifier", description="", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="servicecategory", path="HealthcareService.serviceCategory", description="Service Category of the Healthcare Service", type="token")
    public static final String SP_SERVICECATEGORY = "servicecategory";
    public static final TokenClientParam SERVICECATEGORY = new TokenClientParam("servicecategory");
    @SearchParamDefinition(name="servicetype", path="HealthcareService.serviceType.type", description="The type of service provided by this healthcare service", type="token")
    public static final String SP_SERVICETYPE = "servicetype";
    public static final TokenClientParam SERVICETYPE = new TokenClientParam("servicetype");
    @SearchParamDefinition(name="name", path="HealthcareService.serviceName", description="A portion of the Healthcare service name", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="location", path="HealthcareService.location", description="The location of the Healthcare Service", type="reference")
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    @SearchParamDefinition(name="organization", path="HealthcareService.providedBy", description="The organization that provides this Healthcare Service", type="reference")
    public static final String SP_ORGANIZATION = "organization";
    public static final ReferenceClientParam ORGANIZATION = new ReferenceClientParam("organization");
    @SearchParamDefinition(name="programname", path="HealthcareService.programName", description="One of the Program Names serviced by this HealthcareService", type="string")
    public static final String SP_PROGRAMNAME = "programname";
    public static final StringClientParam PROGRAMNAME = new StringClientParam("programname");
    @SearchParamDefinition(name="characteristic", path="HealthcareService.characteristic", description="One of the HealthcareService's characteristics", type="token")
    public static final String SP_CHARACTERISTIC = "characteristic";
    public static final TokenClientParam CHARACTERISTIC = new TokenClientParam("characteristic");
    public static final Include INCLUDE_LOCATION = new Include("HealthcareService:location");
    public static final Include INCLUDE_ORGANIZATION = new Include("HealthcareService:organization");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="id", formalDefinition="External identifiers for this item")
    private List<IdentifierDt> myIdentifier;
    @Child(name="providedBy", order=1, min=0, max=1, summary=true, modifier=false, type={Organization.class})
    @Description(shortDefinition="", formalDefinition="The organization that provides this healthcare service")
    private ResourceReferenceDt myProvidedBy;
    @Child(name="serviceCategory", type={CodeableConceptDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="class", formalDefinition="Identifies the broad category of service being performed or delivered")
    private CodeableConceptDt myServiceCategory;
    @Child(name="serviceType", order=3, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A specific type of service that may be delivered or performed")
    private List<ServiceType> myServiceType;
    @Child(name="location", order=4, min=1, max=1, summary=true, modifier=false, type={Location.class})
    @Description(shortDefinition="where", formalDefinition="The location where this healthcare service may be provided")
    private ResourceReferenceDt myLocation;
    @Child(name="serviceName", type={StringDt.class}, order=5, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Further description of the service as it would be presented to a consumer while searching")
    private StringDt myServiceName;
    @Child(name="comment", type={StringDt.class}, order=6, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Any additional description of the service and/or any specific issues not covered by the other attributes, which can be displayed as further detail under the serviceName")
    private StringDt myComment;
    @Child(name="extraDetails", type={StringDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Extra details about the service that can't be placed in the other fields")
    private StringDt myExtraDetails;
    @Child(name="photo", type={AttachmentDt.class}, order=8, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="If there is a photo/symbol associated with this HealthcareService, it may be included here to facilitate quick identification of the service in a list")
    private AttachmentDt myPhoto;
    @Child(name="telecom", type={ContactPointDt.class}, order=9, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="List of contacts related to this specific healthcare service")
    private List<ContactPointDt> myTelecom;
    @Child(name="coverageArea", order=10, min=0, max=-1, summary=false, modifier=false, type={Location.class})
    @Description(shortDefinition="", formalDefinition="The location(s) that this service is available to (not where the service is provided)")
    private List<ResourceReferenceDt> myCoverageArea;
    @Child(name="serviceProvisionCode", type={CodeableConceptDt.class}, order=11, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The code(s) that detail the conditions under which the healthcare service is available/offered")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-provision-conditions")
    private List<BoundCodeableConceptDt<ServiceProvisionConditionsEnum>> myServiceProvisionCode;
    @Child(name="eligibility", type={CodeableConceptDt.class}, order=12, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Does this service have specific eligibility requirements that need to be met in order to use the service?")
    private CodeableConceptDt myEligibility;
    @Child(name="eligibilityNote", type={StringDt.class}, order=13, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Describes the eligibility conditions for the service")
    private StringDt myEligibilityNote;
    @Child(name="programName", type={StringDt.class}, order=14, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Program Names that can be used to categorize the service")
    private List<StringDt> myProgramName;
    @Child(name="characteristic", type={CodeableConceptDt.class}, order=15, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Collection of characteristics (attributes)")
    private List<CodeableConceptDt> myCharacteristic;
    @Child(name="referralMethod", type={CodeableConceptDt.class}, order=16, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Ways that the service accepts referrals, if this is not provided then it is implied that no referral is required")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-referral-method")
    private List<BoundCodeableConceptDt<ReferralMethodEnum>> myReferralMethod;
    @Child(name="publicKey", type={StringDt.class}, order=17, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The public part of the 'keys' allocated to an Organization by an accredited body to support secure exchange of data over the internet. To be provided by the Organization, where available")
    private StringDt myPublicKey;
    @Child(name="appointmentRequired", type={BooleanDt.class}, order=18, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Indicates whether or not a prospective consumer will require an appointment for a particular service at a site to be provided by the Organization. Indicates if an appointment is required for access to this service.")
    private BooleanDt myAppointmentRequired;
    @Child(name="availableTime", order=19, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A collection of times that the Service Site is available")
    private List<AvailableTime> myAvailableTime;
    @Child(name="notAvailable", order=20, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The HealthcareService is not available during this period of time due to the provided reason")
    private List<NotAvailable> myNotAvailable;
    @Child(name="availabilityExceptions", type={StringDt.class}, order=21, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A description of site availability exceptions, e.g. public holiday availability. Succinctly describing all possible exceptions to normal site availability as details in the available Times and not available Times")
    private StringDt myAvailabilityExceptions;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myProvidedBy, this.myServiceCategory, this.myServiceType, this.myLocation, this.myServiceName, this.myComment, this.myExtraDetails, this.myPhoto, this.myTelecom, this.myCoverageArea, this.myServiceProvisionCode, this.myEligibility, this.myEligibilityNote, this.myProgramName, this.myCharacteristic, this.myReferralMethod, this.myPublicKey, this.myAppointmentRequired, this.myAvailableTime, this.myNotAvailable, this.myAvailabilityExceptions});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myProvidedBy, this.myServiceCategory, this.myServiceType, this.myLocation, this.myServiceName, this.myComment, this.myExtraDetails, this.myPhoto, this.myTelecom, this.myCoverageArea, this.myServiceProvisionCode, this.myEligibility, this.myEligibilityNote, this.myProgramName, this.myCharacteristic, this.myReferralMethod, this.myPublicKey, this.myAppointmentRequired, this.myAvailableTime, this.myNotAvailable, this.myAvailabilityExceptions});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public HealthcareService setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public HealthcareService addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public ResourceReferenceDt getProvidedBy() {
        if (this.myProvidedBy == null) {
            this.myProvidedBy = new ResourceReferenceDt();
        }
        return this.myProvidedBy;
    }

    public HealthcareService setProvidedBy(ResourceReferenceDt theValue) {
        this.myProvidedBy = theValue;
        return this;
    }

    public CodeableConceptDt getServiceCategory() {
        if (this.myServiceCategory == null) {
            this.myServiceCategory = new CodeableConceptDt();
        }
        return this.myServiceCategory;
    }

    public HealthcareService setServiceCategory(CodeableConceptDt theValue) {
        this.myServiceCategory = theValue;
        return this;
    }

    public List<ServiceType> getServiceType() {
        if (this.myServiceType == null) {
            this.myServiceType = new ArrayList<ServiceType>();
        }
        return this.myServiceType;
    }

    public HealthcareService setServiceType(List<ServiceType> theValue) {
        this.myServiceType = theValue;
        return this;
    }

    public ServiceType addServiceType() {
        ServiceType newType = new ServiceType();
        this.getServiceType().add(newType);
        return newType;
    }

    public HealthcareService addServiceType(ServiceType theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getServiceType().add(theValue);
        return this;
    }

    public ServiceType getServiceTypeFirstRep() {
        if (this.getServiceType().isEmpty()) {
            return this.addServiceType();
        }
        return this.getServiceType().get(0);
    }

    public ResourceReferenceDt getLocation() {
        if (this.myLocation == null) {
            this.myLocation = new ResourceReferenceDt();
        }
        return this.myLocation;
    }

    public HealthcareService setLocation(ResourceReferenceDt theValue) {
        this.myLocation = theValue;
        return this;
    }

    public StringDt getServiceNameElement() {
        if (this.myServiceName == null) {
            this.myServiceName = new StringDt();
        }
        return this.myServiceName;
    }

    public String getServiceName() {
        return (String)this.getServiceNameElement().getValue();
    }

    public HealthcareService setServiceName(StringDt theValue) {
        this.myServiceName = theValue;
        return this;
    }

    public HealthcareService setServiceName(String theString) {
        this.myServiceName = new StringDt(theString);
        return this;
    }

    public StringDt getCommentElement() {
        if (this.myComment == null) {
            this.myComment = new StringDt();
        }
        return this.myComment;
    }

    public String getComment() {
        return (String)this.getCommentElement().getValue();
    }

    public HealthcareService setComment(StringDt theValue) {
        this.myComment = theValue;
        return this;
    }

    public HealthcareService setComment(String theString) {
        this.myComment = new StringDt(theString);
        return this;
    }

    public StringDt getExtraDetailsElement() {
        if (this.myExtraDetails == null) {
            this.myExtraDetails = new StringDt();
        }
        return this.myExtraDetails;
    }

    public String getExtraDetails() {
        return (String)this.getExtraDetailsElement().getValue();
    }

    public HealthcareService setExtraDetails(StringDt theValue) {
        this.myExtraDetails = theValue;
        return this;
    }

    public HealthcareService setExtraDetails(String theString) {
        this.myExtraDetails = new StringDt(theString);
        return this;
    }

    public AttachmentDt getPhoto() {
        if (this.myPhoto == null) {
            this.myPhoto = new AttachmentDt();
        }
        return this.myPhoto;
    }

    public HealthcareService setPhoto(AttachmentDt theValue) {
        this.myPhoto = theValue;
        return this;
    }

    public List<ContactPointDt> getTelecom() {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactPointDt>();
        }
        return this.myTelecom;
    }

    public HealthcareService setTelecom(List<ContactPointDt> theValue) {
        this.myTelecom = theValue;
        return this;
    }

    public ContactPointDt addTelecom() {
        ContactPointDt newType = new ContactPointDt();
        this.getTelecom().add(newType);
        return newType;
    }

    public HealthcareService addTelecom(ContactPointDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getTelecom().add(theValue);
        return this;
    }

    public ContactPointDt getTelecomFirstRep() {
        if (this.getTelecom().isEmpty()) {
            return this.addTelecom();
        }
        return this.getTelecom().get(0);
    }

    public List<ResourceReferenceDt> getCoverageArea() {
        if (this.myCoverageArea == null) {
            this.myCoverageArea = new ArrayList<ResourceReferenceDt>();
        }
        return this.myCoverageArea;
    }

    public HealthcareService setCoverageArea(List<ResourceReferenceDt> theValue) {
        this.myCoverageArea = theValue;
        return this;
    }

    public ResourceReferenceDt addCoverageArea() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getCoverageArea().add(newType);
        return newType;
    }

    public List<BoundCodeableConceptDt<ServiceProvisionConditionsEnum>> getServiceProvisionCode() {
        if (this.myServiceProvisionCode == null) {
            this.myServiceProvisionCode = new ArrayList<BoundCodeableConceptDt<ServiceProvisionConditionsEnum>>();
        }
        return this.myServiceProvisionCode;
    }

    public HealthcareService setServiceProvisionCode(List<BoundCodeableConceptDt<ServiceProvisionConditionsEnum>> theValue) {
        this.myServiceProvisionCode = theValue;
        return this;
    }

    public BoundCodeableConceptDt<ServiceProvisionConditionsEnum> addServiceProvisionCode(ServiceProvisionConditionsEnum theValue) {
        BoundCodeableConceptDt<ServiceProvisionConditionsEnum> retVal = new BoundCodeableConceptDt<ServiceProvisionConditionsEnum>(ServiceProvisionConditionsEnum.VALUESET_BINDER, theValue);
        this.getServiceProvisionCode().add(retVal);
        return retVal;
    }

    public BoundCodeableConceptDt<ServiceProvisionConditionsEnum> getServiceProvisionCodeFirstRep() {
        if (this.getServiceProvisionCode().size() == 0) {
            this.addServiceProvisionCode();
        }
        return this.getServiceProvisionCode().get(0);
    }

    public BoundCodeableConceptDt<ServiceProvisionConditionsEnum> addServiceProvisionCode() {
        BoundCodeableConceptDt<ServiceProvisionConditionsEnum> retVal = new BoundCodeableConceptDt<ServiceProvisionConditionsEnum>(ServiceProvisionConditionsEnum.VALUESET_BINDER);
        this.getServiceProvisionCode().add(retVal);
        return retVal;
    }

    public HealthcareService setServiceProvisionCode(ServiceProvisionConditionsEnum theValue) {
        this.getServiceProvisionCode().clear();
        this.addServiceProvisionCode(theValue);
        return this;
    }

    public CodeableConceptDt getEligibility() {
        if (this.myEligibility == null) {
            this.myEligibility = new CodeableConceptDt();
        }
        return this.myEligibility;
    }

    public HealthcareService setEligibility(CodeableConceptDt theValue) {
        this.myEligibility = theValue;
        return this;
    }

    public StringDt getEligibilityNoteElement() {
        if (this.myEligibilityNote == null) {
            this.myEligibilityNote = new StringDt();
        }
        return this.myEligibilityNote;
    }

    public String getEligibilityNote() {
        return (String)this.getEligibilityNoteElement().getValue();
    }

    public HealthcareService setEligibilityNote(StringDt theValue) {
        this.myEligibilityNote = theValue;
        return this;
    }

    public HealthcareService setEligibilityNote(String theString) {
        this.myEligibilityNote = new StringDt(theString);
        return this;
    }

    public List<StringDt> getProgramName() {
        if (this.myProgramName == null) {
            this.myProgramName = new ArrayList<StringDt>();
        }
        return this.myProgramName;
    }

    public HealthcareService setProgramName(List<StringDt> theValue) {
        this.myProgramName = theValue;
        return this;
    }

    public StringDt addProgramName() {
        StringDt newType = new StringDt();
        this.getProgramName().add(newType);
        return newType;
    }

    public HealthcareService addProgramName(StringDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getProgramName().add(theValue);
        return this;
    }

    public StringDt getProgramNameFirstRep() {
        if (this.getProgramName().isEmpty()) {
            return this.addProgramName();
        }
        return this.getProgramName().get(0);
    }

    public HealthcareService addProgramName(String theString) {
        if (this.myProgramName == null) {
            this.myProgramName = new ArrayList<StringDt>();
        }
        this.myProgramName.add(new StringDt(theString));
        return this;
    }

    public List<CodeableConceptDt> getCharacteristic() {
        if (this.myCharacteristic == null) {
            this.myCharacteristic = new ArrayList<CodeableConceptDt>();
        }
        return this.myCharacteristic;
    }

    public HealthcareService setCharacteristic(List<CodeableConceptDt> theValue) {
        this.myCharacteristic = theValue;
        return this;
    }

    public CodeableConceptDt addCharacteristic() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getCharacteristic().add(newType);
        return newType;
    }

    public HealthcareService addCharacteristic(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getCharacteristic().add(theValue);
        return this;
    }

    public CodeableConceptDt getCharacteristicFirstRep() {
        if (this.getCharacteristic().isEmpty()) {
            return this.addCharacteristic();
        }
        return this.getCharacteristic().get(0);
    }

    public List<BoundCodeableConceptDt<ReferralMethodEnum>> getReferralMethod() {
        if (this.myReferralMethod == null) {
            this.myReferralMethod = new ArrayList<BoundCodeableConceptDt<ReferralMethodEnum>>();
        }
        return this.myReferralMethod;
    }

    public HealthcareService setReferralMethod(List<BoundCodeableConceptDt<ReferralMethodEnum>> theValue) {
        this.myReferralMethod = theValue;
        return this;
    }

    public BoundCodeableConceptDt<ReferralMethodEnum> addReferralMethod(ReferralMethodEnum theValue) {
        BoundCodeableConceptDt<ReferralMethodEnum> retVal = new BoundCodeableConceptDt<ReferralMethodEnum>(ReferralMethodEnum.VALUESET_BINDER, theValue);
        this.getReferralMethod().add(retVal);
        return retVal;
    }

    public BoundCodeableConceptDt<ReferralMethodEnum> getReferralMethodFirstRep() {
        if (this.getReferralMethod().size() == 0) {
            this.addReferralMethod();
        }
        return this.getReferralMethod().get(0);
    }

    public BoundCodeableConceptDt<ReferralMethodEnum> addReferralMethod() {
        BoundCodeableConceptDt<ReferralMethodEnum> retVal = new BoundCodeableConceptDt<ReferralMethodEnum>(ReferralMethodEnum.VALUESET_BINDER);
        this.getReferralMethod().add(retVal);
        return retVal;
    }

    public HealthcareService setReferralMethod(ReferralMethodEnum theValue) {
        this.getReferralMethod().clear();
        this.addReferralMethod(theValue);
        return this;
    }

    public StringDt getPublicKeyElement() {
        if (this.myPublicKey == null) {
            this.myPublicKey = new StringDt();
        }
        return this.myPublicKey;
    }

    public String getPublicKey() {
        return (String)this.getPublicKeyElement().getValue();
    }

    public HealthcareService setPublicKey(StringDt theValue) {
        this.myPublicKey = theValue;
        return this;
    }

    public HealthcareService setPublicKey(String theString) {
        this.myPublicKey = new StringDt(theString);
        return this;
    }

    public BooleanDt getAppointmentRequiredElement() {
        if (this.myAppointmentRequired == null) {
            this.myAppointmentRequired = new BooleanDt();
        }
        return this.myAppointmentRequired;
    }

    public Boolean getAppointmentRequired() {
        return (Boolean)this.getAppointmentRequiredElement().getValue();
    }

    public HealthcareService setAppointmentRequired(BooleanDt theValue) {
        this.myAppointmentRequired = theValue;
        return this;
    }

    public HealthcareService setAppointmentRequired(boolean theBoolean) {
        this.myAppointmentRequired = new BooleanDt(theBoolean);
        return this;
    }

    public List<AvailableTime> getAvailableTime() {
        if (this.myAvailableTime == null) {
            this.myAvailableTime = new ArrayList<AvailableTime>();
        }
        return this.myAvailableTime;
    }

    public HealthcareService setAvailableTime(List<AvailableTime> theValue) {
        this.myAvailableTime = theValue;
        return this;
    }

    public AvailableTime addAvailableTime() {
        AvailableTime newType = new AvailableTime();
        this.getAvailableTime().add(newType);
        return newType;
    }

    public HealthcareService addAvailableTime(AvailableTime theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getAvailableTime().add(theValue);
        return this;
    }

    public AvailableTime getAvailableTimeFirstRep() {
        if (this.getAvailableTime().isEmpty()) {
            return this.addAvailableTime();
        }
        return this.getAvailableTime().get(0);
    }

    public List<NotAvailable> getNotAvailable() {
        if (this.myNotAvailable == null) {
            this.myNotAvailable = new ArrayList<NotAvailable>();
        }
        return this.myNotAvailable;
    }

    public HealthcareService setNotAvailable(List<NotAvailable> theValue) {
        this.myNotAvailable = theValue;
        return this;
    }

    public NotAvailable addNotAvailable() {
        NotAvailable newType = new NotAvailable();
        this.getNotAvailable().add(newType);
        return newType;
    }

    public HealthcareService addNotAvailable(NotAvailable theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getNotAvailable().add(theValue);
        return this;
    }

    public NotAvailable getNotAvailableFirstRep() {
        if (this.getNotAvailable().isEmpty()) {
            return this.addNotAvailable();
        }
        return this.getNotAvailable().get(0);
    }

    public StringDt getAvailabilityExceptionsElement() {
        if (this.myAvailabilityExceptions == null) {
            this.myAvailabilityExceptions = new StringDt();
        }
        return this.myAvailabilityExceptions;
    }

    public String getAvailabilityExceptions() {
        return (String)this.getAvailabilityExceptionsElement().getValue();
    }

    public HealthcareService setAvailabilityExceptions(StringDt theValue) {
        this.myAvailabilityExceptions = theValue;
        return this;
    }

    public HealthcareService setAvailabilityExceptions(String theString) {
        this.myAvailabilityExceptions = new StringDt(theString);
        return this;
    }

    public String getResourceName() {
        return "HealthcareService";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class NotAvailable
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="description", type={StringDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The reason that can be presented to the user as to why this time is not available")
        private StringDt myDescription;
        @Child(name="during", type={PeriodDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Service is not available (seasonally or for a public holiday) from this date")
        private PeriodDt myDuring;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myDescription, this.myDuring});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myDescription, this.myDuring});
        }

        public StringDt getDescriptionElement() {
            if (this.myDescription == null) {
                this.myDescription = new StringDt();
            }
            return this.myDescription;
        }

        public String getDescription() {
            return (String)this.getDescriptionElement().getValue();
        }

        public NotAvailable setDescription(StringDt theValue) {
            this.myDescription = theValue;
            return this;
        }

        public NotAvailable setDescription(String theString) {
            this.myDescription = new StringDt(theString);
            return this;
        }

        public PeriodDt getDuring() {
            if (this.myDuring == null) {
                this.myDuring = new PeriodDt();
            }
            return this.myDuring;
        }

        public NotAvailable setDuring(PeriodDt theValue) {
            this.myDuring = theValue;
            return this;
        }
    }

    @Block
    public static class AvailableTime
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="daysOfWeek", type={CodeDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Indicates which days of the week are available between the start and end Times")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/days-of-week")
        private List<BoundCodeDt<DaysOfWeekEnum>> myDaysOfWeek;
        @Child(name="allDay", type={BooleanDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Is this always available? (hence times are irrelevant) e.g. 24 hour service")
        private BooleanDt myAllDay;
        @Child(name="availableStartTime", type={TimeDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The opening time of day. Note: If the AllDay flag is set, then this time is ignored")
        private TimeDt myAvailableStartTime;
        @Child(name="availableEndTime", type={TimeDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The closing time of day. Note: If the AllDay flag is set, then this time is ignored")
        private TimeDt myAvailableEndTime;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myDaysOfWeek, this.myAllDay, this.myAvailableStartTime, this.myAvailableEndTime});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myDaysOfWeek, this.myAllDay, this.myAvailableStartTime, this.myAvailableEndTime});
        }

        public List<BoundCodeDt<DaysOfWeekEnum>> getDaysOfWeek() {
            if (this.myDaysOfWeek == null) {
                this.myDaysOfWeek = new ArrayList<BoundCodeDt<DaysOfWeekEnum>>();
            }
            return this.myDaysOfWeek;
        }

        public AvailableTime setDaysOfWeek(List<BoundCodeDt<DaysOfWeekEnum>> theValue) {
            this.myDaysOfWeek = theValue;
            return this;
        }

        public BoundCodeDt<DaysOfWeekEnum> addDaysOfWeek(DaysOfWeekEnum theValue) {
            BoundCodeDt retVal = new BoundCodeDt(DaysOfWeekEnum.VALUESET_BINDER, (Enum)theValue);
            this.getDaysOfWeek().add((BoundCodeDt<DaysOfWeekEnum>)retVal);
            return retVal;
        }

        public BoundCodeDt<DaysOfWeekEnum> getDaysOfWeekFirstRep() {
            if (this.getDaysOfWeek().size() == 0) {
                this.addDaysOfWeek();
            }
            return this.getDaysOfWeek().get(0);
        }

        public BoundCodeDt<DaysOfWeekEnum> addDaysOfWeek() {
            BoundCodeDt retVal = new BoundCodeDt(DaysOfWeekEnum.VALUESET_BINDER);
            this.getDaysOfWeek().add((BoundCodeDt<DaysOfWeekEnum>)retVal);
            return retVal;
        }

        public AvailableTime setDaysOfWeek(DaysOfWeekEnum theValue) {
            this.getDaysOfWeek().clear();
            this.addDaysOfWeek(theValue);
            return this;
        }

        public BooleanDt getAllDayElement() {
            if (this.myAllDay == null) {
                this.myAllDay = new BooleanDt();
            }
            return this.myAllDay;
        }

        public Boolean getAllDay() {
            return (Boolean)this.getAllDayElement().getValue();
        }

        public AvailableTime setAllDay(BooleanDt theValue) {
            this.myAllDay = theValue;
            return this;
        }

        public AvailableTime setAllDay(boolean theBoolean) {
            this.myAllDay = new BooleanDt(theBoolean);
            return this;
        }

        public TimeDt getAvailableStartTimeElement() {
            if (this.myAvailableStartTime == null) {
                this.myAvailableStartTime = new TimeDt();
            }
            return this.myAvailableStartTime;
        }

        public String getAvailableStartTime() {
            return (String)this.getAvailableStartTimeElement().getValue();
        }

        public AvailableTime setAvailableStartTime(TimeDt theValue) {
            this.myAvailableStartTime = theValue;
            return this;
        }

        public AvailableTime setAvailableStartTime(String theString) {
            this.myAvailableStartTime = new TimeDt(theString);
            return this;
        }

        public TimeDt getAvailableEndTimeElement() {
            if (this.myAvailableEndTime == null) {
                this.myAvailableEndTime = new TimeDt();
            }
            return this.myAvailableEndTime;
        }

        public String getAvailableEndTime() {
            return (String)this.getAvailableEndTimeElement().getValue();
        }

        public AvailableTime setAvailableEndTime(TimeDt theValue) {
            this.myAvailableEndTime = theValue;
            return this;
        }

        public AvailableTime setAvailableEndTime(String theString) {
            this.myAvailableEndTime = new TimeDt(theString);
            return this;
        }
    }

    @Block
    public static class ServiceType
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="type", type={CodeableConceptDt.class}, order=0, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The specific type of service being delivered or performed")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/c80-practice-codes")
        private CodeableConceptDt myType;
        @Child(name="specialty", type={CodeableConceptDt.class}, order=1, min=0, max=-1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Collection of specialties handled by the service site. This is more of a medical term")
        private List<CodeableConceptDt> mySpecialty;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myType, this.mySpecialty});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.mySpecialty});
        }

        public CodeableConceptDt getType() {
            if (this.myType == null) {
                this.myType = new CodeableConceptDt();
            }
            return this.myType;
        }

        public ServiceType setType(CodeableConceptDt theValue) {
            this.myType = theValue;
            return this;
        }

        public List<CodeableConceptDt> getSpecialty() {
            if (this.mySpecialty == null) {
                this.mySpecialty = new ArrayList<CodeableConceptDt>();
            }
            return this.mySpecialty;
        }

        public ServiceType setSpecialty(List<CodeableConceptDt> theValue) {
            this.mySpecialty = theValue;
            return this;
        }

        public CodeableConceptDt addSpecialty() {
            CodeableConceptDt newType = new CodeableConceptDt();
            this.getSpecialty().add(newType);
            return newType;
        }

        public ServiceType addSpecialty(CodeableConceptDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getSpecialty().add(theValue);
            return this;
        }

        public CodeableConceptDt getSpecialtyFirstRep() {
            if (this.getSpecialty().isEmpty()) {
                return this.addSpecialty();
            }
            return this.getSpecialty().get(0);
        }
    }
}

