/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodingDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="ProcessResponse", profile="http://hl7.org/fhir/profiles/ProcessResponse", id="processresponse")
public class ProcessResponse
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="identifier", path="ProcessResponse.identifier", description="The business identifier of the Explanation of Benefit", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="request", path="ProcessResponse.request", description="The reference to the claim", type="reference")
    public static final String SP_REQUEST = "request";
    public static final ReferenceClientParam REQUEST = new ReferenceClientParam("request");
    @SearchParamDefinition(name="organization", path="ProcessResponse.organization", description="The organization who generated this resource", type="reference")
    public static final String SP_ORGANIZATION = "organization";
    public static final ReferenceClientParam ORGANIZATION = new ReferenceClientParam("organization");
    @SearchParamDefinition(name="requestprovider", path="ProcessResponse.requestProvider", description="The Provider who is responsible the request transaction", type="reference", providesMembershipIn={@Compartment(name="Patient")})
    public static final String SP_REQUESTPROVIDER = "requestprovider";
    public static final ReferenceClientParam REQUESTPROVIDER = new ReferenceClientParam("requestprovider");
    @SearchParamDefinition(name="requestorganization", path="ProcessResponse.requestOrganization", description="The Organization who is responsible the request transaction", type="reference")
    public static final String SP_REQUESTORGANIZATION = "requestorganization";
    public static final ReferenceClientParam REQUESTORGANIZATION = new ReferenceClientParam("requestorganization");
    public static final Include INCLUDE_ORGANIZATION = new Include("ProcessResponse:organization");
    public static final Include INCLUDE_REQUEST = new Include("ProcessResponse:request");
    public static final Include INCLUDE_REQUESTORGANIZATION = new Include("ProcessResponse:requestorganization");
    public static final Include INCLUDE_REQUESTPROVIDER = new Include("ProcessResponse:requestprovider");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The Response business identifier")
    private List<IdentifierDt> myIdentifier;
    @Child(name="request", order=1, min=0, max=1, summary=false, modifier=false, type={IResource.class})
    @Description(shortDefinition="", formalDefinition="Original request resource reference")
    private ResourceReferenceDt myRequest;
    @Child(name="outcome", type={CodingDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Transaction status: error, complete, held.")
    private CodingDt myOutcome;
    @Child(name="disposition", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A description of the status of the adjudication or processing.")
    private StringDt myDisposition;
    @Child(name="ruleset", type={CodingDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The version of the style of resource contents. This should be mapped to the allowable profiles for this and supporting resources.")
    private CodingDt myRuleset;
    @Child(name="originalRuleset", type={CodingDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The style (standard) and version of the original material which was converted into this resource.")
    private CodingDt myOriginalRuleset;
    @Child(name="created", type={DateTimeDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The date when the enclosed suite of services were performed or completed")
    private DateTimeDt myCreated;
    @Child(name="organization", order=7, min=0, max=1, summary=false, modifier=false, type={Organization.class})
    @Description(shortDefinition="", formalDefinition="The organization who produced this adjudicated response.")
    private ResourceReferenceDt myOrganization;
    @Child(name="requestProvider", order=8, min=0, max=1, summary=false, modifier=false, type={Practitioner.class})
    @Description(shortDefinition="", formalDefinition="The practitioner who is responsible for the services rendered to the patient.")
    private ResourceReferenceDt myRequestProvider;
    @Child(name="requestOrganization", order=9, min=0, max=1, summary=false, modifier=false, type={Organization.class})
    @Description(shortDefinition="", formalDefinition="The organization which is responsible for the services rendered to the patient.")
    private ResourceReferenceDt myRequestOrganization;
    @Child(name="form", type={CodingDt.class}, order=10, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The form to be used for printing the content.")
    private CodingDt myForm;
    @Child(name="notes", order=11, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Suite of processing note or additional requirements is the processing has been held.")
    private List<Notes> myNotes;
    @Child(name="error", type={CodingDt.class}, order=12, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Processing errors.")
    private List<CodingDt> myError;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myRequest, this.myOutcome, this.myDisposition, this.myRuleset, this.myOriginalRuleset, this.myCreated, this.myOrganization, this.myRequestProvider, this.myRequestOrganization, this.myForm, this.myNotes, this.myError});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myRequest, this.myOutcome, this.myDisposition, this.myRuleset, this.myOriginalRuleset, this.myCreated, this.myOrganization, this.myRequestProvider, this.myRequestOrganization, this.myForm, this.myNotes, this.myError});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public ProcessResponse setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public ProcessResponse addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public ResourceReferenceDt getRequest() {
        if (this.myRequest == null) {
            this.myRequest = new ResourceReferenceDt();
        }
        return this.myRequest;
    }

    public ProcessResponse setRequest(ResourceReferenceDt theValue) {
        this.myRequest = theValue;
        return this;
    }

    public CodingDt getOutcome() {
        if (this.myOutcome == null) {
            this.myOutcome = new CodingDt();
        }
        return this.myOutcome;
    }

    public ProcessResponse setOutcome(CodingDt theValue) {
        this.myOutcome = theValue;
        return this;
    }

    public StringDt getDispositionElement() {
        if (this.myDisposition == null) {
            this.myDisposition = new StringDt();
        }
        return this.myDisposition;
    }

    public String getDisposition() {
        return (String)this.getDispositionElement().getValue();
    }

    public ProcessResponse setDisposition(StringDt theValue) {
        this.myDisposition = theValue;
        return this;
    }

    public ProcessResponse setDisposition(String theString) {
        this.myDisposition = new StringDt(theString);
        return this;
    }

    public CodingDt getRuleset() {
        if (this.myRuleset == null) {
            this.myRuleset = new CodingDt();
        }
        return this.myRuleset;
    }

    public ProcessResponse setRuleset(CodingDt theValue) {
        this.myRuleset = theValue;
        return this;
    }

    public CodingDt getOriginalRuleset() {
        if (this.myOriginalRuleset == null) {
            this.myOriginalRuleset = new CodingDt();
        }
        return this.myOriginalRuleset;
    }

    public ProcessResponse setOriginalRuleset(CodingDt theValue) {
        this.myOriginalRuleset = theValue;
        return this;
    }

    public DateTimeDt getCreatedElement() {
        if (this.myCreated == null) {
            this.myCreated = new DateTimeDt();
        }
        return this.myCreated;
    }

    public Date getCreated() {
        return (Date)this.getCreatedElement().getValue();
    }

    public ProcessResponse setCreated(DateTimeDt theValue) {
        this.myCreated = theValue;
        return this;
    }

    public ProcessResponse setCreatedWithSecondsPrecision(Date theDate) {
        this.myCreated = new DateTimeDt(theDate);
        return this;
    }

    public ProcessResponse setCreated(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myCreated = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public ResourceReferenceDt getOrganization() {
        if (this.myOrganization == null) {
            this.myOrganization = new ResourceReferenceDt();
        }
        return this.myOrganization;
    }

    public ProcessResponse setOrganization(ResourceReferenceDt theValue) {
        this.myOrganization = theValue;
        return this;
    }

    public ResourceReferenceDt getRequestProvider() {
        if (this.myRequestProvider == null) {
            this.myRequestProvider = new ResourceReferenceDt();
        }
        return this.myRequestProvider;
    }

    public ProcessResponse setRequestProvider(ResourceReferenceDt theValue) {
        this.myRequestProvider = theValue;
        return this;
    }

    public ResourceReferenceDt getRequestOrganization() {
        if (this.myRequestOrganization == null) {
            this.myRequestOrganization = new ResourceReferenceDt();
        }
        return this.myRequestOrganization;
    }

    public ProcessResponse setRequestOrganization(ResourceReferenceDt theValue) {
        this.myRequestOrganization = theValue;
        return this;
    }

    public CodingDt getForm() {
        if (this.myForm == null) {
            this.myForm = new CodingDt();
        }
        return this.myForm;
    }

    public ProcessResponse setForm(CodingDt theValue) {
        this.myForm = theValue;
        return this;
    }

    public List<Notes> getNotes() {
        if (this.myNotes == null) {
            this.myNotes = new ArrayList<Notes>();
        }
        return this.myNotes;
    }

    public ProcessResponse setNotes(List<Notes> theValue) {
        this.myNotes = theValue;
        return this;
    }

    public Notes addNotes() {
        Notes newType = new Notes();
        this.getNotes().add(newType);
        return newType;
    }

    public ProcessResponse addNotes(Notes theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getNotes().add(theValue);
        return this;
    }

    public Notes getNotesFirstRep() {
        if (this.getNotes().isEmpty()) {
            return this.addNotes();
        }
        return this.getNotes().get(0);
    }

    public List<CodingDt> getError() {
        if (this.myError == null) {
            this.myError = new ArrayList<CodingDt>();
        }
        return this.myError;
    }

    public ProcessResponse setError(List<CodingDt> theValue) {
        this.myError = theValue;
        return this;
    }

    public CodingDt addError() {
        CodingDt newType = new CodingDt();
        this.getError().add(newType);
        return newType;
    }

    public ProcessResponse addError(CodingDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getError().add(theValue);
        return this;
    }

    public CodingDt getErrorFirstRep() {
        if (this.getError().isEmpty()) {
            return this.addError();
        }
        return this.getError().get(0);
    }

    public String getResourceName() {
        return "ProcessResponse";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Notes
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="type", type={CodingDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The note purpose: Print/Display.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/note-type")
        private CodingDt myType;
        @Child(name="text", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The note text.")
        private StringDt myText;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myType, this.myText});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.myText});
        }

        public CodingDt getType() {
            if (this.myType == null) {
                this.myType = new CodingDt();
            }
            return this.myType;
        }

        public Notes setType(CodingDt theValue) {
            this.myType = theValue;
            return this;
        }

        public StringDt getTextElement() {
            if (this.myText == null) {
                this.myText = new StringDt();
            }
            return this.myText;
        }

        public String getText() {
            return (String)this.getTextElement().getValue();
        }

        public Notes setText(StringDt theValue) {
            this.myText = theValue;
            return this;
        }

        public Notes setText(String theString) {
            this.myText = new StringDt(theString);
            return this;
        }
    }
}

