/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.provider.dstu2;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.Bundle;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.base.composite.BaseResourceReferenceDt;
import ca.uhn.fhir.model.base.resource.BaseOperationOutcome;
import ca.uhn.fhir.model.dstu2.resource.Bundle;
import ca.uhn.fhir.model.dstu2.valueset.HTTPVerbEnum;
import ca.uhn.fhir.model.dstu2.valueset.SearchEntryModeEnum;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.model.valueset.BundleEntrySearchModeEnum;
import ca.uhn.fhir.model.valueset.BundleEntryTransactionMethodEnum;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.server.BundleInclusionRule;
import ca.uhn.fhir.rest.server.EncodingEnum;
import ca.uhn.fhir.rest.server.IBundleProvider;
import ca.uhn.fhir.rest.server.IPagingProvider;
import ca.uhn.fhir.rest.server.IRestfulServer;
import ca.uhn.fhir.rest.server.IVersionSpecificBundleFactory;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.ResourceReferenceInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class Dstu2BundleFactory
implements IVersionSpecificBundleFactory {
    private ca.uhn.fhir.model.dstu2.resource.Bundle myBundle;
    private FhirContext myContext;
    private String myBase;

    public Dstu2BundleFactory(FhirContext theContext) {
        this.myContext = theContext;
    }

    private void addResourcesForSearch(List<? extends IBaseResource> theResult) {
        ArrayList includedResources = new ArrayList();
        HashSet<Object> addedResourceIds = new HashSet<Object>();
        for (IBaseResource iBaseResource : theResult) {
            if (iBaseResource.getIdElement().isEmpty()) continue;
            addedResourceIds.add(iBaseResource.getIdElement());
        }
        for (IBaseResource iBaseResource : theResult) {
            BundleEntryTransactionMethodEnum httpVerb;
            IResource next = (IResource)iBaseResource;
            HashSet<String> containedIds = new HashSet<String>();
            for (IResource nextContained : next.getContained().getContainedResources()) {
                if (nextContained.getId().isEmpty()) continue;
                containedIds.add(nextContained.getId().getValue());
            }
            ArrayList references = this.myContext.newTerser().getAllPopulatedChildElementsOfType((IBaseResource)next, BaseResourceReferenceDt.class);
            do {
                ArrayList<IResource> addedResourcesThisPass = new ArrayList<IResource>();
                for (BaseResourceReferenceDt nextRef : references) {
                    IResource nextRes = (IResource)nextRef.getResource();
                    if (nextRes == null || !nextRes.getId().hasIdPart() || containedIds.contains(nextRes.getId().getValue())) continue;
                    IdDt id = nextRes.getId();
                    if (!id.hasResourceType()) {
                        String resName = this.myContext.getResourceDefinition((IBaseResource)nextRes).getName();
                        id = id.withResourceType(resName);
                    }
                    if (addedResourceIds.contains(id)) continue;
                    addedResourceIds.add(id);
                    addedResourcesThisPass.add(nextRes);
                }
                references = new ArrayList();
                for (IResource iResource : addedResourcesThisPass) {
                    List newReferences = this.myContext.newTerser().getAllPopulatedChildElementsOfType((IBaseResource)iResource, BaseResourceReferenceDt.class);
                    references.addAll(newReferences);
                }
                includedResources.addAll(addedResourcesThisPass);
            } while (!references.isEmpty());
            Bundle.Entry entry = this.myBundle.addEntry().setResource(next);
            if (next.getId().hasBaseUrl()) {
                entry.setFullUrl(next.getId().getValue());
            }
            if ((httpVerb = (BundleEntryTransactionMethodEnum)ResourceMetadataKeyEnum.ENTRY_TRANSACTION_METHOD.get(next)) == null) continue;
            entry.getRequest().getMethodElement().setValueAsString(httpVerb.getCode());
        }
        for (IBaseResource iBaseResource : includedResources) {
            Bundle.Entry entry = this.myBundle.addEntry();
            entry.setResource((IResource)iBaseResource).getSearch().setMode(SearchEntryModeEnum.INCLUDE);
            if (!iBaseResource.getIdElement().hasBaseUrl()) continue;
            entry.setFullUrl(iBaseResource.getIdElement().getValue());
        }
    }

    public void addResourcesToBundle(List<IBaseResource> theResult, BundleTypeEnum theBundleType, String theServerBase, BundleInclusionRule theBundleInclusionRule, Set<Include> theIncludes) {
        if (this.myBundle == null) {
            this.myBundle = new ca.uhn.fhir.model.dstu2.resource.Bundle();
        }
        ArrayList includedResources = new ArrayList();
        HashSet<IdDt> addedResourceIds = new HashSet<IdDt>();
        for (IBaseResource next : theResult) {
            if (next.getIdElement().isEmpty()) continue;
            addedResourceIds.add((IdDt)next.getIdElement());
        }
        for (IBaseResource nextBaseRes : theResult) {
            IResource next = (IResource)nextBaseRes;
            HashSet<String> containedIds = new HashSet<String>();
            for (IResource nextContained : next.getContained().getContainedResources()) {
                if (nextContained.getId().isEmpty()) continue;
                containedIds.add(nextContained.getId().getValue());
            }
            ArrayList references = this.myContext.newTerser().getAllResourceReferences((IBaseResource)next);
            do {
                ArrayList<IResource> addedResourcesThisPass = new ArrayList<IResource>();
                for (ResourceReferenceInfo nextRefInfo : references) {
                    IResource nextRes;
                    if (!theBundleInclusionRule.shouldIncludeReferencedResource(nextRefInfo, theIncludes) || (nextRes = (IResource)nextRefInfo.getResourceReference().getResource()) == null || !nextRes.getId().hasIdPart() || containedIds.contains(nextRes.getId().getValue())) continue;
                    IdDt id = nextRes.getId();
                    if (!id.hasResourceType()) {
                        String resName = this.myContext.getResourceDefinition((IBaseResource)nextRes).getName();
                        id = id.withResourceType(resName);
                    }
                    if (addedResourceIds.contains(id)) continue;
                    addedResourceIds.add(id);
                    addedResourcesThisPass.add(nextRes);
                }
                includedResources.addAll(addedResourcesThisPass);
                references = new ArrayList();
                for (IResource iResource : addedResourcesThisPass) {
                    List newReferences = this.myContext.newTerser().getAllResourceReferences((IBaseResource)iResource);
                    references.addAll(newReferences);
                }
            } while (!references.isEmpty());
            Bundle.Entry entry = this.myBundle.addEntry().setResource(next);
            BundleEntryTransactionMethodEnum httpVerb = (BundleEntryTransactionMethodEnum)ResourceMetadataKeyEnum.ENTRY_TRANSACTION_METHOD.get(next);
            if (httpVerb != null) {
                entry.getRequest().getMethodElement().setValueAsString(httpVerb.getCode());
            }
            this.populateBundleEntryFullUrl(next, entry);
            BundleEntrySearchModeEnum searchMode = (BundleEntrySearchModeEnum)ResourceMetadataKeyEnum.ENTRY_SEARCH_MODE.get(next);
            if (searchMode == null) continue;
            entry.getSearch().getModeElement().setValue((Object)searchMode.getCode());
        }
        for (IBaseResource next : includedResources) {
            Bundle.Entry entry = this.myBundle.addEntry();
            entry.setResource((IResource)next).getSearch().setMode(SearchEntryModeEnum.INCLUDE);
            this.populateBundleEntryFullUrl((IResource)next, entry);
        }
    }

    private void populateBundleEntryFullUrl(IResource next, Bundle.Entry entry) {
        if (next.getId().hasBaseUrl()) {
            entry.setFullUrl(next.getId().toVersionless().getValue());
        } else if (StringUtils.isNotBlank((CharSequence)this.myBase) && next.getId().hasIdPart()) {
            IdDt id = next.getId().toVersionless();
            id = id.withServerBase(this.myBase, this.myContext.getResourceDefinition((IBaseResource)next).getName());
            entry.setFullUrl(id.getValue());
        }
    }

    public void addRootPropertiesToBundle(String theAuthor, String theServerBase, String theCompleteUrl, Integer theTotalResults, BundleTypeEnum theBundleType, IPrimitiveType<Date> theLastUpdated) {
        this.myBase = theServerBase;
        if (this.myBundle.getId().isEmpty()) {
            this.myBundle.setId(UUID.randomUUID().toString());
        }
        if (ResourceMetadataKeyEnum.UPDATED.get((IResource)this.myBundle) == null) {
            ResourceMetadataKeyEnum.UPDATED.put((IResource)this.myBundle, (Object)((InstantDt)theLastUpdated));
        }
        if (!this.hasLink("self", this.myBundle) && StringUtils.isNotBlank((CharSequence)theCompleteUrl)) {
            this.myBundle.addLink().setRelation("self").setUrl(theCompleteUrl);
        }
        if (this.myBundle.getTypeElement().isEmpty() && theBundleType != null) {
            this.myBundle.getTypeElement().setValueAsString(theBundleType.getCode());
        }
        if (this.myBundle.getTotalElement().isEmpty() && theTotalResults != null) {
            this.myBundle.getTotalElement().setValue((Object)theTotalResults);
        }
    }

    public Bundle getDstu1Bundle() {
        return null;
    }

    public IResource getResourceBundle() {
        return this.myBundle;
    }

    private boolean hasLink(String theLinkType, ca.uhn.fhir.model.dstu2.resource.Bundle theBundle) {
        for (Bundle.Link next : theBundle.getLink()) {
            if (!theLinkType.equals(next.getRelation())) continue;
            return true;
        }
        return false;
    }

    public void initializeBundleFromBundleProvider(IRestfulServer<?> theServer, IBundleProvider theResult, EncodingEnum theResponseEncoding, String theServerBase, String theCompleteUrl, boolean thePrettyPrint, int theOffset, Integer theLimit, String theSearchId, BundleTypeEnum theBundleType, Set<Include> theIncludes) {
        List resourceList;
        int numToReturn;
        this.myBase = theServerBase;
        String searchId = null;
        Integer numTotalResults = theResult.size();
        if (theServer.getPagingProvider() == null) {
            numToReturn = numTotalResults;
            resourceList = numToReturn > 0 ? theResult.getResources(0, numToReturn) : Collections.emptyList();
            RestfulServerUtils.validateResourceListNotNull(resourceList);
        } else {
            IPagingProvider pagingProvider = theServer.getPagingProvider();
            numToReturn = theLimit == null || theLimit.equals(0) ? pagingProvider.getDefaultPageSize() : Math.min(pagingProvider.getMaximumPageSize(), theLimit);
            if (numTotalResults != null) {
                numToReturn = Math.min(numToReturn, numTotalResults - theOffset);
            }
            resourceList = numToReturn > 0 ? theResult.getResources(theOffset, numToReturn + theOffset) : Collections.emptyList();
            RestfulServerUtils.validateResourceListNotNull(resourceList);
            if (theSearchId != null) {
                searchId = theSearchId;
            } else if (numTotalResults == null || numTotalResults > numToReturn) {
                searchId = pagingProvider.storeResultList(theResult);
                Validate.notNull((Object)searchId, (String)"Paging provider returned null searchId", (Object[])new Object[0]);
            }
        }
        for (IBaseResource next : resourceList) {
            if (next.getIdElement() != null && !next.getIdElement().isEmpty() || next instanceof BaseOperationOutcome) continue;
            throw new InternalErrorException("Server method returned resource of type[" + next.getClass().getSimpleName() + "] with no ID specified (IResource#setId(IdDt) must be called)");
        }
        this.addResourcesToBundle(new ArrayList<IBaseResource>(resourceList), theBundleType, theServerBase, theServer.getBundleInclusionRule(), theIncludes);
        this.addRootPropertiesToBundle(null, theServerBase, theCompleteUrl, numTotalResults, theBundleType, (IPrimitiveType<Date>)theResult.getPublished());
        if (theServer.getPagingProvider() != null) {
            int limit = theLimit != null ? theLimit.intValue() : theServer.getPagingProvider().getDefaultPageSize();
            limit = Math.min(limit, theServer.getPagingProvider().getMaximumPageSize());
            if (searchId != null) {
                if (numTotalResults == null || theOffset + numToReturn < numTotalResults) {
                    this.myBundle.addLink().setRelation("next").setUrl(RestfulServerUtils.createPagingLink(theIncludes, (String)theServerBase, (String)searchId, (int)(theOffset + numToReturn), (int)numToReturn, (EncodingEnum)theResponseEncoding, (boolean)thePrettyPrint, (BundleTypeEnum)theBundleType));
                }
                if (theOffset > 0) {
                    int start = Math.max(0, theOffset - limit);
                    this.myBundle.addLink().setRelation("previous").setUrl(RestfulServerUtils.createPagingLink(theIncludes, (String)theServerBase, (String)searchId, (int)start, (int)limit, (EncodingEnum)theResponseEncoding, (boolean)thePrettyPrint, (BundleTypeEnum)theBundleType));
                }
            }
        }
    }

    public void initializeBundleFromResourceList(String theAuthor, List<? extends IBaseResource> theResources, String theServerBase, String theCompleteUrl, int theTotalResults, BundleTypeEnum theBundleType) {
        this.myBundle = new ca.uhn.fhir.model.dstu2.resource.Bundle();
        this.myBundle.setId(UUID.randomUUID().toString());
        ResourceMetadataKeyEnum.PUBLISHED.put((IResource)this.myBundle, (Object)InstantDt.withCurrentTime());
        this.myBundle.addLink().setRelation("fhir-base").setUrl(theServerBase);
        this.myBundle.addLink().setRelation("self").setUrl(theCompleteUrl);
        this.myBundle.getTypeElement().setValueAsString(theBundleType.getCode());
        if (theBundleType.equals((Object)BundleTypeEnum.TRANSACTION)) {
            for (IBaseResource iBaseResource : theResources) {
                IResource next = (IResource)iBaseResource;
                Bundle.Entry nextEntry = this.myBundle.addEntry();
                nextEntry.setResource(next);
                if (next.getId().isEmpty()) {
                    nextEntry.getRequest().setMethod(HTTPVerbEnum.POST);
                    continue;
                }
                nextEntry.getRequest().setMethod(HTTPVerbEnum.PUT);
                if (next.getId().isAbsolute()) {
                    nextEntry.getRequest().setUrl((UriDt)next.getId());
                    continue;
                }
                String resourceType = this.myContext.getResourceDefinition((IBaseResource)next).getName();
                nextEntry.getRequest().setUrl(new IdDt(theServerBase, resourceType, next.getId().getIdPart(), next.getId().getVersionIdPart()).getValue());
            }
        } else {
            this.addResourcesForSearch(theResources);
        }
        this.myBundle.getTotalElement().setValue((Object)theTotalResults);
    }

    public void initializeWithBundleResource(IBaseResource theBundle) {
        this.myBundle = (ca.uhn.fhir.model.dstu2.resource.Bundle)theBundle;
    }

    public List<IBaseResource> toListOfResources() {
        ArrayList<IBaseResource> retVal = new ArrayList<IBaseResource>();
        for (Bundle.Entry next : this.myBundle.getEntry()) {
            IdDt id;
            String resourceType;
            if (next.getResource() != null) {
                retVal.add((IBaseResource)next.getResource());
                continue;
            }
            if (next.getResponse().getLocationElement().isEmpty() || !StringUtils.isNotBlank((CharSequence)(resourceType = (id = new IdDt(next.getResponse().getLocation())).getResourceType()))) continue;
            IResource res = (IResource)this.myContext.getResourceDefinition(resourceType).newInstance();
            res.setId(id);
            retVal.add((IBaseResource)res);
        }
        return retVal;
    }
}

