/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.AgeDt;
import ca.uhn.fhir.model.dstu2.composite.BoundCodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.PeriodDt;
import ca.uhn.fhir.model.dstu2.composite.RangeDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.ClinicalImpression;
import ca.uhn.fhir.model.dstu2.resource.DiagnosticReport;
import ca.uhn.fhir.model.dstu2.resource.Encounter;
import ca.uhn.fhir.model.dstu2.resource.Observation;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.valueset.ConditionCategoryCodesEnum;
import ca.uhn.fhir.model.dstu2.valueset.ConditionClinicalStatusCodesEnum;
import ca.uhn.fhir.model.dstu2.valueset.ConditionVerificationStatusEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Condition", profile="http://hl7.org/fhir/profiles/Condition", id="condition")
public class Condition
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="code", path="Condition.code", description="Code for the condition", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="identifier", path="Condition.identifier", description="A unique identifier of the condition record", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="clinicalstatus", path="Condition.clinicalStatus", description="The clinical status of the condition", type="token")
    public static final String SP_CLINICALSTATUS = "clinicalstatus";
    public static final TokenClientParam CLINICALSTATUS = new TokenClientParam("clinicalstatus");
    @SearchParamDefinition(name="severity", path="Condition.severity", description="The severity of the condition", type="token")
    public static final String SP_SEVERITY = "severity";
    public static final TokenClientParam SEVERITY = new TokenClientParam("severity");
    @SearchParamDefinition(name="category", path="Condition.category", description="The category of the condition", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="onset", path="Condition.onset[x]", description="Date related onsets (dateTime and Period)", type="date")
    public static final String SP_ONSET = "onset";
    public static final DateClientParam ONSET = new DateClientParam("onset");
    @SearchParamDefinition(name="onset-info", path="Condition.onset[x]", description="Other onsets (boolean, age, range, string)", type="string")
    public static final String SP_ONSET_INFO = "onset-info";
    public static final StringClientParam ONSET_INFO = new StringClientParam("onset-info");
    @SearchParamDefinition(name="encounter", path="Condition.encounter", description="", type="reference", providesMembershipIn={@Compartment(name="Encounter")})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    @SearchParamDefinition(name="asserter", path="Condition.asserter", description="", type="reference", providesMembershipIn={@Compartment(name="RelatedPerson")})
    public static final String SP_ASSERTER = "asserter";
    public static final ReferenceClientParam ASSERTER = new ReferenceClientParam("asserter");
    @SearchParamDefinition(name="date-recorded", path="Condition.dateRecorded", description="A date, when the Condition statement was documented", type="date")
    public static final String SP_DATE_RECORDED = "date-recorded";
    public static final DateClientParam DATE_RECORDED = new DateClientParam("date-recorded");
    @SearchParamDefinition(name="evidence", path="Condition.evidence.code", description="", type="token")
    public static final String SP_EVIDENCE = "evidence";
    public static final TokenClientParam EVIDENCE = new TokenClientParam("evidence");
    @SearchParamDefinition(name="body-site", path="Condition.bodySite", description="", type="token")
    public static final String SP_BODY_SITE = "body-site";
    public static final TokenClientParam BODY_SITE = new TokenClientParam("body-site");
    @SearchParamDefinition(name="stage", path="Condition.stage.summary", description="", type="token")
    public static final String SP_STAGE = "stage";
    public static final TokenClientParam STAGE = new TokenClientParam("stage");
    @SearchParamDefinition(name="patient", path="Condition.patient", description="", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_ASSERTER = new Include("Condition:asserter");
    public static final Include INCLUDE_ENCOUNTER = new Include("Condition:encounter");
    public static final Include INCLUDE_PATIENT = new Include("Condition:patient");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="This records identifiers associated with this condition that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation)")
    private List<IdentifierDt> myIdentifier;
    @Child(name="patient", order=1, min=1, max=1, summary=false, modifier=false, type={Patient.class})
    @Description(shortDefinition="", formalDefinition="Indicates the patient who the condition record is associated with")
    private ResourceReferenceDt myPatient;
    @Child(name="encounter", order=2, min=0, max=1, summary=false, modifier=false, type={Encounter.class})
    @Description(shortDefinition="", formalDefinition="Encounter during which the condition was first asserted")
    private ResourceReferenceDt myEncounter;
    @Child(name="asserter", order=3, min=0, max=1, summary=false, modifier=false, type={Practitioner.class, Patient.class})
    @Description(shortDefinition="", formalDefinition="Individual who is making the condition statement")
    private ResourceReferenceDt myAsserter;
    @Child(name="dateRecorded", type={DateDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A date, when  the Condition statement was documented")
    private DateDt myDateRecorded;
    @Child(name="code", type={CodeableConceptDt.class}, order=5, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Identification of the condition, problem or diagnosis.")
    private CodeableConceptDt myCode;
    @Child(name="category", type={CodeableConceptDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A category assigned to the condition.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/valueset-condition-category")
    private BoundCodeableConceptDt<ConditionCategoryCodesEnum> myCategory;
    @Child(name="clinicalStatus", type={CodeDt.class}, order=7, min=0, max=1, summary=false, modifier=true)
    @Description(shortDefinition="", formalDefinition="The clinical status of the condition.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/valueset-condition-clinical")
    private BoundCodeDt<ConditionClinicalStatusCodesEnum> myClinicalStatus;
    @Child(name="verificationStatus", type={CodeDt.class}, order=8, min=1, max=1, summary=false, modifier=true)
    @Description(shortDefinition="", formalDefinition="The verification status to support the clinical status of the condition.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-ver-status")
    private BoundCodeDt<ConditionVerificationStatusEnum> myVerificationStatus;
    @Child(name="severity", type={CodeableConceptDt.class}, order=9, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A subjective assessment of the severity of the condition as evaluated by the clinician.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/valueset-condition-severity")
    private CodeableConceptDt mySeverity;
    @Child(name="onset", order=10, min=0, max=1, summary=false, modifier=false, type={DateTimeDt.class, AgeDt.class, PeriodDt.class, RangeDt.class, StringDt.class})
    @Description(shortDefinition="", formalDefinition="Estimated or actual date or date-time  the condition began, in the opinion of the clinician")
    private IDatatype myOnset;
    @Child(name="abatement", order=11, min=0, max=1, summary=false, modifier=false, type={DateTimeDt.class, AgeDt.class, BooleanDt.class, PeriodDt.class, RangeDt.class, StringDt.class})
    @Description(shortDefinition="", formalDefinition="The date or estimated date that the condition resolved or went into remission. This is called \"abatement\" because of the many overloaded connotations associated with \"remission\" or \"resolution\" - Conditions are never really resolved, but they can abate.")
    private IDatatype myAbatement;
    @Child(name="stage", order=12, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Clinical stage or grade of a condition. May include formal severity assessments")
    private Stage myStage;
    @Child(name="evidence", order=13, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Supporting Evidence / manifestations that are the basis on which this condition is suspected or confirmed")
    private List<Evidence> myEvidence;
    @Child(name="bodySite", type={CodeableConceptDt.class}, order=14, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The anatomical location where this condition manifests itself")
    private List<CodeableConceptDt> myBodySite;
    @Child(name="notes", type={StringDt.class}, order=15, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Additional information about the Condition. This is a general notes/comments entry  for description of the Condition, its diagnosis and prognosis")
    private StringDt myNotes;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myPatient, this.myEncounter, this.myAsserter, this.myDateRecorded, this.myCode, this.myCategory, this.myClinicalStatus, this.myVerificationStatus, this.mySeverity, this.myOnset, this.myAbatement, this.myStage, this.myEvidence, this.myBodySite, this.myNotes});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myPatient, this.myEncounter, this.myAsserter, this.myDateRecorded, this.myCode, this.myCategory, this.myClinicalStatus, this.myVerificationStatus, this.mySeverity, this.myOnset, this.myAbatement, this.myStage, this.myEvidence, this.myBodySite, this.myNotes});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Condition setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public Condition addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public ResourceReferenceDt getPatient() {
        if (this.myPatient == null) {
            this.myPatient = new ResourceReferenceDt();
        }
        return this.myPatient;
    }

    public Condition setPatient(ResourceReferenceDt theValue) {
        this.myPatient = theValue;
        return this;
    }

    public ResourceReferenceDt getEncounter() {
        if (this.myEncounter == null) {
            this.myEncounter = new ResourceReferenceDt();
        }
        return this.myEncounter;
    }

    public Condition setEncounter(ResourceReferenceDt theValue) {
        this.myEncounter = theValue;
        return this;
    }

    public ResourceReferenceDt getAsserter() {
        if (this.myAsserter == null) {
            this.myAsserter = new ResourceReferenceDt();
        }
        return this.myAsserter;
    }

    public Condition setAsserter(ResourceReferenceDt theValue) {
        this.myAsserter = theValue;
        return this;
    }

    public DateDt getDateRecordedElement() {
        if (this.myDateRecorded == null) {
            this.myDateRecorded = new DateDt();
        }
        return this.myDateRecorded;
    }

    public Date getDateRecorded() {
        return (Date)this.getDateRecordedElement().getValue();
    }

    public Condition setDateRecorded(DateDt theValue) {
        this.myDateRecorded = theValue;
        return this;
    }

    public Condition setDateRecorded(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDateRecorded = new DateDt(theDate, thePrecision);
        return this;
    }

    public Condition setDateRecordedWithDayPrecision(Date theDate) {
        this.myDateRecorded = new DateDt(theDate);
        return this;
    }

    public CodeableConceptDt getCode() {
        if (this.myCode == null) {
            this.myCode = new CodeableConceptDt();
        }
        return this.myCode;
    }

    public Condition setCode(CodeableConceptDt theValue) {
        this.myCode = theValue;
        return this;
    }

    public BoundCodeableConceptDt<ConditionCategoryCodesEnum> getCategory() {
        if (this.myCategory == null) {
            this.myCategory = new BoundCodeableConceptDt<ConditionCategoryCodesEnum>(ConditionCategoryCodesEnum.VALUESET_BINDER);
        }
        return this.myCategory;
    }

    public Condition setCategory(BoundCodeableConceptDt<ConditionCategoryCodesEnum> theValue) {
        this.myCategory = theValue;
        return this;
    }

    public Condition setCategory(ConditionCategoryCodesEnum theValue) {
        this.setCategory(new BoundCodeableConceptDt<ConditionCategoryCodesEnum>(ConditionCategoryCodesEnum.VALUESET_BINDER, theValue));
        return this;
    }

    public BoundCodeDt<ConditionClinicalStatusCodesEnum> getClinicalStatusElement() {
        if (this.myClinicalStatus == null) {
            this.myClinicalStatus = new BoundCodeDt(ConditionClinicalStatusCodesEnum.VALUESET_BINDER);
        }
        return this.myClinicalStatus;
    }

    public String getClinicalStatus() {
        return (String)this.getClinicalStatusElement().getValue();
    }

    public Condition setClinicalStatus(BoundCodeDt<ConditionClinicalStatusCodesEnum> theValue) {
        this.myClinicalStatus = theValue;
        return this;
    }

    public Condition setClinicalStatus(ConditionClinicalStatusCodesEnum theValue) {
        this.setClinicalStatus((BoundCodeDt<ConditionClinicalStatusCodesEnum>)new BoundCodeDt(ConditionClinicalStatusCodesEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public BoundCodeDt<ConditionVerificationStatusEnum> getVerificationStatusElement() {
        if (this.myVerificationStatus == null) {
            this.myVerificationStatus = new BoundCodeDt(ConditionVerificationStatusEnum.VALUESET_BINDER);
        }
        return this.myVerificationStatus;
    }

    public String getVerificationStatus() {
        return (String)this.getVerificationStatusElement().getValue();
    }

    public Condition setVerificationStatus(BoundCodeDt<ConditionVerificationStatusEnum> theValue) {
        this.myVerificationStatus = theValue;
        return this;
    }

    public Condition setVerificationStatus(ConditionVerificationStatusEnum theValue) {
        this.setVerificationStatus((BoundCodeDt<ConditionVerificationStatusEnum>)new BoundCodeDt(ConditionVerificationStatusEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public CodeableConceptDt getSeverity() {
        if (this.mySeverity == null) {
            this.mySeverity = new CodeableConceptDt();
        }
        return this.mySeverity;
    }

    public Condition setSeverity(CodeableConceptDt theValue) {
        this.mySeverity = theValue;
        return this;
    }

    public IDatatype getOnset() {
        return this.myOnset;
    }

    public Condition setOnset(IDatatype theValue) {
        this.myOnset = theValue;
        return this;
    }

    public IDatatype getAbatement() {
        return this.myAbatement;
    }

    public Condition setAbatement(IDatatype theValue) {
        this.myAbatement = theValue;
        return this;
    }

    public Stage getStage() {
        if (this.myStage == null) {
            this.myStage = new Stage();
        }
        return this.myStage;
    }

    public Condition setStage(Stage theValue) {
        this.myStage = theValue;
        return this;
    }

    public List<Evidence> getEvidence() {
        if (this.myEvidence == null) {
            this.myEvidence = new ArrayList<Evidence>();
        }
        return this.myEvidence;
    }

    public Condition setEvidence(List<Evidence> theValue) {
        this.myEvidence = theValue;
        return this;
    }

    public Evidence addEvidence() {
        Evidence newType = new Evidence();
        this.getEvidence().add(newType);
        return newType;
    }

    public Condition addEvidence(Evidence theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getEvidence().add(theValue);
        return this;
    }

    public Evidence getEvidenceFirstRep() {
        if (this.getEvidence().isEmpty()) {
            return this.addEvidence();
        }
        return this.getEvidence().get(0);
    }

    public List<CodeableConceptDt> getBodySite() {
        if (this.myBodySite == null) {
            this.myBodySite = new ArrayList<CodeableConceptDt>();
        }
        return this.myBodySite;
    }

    public Condition setBodySite(List<CodeableConceptDt> theValue) {
        this.myBodySite = theValue;
        return this;
    }

    public CodeableConceptDt addBodySite() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getBodySite().add(newType);
        return newType;
    }

    public Condition addBodySite(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getBodySite().add(theValue);
        return this;
    }

    public CodeableConceptDt getBodySiteFirstRep() {
        if (this.getBodySite().isEmpty()) {
            return this.addBodySite();
        }
        return this.getBodySite().get(0);
    }

    public StringDt getNotesElement() {
        if (this.myNotes == null) {
            this.myNotes = new StringDt();
        }
        return this.myNotes;
    }

    public String getNotes() {
        return (String)this.getNotesElement().getValue();
    }

    public Condition setNotes(StringDt theValue) {
        this.myNotes = theValue;
        return this;
    }

    public Condition setNotes(String theString) {
        this.myNotes = new StringDt(theString);
        return this;
    }

    public String getResourceName() {
        return "Condition";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Evidence
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="code", type={CodeableConceptDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A manifestation or symptom that led to the recording of this condition")
        private CodeableConceptDt myCode;
        @Child(name="detail", order=1, min=0, max=-1, summary=false, modifier=false, type={IResource.class})
        @Description(shortDefinition="", formalDefinition="Links to other relevant information, including pathology reports")
        private List<ResourceReferenceDt> myDetail;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myCode, this.myDetail});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCode, this.myDetail});
        }

        public CodeableConceptDt getCode() {
            if (this.myCode == null) {
                this.myCode = new CodeableConceptDt();
            }
            return this.myCode;
        }

        public Evidence setCode(CodeableConceptDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public List<ResourceReferenceDt> getDetail() {
            if (this.myDetail == null) {
                this.myDetail = new ArrayList<ResourceReferenceDt>();
            }
            return this.myDetail;
        }

        public Evidence setDetail(List<ResourceReferenceDt> theValue) {
            this.myDetail = theValue;
            return this;
        }

        public ResourceReferenceDt addDetail() {
            ResourceReferenceDt newType = new ResourceReferenceDt();
            this.getDetail().add(newType);
            return newType;
        }
    }

    @Block
    public static class Stage
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="summary", type={CodeableConceptDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A simple summary of the stage such as \"Stage 3\". The determination of the stage is disease-specific")
        private CodeableConceptDt mySummary;
        @Child(name="assessment", order=1, min=0, max=-1, summary=false, modifier=false, type={ClinicalImpression.class, DiagnosticReport.class, Observation.class})
        @Description(shortDefinition="", formalDefinition="Reference to a formal record of the evidence on which the staging assessment is based")
        private List<ResourceReferenceDt> myAssessment;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.mySummary, this.myAssessment});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySummary, this.myAssessment});
        }

        public CodeableConceptDt getSummary() {
            if (this.mySummary == null) {
                this.mySummary = new CodeableConceptDt();
            }
            return this.mySummary;
        }

        public Stage setSummary(CodeableConceptDt theValue) {
            this.mySummary = theValue;
            return this;
        }

        public List<ResourceReferenceDt> getAssessment() {
            if (this.myAssessment == null) {
                this.myAssessment = new ArrayList<ResourceReferenceDt>();
            }
            return this.myAssessment;
        }

        public Stage setAssessment(List<ResourceReferenceDt> theValue) {
            this.myAssessment = theValue;
            return this;
        }

        public ResourceReferenceDt addAssessment() {
            ResourceReferenceDt newType = new ResourceReferenceDt();
            this.getAssessment().add(newType);
            return newType;
        }
    }
}

