/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum PaymentTypeCodesEnum {
    PAYMENT("payment", "http://hl7.org/fhir/payment-type"),
    ADJUSTMENT("adjustment", "http://hl7.org/fhir/payment-type"),
    ADVANCE("advance", "http://hl7.org/fhir/payment-type");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "Payment Type Codes";
    private static Map<String, PaymentTypeCodesEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, PaymentTypeCodesEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<PaymentTypeCodesEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static PaymentTypeCodesEnum forCode(String theCode) {
        PaymentTypeCodesEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private PaymentTypeCodesEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, PaymentTypeCodesEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, PaymentTypeCodesEnum>>();
        for (PaymentTypeCodesEnum next : PaymentTypeCodesEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<PaymentTypeCodesEnum>(){

            public String toCodeString(PaymentTypeCodesEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(PaymentTypeCodesEnum theEnum) {
                return theEnum.getSystem();
            }

            public PaymentTypeCodesEnum fromCodeString(String theCodeString) {
                return (PaymentTypeCodesEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public PaymentTypeCodesEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (PaymentTypeCodesEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

