/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum GoalCategoryEnum {
    DIETARY("dietary", "http://hl7.org/fhir/goal-category"),
    SAFETY("safety", "http://hl7.org/fhir/goal-category"),
    BEHAVIORAL("behavioral", "http://hl7.org/fhir/goal-category"),
    NURSING("nursing", "http://hl7.org/fhir/goal-category"),
    PHYSIOTHERAPY("physiotherapy", "http://hl7.org/fhir/goal-category");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "GoalCategory";
    private static Map<String, GoalCategoryEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, GoalCategoryEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<GoalCategoryEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static GoalCategoryEnum forCode(String theCode) {
        GoalCategoryEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private GoalCategoryEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, GoalCategoryEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, GoalCategoryEnum>>();
        for (GoalCategoryEnum next : GoalCategoryEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<GoalCategoryEnum>(){

            public String toCodeString(GoalCategoryEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(GoalCategoryEnum theEnum) {
                return theEnum.getSystem();
            }

            public GoalCategoryEnum fromCodeString(String theCodeString) {
                return (GoalCategoryEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public GoalCategoryEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (GoalCategoryEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

