/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum ExceptionCodesEnum {
    STUDENT_FULLTIME("student", "http://hl7.org/fhir/exception"),
    DISABLED("disabled", "http://hl7.org/fhir/exception");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "Exception Codes";
    private static Map<String, ExceptionCodesEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, ExceptionCodesEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<ExceptionCodesEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static ExceptionCodesEnum forCode(String theCode) {
        ExceptionCodesEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private ExceptionCodesEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, ExceptionCodesEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, ExceptionCodesEnum>>();
        for (ExceptionCodesEnum next : ExceptionCodesEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<ExceptionCodesEnum>(){

            public String toCodeString(ExceptionCodesEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(ExceptionCodesEnum theEnum) {
                return theEnum.getSystem();
            }

            public ExceptionCodesEnum fromCodeString(String theCodeString) {
                return (ExceptionCodesEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public ExceptionCodesEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (ExceptionCodesEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

