/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum ContractTypeCodesEnum {
    PRIVACY("privacy", "http://hl7.org/fhir/contracttypecodes"),
    DISCLOSURE("disclosure", "http://hl7.org/fhir/contracttypecodes");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "Contract Type Codes";
    private static Map<String, ContractTypeCodesEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, ContractTypeCodesEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<ContractTypeCodesEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static ContractTypeCodesEnum forCode(String theCode) {
        ContractTypeCodesEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private ContractTypeCodesEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, ContractTypeCodesEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, ContractTypeCodesEnum>>();
        for (ContractTypeCodesEnum next : ContractTypeCodesEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<ContractTypeCodesEnum>(){

            public String toCodeString(ContractTypeCodesEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(ContractTypeCodesEnum theEnum) {
                return theEnum.getSystem();
            }

            public ContractTypeCodesEnum fromCodeString(String theCodeString) {
                return (ContractTypeCodesEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public ContractTypeCodesEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (ContractTypeCodesEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

