/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum ContractSubtypeCodesEnum {
    DISCLOSURE_CA("disclosure-CA", "http://hl7.org/fhir/contractsubtypecodes"),
    DISCLOSURE_US("disclosure-US", "http://hl7.org/fhir/contractsubtypecodes");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "Contract Subtype Codes";
    private static Map<String, ContractSubtypeCodesEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, ContractSubtypeCodesEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<ContractSubtypeCodesEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static ContractSubtypeCodesEnum forCode(String theCode) {
        ContractSubtypeCodesEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private ContractSubtypeCodesEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, ContractSubtypeCodesEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, ContractSubtypeCodesEnum>>();
        for (ContractSubtypeCodesEnum next : ContractSubtypeCodesEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<ContractSubtypeCodesEnum>(){

            public String toCodeString(ContractSubtypeCodesEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(ContractSubtypeCodesEnum theEnum) {
                return theEnum.getSystem();
            }

            public ContractSubtypeCodesEnum fromCodeString(String theCodeString) {
                return (ContractSubtypeCodesEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public ContractSubtypeCodesEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (ContractSubtypeCodesEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

